#include <amxmodx>
#include <amxmisc>
#include <csx>

#define PLUGIN "Top10"
#define VERSION "1.0"
#define AUTHOR "MUT@NT"

#define MAX_PLAYERS             32 + 1

#define MAX_NAME_LENGTH         31
#define MAX_WEAPON_LENGTH       31
#define MAX_TEXT_LENGTH         255
#define MAX_BUFFER_LENGTH       2047

// User stats parms id
#define STATS_KILLS             0
#define STATS_DEATHS            1
#define STATS_HS                2
#define STATS_TKS               3
#define STATS_SHOTS             4
#define STATS_HITS              5
#define STATS_DAMAGE            6

new g_sBuffer[MAX_BUFFER_LENGTH + 1]                = ""
new t_sName[MAX_NAME_LENGTH + 1]                    = ""

public plugin_init()
{
	// Register plugin.
	register_plugin(PLUGIN, VERSION, AUTHOR)
	register_dictionary("statsx.txt")

	register_clcmd("say /top10", "cmdTop10", 0, "- display top 10 players (MOTD)")
	register_clcmd("say_team /top10", "cmdTop10", 0, "- display top 10 players (MOTD)")
}

// Stats formulas
Float:accuracy(izStats[8])
{
	if (!izStats[STATS_SHOTS])
		return (0.0)
	
	return (100.0 * float(izStats[STATS_HITS]) / float(izStats[STATS_SHOTS]))
}

Float:effec(izStats[8])
{
	if (!izStats[STATS_KILLS])
		return (0.0)
	
	return (100.0 * float(izStats[STATS_KILLS]) / float(izStats[STATS_KILLS] + izStats[STATS_DEATHS]))
}

// Get and format top 10.
format_top10(sBuffer[MAX_BUFFER_LENGTH + 1])
{
	new iMax = get_statsnum()
	new izStats[8], izBody[8]
	new iLen = 0

	if (iMax > 10)
		iMax = 10

	new lKills[16], lDeaths[16], lEff[16], lAcc[16]

	format(lKills, 15, "%L", LANG_SERVER, "KILLS")
	format(lDeaths, 15, "%L", LANG_SERVER, "DEATHS")

	ucfirst(lEff)
	ucfirst(lAcc)

	iLen = format(sBuffer, MAX_BUFFER_LENGTH, "<body background=http://img244.imageshack.us/img244/2816/unnamedgc2.png bgProperties=fixed><center><font color=#FF0000><img src=http://img77.imageshack.us/img77/4986/mamamiamf6.png><pre>")
	iLen += format(sBuffer[iLen], MAX_BUFFER_LENGTH - iLen, "%2s %-22.22s %6s %6s %4s^n", "#", "Nick", lKills, lDeaths, "HS", lEff, lAcc)
	
	for (new i = 0; i < iMax && MAX_BUFFER_LENGTH - iLen > 0; i++)
	{
		get_stats(i, izStats, izBody, t_sName, MAX_NAME_LENGTH)
		replace_all(t_sName, MAX_NAME_LENGTH, "<", "[")
		replace_all(t_sName, MAX_NAME_LENGTH, ">", "]")
		iLen += format(sBuffer[iLen], MAX_BUFFER_LENGTH - iLen, "%2d %-22.22s %6d %6d %4d^n", i + 1, t_sName, izStats[STATS_KILLS], 
						izStats[STATS_DEATHS], izStats[STATS_HS], effec(izStats), accuracy(izStats))
	}
}

// Display MOTD top10 ranked.
public cmdTop10(id)
{
	
	format_top10(g_sBuffer)
	show_motd(id, g_sBuffer, "Top 10")
	
	return PLUGIN_CONTINUE
}

