#include <amxmodx>
#include <fakemeta>
#include <xs>
#tryinclude <biohazard>

#if !defined _biohazard_included
        #assert Biohazard functions file required!
#endif

new cvar_flashlight, g_flashlight[33], g_lightent[33]
public plugin_init()
{
	register_plugin("flashlight", "0.3", "cheap_suit")
	is_biomod_active() ? plugin_init2() : pause("ad")
}

public plugin_init2()
{
	register_forward(FM_Think, "fwd_think")
	register_event("Flashlight", "event_flashlight", "b")
	register_event("Damage",     "event_damage",	 "b")
	register_event("ResetHUD",   "event_resethud", 	 "be")
	
	cvar_flashlight = register_cvar("bh_flashlight", "1")
}

public plugin_precache()
	precache_model("sprites/dot.spr")

public client_connect(id)
	reset_user(id)

public client_disconnect(id)
	reset_user(id)

public reset_user(id)
{
	if(g_lightent[id] > 0 && pev_valid(g_lightent[id]))
		engfunc(EngFunc_RemoveEntity, g_lightent[id])
	g_lightent[id] = 0, g_flashlight[id] = 0
}

public event_resethud(id)
	g_flashlight[id] = false

public event_flashlight(id)
{
	if(is_user_zombie(id) || !get_pcvar_num(cvar_flashlight)) return
	
	flashlight(id, g_flashlight[id] ? false : true)
	set_pev(id, pev_effects, pev(id, pev_effects) & ~EF_DIMLIGHT)
}

public event_damage(id) if(get_user_health(id) < 1)
	flashlight(id, false)

public event_infect2(id)
	flashlight(id, false)

public fwd_think(ent)
{
	if(!pev_valid(ent))
		return FMRES_IGNORED
	
        static classname[11]
	pev(ent, pev_classname, classname, 10)
	
	if(!equal(classname, "flashlight"))
		return FMRES_IGNORED
	
        static id; id = pev(ent, pev_owner)
        if(!is_user_alive(id))
	{
		set_pev(ent, pev_effects, 0)
		return FMRES_IGNORED
	}
	else if(!g_flashlight[id])
	{
		set_pev(ent, pev_effects, 0)
		return FMRES_IGNORED
	}
	
	static Float:origin[3];   pev(id, pev_origin, origin)
	static Float:aim[3]; 	  get_user_aim(id, origin, aim)
	static Float:hitpoint[3]; fm_trace_line(-1, origin, aim, hitpoint)
	engfunc(EngFunc_SetOrigin, ent, hitpoint)
	set_pev(ent, pev_nextthink, get_gametime())
		
	return FMRES_HANDLED
}
	
	
stock flashlight(index, bool:status = false)
{
	g_flashlight[index] = status

	static msg_flashlight
	if(!msg_flashlight) msg_flashlight = get_user_msgid("Flashlight")
	
	message_begin(MSG_ONE, msg_flashlight, _, index)
	write_byte(status ? 1 : 0)
	write_byte(100)
	message_end()
	
	if(status)
	{
		if(!pev_valid(g_lightent[index]))
		{
			g_lightent[index] = engfunc(EngFunc_CreateNamedEntity, engfunc(EngFunc_AllocString, "info_target"))
			if(g_lightent[index])
			{
				engfunc(EngFunc_SetModel, g_lightent[index], "sprites/dot.spr")
				set_pev(g_lightent[index], pev_classname,  "flashlight")
				set_pev(g_lightent[index], pev_solid,      SOLID_NOT)
				set_pev(g_lightent[index], pev_movetype,   MOVETYPE_FLY)
				set_pev(g_lightent[index], pev_rendermode, kRenderTransTexture)
				set_pev(g_lightent[index], pev_effects,    EF_BRIGHTLIGHT)
				set_pev(g_lightent[index], pev_renderamt,  0.0)
				set_pev(g_lightent[index], pev_owner,      index)
				set_pev(g_lightent[index], pev_nextthink,  get_gametime())
			}
		}
		else
		{
			set_pev(g_lightent[index], pev_effects,   EF_BRIGHTLIGHT)
			set_pev(g_lightent[index], pev_nextthink, get_gametime())
		}
	}
	else
		if(pev_valid(g_lightent[index])) set_pev(g_lightent[index], pev_effects, 0)
}

stock fm_trace_line(ignoreent, const Float:start[3], const Float:end[3], Float:ret[3]) 
{
	engfunc(EngFunc_TraceLine, start, end, ignoreent == -1 ? 1 : 0, ignoreent, 0)
	static ent; ent = get_tr2(0, TR_pHit); get_tr2(0, TR_vecEndPos, ret)

	return pev_valid(ent) ? ent : 0
}

stock get_user_aim(index, const Float:source[3], Float:ret[3])
{
	static Float:vangle[3]; pev(index, pev_v_angle, vangle)
	static Float:temp[3];   engfunc(EngFunc_MakeVectors, temp)
	static Float:dir[3];    angle_vector(vangle, ANGLEVECTOR_FORWARD, dir)
	xs_vec_mul_scalar(dir, 2048.8, temp)
	xs_vec_add(source, temp, ret)
}