/* zp_lighting_vote v0.3 */

#include <amxmodx>
#include <amxmisc>

#define PLUGIN "zp_lighting_vote"
#define VERSION "0.3"
#define AUTHOR "ZETA [M|E|N]/CHyC"

#define keys (1<<0)|(1<<1)|(1<<2)

new menu[121],players[32],player_name[32],item[4][21],vote[4],num,i

public plugin_init() {
	register_plugin("PLUGIN","VERSION","AUTHOR")
	register_cvar("zp_lighting_vote", VERSION, FCVAR_SERVER)
	register_menucmd(register_menuid("lighting_vote"),keys,"func_vote")
	register_dictionary("zp_lighting_vote.txt") 
}

public plugin_cfg() {
	format(item[0],20,"%L",LANG_PLAYER,"VOTE_QUESTION")
	format(item[1],20,"%L",LANG_PLAYER,"VOTE_NIGHT")
	format(item[2],20,"%L",LANG_PLAYER,"VOTE_EVENING")
	format(item[3],20,"%L",LANG_PLAYER,"VOTE_TWILIGHT")
	format(menu,120,"\y%s^n^n\r1. \w%s^n\r2. \w%s^n\r3. \w%s",item[0],item[1],item[2],item[3])

	set_task(120.0,"func_menu_vote")
}

public func_menu_vote() {
	get_players(players,num)
	
	for(i=0;i<num;i++) {
		show_menu(players[i],keys,menu,10,"lighting_vote")
		set_task(10.0,"result_vote")
	}
	return PLUGIN_HANDLED
}

public func_vote(id,key) {
	key++
	
	get_user_name(id,player_name,31)
	client_print(0,print_chat,"%L", LANG_PLAYER, "VOTE_RESULT",player_name,item[key])
	
	vote[key]++
	return PLUGIN_HANDLED
}


public result_vote() {
	set_hudmessage(255, 255, 255, 0.06, 0.70, 0, 6.0, 7.0,_,_,5)
	
	if(vote[1]>vote[2]) {
		if(vote[1]>vote[3]) {
			server_cmd("zp_lighting a")
			show_hudmessage(0, "%L", LANG_PLAYER, "RESULT_NIGHT")
		}
		else {
			server_cmd("zp_lighting c")
			show_hudmessage(0, "%L", LANG_PLAYER, "RESULT_TWILIGHT")
		}
	}
	else if(vote[2]>vote[3]) {
		server_cmd("zp_lighting b")
		show_hudmessage(0, "%L", LANG_PLAYER, "RESULT_EVENING")
		}
		else {
			server_cmd("zp_lighting c")
			show_hudmessage(0, "%L", LANG_PLAYER, "RESULT_TWILIGHT")
		}
	return PLUGIN_HANDLED
}

