#include <amxmodx>
#include <cstrike>

#define PLUGIN_VERSION "1.2.4"

// Variable
new zoom_cost

public plugin_init()
{
	// Register Plugin
	register_plugin( "Buy Zoom", PLUGIN_VERSION, "fezh" )

	// Client Commands
	register_clcmd( "say /zoom", "set_zoom" )
	register_clcmd( "say_team /zoom", "set_zoom" )
	register_clcmd( "say /remove", "remove_zoom" )
	register_clcmd( "say_team /remove", "remove_zoom" )
	register_clcmd( "say /zoomhelp", "cmd_helpmotd" )
	register_clcmd( "say_team /zoomhelp", "cmd_helpmotd" )

	// CVAR
        zoom_cost = register_cvar( "amxx_zoom_cost", "500" )

	// Plugin Version
	register_cvar( "buy_zoom_version", PLUGIN_VERSION, FCVAR_SERVER|FCVAR_EXTDLL|FCVAR_UNLOGGED|FCVAR_SPONLY )

	// Multilingual Dictionary
	register_dictionary( "buy_zoom.txt")

	// Bug Fix
	register_event( "DeathMsg", "user_dead", "a" )
}

// Plugin Message
public client_putinserver( id )
{
	set_task( 15.0, "plugin_message", id )
}

// Plugin Shows Help Message
public plugin_message( id )
{
        client_print( 0, print_chat, "%L", LANG_PLAYER, "HELPMSG" )
}

// Bug fix
public user_dead()
{
        new id = read_data( 2 )
        cs_set_user_zoom( id, CS_RESET_ZOOM, 0 )

	return PLUGIN_HANDLED
}

// Remove Command
public remove_zoom( id )
{
        cs_set_user_zoom( id, CS_RESET_ZOOM, 0 )
        client_print( id, print_chat, "%L", id, "REMMSG" )

	return PLUGIN_HANDLED
}

// Buy Command
public set_zoom( id )
{
	new money_left_over = cs_get_user_money( id ) - get_pcvar_num( zoom_cost );
	if ( money_left_over < 0 ) 
	{
		client_print( id, print_chat, "%L", id, "DONTZOOM" )

		return PLUGIN_HANDLED
	}

	cs_set_user_money( id, money_left_over, 1 )
	cs_set_user_zoom( id, CS_SET_AUGSG552_ZOOM, 0 )
	client_print( id, print_chat, "%L", id, "ZOOMMSG" )

	return PLUGIN_HANDLED
}

// Help Motd
public cmd_helpmotd( id )
{
	static motd[ 2048 ]
	formatex( motd, 2047,"%L", id, "HELP_MOTD" )

	show_motd( id, motd, "Zoom Commands" )
}