/*
[ZP] Extra Item : Immunity

Plugin Thread :

http://forums.alliedmods.net/showthread.php?t=105537
*/


#include <amxmodx>
#include <fun>
#include <hamsandwich>
#include <zombieplague>

#define AUTHOR "Javivi & sunx"

// If you want immunity for all round, uncomment this !
//#define ALLROUND

// Task IDs
#define TASK_AURA 321

// Ammo Pack cost 
#if !defined ALLROUND
new const ITEM_COST = 15
#else
new const ITEM_COST = 30
#endif

// Variables
new g_itemID, g_HudSync

// Cvars
#if !defined ALLROUND
new cvar_duration
#endif

new cvar_auracolor, cvar_aurasize

// Array
new g_HaveImmunity[33], Time[33]


public plugin_init()
{
	// Plugin register
	register_plugin("[ZP] Extra Item: Immunity", "3.0", AUTHOR)
	
	// Cvars
	#if !defined ALLROUND
	cvar_duration = register_cvar("zp_immunity_duration", "30")
	#endif
	
	cvar_auracolor = register_cvar("zp_immunity_color", "255 165 0")
	cvar_aurasize = register_cvar("zp_immunity_aura_size", "25")
	
	// Variables
	#if !defined ALLROUND
	g_itemID = zp_register_extra_item("Immunity", ITEM_COST , ZP_TEAM_HUMAN)	
	#else
	g_itemID = zp_register_extra_item("Immunity (All round)", ITEM_COST , ZP_TEAM_HUMAN)	
	#endif
	g_HudSync = CreateHudSyncObj()
	
	// Language File
	register_dictionary("zp_extra_immunity.txt")
	
	// Hamsandwich forward
	RegisterHam(Ham_Spawn, "player", "fw_PlayerSpawn_Post", 1)
	
	// Gamemonitor info
	static szCvar[30]
	formatex(szCvar, charsmax(szCvar), "v3.0 by Javivi")
	register_cvar("zp_immunity", szCvar, FCVAR_SERVER|FCVAR_SPONLY)
}

// If some one buy the item
public zp_extra_item_selected(id, itemid)
{
	if(itemid == g_itemID)
	{
		// Wait until the round start
		if (!zp_has_round_started())
		{
			new Temp[32]
			formatex(Temp, 31 , "!g[ZP] !y%L", id, "WAIT")
			chat_color(id, Temp)
			zp_set_user_ammo_packs(id, zp_get_user_ammo_packs(id) + ITEM_COST)
			
			return
		}
		// If the player dont have immunity
		if(!g_HaveImmunity[id])
		{
			// Enable Godmode
			set_user_godmode(id, 1)
			
			// Aura task
			set_task(0.1, "aura", id + TASK_AURA, _, _, "b")
			
			g_HaveImmunity[id] = true
			
			// If you want use the item all round
			#if defined ALLROUND
			set_hudmessage(85, 127, 255, -1.0, 0.15, 1, 0.1, 3.0, 0.05, 0.05, -1)
			ShowSyncHudMsg(id, g_HudSync, "%L", id, "IMMUME")
			
			#else
			// Start the countdown !
			Time[id] = get_pcvar_num(cvar_duration)
			CountDown(id)
			
			#endif
		}
		
		// If the player already have immunity
		else
		{
			new Temp[32]
			formatex(Temp, 31, "!g[ZP] !y%L", id, "ALREADY")
			chat_color(id, Temp)	
			zp_set_user_ammo_packs(id, zp_get_user_ammo_packs(id) + ITEM_COST)
			
			return
		}
		
	}
}

// Countdown code
public CountDown(id)
{
	// If time is 0 or -1
	if(Time[id] <= 0)
	{		
		// Remove aura task
		remove_task(id + TASK_AURA)
		
		// Client_Print
		client_print(id, print_center, "%L", id, "EXPIRED")
		
		// Disable godmode
		set_user_godmode(id, 0)
		
		// The player dont have immunity
		g_HaveImmunity[id] = false
		
		// Remove countdown
		return
	}
	
	// Time - 1
	Time[id]--
	
	// Show the immunity seconds
	set_hudmessage(85, 127, 255, -1.0, 0.15, 1, 0.1, 3.0, 0.05, 0.05, -1)
	ShowSyncHudMsg(id, g_HudSync, "%L", id, "REMAINING", Time[id])
	
	// Repeat
	set_task(1.0, "CountDown", id)
}



// If user is infected (Infection nade)
public zp_user_infected_post(id)
{
	if(g_HaveImmunity[id])
	{
		#if !defined ALLROUND
		// Remove countdown task
		Time[id] = 0
		#endif
		
		// Remove aura task
		remove_task(id + TASK_AURA)
		
		// The player dont have immunity
		g_HaveImmunity[id] = false
		
		// Disable godmode
		set_user_godmode(id, 0)
	}
}


// At player spawn
public fw_PlayerSpawn_Post(id)
{
	if(g_HaveImmunity[id])
	{
		#if !defined ALLROUND
		// Remove countdown task
		Time[id] = 0
		
		#else
		
		// If allround is uncommented show a message.
		client_print(id, print_center, "%L", id, "EXPIRED")
		#endif
		
		// Remove aura task
		remove_task(id + TASK_AURA)
		
		// Disable godmode
		set_user_godmode(id, 0)
		
		// Remove immunity
		g_HaveImmunity[id] = false
	}
}



/*============
Aura Code
============*/

public aura(id)
{
	id -= TASK_AURA
	
	
	// If user die 
	if (!is_user_alive(id))
		return
	
	// Color cvar ---> RGB!
	new szColors[16]
	get_pcvar_string(cvar_auracolor, szColors, 15)
	
	new gRed[4], gGreen[4], gBlue[4], iRed, iGreen, iBlue
	parse(szColors, gRed, 3, gGreen, 3, gBlue, 3)
	
	iRed = clamp(str_to_num(gRed), 0, 255)
	iGreen = clamp(str_to_num(gGreen), 0, 255)
	iBlue = clamp(str_to_num(gBlue), 0, 255)
	
	new Origin[3]
	get_user_origin(id, Origin)
	
	message_begin(MSG_ALL, SVC_TEMPENTITY)
	write_byte(TE_DLIGHT)
	write_coord(Origin[0])
	write_coord(Origin[1])
	write_coord(Origin[2])
	write_byte(get_pcvar_num(cvar_aurasize))
	write_byte(iRed) //   R
	write_byte(iGreen) // G
	write_byte(iBlue) //  B
	write_byte(2)
	write_byte(0)
	message_end()
}


/*===============
ColorChat Stock
===============*/

stock chat_color(const id, const input[], any:...)
{
	static msg[191], iSayText
	vformat(msg, 190, input, 3)
	
	if( !iSayText ) iSayText = get_user_msgid("SayText");
	
	replace_all(msg, 190, "!g", "^4")
	replace_all(msg, 190, "!y", "^1")
	
	
	message_begin(id ? MSG_ONE_UNRELIABLE : MSG_BROADCAST, iSayText, _, id ? id : find_player("j") )
	write_byte(id ? id : find_player("j") )
	write_string(msg)
	message_end()
} 
