/* Plugin generated by AMXX-Studio */

#include <amxmodx>
#include <amxmisc>
#include <fakemeta>
#include <xs>
#include <cstrike>
#include <biohazard>
//#include <fakemeta_util>

#define PLUGIN "LTM for BIOHAZARD"
#define VERSION "+1.1"
#define AUTHOR "SandStriker"

#define RemoveEntity(%1)	engfunc(EngFunc_RemoveEntity,%1)
//#define ACCESSLEVEL		ADMIN_LEVEL_H
#define TASK_PLANT		15100
#define TASK_RESET		15500

#define LASERMINE_TEAM		pev_iuser1//EV_INT_iuser1
#define LASERMINE_OWNER		pev_iuser2 //EV_INT_iuser3
#define LASERMINE_STEP		pev_iuser3
#define LASERMINE_HITING	pev_iuser4
#define LASERMINE_COUNT		pev_fuser1

#define LASERMINE_POWERUP	pev_fuser2
#define LASERMINE_BEAMTHINK	pev_fuser3

#define LASERMINE_BEAMENDPOINT	pev_vuser1
#define MAX_MINES		10
#define MODE_LASERMINE		0
#define OFFSET_TEAM 		114
#define OFFSET_DEATH	 	444
#define bio_get_user_team(%1)   CsTeams:get_pdata_int(%1, OFFSET_TEAM)
#define cs_get_user_deaths(%1)  get_pdata_int(%1, OFFSET_DEATH)

enum tripmine_e {
	TRIPMINE_IDLE1 = 0,
	TRIPMINE_IDLE2,
	TRIPMINE_ARM1,
	TRIPMINE_ARM2,
	TRIPMINE_FIDGET,
	TRIPMINE_HOLSTER,
	TRIPMINE_DRAW,
	TRIPMINE_WORLD,
	TRIPMINE_GROUND,
};

enum
{
	POWERUP_THINK,
	BEAMBREAK_THINK,
	EXPLOSE_THINK
};

enum
{
	POWERUP_SOUND,
	ACTIVATE_SOUND,
	STOP_SOUND
};

new const
	ENT_MODELS[]	= "models/v_tripmine.mdl",
	ENT_SOUND1[]	= "weapons/mine_deploy.wav",
	ENT_SOUND2[]	= "weapons/mine_charge.wav",
	ENT_SOUND3[]	= "weapons/mine_activate.wav",
	ENT_SOUND4[]	= "debris/beamstart9.wav",
	ENT_SOUND5[]	= "items/gunpickup2.wav",
	ENT_SOUND6[]	= "debris/bustglass1.wav",
	ENT_SOUND7[]	= "debris/bustglass2.wav",
	ENT_SPRITE1[] 		= "sprites/laserbeam.spr",
	ENT_SPRITE2[] 		= "sprites/zerogxplode.spr";

new const
	ENT_CLASS_NAME[]	= "lasermine",
	//ENT_CLASS_NAME2[]	= "info_target",
	ENT_CLASS_NAME3[]	= "func_breakable";

new const
	CHATTAG[] 		= "[BioLezer]",
	//STR_MINEDETNATED[] 	= "Neked van Lezered.",
	//STR_MINEDETNATED2[]	= "Felrobbant a te lezered.",
	STR_NOTACTIVE[] 	= "A lezer nem aktiv a szerveren.",
	STR_DONTHAVEMINE[]	= "Nincs lezered. Vegyel!",
	STR_CANTDEPLOY[]	= "A csapat nem hasznalhat tobb lezert!",
	STR_MAXDEPLOY[]		= "Az osszes lezered le tetted.",
	STR_MANYPPL[]		= "A te csapatod nem tehet tobb lezert!",
	STR_PLANTWALL[]		= "A lezert a falra tedd!",
	STR_REF[]		= "Ha nem ismered a lezert ird a cset-be hogy 'lasermine'.",
	STR_CBT[]		= "Te Zombi vagy! Nem hasznalhatsz lezert!",
	STR_HAVEMAX[]		= "Osszes Lezered megvan.",
	STR_NOMONEY[]		= "Neked nincs eleg penzed! ($",
	STR_NEEDED[]		= "kell)",
	STR_DELAY[]		= "Az ido leteltevel tudsz vasarolni es lezert tenni.",
	STR_SECONDS[]		= "masodperc.",
	STR_BOUGHT[]		= "Te Sikeressen vetel lezert.",
	STR_STATE[]		= "Lezered szama:",
	STR_NOACCESS[]		= "Nem hasznalhatod a lezert.";

new g_EntMine;
new beam, boom
new 
	g_LENABLE,g_LFMONEY,g_LAMMO,g_LDMG,
	g_LTMAX,g_LCOST,g_LHEALTH,g_LMODE,g_LRADIUS,g_LRDMG,g_LFF,g_LCBT;
new
	g_LDELAY,/*g_LTHINK,*/g_LVISIBLE,
	g_LSTAMMO,g_LACCESS,g_LGLOW,g_LDMGMODE,g_LCLMODE,g_LCBRIGHT,g_LDSEC;

new g_dcount,g_nowtime,g_MaxPL
new bool:g_settinglaser[33]
new g_msgDeathMsg,g_msgScoreInfo,g_msgDamage,g_msgStatusText;
new Float:plspeed[33]
new plsetting[33]
new g_havemine[33];
new g_deployed[33];

public plugin_init() {
	register_plugin(PLUGIN, VERSION, AUTHOR)
	
	// Add your code here...
	//register_clcmd("+setlaser","CreateLaserMine_Progress");
   	//register_clcmd("-setlaser","StopCreateLaserMine");
	register_clcmd("say","say_lasermine");
	register_clcmd("buy_lasermine","BuyLasermine");
	g_LENABLE	= register_cvar("bio_ltm","1")
	g_LACCESS	= register_cvar("bio_ltm_acs","0")  //0 all, 1 admin
	g_LMODE		= register_cvar("bio_ltm_mode","0") //0 lasermine, 1 tripmine
	g_LAMMO		= register_cvar("bio_ltm_ammo","2")
	g_LDMG		= register_cvar("bio_ltm_dmg","60") //laser hit dmg
	g_LCOST		= register_cvar("bio_ltm_cost","2500")
	g_LFMONEY	= register_cvar("bio_ltm_fragmoney","300")
	g_LHEALTH	= register_cvar("bio_ltm_health","500")
	g_LTMAX		= register_cvar("bio_ltm_teammax","10")
	g_LRADIUS	= register_cvar("bio_ltm_radius","320.0")
	g_LRDMG		= register_cvar("bio_ltm_rdmg","100") //radius damage
	g_LFF		= register_cvar("bio_ltm_ff","0")
	g_LCBT		= register_cvar("bio_ltm_cbt","ALL")
	g_LDELAY	= register_cvar("bio_ltm_delay","15")
	//g_LTHINK = register_cvar("bio_ltm_think","0.01")
	g_LVISIBLE	= register_cvar("bio_ltm_line","1")
	g_LGLOW		= register_cvar("bio_ltm_glow","0")
	g_LCBRIGHT	= register_cvar("bio_ltm_bright","255")//laser line brightness.
	g_LCLMODE	= register_cvar("bio_ltm_color","0") //0 is team color,1 is green
	g_LDMGMODE	= register_cvar("bio_ltm_ldmgmode","0") //0 - frame dmg, 1 - once dmg, 2 - 1 second dmg
	g_LDSEC		= register_cvar("bio_ltm_ldmgseconds","1") //mode 2 only, damage / seconds. default 1 (sec)
	g_LSTAMMO	= register_cvar("bio_ltm_startammo","1")

	register_event("DeathMsg", "DeathEvent", "a")
 	register_event("CurWeapon", "standing", "be", "1=1")
	register_event("ResetHUD", "delaycount", "a")
	register_event("ResetHUD", "newround", "b")
	register_event("Damage","CutDeploy_onDamage","b")
	g_msgDeathMsg 	= get_user_msgid("DeathMsg")
	g_msgScoreInfo	= get_user_msgid("ScoreInfo")
	g_msgDamage 	= get_user_msgid("Damage")
	g_msgStatusText = get_user_msgid("StatusText")

	// -- Forward.
	register_forward(FM_Think, "ltm_Think" );
	register_forward(FM_PlayerPostThink, "ltm_PostThink" );
	register_forward(FM_PlayerPreThink, "ltm_PreThink")

}

public plugin_precache() 
{
	precache_sound(ENT_SOUND1);
	precache_sound(ENT_SOUND2);
	precache_sound(ENT_SOUND3);
	precache_sound(ENT_SOUND4);
	precache_sound(ENT_SOUND5);
	precache_sound(ENT_SOUND6);
	precache_sound(ENT_SOUND7);
	precache_model(ENT_MODELS);
	beam = precache_model(ENT_SPRITE1);
	boom = precache_model(ENT_SPRITE2);
	
	return PLUGIN_CONTINUE;
}

public plugin_modules() 
{
	require_module("fakemeta")
	require_module("cstrike")
	//require_module("fun")
}

public plugin_cfg()
{
	g_EntMine = engfunc(EngFunc_AllocString,ENT_CLASS_NAME3);
	arrayset(g_havemine,0,sizeof(g_havemine));
	arrayset(g_deployed,0,sizeof(g_deployed));
	g_MaxPL = get_maxplayers();
}

public delaycount()
{
	g_dcount = floatround(get_gametime())
}

bool:CheckTime()
{
	g_nowtime = floatround(get_gametime()) - g_dcount
	if(g_nowtime >= get_pcvar_num(g_LDELAY))
		return true
	return false
}

public CreateLaserMine_Progress(id){ 


	if (!CreateCheck(id))
		return PLUGIN_HANDLED;
	g_settinglaser[id] = true

	message_begin( MSG_ONE, 108, {0,0,0}, id );
	write_byte(1);
	write_byte(0);
	message_end();


	new PID[1];
	PID[0] = id;
	set_task(1.2, "Spawn", (TASK_PLANT + id), PID, 1);
	

	return PLUGIN_HANDLED;
}

public StopCreateLaserMine(id)
{

	DeleteTask(id);
	message_begin(MSG_ONE, 108, {0,0,0}, id)
	write_byte(0);
	write_byte(0);
	message_end();

	return PLUGIN_HANDLED;
}

public Spawn( ids[] )
{
	new id = ids[0];
	// motor
	new i_Ent = engfunc(EngFunc_CreateNamedEntity,g_EntMine);
	if(!i_Ent) {
		client_print(id,print_chat,"[Laesrmine Debug] Can't Create Entity")
		return PLUGIN_HANDLED_MAIN;
	}
	set_pev(i_Ent,pev_classname,ENT_CLASS_NAME)

	engfunc(EngFunc_SetModel,i_Ent,ENT_MODELS);

	set_pev(i_Ent,pev_solid,SOLID_NOT);
	set_pev(i_Ent,pev_movetype,MOVETYPE_FLY);

	set_pev(i_Ent,pev_frame,0);
	set_pev(i_Ent,pev_body,3);
	set_pev(i_Ent,pev_sequence,TRIPMINE_WORLD);
	set_pev(i_Ent,pev_framerate,0);
    
	set_pev(i_Ent,pev_takedamage,DAMAGE_YES);
	
	set_pev(i_Ent,pev_dmg,100.0);
	set_user_health(i_Ent,get_pcvar_num(g_LHEALTH));
	new Float:vOrigin[3];
	new	Float:vNewOrigin[3],Float:vNormal[3],Float:vTraceDirection[3],
		Float:vTraceEnd[3],Float:vEntAngles[3];
	pev( id, pev_origin, vOrigin );
	velocity_by_aim( id, 128, vTraceDirection );
	xs_vec_add( vTraceDirection, vOrigin, vTraceEnd );
	
	engfunc( EngFunc_TraceLine, vOrigin, vTraceEnd, DONT_IGNORE_MONSTERS, id, 0 );
	
	new Float:fFraction;
	get_tr2( 0, TR_flFraction, fFraction );
	

	// -- We hit something!
	if ( fFraction < 1.0 )
	{
		// -- Save results to be used later.
		get_tr2( 0, TR_vecEndPos, vTraceEnd );
		get_tr2( 0, TR_vecPlaneNormal, vNormal );
	}


	xs_vec_mul_scalar( vNormal, 8.0, vNormal );
	xs_vec_add( vTraceEnd, vNormal, vNewOrigin );

	engfunc(EngFunc_SetSize, i_Ent, Float:{ -8.0, -8.0, -8.0 }, Float:{ 8.0, 8.0, 8.0 } );
	engfunc(EngFunc_SetOrigin, i_Ent, vNewOrigin );

	// -- Rotate tripmine.
	vector_to_angle(vNormal,vEntAngles );
	set_pev(i_Ent,pev_angles,vEntAngles );

	// -- Calculate laser end origin.
	new Float:vBeamEnd[3], Float:vTracedBeamEnd[3];
        
	xs_vec_mul_scalar(vNormal, 8192.0, vNormal );
	xs_vec_add( vNewOrigin, vNormal, vBeamEnd );

	engfunc( EngFunc_TraceLine, vNewOrigin, vBeamEnd, IGNORE_MONSTERS, -1, 0 );

	get_tr2( 0, TR_vecPlaneNormal, vNormal );
	get_tr2( 0, TR_vecEndPos, vTracedBeamEnd );

	// -- Save results to be used later.
	set_pev(i_Ent, LASERMINE_OWNER, id );
	set_pev(i_Ent,LASERMINE_BEAMENDPOINT,vTracedBeamEnd);
	set_pev(i_Ent,LASERMINE_TEAM,int:bio_get_user_team(id));

	new Float:fCurrTime = get_gametime();

	set_pev(i_Ent,LASERMINE_POWERUP, fCurrTime + 2.5 );
   
	set_pev(i_Ent,LASERMINE_STEP,POWERUP_THINK);
	set_pev(i_Ent,pev_nextthink, fCurrTime + 0.2 );

	PlaySound(i_Ent,POWERUP_SOUND );
	g_deployed[id]++;
	g_havemine[id]--;
	DeleteTask(id);
	ShowAmmo(id);
	return 1;
}

stock TeamDeployedCount(id)
{
	//new tid[32];
	
	static i;
	static CsTeams:t;t = bio_get_user_team(id);
	static cnt;cnt=0;

	for(i = 1;i <= g_MaxPL;i++)
	{
		if(is_user_connected(i))
			if(t == bio_get_user_team(i))
				cnt += g_deployed[i];
	}

	return cnt;
}

bool:CheckCanTeam(id)
{
	new arg[5],CsTeam:num
	get_pcvar_string(g_LCBT,arg,3)
	if(equali(arg,"T")){
		num = CsTeam:CS_TEAM_T
	}
	else if(equali(arg,"CT")){
		num = CsTeam:CS_TEAM_CT
	}
	else if(equali(arg,"ALL")){
		num = CsTeam:CS_TEAM_UNASSIGNED
	}	
	else{
		num = CsTeam:CS_TEAM_UNASSIGNED
	}
	if(num != CsTeam:CS_TEAM_UNASSIGNED && num != CsTeam:bio_get_user_team(id))
		return false;
	return true
}

bool:CanCheck(id,mode)
{
	if( !get_pcvar_num( g_LENABLE ) )
	{
		client_print(id, print_chat, "%s %s",CHATTAG,STR_NOTACTIVE)
		return false
	}
	if( get_pcvar_num(g_LACCESS) != 0)
		if(!(get_user_flags(id) & ADMIN_IMMUNITY))
		{
			client_print(id, print_chat, "%s %s",CHATTAG,STR_NOACCESS)
			return false
		}
	if(!is_user_alive(id)) return false
	if(is_user_zombie(id))
	{
		client_print(id, print_chat, "%s %s",CHATTAG,STR_CBT)
		return false
	}
	if (!CheckCanTeam(id))
	{
		client_print(id, print_chat, "%s %s",CHATTAG,STR_CANTDEPLOY)	
		return false
	}
	if( mode == 0)
	{
		if(g_havemine[id] <= 0){
			client_print(id, print_chat, "%s %s",CHATTAG,STR_DONTHAVEMINE)
			return false
		}
	}
	if (mode == 1)
	{
		if (g_havemine[id] >= get_pcvar_num(g_LAMMO)){
			client_print(id, print_chat, "%s %s",CHATTAG,STR_HAVEMAX)	
			return false
		}
		if (cs_get_user_money(id) < get_pcvar_num(g_LCOST)) {
			client_print(id, print_chat, "%s %s%d %s",CHATTAG, STR_NOMONEY,get_pcvar_num(g_LCOST),STR_NEEDED)	
			return false
		}
	}
	if(!CheckTime()){
		client_print(id,print_chat, "%s %s %d %s",CHATTAG,STR_DELAY,get_pcvar_num(g_LDELAY)-g_nowtime,STR_SECONDS)
		return false
	}

	return true;
}

bool:CreateCheck( id )
{
	if (!CanCheck(id,0)) return false
	if (g_deployed[id] >= get_pcvar_num(g_LAMMO))  //unhandled error
	{
		client_print(id, print_chat, "%s %s",CHATTAG,STR_MAXDEPLOY)
		return false
	}

	//client_print(id,print_chat,"[Lasermine] your team deployed %d",TeamDeployedCount(id))
	if(TeamDeployedCount(id) >= get_pcvar_num(g_LTMAX))
	{
		client_print(id, print_chat, "%s %s",CHATTAG,STR_MANYPPL)
		return false
	}
	
	new Float:vTraceDirection[3], Float:vTraceEnd[3],Float:vOrigin[3];
	
	pev( id, pev_origin, vOrigin );
	velocity_by_aim( id, 128, vTraceDirection );
	xs_vec_add( vTraceDirection, vOrigin, vTraceEnd );
	
	engfunc( EngFunc_TraceLine, vOrigin, vTraceEnd, DONT_IGNORE_MONSTERS, id, 0 );
	
	new Float:fFraction,Float:vTraceNormal[3];
	get_tr2( 0, TR_flFraction, fFraction );
	
	// -- We hit something!
	if ( fFraction < 1.0 )
	{
		// -- Save results to be used later.
		get_tr2( 0, TR_vecEndPos, vTraceEnd );
		get_tr2( 0, TR_vecPlaneNormal, vTraceNormal );

		//get_tr2( 0, TR_pHit );

		return true;
	}

	client_print(id, print_chat, "%s %s",CHATTAG,STR_PLANTWALL)
	DeleteTask(id);
	// -- Did not touched something. (not solid)
	return false;
}

public ltm_Think( i_Ent )
{
	if ( !pev_valid( i_Ent ) )
		return FMRES_IGNORED;
	new EntityName[sizeof(ENT_CLASS_NAME)+1];
	static const size = sizeof(ENT_CLASS_NAME);
	pev( i_Ent, pev_classname, EntityName, size);
	if(!get_pcvar_num(g_LENABLE)) return FMRES_IGNORED;
	// -- Entity is not a tripmine, ignoring the next...
	if ( !equal( EntityName, ENT_CLASS_NAME ) )
		return FMRES_IGNORED;

	static Float:fCurrTime;
	fCurrTime = get_gametime();

	switch( pev( i_Ent, LASERMINE_STEP ) )
	{
		case POWERUP_THINK :
		{
			new Float:fPowerupTime;
			pev( i_Ent, LASERMINE_POWERUP, fPowerupTime );

			if( fCurrTime > fPowerupTime )
			{
				set_pev( i_Ent, pev_solid, SOLID_BBOX );
				set_pev( i_Ent, LASERMINE_STEP, BEAMBREAK_THINK );

				PlaySound( i_Ent, ACTIVATE_SOUND );
			}
			if(get_pcvar_num(g_LGLOW)!=0)
			{
				if(get_pcvar_num(g_LCLMODE)==0)
				{
					switch (pev(i_Ent,LASERMINE_TEAM))
					{
						case CS_TEAM_T: set_rendering(i_Ent,kRenderFxGlowShell,255,0,0,kRenderNormal,5)
						case CS_TEAM_CT:set_rendering(i_Ent,kRenderFxGlowShell,0,0,255,kRenderNormal,5)
					}
				}else
				{
					set_rendering(i_Ent,kRenderFxGlowShell,0,255,0,kRenderNormal,5)
				}
			}
			set_pev( i_Ent, pev_nextthink, fCurrTime + 0.1 );
		}
		case BEAMBREAK_THINK :
		{
			static Float:vEnd[3],Float:vOrigin[3];
			pev( i_Ent, pev_origin, vOrigin );
			pev( i_Ent, LASERMINE_BEAMENDPOINT, vEnd );

			static iHit, Float:fFraction;
			engfunc( EngFunc_TraceLine, vOrigin, vEnd, DONT_IGNORE_MONSTERS, i_Ent, 0 );

			get_tr2( 0, TR_flFraction, fFraction );
			iHit = get_tr2( 0, TR_pHit );

			// -- Something has passed the laser.
			if ( fFraction < 1.0 )
			{
				// -- Ignoring others tripmines entity.
				if(pev_valid(iHit))
				{
					pev( iHit, pev_classname, EntityName, size );
	
					if( !equal( EntityName, ENT_CLASS_NAME ) )
					{
						set_pev( i_Ent, pev_enemy, iHit );
						if(get_pcvar_num(g_LMODE) == MODE_LASERMINE)
							CreateLaserDamage(i_Ent,iHit);
						else
							set_pev( i_Ent, LASERMINE_STEP, EXPLOSE_THINK );
				
						set_pev( i_Ent, pev_nextthink, fCurrTime + random_float( 0.1, 0.3 ) );
					}
				}
			}
			if(get_pcvar_num(g_LDMGMODE)!=0)
				if(pev(i_Ent,LASERMINE_HITING) != iHit)
					set_pev(i_Ent,LASERMINE_HITING,iHit);
 
			// -- Tripmine is still there.
			if ( pev_valid( i_Ent ) || (pev(i_Ent,pev_health) > 0.0))
			{
				static Float:fHealth;
				pev( i_Ent, pev_health, fHealth );

				if( fHealth < 0 )
				{
					set_pev( i_Ent, LASERMINE_STEP, EXPLOSE_THINK );
					set_pev( i_Ent, pev_nextthink, fCurrTime + random_float( 0.1, 0.3 ) );
				}
                    
				static Float:fBeamthink;
				pev( i_Ent, LASERMINE_BEAMTHINK, fBeamthink );
                    
				if( fBeamthink < fCurrTime && get_pcvar_num(g_LVISIBLE))
				{
					DrawLaser(i_Ent, vOrigin, vEnd );
					set_pev( i_Ent, LASERMINE_BEAMTHINK, fCurrTime + 0.1 );
				}
				set_pev( i_Ent, pev_nextthink, fCurrTime + 0.01 );
			}
		}
		case EXPLOSE_THINK :
		{
			// -- Stopping entity to think
			set_pev( i_Ent, pev_nextthink, 0.0 );
			PlaySound( i_Ent, STOP_SOUND );
			g_deployed[pev(i_Ent,LASERMINE_OWNER)]--;
			CreateExplosion( i_Ent );
			CreateDamage(i_Ent,get_pcvar_float(g_LRDMG),get_pcvar_float(g_LRADIUS))
			RemoveEntity   ( i_Ent );
		}
	}

	return FMRES_IGNORED;
}

PlaySound( i_Ent, i_SoundType )
{
	switch ( i_SoundType )
	{
		case POWERUP_SOUND :
		{
			emit_sound( i_Ent, CHAN_VOICE, ENT_SOUND1, VOL_NORM, ATTN_NORM, 0, PITCH_NORM );
			emit_sound( i_Ent, CHAN_BODY , ENT_SOUND2, 0.2, ATTN_NORM, 0, PITCH_NORM );
		}
		case ACTIVATE_SOUND :
		{
			emit_sound( i_Ent, CHAN_VOICE, ENT_SOUND3, 0.5, ATTN_NORM, 1, 75 );
		}
		case STOP_SOUND :
		{
			emit_sound( i_Ent, CHAN_BODY , ENT_SOUND2, 0.2, ATTN_NORM, SND_STOP, PITCH_NORM );
			emit_sound( i_Ent, CHAN_VOICE, ENT_SOUND3, 0.5, ATTN_NORM, SND_STOP, 75 );
		}
	}
}

DrawLaser(i_Ent, const Float:v_Origin[3], const Float:v_EndOrigin[3] )
{
	new tcolor[3];
	new teamid = pev(i_Ent, LASERMINE_TEAM);
	if(get_pcvar_num(g_LCLMODE) == 0)
	{
		switch(teamid){
			case 1:{
				tcolor[0] = 255
				tcolor[1] = 0
				tcolor[2] = 0
			}
			case 2:{
				tcolor[0] = 0
				tcolor[1] = 0
				tcolor[2] = 255
			}
		}
	}else
	{
		tcolor[0] = 0
		tcolor[1] = 255
		tcolor[2] = 0
	}
	message_begin(MSG_BROADCAST,SVC_TEMPENTITY) 
	write_byte(TE_BEAMPOINTS)
	engfunc(EngFunc_WriteCoord,v_Origin[0])
	engfunc(EngFunc_WriteCoord,v_Origin[1])
	engfunc(EngFunc_WriteCoord,v_Origin[2])
	engfunc(EngFunc_WriteCoord,v_EndOrigin[0]) //Random
	engfunc(EngFunc_WriteCoord,v_EndOrigin[1]) //Random
	engfunc(EngFunc_WriteCoord,v_EndOrigin[2]) //Random
	write_short(beam)
	write_byte(0)
	write_byte(0)
	write_byte(1) //Life
	write_byte(5) //Width
	write_byte(0)//wave
	write_byte(tcolor[0]) // r
	write_byte(tcolor[1]) // g
	write_byte(tcolor[2]) // b
	write_byte(get_pcvar_num(g_LCBRIGHT))
	write_byte(255)
	message_end() 
}
/*
CreateDamage(iCurrent,DmgMAX,Float:Radius)
{
	new AtkID = pev(iCurrent,LASERMINE_OWNER)// entity_get_int(iCurrent,LASERMINE_OWNER)
	new TeamID= pev(iCurrent,LASERMINE_TEAM) //entity_get_int(iCurrent,LASERMINE_INT_TEAM)
	new Player = -1;
	new Float:distance,dmg;
	new Float:tOrigin[3];
	new Float:vOrigin[3];
	new iHitHP,iHitTeam;
	pev(iCurrent,pev_origin,vOrigin);
	while((Player = engfunc(EngFunc_FindEntityInSphere, Player, vOrigin, Radius)) != 0)
	{
		if(is_user_alive(Player))
		{
			pev(Player,pev_origin,tOrigin)
			distance = get_distance_f(vOrigin, tOrigin)
			dmg = floatround(DmgMAX - ((DmgMAX / Radius) * distance))
			iHitHP = pev_user_health(Player) - dmg
			iHitTeam = int:bio_get_user_team(Player)
			if(iHitHP <= 0)
			{
				if(iHitTeam != TeamID)
				{
					cs_set_user_money(AtkID,cs_get_user_money(AtkID) + get_pcvar_num(g_LFMONEY))
					set_score(AtkID,Player,1,iHitHP)
				}else
				{
					if(get_pcvar_num(g_LFF))
					{
						cs_set_user_money(AtkID,cs_get_user_money(AtkID) - get_pcvar_num(g_LFMONEY))
						set_score(AtkID,Player,-1,iHitHP)
					}
				}
			}else
			{
				if(iHitTeam != TeamID || get_pcvar_num(g_LFF))
				{
					//set_pev(Player,pev_health,iHitHP)
					set_user_health(Player, iHitHP)
					message_begin(MSG_ONE_UNRELIABLE, g_msgDamage, {0,0,0}, Player) 
					write_byte(dmg)
					write_byte(dmg)
					write_long(DMG_BULLET)
					engfunc(EngFunc_WriteCoord,vOrigin[0])
					engfunc(EngFunc_WriteCoord,vOrigin[1])
					engfunc(EngFunc_WriteCoord,vOrigin[2])
					message_end()
				}
			}
		}
		Player =  engfunc(EngFunc_FindEntityInSphere,Player,vOrigin,Radius)
	}
	return PLUGIN_CONTINUE
}
*/
CreateDamage(iCurrent,Float:DmgMAX,Float:Radius)
{
	// Get given parameters
	
	new Float:vecSrc[3]
	pev(iCurrent, pev_origin, vecSrc)

	new AtkID =pev(iCurrent,LASERMINE_OWNER)
	new TeamID=pev(iCurrent,LASERMINE_TEAM)

	new ent = -1
	new Float:tmpdmg = DmgMAX

	new Float:kickback = 0.0
	
	// Needed for doing some nice calculations :P
	new Float:Tabsmin[3], Float:Tabsmax[3]
	new Float:vecSpot[3]
	new Float:Aabsmin[3], Float:Aabsmax[3]
	new Float:vecSee[3]
	new trRes
	new Float:flFraction
	new Float:vecEndPos[3]
	new Float:distance
	new Float:origin[3], Float:vecPush[3]
	new Float:invlen
	new Float:velocity[3]
	new iHitHP,iHitTeam;
	// Calculate falloff
	new Float:falloff
	if (Radius > 0.0)
	{
		falloff = DmgMAX / Radius
	} else {
		falloff = 1.0
	}
	
	// Find monsters and players inside a specifiec radius
	while((ent = engfunc(EngFunc_FindEntityInSphere, ent, vecSrc, Radius)) != 0)
	{
		if(!pev_valid(ent)) continue
		if(!(pev(ent, pev_flags) & (FL_CLIENT | FL_FAKECLIENT | FL_MONSTER)))
		{
			// Entity is not a player or monster, ignore it
			continue
		}
		
		// Reset data
		kickback = 1.0
		tmpdmg = DmgMAX
		
		// The following calculations are provided by Orangutanz, THANKS!
		// We use absmin and absmax for the most accurate information
		pev(ent, pev_absmin, Tabsmin)
		pev(ent, pev_absmax, Tabsmax)
		vecSpot[0] = (Tabsmin[0] + Tabsmax[0]) * 0.5
		vecSpot[1] = (Tabsmin[1] + Tabsmax[1]) * 0.5
		vecSpot[2] = (Tabsmin[2] + Tabsmax[2]) * 0.5
		
		pev(iCurrent, pev_absmin, Aabsmin)
		pev(iCurrent, pev_absmax, Aabsmax)
		vecSee[0] = (Aabsmin[0] + Aabsmax[0]) * 0.5
		vecSee[1] = (Aabsmin[1] + Aabsmax[1]) * 0.5
		vecSee[2] = (Aabsmin[2] + Aabsmax[2]) * 0.5
		
		engfunc(EngFunc_TraceLine, vecSee, vecSpot, 0, iCurrent, trRes)
		get_tr2(trRes, TR_flFraction, flFraction)
		// Explosion can 'see' this entity, so hurt them! (or impact through objects has been enabled xD)
		if (flFraction >= 0.9 || get_tr2(trRes, TR_pHit) == ent)
		{
			// Work out the distance between impact and entity
			get_tr2(trRes, TR_vecEndPos, vecEndPos)
			
			distance = get_distance_f(vecSrc, vecEndPos) * falloff
			tmpdmg -= distance
			if(tmpdmg < 0.0)
				tmpdmg = 0.0
			
			// Kickback Effect
			if(kickback != 0.0)
			{
				origin[0] = vecSpot[0] - vecSee[0]
				origin[1] = vecSpot[1] - vecSee[1]
				origin[2] = vecSpot[2] - vecSee[2]
				
				invlen = 1.0/get_distance_f(vecSpot, vecSee)
				vecPush[0] = origin[0] * invlen
				vecPush[1] = origin[1] * invlen
				vecPush[2] = origin[2] * invlen
				
				pev(ent, pev_velocity, velocity)
				velocity[0] = velocity[0] + vecPush[0] * tmpdmg * kickback
				velocity[1] = velocity[1] + vecPush[1] * tmpdmg * kickback
				velocity[2] = velocity[2] + vecPush[2] * tmpdmg * kickback
				
				if(tmpdmg < 60.0)
				{
					velocity[0] *= 12.0
					velocity[1] *= 12.0
					velocity[2] *= 12.0
				} else {
					velocity[0] *= 4.0
					velocity[1] *= 4.0
					velocity[2] *= 4.0
				}
				
				if(velocity[0] != 0.0 || velocity[1] != 0.0 || velocity[2] != 0.0)
				{
					// There's some movement todo :)
					set_pev(ent, pev_velocity, velocity)
				}
			}
			iHitHP = pev_user_health(ent) - floatround(tmpdmg)
			iHitTeam = int:bio_get_user_team(ent)
			if(iHitHP <= 0)
			{
				if(iHitTeam != TeamID)
				{
					cs_set_user_money(AtkID,cs_get_user_money(AtkID) + get_pcvar_num(g_LFMONEY))
					set_score(AtkID,ent,1,iHitHP)
				}else
				{
					if(get_pcvar_num(g_LFF))
					{
						cs_set_user_money(AtkID,cs_get_user_money(AtkID) - get_pcvar_num(g_LFMONEY))
						set_score(AtkID,ent,-1,iHitHP)
					}
				}
			}else
			{
				if(iHitTeam != TeamID || get_pcvar_num(g_LFF))
				{
					//set_pev(Player,pev_health,iHitHP)
					set_user_health(ent, iHitHP)
					message_begin(MSG_ONE_UNRELIABLE, g_msgDamage, {0,0,0}, ent) 
					write_byte(floatround(tmpdmg))
					write_byte(floatround(tmpdmg))
					write_long(DMG_BULLET)
					engfunc(EngFunc_WriteCoord,vecSrc[0])
					engfunc(EngFunc_WriteCoord,vecSrc[1])
					engfunc(EngFunc_WriteCoord,vecSrc[2])
					message_end()
				}
			}
		}
	}
	
	return
}


CreateExplosion(iCurrent)
{
	
	new Float:vOrigin[3]
	pev(iCurrent,pev_origin,vOrigin)

	message_begin(MSG_BROADCAST, SVC_TEMPENTITY)
	write_byte(99) //99 = KillBeam
	write_short(iCurrent)
	message_end()

	message_begin(MSG_BROADCAST, SVC_TEMPENTITY)
	write_byte(3)
	engfunc(EngFunc_WriteCoord,vOrigin[0])
	engfunc(EngFunc_WriteCoord,vOrigin[1])
	engfunc(EngFunc_WriteCoord,vOrigin[2])
	write_short(boom)
	write_byte(50)
	write_byte(15)
	write_byte(0)
	message_end()
}

CreateLaserDamage(iCurrent,isHit)
{
	if(isHit < 0 ) return PLUGIN_CONTINUE
	switch(get_pcvar_num(g_LDMGMODE))
	{
		case 1:
		{
			if(pev(iCurrent,LASERMINE_HITING) == isHit)
				return PLUGIN_CONTINUE
		}
		case 2:
		{
			if(pev(iCurrent,LASERMINE_HITING) == isHit)
			{
				static Float:cnt
				static now,htime;now = floatround(get_gametime())

				pev(iCurrent,LASERMINE_COUNT,cnt)
				htime = floatround(cnt)
				if(now - htime < get_pcvar_num(g_LDSEC))
				{
					return PLUGIN_CONTINUE;
				}else{
					set_pev(iCurrent,LASERMINE_COUNT,get_gametime())
				}
			}else
			{
				set_pev(iCurrent,LASERMINE_COUNT,get_gametime())
			}
		}
	}

	new Float:vOrigin[3],Float:vEnd[3]
	pev(iCurrent,pev_origin,vOrigin)
	pev(iCurrent,pev_vuser1,vEnd)

	new teamid = pev(iCurrent, LASERMINE_TEAM)

	new szClassName[32]
	new Alive,God
	new iHitTeam,iHitHP,id
	new hitscore

	
	szClassName[0] = '^0'
	pev(isHit,pev_classname,szClassName,32)
	
	if((pev(isHit, pev_flags) & (FL_CLIENT | FL_FAKECLIENT | FL_MONSTER)))
	{
		Alive = is_user_alive(isHit)
		God = get_user_godmode(isHit)
		if(!Alive || God) return PLUGIN_CONTINUE
			 
		iHitTeam = int:bio_get_user_team(isHit)
		iHitHP = pev_user_health(isHit) - get_pcvar_num(g_LDMG)
		id = pev(iCurrent,LASERMINE_OWNER)//, szNetName[32]
		if(iHitHP <= 0)
		{
			if(iHitTeam != teamid)
			{
				emit_sound(isHit, CHAN_WEAPON, ENT_SOUND4, 1.0, ATTN_NORM, 0, PITCH_NORM )
				hitscore = 1
				cs_set_user_money(id,cs_get_user_money(id) + get_pcvar_num(g_LFMONEY))
				set_score(id,isHit,hitscore,iHitHP)
			}else
			{
				if(get_pcvar_num(g_LFF))
				{
					emit_sound(isHit, CHAN_WEAPON, ENT_SOUND4, 1.0, ATTN_NORM, 0, PITCH_NORM )
					hitscore = -1									
					cs_set_user_money(id,cs_get_user_money(id) - get_pcvar_num(g_LFMONEY))
					set_score(id,isHit,hitscore,iHitHP)
				}
			}
		}else if(iHitTeam != teamid || get_pcvar_num(g_LFF))
		{
			emit_sound(isHit, CHAN_WEAPON, ENT_SOUND4, 1.0, ATTN_NORM, 0, PITCH_NORM )
			set_user_health(isHit,iHitHP)
			set_pev(iCurrent,LASERMINE_HITING,isHit);
			message_begin(MSG_ONE_UNRELIABLE, g_msgDamage, {0,0,0}, isHit) 
			write_byte(get_pcvar_num(g_LDMG))
			write_byte(get_pcvar_num(g_LDMG))
			write_long(DMG_BULLET)
			engfunc(EngFunc_WriteCoord,vOrigin[0])
			engfunc(EngFunc_WriteCoord,vOrigin[1])
			engfunc(EngFunc_WriteCoord,vOrigin[2])
			message_end()
		}
	}else if(equal(szClassName, ENT_CLASS_NAME3))
	{
		new hl;
		hl = pev_user_health(isHit);
		set_user_health(isHit,hl-get_pcvar_num(g_LDMG));
	}
	return PLUGIN_CONTINUE
}

stock pev_user_health(id)
{
	new Float:health
	pev(id,pev_health,health)
	return floatround(health)
}

stock set_user_health(id,health)
{
	health > 0 ? set_pev(id, pev_health, float(health)) : dllfunc(DLLFunc_ClientKill, id);
}

stock get_user_godmode(index) {
	new Float:val
	pev(index, pev_takedamage, val)

	return (val == DAMAGE_NO)
}

stock set_user_frags(index, frags)
{
	set_pev(index, pev_frags, float(frags))

	return 1
}

stock pev_user_frags(index)
{
	new Float:frags;
	pev(index,pev_frags,frags);
	return floatround(frags);
}

set_score(id,target,hitscore,HP){

	new idfrags = pev_user_frags(id) + hitscore// get_user_frags(id) + hitscore	
	set_user_frags(id,idfrags)
	//set_user_frags(id, idfrags)
	//entity_set_float(id, EV_FL_frags, float(idfrags))
	
	new tarfrags = pev_user_frags(target) + 1 //get_user_frags(target) + 1
	set_user_frags(target,tarfrags)
	//set_user_frags(target,tarfrags)
	//entity_set_float(target, EV_FL_frags, float(tarfrags))
	
	new idteam = int:bio_get_user_team(id)
	new iddeaths = cs_get_user_deaths(id)


	message_begin(MSG_ALL, g_msgDeathMsg, {0, 0, 0} ,0)
	write_byte(id)
	write_byte(target)
	write_byte(0)
	write_string(ENT_CLASS_NAME)
	message_end()

	message_begin(MSG_ALL, g_msgScoreInfo)
	write_byte(id)
	write_short(idfrags)
	write_short(iddeaths)
	write_short(0)
	write_short(idteam)
	message_end()

	set_msg_block(g_msgDeathMsg, BLOCK_ONCE)

	//entity_set_float(target, EV_FL_health,float(HP))
	set_user_health(target, HP)
	//set_pev(target,pev_health,HP)

}

public BuyLasermine(id)
{	
	if( !CanCheck(id,1) )return PLUGIN_CONTINUE
	cs_set_user_money(id,cs_get_user_money(id) - get_pcvar_num(g_LCOST))
	g_havemine[id]++;
	emit_sound(id, CHAN_ITEM, ENT_SOUND5, VOL_NORM, ATTN_NORM, 0, PITCH_NORM)
	client_print(id, print_chat, "%s %s",CHATTAG,STR_BOUGHT)
	ShowAmmo(id)
	return PLUGIN_HANDLED
}

ShowAmmo(id)
{ 
    new ammo[51] 
    formatex(ammo, 50, "%s %i/%i",STR_STATE, g_havemine[id],get_pcvar_num(g_LAMMO))

    message_begin(MSG_ONE, g_msgStatusText, {0,0,0}, id) 
    write_byte(0) 
    write_string(ammo) 
    message_end() 
} 

public showInfo(id)
{
	client_print(id, print_chat, STR_REF)
}

public say_lasermine(id){
	new said[32]
	read_argv(1,said,31);
	if( !get_pcvar_num( g_LENABLE )  ){
//		client_print(id, print_chat, "%s Lasermines are not currently active.",CHATTAG)
		return PLUGIN_CONTINUE
	}
	
	if (equali(said,"/buy lasermine")||equali(said,"/lm")){
		BuyLasermine(id)
	}else if (equali(said, "lasermine") || equali(said, "/lasermine")){
		const SIZE = 1024
		new msg[SIZE+1],len = 0;
		len += formatex(msg[len], SIZE - len, "<html><body>")
		len += formatex(msg[len], SIZE - len, "<p><b>LaserMine</b></p><br/><br/>")
		len += formatex(msg[len], SIZE - len, "<p>You can be setting the mine on the wall.</p><br/>")
		len += formatex(msg[len], SIZE - len, "<p>That laser will give what touched it damage.</p><br/><br/>")
		len += formatex(msg[len], SIZE - len, "<p><b>LaserMine Commands</b></p><br/><br/>")
		len += formatex(msg[len], SIZE - len, "<p><b>Say /buy lasermine</b> or <b>Say /lm</b> //buying lasermine<br/>")
		len += formatex(msg[len], SIZE - len, "<b>buy_lasermine</b> //bind ^"F2^" buy_lasermine : using F2 buying lasermine<br/>")
		len += formatex(msg[len], SIZE - len, "<b>+setlaser</b> //bind mouse3 +setlaser : using mouse3 set lasermine on wall<br/>")
		len += formatex(msg[len], SIZE - len, "</body></html>")
		show_motd(id, msg, "Lasermine Entity help")
		return PLUGIN_CONTINUE
	}
	else if (containi(said, "laser") != -1) {
		showInfo(id)
		return PLUGIN_CONTINUE
	}
	return PLUGIN_CONTINUE
}

public standing(id) 
{
	if (!g_settinglaser[id])
		return PLUGIN_CONTINUE

	set_pev(id, pev_maxspeed, 1.0)
//	ShowAmmo(id)

	return PLUGIN_CONTINUE
}

public ltm_PostThink(id) 
{
	if (!g_settinglaser[id] && plsetting[id]){
		resetspeed(id)
	}
	else if (g_settinglaser[id] && !plsetting[id]) {
		pev(id, pev_maxspeed,plspeed[id])
		set_pev(id, pev_maxspeed, 1.0)
	}
	plsetting[id] = g_settinglaser[id]
	return FMRES_IGNORED
}

public ltm_PreThink(id)
{
	if (!is_user_alive(id) || is_user_zombie(id) || g_settinglaser[id] == true || is_user_bot(id))
		return FMRES_IGNORED;

	if(pev(id, pev_button ) & IN_USE && !(pev(id, pev_oldbuttons ) & IN_USE ))
		//client_print(id,print_chat,"test");
		CreateLaserMine_Progress(id)
	return FMRES_IGNORED;
}

resetspeed(id)
{
	set_pev(id, pev_maxspeed, plspeed[id])
}

public client_putinserver(id){
	g_deployed[id] = 0;
	g_havemine[id] = 0;
	DeleteTask(id);
	return PLUGIN_CONTINUE
}

public client_disconnect(id){
	if(!get_pcvar_num( g_LENABLE ))
		return PLUGIN_CONTINUE
	DeleteTask(id);
	RemoveAllTripmines(id);
	return PLUGIN_CONTINUE
}


public newround(id){
	if(!get_pcvar_num( g_LENABLE ))
		return PLUGIN_CONTINUE
	pev(id, pev_maxspeed,plspeed[id])
	DeleteTask(id);
	RemoveAllTripmines(id);
	delaycount();
	SetStartAmmo(id);
	return PLUGIN_CONTINUE
}

public DeathEvent(){
	if(!get_pcvar_num( g_LENABLE ))
		return PLUGIN_CONTINUE

	new id = read_data(2)
	if(is_user_connected(id)) DeleteTask(id);
	return PLUGIN_CONTINUE
}

public RemoveAllTripmines( i_Owner )
{
	new iEnt = g_MaxPL + 1;
	new clsname[32];
	while( ( iEnt = engfunc( EngFunc_FindEntityByString, iEnt, "classname", ENT_CLASS_NAME ) ) )
	{
		if ( i_Owner )
		{
			if( pev( iEnt, LASERMINE_OWNER ) != i_Owner )
				continue;
			clsname[0] = '^0'
			pev( iEnt, pev_classname, clsname, sizeof(clsname)-1 );
                
			if ( equali( clsname, ENT_CLASS_NAME ) )
			{
				PlaySound( iEnt, STOP_SOUND );
				RemoveEntity( iEnt );
			}
		}
		else
			set_pev( iEnt, pev_flags, FL_KILLME );
	}
	g_deployed[i_Owner]=0;
}

SetStartAmmo(id)
{
	new stammo = get_pcvar_num(g_LSTAMMO);
	if(stammo <= 0) return PLUGIN_CONTINUE;
	g_havemine[id] = (g_havemine[id] <= 0) ? stammo : g_havemine[id];
	return PLUGIN_CONTINUE;
}

public CutDeploy_onDamage(id)
{
	if(get_user_health(id) < 1)
		DeleteTask(id);
}

public event_infect2(id)
{
	DeleteTask(id);
	return PLUGIN_CONTINUE
}

DeleteTask(id)
{
	if (task_exists((TASK_PLANT + id)))
	{
		remove_task((TASK_PLANT + id))
	}
	g_settinglaser[id] = false
	return PLUGIN_CONTINUE;
}

stock set_rendering(entity, fx = kRenderFxNone, r = 255, g = 255, b = 255, render = kRenderNormal, amount = 16)
{
	static Float:RenderColor[3];
	RenderColor[0] = float(r);
	RenderColor[1] = float(g);
	RenderColor[2] = float(b);

	set_pev(entity, pev_renderfx, fx);
	set_pev(entity, pev_rendercolor, RenderColor);
	set_pev(entity, pev_rendermode, render);
	set_pev(entity, pev_renderamt, float(amount));

	return 1
}
/* AMXX-Studio Notes - DO NOT MODIFY BELOW HERE
*{\\ rtf1\\ ansi\\ deff0{\\ fonttbl{\\ f0\\ fnil Tahoma;}}\n\\ viewkind4\\ uc1\\ pard\\ lang1038\\ f0\\ fs16 \n\\ par }
*/
