/* AMX Mod script.
*
* Fegyver Menu
*  by Mattcook & xeroblood
*
* Magyarostotta AlleY
*
* Lers: Menn keresztl tudsz fegyvereket adni a jtkosoknak. (Csak adminok hasznlhatjk)
*
* Parancsok:
* amx_weaponmenu
*  vagy
* weaponmenu
*
* Plda:
* bind "f" "amx_weaponmenu"
*
* Info: Ezt a plugin azrt lett ltrehozva, hogy az adminok ingyen tudjanak fegyvereket
* adni a jtkosoknak vagy maguknak.
* A fplugin segtsgvel egy menn keresztl lehet fegyvereket adni.nem kell kln megvenni.
*
* Jvrs:
* xeroblood (Ksznm, hogy sok segtsget nyjtottl nekem a pluginban.)
* F1del1ty (Ksznm a nagyszer tleteket ehez a pluginhoz.)
*
*/

#include <amxmodx>
#include <amxmisc>

// Ez csak akkor szksges, ha az AMX MOD X v1.0 van felteleptve.
// Megjegyzs vagy trld az AMX 0.9.9-es verzijt.
#include <fun>


// Max rtkek felptse a menben.
#define MAX_PLAYERS     32
#define MAX_WEAPONS     24
#define MAX_AMMO        11
#define MAX_ITEMS        8
#define MAX_DISPLAY      8

// Menu tpus indexek.
#define MT_PISTOL        0
#define MT_SHOTGUN       1
#define MT_SMG           2
#define MT_RIFLE         3
#define MT_MACHINE       4
#define MT_PAMMO         5
#define MT_SAMMO         6
#define MT_EQUIP         7
#define MT_EXTRA         8

// Fegyver tpus indexek.
#define OFFSET_SHOTGUN   6
#define OFFSET_SMG       8
#define OFFSET_RIFLE    13
#define OFFSET_MACHINE  23

// Max men belltsa az sszes menben.
// (Machine Gun menben csak 1 lehetsg van ezrt nincs szksg tmbkre.)
#define MO_MAX_MAIN      9
#define MO_MAX_PISTOL    6
#define MO_MAX_SHOTGUN   2
#define MO_MAX_SMG       5
#define MO_MAX_RIFLE    10
#define MO_MAX_EQUIP     8
#define MO_MAX_EXTRA    14


// Fmen szveg
new g_szMainMenuTxt[MO_MAX_MAIN][] = {
"Pisztolyok",
"Shotgunok",
"SMG-k",
"Puskk",
"Machine Guns",
"Elsodleges toltenycsomag",
"Masodlagos toltenycsomag",
"Egyeb felszerelesek",
"Extra menu"
}

// Pisztoly men szvegek
new g_szPistolMenuTxt[MO_MAX_PISTOL][] = {
"USP",
"Glock",
"Deagle",
"228 Compact",
"Dual Elites",
"Five-Seven"
}

//Shotguns Sekci
new g_szShotgunMenuTxt[MO_MAX_SHOTGUN][] = {
"Pumpalos Shotgun",
"Auto Shotgun"
}

//SMG Sekci
new g_szSmgMenuTxt[MO_MAX_SMG][] = {
"MP5",
"TMP",
"C90",
"Mac10",
"UMP"
}

//Puska Sekci
new g_szRifleMenuTxt[MO_MAX_RIFLE][] = {
"Famas",
"Krieg SG552",
"AK47",
"M4A1",
"Bullpup",
"Scout",
"AWP",
"CT Magozo",
"T Magozo",
"Galil"
}

//Machine Guns Sekci
new g_szMachineMenuTxt[] = "M249 (Para)"

//Egyb Sekci
new g_szEquipMenuTxt[MO_MAX_EQUIP][] = {
"Kevlar",
"Kevlar + Helmet",
"Feny granat",
"He granat",
"Fust granat",
"Hatastalanito",
"Ejjellato szemuveg",
"Pajzs"
}

//Extra Sekci
new g_szExtraMenuTxt[MO_MAX_EXTRA][] = {
"Osszes fegyver",
"M3 keszlet",
"MP5 Navy keszlet",
"Famas keszlet",
"Galil keszlet",
"M4A1 keszlet",
"AK47 keszlet",
"Krieg SG552 keszlet",
"Bullpup keszlet",
"M249 keszlet",
"Scout keszlet",
"Magozo Keszlet",
"AWP Keszlet",
"Granat Keszlet"
}

// Fegyverek neve a give_item() parancssorral.
new g_szWeaponList[MAX_WEAPONS][] = {
  "weapon_usp", "weapon_glock18", "weapon_deagle", "weapon_p228", "weapon_elite",
  "weapon_fiveseven", "weapon_m3", "weapon_xm1014", "weapon_mp5navy", "weapon_tmp",
  "weapon_p90", "weapon_mac10", "weapon_ump45", "weapon_famas", "weapon_sg552",
  "weapon_ak47", "weapon_m4a1", "weapon_aug", "weapon_scout", "weapon_awp",
  "weapon_g3sg1", "weapon_sg550", "weapon_galil", "weapon_m249"
}

// Egyeb nevek a give_item() parancssorral.
new g_szItemsList[MAX_ITEMS][] = {
  "item_kevlar", "item_assaultsuit", "weapon_flashbang", "weapon_hegrenade",
  "weapon_smokegrenade", "item_thighpack", "item_nvgs", "weapon_shield"
}

// Toltenycsomag nevek a give_item() parancssorral.
new g_szAmmoList[MAX_AMMO][] = {
  "ammo_45acp", "ammo_9mm", "ammo_50ae", "ammo_357sig",
  "ammo_57mm", "ammo_buckshot", "ammo_556nato", "ammo_762nato",
  "ammo_338magnum", "ammo_308", "ammo_556natobox"
}

new g_nWeaponData[MAX_WEAPONS][2] = {
  { 0, 8 }, { 1, 8 }, { 2, 5 }, { 3, 6 }, { 1, 4 },
  { 4, 4 }, { 5, 4 }, { 5, 4 }, { 1, 4 }, { 1, 4 },
  { 4, 4 }, { 0, 6 }, { 0, 6 }, { 6, 3 }, { 6, 3 },
  { 7, 3 }, { 6, 3 }, { 6, 3 }, { 7, 3 }, { 8, 3 },
  { 7, 3 }, { 6, 3 }, { 9, 3 }, { 10, 7 }
}

// Szamok amik az oldal menuben vagy a Multi-Page menben vannak.  (Mint puskk s a jtkosmen)
// Tbb jtkos is megnyithattya a ment egyszerre gy, hogy nem muszly ugyanazon a tmbn lenni. MAX_PLAYERS (32)
// A plya minden egyes oldaln hasznlhat a men.
// A jtkos nevek benne vannak a menben gy lehet nekik fegyvert adni (1-32 jtkosig). De 1 jtkosnak minimum fent kell lennie,hogy a ment hasznlni tudjk.
// Amikor ebben a tmbben vagy  Plda: g_nMenuPosition[ id - 1 ]
new g_nMenuPosition[MAX_PLAYERS]

// A kijelz meletti.  Klnbz men tpusok: Menu, Pisztolyok, Shotgunok, SMGk, Puskk, stb..
new g_nMenuType[MAX_PLAYERS]

// Szmok amik a menpontokat jellik.
new g_nMenuOption[MAX_PLAYERS]


// A kvetkezt hasznljk a jtkosok. Men kvetse, Jtkos mit vlasztott.
new g_nMenuPlayers[MAX_PLAYERS][MAX_PLAYERS]
new g_nMenuPlayersNum[MAX_PLAYERS]


public plugin_init()
{
    register_plugin( "Fegyver Menu", "1.0", "Mattcook & xeroblood" )

    register_clcmd( "amx_weaponmenu", "ShowWeaponMenu", ADMIN_MENU, "Shows The Weapon Menu" )
    register_clcmd( "weaponmenu", "ShowWeaponMenu", ADMIN_MENU, "Shows The Weapon Menu" )

    register_cvar( "sv_weaponmenu_smoke", "1" ) // Legyen fst grnt?  (1 = Igen, 0 = Nem)
    register_cvar( "sv_weaponmenu_state", "1" ) // Fegyver men visszalltsa
                                                // 0 = Kilps a give_items menbl
                                                // 1 = Vissza a jtkos menhz
                                                // 2 = Vissza a fegyvermenhz

    register_menucmd( register_menuid("Fegyver Menu:"),       1023, "MainMenuCmd" )
    register_menucmd( register_menuid("Pisztoly Menu:"),      1023, "RegularMenuCmd" )
    register_menucmd( register_menuid("Shotgun Menu:"),       1023, "RegularMenuCmd" )
    register_menucmd( register_menuid("SMG Menu:"),           1023, "RegularMenuCmd" )
    register_menucmd( register_menuid("Puska Menu:"),         1023, "RifleMenuCmd" )
    register_menucmd( register_menuid("Machine Gun Menu:"),   1023, "RegularMenuCmd" )
    register_menucmd( register_menuid("Egyeb Menu:"),         1023, "RegularMenuCmd" )
    register_menucmd( register_menuid("Extra Menu:"),         1023, "ExtraMenuCmd" )
    register_menucmd( register_menuid("Jatekos Menu:"),       1023, "PlayerMenuCmd" )

    return PLUGIN_CONTINUE
}

public ShowWeaponMenu( id, lvl, cid )
{
    if( cmd_access( id, lvl, cid, 0 ) )
    {
        g_nMenuPosition[id-1] = 0
        ShowMainMenu( id )
    }
    return PLUGIN_HANDLED
}

///////////////////////////////////////////////////////////////////////////////////////////
//
//      Menu kezelse kdkkal
//
///////////////////////////////////////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////////////////////////////////////
// Kezeli a menut
public MainMenuCmd( id, key )
{
    // Szmok, amivel a men tipusa lett kivlasztva.
    g_nMenuType[id-1] = key

    switch( key )
    {
        case 0: ShowPistolMenu( id )
        case 1: ShowShotgunMenu( id )
        case 2: ShowSmgMenu( id )
        case 3: ShowRifleMenu( id, g_nMenuPosition[id-1] = 0 )
        case 4: ShowMachineMenu( id )
        case 5: ShowPlayerMenu( id, g_nMenuPosition[id-1] = 0 )
        case 6: ShowPlayerMenu( id, g_nMenuPosition[id-1] = 0 )
        case 7: ShowEquipMenu( id )
        case 8: ShowExtraMenu( id, g_nMenuPosition[id-1] = 0 )
        default: { /* Do Nothing Here (Exit Option) */ }
    }
    return PLUGIN_HANDLED
}
//
///////////////////////////////////////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////////////////////////////////////
// Kezeli az sszes fegyver ment, kivve a Multi-Page ment mint pldul a puska men.
public RegularMenuCmd( id, key )
{
    // Szmok amelyek a belltsban lettek kivlasztva.
    g_nMenuOption[id-1] = key

    switch( key )
    {
        case 9:
        {
            // A felhasznl gy dnttt, hogy visszamegy az elz menbe.
            ShowMainMenu( id )
        }
        default: ShowPlayerMenu( id, g_nMenuPosition[id-1] = 0 )
    }
    return PLUGIN_HANDLED
}
//
///////////////////////////////////////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////////////////////////////////////
// Kezeli a Multi-Page s a Puskk ment
public RifleMenuCmd( id, key )
{
    // Szmok amelyek a belltsban lettek kivlasztva.
    g_nMenuOption[id-1] = g_nMenuPosition[id-1] * MAX_DISPLAY + key

    switch( key )
    {
        case 8:
        {
            // Felhasznl ltal kivlasztott "Tovbb..." opci
            ShowRifleMenu( id, ++g_nMenuPosition[id-1] )
        }
        case 9:
        {
            // A felhasznl gy dnttt, hogy visszamegy az elz menbe.
            if( g_nMenuPosition[id-1] )
            {
                ShowRifleMenu( id, --g_nMenuPosition[id-1] )
            }else
            {
                ShowMainMenu( id )
            }
        }
        default: ShowPlayerMenu( id, g_nMenuPosition[id-1] = 0 )
    }
    return PLUGIN_HANDLED
}
//
///////////////////////////////////////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////////////////////////////////////
// Kezeli a Multi-Page s a jtkos ment
public PlayerMenuCmd( id, key )
{
    switch( key )
    {
        case 8:
        {
            // Felhasznl ltal kivlasztott "Tovbb..." opci
            ShowPlayerMenu( id, ++g_nMenuPosition[id-1] )
        }
        case 9:
        {
            // A felhasznl gy dnttt, hogy visszamegy az elz menbe.
            if( g_nMenuPosition[id-1] )
            {
                ShowPlayerMenu( id, --g_nMenuPosition[id-1] )
            }else
            {
                ShowMainMenu( id )
            }
        }
        default:
        {
            // Megkeress, hogy melyik jtkost vlasszk
            new nPlayerID = g_nMenuPlayers[id-1][g_nMenuPosition[id-1] * MAX_DISPLAY + key]

            // Adja hozz a jtkoshoz a kivlasztott elemet
            GiveMenuItem( id, nPlayerID )

            // Ellenrizze, hogy melyik men a Re-Open (ha van ilyen)
            switch( clamp(get_cvar_num("sv_weaponmenu_state"), 0, 2) )
            {
                case 1: ShowPlayerMenu( id, g_nMenuPosition[id-1] ) // Jtkos Menu (Rgi pozci)
                case 2: ShowMainMenu( id ) // Fegyver Menu
            }
        }
    }
    return PLUGIN_HANDLED
}
//
///////////////////////////////////////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////////////////////////////////////
// Kezeli a Multi-Page s az Extra ment
public ExtraMenuCmd( id, key )
{
    // Szmok amelyek a belltsban lettek kivlasztva.
    g_nMenuOption[id-1] = g_nMenuPosition[id-1] * MAX_DISPLAY + key

    switch( key )
    {
        case 8:
        {
            // Felhasznl ltal kivlasztott "Tovbb..." opci
            ShowExtraMenu( id, ++g_nMenuPosition[id-1] )
        }
        case 9:
        {
            // A felhasznl gy dnttt, hogy visszamegy az elz menbe.
            if( g_nMenuPosition[id-1] )
            {
                ShowExtraMenu( id, --g_nMenuPosition[id-1] )
            }else
            {
                ShowMainMenu( id )
            }
        }
        default: ShowPlayerMenu( id, g_nMenuPosition[id-1] = 0 )
    }
    return PLUGIN_HANDLED
}
//
///////////////////////////////////////////////////////////////////////////////////////////


///////////////////////////////////////////////////////////////////////////////////////////
//
//      Men felptse kdokbl
//
///////////////////////////////////////////////////////////////////////////////////////////


///////////////////////////////////////////////////////////////////////////////////////////
// A Men felptsi szakaszai
public ShowMainMenu( id )
{
    new i, nLen, nKeys = (1<<9)
    new szMenuBody[256]

    nLen = format( szMenuBody, 255, "\yFegyver Menu:\w^n" )
    for( i = 0; i < MO_MAX_MAIN; i++ )
    {
        nKeys |= (1<<i)
        nLen += format( szMenuBody[nLen], (255-nLen), "%d. %s^n", (i+1), g_szMainMenuTxt[i] )
    }
    format( szMenuBody[nLen], (255-nLen), "^n0. Kilepes" )

    show_menu( id, nKeys, szMenuBody, -1 )
    return
}
//
///////////////////////////////////////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////////////////////////////////////
// A pisztoly men felptsi szakaszai
public ShowPistolMenu( id )
{
    new i, nLen, nKeys = (1<<9)
    new szMenuBody[256]

    nLen = format( szMenuBody, 255, "\yPisztoly Menu:\w^n" )
    for( i = 0; i < MO_MAX_PISTOL; i++ )
    {
        nKeys |= (1<<i)
        nLen += format( szMenuBody[nLen], (255-nLen), "%d. %s^n", (i+1), g_szPistolMenuTxt[i] )
    }
    format( szMenuBody[nLen], (255-nLen), "^n0. Vissza" )

    show_menu( id, nKeys, szMenuBody, -1 )
    return
}
//
///////////////////////////////////////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////////////////////////////////////
// A shotgun men felptsi szakaszai
public ShowShotgunMenu( id )
{
    new i, nLen, nKeys = (1<<9)
    new szMenuBody[256]

    nLen = format( szMenuBody, 255, "\yShotgun Menu:\w^n" )
    for( i = 0; i < MO_MAX_SHOTGUN; i++ )
    {
        nKeys |= (1<<i)
        nLen += format( szMenuBody[nLen], (255-nLen), "%d. %s^n", (i+1), g_szShotgunMenuTxt[i] )
    }
    format( szMenuBody[nLen], (255-nLen), "^n0. Vissza" )

    show_menu( id, nKeys, szMenuBody, -1 )
    return
}
//
///////////////////////////////////////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////////////////////////////////////
// Az SMG men felptsi szakaszai
public ShowSmgMenu( id )
{
    new i, nLen, nKeys = (1<<9)
    new szMenuBody[2256]

    nLen = format( szMenuBody, 255, "\ySMG Menu:\w^n" )
    for( i = 0; i < MO_MAX_SMG; i++ )
    {
        nKeys |= (1<<i)
        nLen += format( szMenuBody[nLen], (255-nLen), "%d. %s^n", (i+1), g_szSmgMenuTxt[i] )
    }
    format( szMenuBody[nLen], (255-nLen), "^n0. Vissza" )

    show_menu( id, nKeys, szMenuBody, -1 )
    return
}
//
///////////////////////////////////////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////////////////////////////////////
// A Puska men felptsi szakaszai
public ShowRifleMenu( id, pos )
{
    if( pos < 0 ) return

    new i, j = 0, nStart, nEnd, nLen, nKeys = (1<<9)
    new szMenuBody[512]

    nStart = pos * MAX_DISPLAY

    if( nStart >= MO_MAX_RIFLE )
        nStart = pos = g_nMenuPosition[id-1] = 0

    nLen = format( szMenuBody, 511, "\yPuska Menu:\R%d/2^n\w^n", pos + 1 )

    nEnd = nStart + MAX_DISPLAY
    if( nEnd > MO_MAX_RIFLE ) nEnd = MO_MAX_RIFLE

    for( i = nStart; i < nEnd; i++ )
    {
        nKeys |= (1<<j++)
        nLen += format( szMenuBody[nLen], (511-nLen), "%d. %s^n", j, g_szRifleMenuTxt[i] )
    }

    if( nEnd != MO_MAX_RIFLE )
    {
        format( szMenuBody[nLen], (511-nLen), "^n9. Tovabb...^n0. Vissza" )
        nKeys |= (1<<8)
    }
    else format( szMenuBody[nLen], (511-nLen), "^n0. Back" )

    show_menu( id, nKeys, szMenuBody, -1 )
    return
}
//
///////////////////////////////////////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////////////////////////////////////
// A Machine Gun men felptsi szakaszai
public ShowMachineMenu( id )
{
    new nLen, nKeys = (1<<0|1<<9)
    new szMenuBody[256]

    nLen = format( szMenuBody, 255, "\yMachine Gun Menu:\w^n" )
    nLen += format( szMenuBody[nLen], (255-nLen), "%d. %s^n", 1, g_szMachineMenuTxt )
    format( szMenuBody[nLen], (255-nLen), "^n0. Vissza" )

    show_menu( id, nKeys, szMenuBody, -1 )
    return
}
//
///////////////////////////////////////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////////////////////////////////////
// Az Egyb men felptsi szakaszai
public ShowEquipMenu( id )
{
    new i, nLen, nKeys = (1<<9)
    new szMenuBody[256]

    nLen = format( szMenuBody, 255, "\yEgyeb Menu:\w^n" )
    for( i = 0; i < MO_MAX_EQUIP; i++ )
    {
        nKeys |= (1<<i)
        nLen += format( szMenuBody[nLen], (255-nLen), "%d. %s^n", (i+1), g_szEquipMenuTxt[i] )
    }
    format( szMenuBody[nLen], (255-nLen), "^n0. Vissza" )

    show_menu( id, nKeys, szMenuBody, -1 )
    return
}
//
///////////////////////////////////////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////////////////////////////////////
// Az Extra men felptsi szakaszai
/*
public ShowExtraMenu( id )
{
    new i, nLen, nKeys = (1<<9)
    new szMenuBody[256]

    nLen = format( szMenuBody, 255, "\yExtra Menu:\w^n" )
    for( i = 0; i < MO_MAX_EXTRA; i++ )
    {
        nKeys |= (1<<i)
        nLen += format( szMenuBody[nLen], (255-nLen), "%d. %s^n", (i+1), g_szExtraMenuTxt[i] )
    }
    format( szMenuBody[nLen], (255-nLen), "^n0. Vissza" )

    show_menu( id, nKeys, szMenuBody, -1 )
    return
}*/

public ShowExtraMenu( id, pos )
{
    if( pos < 0 ) return

    new i, j = 0, nStart, nEnd, nLen, nKeys = (1<<9)
    new szMenuBody[512]

    nStart = pos * MAX_DISPLAY

    if( nStart >= MO_MAX_EXTRA )
        nStart = pos = g_nMenuPosition[id-1] = 0

    nLen = format( szMenuBody, 511, "\yExtra Menu:\R%d/2^n\w^n", pos + 1 )

    nEnd = nStart + MAX_DISPLAY
    if( nEnd > MO_MAX_EXTRA ) nEnd = MO_MAX_EXTRA

    for( i = nStart; i < nEnd; i++ )
    {
        nKeys |= (1<<j++)
        nLen += format( szMenuBody[nLen], (511-nLen), "%d. %s^n", j, g_szExtraMenuTxt[i] )
    }

    if( nEnd != MO_MAX_EXTRA )
    {
        format( szMenuBody[nLen], (511-nLen), "^n9. Tovabb...^n0. Vissza" )
        nKeys |= (1<<8)
    }
    else format( szMenuBody[nLen], (511-nLen), "^n0. Vissza" )

    show_menu( id, nKeys, szMenuBody, -1 )
    return
}

//
///////////////////////////////////////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////////////////////////////////////
// A Jatekos men felptsi szakaszai
public ShowPlayerMenu( id, pos )
{
    if( pos < 0 ) return

    get_players( g_nMenuPlayers[id-1], g_nMenuPlayersNum[id-1] )

    new i, j = 0, idx
    new szUserName[32], szMenuBody[512]
    new nStart = pos * MAX_DISPLAY

    if( nStart >= g_nMenuPlayersNum[id-1] )
        nStart = pos = g_nMenuPosition[id-1] = 0

    new nLen = format( szMenuBody, 511, "\yJatekos Menu:\R%d/%d^n\w^n", (pos+1), (g_nMenuPlayersNum[id-1] / MAX_DISPLAY + ((g_nMenuPlayersNum[id-1] % MAX_DISPLAY) ? 1 : 0 )) )
    new nEnd = nStart + MAX_DISPLAY
    new nKeys = (1<<9)

    if( nEnd > g_nMenuPlayersNum[id-1] )
        nEnd = g_nMenuPlayersNum[id-1]

    for( i = nStart; i < nEnd; i++ )
    {
        idx = g_nMenuPlayers[id-1][i]
        get_user_name( idx, szUserName, 31 )

        nKeys |= (1<<j++)
        nLen += format( szMenuBody[nLen], (511-nLen), "%d. %s^n", j, szUserName )
    }

    if( nEnd != g_nMenuPlayersNum[id-1] )
    {
        nKeys |= (1<<8)
        format( szMenuBody[nLen], (511-nLen), "^n9. Tovabb...^n0. Vissza" )
    }
    else format( szMenuBody[nLen], (511-nLen), "^n0. Vissza" )

    show_menu( id, nKeys, szMenuBody )
    return
}
//
///////////////////////////////////////////////////////////////////////////////////////////


///////////////////////////////////////////////////////////////////////////////////////////
//
//      Fegyver adsa kdokbol.
//
///////////////////////////////////////////////////////////////////////////////////////////


///////////////////////////////////////////////////////////////////////////////////////////
//  A kvetkez funkci igazbol az ads.
//
stock GiveMenuItem( id, p_nPlayerID )
{
    new szUserName[32]
    get_user_name( p_nPlayerID, szUserName, 31 )

    switch( g_nMenuType[id-1] )
    {
        case MT_PISTOL:  GivePlayerWeapon( p_nPlayerID, g_nMenuOption[id-1] )
        case MT_SHOTGUN: GivePlayerWeapon( p_nPlayerID, (OFFSET_SHOTGUN + g_nMenuOption[id-1]) )
        case MT_SMG:     GivePlayerWeapon( p_nPlayerID, (OFFSET_SMG + g_nMenuOption[id-1]) )
        case MT_RIFLE:   GivePlayerWeapon( p_nPlayerID, (OFFSET_RIFLE + g_nMenuOption[id-1]) )
        case MT_MACHINE: GivePlayerWeapon( p_nPlayerID, (OFFSET_MACHINE + g_nMenuOption[id-1]) )
        case MT_PAMMO:   GivePrimaryAmmo( p_nPlayerID )
        case MT_SAMMO:   GiveSecondaryAmmo( p_nPlayerID )
        case MT_EQUIP:   GivePlayerItem( p_nPlayerID, g_nMenuOption[id-1] )
        case MT_EXTRA:   GivePlayerExtra( p_nPlayerID, g_nMenuOption[id-1] )
    }
    return
}


stock GivePlayerWeapon( id, nWeaponIdx )
{
    if( !is_user_alive(id) || (nWeaponIdx < 0) || (nWeaponIdx >= MAX_WEAPONS) )
        return // Hibas nev vagy fegyver

    give_item( id, g_szWeaponList[nWeaponIdx] )
    for( new i = 0; i < g_nWeaponData[nWeaponIdx][1]; i++ )
        give_item( id, g_szAmmoList[g_nWeaponData[nWeaponIdx][0]] )

    return
}

stock GivePlayerExtra( id, nExtraIdx )
{
    if( !is_user_alive(id) || (nExtraIdx < 0) || (nExtraIdx >= MO_MAX_EXTRA) )
        return

    new i, j
    switch( nExtraIdx )
    {
        case 0:   // Osszes fegyver adasa a jatekosnak (+tolteny)
        {
            for( i = 0; i < MAX_WEAPONS; i++ )
            {
                give_item( id, g_szWeaponList[i] )
                for( j = 0; j < g_nWeaponData[i][1]; j++ )
                    give_item( id, g_szAmmoList[g_nWeaponData[i][0]] )
            }
        }
        case 1:   // M3 kszlet adsa a jtkosnak
        {
            GivePlayerWeapon( id, 6 )   // [6] = M3
            GivePlayerWeapon( id, 2 )   // [2] = Deagle
            for( i = 1; i < 6; i++ )
                GivePlayerItem( id, i ) // Kevlar, Fny/HE/Fst grnt, Hatstalant
        }
        case 2:   // MP5 navy kszlet adsa a jtkosnak
        {
            GivePlayerWeapon( id, 8 )   // [8] = MP5 Navy
            GivePlayerWeapon( id, 2 )   // [2] = Deagle
            for( i = 1; i < 6; i++ )
                GivePlayerItem( id, i ) // Kevlar, Fny/HE/Fst grnt, Hatstalant
        }
        case 3:   // Famas kszlet adsa a jtkosnak
        {
            GivePlayerWeapon( id, 13 )  // [13] = Clarion (Famas)
            GivePlayerWeapon( id, 2 )   // [2]  = Deagle
            for( i = 1; i < 6; i++ )
                GivePlayerItem( id, i ) // Kevlar, Fny/HE/Fst grnt, Hatstalant
        }
        case 4:   // Galil kszlet adsa a jtkosnak
        {
            GivePlayerWeapon( id, 22 )  // [22] = Galil
            GivePlayerWeapon( id, 2 )   // [2]  = Deagle
            for( i = 1; i < 6; i++ )
                GivePlayerItem( id, i ) // Kevlar, Fny/HE/Fst grnt, Hatstalant
        }
        case 5:   // M4A1 kszlet adsa a jtkosnak
        {
            GivePlayerWeapon( id, 16 )  // [16] = M4A1
            GivePlayerWeapon( id, 2 )   // [2]  = Deagle
            for( i = 1; i < 6; i++ )
                GivePlayerItem( id, i ) // Kevlar, Fny/HE/Fst grnt, Hatstalant
        }
        case 6:   // AK47 kszlet adsa a jtkosnak
        {
            GivePlayerWeapon( id, 15 )  // [15] = AK47
            GivePlayerWeapon( id, 2 )   // [2]  = Deagle
            for( i = 1; i < 6; i++ )
                GivePlayerItem( id, i ) // Kevlar, Fny/HE/Fst grnt, Hatstalant
        }
        case 7:   // SG552 kszlet adsa a jtkosnak
        {
            GivePlayerWeapon( id, 14 )  // [14] = Krieg SG552
            GivePlayerWeapon( id, 2 )   // [2]  = Deagle
            for( i = 1; i < 6; i++ )
                GivePlayerItem( id, i ) // Kevlar, Fny/HE/Fst grnt, Hatstalant
        }
        case 8:   // Bulpup kszlet adsa a jtkosnak
        {
            GivePlayerWeapon( id, 17 )  // [17] = Bullpup
            GivePlayerWeapon( id, 2 )   // [2]  = Deagle
            for( i = 1; i < 6; i++ )
                GivePlayerItem( id, i ) // Kevlar, Fny/HE/Fst grnt, Hatstalant
        }
        case 9:   // M249 kszlet adsa a jtkosnak
        {
            GivePlayerWeapon( id, 23 )  // [23] = M249
            GivePlayerWeapon( id, 2 )   // [2]  = Deagle
            for( i = 1; i < 6; i++ )
                GivePlayerItem( id, i ) // Kevlar, Fny/HE/Fst grnt, Hatstalant
        }
        case 10:   // Scout kszlet adsa a jtkosnak
        {
            GivePlayerWeapon( id, 16 )  // [18] = Scout
            GivePlayerWeapon( id, 2 )   // [2]  = Deagle
            for( i = 1; i < 6; i++ )
                GivePlayerItem( id, i ) // Kevlar, Fny/HE/Fst grnt, Hatstalant
        }
        case 11:   // Magozo kszlet adsa a jtkosnak
        {
            GivePlayerWeapon( id, 20 )    // [20] = CT AutoSniper (G3SG1)
            //GivePlayerWeapon( id, 21 )  // [21] = T AutoSniper (SG550)
            GivePlayerWeapon( id, 2 )     // [2]  = Deagle
            for( i = 1; i < 6; i++ )
                GivePlayerItem( id, i ) // Kevlar, Fny/HE/Fst grnt, Hatstalant
        }
        case 12:   // AWP kszlet adsa a jtkosnak
        {
            GivePlayerWeapon( id, 19 )  // [19] = AWP
            GivePlayerWeapon( id, 2 )   // [2]  = Deagle
            for( i = 1; i < 6; i++ )
                GivePlayerItem( id, i ) // Kevlar, Fny/HE/Fst grnt, Hatstalant
        }
        case 13:   // Granat kszlet adsa a jtkosnak
        {
            for( i = 2; i < 5; i++ )
                GivePlayerItem( id, i ) // Fny/HE/Fst grnt
        }
    }
    return
}

stock GivePlayerItem( id, nItemIdx )
{
    if( !is_user_alive(id) || (nItemIdx < 0) || (nItemIdx >= MAX_ITEMS) )
        return // rvnytelen felhasznl vagy pont

    if( (nItemIdx == 4) && (get_cvar_num("sv_weaponmenu_smoke") < 1) )
        return // Fst grnt korltozott

    if( nItemIdx == 2 ) // 2 feny granat adhat
        give_item( id, g_szItemsList[nItemIdx] )
    give_item( id, g_szItemsList[nItemIdx] )

    return
}

stock GivePrimaryAmmo( id )
{
    new nWeapons[32], nNum, i, j, k
    new szWeaponName[32]

    // Csak elsodleges loszer adhat a fegyverekhez
    get_user_weapons( id, nWeapons, nNum )
    for( i = 0; i < nNum; i++ )
    {
        get_weaponname( nWeapons[i], szWeaponName, 31 )
        for( j = OFFSET_SHOTGUN; j < MAX_WEAPONS; j++ )
        {
            if( equali( szWeaponName, g_szWeaponList[j] ) )
            {
                for( k = 0; k < g_nWeaponData[j][1]; k++ )
                    give_item( id, g_szAmmoList[g_nWeaponData[j][0]] )
            }
        }
    }
    return
}

stock GiveSecondaryAmmo( id )
{
    new nWeapons[32], nNum, i, j, k
    new szWeaponName[32]

    // Csak msodlagos loszer adhat a pisztolyokhoz
    get_user_weapons( id, nWeapons, nNum )
    for( i = 0; i < nNum; i++ )
    {
        get_weaponname( nWeapons[i], szWeaponName, 31 )
        for( j = 0; j < OFFSET_SHOTGUN; j++ )
        {
            if( equali( szWeaponName, g_szWeaponList[j] ) )
            {
                for( k = 0; k < g_nWeaponData[j][1]; k++ )
                    give_item( id, g_szAmmoList[g_nWeaponData[j][0]] )
            }
        }
    }
    return
}
//
//
///////////////////////////////////////////////////////////////////////////////////////////