#include <amxmodx>
#include <amxmisc>
#include <fun>
#include <fakemeta>
#include <zombieplague>
#include <hamsandwich>

#define PLUGIN "[ZP] Class Predator"
#define VERSION "1.0"
#define AUTHOR "TEo"
//Magyarositotta: Ginaa

//Some vars
new g_zclass_Predator, g_maxplayers, g_status
new g_sndInv[] = "predator/predator.wav"
new cvar_ability_time, cvar_invamount, cvar_speed, cvar_infect_hp, cvar_cooldown, cvar_gravity, cvar_icon, cvar_dmg_multi
new Float:g_last[33]
new keys = MENU_KEY_1|MENU_KEY_2|MENU_KEY_3
new g_icon[33][16]
new bool: g_ability[33], bool: g_bind[33] = false, bool: g_use[33]

//Predator Atributes
new const zclass_name[] = { "Predator" }
new const zclass_info[] = { "Invisible + dmg" }
new const zclass_model[] = { "Predator" }
new const zclass_clawmodel[] = { "v_Predator.mdl" }
const zclass_health = 1600
const zclass_speed = 190
const Float:zclass_gravity = 1.0
const Float:zclass_knockback = 1.0

public plugin_init()
{    
    
    cvar_dmg_multi = register_cvar("zp_predator_dmg_multi", "3")
    cvar_ability_time = register_cvar("zp_Predator_ability_long", "10")
    cvar_invamount = register_cvar("zp_Predator_visible_amount", "0")
    cvar_speed = register_cvar("zp_Predator_max_speed", "400")
    cvar_infect_hp = register_cvar("zp_Predator_infect_hp", "300")
    cvar_cooldown = register_cvar("zp_Predator_cooldown", "30")
    cvar_gravity = register_cvar("zp_Predator_gravity", "700")
    cvar_icon = register_cvar("zp_Predator_icon", "1")
    
    register_clcmd("ability","ability", ADMIN_ALL, "bind ^"key^" ^"ability^"")
    register_forward(FM_PlayerPreThink, "fw_ppt")
    register_event("HLTV", "newround", "a", "1=0", "2=0")
    register_event("DeathMsg", "death", "a")
    register_menucmd(register_menuid("Do you want to bind P ability?"), keys, "bind_p")
    RegisterHam( Ham_TakeDamage, "player", "fw_TakeDamage" )
    
    g_status = get_user_msgid("StatusIcon")
}

public plugin_precache()
{
    register_plugin(PLUGIN, VERSION, AUTHOR)
    g_zclass_Predator = zp_register_zombie_class(zclass_name, zclass_info, zclass_model, zclass_clawmodel, zclass_health, zclass_speed, zclass_gravity, zclass_knockback)
    precache_sound(g_sndInv)
}

public zp_user_infected_post(id, infector)
{
    if (zp_get_user_zombie_class(infector) == g_zclass_Predator)
    {
        set_pev(infector, pev_health, float(pev(infector, pev_health) + get_pcvar_num(cvar_infect_hp)))
        set_hudmessage(255, 0, 0, -1.0, 0.45, 0, 0.0, 3.0, 0.01, 0.01, -1)
        show_hudmessage(infector, "+%i HP!", get_pcvar_num(cvar_infect_hp))
    }
    
    if (zp_get_user_zombie_class(id) == g_zclass_Predator)
    {
        g_ability[id] = false
        set_user_rendering(id, kRenderFxNone, 0, 0, 0, kRenderNormal, 255)
        set_user_maxspeed(id, float(zclass_speed))
        set_user_gravity(id, zclass_gravity)
        
        if (!g_bind[id])
        {
            new menu[192]
            format(menu, 191, "Szeretned ha bebindelnenk a kepesseget a P-beture?^n^n1. Igen^n2. Nem^n3. Az E-betuvel szeretnem hasznalni")
            show_menu(id, keys, menu)
        }
    }
}

public zp_user_humanized_post(id)
    if(zp_get_user_zombie_class(id) == g_zclass_Predator)
        ability_end(id)

public bind_p(id, keys)
{
    g_bind[id] = true
    switch(keys)
    {
        case 0:
            client_cmd(id, "bind p ability")
        
        case 1:
            client_print(id, print_chat, "[ZP] A teljes lathatatlansaghoz ird a consolba: bind ^'^'gomb^'^' ^'^'ability^'^'. Es utana nyomd meg a kivalasztott gombot!")
        
        case 2:
            g_use[id] = true
        
        default:
            g_bind[id] = false
    }
    
    return PLUGIN_HANDLED
}

public ability(id)
{
    if (zp_get_user_zombie(id) && (zp_get_user_zombie_class(id) == g_zclass_Predator))
    {
        if(g_ability[id])
        {
            client_print(id, print_chat, "[ZP] Te mar igyis lathatatlan vagy!!")
            return PLUGIN_HANDLED
        }
        
        if(!is_user_alive(id))
        {
            client_print(id, print_chat, "[ZP] Halott vagy.Halottak nem tudjak hasznalni a kepesseget.")
            return PLUGIN_HANDLED
        }
        
        static Float: i
        i = get_pcvar_float(cvar_cooldown)
        
        if (get_gametime() - g_last[id] < i) {
            client_print(id, print_chat, "[ZP] Varj %.f0 masodpercet hogy hasznalhasd a kepesseget!", get_pcvar_float(cvar_cooldown) - (get_gametime() - g_last[id]))
            return PLUGIN_HANDLED
        } else {
            set_user_rendering(id, kRenderFxGlowShell, 0, 0, 0, kRenderTransAlpha, get_pcvar_num(cvar_invamount))
            set_user_maxspeed(id, get_pcvar_float(cvar_speed))
            set_user_gravity(id, get_pcvar_float(cvar_gravity) / 800)
            emit_sound(id, CHAN_BODY, g_sndInv, 1.0, ATTN_NORM, 0, PITCH_HIGH)
            set_hudmessage(200, 100, 0, -1.0, 0.85, 0, 0.0, 3.0, 0.01, 0.01, -1)
            show_hudmessage(id, "You are now invisible. Time to hunt!")
            set_task(get_pcvar_float(cvar_ability_time), "ability_end", id)
            if(get_pcvar_num(cvar_icon) == 1)
                set_icon(id)
            g_ability[id] = true
        }
    }
    return PLUGIN_CONTINUE
}

public ability_end(id)
{
    set_user_rendering(id, kRenderFxNone, 0, 0, 0, kRenderNormal, 255)
    set_user_maxspeed(id, float(zclass_speed))
    set_user_gravity(id, zclass_gravity)
    
    if (get_pcvar_num(cvar_cooldown) > 0)
        client_print(id, print_chat, "[ZP] Varj %i masodpercet,hogy ujra hasznald a kepesseget .", get_pcvar_num(cvar_cooldown))
    
    if(get_pcvar_num(cvar_icon) == 1)
        delete_icon(id)
    
    g_last[id] = get_gametime()
    g_ability[id] = false
}

public fw_ppt(id)
{
    if (!is_user_alive(id) || !zp_get_user_zombie(id))
        return FMRES_IGNORED
    
    if (g_use[id])
    {
        static button, oldbutton
        button = get_user_button(id)
        oldbutton = get_user_oldbutton(id)
        
        if (!(button & IN_USE) && (oldbutton & IN_USE))      
            ability(id)
    }
    
    if (g_ability[id] && (zp_get_user_zombie_class(id) == g_zclass_Predator) && zp_get_user_zombie(id))
    {
        set_user_rendering(id, kRenderFxGlowShell, 0, 0, 0, kRenderTransAlpha, get_pcvar_num(cvar_invamount))
        set_user_maxspeed(id, get_pcvar_float(cvar_speed))
        set_pev(id, pev_flTimeStepSound, 999)
        set_user_gravity(id, get_pcvar_float(cvar_gravity) / 800)
    }
    
    return PLUGIN_CONTINUE
}

public newround()
{
    g_maxplayers = get_maxplayers()
    
    for (new id = 1; id <= g_maxplayers; id++)
    {
        g_last[id] = get_gametime()
        g_ability[id] = false
    }
}

public fw_TakeDamage( victim, inflictor, attacker, Float:damage, damagebits )
{
        if ((zp_get_user_zombie_class(attacker) == g_zclass_Predator) && (get_user_weapon(attacker) == CSW_KNIFE))
        {
                SetHamParamFloat( 4, damage * get_pcvar_float(cvar_dmg_multi) )
        }
}

public death()
{
    new id = read_data(2)
    ability_end(id)
    return PLUGIN_HANDLED
}

public set_icon(id)
{
    static color[3], sprite[16]
    color = {250, 250, 250}
    sprite = "dmg_gas"
    g_icon[id] = sprite
    
    message_begin(MSG_ONE, g_status, {0, 0, 0}, id)
    write_byte(1)
    write_string(g_icon[id])
    write_byte(color[0])
    write_byte(color[1])
    write_byte(color[2])
    message_end()
}

public delete_icon(id) 
{
    message_begin(MSG_ONE, g_status, {0, 0, 0}, id)
    write_byte(0)
    write_string(g_icon[id])
    message_end()
}

stock get_user_button(id)
    return pev(id, pev_button)

stock get_user_oldbutton(id)
    return pev(id, pev_oldbuttons)  
/* AMXX-Studio Notes - DO NOT MODIFY BELOW HERE
*{\\ rtf1\\ ansi\\ deff0{\\ fonttbl{\\ f0\\ fnil Tahoma;}}\n\\ viewkind4\\ uc1\\ pard\\ lang1034\\ f0\\ fs16 \n\\ par }
*/
