#include <amxmodx>
#include <hamsandwich>
#include <zombieplague>
#include <fakemeta>
/*		WereWolf Zombie
			by x[L]eoNNN
		
		#Description :
		
		this is a Zombie Class of Famous Game, "L4d" with the ability to throw rocks at enemies,
		either killing him, infecting taking life, etc. (controlled by a cvar)
		
		this is a Zombie Class that is Werewolf, alone which can be killed by silver bullets
		that are bought extra item
		
		#Cvars :
		
		zp_sb_oneround 1 // one round bullets
		zp_silver_bullets 30 // silver bullets
		zp_werewolf_killreward_enable 1 // 1 = enable ammo packs reward / 0 = disable
		zp_werewolf_killreward  4 // ammo packs reward for kill a werewolf
		zp_sb_effect 1 // silver bullets effect
		zp_werewolf_howling 1 // enable werewolf howling
		zp_werewolf_howling_time 5.0 // werewolf howling time
		zp_werewolf_howling_dontmove 1 // dont move in howling
		
		#Changelog :
		
		v1.0: public release

*/
new const zclass_name[] = { "WereWolf" } // name
new const zclass_info[] = { "Only it can be killed by silver bullets" } // description
new const zclass_model[] = { "zm_werewolf" } // model
new const zclass_clawmodel[] = { "v_werewolf.mdl" } // claw model
const zclass_health = 800 // health
const zclass_speed = 200 // speed
const Float:zclass_gravity = 1.0 // gravity
const Float:zclass_knockback = 0.6 // knockback

new const howling_sounds[][] = { "zm_werewolf/werewolf1.wav", "zm_werewolf/werewolf2.wav" }
new const silver_bullets_sprite[] = "sprites/dot.spr" // silver bullets sprite

new cvar_oneround, cvar_sb, cvar_rewardenable, cvar_reward, cvar_sb_effect, cvar_howling, cvar_dontmove,
cvar_howlingtime, cvar_lasthowling, cvar_damage

new g_SBItemID, g_SBSpr, g_werewolf
new bool: g_PlayerHaveSB[33], g_SilverBullets[33]
new Float:g_last_howling[33]

public plugin_init()
{
	register_plugin("[ZP] Zombie Class: Werewolf Zombie", "1.0", "xLeoNNN") 
	register_event("CurWeapon", "event_CurWeapon", "be", "1=1", "3>0")
	
	RegisterHam(Ham_Spawn, "player", "fw_PlayerSpawn_Post", 1)
	RegisterHam(Ham_Killed, "player", "fw_PlayerKilled")
	RegisterHam(Ham_TakeDamage, "player", "fw_TakeDamage")
	
	register_forward(FM_CmdStart, "CmdStart" )
	
	g_SBItemID = zp_register_extra_item("Buy Silver Bullets", 15, ZP_TEAM_HUMAN)
	
	cvar_oneround = register_cvar("zp_sb_oneround", "1")
	cvar_sb = register_cvar("zp_silver_bullets", "30")
	cvar_rewardenable = register_cvar("zp_werewolf_killreward_enable", "1")
	cvar_reward = register_cvar("zp_werewolf_killreward", "4")
	cvar_sb_effect = register_cvar("zp_sb_effect", "1")
	cvar_howling = register_cvar("zp_werewolf_howling", "1")
	cvar_howlingtime = register_cvar("zp_werewolf_howling_time", "5.0")
	cvar_dontmove = register_cvar("zp_werewolf_howling_dontmove", "1")
	cvar_lasthowling = register_cvar( "zp_werewolf_last_howling_time", "20.0" )
	cvar_damage = register_cvar("zp_werewolf_damage","0.5")
}

public plugin_precache()
{
	g_werewolf = zp_register_zombie_class(zclass_name, zclass_info, zclass_model, zclass_clawmodel, zclass_health, zclass_speed, zclass_gravity, zclass_knockback) 
	g_SBSpr = precache_model(silver_bullets_sprite)
	static i
	for(i = 0; i < sizeof howling_sounds; i++)
		precache_sound(howling_sounds[i])
}


public zp_user_infected_post ( id, infector )
{
	if (zp_get_user_zombie_class(id) == g_werewolf)
	{
		print_chatColor(id, "\g[ZP]\n Kivalasztottad a  \gVerfarkas\n fajt, csak ezust golyoval tudnak megolni!!") 
	}
	g_PlayerHaveSB[id] = false
	g_SilverBullets[id] = false
}  

public zp_user_humanized_post(id)
{
	g_PlayerHaveSB[id] = false
	g_SilverBullets[id] = false
}

public zp_extra_item_selected(id, itemid)
{
	if (itemid == g_SBItemID)
	{
		print_chatColor(id, "\g[ZP]\n Vettel ezust golyokat!Meg tudod olni a  \gverfarkasokat\n!!!")
		g_PlayerHaveSB[id] = true
		g_SilverBullets[id] = get_pcvar_num(cvar_sb)
	}
}

public fw_PlayerKilled(victim, attacker, shouldgib)
{
	g_PlayerHaveSB[victim] = false
	g_SilverBullets[victim] = false
	
	if(g_PlayerHaveSB[attacker] && zp_get_user_zombie_class(victim) == g_werewolf)
	{
		if(get_pcvar_num(cvar_rewardenable))
		{
			print_chatColor(attacker, "\g[ZP]\n Kaptal \t%d\n loszercsomagot mert megoltel egy verfarkast!", get_pcvar_num(cvar_reward))
			zp_set_user_ammo_packs(attacker, zp_get_user_ammo_packs(attacker) + get_pcvar_num(cvar_reward))
		}
	}    
}

public client_connect(id)
{
	g_PlayerHaveSB[id] = false
	g_SilverBullets[id] = false
}

public client_disconnect(id)
{
	g_PlayerHaveSB[id] = false
	g_SilverBullets[id] = false
}

public fw_PlayerSpawn_Post(id)
{
	if (!is_user_alive(id))
		return;
	
	if(get_pcvar_num(cvar_oneround))
	{
		g_PlayerHaveSB[id] = false
		g_SilverBullets[id] = false
	}
}

public fw_TakeDamage(victim, inflictor, attacker, Float:damage, damage_type)
{
	if(!g_PlayerHaveSB[attacker] && zp_get_user_zombie_class(victim) == g_werewolf)
	{
		new Float: dmg;
		
		dmg = get_pcvar_float(cvar_damage)
		
		SetHamParamFloat(4, damage*dmg)
		return HAM_SUPERCEDE
	}
	else
		if(get_user_weapon(attacker) == CSW_KNIFE)
			if(zp_get_user_zombie_class(victim) == g_werewolf)
				return HAM_SUPERCEDE
	
	return HAM_IGNORED
}

public CmdStart( const id, const uc_handle, random_seed )
{
	if(!is_user_alive(id))
		return FMRES_IGNORED;
	
	if(!zp_get_user_zombie(id) || zp_get_user_nemesis(id))
		return FMRES_IGNORED;
	
	new button = pev(id, pev_button)
	new oldbutton = pev(id, pev_oldbuttons)
	
	if (zp_get_user_zombie(id) && zp_get_user_zombie_class(id) == g_werewolf)
	{
		if(oldbutton & IN_RELOAD && !(button & IN_RELOAD))
		{
			if( get_gametime() - g_last_howling[id] < get_pcvar_float(cvar_lasthowling))
			{
				print_chatColor(id, "\g[ZP]\n Varnod kell %.f0 masodpercet hogy ujra uvolthess!", get_pcvar_float(cvar_lasthowling) - (get_gametime() - g_last_howling[id]))
				return PLUGIN_HANDLED
			}
			
			g_last_howling[id] = get_gametime()
			
			if(get_pcvar_num(cvar_howling))
			{
				emit_sound(id, CHAN_STREAM, howling_sounds[random_num(0, sizeof howling_sounds - 1)], 1.0, ATTN_NORM, 0, PITCH_HIGH )
				if(get_pcvar_num(cvar_dontmove))
				{
					set_pev(id , pev_velocity , { 0.0 , 0.0 , 0.0 } )
					set_pev(id, pev_flags, pev(id, pev_flags) | FL_FROZEN) 
					set_task(get_pcvar_float(cvar_howlingtime), "set_vel", id)
				}
			}
		}
	}
	return FMRES_IGNORED
}

public set_vel(id)
	set_pev(id , pev_flags , pev(id , pev_flags) & ~FL_FROZEN)

public event_CurWeapon(id)
{
	new buttons = pev(id, pev_button)
	new oldbuttons = pev(id, pev_oldbuttons)
	
	if(buttons & IN_ATTACK || oldbuttons & IN_ATTACK)
	{
		if (g_SilverBullets[id] > 0 && g_PlayerHaveSB[id] ) 
		{
			if(get_pcvar_num(cvar_sb_effect))
			{
				static Origin[3], Origin2[3]
				get_user_origin(id, Origin, 1) 
				get_user_origin(id, Origin2, 4) 
				
				message_begin(MSG_BROADCAST,SVC_TEMPENTITY)
				write_byte (0)     
				write_coord(Origin[0])
				write_coord(Origin[1])
				write_coord(Origin[2])
				write_coord(Origin2[0])
				write_coord(Origin2[1])
				write_coord(Origin2[2])
				write_short(g_SBSpr)
				write_byte(1) 
				write_byte(5) 
				write_byte(2) 
				write_byte(10) 
				write_byte(0) 
				write_byte(132)     
				write_byte(132)       
				write_byte(132)
				write_byte(200) 
				write_byte(150) 
				message_end()
			}
			
			g_SilverBullets[id]--
		}
	}
	if(g_SilverBullets[id] <= 0)
	{
		g_PlayerHaveSB[id] = false
		g_SilverBullets[id] = 0
	}
}


stock print_chatColor(const id,const input[], any:...)
{
	new msg[191], players[32], count = 1;
	vformat(msg,190,input,3);
	replace_all(msg,190,"\g","^4");// zold
	replace_all(msg,190,"\n","^1");// normal
	replace_all(msg,190,"\t","^3");// csapatszin
	
	if (id) players[0] = id; else get_players(players,count,"ch");
	for (new i=0;i<count;i++)
		if (is_user_connected(players[i]))
	{
		message_begin(MSG_ONE_UNRELIABLE,get_user_msgid("SayText"),_,players[i]);
		write_byte(players[i]);
		write_string(msg);
		message_end();
	}
}  
/* AMXX-Studio Notes - DO NOT MODIFY BELOW HERE
*{\\ rtf1\\ ansi\\ deff0{\\ fonttbl{\\ f0\\ fnil Tahoma;}}\n\\ viewkind4\\ uc1\\ pard\\ lang1034\\ f0\\ fs16 \n\\ par }
*/
