#include <amxmodx>
#include <engine>
#include <fakemeta>
#include <zombieplague>


new const PLUGIN[]  = "[ZP] Class Legy";
new const VERSION[] = "1.0";
new const AUTHOR[]  = "VirTuaL .";


new g_zclass_legy
new bool:has_jp[33];

new const CVAR_JP_SPEED[]  = "jp_speed";


// Fly Zombie Attributes
new const zclass_name[] = { "Legy Zombi" } // name
new const zclass_info[] = { "\rRepul,Kicsi Modell,100 HP" } // description
new const zclass_model[] = { "class_legy" } // model
new const zclass_clawmodel[] = { "v_knife_legy.mdl" } // claw model
const zclass_health = 100 // health
const zclass_speed = 250 // speed
const Float:zclass_gravity = 0.6 // gravity
const Float:zclass_knockback = 2.0 // knockback


public plugin_init()
{
	register_plugin(PLUGIN , VERSION , AUTHOR);
	register_cvar(CVAR_JP_SPEED    , "250");
}

public plugin_precache()
{
	g_zclass_legy = zp_register_zombie_class(zclass_name, zclass_info, zclass_model, zclass_clawmodel, zclass_health, zclass_speed, zclass_gravity, zclass_knockback)
	
}

public client_PreThink(id) 
{
	if(!is_user_alive(id) || !zp_get_user_zombie(id)) return PLUGIN_CONTINUE
	if(zp_get_user_zombie_class(id) != g_zclass_legy) return PLUGIN_CONTINUE
	
	new Float:fAim[3] , Float:fVelocity[3];
	VelocityByAim(id , get_cvar_num(CVAR_JP_SPEED) , fAim);
	
	if(!(get_user_button(id) & IN_JUMP))
	{
		fVelocity[0] = fAim[0];
		fVelocity[1] = fAim[1];
		fVelocity[2] = fAim[2];

		set_user_velocity(id , fVelocity);
		fm_set_rendering(id, kRenderFxGlowShell, 255, 0, 0, kRenderNormal, 16);
	}
	return PLUGIN_CONTINUE;
}


// User Infected forward
public zp_user_infected_post(id, infector)
{		
	if (zp_get_user_zombie_class(id) == g_zclass_legy)
	{
		client_print(id,print_chat,"[ZP] Te Legy Zombi vagy!")
		has_jp[id] = true
	}	
}

// Set entity's rendering type (from fakemeta_util)
stock fm_set_rendering(entity, fx = kRenderFxNone, r = 255, g = 255, b = 255, render = kRenderNormal, amount = 16)
{
	static Float:color[3]
	color[0] = float(r)
	color[1] = float(g)
	color[2] = float(b)
	
	set_pev(entity, pev_renderfx, fx)
	set_pev(entity, pev_rendercolor, color)
	set_pev(entity, pev_rendermode, render)
	set_pev(entity, pev_renderamt, float(amount))
}