#include <amxmodx> 
#include <engine> 
#include <xs> 
#include <zombieplague> 

#define PLUGIN "Nemesis Spr" 
#define VERSION "0.1" 
#define AUTHOR "GoOleM" 

new Float:g_fDelay[33] 
new nemesis_sprite 
new cvar_maxdistance 
new cvar_updatedelay 

public plugin_init() 
{ 
    register_plugin(PLUGIN, VERSION, AUTHOR) 
    cvar_maxdistance = register_cvar("zp_survsprite_distance",  "5000") 
    cvar_updatedelay = register_cvar("zp_survsprite_updatedelay", "1.0") 
} 

public plugin_precache() 
{ 
    nemesis_sprite = precache_model("sprites/nemesis.spr") 
} 

public client_PreThink(id) 
{ 
    if(!is_user_alive(id)) 
    return PLUGIN_CONTINUE 

    if((g_fDelay[id] + get_pcvar_float(cvar_updatedelay)) > get_gametime()) 
    return PLUGIN_CONTINUE 

     
    g_fDelay[id] = get_gametime() 
     

    new Float:fMyOrigin[3] 
    entity_get_vector(id, EV_VEC_origin, fMyOrigin) 

    static Players[32], iNum 
    get_players(Players, iNum, "a") 
    for(new i = 0; i < iNum; ++i) if(id != Players[i]) 
    { 
    new target = Players[i] 
         
    if(!zp_get_user_nemesis(target)) 
    continue 
     
    new Float:fTargetOrigin[3] 
    entity_get_vector(target, EV_VEC_origin, fTargetOrigin) 

         
    if((get_distance_f(fMyOrigin, fTargetOrigin) > get_pcvar_num(cvar_maxdistance))  
    || !is_in_viewcone(id, fTargetOrigin)) 
    continue 
         
    new Float:fMiddle[3], Float:fHitPoint[3] 
    xs_vec_sub(fTargetOrigin, fMyOrigin, fMiddle) 
    trace_line(-1, fMyOrigin, fTargetOrigin, fHitPoint) 
         
    new Float:fWallOffset[3], Float:fDistanceToWall 
         
    fDistanceToWall = vector_distance(fMyOrigin, fHitPoint) - 10.0 
    normalize(fMiddle, fWallOffset, fDistanceToWall) 
     
    new Float:fSpriteOffset[3] 
    xs_vec_add(fWallOffset, fMyOrigin, fSpriteOffset) 
    new Float:fScale, Float:fDistanceToTarget = vector_distance(fMyOrigin, fTargetOrigin) 
    if(fDistanceToWall > 100.0) 
    fScale = 8.0 * (fDistanceToWall / fDistanceToTarget) 
    else 
         fScale = 2.0 
     te_sprite(id, fSpriteOffset, nemesis_sprite, floatround(fScale), 125) 
    } 
    return PLUGIN_CONTINUE 
} 

stock te_sprite(id, Float:origin[3], sprite, scale, brightness) 
{ 
    message_begin(MSG_ONE, SVC_TEMPENTITY, _, id) 
    write_byte(TE_SPRITE) 
    write_coord(floatround(origin[0])) 
    write_coord(floatround(origin[1])) 
    write_coord(floatround(origin[2])) 
    write_short(sprite) 
    write_byte(scale)  
    write_byte(brightness) 
    message_end() 
} 

stock normalize(Float:fIn[3], Float:fOut[3], Float:fMul) 
{ 
    new Float:fLen = xs_vec_len(fIn) 
    xs_vec_copy(fIn, fOut) 

    fOut[0] /= fLen, fOut[1] /= fLen, fOut[2] /= fLen 
    fOut[0] *= fMul, fOut[1] *= fMul, fOut[2] *= fMul 
} 