#include <amxmodx>
#include <amxmisc>
#include <zombieplague>

#define PLUGIN 	"[ZP] Addon: APs Leader"
#define VERSION "1.2"
#define AUTHOR	"Kiske"

// Cvars
new leader_msj

// Others
new MaxPlayers, SayText

public plugin_init()
{
	register_plugin(PLUGIN, VERSION, AUTHOR)
	
	// Language Files
	register_dictionary("aps_leader.txt")
	
	// Cvars
	leader_msj = register_cvar("zp_leader_msj", "3")
	
	// Client Commands
	register_clcmd("say /vezeto", "CheckLeader")
	register_clcmd("say_team /vezeto", "CheckLeader")
	
	// Event
	register_event("HLTV", "RoundStart", "a", "1=0", "2=0")
	
	// Others
	SayText = get_user_msgid("SayText")
	MaxPlayers = get_maxplayers()
}

public RoundStart()
{
	if ( get_pcvar_num(leader_msj) == 1 || get_pcvar_num(leader_msj) == 3 )
		set_task(2.2, "Leader") // I use this set_task to the message appears then of "welcome_msg"
}

public Leader()
{
	if ( get_pcvar_num(leader_msj) == 1 || get_pcvar_num(leader_msj) == 3 )
	{
		new iAmmoPacks
		new iLeader = GetLeader(iAmmoPacks)
		new Players = UsersGetPlaying()
		new iPlayers[32], iNum, Others
		new szName[32]
		get_user_name( iLeader, szName, 31 )
		get_players( iPlayers, iNum, "ch" )
		
		for ( new i = 0; i < iNum; i++ )
			Others = zp_get_user_ammo_packs(i)
	
		if ( Players == 0 )
			ChatColor( 0, "%L", LANG_PLAYER, "NO_PLAYERS" )
		else if ( iAmmoPacks == Others )
			ChatColor( 0, "%L", LANG_PLAYER, "MORE_LEADERS" )
		else
			ChatColor( 0, "%L", LANG_PLAYER, "LEADER", szName, iAmmoPacks )
	}
}

// Check Leader
public CheckLeader(id)
{
	if ( get_pcvar_num(leader_msj) == 2 || get_pcvar_num(leader_msj) == 3 )
	{
		new iAmmoPacks
		new iLeader = GetLeader(iAmmoPacks)
		new Players = UsersGetPlaying()
		new iPlayers[32], iNum, Others
		new szName[32]
		get_user_name( iLeader, szName, 31 )
		get_players( iPlayers, iNum, "ch" )
		
		for ( new i = 0; i < iNum; i++ )
			Others = zp_get_user_ammo_packs(i)
			
		if ( Players == 0 )
			ChatColor( id, "%L", LANG_PLAYER, "NO_PLAYERS" )
		else if ( iAmmoPacks == Others )
			ChatColor( id, "%L", LANG_PLAYER, "MORE_LEADERS" )
		else
			ChatColor( id, "%L", LANG_PLAYER, "LEADER", szName, iAmmoPacks )
	}
	
	return PLUGIN_HANDLED;
}

GetLeader( &iAmmoPacks )
{
	new iPlayers[32], iNum, id, i, iLeader, iPacks
	get_players( iPlayers, iNum, "ch" )
	
	for ( i = 0; i < iNum; i++ )
	{
		id = iPlayers[i]
		iPacks = zp_get_user_ammo_packs(id)
		
		if ( iPacks > iAmmoPacks )
		{
			iAmmoPacks = iPacks
			iLeader = id
		}
	}
	return iLeader;
}

// ChatColor!
stock ChatColor(const id, const input[], any:...)
{
	new count = 1, players[32]
	static msg[191]
	vformat(msg, 190, input, 3)
	
	replace_all(msg, 190, "!g", "^4") // Green Color
	replace_all(msg, 190, "!y", "^1") // Default Color
	replace_all(msg, 190, "!t", "^3") // Team Color
	
	if (id) players[0] = id; else get_players(players, count, "ch") 
	{
		for ( new i = 0; i < count; i++ )
		{
			if ( is_user_connected(players[i]) )
			{
				message_begin(MSG_ONE_UNRELIABLE, SayText, _, players[i])
				write_byte(players[i]);
				write_string(msg);
				message_end();
			}
		}
	}
}

// Users Get Playing (Stock from the ZP)
UsersGetPlaying()
{
	static iPlaying, id
	iPlaying = 0
	
	for ( id = 1; id <= MaxPlayers; id++ )
	{
		if ( is_user_connected(id) )
		{
			if ( get_user_team(id) == 1 || get_user_team(id) == 2 )
				iPlaying++
		}
	}
	
	return iPlaying;
}