/*
This plugin was created first by Alka with specific sound !
It was necesar to precache the sound and to be downloaded
by clients.

This version modified by me it using vox sounds that plays the
health and armour of your killer and does not require any
precache.

Credits:

Alka	- Using his color stock for color chat print (new version)
- Creating the plugin (main ideea & work) and can be found
here: http://forums.alliedmods.net/showthread.php?t=52458

The new version (this plugin) can be found on Allied Modds Forum
here: http://forums.alliedmods.net/showthread.php?t=89384

Available CVAR's:
amx_chatmsg_killer "1"			// Enable/Disable chat message for killer (Def: 1 - ON)
amx_chatmsg_victim "1"			// Enable/Disable chat message for victim (Def: 1 - ON)
amx_play_sound "0"			// Enable/Disable vox sound for victim (Def: 1 - ON)

*/

#include <amxmodx>
#include <amxmisc>

#define VERSION "2.7"

new g_ChatKiller, g_ChatVictim, g_Sound, g_SayText, g_MaxClients


public plugin_init()
{
	/* Register plugin */
	register_plugin("Kill Message w/ VOX", VERSION, "God@Dorin");
	
	/* Register plugin version */
	register_cvar("chatmsg_version", VERSION, FCVAR_SERVER|FCVAR_SPONLY);
	set_cvar_string("chatmsg_version", VERSION);
	
	/* Register Death Event */
	register_event("DeathMsg", "event_death", "a");
	
	/* Register Language file */
	register_dictionary("kill_chat_message.txt");
	
	/* Register cvars */
	g_ChatKiller = register_cvar("amx_chatmsg_killer","1");	
	g_ChatVictim = register_cvar("amx_chatmsg_victim","1");
	g_Sound = register_cvar("amx_play_sound","0");
	g_MaxClients = get_maxplayers()
	
	g_SayText = get_user_msgid("SayText");
}

public event_death()
{
	new killer = read_data(1);
	new victim = read_data(2);
	
	if ( !( 1 <= killer <= g_MaxClients ) || killer == victim )
	{
		return PLUGIN_CONTINUE;
	}
	
	new vicname[32], killname[32]
	new frags = get_user_frags(killer);
	new armor = get_user_armor(killer);
	new health = get_user_health(killer);
	get_user_name(victim,vicname,31);
	get_user_name(killer,killname,31);
	
	if(get_pcvar_num(g_ChatKiller) ==1)
	{
		client_printc(killer,"%L", killer, "KILL_MSG_VIC", vicname);
	}	
	
	if(get_pcvar_num(g_ChatVictim) ==1)
	{	
		client_printc(victim,"%L", victim, "KILL_MSG_KILL", killname, health, armor, frags+1);
	}
	
	if(get_pcvar_num(g_Sound) ==1)
	{
		new healthstr[21], armorstr[21]
		num_to_word(health, healthstr, 20);
		num_to_word(armor, armorstr, 20);
		
		client_cmd(victim, "spk ^"vox/%s health and %s armor^"", healthstr, armorstr)
	}
	return PLUGIN_CONTINUE;
}
stock client_printc(const id, const string[], {Float, Sql, Resul,_}:...) {
	
	new msg[191], players[32], count = 1;
	vformat(msg, sizeof msg - 1, string, 3);
	
	replace_all(msg,190,"!g","^4");
	replace_all(msg,190,"!y","^1");
	replace_all(msg,190,"!t","^3");
	
	if(id)
		players[0] = id;
	else
		get_players(players,count,"ch");
	
	for (new i = 0 ; i < count ; i++)
	{
		if (is_user_connected(players[i]))
		{
			message_begin(MSG_ONE_UNRELIABLE, g_SayText,_, players[i]);
			write_byte(players[i]);
			write_string(msg);
			message_end();
		}		
	}
}
