#include <amxmodx>
#include <amxmisc>
#include <fun>
#include <engine>

//Used for create_middle functions
#define tag_sprite_size_horizontal	4000
#define tag_sprite_size_vertical	600
#define tag_sprite_vertical_increments	15

#define MINNUM		2

new bool:stopplugin

new beamsprite

new CTspawn_loc[3]
new Tspawn_loc[3]

new plugin_enabled, plugin_fence, plugin_2ppl, plugin_checktime, plugin_redrawtime, plugin_fencecolor, plugin_fencealpha, plugin_punishment

new Float:farthest_point1[3]
new Float:farthest_point2[3]
new alivenum, maxplayers

new Float:oldtime

new multiplier

public plugin_init()
{
	register_plugin("No Rush","2.0","GHW_Chronic")

	plugin_enabled = register_cvar("NR_enabled","1")
	plugin_fence = register_cvar("NR_fence","1")
	plugin_2ppl = register_cvar("NR_twopeople","1")
	plugin_punishment = register_cvar("NR_punishment","1")
	plugin_checktime = register_cvar("NR_checktime","2.0")
	plugin_redrawtime = register_cvar("NR_redrawtime","15.0")
	plugin_fencecolor = register_cvar("NR_fencecolor","green")
	plugin_fencealpha = register_cvar("NR_fencealpha","200")

	stopplugin=true
	new mapname[32]
	get_mapname(mapname,31)
	new configfile[200]
	get_configsdir(configfile,199)
	format(configfile,199,"%s/no_rush_maps.ini",configfile)
	if(file_exists(configfile))
	{
		new read[32], trash
		for(new i=0;i<file_size(configfile,1);i++)
		{
			read_file(configfile,i,read,31,trash)
			if(equali(mapname,read))
			{
				set_task(0.1,"spawn_locs")
				set_task(0.2,"create_middle1")
				oldtime = get_pcvar_float(plugin_redrawtime)
				stopplugin=false
				break;
			}
		}
	}

	register_event("DeathMsg","checknum","a")
	register_event("ResetHUD","checknum","b")

	maxplayers = get_maxplayers()
}

public plugin_precache()
{
	beamsprite = precache_model("sprites/dot.spr")
}

public client_putinserver(id)
{
	if(!stopplugin)
	{
		set_task(get_pcvar_float(plugin_checktime),"prethink",id,"",0,"b")
	}
}

public client_disconnect(id)
{
	remove_task(id)
}

public checknum()
{
	if(get_pcvar_num(plugin_enabled) && !stopplugin)
	{
		new newnum
		for(new i=0;i<=maxplayers;i++)
		{
			if(is_user_alive(i)) newnum++
		}
		if(alivenum>MINNUM && newnum<=MINNUM && get_pcvar_num(plugin_2ppl))
		{
			client_print(0,print_chat,"[AMXX]Te most mar at tudsz menni a masik oldalra, mivel csak 2 ember maradt.")
		}
		alivenum=newnum
	}
}

public prethink(id)
{
	if(is_user_alive(id) && !stopplugin && get_pcvar_num(plugin_enabled) && !(alivenum<=MINNUM && get_pcvar_num(plugin_2ppl)) )
	{
		new origin[3]
		get_user_origin(id,origin)
		new team[32]
		get_user_team(id,team,31)
		new teamnum=1
		if(containi(team,"CT")!=-1 || containi(team,"Counter")!=-1)
		{
			teamnum=2
		}
		if( (get_distance(origin,CTspawn_loc)<get_distance(origin,Tspawn_loc) && teamnum==1) || (get_distance(origin,Tspawn_loc)<get_distance(origin,CTspawn_loc) && teamnum==2) )
		{
			if(get_pcvar_num(plugin_punishment)==1) user_kill(id)
			else
			{
				new origin[3]
				get_user_origin(id,origin)
				new Float:vector1[3]
				if(teamnum==2)
				{
					vector1[0] = float(CTspawn_loc[0]) - origin[0]
					vector1[1] = float(CTspawn_loc[1]) - origin[1]
					vector1[2] = float(CTspawn_loc[2]) - origin[2]
				}
				else
				{
					vector1[0] = float(Tspawn_loc[0]) - origin[0]
					vector1[1] = float(Tspawn_loc[1]) - origin[1]
					vector1[2] = float(Tspawn_loc[2]) - origin[2]
				}
				new Float:num = floatsqroot(250*250 / vector1[0]*vector1[0] + vector1[1]*vector1[1] + vector1[2]*vector1[2])
				vector1[0] *= num
				vector1[1] *= num
				vector1[2] *= num
				set_user_velocity(id,vector1)
			}
			client_print(id,print_chat,"[AMXX] Ne manj at a kozepso vonalon!")
		}
	}
}

public spawn_locs()
{
	new ent1 = find_ent_by_class(0,"info_player_start")
	new ent2 = find_ent_by_class(0,"info_player_deathmatch")
	if(!ent1)
	{
		log_amx("No info_player_start found")
		stopplugin=true
	}
	if(!ent2)
	{
		log_amx("No info_player_deathmatch found")
		stopplugin=true
	}
	new Float:CTspawn_loc_F[3]
	new Float:Tspawn_loc_F[3]
	entity_get_vector(ent1,EV_VEC_origin,CTspawn_loc_F)
	entity_get_vector(ent2,EV_VEC_origin,Tspawn_loc_F)
	CTspawn_loc[0] = floatround(CTspawn_loc_F[0])
	CTspawn_loc[1] = floatround(CTspawn_loc_F[1])
	CTspawn_loc[2] = floatround(CTspawn_loc_F[2])
	Tspawn_loc[0] = floatround(Tspawn_loc_F[0])
	Tspawn_loc[1] = floatround(Tspawn_loc_F[1])
	Tspawn_loc[2] = floatround(Tspawn_loc_F[2])
}

public create_middle1()
{
	//***
	//Simple Algebra to calculate the location of the middle line(s).
	//***
	
	new Float:CTspawn_loc_F[3]
	new Float:Tspawn_loc_F[3]
	IVecFVec(CTspawn_loc,CTspawn_loc_F)
	IVecFVec(Tspawn_loc,Tspawn_loc_F)
	
	new Float:line1_slope = (CTspawn_loc_F[1] - Tspawn_loc_F[1]) / (CTspawn_loc_F[0] - Tspawn_loc_F[0])
	new Float:line2_slope = -1.0 * (1.0 / line1_slope)
	
	new Float:midpoint[3]
	midpoint[0] = (CTspawn_loc_F[0] + Tspawn_loc_F[0]) / 2
	midpoint[1] = (CTspawn_loc_F[1] + Tspawn_loc_F[1]) / 2
	midpoint[2] = (CTspawn_loc_F[2] + Tspawn_loc_F[2]) / 2

	if(floatabs(line2_slope)>1.0)
	{
		farthest_point1[1] = midpoint[1] + (tag_sprite_size_horizontal / 2)
		farthest_point2[1] = midpoint[1] - (tag_sprite_size_horizontal / 2)
		
		farthest_point1[0] = (farthest_point1[1] - midpoint[1] + (line2_slope * midpoint[0])) / line2_slope
		farthest_point2[0] = (farthest_point2[1] - midpoint[1] + (line2_slope * midpoint[0])) / line2_slope
	}
	
	if(floatabs(line2_slope)<=1.0)
	{
		farthest_point1[0] = midpoint[0] + (tag_sprite_size_horizontal / 2)
		farthest_point2[0] = midpoint[0] - (tag_sprite_size_horizontal / 2)

		farthest_point1[1] = line2_slope*(farthest_point1[0]-midpoint[0]) + midpoint[1]
		farthest_point2[1] = line2_slope*(farthest_point2[0]-midpoint[0]) + midpoint[1]
	}
	
	farthest_point1[2] = midpoint[2] - (tag_sprite_size_vertical / 2)

	set_task(get_pcvar_float(plugin_redrawtime),"create_middle2",1337,"",0,"b")
}

public create_middle2()
{
	if(!stopplugin && get_pcvar_num(plugin_fence) && get_pcvar_num(plugin_enabled) && !(alivenum<=MINNUM && get_pcvar_num(plugin_2ppl)))
	{
		set_task(0.1,"create_middle3",0,"",0,"a",(tag_sprite_size_vertical / tag_sprite_vertical_increments))
		multiplier=1
	}
	if(oldtime!=get_pcvar_float(plugin_redrawtime))
	{
		remove_task(1337)
		set_task(get_pcvar_float(plugin_redrawtime),"create_middle1",1337,"",0,"b")
		oldtime=get_pcvar_float(plugin_redrawtime)
	}
}

public create_middle3()
{
	new zpoint = floatround(farthest_point1[2]) + (multiplier * tag_sprite_vertical_increments)
	multiplier++
	new color[32], red, green, blue
	get_pcvar_string(plugin_fencecolor,color,31)
	if(equali(color,"red"))
	{
		red=255
		green=0
		blue=0
	}
	else if(equali(color,"blue"))
	{
		red=0
		green=0
		blue=255
	}
	else if(equali(color,"white"))
	{
		red=255
		green=255
		blue=255
	}
	else if(equali(color,"random"))
	{
		red=random_num(0,255)
		green=random_num(0,255)
		blue=random_num(0,255)
	}
	else if(equali(color,"Yellow"))
	{
		red = 255
		green = 255
		blue = 0
	}
	else if(equali(color,"Orange"))
	{
		red = 255
		green = 128
		blue = 64
	}
	else if(equali(color,"Pink"))
	{
		red = 255
		green = 0
		blue = 128
	}
	else if(equali(color,"Indigo"))
	{
		red = 0
		green = 255
		blue = 255
	}
	else
	{
		red=0
		green=255
		blue=0
	}

	message_begin(MSG_BROADCAST, SVC_TEMPENTITY) 
	write_byte(0)		//TE_BEAMPOINTS
	write_coord(floatround(farthest_point1[0]))
	write_coord(floatround(farthest_point1[1]))
	write_coord(zpoint)
	write_coord(floatround(farthest_point2[0]))
	write_coord(floatround(farthest_point2[1]))
	write_coord(zpoint)
	write_short(beamsprite)
	write_byte(1)		// framestart
	write_byte(1)		// framerate
	write_byte(get_pcvar_num(plugin_redrawtime) * 10)// life in 0.1's
	write_byte(5)		// width
	write_byte(0)		// noise
	write_byte(red)		// red
	write_byte(green)	// green
	write_byte(blue)	// blue
	write_byte(get_pcvar_num(plugin_fencealpha))// brightness
	write_byte(0)		// speed
	message_end()
}
