#include <amxmodx>
#include <fakemeta>
#include <fakemeta_util>
#include <fun>
#include <hamsandwich>
#include <cstrike>
#include <zombieplague>
#include <engine>

// Info Plugin
#define VERSION "1.0"
#define AUTHOR "NST"


// Info Weapon
#define CURENT_WEAPON CSW_SCOUT
new models_weapon[64] = "Crossbow"
new name_weapon[64] = "Crossbow"


new plugin_name[64] = "[ZP] Extra: %s"
new name_class_weapon[64] = "nst_%s"
new V_MODEL[64] = "models/cso_wpn/v_%s.mdl"
new P_MODEL[64] = "models/cso_wpn/p_%s.mdl"
new W_MODEL[64] = "models/cso_wpn/w_%s.mdl"

new cvar_dmg_name[64] = "nst_%s_dmg"
new cvar_uclip_name[64] = "nst_%s_uclip"
new cvar_speed_name[64] = "nst_%s_speed"
new cvar_zoom_name[64] = "nst_%s_zoom"
new cvar_clip_name[64] = "nst_%s_clip"
new cvar_ammo_name[64] = "nst_%s_ammo"
new cvar_recoil_name[64] = "nst_%s_recoil"
new cvar_round_name[64] = "nst_%s_round"

#define is_valid_player(%1) (1 <= %1 <= 32)
new user_clip[33], user_ammo[33]
new cvar_dmgmultiplier, cvar_uclip, cvar_speed, cvar_zoom, cvar_clip, cvar_ammo, cvar_recoil, cvar_round
new g_itemid
new bool:G_HasWp[33]
new g_hasZoom[ 33 ]
const Wep_drop = ((1<<CURENT_WEAPON))
new szWeapon[17]
new Float:cl_pushangle[33][3]


////////////////////////////////// Ammo //////////////////////////////////

const SILENT_BS	= ((1<<CSW_USP)|(1<<CURENT_WEAPON))

// weapons offsets
const m_pPlayer			= 41
const m_iId				= 43
const m_fKnown				= 44
const m_flNextPrimaryAttack	= 46
const m_flNextSecondaryAttack	= 47
const m_flTimeWeaponIdle		= 48
const m_iPrimaryAmmoType		= 49
const m_iClip				= 51
const m_fInReload			= 54
const m_fInSpecialReload		= 55
const m_fSilent			= 74
const m_flNextAttack		= 83
const m_rgAmmo_player_Slot0	= 376

stock const g_iDftMaxClip[CSW_P90+1] = {
	-1,  13, -1, 10,  1,  7,    1, 30, 30,  1,  30, 
		20, 25, 30, 35, 25,   12, 20, 10, 30, 100, 
		8 , 30, 30, 20,  2,    7, 30, 30, -1,  50}
		
stock const g_iReloadAnims[CSW_P90+1] = {
	-1,  5, -1, 3, -1,  6,   -1, 1, 1, -1, 14, 
		4,  2, 3,  1,  1,   13, 7, 4,  1,  3, 
		6, 11, 1,  3, -1,    4, 1, 1, -1,  1}
		
stock const Float:g_fDelay[CSW_P90+1] = {
	0.00, 2.70, 0.00, 2.00, 0.00, 0.55,   0.00, 3.15, 3.30, 0.00, 4.50, 
		 2.70, 3.50, 3.35, 2.45, 3.30,   2.70, 2.20, 2.50, 2.63, 4.70, 
		 0.55, 3.05, 2.12, 3.50, 0.00,   2.20, 3.00, 2.45, 0.00, 3.40
}


public plugin_init()
{
	// Create value
	format(V_MODEL, 63, V_MODEL, models_weapon)
	format(P_MODEL, 63, P_MODEL, models_weapon)
	format(W_MODEL, 63, W_MODEL, models_weapon)
	
	format(cvar_dmg_name, 63, cvar_dmg_name, models_weapon)
	format(cvar_uclip_name, 63, cvar_uclip_name, models_weapon)
	format(cvar_speed_name, 63, cvar_speed_name, models_weapon)
	format(cvar_zoom_name, 63, cvar_zoom_name, models_weapon)
	format(cvar_clip_name, 63, cvar_clip_name, models_weapon)
	format(cvar_ammo_name, 63, cvar_ammo_name, models_weapon)
	format(cvar_recoil_name, 63, cvar_recoil_name, models_weapon)
	format(cvar_round_name, 63, cvar_round_name, models_weapon)
	
	format(plugin_name, 63, plugin_name, name_weapon)
	format(name_class_weapon, 63, name_class_weapon, models_weapon)

	// Reg Cvar
	cvar_dmgmultiplier = register_cvar(cvar_dmg_name, "3")
	cvar_uclip = register_cvar(cvar_uclip_name, "0")
	cvar_speed = register_cvar(cvar_speed_name,"0.2")
	cvar_zoom = register_cvar(cvar_zoom_name,"0")
	cvar_clip = register_cvar(cvar_clip_name,"50")
	cvar_ammo = register_cvar(cvar_ammo_name,"100")
	cvar_recoil = register_cvar(cvar_recoil_name,"0.1")


	
	register_plugin(plugin_name, VERSION, AUTHOR)
	g_itemid = zp_register_extra_item(name_weapon, 25, ZP_TEAM_HUMAN)

	//register_event("WeapPickup","checkModel","b","1=19")
	register_event("DeathMsg", "Death", "a")
	register_event("CurWeapon","checkWeapon","be","1=1")
	register_event("HLTV", "event_start_freezetime", "a", "1=0", "2=0")

	// Ham
	RegisterHam(Ham_TakeDamage, "player", "fw_TakeDamage")
	//RegisterHam(Ham_Spawn, "player", "fwHamPlayerSpawnPost", 1)
	get_weaponname(CURENT_WEAPON, szWeapon, charsmax(szWeapon))
	RegisterHam(Ham_Item_PostFrame, szWeapon, "Item_PostFrame")
	register_forward( FM_CmdStart, "fw_CmdStart" )
	
	// Recoil
	RegisterHam(Ham_Weapon_PrimaryAttack, szWeapon, "fw_primary_attack")
	RegisterHam(Ham_Weapon_PrimaryAttack, szWeapon, "fw_primary_attack_post",1) 

	register_clcmd("drop","cmd_drop", 0)
}

// Other Public
public plugin_precache()
{
	format(V_MODEL, 63, V_MODEL, models_weapon)
	format(P_MODEL, 63, P_MODEL, models_weapon)
	format(W_MODEL, 63, W_MODEL, models_weapon)
	
	precache_model(V_MODEL)
	precache_model(P_MODEL)
	precache_model(W_MODEL)
}

public client_connect(id)
{
	G_HasWp[id] = false
}

public client_disconnect(id)
{
	G_HasWp[id] = false
}

public Death()
{
	new id = read_data(2) 
	if(G_HasWp[id])
	{
		create_w_class(id, user_clip[id], user_ammo[id], 0)
		G_HasWp[id] = false
		return PLUGIN_HANDLED
	}
	
	return PLUGIN_CONTINUE
}

public fwHamPlayerSpawnPost(id)
{
	if (!get_pcvar_num(cvar_round)) G_HasWp[id] = false
}

public zp_user_infected_post(id)
{
	if (zp_get_user_zombie(id))
	{
		G_HasWp[id] = false
	}
}

public zp_extra_item_selected(player, itemid)
{
	if ( itemid == g_itemid )
	{
		drop_prim(player)
		give_weapon(player, get_pcvar_num(cvar_clip), get_pcvar_num(cvar_ammo))
	}
}

public event_start_freezetime()
{
	remove_class_wpn()
}
// End Other Public


// Check Weapon
public checkModel(id)
{
	if ( zp_get_user_zombie(id) )
		return PLUGIN_HANDLED
	
	new szWeapID = read_data(2)
	
	if ( szWeapID == CURENT_WEAPON && G_HasWp[id] == true)
	{
		set_pev(id, pev_viewmodel2, V_MODEL)
		set_pev(id, pev_weaponmodel2, P_MODEL)
	}
	return PLUGIN_HANDLED
}

public checkWeapon(id)
{
	new plrClip, plrAmmo, plrWeapId
	plrWeapId = get_user_weapon(id, plrClip , plrAmmo)
	
	
	if (plrWeapId == CURENT_WEAPON && G_HasWp[id])
	{
		checkModel(id)

		// Speed
		new Ent = get_weapon_ent(id,plrWeapId)
		new Float:N_Speed
		if(Ent) 
		{
			N_Speed = get_pcvar_float(cvar_speed)
			new Float:Delay = get_pdata_float( Ent, 46, 4) * N_Speed	
			if (Delay > 0.0) {
				set_pdata_float( Ent, 46, Delay, 4)
			}
		}
	}
	else 
	{
		return PLUGIN_CONTINUE
	}
	

	
	return PLUGIN_HANDLED
}
// End Check Weapon


// Control Damage
public fw_TakeDamage(victim, inflictor, attacker, Float:damage)
{
    if ( is_valid_player( attacker ) && get_user_weapon(attacker) == CURENT_WEAPON && G_HasWp[attacker] )
    {
        SetHamParamFloat(4, damage * get_pcvar_float( cvar_dmgmultiplier ) )
    }
}
// End Control Damage



// Zoom Wepaon
public fw_CmdStart( id, uc_handle, seed )
{
	if( !is_user_alive( id ) ) 
		return PLUGIN_HANDLED
	
	
	new szClip, szAmmo
	new szWeapID = get_user_weapon( id, szClip, szAmmo )
	
	if( szWeapID == CURENT_WEAPON && G_HasWp[id] == true)
	{
		// Zoom Weapon
		if (get_pcvar_num(cvar_zoom))
		{
			if( ( get_uc( uc_handle, UC_Buttons ) & IN_ATTACK2 ) && !( pev( id, pev_oldbuttons ) & IN_ATTACK2 ) )
			{
				if(!g_hasZoom[id] == true)
				{
					g_hasZoom[id] = true
					cs_set_user_zoom( id, CS_SET_AUGSG552_ZOOM, 0 )
					client_cmd(id,"spk weapons/zoom")
				}
				else if (g_hasZoom[id])
				{
					g_hasZoom[ id ] = false
					cs_set_user_zoom( id, CS_RESET_ZOOM, 0 )
				}
			}
		}
		// UClip
		if (get_pcvar_num(cvar_uclip))
		{
			new ent = get_weapon_ent(id,CURENT_WEAPON)
			cs_set_weapon_ammo(ent, get_pcvar_num(cvar_clip))
		}
		
		user_clip[id] = szClip
		user_ammo[id] = szAmmo

	}
	
	if ( (g_hasZoom[ id ] && (pev(id, pev_button) & IN_RELOAD)) || (g_hasZoom[id] && szWeapID != CURENT_WEAPON) )
	{
		g_hasZoom[id] = false
		cs_set_user_zoom( id, CS_RESET_ZOOM, 0 )
	}

	
	return PLUGIN_HANDLED
}
// End Zoom Wepaon


// Recoil of Weapon
public fw_primary_attack(ent)
{
	new id = pev(ent,pev_owner)
	pev(id,pev_punchangle,cl_pushangle[id])
	
	return HAM_IGNORED
}
public fw_primary_attack_post(ent)
{
	new id = pev(ent,pev_owner)
	new szClip, szAmmo
	new szWeapID = get_user_weapon( id, szClip, szAmmo )
	
	if( szWeapID == CURENT_WEAPON && G_HasWp[id] == true)
	{
		new Float:push[3]
		pev(id,pev_punchangle,push)
		xs_vec_sub(push,cl_pushangle[id],push)
		
		xs_vec_mul_scalar(push,get_pcvar_float(cvar_recoil),push)
		xs_vec_add(push,cl_pushangle[id],push)
		set_pev(id,pev_punchangle,push)
	}
	
	return HAM_IGNORED
}
// End Recoil of Weapon


// Drop Weapon
public cmd_drop(id)
{
	new plrClip, plrAmmo
	new plrWeapId
	plrWeapId = get_user_weapon(id, plrClip , plrAmmo)
	
	if(plrWeapId == CURENT_WEAPON && G_HasWp[id] && is_user_alive(id)) {
		create_w_class(id, plrClip, plrAmmo, 1)		
		return PLUGIN_HANDLED
	} 
	return PLUGIN_CONTINUE
}

public create_w_class(id, clip, ammo, type)
{
	new Float:Aim[3],Float:origin[3]
	VelocityByAim(id, 64, Aim)
	entity_get_vector(id,EV_VEC_origin,origin)
	
	if (type == 1) {
		origin[0] += 2*Aim[0]
		origin[1] += 2*Aim[1]
	}

	new nst_cre_class = create_entity("info_target")
	entity_set_string(nst_cre_class,EV_SZ_classname,name_class_weapon)
	entity_set_model(nst_cre_class,W_MODEL)	
		
	entity_set_size(nst_cre_class,Float:{-2.0,-2.0,-2.0},Float:{5.0,5.0,5.0})
	entity_set_int(nst_cre_class,EV_INT_solid,1)
		
	entity_set_int(nst_cre_class,EV_INT_movetype,6)
	entity_set_int(nst_cre_class, EV_INT_iuser1, clip)
	entity_set_int(nst_cre_class, EV_INT_iuser2, ammo)
	entity_set_vector(nst_cre_class,EV_VEC_origin,origin)
	G_HasWp[id] = false
	remowegun(id)
}
// End Drop Weapon


// Remove Class Wepaons in new round
public remove_class_wpn()
{
	new nextitem  = find_ent_by_class(-1,name_class_weapon)
	while(nextitem) {
		remove_entity(nextitem)
		nextitem = find_ent_by_class(-1,name_class_weapon)
	}
	return PLUGIN_CONTINUE
}
// End Remove Class Wepaons in new round


// Weapon Pickup
public pfn_touch(ptr, ptd) {
	if(is_valid_ent(ptr)) {
		
		new classname[32]
		entity_get_string(ptr,EV_SZ_classname,classname,31)
		if(equal(classname, name_class_weapon)) {
			if(is_valid_ent(ptd)) {
				new id = ptd
				if(id > 0 && id < 34) {
					if(!G_HasWp[id] && is_user_alive(id) && !zp_get_user_zombie(id)) {
						give_weapon(id,entity_get_int(ptr, EV_INT_iuser1), entity_get_int(ptr, EV_INT_iuser2))
						remove_entity(ptr)
					}
				}
			}
		}
	}
}
// End Weapon Pickup


// remove gun and save all guns
public remowegun(id) { 
	new wpnList[32] 
	new number
	get_user_weapons(id,wpnList,number) 
	for (new i = 0;i < number ;i++) { 
		if (wpnList[i] == CURENT_WEAPON) {
			fm_strip_user_gun(id, wpnList[i])
		}
	}
} 

//give wpn
public give_weapon(id, clip, ammo){
	G_HasWp[id] = true
	give_item(id,szWeapon)
	cs_set_user_bpammo(id, CURENT_WEAPON, ammo)
	new ent = get_weapon_ent(id,CURENT_WEAPON)
	cs_set_weapon_ammo(ent, clip)
	
}


// Give Ammo Clip
public Item_PostFrame(iEnt)
{
	static id ; id = get_pdata_cbase(iEnt, m_pPlayer, 4)
	new plrClip, plrAmmo, plrWeapId
	plrWeapId = get_user_weapon(id, plrClip , plrAmmo)
	
	if (plrWeapId == CURENT_WEAPON && G_HasWp[id])
	{

	static iId ; iId = get_pdata_int(iEnt, m_iId, 4)
	static iMaxClip ; iMaxClip = get_pcvar_num(cvar_clip)
	static fInReload ; fInReload = get_pdata_int(iEnt, m_fInReload, 4)
	static Float:flNextAttack ; flNextAttack = get_pdata_float(id, m_flNextAttack, 5)

	static iAmmoType ; iAmmoType = m_rgAmmo_player_Slot0 + get_pdata_int(iEnt, m_iPrimaryAmmoType, 4)
	static iBpAmmo ; iBpAmmo = get_pdata_int(id, iAmmoType, 5)
	static iClip ; iClip = get_pdata_int(iEnt, m_iClip, 4)


	if( fInReload && flNextAttack <= 0.0 )
	{
		new j = min(iMaxClip - iClip, iBpAmmo)
		set_pdata_int(iEnt, m_iClip, iClip + j, 4)
		set_pdata_int(id, iAmmoType, iBpAmmo-j, 5)		
		set_pdata_int(iEnt, m_fInReload, 0, 4)
		fInReload = 0
	}
	
	static iButton ; iButton = pev(id, pev_button)
	if(	(iButton & IN_ATTACK2 && get_pdata_float(iEnt, m_flNextSecondaryAttack, 4) <= 0.0)
	||	(iButton & IN_ATTACK && get_pdata_float(iEnt, m_flNextPrimaryAttack, 4) <= 0.0)	)
	{
		return
	}
	
	if( iButton & IN_RELOAD && !fInReload )
	{
		if( iClip >= iMaxClip )
		{
			set_pev(id, pev_button, iButton & ~IN_RELOAD)
			if( SILENT_BS & (1<<iId) && !get_pdata_int(iEnt, m_fSilent, 4) )
			{
				SendWeaponAnim( id, iId == CSW_USP ? 8 : 7 )
			}
			else
			{
				SendWeaponAnim(id, 0)
			}
		}
		else if( iClip == g_iDftMaxClip[iId] )
		{
			if( iBpAmmo )
			{
				set_pdata_float(id, m_flNextAttack, g_fDelay[iId], 5)

				if( SILENT_BS & (1<<iId) && get_pdata_int(iEnt, m_fSilent, 4) )
				{
					SendWeaponAnim( id, iId == CSW_USP ? 5 : 4 )
				}
				else
				{
					SendWeaponAnim(id, g_iReloadAnims[iId])
				}
				set_pdata_int(iEnt, m_fInReload, 1, 4)

				set_pdata_float(iEnt, m_flTimeWeaponIdle, g_fDelay[iId] + 0.5, 4)
			}
		}
	}
	
	}
}
SendWeaponAnim(id, iAnim)
{
	set_pev(id, pev_weaponanim, iAnim)

	message_begin(MSG_ONE_UNRELIABLE, SVC_WEAPONANIM, _, id)
	write_byte(iAnim)
	write_byte(pev(id,pev_body))
	message_end()
}
// End Give Ammo Clip


// Stock
stock drop_prim(id) 
{
	new weapons[32], num
	get_user_weapons(id, weapons, num)
	for (new i = 0; i < num; i++) {
		if (Wep_drop & (1<<weapons[i])) 
		{
			static wname[32]
			get_weaponname(weapons[i], wname, sizeof wname - 1)
			engclient_cmd(id, "drop", wname)
			G_HasWp[id] = false
		}
	}
}
//get weapon id
stock get_weapon_ent(id,wpnid=0,wpnName[]="")
{
	// who knows what wpnName will be
	static newName[24];

	// need to find the name
	if(wpnid) get_weaponname(wpnid,newName,23);

	// go with what we were told
	else formatex(newName,23,"%s",wpnName);

	// prefix it if we need to
	if(!equal(newName,"weapon_",7))
		format(newName,23,"weapon_%s",newName);

	return fm_find_ent_by_owner(get_maxplayers(),newName,id);
} 