#include <amxmodx>
#include <amxmisc>
#include <fakemeta>
#include <fakemeta_util>
#include <hamsandwich>
#include <fun>
#include <engine>
#include <cstrike>
#include <zombieplague>
#define EWEAPON_W_MODEL "models/cso_wpn/w_waterpistol.mdl"
#define EWEAPON_V_MODEL "models/cso_wpn/v_waterpistol.mdl"
#define EWEAPON_P_MODEL "models/cso_wpn/p_waterpistol.mdl"
#define EWEAPON_SOUND_FIRE "weapons/water-1.wav"
#define EWEAPON_SOUND_EMPTY "weapons/ak47_clipout.wav"

#define EWEAPON_LOGNAME "watergun"

#define EWEAPON_WEAPONKEY 1200788
#define EWEAPON_BASE_WEAPON "weapon_ump45"

#define EWEAPON_CLIPSIZE 70
#define EWEAPON_START_AMMO 300

#define EWEAPON_SHOOT_NEXTATTACKTIME 0.1
#define EWEAPON_SHOOT_NEXTIDLETIME 0.1
#define EWEAPON_SHOOTEMPTY_NEXTATTACKTIME 0.2
#define EWEAPON_SHOOTEMPTY_NEXTIDLETIME 0.2
#define EWEAPON_RELOAD_TIME 2.3
#define EWEAPON_BASE_DAMAGE 70.0

#define EWEAPON_HORIZONTAL_RECOIL 150
#define EWEAPON_VERTICAL_RECOIL 1

#define ANIM_IDLE 0
#define ANIM_IDLE_EMPTY 3
#define ANIM_RELOAD 4
#define ANIM_DRAW 5
#define ANIM_DRAW_EMPTY 2
#define ANIM_FIRE1 1
#define ANIM_FIRE2 1
#define ANIM_FIRE3 1

#define ANIM_PLAYER_POSTFIX "rifle"

#define FIRE_WATERSPRAY
/* ------------------------------------------------- */

new g_EWeaponId = 0;
new g_OriginalWModel[128];
#define EV_INT_WEAPONKEY	EV_INT_impulse
#define MAX_PLAYERS 32

new DecalsShot[5] = {41, 42, 43, 44, 45};
new g_BloodDecals[6];
new g_BloodSprite[2];

enum _:e_EWepState 
{
	bool:wep_have,
	bool:wep_active,
	wep_ent,
	wep_TmpClip,
};

new g_EWepPlayerData[MAX_PLAYERS+1][e_EWepState];

//CBaseWeapon fields
#define m_fKnown				44
#define m_flNextPrimaryAttack 			46
#define m_flTimeWeaponIdle			48
#define m_iClip					51
#define m_fInReload				54
#define m_flNextAttack				83
#define CBASEWEAPON_LINUX_XTRA_OFF			4

new const g_item_name[] = { "\wVizipisztoly\r[CSO]" };
new g_itemid_guitar;
const g_item_cost = 18;

#if defined FIRE_WATERSPRAY
new tracer_sprite;
new tracer_sprite2;
#endif //FIRE_WATERSPRAY

public plugin_init() {
	register_plugin("[ZP] Extra: Guitar!", "0.7.0", "Crock");
	g_itemid_guitar = zp_register_extra_item(g_item_name, g_item_cost, ZP_TEAM_HUMAN);

	InitDecals();

	RegisterHam(Ham_Weapon_PrimaryAttack, EWEAPON_BASE_WEAPON, "CWeapon__PrimaryAttack");
	RegisterHam(Ham_Item_Deploy, EWEAPON_BASE_WEAPON, "CWeapon__Deploy", 1);
	RegisterHam(Ham_Item_AddToPlayer, EWEAPON_BASE_WEAPON, "CWeapon__AddToPlayer");
	RegisterHam(Ham_Item_AttachToPlayer, EWEAPON_BASE_WEAPON, "CWeapon__AttachToPlayer");
	RegisterHam(Ham_Item_PostFrame, EWEAPON_BASE_WEAPON, "CWeapon__ItemPostFrame");
	RegisterHam(Ham_Weapon_Reload, EWEAPON_BASE_WEAPON, "CWeapon__Reload");
	RegisterHam(Ham_Weapon_Reload, EWEAPON_BASE_WEAPON, "CWeapon__Reload_Post", 1);

	register_forward(FM_SetModel, "CWeapon__SetModel");
	register_forward(FM_UpdateClientData, "fw_UpdateClientData_Post", 1);
	register_event("CurWeapon", "event_curweapon", "be", "1=1");
	register_message(get_user_msgid("DeathMsg"), "message_DeathMsg");

	g_EWeaponId = get_weaponid(EWEAPON_BASE_WEAPON);
}

stock InitDecals() 
{
	g_BloodDecals[0] = get_decal_index("{blood1");
	g_BloodDecals[1] = get_decal_index("{blood2");
	g_BloodDecals[2] = get_decal_index("{blood3");
	g_BloodDecals[3] = get_decal_index("{blood4");
	g_BloodDecals[4] = get_decal_index("{blood5");
	g_BloodDecals[5] = get_decal_index("{blood6");
}

public plugin_precache() {
	precache_model(EWEAPON_W_MODEL);
	precache_model(EWEAPON_V_MODEL);
	precache_model(EWEAPON_P_MODEL);

	precache_sound(EWEAPON_SOUND_FIRE);
	precache_sound(EWEAPON_SOUND_EMPTY);

	g_BloodSprite[0] = precache_model("sprites/blood.spr")
	g_BloodSprite[1] = precache_model("sprites/bloodspray.spr")

#if defined FIRE_WATERSPRAY
	tracer_sprite = precache_model("sprites/bluejet1.spr");
	tracer_sprite2 = precache_model("sprites/blueflare2.spr");
#endif
}

public CWeapon__PrimaryAttack(weapon_entity) {
	if(!is_valid_ent(weapon_entity))
		return HAM_IGNORED;

	new id = pev(weapon_entity, pev_owner)
	if (!is_user_connected(id))
		return HAM_IGNORED;

	if (!g_EWepPlayerData[id][wep_have])
		return HAM_IGNORED;

	static szClassName[33]
	entity_get_string(weapon_entity, EV_SZ_classname, szClassName, charsmax(szClassName))

	new iClip = get_pdata_int(weapon_entity, m_iClip, CBASEWEAPON_LINUX_XTRA_OFF)
	if (iClip <= 0) {
		send_weapon_animation(id, ANIM_IDLE_EMPTY)
		engfunc(EngFunc_EmitSound, id, CHAN_WEAPON, EWEAPON_SOUND_EMPTY, VOL_NORM, ATTN_NORM, 0, PITCH_NORM)

		set_pdata_float(weapon_entity, m_flNextPrimaryAttack, EWEAPON_SHOOTEMPTY_NEXTATTACKTIME, CBASEWEAPON_LINUX_XTRA_OFF)
		set_pdata_float(weapon_entity, m_flTimeWeaponIdle, EWEAPON_SHOOTEMPTY_NEXTIDLETIME, CBASEWEAPON_LINUX_XTRA_OFF)

		return HAM_SUPERCEDE;
	}
	iClip--;
	set_pdata_int(weapon_entity, m_iClip, iClip, CBASEWEAPON_LINUX_XTRA_OFF);

	new anim;
	switch (random_num(0,2)) {
		case 0: anim = ANIM_FIRE1;
		case 1: anim = ANIM_FIRE2;
		default: anim = ANIM_FIRE3;
	}
	send_weapon_animation(id, anim);


	/* player model animation */

	engfunc(EngFunc_EmitSound, id, CHAN_WEAPON, EWEAPON_SOUND_FIRE, VOL_NORM, ATTN_NORM, 0, PITCH_NORM);


	static Float:plrViewAngles[3], Float:VecEnd[3], Float:VecDir[3], Float:PlrOrigin[3];
	pev(id, pev_v_angle, plrViewAngles);

	static Float:VecSrc[3], Float:VecDst[3];
	
	//VecSrc = pev->origin + pev->view_ofs;
	pev(id, pev_origin, PlrOrigin)
	pev(id, pev_view_ofs, VecSrc)
	xs_vec_add(VecSrc, PlrOrigin, VecSrc)

	//VecDst = VecDir * 8192.0;
	angle_vector(plrViewAngles, ANGLEVECTOR_FORWARD, VecDir);
	xs_vec_mul_scalar(VecDir, 8192.0, VecDst);
	xs_vec_add(VecDst, VecSrc, VecDst);
	
	new hTrace = create_tr2()
	engfunc(EngFunc_TraceLine, VecSrc, VecDst, 0, id, hTrace)
	new hitEnt = get_tr2(hTrace, TR_pHit);
	get_tr2(hTrace, TR_vecEndPos, VecEnd);

	#if defined FIRE_WATERSPRAY
		create_tracer_water(id, VecSrc, VecEnd)
	#endif //FIRE_WATERSPRAY

	new bool:bNeedDrawShot = true;

	if (pev_valid(hitEnt)) {
		new Float:takeDamage;
		pev(hitEnt, pev_takedamage, takeDamage);

		if (takeDamage != 0.0) {
			bNeedDrawShot = false;

			new Float:dmg = EWEAPON_BASE_DAMAGE;

			new hitGroup = get_tr2(hTrace, TR_iHitgroup);

			switch (hitGroup) {
				case HIT_HEAD: { dmg *= 1.0; }
				case HIT_LEFTARM: { dmg *= 0.5; }
				case HIT_RIGHTARM: { dmg *= 0.5; }
				case HIT_LEFTLEG: { dmg *= 0.5; }
				case HIT_RIGHTLEG: { dmg *= 0.5; }
			}

			if (is_user_connected(hitEnt) && zp_get_user_zombie(hitEnt)) {
				ExecuteHamB(Ham_TakeDamage, hitEnt, id, id, dmg, DMG_BULLET | DMG_NEVERGIB);
				ExecuteHamB(Ham_TraceBleed, hitEnt, dmg, VecDir, hTrace, DMG_BULLET | DMG_NEVERGIB);
				make_blood(VecEnd, dmg, hitEnt);
			}
		
		}

		new solid = pev(hitEnt, pev_solid);
		if (solid != SOLID_BSP)
			bNeedDrawShot = false;

	}

	static Float:punchAngle[3];
	punchAngle[0] = float(random_num(-EWEAPON_VERTICAL_RECOIL, EWEAPON_VERTICAL_RECOIL)) / 100.0;

	punchAngle[1] = float(random_num(-EWEAPON_HORIZONTAL_RECOIL, EWEAPON_HORIZONTAL_RECOIL)) / 100.0;
	punchAngle[2] = 0.0;
	set_pev(id, pev_punchangle, punchAngle);


	/* draw decal if needed */

	if (bNeedDrawShot == true) {
		#if defined FIRE_WATERSPRAY
		#else
			create_shot(VecEnd, hitEnt);
		#endif //FIRE_WATERSPRAY
	} else {
		if (pev_valid(hitEnt)) {
			// engfunc(EngFunc_EmitAmbientSound, 0, VecEnd, "hit_body.wav", VOL_NORM, ATTN_NORM, 0, PITCH_NORM)
		}
	}

	set_pdata_float(weapon_entity, m_flNextPrimaryAttack, EWEAPON_SHOOT_NEXTATTACKTIME, CBASEWEAPON_LINUX_XTRA_OFF)
	set_pdata_float(weapon_entity, m_flTimeWeaponIdle, EWEAPON_SHOOT_NEXTIDLETIME, CBASEWEAPON_LINUX_XTRA_OFF)

	free_tr2(hTrace);
	
	return HAM_SUPERCEDE;
}

public CWeapon__SetModel(entity, model[]) {
	if(!is_valid_ent(entity))
		return FMRES_IGNORED;
		
	static szClassName[33]
	entity_get_string(entity, EV_SZ_classname, szClassName, charsmax(szClassName))

	// save original W_ model
	if (equal(szClassName, EWEAPON_BASE_WEAPON)) {
		copy(g_OriginalWModel, 127, model)
	}


	if (!equal(szClassName, "weaponbox")) {
		return FMRES_IGNORED;
	}

	if (!g_OriginalWModel[0] || !equal(g_OriginalWModel, model)) {
		return FMRES_IGNORED;
	}

	new entOwner = entity_get_edict(entity, EV_ENT_owner)
	new entStoredEWep = find_ent_by_owner(FM_NULLENT, EWEAPON_BASE_WEAPON, entity)

	if(is_user_connected(entOwner) && \
		g_EWepPlayerData[entOwner][wep_have] == true && 
		is_valid_ent(entStoredEWep)) \
	{
		entity_set_int(entStoredEWep, EV_INT_WEAPONKEY, EWEAPON_WEAPONKEY)

		// save ammo
		new bpammos = cs_get_user_bpammo(entOwner, g_EWeaponId);
		entity_set_int(entStoredEWep, EV_INT_weapons, bpammos);
		cs_set_user_bpammo(entOwner, g_EWeaponId, 0);
		
		CWeapon__RemoveFromPlayer(entOwner)
		
		entity_set_model(entity, EWEAPON_W_MODEL);
		
		return FMRES_SUPERCEDE;
	}

	return FMRES_IGNORED;
}

stock CWeapon__RemoveFromPlayer(id) {
	g_EWepPlayerData[id][wep_have] = false;
	g_EWepPlayerData[id][wep_active] = false;
	g_EWepPlayerData[id][wep_ent] = 0;
}

public CWeapon__Deploy(weapon_entity) {
	if (!is_valid_ent(weapon_entity))
		return HAM_IGNORED;

	static szClassName[33]
	entity_get_string(weapon_entity, EV_SZ_classname, szClassName, charsmax(szClassName))

	new i, id = 0;
	for (i = 1; i < (MAX_PLAYERS+1); i++) {
		if (g_EWepPlayerData[i][wep_have] && g_EWepPlayerData[i][wep_ent] == weapon_entity)
			id = i;
	}
	

	if (!is_user_connected(id))
		return HAM_IGNORED;

	if (!g_EWepPlayerData[id][wep_have])
		return HAM_IGNORED;

	if (!equal(szClassName, EWEAPON_BASE_WEAPON)) {
		g_EWepPlayerData[id][wep_active] = false;
		return HAM_IGNORED;
	}

	new iClip = get_pdata_int(weapon_entity, m_iClip, CBASEWEAPON_LINUX_XTRA_OFF)

	set_pev(id, pev_viewmodel2, EWEAPON_V_MODEL);
	set_pev(id, pev_weaponmodel2, EWEAPON_P_MODEL);

	g_EWepPlayerData[id][wep_active] = true;

	if (iClip > 0)
		send_weapon_animation(id, ANIM_DRAW)
	else
		send_weapon_animation(id, ANIM_DRAW_EMPTY)
		
	return HAM_IGNORED;
}


public CWeapon__AttachToPlayer(weapon_entity, id) {
	if (!is_valid_ent(weapon_entity))
		return HAM_IGNORED;

	if (!is_user_connected(id))
		return HAM_IGNORED;

	if (!g_EWepPlayerData[id][wep_have])
		return HAM_IGNORED;

	if(get_pdata_int(weapon_entity, m_fKnown, CBASEWEAPON_LINUX_XTRA_OFF)) {
		return HAM_IGNORED;
	}
	
	set_pdata_int(weapon_entity, m_iClip, EWEAPON_CLIPSIZE, CBASEWEAPON_LINUX_XTRA_OFF)

	return HAM_IGNORED;
}

public CWeapon__AddToPlayer(weapon_entity, id) {
	if (!is_valid_ent(weapon_entity))
		return HAM_IGNORED;

	if (!is_user_connected(id))
		return HAM_IGNORED;

	if(entity_get_int(weapon_entity, EV_INT_WEAPONKEY) == EWEAPON_WEAPONKEY && g_EWepPlayerData[id][wep_have] == false)	{

		entity_set_int(weapon_entity, EV_INT_WEAPONKEY, 0)

		//restore ammo
		new bpammos = entity_get_int(weapon_entity, EV_INT_weapons);
		cs_set_user_bpammo(id, g_EWeaponId, bpammos);

		g_EWepPlayerData[id][wep_have] = true;
		g_EWepPlayerData[id][wep_ent] = weapon_entity;
		return HAM_HANDLED;
	}

	if (g_EWepPlayerData[id][wep_have] == true) {
		g_EWepPlayerData[id][wep_ent] = weapon_entity;
	}

	return HAM_IGNORED;
}

public CWeapon__ItemPostFrame(weapon_entity) {
	new id = pev(weapon_entity, pev_owner)
	if (!is_user_connected(id))
		return FMRES_IGNORED;

	if (!g_EWepPlayerData[id][wep_have])
		return FMRES_IGNORED;

	new Float:flNextAttack = get_pdata_float(id, m_flNextAttack)

	new iBpAmmo = cs_get_user_bpammo(id, g_EWeaponId);
	new iClip = get_pdata_int(weapon_entity, m_iClip)

	new fInReload = get_pdata_int(weapon_entity, m_fInReload, CBASEWEAPON_LINUX_XTRA_OFF) 

	if (fInReload && flNextAttack <= 0.0) {
		new j = min(EWEAPON_CLIPSIZE - iClip, iBpAmmo)
	
		set_pdata_int(weapon_entity, m_iClip, iClip + j, CBASEWEAPON_LINUX_XTRA_OFF)
		cs_set_user_bpammo(id, g_EWeaponId, iBpAmmo-j);
		
		set_pdata_int(weapon_entity, m_fInReload, 0, CBASEWEAPON_LINUX_XTRA_OFF)
		fInReload = 0
	}

	return FMRES_IGNORED;
}

public CWeapon__Reload(weapon_entity) {
	new id = pev(weapon_entity, pev_owner)
	if (!is_user_connected(id))
		return FMRES_IGNORED;

	if (!g_EWepPlayerData[id][wep_have])
		return FMRES_IGNORED;

	g_EWepPlayerData[id][wep_TmpClip] = -1;

	new iBpAmmo = cs_get_user_bpammo(id, g_EWeaponId);
	new iClip = get_pdata_int(weapon_entity, m_iClip, CBASEWEAPON_LINUX_XTRA_OFF)

	if (iBpAmmo <= 0)
		return FMRES_SUPERCEDE;

	if (iClip >= EWEAPON_CLIPSIZE)
		return FMRES_SUPERCEDE;


	g_EWepPlayerData[id][wep_TmpClip] = iClip;
	
	set_pdata_int(weapon_entity, m_iClip, 0, CBASEWEAPON_LINUX_XTRA_OFF)

	return FMRES_IGNORED;
}

public CWeapon__Reload_Post(weapon_entity) {
	new id = pev(weapon_entity, pev_owner)
	if (!is_user_connected(id))
		return FMRES_IGNORED;

	if (!g_EWepPlayerData[id][wep_have])
		return FMRES_IGNORED;

	if (g_EWepPlayerData[id][wep_TmpClip] == -1)
		return FMRES_IGNORED;

	set_pdata_int(weapon_entity, m_iClip, g_EWepPlayerData[id][wep_TmpClip], CBASEWEAPON_LINUX_XTRA_OFF)

	set_pdata_float(weapon_entity, m_flTimeWeaponIdle, EWEAPON_RELOAD_TIME, CBASEWEAPON_LINUX_XTRA_OFF)

	set_pdata_float(id, m_flNextAttack, EWEAPON_RELOAD_TIME)

	set_pdata_int(weapon_entity, m_fInReload, 1)

	send_weapon_animation( id, ANIM_RELOAD )

	g_EWepPlayerData[id][wep_TmpClip] = -1;

	return FMRES_IGNORED;
}

public fw_UpdateClientData_Post(Player, SendWeapons, CD_Handle) {
	if(!is_user_alive(Player))
		return FMRES_IGNORED;

	if(!g_EWepPlayerData[Player][wep_active])
	        return FMRES_IGNORED;

	set_cd(CD_Handle, CD_flNextAttack, halflife_time () + 0.001)
	return FMRES_HANDLED
}

public event_curweapon(id) {
	if(!is_user_alive(id)) 
		return PLUGIN_CONTINUE;

	if(read_data(2) == g_EWeaponId && g_EWepPlayerData[id][wep_have] == true) {
	} else {
		g_EWepPlayerData[id][wep_active] = false;
	}
	return PLUGIN_HANDLED;
}

public client_connect(id) {
	g_EWepPlayerData[id][wep_active] = false;
	g_EWepPlayerData[id][wep_have] = false;
}

public client_disconnect(id) {
	if (g_EWepPlayerData[id][wep_have] == true) {
		CWeapon__RemoveFromPlayer(id)
	}
}

public message_DeathMsg(msg_id, msg_dest, id) {
	static szTruncatedWeapon[33], iAttacker;
	
	get_msg_arg_string(4, szTruncatedWeapon, charsmax(szTruncatedWeapon));
	
	iAttacker = get_msg_arg_int(1);

	if(is_user_connected(iAttacker) && g_EWepPlayerData[iAttacker][wep_have] == true && equal(szTruncatedWeapon, EWEAPON_BASE_WEAPON)) {
		set_msg_arg_string(4, EWEAPON_LOGNAME);
	}

	return PLUGIN_CONTINUE;
}

#if defined FIRE_WATERSPRAY
stock create_tracer_water(id, Float:fVec1[3], Float:fVec2[3]) {
	static iVec1[3];
	FVecIVec(fVec1, iVec1);

	static Float:origin[3], Float:vSrc[3], Float:angles[3], Float:v_forward[3], Float:v_right[3], Float:v_up[3], Float:gun_position[3], Float:player_origin[3], Float:player_view_offset[3];
	pev(id, pev_v_angle, angles);
	engfunc(EngFunc_MakeVectors, angles);
	global_get(glb_v_forward, v_forward);
	global_get(glb_v_right, v_right);
	global_get(glb_v_up, v_up);

	//m_pPlayer->GetGunPosition( ) = pev->origin + pev->view_ofs
	pev(id, pev_origin, player_origin);
	pev(id, pev_view_ofs, player_view_offset);
	xs_vec_add(player_origin, player_view_offset, gun_position);

	xs_vec_mul_scalar(v_forward, 24.0, v_forward);
	xs_vec_mul_scalar(v_right, 3.0, v_right);

	if ((pev(id, pev_flags) & FL_DUCKING) == FL_DUCKING)
		xs_vec_mul_scalar(v_up, 6.0, v_up);
	else
		xs_vec_mul_scalar(v_up, -2.0, v_up);

	xs_vec_add(gun_position, v_forward, origin);
	xs_vec_add(origin, v_right, origin);
	xs_vec_add(origin, v_up, origin);

	vSrc[0] = origin[0];
	vSrc[1] = origin[1];
	vSrc[2] = origin[2];


	new Float:dist = get_distance_f(vSrc, fVec2);
	new CountDrops = floatround(dist / 50.0);
	
	if (CountDrops > 20)
		CountDrops = 20;
	
	if (CountDrops < 2)
		CountDrops = 2;

	message_begin(MSG_PAS, SVC_TEMPENTITY, iVec1);
	write_byte(TE_SPRITETRAIL);
	engfunc(EngFunc_WriteCoord, vSrc[0]);
	engfunc(EngFunc_WriteCoord, vSrc[1]);
	engfunc(EngFunc_WriteCoord, vSrc[2]);
	engfunc(EngFunc_WriteCoord, fVec2[0]);
	engfunc(EngFunc_WriteCoord, fVec2[1]);
	engfunc(EngFunc_WriteCoord, fVec2[2]);
	write_short(tracer_sprite2); 
	write_byte(CountDrops); //count
	write_byte(0); //life  
	write_byte(1); //scale
	write_byte(60); //velocity
	write_byte(10); //rand_velocity
	message_end();


	message_begin(MSG_PAS, SVC_TEMPENTITY, iVec1);
	write_byte(TE_BEAMPOINTS);
	engfunc(EngFunc_WriteCoord, fVec2[0]);
	engfunc(EngFunc_WriteCoord, fVec2[1]);
	engfunc(EngFunc_WriteCoord, fVec2[2]);
	engfunc(EngFunc_WriteCoord, vSrc[0]);
	engfunc(EngFunc_WriteCoord, vSrc[1]);
	engfunc(EngFunc_WriteCoord, vSrc[2]);
	write_short(tracer_sprite); 
	write_byte(6); //starting_frame
	write_byte(200); //framerate
	write_byte(1); //life
	write_byte(100); //line width
	write_byte(0); //noise ampl
	write_byte(64); write_byte(64); write_byte(192);  //color
	write_byte(192); //brightness
	write_byte(250); //scroll speed
	message_end();
}
#endif //FIRE_WATERSPRAY

stock send_weapon_animation(id, iAnim) {
	set_pev(id, pev_weaponanim, iAnim);
	message_begin(MSG_ONE_UNRELIABLE, SVC_WEAPONANIM, _, id);
	write_byte(iAnim);
	write_byte(pev(id,pev_body));
	message_end();
}

stock create_shot(Float:fOrigin[3], entity = 0) {
	message_begin(MSG_BROADCAST, SVC_TEMPENTITY);
	write_byte(TE_GUNSHOTDECAL);
	engfunc(EngFunc_WriteCoord, fOrigin[0]);
	engfunc(EngFunc_WriteCoord, fOrigin[1]);
	engfunc(EngFunc_WriteCoord, fOrigin[2]);
	if(!pev_valid(entity)) {
		write_short(0);
	} else {
		write_short(entity);
	}
	write_byte(DecalsShot[random_num(0,4)]);
	message_end();
}

stock make_blood(const Float:vTraceEnd[3], Float:Damage, hitEnt) {
	new bloodColor = ExecuteHam(Ham_BloodColor, hitEnt);
	if (bloodColor == -1)
		return;

	new amount = floatround(Damage);

	amount *= 2; //according to HLSDK

	message_begin(MSG_BROADCAST, SVC_TEMPENTITY);
	write_byte(TE_BLOODSPRITE);
	write_coord(floatround(vTraceEnd[0]));
	write_coord(floatround(vTraceEnd[1]));
	write_coord(floatround(vTraceEnd[2]));
	write_short(g_BloodSprite[1]);
	write_short(g_BloodSprite[0]);
	write_byte(bloodColor);
	write_byte(min(max(3, amount/10), 16));
	message_end();
}

public zp_extra_item_selected(id, itemid) {
	if(itemid == g_itemid_guitar) {	
		if (user_has_weapon(id, g_EWeaponId))
			engclient_cmd(id, "drop", EWEAPON_BASE_WEAPON);

		g_EWepPlayerData[id][wep_have] = true;
		give_item(id, EWEAPON_BASE_WEAPON);

		cs_set_user_bpammo (id, g_EWeaponId, EWEAPON_START_AMMO);
	}
}

public zp_user_infected_post(id) {
	if (g_EWepPlayerData[id][wep_have] == true) {
		CWeapon__RemoveFromPlayer(id)
	}
}

public zp_user_humanized_post(id, survivor) {
	if (survivor && g_EWepPlayerData[id][wep_have] == true) {
		CWeapon__RemoveFromPlayer(id)
	}
}
