#include <amxmodx>
#include <fakemeta>
#include <fun> 
#include <engine> 
#include <hamsandwich>
#include <zombieplague>

#define PLUGIN    "Choose knifes"
#define VERSION    "1.0"
#define AUTHOR    "CHyC/4e/l"

#define VIP ADMIN_LEVEL_H
#define MAXPLAYERS 32

new combat_v_model[] = "models/zb/v_combat_knife.mdl"
new combat_p_model[] = "models/zb/p_combat_knife.mdl"

new strong_v_model[] = "models/zb/v_strong_knife.mdl"
new strong_p_model[] = "models/zb/p_strong_knife.mdl"

new axe_v_model[] = "models/zb/v_pfire_knife.mdl"	
new axe_p_model[] = "models/zb/p_pfire_knife.mdl"	

new katana_v_model[] = "models/zb/v_katana_knife.mdl"	
new katana_p_model[] = "models/zb/p_katana_knife.mdl"

new hammer_v_model[] = "models/zb/v_hammer_knife.mdl"	
new hammer_p_model[] = "models/zb/p_hammer_knife.mdl"	

const m_pPlayer = 41 
const m_flNextPrimaryAttack = 46 
const m_flNextSecondaryAttack = 47 
const m_flTimeWeaponIdle = 48 

new g_hasSpeed[33], SayText
new bool:g_WasShowed[MAXPLAYERS + 1]
new g_knife_combat[33], cvar_knife_combat_jump, cvar_knife_combat_spd, cvar_knife_combat_dmg, cvar_knife_combat_knock, cvar_knife_combat_spd_attack2
new g_knife_strong[33], cvar_knife_strong_jump, cvar_knife_strong_spd, cvar_knife_strong_dmg, cvar_knife_strong_knock, cvar_knife_strong_spd_attack2
new g_knife_axe[33], cvar_knife_axe_jump, cvar_knife_axe_spd, cvar_knife_axe_dmg, cvar_knife_axe_knock, cvar_knife_axe_spd_attack2
new g_knife_katana[33], cvar_knife_katana_jump, cvar_knife_katana_spd, cvar_knife_katana_dmg, cvar_knife_katana_knock, cvar_knife_katana_spd_attack2
new g_knife_hammer[33], cvar_knife_hammer_jump, cvar_knife_hammer_spd, cvar_knife_hammer_dmg, cvar_knife_hammer_knock, cvar_hammer_spd_attack2

new const g_sound_knife[] = { "items/gunpickup2.wav" }

new const combat_sounds[][] =
{
	"zmwpn/zb_knife/combat_deploy.wav",
	"zmwpn/zb_knife/combat_hit.wav"	,
	"zmwpn/zb_knife/combat_hit.wav"	,
	"zmwpn/zb_knife/combat_hit.wav"	,
	"zmwpn/zb_knife/combat_hit.wav"	,
	"zmwpn/zb_knife/combat_hitwall.wav",
	"zmwpn/zb_knife/combat_slash.wav",
	"zmwpn/zb_knife/combat_slash.wav",
	"zmwpn/zb_knife/combat_stab.wav"
}

new const strong_sounds[][] =
{
	"zmwpn/zb_knife/strong_deploy.wav",
	"zmwpn/zb_knife/strong_hit.wav",
	"zmwpn/zb_knife/strong_hit.wav",
	"zmwpn/zb_knife/strong_hit.wav",
	"zmwpn/zb_knife/strong_hit.wav",
	"zmwpn/zb_knife/strong_hitwall.wav",
	"zmwpn/zb_knife/strong_slash.wav",
	"zmwpn/zb_knife/strong_slash.wav",
	"zmwpn/zb_knife/strong_stab.wav"
}

new const axe_sounds[][] =
{
	"zmwpn/zb_knife/pfireknife_deploy.wav",
	"zmwpn/zb_knife/pfireknife_hit.wav",
	"zmwpn/zb_knife/pfireknife_hit.wav",
	"zmwpn/zb_knife/pfireknife_hit.wav",
	"zmwpn/zb_knife/pfireknife_hit.wav",
	"zmwpn/zb_knife/pfireknife_hitwall.wav",
	"zmwpn/zb_knife/pfireknife_slash.wav",
	"zmwpn/zb_knife/pfireknife_slash.wav",
	"zmwpn/zb_knife/pfireknife_stab.wav"
}

new const katana_sounds[][] =
{
	"zmwpn/zb_knife/katana_deploy.wav",
	"zmwpn/zb_knife/katana_hit.wav",
	"zmwpn/zb_knife/katana_hit.wav",
	"zmwpn/zb_knife/katana_hit.wav",
	"zmwpn/zb_knife/katana_hit.wav",
	"zmwpn/zb_knife/katana_hitwall.wav",
	"zmwpn/zb_knife/katana_slash.wav",
	"zmwpn/zb_knife/katana_slash.wav",
	"zmwpn/zb_knife/katana_stab.wav"
}

new const hammer_sounds[][] =
{
	"zmwpn/zb_knife/hammer_deploy.wav",
	"zmwpn/zb_knife/hammer_hit.wav",
	"zmwpn/zb_knife/hammer_hit.wav",
	"zmwpn/zb_knife/hammer_hit.wav",
	"zmwpn/zb_knife/hammer_hit.wav",
	"zmwpn/zb_knife/hammer_hitwall.wav",
	"zmwpn/zb_knife/hammer_slash.wav",
	"zmwpn/zb_knife/hammer_slash.wav",
	"zmwpn/zb_knife/hammer_stab.wav"
}

new const oldknife_sounds[][] =
{
	"weapons/knife_deploy1.wav",
	"weapons/knife_hit1.wav",
	"weapons/knife_hit2.wav",
	"weapons/knife_hit3.wav",
	"weapons/knife_hit4.wav",
	"weapons/knife_hitwall1.wav",
	"weapons/knife_slash1.wav",
	"weapons/knife_slash2.wav",
	"weapons/knife_stab.wav"
}

public plugin_init()
{
	register_plugin(PLUGIN , VERSION , AUTHOR);
	register_cvar("zp_addon_knife", VERSION, FCVAR_SERVER);
        SayText = get_user_msgid("SayText")   

 	register_clcmd("say /knife","knife_menu",ADMIN_ALL,"knife_menu")
 	register_clcmd("/knife","knife_menu",ADMIN_ALL,"knife_menu")
	register_clcmd("combat", "give_combat")
	register_clcmd("strong", "give_strong")
	register_clcmd("axe", "give_axe")
	register_clcmd("katana", "give_katana")
	register_clcmd("hammer", "give_hammer")

	register_event("CurWeapon","checkWeapon","be","1=1");
	register_event("Damage" , "event_Damage" , "b" , "2>0");

	register_forward(FM_PlayerPreThink, "fw_PlayerPreThink");
	register_forward(FM_EmitSound, "fw_EmitSound");

	register_message(get_user_msgid("DeathMsg"), "message_DeathMsg");

	RegisterHam(Ham_TakeDamage, "player", "fw_TakeDamage");
        RegisterHam(Ham_Weapon_SecondaryAttack, "weapon_knife", "fw_Knife_SecondaryAttack_Post", 1) 

	cvar_knife_combat_jump= register_cvar("zp_knife_combat_jump", "290.0");
	cvar_knife_combat_spd = register_cvar("zp_knife_combat_spd", "310.0");
	cvar_knife_combat_dmg = register_cvar("zp_knife_combat_dmg" , "5.0");
	cvar_knife_combat_knock = register_cvar("zp_knife_combat_knock" , "6.0");
	cvar_knife_combat_spd_attack2 = register_cvar("zp_knife_combat_spd_attack2" , "1.3");

	cvar_knife_strong_jump= register_cvar("zp_knife_strong_jump", "290.0");
	cvar_knife_strong_spd = register_cvar("zp_knife_strong_spd", "270.0");
	cvar_knife_strong_dmg = register_cvar("zp_knife_strong_dmg" , "11.0");
	cvar_knife_strong_knock = register_cvar("zp_knife_strong_knock" , "8.0");
	cvar_knife_strong_spd_attack2 = register_cvar("zp_knife_strong_spd_attack2" , "1.8");

	cvar_knife_axe_jump= register_cvar("zp_knife_axe_jump", "350.0");
	cvar_knife_axe_spd = register_cvar("zp_knife_axe_spd", "270.0");
	cvar_knife_axe_dmg = register_cvar("zp_knife_axe_dmg" , "6.0");
	cvar_knife_axe_knock = register_cvar("zp_knife_axe_knock" , "6.0");
	cvar_knife_axe_spd_attack2 = register_cvar("zp_knife_axe_spd_attack2" , "1.5");

	cvar_knife_katana_jump= register_cvar("zp_knife_katana_jump", "290.0");
	cvar_knife_katana_spd = register_cvar("zp_knife_katana_spd", "270.0");
	cvar_knife_katana_dmg = register_cvar("zp_knife_katana_dmg" , "5.5");
	cvar_knife_katana_knock = register_cvar("zp_knife_katana_knock" , "12.5");
	cvar_knife_katana_spd_attack2 = register_cvar("zp_knife_katana_spd_attack2" , "1.3");

	cvar_knife_hammer_jump= register_cvar("zp_knife_hammer_jump", "320.0");
	cvar_knife_hammer_spd= register_cvar("zp_knife_hammer_spd", "300.0");
	cvar_knife_hammer_dmg = register_cvar("zp_knife_hammer_dmg" , "12.0");
	cvar_knife_hammer_knock = register_cvar("zp_knife_hammer_knock" , "13.0");
	cvar_hammer_spd_attack2 = register_cvar("zp_knife_hammer_spd_attack2" , "1.5");

    	register_event("HLTV", "event_round_start", "a", "1=0", "2=0")
}

public client_connect(id)
{
	g_knife_combat[id] = false
	g_knife_strong[id] = false
	g_knife_axe[id] = false
	g_knife_katana[id] = false
	g_knife_hammer[id] = false
	g_hasSpeed[id] = false
}

public client_disconnect(id)
{
	g_knife_combat[id] = false
	g_knife_strong[id] = false
	g_knife_axe[id] = false
	g_knife_katana[id] = false
	g_knife_hammer[id] = false
	g_hasSpeed[id] = false
}

public plugin_precache()
{
	precache_model(combat_v_model)
	precache_model(combat_p_model)
	precache_model(strong_v_model)
	precache_model(strong_p_model)
	precache_model(axe_v_model)
	precache_model(axe_p_model)
	precache_model(katana_v_model)
	precache_model(katana_p_model)
	precache_model(hammer_v_model)
	precache_model(hammer_p_model)

	precache_sound(g_sound_knife)

	for(new i = 0; i < sizeof combat_sounds; i++)
		precache_sound(combat_sounds[i])

	for(new i = 0; i < sizeof strong_sounds; i++)
		precache_sound(strong_sounds[i])

	for(new i = 0; i < sizeof axe_sounds; i++)
		precache_sound(axe_sounds[i])  

	for(new i = 0; i < sizeof katana_sounds; i++)
		precache_sound(katana_sounds[i])

	for(new i = 0; i < sizeof hammer_sounds; i++)
		precache_sound(hammer_sounds[i])
}

public event_round_start(id)
{
    	for (new i; i < MAXPLAYERS + 1; i++)
        	g_WasShowed[i] = false
}

public knife_menu(id)
{
    	if (g_WasShowed[id])
    	{
        	print_col_chat(id, "^x04[Kés Menü]^x01Körönként 1x van lehetőséged elhöhívni a [Kés menü] -t!")
        	return PLUGIN_HANDLED
   	 }

	if(is_user_alive(id) && !zp_get_user_zombie(id))
	{
		my_menu(id)
	}

	return PLUGIN_HANDLED
}

public my_menu(id)
{
	new menu = menu_create("\y[ZP] Kés Menü", "menu_handler");
	menu_additem(menu, "\wCombat \y[ Gyors futás +40 ]", "1", 0);
	menu_additem(menu, "\wStrong \y[ Erös ütés +50 ]", "2", 0);
	menu_additem(menu, "\wBlade \y[ Magas Ugrás +45 ]", "3", 0);
	menu_additem(menu, "\wKatana \y[ Magas Visszalökés +55 ]", "4", 0);
	menu_additem(menu, "\wHammer \r[ . * VIP * . ]", "5", ADMIN_LEVEL_H);
    
	menu_setprop(menu, MPROP_EXIT, MEXIT_ALL);
    
	menu_display(id, menu, 0);    
} 

public menu_handler(id, menu, item)
{
	if( item == MENU_EXIT )
	{
       		menu_destroy(menu);
        	return PLUGIN_HANDLED;    
	}
    
	new data[6], iName[64];
	new access, callback;
    
	menu_item_getinfo(menu, item, access, data,5, iName, 63, callback);
    
	new key = str_to_num(data);
    
	switch(key)
	{
        	case 1:
        	{
			give_combat(id)
			menu_destroy(menu);
			return PLUGIN_HANDLED
		}
		case 2:
		{
			give_strong(id)
			menu_destroy(menu);
			return PLUGIN_HANDLED
		}
		case 3:
		{
			give_axe(id)
			menu_destroy(menu);
			return PLUGIN_HANDLED
		}
		case 4:
		{
			give_katana(id)
			menu_destroy(menu);
			return PLUGIN_HANDLED
		}
		case 5:
		{
               		set_user_armor(id, get_user_armor(id) + 50)
			give_hammer(id)
			menu_destroy(menu);
			return PLUGIN_HANDLED
		}
	}
	menu_destroy(menu);
	return PLUGIN_HANDLED
}

public give_combat(id)
{
	g_knife_combat[id] = true	
	g_knife_strong[id] = false
	g_knife_axe[id] = false	
	g_knife_katana[id] = false	
	g_knife_hammer[id] = false
	g_hasSpeed[id] =  true
	g_WasShowed[id] = true

	engfunc(EngFunc_EmitSound, id, CHAN_BODY, g_sound_knife, 1.0, ATTN_NORM, 0, PITCH_NORM)
}

public give_strong(id)
{
	g_knife_combat[id] = false	
	g_knife_strong[id] = true	
	g_knife_axe[id] = false
	g_knife_katana[id] = false	
	g_knife_hammer[id] = false
	g_hasSpeed[id] = true
	g_WasShowed[id] = true

	engfunc(EngFunc_EmitSound, id, CHAN_BODY, g_sound_knife, 1.0, ATTN_NORM, 0, PITCH_NORM)
}

public give_axe(id)
{
	g_knife_combat[id] = false	
	g_knife_strong[id] = false	
	g_knife_axe[id] = true
	g_knife_katana[id] = false	
	g_knife_hammer[id] = false
	g_hasSpeed[id] = true
	g_WasShowed[id] = true

	engfunc(EngFunc_EmitSound, id, CHAN_BODY, g_sound_knife, 1.0, ATTN_NORM, 0, PITCH_NORM)
}

public give_katana(id)
{
	g_knife_combat[id] = false	
	g_knife_strong[id] = false	
	g_knife_axe[id] = false
	g_knife_katana[id] = true	
	g_knife_hammer[id] = false
	g_hasSpeed[id] = true
	g_WasShowed[id] = true

	engfunc(EngFunc_EmitSound, id, CHAN_BODY, g_sound_knife, 1.0, ATTN_NORM, 0, PITCH_NORM)
}


public give_hammer(id)
{
	if (get_user_flags(id) & VIP)
	{
		g_knife_combat[id] = false	
		g_knife_strong[id] = false	
		g_knife_axe[id] = false
		g_knife_katana[id] = false
		g_knife_hammer[id] = true
		g_hasSpeed[id] =  true
		g_WasShowed[id] = true

		engfunc(EngFunc_EmitSound, id, CHAN_BODY, g_sound_knife, 1.0, ATTN_NORM, 0, PITCH_NORM)
	}
	else 
	{
		client_cmd(id, "/knife")
		g_WasShowed[id] = true
	}
}

public checkWeapon(id)
{
	new plrWeapId
    
	plrWeapId = get_user_weapon(id)
    
	if (plrWeapId == CSW_KNIFE && (g_knife_combat[id] || g_knife_strong[id] || g_knife_axe[id] || g_knife_katana[id] || g_knife_hammer[id]))
	{
		checkModel(id)
	}
}

public checkModel(id)
{
	if (zp_get_user_zombie(id))
		return PLUGIN_HANDLED
    
	if (g_knife_combat[id])
	{
		set_pev(id, pev_viewmodel2, combat_v_model)
		set_pev(id, pev_weaponmodel2, combat_p_model)
	}

	if (g_knife_strong[id])
	{
		set_pev(id, pev_viewmodel2, strong_v_model)
		set_pev(id, pev_weaponmodel2, strong_p_model)
	}

	if (g_knife_axe[id])
	{
		set_pev(id, pev_viewmodel2, axe_v_model)
		set_pev(id, pev_weaponmodel2, axe_p_model)
	}

	if (g_knife_katana[id])
	{
		set_pev(id, pev_viewmodel2, katana_v_model)
		set_pev(id, pev_weaponmodel2, katana_p_model)
	}

	if (g_knife_hammer[id])
	{
		set_pev(id, pev_viewmodel2, hammer_v_model)
		set_pev(id, pev_weaponmodel2, hammer_p_model)
	}
	return PLUGIN_HANDLED
}

public fw_EmitSound(id, channel, const sound[])
{
	if(!is_user_alive(id) || zp_get_user_zombie(id))
		return FMRES_IGNORED
        
	for(new i = 0; i < sizeof combat_sounds; i++) 
	for(new i = 0; i < sizeof strong_sounds; i++)
	for(new i = 0; i < sizeof axe_sounds; i++)
	for(new i = 0; i < sizeof katana_sounds; i++)
	for(new i = 0; i < sizeof hammer_sounds; i++)
	{
		if(equal(sound, oldknife_sounds[i]))
		{
			if (g_knife_combat[id])
			{
				emit_sound(id, channel, combat_sounds[i], 1.0, ATTN_NORM, 0, PITCH_NORM)
				return FMRES_SUPERCEDE
			}
			if (g_knife_strong[id])
			{
				emit_sound(id, channel, strong_sounds[i], 1.0, ATTN_NORM, 0, PITCH_NORM)
				return FMRES_SUPERCEDE
			}
			if (g_knife_axe[id])
			{
				emit_sound(id, channel, axe_sounds[i], 1.0, ATTN_NORM, 0, PITCH_NORM)
				return FMRES_SUPERCEDE
			}
			if (g_knife_katana[id])
			{
				emit_sound(id, channel, katana_sounds[i], 1.0, ATTN_NORM, 0, PITCH_NORM)
				return FMRES_SUPERCEDE
			}
			if (g_knife_hammer[id])
			{
				emit_sound(id, channel, hammer_sounds[i], 1.0, ATTN_NORM, 0, PITCH_NORM)
				return FMRES_SUPERCEDE
			}
			if (!g_knife_combat[id] || !g_knife_strong[id] || !g_knife_axe[id] || !g_knife_katana[id] || !g_knife_hammer[id])
			{
				emit_sound(id, channel, oldknife_sounds[i], 1.0, ATTN_NORM, 0, PITCH_NORM)
				return FMRES_SUPERCEDE
			}
		}
	}
	return FMRES_IGNORED
}

public message_DeathMsg(msg_id, msg_dest, id)
{
	static szTruncatedWeapon[33], iattacker, ivictim
	
	get_msg_arg_string(4, szTruncatedWeapon, charsmax(szTruncatedWeapon))
	
	iattacker = get_msg_arg_int(1)
	ivictim = get_msg_arg_int(2)
	
	if(!is_user_connected(iattacker) || iattacker == ivictim)
		return PLUGIN_CONTINUE

	if (!zp_get_user_zombie(iattacker))
	{
		if(equal(szTruncatedWeapon, "knife") && get_user_weapon(iattacker) == CSW_KNIFE)
		{
			if(g_knife_combat[iattacker])
				set_msg_arg_string(4, "Combat knife")
		}
	
		if(equal(szTruncatedWeapon, "knife") && get_user_weapon(iattacker) == CSW_KNIFE)
		{
			if(g_knife_strong[iattacker])
				set_msg_arg_string(4, "Strong knife")
		}

		if(equal(szTruncatedWeapon, "knife") && get_user_weapon(iattacker) == CSW_KNIFE)
		{
			if(g_knife_axe[iattacker])
				set_msg_arg_string(4, "Blade knife")
		}

		if(equal(szTruncatedWeapon, "knife") && get_user_weapon(iattacker) == CSW_KNIFE)
		{
			if(g_knife_katana[iattacker])
				set_msg_arg_string(4, "Katana knife")
		}

		if(equal(szTruncatedWeapon, "knife") && get_user_weapon(iattacker) == CSW_KNIFE)
		{
			if(g_knife_hammer[iattacker])
				set_msg_arg_string(4, "Ice knife")
		}
	}
	return PLUGIN_CONTINUE
}

stock print_col_chat(const id, const input[], any:...)  
{  
	new count = 1, players[32];  
    	static msg[191];  
    	vformat(msg, 190, input, 3);  
    	replace_all(msg, 190, "!g", "^4"); // Green Color  
    	replace_all(msg, 190, "!y", "^1"); // Default Color 
    	replace_all(msg, 190, "!t", "^3"); // Team Color  
    	if (id) players[0] = id; else get_players(players, count, "ch");  
    	{  
        	for ( new i = 0; i < count; i++ )  
        	{  
            		if ( is_user_connected(players[i]) )  
            		{  
                		message_begin(MSG_ONE_UNRELIABLE, SayText, _, players[i]);  
                		write_byte(players[i]);  
                		write_string(msg);  
                		message_end();  
            		}  
        	}  
    	}  
}   

public fw_PlayerPreThink(id)
{
	if(!is_user_alive(id) || zp_get_user_zombie(id))
		return FMRES_IGNORED

	new temp[2], weapon = get_user_weapon(id, temp[0], temp[1])

	if (weapon == CSW_KNIFE && g_knife_combat[id])
	{
		g_hasSpeed[id] = true
		set_pev(id, pev_maxspeed, get_pcvar_float(cvar_knife_combat_spd))
	}

	if(weapon == CSW_KNIFE && g_knife_combat[id])        
		if ((pev(id, pev_button) & IN_JUMP) && !(pev(id, pev_oldbuttons) & IN_JUMP))
		{
			new flags = pev(id, pev_flags)
			new waterlvl = pev(id, pev_waterlevel)
			
			if (!(flags & FL_ONGROUND))
				return FMRES_IGNORED

			if (flags & FL_WATERJUMP)
				return FMRES_IGNORED

			if (waterlvl > 1)
				return FMRES_IGNORED
			
			new Float:fVelocity[3]
			pev(id, pev_velocity, fVelocity)
			
			fVelocity[2] += get_pcvar_num(cvar_knife_combat_jump)
			
			set_pev(id, pev_velocity, fVelocity)
			set_pev(id, pev_gaitsequence, 6)
		}
	if (weapon == CSW_KNIFE && g_knife_strong[id])
	{
		g_hasSpeed[id] = true
		set_pev(id, pev_maxspeed, get_pcvar_float(cvar_knife_strong_spd))

		if ((pev(id, pev_button) & IN_JUMP) && !(pev(id, pev_oldbuttons) & IN_JUMP))
		{
			new flags = pev(id, pev_flags)
			new waterlvl = pev(id, pev_waterlevel)
			
			if (!(flags & FL_ONGROUND))
				return FMRES_IGNORED

			if (flags & FL_WATERJUMP)
				return FMRES_IGNORED

			if (waterlvl > 1)
				return FMRES_IGNORED
			
			new Float:fVelocity[3]
			pev(id, pev_velocity, fVelocity)
			
			fVelocity[2] += get_pcvar_num(cvar_knife_strong_jump)
			
			set_pev(id, pev_velocity, fVelocity)
			set_pev(id, pev_gaitsequence, 6)
		}
	}
	if (weapon == CSW_KNIFE && g_knife_axe[id])
	{
		g_hasSpeed[id] = true
		set_pev(id, pev_maxspeed, get_pcvar_float(cvar_knife_axe_spd))

		if ((pev(id, pev_button) & IN_JUMP) && !(pev(id, pev_oldbuttons) & IN_JUMP))
		{
			new flags = pev(id, pev_flags)
			new waterlvl = pev(id, pev_waterlevel)
			
			if (!(flags & FL_ONGROUND))
				return FMRES_IGNORED

			if (flags & FL_WATERJUMP)
				return FMRES_IGNORED

			if (waterlvl > 1)
				return FMRES_IGNORED
			
			new Float:fVelocity[3]
			pev(id, pev_velocity, fVelocity)
			
			fVelocity[2] += get_pcvar_num(cvar_knife_axe_jump)
			
			set_pev(id, pev_velocity, fVelocity)
			set_pev(id, pev_gaitsequence, 6)
		}
	}
	if (weapon == CSW_KNIFE && g_knife_katana[id])
	{
		g_hasSpeed[id] = true
		set_pev(id, pev_maxspeed, get_pcvar_float(cvar_knife_katana_spd))

		if ((pev(id, pev_button) & IN_JUMP) && !(pev(id, pev_oldbuttons) & IN_JUMP))
		{
			new flags = pev(id, pev_flags)
			new waterlvl = pev(id, pev_waterlevel)
			
			if (!(flags & FL_ONGROUND))
				return FMRES_IGNORED

			if (flags & FL_WATERJUMP)
				return FMRES_IGNORED

			if (waterlvl > 1)
				return FMRES_IGNORED
			
			new Float:fVelocity[3]
			pev(id, pev_velocity, fVelocity)
			
			fVelocity[2] += get_pcvar_num(cvar_knife_katana_jump)
			
			set_pev(id, pev_velocity, fVelocity)
			set_pev(id, pev_gaitsequence, 6)
		}
	}
	if (weapon == CSW_KNIFE && g_knife_hammer[id])
	{
		g_hasSpeed[id] = true
		set_pev(id, pev_maxspeed, get_pcvar_float(cvar_knife_hammer_spd))

		if ((pev(id, pev_button) & IN_JUMP) && !(pev(id, pev_oldbuttons) & IN_JUMP))
		{
			new flags = pev(id, pev_flags)
			new waterlvl = pev(id, pev_waterlevel)
			
			if (!(flags & FL_ONGROUND))
				return FMRES_IGNORED

			if (flags & FL_WATERJUMP)
				return FMRES_IGNORED

			if (waterlvl > 1)
				return FMRES_IGNORED
			
			new Float:fVelocity[3]
			pev(id, pev_velocity, fVelocity)
			
			fVelocity[2] += get_pcvar_num(cvar_knife_hammer_jump)
			
			set_pev(id, pev_velocity, fVelocity)
			set_pev(id, pev_gaitsequence, 6)
		}
	}
	return FMRES_IGNORED
}  

public fw_TakeDamage(victim, inflictor, attacker, Float:damage, damage_type)
{
	if(!is_user_connected(attacker))
		return HAM_IGNORED
	
	if(zp_get_user_zombie(attacker))
		return HAM_IGNORED

	new weapon = get_user_weapon(attacker)

	if (weapon == CSW_KNIFE && g_knife_combat[attacker])
	{	
		SetHamParamFloat(4, damage * get_pcvar_float(cvar_knife_combat_dmg))
	}
	if (weapon == CSW_KNIFE && g_knife_strong[attacker])
	{	
		SetHamParamFloat(4, damage * get_pcvar_float(cvar_knife_strong_dmg))
	}
	if (weapon == CSW_KNIFE && g_knife_axe[attacker])
	{	
		SetHamParamFloat(4, damage * get_pcvar_float(cvar_knife_axe_dmg))
	}
	if (weapon == CSW_KNIFE && g_knife_katana[attacker])
	{	
		SetHamParamFloat(4, damage * get_pcvar_float(cvar_knife_katana_dmg))
	}
		
	if (weapon == CSW_KNIFE && g_knife_hammer[attacker])
	{	 
		SetHamParamFloat(4, damage * get_pcvar_float(cvar_knife_hammer_dmg))
	}

	return HAM_IGNORED
}

public fw_Knife_SecondaryAttack_Post(knife) 
{     
    	static id 
    	id = get_pdata_cbase(knife, m_pPlayer, 4) 

    	if(zp_get_user_zombie(id))
		return HAM_IGNORED
    
    	if(is_user_connected(id) && g_knife_combat[id]) 
    	{ 
        	static Float:flRate 
        	flRate = get_pcvar_float(cvar_knife_combat_spd_attack2) 
         
        	set_pdata_float(knife, m_flNextPrimaryAttack, flRate, 4) 
        	set_pdata_float(knife, m_flNextSecondaryAttack, flRate, 4) 
        	set_pdata_float(knife, m_flTimeWeaponIdle, flRate, 4) 
    	} 
 
    	if(is_user_connected(id) && g_knife_strong[id]) 
    	{ 
        	static Float:flRate 
        	flRate = get_pcvar_float(cvar_knife_strong_spd_attack2) 
        	 
        	set_pdata_float(knife, m_flNextPrimaryAttack, flRate, 4) 
        	set_pdata_float(knife, m_flNextSecondaryAttack, flRate, 4) 
        	set_pdata_float(knife, m_flTimeWeaponIdle, flRate, 4) 
    	} 

    	if(is_user_connected(id) && g_knife_axe[id]) 
    	{ 
        	static Float:flRate 
        	flRate = get_pcvar_float(cvar_knife_axe_spd_attack2) 
        		 
        	set_pdata_float(knife, m_flNextPrimaryAttack, flRate, 4) 
        	set_pdata_float(knife, m_flNextSecondaryAttack, flRate, 4) 
        	set_pdata_float(knife, m_flTimeWeaponIdle, flRate, 4) 
    	} 

    	if(is_user_connected(id) && g_knife_katana[id]) 
    	{ 
        	static Float:flRate 
        	flRate = get_pcvar_float(cvar_knife_katana_spd_attack2) 
        		 
        	set_pdata_float(knife, m_flNextPrimaryAttack, flRate, 4) 
        	set_pdata_float(knife, m_flNextSecondaryAttack, flRate, 4) 
        	set_pdata_float(knife, m_flTimeWeaponIdle, flRate, 4) 
    	} 

    	if(is_user_connected(id) && g_knife_hammer[id]) 
    	{ 
        	static Float:flRate 
        	flRate = get_pcvar_float(cvar_hammer_spd_attack2) 
        	 
        	set_pdata_float(knife, m_flNextPrimaryAttack, flRate, 4) 
        	set_pdata_float(knife, m_flNextSecondaryAttack, flRate, 4) 
        	set_pdata_float(knife, m_flTimeWeaponIdle, flRate, 4) 
    	} 	
   
    	return HAM_IGNORED 
} 

public event_Damage(id)
{
	new weapon , attacker = get_user_attacker(id , weapon);

	if(!is_user_alive(attacker))
		return PLUGIN_CONTINUE;

	if(weapon == CSW_KNIFE && g_knife_combat[attacker])
	{
		new Float:vec[3];
		new Float:oldvelo[3];
		get_user_velocity(id, oldvelo);
		create_velocity_vector(id , attacker , vec);
		vec[0] += oldvelo[0];
		vec[1] += oldvelo[1];
		set_user_velocity(id , vec);
	}

	if(weapon == CSW_KNIFE && g_knife_strong[attacker])
	{
		new Float:vec[3];
		new Float:oldvelo[3];
		get_user_velocity(id, oldvelo);
		create_velocity_vector(id , attacker , vec);
		vec[0] += oldvelo[0];
		vec[1] += oldvelo[1];
		set_user_velocity(id , vec);
	}

	if(weapon == CSW_KNIFE && g_knife_axe[attacker])
	{
		new Float:vec[3];
		new Float:oldvelo[3];
		get_user_velocity(id, oldvelo);
		create_velocity_vector(id , attacker , vec);
		vec[0] += oldvelo[0];
		vec[1] += oldvelo[1];
		set_user_velocity(id , vec);
	}

	if(weapon == CSW_KNIFE && g_knife_katana[attacker])
	{
		new Float:vec[3];
		new Float:oldvelo[3];
		get_user_velocity(id, oldvelo);
		create_velocity_vector(id , attacker , vec);
		vec[0] += oldvelo[0];
		vec[1] += oldvelo[1];
		set_user_velocity(id , vec);
	}

	if(weapon == CSW_KNIFE && g_knife_hammer[attacker])
	{
		new Float:vec[3];
		new Float:oldvelo[3];
		get_user_velocity(id, oldvelo);
		create_velocity_vector(id , attacker , vec);
		vec[0] += oldvelo[0];
		vec[1] += oldvelo[1];
		set_user_velocity(id , vec);
	}

	return PLUGIN_CONTINUE;
}

stock create_velocity_vector(victim,attacker,Float:velocity[3])
{
	if(!zp_get_user_zombie(victim) || !is_user_alive(attacker))
		return 0;

	new Float:vicorigin[3];
	new Float:attorigin[3];
	entity_get_vector(victim   , EV_VEC_origin , vicorigin);
	entity_get_vector(attacker , EV_VEC_origin , attorigin);

	new Float:origin2[3]
	origin2[0] = vicorigin[0] - attorigin[0];
	origin2[1] = vicorigin[1] - attorigin[1];

	new Float:largestnum = 0.0;

	if(floatabs(origin2[0])>largestnum) largestnum = floatabs(origin2[0]);
	if(floatabs(origin2[1])>largestnum) largestnum = floatabs(origin2[1]);

	origin2[0] /= largestnum;
	origin2[1] /= largestnum;

	if (g_knife_combat[attacker])
	{
		velocity[0] = ( origin2[0] * (get_pcvar_float(cvar_knife_combat_knock) * 3000) ) / get_entity_distance(victim , attacker);
		velocity[1] = ( origin2[1] * (get_pcvar_float(cvar_knife_combat_knock) * 3000) ) / get_entity_distance(victim , attacker);
	}

	if (g_knife_strong[attacker])
	{
		velocity[0] = ( origin2[0] * (get_pcvar_float(cvar_knife_strong_knock) * 3000) ) / get_entity_distance(victim , attacker);
		velocity[1] = ( origin2[1] * (get_pcvar_float(cvar_knife_strong_knock) * 3000) ) / get_entity_distance(victim , attacker);
	}

	if (g_knife_axe[attacker])
	{
		velocity[0] = ( origin2[0] * (get_pcvar_float(cvar_knife_axe_knock) * 3000) ) / get_entity_distance(victim , attacker);
		velocity[1] = ( origin2[1] * (get_pcvar_float(cvar_knife_axe_knock) * 3000) ) / get_entity_distance(victim , attacker);
	}

	if (g_knife_katana[attacker])
	{
		velocity[0] = ( origin2[0] * (get_pcvar_float(cvar_knife_katana_knock) * 3000) ) / get_entity_distance(victim , attacker);
		velocity[1] = ( origin2[1] * (get_pcvar_float(cvar_knife_katana_knock) * 3000) ) / get_entity_distance(victim , attacker);
	}

	if (g_knife_hammer[attacker])
	{
		velocity[0] = ( origin2[0] * (get_pcvar_float(cvar_knife_hammer_knock) * 3000) ) / get_entity_distance(victim , attacker);
		velocity[1] = ( origin2[1] * (get_pcvar_float(cvar_knife_hammer_knock) * 3000) ) / get_entity_distance(victim , attacker);
	}

	if(velocity[0] <= 20.0 || velocity[1] <= 20.0)
		velocity[2] = random_float(200.0 , 275.0);

	return 1;
}

public client_putinserver(id)
{
	switch(random_num(0, 0))
	{
		case 0:
		{
			g_knife_combat[id] = true
			g_hasSpeed[id] = true
		}

	}
}