#include <amxmodx>
#include <fakemeta>
#include <hamsandwich>
#include <zombieplague>

#define PLUGIN "[ZP] Addon: Evolucio"
#define VERSION "1.0"
#define AUTHOR "Dias"

#define TASK_GLOWSHELL 123123
#define TASK_SHOWHUD 321321

#define HUD_DELAY_TIME 0.25

new g_sync_hud1, g_sync_hud2
new g_level[33]
const MAX_LEVEL_HUMAN = 10

// Human Evolution Vars + Config
new const levelup_sound[] = "zombie_plague/levelup.wav"
new id_sprites_levelup
new const sprites_effects_levelup[] = "sprites/zombie_plague/levelup.spr"

new Float:XDAMAGE[11] = {
	1.0,
	1.1,
	1.2,
	1.3,
	1.4,
	1.5,
	1.6,
	1.7,
	1.8,
	1.9,
	2.0
}

public plugin_init() 
{
	register_plugin(PLUGIN, VERSION, AUTHOR)
	
	register_event("DeathMsg", "event_death", "a")
	register_event("HLTV", "event_newround", "a", "1=0", "2=0")
	
	RegisterHam(Ham_Spawn, "player", "fw_spawn_post", 1)
	RegisterHam(Ham_TakeDamage, "player", "fw_takedamage")
	
	g_sync_hud1 = CreateHudSyncObj(18)
	g_sync_hud2 = CreateHudSyncObj(19)
}

public plugin_precache()
{
	engfunc(EngFunc_PrecacheSound, levelup_sound)
	
	// Precache Sprites
	id_sprites_levelup = precache_model(sprites_effects_levelup)	
}

public zp_user_humanized_post(id)
{
	fw_spawn_post(id)
}

public zp_user_infected_post(id)
{
	g_level[id] = 0
	
	set_hudmessage(0, 0, 0, -1.0, 0.83, 0, 2.0, 2.0)
	ShowSyncHudMsg(id, g_sync_hud1, "")
	
	remove_task(id+TASK_GLOWSHELL)
	remove_task(id+TASK_SHOWHUD)
}

public event_newround()
{
	static id
	for (id = 1; id <= get_maxplayers(); id++)
	{
		if (is_user_alive(id) && !zp_get_user_zombie(id) && !zp_get_user_nemesis(id) && !zp_get_user_survivor(id))
		{
			g_level[id] = 0
		}
	}	
}

public event_death()
{
	new attacker = read_data(1)
	new victim = read_data(2) 	
	
	// Zombie Die
	if (zp_get_user_zombie(victim) && !zp_get_user_zombie(attacker))
	{
		UpdateLevelTeamHuman()
	}	
}

public fw_spawn_post(id)
{
	if (is_user_alive(id) && !zp_get_user_zombie(id) && !zp_get_user_nemesis(id) && !zp_get_user_survivor(id))
	{
		set_task(HUD_DELAY_TIME, "show_hud", id+TASK_SHOWHUD, _, _, "b")
	}	
}

public fw_takedamage(victim, inflictor, attacker, Float:damage, damagetype)
{
	if(damagetype & DMG_GENERIC || victim == attacker || !is_user_alive(victim) || !is_user_connected(attacker))
		return HAM_IGNORED

	if((damagetype & (1<<24)) && zp_get_user_zombie(attacker))
		return HAM_IGNORED	
	
	if(!zp_get_user_zombie(attacker) && !zp_get_user_nemesis(attacker) && !zp_get_user_survivor(attacker))
	{
		if (g_level[attacker])
		{
			new Float: xdmg = XDAMAGE[g_level[attacker]]
			damage *= xdmg
		}

		SetHamParamFloat(4, damage)
	}
	
	return HAM_HANDLED
}

public show_hud(taskid)
{
	new id = taskid - TASK_SHOWHUD
	
	if (is_user_alive(id) && !zp_get_user_zombie(id) && !zp_get_user_nemesis(id) && !zp_get_user_survivor(id))
	{
		show_hud_text(id)
	} else {
		set_hudmessage(0, 0, 0, -1.0, 0.83, 0, 2.0, 2.0)
		ShowSyncHudMsg(id, g_sync_hud1, "")		
		
		remove_task(taskid)
		remove_task(id+TASK_GLOWSHELL)
	}
}

public UpdateLevelTeamHuman()
{
	static id
	for (id = 1; id <= get_maxplayers(); id++)
	{
		if (is_user_alive(id) && !zp_get_user_zombie(id) && !zp_get_user_nemesis(id) && !zp_get_user_survivor(id))
		{
			UpdateLevelHuman(id, 1)
		}
	}
	
	return 1	
}

public UpdateLevelHuman(id, num)
{
	// update level
	g_level[id] += num
	if (g_level[id] > MAX_LEVEL_HUMAN)
	{
		g_level[id] = MAX_LEVEL_HUMAN
	}
	else
	{
		// Play Sound
		PlaySound2(id, levelup_sound)
		
		// Effect
		EffectLevelUp(id)

		// show hudtext
		set_hudmessage(0, 255, 0, -1.0, 0.40, 1, 5.0, 5.0)
		ShowSyncHudMsg(id, g_sync_hud2, "Level Up to %i !!!", g_level[id])
	}
}

public EffectLevelUp(id)
{
	if (!is_user_alive(id)) return;
	
	// get origin
	static Float:origin[3]
	pev(id, pev_origin, origin)
	
	// set color
	new color[3]
	color[0] = get_color_level(id, 0)
	color[1] = get_color_level(id, 1)
	color[2] = get_color_level(id, 2)

	// create effect
	engfunc(EngFunc_MessageBegin, MSG_ALL, SVC_TEMPENTITY, origin, 0)
	write_byte(TE_BEAMCYLINDER) // TE id
	engfunc(EngFunc_WriteCoord, origin[0]) // x
	engfunc(EngFunc_WriteCoord, origin[1]) // y
	engfunc(EngFunc_WriteCoord, origin[2]) // z
	engfunc(EngFunc_WriteCoord, origin[0]) // x axis
	engfunc(EngFunc_WriteCoord, origin[1]) // y axis
	engfunc(EngFunc_WriteCoord, origin[2]+100.0) // z axis
	write_short(id_sprites_levelup) // sprite
	write_byte(0) // startframe
	write_byte(0) // framerate
	write_byte(4) // life
	write_byte(60) // width
	write_byte(0) // noise
	write_byte(color[0]) // red
	write_byte(color[1]) // green
	write_byte(color[2]) // blue
	write_byte(200) // brightness
	write_byte(0) // speed
	message_end()
	
	// create glow shell
	fm_set_rendering(id)
	fm_set_rendering(id, kRenderFxGlowShell, color[0], color[1], color[2], kRenderNormal, 0)
	if (task_exists(id+TASK_GLOWSHELL)) remove_task(id+TASK_GLOWSHELL)
	set_task(10.0, "RemoveGlowShell", id+TASK_GLOWSHELL)
}

public RemoveGlowShell(taskid)
{
	new id = taskid - TASK_GLOWSHELL
	fm_set_rendering(id)
	
	if(task_exists(taskid)) remove_task(taskid)
}

public show_hud_text(id)
{
	static level_color[3]
	
	level_color[0] = get_color_level(id, 0)
	level_color[1] = get_color_level(id, 1)
	level_color[2] = get_color_level(id, 2)
	
	set_hudmessage(level_color[0], level_color[1], level_color[2], -1.0, 0.83, 0, 2.0, 2.0)
	
	if(g_level[id] == 0)
	{
		ShowSyncHudMsg(id, g_sync_hud1, "Szint: 100%%^n[--------------------]")
	} else if(g_level[id] == 1) {
		ShowSyncHudMsg(id, g_sync_hud1, "Szint: 110%%^n[++------------------]")		
	} else if(g_level[id] == 2) {
		ShowSyncHudMsg(id, g_sync_hud1, "Szint: 120%%^n[++++----------------]")		
	} else if(g_level[id] == 3) {
		ShowSyncHudMsg(id, g_sync_hud1, "Szint: 130%%^n[++++++--------------]")		
	} else if(g_level[id] == 4) {
		ShowSyncHudMsg(id, g_sync_hud1, "Szint: 140%%^n[++++++++------------]")		
	} else if(g_level[id] == 5) {
		ShowSyncHudMsg(id, g_sync_hud1, "Szint: 150%%^n[++++++++++----------]")		
	} else if(g_level[id] == 6) {
		ShowSyncHudMsg(id, g_sync_hud1, "Szit: 160%%^n[++++++++++++--------]")		
	} else if(g_level[id] == 7) {
		ShowSyncHudMsg(id, g_sync_hud1, "Szint: 170%%^n[++++++++++++++------]")		
	} else if(g_level[id] == 8) {
		ShowSyncHudMsg(id, g_sync_hud1, "Szint: 180%%^n[++++++++++++++++----]")		
	} else if(g_level[id] == 9) {
		ShowSyncHudMsg(id, g_sync_hud1, "Szint: 190%%^n[++++++++++++++++++--]")		
	} else if(g_level[id] == 10) {
		ShowSyncHudMsg(id, g_sync_hud1, "Szint: 200%%^n[++++++++++++++++++++]")		
	}
}

stock get_color_level(id, num)
{
	new color[3]

	switch (g_level[id])
	{
		case 1: color = {0,177,0}
		case 2: color = {0,177,0}
		case 3: color = {0,177,0}
		case 4: color = {137,191,20}
		case 5: color = {137,191,20}
		case 6: color = {250,229,0}
		case 7: color = {250,229,0}
		case 8: color = {243,127,1}
		case 9: color = {243,127,1}
		case 10: color = {255,3,0}
		case 11: color = {127,40,208}
		case 12: color = {127,40,208}
		case 13: color = {127,40,208}
		default: color = {0,177,0}
	}
	
	return color[num];
}

stock PlaySound2(id, const sound[])
{
	client_cmd(id, "spk ^"%s^"", sound)
}

stock fm_set_rendering(entity, fx = kRenderFxNone, r = 255, g = 255, b = 255, render = kRenderNormal, amount = 16)
{
	static Float:color[3]
	color[0] = float(r)
	color[1] = float(g)
	color[2] = float(b)
	
	set_pev(entity, pev_renderfx, fx)
	set_pev(entity, pev_rendercolor, color)
	set_pev(entity, pev_rendermode, render)
	set_pev(entity, pev_renderamt, float(amount))
}
