/********************************************************/
/* Mega Shop by: TheArmagedon 				*/	
/*							*/
/* ##Weapon Shop##					*/
/* ##Extras Shop##					*/
/* ##Admin Shop##					*/
/*							*/		
/* Change the Cvars on mega_shop.cfg			*/
/*							*/
/* Changelog:						*/
/* v1.1							*/
/* amx_ms_pweapon_damage [DMG] = Default: 2.0		*/
/*							*/
/* v1.2							*/
/* amx_ms_oneround [1/0] = Default: 1			*/
/*							*/	
/* Sorry if my english is bad.				*/
/*							*/
/********************************************************/

////////////////////////////////////////////////////////////////////////////////////////////////////
// INCLUDES
////////////////////////////////////////////////////////////////////////////////////////////////////
#include <amxmodx>
#include <fun>
#include <fakemeta_util>
#include <hamsandwich>
#include <amxmisc>
#include <cstrike>
#include <engine>
////////////////////////////////////////////////////////////////////////////////////////////////////
// Define
////////////////////////////////////////////////////////////////////////////////////////////////////
#include <zombieplague>
#define GET_MONEY(%1) zp_get_user_ammo_packs(%1)
#define SET_MONEY(%1,%2) zp_set_user_ammo_packs(%1, %2)

#define HE_GRENADE	(1<<0)
#define SMOKE_GRENADE	(1<<1)
#define FLASH_GRENADE	(1<<2)

#define MAX_PLAYERS	32
#define MAXSLOTS 32

////////////////////////////////////////////////////////////////////////////////////////////////////
// COLORCHAT
////////////////////////////////////////////////////////////////////////////////////////////////////
enum Color
{
	YELLOW = 1, // Yellow
	GREEN, // Green Color
	TEAM_COLOR, // Red, grey, blue
	GREY, // grey
	RED, // Red
	BLUE, // Blue
}

new TeamInfo;
new SayText;
new MaxSlots;


new TeamName[][] = 
{
	"",
	"TERRORIST",
	"CT",
	"SPECTATOR"
}
new bool:IsConnected[MAXSLOTS + 1];

////////////////////////////////////////////////////////////////////////////////////////////////////
// Pcvars
////////////////////////////////////////////////////////////////////////////////////////////////////
new plugin_onoff, specspeed, speclife, specgrav, gravcost, ammocost, speccost, bhopcost, silentcost, glowcost
new gravityam, bhop_onoff, ammo_onoff, grav_onoff, spec_onoff, silent_onoff, glow_onoff, noclip_onoff
new noclipcost, nocliptime, gmodetime, gmodecost, gmode_onoff, money_onoff, pweapdmgmulti, one_round
// Menus-pcvar
new admmenuon, extrason, weaponson
// Weap.Menu - pcvar
new powerawp, powerak, powercolt
new akcost, awpcost, coltcost

// NOCLIP
#define GetPlayerHullSize(%1)  ( ( pev ( %1, pev_flags ) & FL_DUCKING ) ? HULL_HEAD : HULL_HUMAN )

enum Coord_e { Float:x, Float:y, Float:z };

////////////////////////////////////////////////////////////////////////////////////////////////////
// Bool's
////////////////////////////////////////////////////////////////////////////////////////////////////
new bool:has_awp[33]
new bool:has_ak[33]
new bool:has_colt[33]
new bool:g_Gravity[33]
new bool:g_UnAmmo[33]
new bool:g_Alive[33]
new bool:g_SilentF[33]
new bool:g_Glow[33]
new bool:g_GodMode[33]
new bool:g_NoClip[33]
new bool:oneRound[33]



// Bhop
new bool:g_HasBhop[33]
new g_iCdWaterJumpTime[33]


////////////////////////////////////////////////////////////////////////////////////////////////////
// Plugin Start
////////////////////////////////////////////////////////////////////////////////////////////////////
public plugin_init()
{
	// Register Plugin
	register_plugin("Mega Shop","1.2","TheArmagedon")
	
	// Register Lang
	register_dictionary("zp_mega_shop.txt")
	
	// Say
	register_clcmd("say /megashop","ovomenu");
	register_clcmd("say_team /megashop","ovomenu");
	register_clcmd("say .megashop","ovomenu");
	register_clcmd("say_team .megashop","ovomenu");
	register_clcmd("say /mshop","ovomenu");
	register_clcmd("say_team /mshop","ovomenu");
	register_clcmd("say .mshop","ovomenu");
	register_clcmd("say_team .mshop","ovomenu");
	register_clcmd("say /shop", "ovomenu");
	register_clcmd("say_team /shop", "ovomenu");
	
	// Cvar's
	plugin_onoff	= register_cvar("amx_mega_shop", "1")
	one_round	= register_cvar("amx_ms_oneround", "1")
	grav_onoff	= register_cvar("amx_ms_gravity", "1")
	spec_onoff	= register_cvar("amx_ms_special", "1")
	bhop_onoff	= register_cvar("amx_ms_bunnyhop", "1")
	ammo_onoff	= register_cvar("amx_ms_ammo", "1")
	silent_onoff	= register_cvar("amx_ms_silentf", "1")
	glow_onoff	= register_cvar("amx_ms_glow", "1")
	noclip_onoff	= register_cvar("amx_ms_noclip", "1")
	gmode_onoff	= register_cvar("amx_ms_godmode", "1")
	money_onoff	= register_cvar("amx_ms_money", "1")
	gravityam	= register_cvar("amx_ms_gravity_amount", "0.5")
	specspeed	= register_cvar("amx_ms_special_speed", "500.0")
	speclife	= register_cvar("amx_ms_special_life", "150")
	specgrav	= register_cvar("amx_ms_special_gravity", "0.7")
	weaponson	= register_cvar("amx_ms_weapon_menu", "1")
	extrason	= register_cvar("amx_ms_extra_menu", "1")
	admmenuon	= register_cvar("amx_ms_admin_menu", "1")
	powerawp	= register_cvar("amx_ms_weapon_awp", "1")
	powerak		= register_cvar("amx_ms_weapon_ak47", "1")
	powercolt	= register_cvar("amx_ms_weapon_m4a1", "1")
	// Cvar's --- Price - EXTRAS
	gravcost	= register_cvar("amx_ms_gravity_cost", "9000")
	ammocost	= register_cvar("amx_ms_ammo_cost", "16000")
	speccost	= register_cvar("amx_ms_special_cost", "13000")
	bhopcost	= register_cvar("amx_ms_bhop_cost", "15000")
	silentcost	= register_cvar("amx_ms_silentf_cost", "7000")
	glowcost	= register_cvar("amx_ms_glow_cost", "3000")
	// Cvar's --- Price/dmg - WEAPONS
	awpcost		= register_cvar("amx_ms_awp_cost", "16000")
	akcost		= register_cvar("amx_ms_ak47_cost", "15000")
	coltcost	= register_cvar("amx_ms_colt_cost", "15000")
	pweapdmgmulti	= register_cvar("amx_ms_pweapon_damage", "2.0") // 2.0 Double DMG
	// Cvar's --- Price - ADMIN MENU
	noclipcost	= register_cvar("amx_ms_noclip_cost", "15000")
	gmodecost	= register_cvar("amx_ms_godmod_cost", "16000")
	nocliptime	= register_cvar("amx_ms_noclip_time", "10.0")
	gmodetime	= register_cvar("amx_ms_godmod_time", "10.0")
	
	// Bhop
	RegisterHam(Ham_Player_Jump, "player", "Player_Jump")
	register_forward(FM_UpdateClientData, "UpdateClientData")
	register_forward(FM_CmdStart, "CmdStart")
	
	// AMMO
	register_event("CurWeapon" , "event_CurWeapon" , "be" , "1=1");
	
	// Weapons
	register_event( "Damage", "event_damage", "be" )
	
	// Death
	register_event( "DeathMsg", "EventDeath", "a");
	
	// COLORCHAT
	TeamInfo = get_user_msgid("TeamInfo");
	SayText = get_user_msgid("SayText");
	MaxSlots = get_maxplayers();

	
	// ROUND START
	register_logevent( "Event_RoundStart", 2, "1=Round_Start" );
	
 
}
////////////////////////////////////////////////////////////////////////////////////////////////////
// Precache Model
////////////////////////////////////////////////////////////////////////////////////////////////////
public plugin_precache() {
	precache_model("models/v_awp.mdl")
	precache_model("models/v_ak47.mdl") 
	precache_model("models/v_m4a1.mdl")
}
////////////////////////////////////////////////////////////////////////////////////////////////////
// STOCKS
////////////////////////////////////////////////////////////////////////////////////////////////////
stock maxclip(wpnid) 
{
		
	static ca;
	ca = 0;

	switch (wpnid) 
	{
		case CSW_P228 : ca = 13;
		case CSW_SCOUT : ca = 10;
		case CSW_HEGRENADE : ca = 0;
		case CSW_XM1014 : ca = 7;
		case CSW_C4 : ca = 0;
		case CSW_MAC10 : ca = 30;
		case CSW_AUG : ca = 30;
		case CSW_SMOKEGRENADE : ca = 0;
		case CSW_ELITE : ca = 15;
		case CSW_FIVESEVEN : ca = 20;
		case CSW_UMP45 : ca = 25;
		case CSW_SG550 : ca = 30;
		case CSW_GALI : ca = 35;
		case CSW_FAMAS : ca = 25;
		case CSW_USP : ca = 12;
		case CSW_GLOCK18 : ca = 20;
		case CSW_AWP : ca = 10;
		case CSW_MP5NAVY : ca = 30;
		case CSW_M249 : ca = 100;
		case CSW_M3 : ca = 8;
		case CSW_M4A1 : ca = 30;
		case CSW_TMP : ca = 30;
		case CSW_G3SG1 : ca = 20;
		case CSW_FLASHBANG : ca = 0;
		case CSW_DEAGLE	: ca = 7;
		case CSW_SG552 : ca = 30;
		case CSW_AK47 : ca = 30;
		case CSW_P90 : ca = 50;
	}
	return ca;
}


stock nade_flags()
{
	static buffer[8];

	return read_flags(buffer);
}

stock log_kill(killer, victim, weapon[],headshot) {
	user_silentkill( victim );
	
	message_begin( MSG_ALL, get_user_msgid( "DeathMsg" ), {0,0,0}, 0 );
	write_byte( killer );
	write_byte( victim );
	write_byte( headshot );
	write_string( weapon );
	message_end();
	
	new kfrags = get_user_frags( killer );
	set_user_frags( killer, kfrags++ );
	new vfrags = get_user_frags( victim );
	set_user_frags( victim, vfrags++ );
	
	return  PLUGIN_CONTINUE
}
////////////////////////////////////////////////////////////////////////////////////////////////////
// IS USER ALIVE
////////////////////////////////////////////////////////////////////////////////////////////////////
public Check_Alive(id)
{
	g_Alive[id] = bool:is_user_alive(id)
}
////////////////////////////////////////////////////////////////////////////////////////////////////
// Death EVENT
////////////////////////////////////////////////////////////////////////////////////////////////////
public EventDeath( ) {
	
	new iVictim = read_data( 2 );
	
	disableall(iVictim)
	
	g_Alive[iVictim] = bool:is_user_alive(iVictim)
	
	return PLUGIN_CONTINUE;
}
////////////////////////////////////////////////////////////////////////////////////////////////////
// ROUND START
////////////////////////////////////////////////////////////////////////////////////////////////////
public Event_RoundStart(  ) {
	
	new iPlayers[32], iNum
	get_players( iPlayers, iNum, "c" );
	
	for(new i; i < iNum; i++)
		disableall(iPlayers[i])
	
}
////////////////////////////////////////////////////////////////////////////////////////////////////
// UNLIMITED AMMO
////////////////////////////////////////////////////////////////////////////////////////////////////
public event_CurWeapon(id)
{
	if(!is_user_alive(id))
		return PLUGIN_CONTINUE;

	if(g_UnAmmo[id])
	{
		static wpnid, clip;
		wpnid = read_data(2);
		clip = read_data(3);

		give_ammo(id , wpnid , clip);
	}

	return PLUGIN_CONTINUE;
}
////////////////////////////////////////////////////////////////////////////////////////////////////
// WELCOME MSG / CONFIG
////////////////////////////////////////////////////////////////////////////////////////////////////
public client_putinserver(id) 
{
	set_task(8.0, "sv_msg", id)
	set_task(150.0, "sv_msg", id, _, _, "b")
}
public plugin_cfg()
{
	new icfg[32]
	get_configsdir(icfg, sizeof icfg - 1);
	server_cmd("exec %s/zp_mega_shop.cfg", icfg)
	server_exec();
}
public sv_msg(id) {
	ColorChat(id, RED, "%L", id, "WELCOME_MSG");
}
////////////////////////////////////////////////////////////////////////////////////////////////////
// SET ALL FALSE ON CLIENT CONNECT/DISCONNECT
////////////////////////////////////////////////////////////////////////////////////////////////////
public client_connect(id)
{
	g_UnAmmo[id] = false;
	g_Gravity[id] = false;
	g_HasBhop[id] = false;
	g_Glow[id] = false
	g_NoClip[id] = false
	g_GodMode[id] = false
	// Set oneRound  true 
	oneRound[id] = true
}
public client_disconnect(id)
{
	g_UnAmmo[id] = false;
	g_Gravity[id] = false;
	g_HasBhop[id] = false;
	g_Alive[id] = false
	g_Glow[id] = false
	g_NoClip[id] = false
	g_GodMode[id] = false
}
////////////////////////////////////////////////////////////////////////////////////////////////////
// UNLIMITED AMMO (GIVE AMMO)
////////////////////////////////////////////////////////////////////////////////////////////////////
public give_ammo(id , wpnid , clip)
{
	if(!is_user_alive(id))
		return;

	if(	wpnid==CSW_C4		||
		wpnid==CSW_KNIFE	||
		wpnid==CSW_HEGRENADE	||
		wpnid==CSW_SMOKEGRENADE	||
		wpnid==CSW_FLASHBANG	) 
			return;

	if(!clip)
	{
		static weapname[33];
		get_weaponname(wpnid , weapname , 32);

		static wpn
		wpn = -1;
		while((wpn = find_ent_by_class(wpn , weapname)) != 0)
		{
			if(id == entity_get_edict(wpn , EV_ENT_owner))
			{
				cs_set_weapon_ammo(wpn , maxclip(wpnid))
				break;
			}
		}
	}
}
// Check nades
public check_for_nades(id)
{
	if(!is_user_alive(id))
		return;

	if(nade_flags() & HE_GRENADE)
	{
		if(!user_has_weapon(id , CSW_HEGRENADE))
			give_item(id , "weapon_hegrenade");
	}
	if(nade_flags() & SMOKE_GRENADE)
	{
		if(!user_has_weapon(id , CSW_SMOKEGRENADE))
			give_item(id , "weapon_smokegrenade");
	}
	if(nade_flags() & FLASH_GRENADE)
	{
		if(!user_has_weapon(id , CSW_FLASHBANG))
			give_item(id , "weapon_flashbang");
	}
}
////////////////////////////////////////////////////////////////////////////////////////////////////
// PLAYER DIE
////////////////////////////////////////////////////////////////////////////////////////////////////
public fw_PlayerKilled(victim, attacker, shouldgib)
{
	// Victim has Gravity/Bhop/Unlimited Ammo
	if(g_Gravity[victim] && g_HasBhop[victim] && g_UnAmmo[victim])
	{
		g_Gravity[victim] = false
		g_HasBhop[victim] = false
		g_UnAmmo[victim] = false
	}
	// Victim has P.Weapon's
	if(has_ak[victim] && has_awp[victim] && has_colt[victim])
	{
		has_colt[victim] = false
		has_ak[victim] = false
		has_awp[victim] = false
	}
}	
////////////////////////////////////////////////////////////////////////////////////////////////////
// MENU START!
////////////////////////////////////////////////////////////////////////////////////////////////////
public ovomenu(id)
{
	new Buffer[32]
	if(oneRound[id] == true) {
		if(get_pcvar_num(plugin_onoff) == 1) {	
			if(is_user_alive(id)) {
				new menu = menu_create("Fö Menü:", "menu_handler");
			
				if(get_pcvar_num(weaponson) == 1) {
					formatex(Buffer, 31, "%L", id, "MENU_ITEM_1", 0);
					menu_additem(menu, Buffer, "1");
				}
				if(get_pcvar_num(extrason) == 1) {
					formatex(Buffer, 31, "%L", id, "MENU_ITEM_2", 0);
					menu_additem(menu, Buffer, "2");
				}
				if(get_pcvar_num(admmenuon) == 1 && get_user_flags(id) & ADMIN_CHAT) {
					formatex(Buffer, 31, "\y[VIP]\rBolt", id, 0);
					menu_additem(menu, Buffer, "3");
				} else { 
					ColorChat(id, BLUE, "^4[MegaShop]^3 Megnyitottad a ^4Mega Bolt-ot.");
				}
				menu_setprop(menu, MPROP_EXIT, MEXIT_ALL);
			
				//Menu Display
				menu_display(id, menu, 0);
			}
			else
			ColorChat(id, BLUE, "^4[MegaShop]^3 Csak élők vásárolhatnak.");
			return PLUGIN_HANDLED;
		} 
		else
			ColorChat(id, BLUE, "^4[MegaShop]^3 Funkció kikapcsolva.");
		return PLUGIN_HANDLED;
	} else
		ColorChat(id, BLUE, "^4[MegaShop]^3 %L.", id, "ONEPERROUND");
	return PLUGIN_HANDLED;
}
// Show Weapon/Extras/Adm Menu
public menu_handler(id, menu, item)
{
	if( item == MENU_EXIT )
	{
	menu_destroy(menu);
	return PLUGIN_HANDLED;
	}
	new data[6], szName[64];
	new access, callback;
	menu_item_getinfo(menu, item, access, data,charsmax(data), szName,charsmax(szName), callback);
	new key = str_to_num(data);
	
	switch(key)
	{
	case 1:
	{
		menuweapon(id)
	}
	case 2:
	{
		menuextra(id)
	}
	case 3:
	{
		menuadm(id)
	}
	}
	menu_destroy(menu);
	return PLUGIN_HANDLED;
}
////////////////////////////////////////////////////////////////////////////////////////////////////
// WEAPON MENU
////////////////////////////////////////////////////////////////////////////////////////////////////
public menuweapon(id)
{
	new Buffer[32]
	if(get_pcvar_num(weaponson) == 1) {
		if(is_user_alive(id)) {
	new menu = menu_create("E.Fegyver Menü:", "sec_menu_handler");

	if(get_pcvar_num(powerawp) == 1) {
	formatex(Buffer, 31, "Erö AWP - (%d \rL)", get_pcvar_num(awpcost));
	menu_additem(menu, Buffer, "1");
	}
	if(get_pcvar_num(powerak) == 1) {
	formatex(Buffer, 31, "Erö AK47 - (%d \rL)", get_pcvar_num(akcost));
	menu_additem(menu, Buffer, "2");
	}
	if(get_pcvar_num(powercolt) == 1) {
	formatex(Buffer, 31, "Erö Colt-M4A1 - (%d \rL)", get_pcvar_num(coltcost));
	menu_additem(menu, Buffer, "3");
	}
	menu_setprop(menu, MPROP_EXIT, MEXIT_ALL);
	//Menu Display
	menu_display(id, menu, 0);
		} else {
	ColorChat(id, BLUE, "^4[MegaShop]^3 Csak élők vásárolhatnak.");
	return PLUGIN_HANDLED;
	}
		} else {
	ColorChat(id, BLUE, "^4[MegaShop]^3 Funkció kikapcsolva.");
	return PLUGIN_HANDLED;
	}
	return PLUGIN_CONTINUE;
}
// Weapon Menu function
public sec_menu_handler(id, menu, item)
{
	if( item == MENU_EXIT )
	{
	menu_destroy(menu);
	return PLUGIN_HANDLED;
	}
	new data[6], szName[64];
	new access, callback;
	menu_item_getinfo(menu, item, access, data,charsmax(data), szName,charsmax(szName), callback);
	new key = str_to_num(data);
	
	switch(key)
	{
	case 1: 
	{
		if(get_pcvar_num(powercolt) == 0) {
		ColorChat(id, BLUE, "^4[E.Fegyver]^3 Tárgy kikapcsolva!");
		return PLUGIN_HANDLED;
		}
		new money = zp_get_user_ammo_packs(id);
		new cost = get_pcvar_num(awpcost);
	
		if(money > cost || money == cost) {
		zp_set_user_ammo_packs(id, money - cost);
			
		ColorChat(id, BLUE, "^4[E.Fegyver]^3 %L [1]^4 Erő Awp^3-t.", id, "BUY");
		has_awp[id] = true
	
		give_item(id, "weapon_awp");
			
		if(get_pcvar_num(one_round) == 1) {
			oneRound[id] = false;
		} else {
			oneRound[id] = true;
		}
			
		new Weapon = get_user_weapon(id)
		
		if(Weapon == CSW_AWP)
			entity_set_string(id, EV_SZ_viewmodel, "models/v_awp.mdl")
			} else	{
		ColorChat(id, BLUE, "^4[E.Fegyver]^3 %L.", id, "MONEY");
				}
	}
	case 2:
	{
		if(get_pcvar_num(powercolt) == 0)  {
		ColorChat(id, BLUE, "^4[E.Fegyver]^3 Tárgy kikapcsolva!");
		return PLUGIN_HANDLED;
		}
		new money = zp_get_user_ammo_packs(id);
		new cost = get_pcvar_num(akcost);
	
		if(money > cost || money == cost) {
		zp_set_user_ammo_packs(id, money - cost);
			
		ColorChat(id, BLUE, "^4[E.Fegyver]^3 %L [1]^4 Erő AK-47^3-et.", id, "BUY");
		has_ak[id] = true
			
		give_item(id, "weapon_ak47");
			
		if(get_pcvar_num(one_round) == 1) {
			oneRound[id] = false;
		} else {
			oneRound[id] = true;
		}
		
		new Weapon = get_user_weapon(id)
				
		if(Weapon == CSW_AK47)
			entity_set_string(id, EV_SZ_viewmodel, "models/v_ak47.mdl")
			} else	{
		ColorChat(id, BLUE, "^4[E.Fegyver]^3 %L.", id, "MONEY");
				}	
	}
	case 3: 
	{
		if(get_pcvar_num(powercolt) == 0) {
		ColorChat(id, BLUE, "^4[E.Fegyver]^3 Tárgy kikapcsolva!");
		return PLUGIN_HANDLED;
		}
		new money = zp_get_user_ammo_packs(id);
		new cost = get_pcvar_num(coltcost);
	
		if(money > cost || money == cost) {
		zp_set_user_ammo_packs(id, money - cost);
			
		ColorChat(id, BLUE, "^4[E.Fegyver]^3 %L [1]^4 Erő M4A1^3-et.", id, "BUY");
		has_colt[id] = true
			
		if(get_pcvar_num(one_round) == 1) {
			oneRound[id] = false;
		} else {
			oneRound[id] = true;
		}			
		give_item(id, "weapon_m4a1");
				
		new Weapon = get_user_weapon(id)
				
		if(Weapon == CSW_M4A1)
			entity_set_string(id, EV_SZ_viewmodel, "models/v_m4a1.mdl")
			} else	{
		ColorChat(id, BLUE, "^4[E.Fegyver]^3 %L.", id, "MONEY");
				}		
	}
    }
	menu_destroy(menu);
	return PLUGIN_HANDLED;
}
////////////////////////////////////////////////////////////////////////////////////////////////////
// EXTRAS MENU
////////////////////////////////////////////////////////////////////////////////////////////////////
public menuextra(id)
{
		new Buffer[32]
		
		if(get_pcvar_num(extrason) == 1) {
			if(is_user_alive(id)) {
			
		new menu = menu_create("Extra Menü:", "trd_menu_handler");
	
		if(get_pcvar_num(grav_onoff) == 1) {
		formatex(Buffer, 31, "%L (%d \rL)", id, "EXTRA_LOW_GRAV", get_pcvar_num(gravcost));
		menu_additem(menu, Buffer, "1");
		}
		if(get_pcvar_num(ammo_onoff) == 1) {
		formatex(Buffer, 31, "%L - (%d \rL)", id, "EXTRA_UNLI_AMMO", get_pcvar_num(ammocost));
		menu_additem(menu, Buffer, "2");
		}
		if(get_pcvar_num(bhop_onoff) == 1) {
		formatex(Buffer, 31, "BunnyHop - (%d \rL)", get_pcvar_num(bhopcost));
		menu_additem(menu, Buffer, "3");
		}
		if(get_pcvar_num(spec_onoff) == 1) {
		formatex(Buffer, 31, "%L - (%d \rL)", id, "EXTRA_SPEC_ARMOR", get_pcvar_num(speccost));
		menu_additem(menu, Buffer, "4");
		}
		if(get_pcvar_num(silent_onoff) == 1) {
		formatex(Buffer, 31, "%L - (%d \rL)", id, "EXTRA_SILENT_STEP", get_pcvar_num(silentcost));
		menu_additem(menu, Buffer, "5");
		}
		if(get_pcvar_num(glow_onoff) == 1) {
		formatex(Buffer, 31, "%L - (%d \rL)", id, "EXTRA_GLOW", get_pcvar_num(glowcost));
		menu_additem(menu, Buffer, "6");
		}
		menu_setprop(menu, MPROP_EXIT, MEXIT_ALL);
	
		//Menu Display
		menu_display(id, menu, 0);
    
			} else
			ColorChat(id, BLUE, "^4[MegaShop]^3 Csak elők vásárolhatnak.");
			return PLUGIN_HANDLED;

		} else {
		ColorChat(id, BLUE, "^4[MegaShop]^3 Funkció kikapcsolva.");
		return PLUGIN_HANDLED;
	}
		return PLUGIN_CONTINUE;
}
// Extra Menu Function
public trd_menu_handler(id, menu, item)
{
	if( item == MENU_EXIT )
	{
	menu_destroy(menu);
	return PLUGIN_HANDLED;
	}
	new data[6], szName[64];
	new access, callback;
	menu_item_getinfo(menu, item, access, data,charsmax(data), szName,charsmax(szName), callback);
	new key = str_to_num(data);
	
	switch(key)
	{
	case 1:
	{
		if(get_pcvar_num(grav_onoff) == 0) {
		ColorChat(id, BLUE, "^4[Extra]^3 Tárgy kikapcsolva!");
		return PLUGIN_HANDLED;
		}
		new money = zp_get_user_ammo_packs(id);
		new cost = get_pcvar_num(gravcost);
		
		if(money > cost || money == cost) {
		zp_set_user_ammo_packs(id, money - cost);
		ColorChat(id, BLUE, "^4[Extra]^3 Alacsony Gravitaciót ^4%L!", id, "BUY");
		g_Gravity[id] = true;
		
		if(get_pcvar_num(one_round) == 1) {
			oneRound[id] = false;
		} else {
			oneRound[id] = true;
		}
		
		set_user_gravity(id, get_pcvar_float(gravityam));
		} else {
			ColorChat(id, BLUE, "^4[E.Fegyver]^3 %L.", id, "MONEY");		
		}
	}
	case 2:
	{
		if(get_pcvar_num(ammo_onoff) == 0){
		ColorChat(id, BLUE, "^4[Extra]^3 Tárgy Kikapcsolva!");
		return PLUGIN_HANDLED;
		}
		new money = zp_get_user_ammo_packs(id);
		new cost = get_pcvar_num(ammocost);
		
		if(money > cost || money == cost) {
		zp_set_user_ammo_packs(id, money - cost);
		ColorChat(id, BLUE, "^4[Extra]^3 Végtelen töltényt ^4%L!", id, "BUY");
		g_UnAmmo[id] = true;
		
		if(get_pcvar_num(one_round) == 1) {
			oneRound[id] = false;
		} else {
			oneRound[id] = true;
		}
		
		} else {
			ColorChat(id, BLUE, "^4[E.Fegyver]^3 %L.", id, "MONEY");	
		}
	}
	case 3:
	{
		if(get_pcvar_num(bhop_onoff) == 0){
		ColorChat(id, BLUE, "^4[Extra]^3 Tárgy Kikapcsolva!");
		return PLUGIN_HANDLED;
		}
		new money = zp_get_user_ammo_packs(id);
		new cost = get_pcvar_num(bhopcost);
		
		if(money > cost || money == cost) {
		zp_set_user_ammo_packs(id, money - cost);
		ColorChat(id, BLUE, "^4[Extra]^3 Bhop-ot ^4%L!", id, "BUY");
		g_HasBhop[id] = true;
		
		if(get_pcvar_num(one_round) == 1) {
			oneRound[id] = false;
		} else {
			oneRound[id] = true;
		}
		
		} else {
			ColorChat(id, BLUE, "^4[E.Fegyver]^3 %L.", id, "MONEY");
		}		
	}
	case 4:
	{
		if(get_pcvar_num(spec_onoff) == 0){
		ColorChat(id, BLUE, "^4[Extra]^3 Tárgy Kikapcsolva!");
		return PLUGIN_HANDLED;
		}
		new money = zp_get_user_ammo_packs(id);
		new cost = get_pcvar_num(speccost);
		
		if(money > cost || money == cost) {
		zp_set_user_ammo_packs(id, money - cost);
		ColorChat(id, BLUE, "^4[Extra]^3 Speciális Felszerelés-t ^4%L!", id, "BUY");
		g_Gravity[id] = true;
		
		if(get_pcvar_num(one_round) == 1) {
			oneRound[id] = false;
		} else {
			oneRound[id] = true;
		}
		
		set_user_maxspeed(id, get_pcvar_float(specspeed));
		set_user_health(id, get_pcvar_num(speclife));
		set_user_gravity(id, get_pcvar_float(specgrav));
		} else {
			ColorChat(id, BLUE, "^4[E.Fegyver]^3 %L.", id, "MONEY");
			
		}
	}
	case 5:
	{
		if(get_pcvar_num(silent_onoff) == 0){
		ColorChat(id, BLUE, "^4[Extra]^3 Tárgy Kikapcsolva!");
		return PLUGIN_HANDLED;
		}
		new money = zp_get_user_ammo_packs(id);
		new cost = get_pcvar_num(silentcost);
		
		if(money > cost || money == cost) {
		zp_set_user_ammo_packs(id, money - cost);
		ColorChat(id, BLUE, "^4[Extra]^3 Halk Járás-t ^4 %L!", id, "BUY");
		g_SilentF[id] = true;
		
		if(get_pcvar_num(one_round) == 1) {
			oneRound[id] = false;
		} else {
			oneRound[id] = true;
		}
		
		set_user_footsteps(id, 1)
		} else {
			ColorChat(id, BLUE, "^4[E.Fegyver]^3 %L.", id, "MONEY");
		}
	}
	case 6:
	{
		if(get_pcvar_num(glow_onoff) == 0){
		ColorChat(id, BLUE, "^4[Extra]^3 Tárgy Kikapcsolva!");
		return PLUGIN_HANDLED;
		}
		new money = zp_get_user_ammo_packs(id);
		new cost = get_pcvar_num(glowcost);
		
		if(money > cost || money == cost) {
		zp_set_user_ammo_packs(id, money - cost);
		
		new col1 = random_num(0, 255)
		new col2 = random_num(0, 255)
		new col3 = random_num(0, 255)
		
		ColorChat(id, BLUE, "^4[Extra]^3 Aurá-t ^4 %L!", id, "BUY");
		g_Glow[id] = true;
		
		if(get_pcvar_num(one_round) == 1) {
			oneRound[id] = false;
		} else {
			oneRound[id] = true;
		}
		
		set_user_rendering(id, kRenderFxGlowShell, col1, col2, col3, kRenderNormal, 25)
		} else {
			ColorChat(id, BLUE, "^4[E.Fegyver]^3 %L.", id, "MONEY");
		}
	}
		
    }
	menu_destroy(menu);
	return PLUGIN_HANDLED;
}
////////////////////////////////////////////////////////////////////////////////////////////////////
// ADMIN MENU
////////////////////////////////////////////////////////////////////////////////////////////////////
public menuadm(id)
{
	new Buffer[32]
	if(get_pcvar_num(weaponson) == 1) {
		if(is_user_alive(id)) {
			new menu = menu_create("VIP Menü:", "adm_menu_handler");
		
			if(get_pcvar_num(noclip_onoff) == 1) {
			formatex(Buffer, 31, "%L [%d Sec] - (%d \rL)", id, "VIP_NOCLIP", get_pcvar_num(nocliptime), get_pcvar_num(noclipcost));
			menu_additem(menu, Buffer, "1");
			}
			if(get_pcvar_num(gmode_onoff) == 1) {
			formatex(Buffer, 31, "%L [%d Sec] - (%d \rL)", id, "VIP_GODMOD", get_pcvar_num(gmodetime), get_pcvar_num(gmodecost));
			menu_additem(menu, Buffer, "2");
			}
			if(get_pcvar_num(money_onoff) == 1) {
			formatex(Buffer, 31, "\y+ \w100 \rLCS", 0);
			menu_additem(menu, Buffer, "3");
			}
			menu_setprop(menu, MPROP_EXIT, MEXIT_ALL);
		
			//Menu Display
			menu_display(id, menu, 0);

		} else
			ColorChat(id, BLUE, "^4[MegaShop]^3 Csak élők vásárolhatnak.");
		return PLUGIN_HANDLED;
	} else {
		ColorChat(id, BLUE, "^4[MegaShop]^3 Funkció kikapcsolva.");
		return PLUGIN_HANDLED;
	}
	return PLUGIN_CONTINUE;
}
// Admin Menu Function
public adm_menu_handler(id, menu, item)
{
	if( item == MENU_EXIT )
	{
	menu_destroy(menu);
	return PLUGIN_HANDLED;
	}
	new data[6], szName[64];
	new access, callback;
	menu_item_getinfo(menu, item, access, data,charsmax(data), szName,charsmax(szName), callback);
	new key = str_to_num(data);
	
	switch(key)
	{
	case 1: 
	{
		if(get_pcvar_num(noclip_onoff) == 0) {
		ColorChat(id, BLUE, "^4[VIP Menü]^3 Tárgy Kikapcsolva!");
		return PLUGIN_HANDLED;
		}
		new money = zp_get_user_ammo_packs(id);
		new cost = get_pcvar_num(noclipcost);
	
		if(money > cost || money == cost) {
		zp_set_user_ammo_packs(id, money - cost);
			
		ColorChat(id, BLUE, "^4[VIP Menü]^3 Falon Átjárás-t ^4 %L.", id, "BUY");
		g_NoClip[id] = true;
		
		if(get_pcvar_num(one_round) == 1) {
			oneRound[id] = false;
		} else {
			oneRound[id] = true;
		}

		set_user_noclip(id, 1)
		set_task(get_pcvar_float(nocliptime), "remove_noclip", id);
	
			} else {
			ColorChat(id, BLUE, "^4[E.Fegyver]^3 %L.", id, "MONEY");
			}
	}
	case 2:
	{
		if(get_pcvar_num(gmode_onoff) == 0)  {
		ColorChat(id, BLUE, "^4[VIP Menü]^3 Tárgy Kikapcsolva!");
		return PLUGIN_HANDLED;
		}
		new money = zp_get_user_ammo_packs(id);
		new cost = get_pcvar_num(gmodecost);
	
		if(money > cost || money == cost) {
		zp_set_user_ammo_packs(id, money - cost);
			
		ColorChat(id, BLUE, "^4[VIP Menü]^3 Isten Mod-ot ^4 %L.", id, "BUY");
		g_GodMode[id] = true
		
		if(get_pcvar_num(one_round) == 1) {
			oneRound[id] = false;
		} else {
			oneRound[id] = true;
		}
			
		set_user_godmode(id,1)
		set_task(get_pcvar_float(gmodetime), "remove_gmode", id);
			
			} else {
			ColorChat(id, BLUE, "^4[E.Fegyver]^3 %L.", id, "MONEY");
			}	
	}
	case 3: 
	{
		if(get_pcvar_num(money_onoff) == 0) {
		ColorChat(id, BLUE, "^4[VIP Menü]^3 Tárgy Kikapcsolva!");
		return PLUGIN_HANDLED;
		}	
		
		ColorChat(id, BLUE, "^4[VIP Menü]^3 100 LCS-t kaptál.");	
		new money = zp_get_user_ammo_packs(id);
		
		zp_set_user_ammo_packs(id, money + 100);
		
		if(get_pcvar_num(one_round) == 1) {
			oneRound[id] = false;
		} else {
			oneRound[id] = true;
		}
		
		}	
	}
	menu_destroy(menu);
	return PLUGIN_HANDLED;
}	
////////////////////////////////////////////////////////////////////////////////////////////////////
// Remove GodMode/Noclip
////////////////////////////////////////////////////////////////////////////////////////////////////
// Remove Gmode (TIME)
public remove_gmode(id) {
	g_GodMode[id] = false;
	ColorChat(id, BLUE, "^4[MegaShop]^3 Lejárt az ^4'Isten Mod'^3-od!")
	set_user_godmode(id,0)
}
// Remove Noclip (TIME)
public remove_noclip(id) {
	g_NoClip[id] = false;
	ColorChat(id, BLUE, "^4[MegaShop]^3 Lejárt a ^4'Falon Átjárás'^3-od!")
	set_user_noclip(id, 0)
	ClientCommand_UnStick(id)
}
	
////////////////////////////////////////////////////////////////////////////////////////////////////
// BunnyHOP
////////////////////////////////////////////////////////////////////////////////////////////////////
public CmdStart(id, uc_handle, seed) {
	
	if(	is_user_alive(id)
	&& 	g_HasBhop[id]
	&&	get_uc(uc_handle, UC_Buttons) & IN_USE
	&&	pev(id, pev_flags) & FL_ONGROUND	) {
		static Float:fVelocity[3]
		pev(id, pev_velocity, fVelocity)
		fVelocity[0] *= 0.3
		fVelocity[1] *= 0.3
		fVelocity[2] *= 0.3
		set_pev(id, pev_velocity, fVelocity)
	}
}

public Player_Jump(id) {

	if( !is_user_alive(id) ) {
		return
	}
	
	if( g_iCdWaterJumpTime[id] ) {
		return
	}
	
	if( pev(id, pev_waterlevel) >= 2 ){
		return
	}
	
	static iFlags ; iFlags = pev(id, pev_flags)
	if( !(iFlags & FL_ONGROUND) ){
		return
	}
	
	static iOldButtons ; iOldButtons = pev(id, pev_oldbuttons)
	if( !g_HasBhop[id] && iOldButtons & IN_JUMP ){
		return
	}
	
	set_pev(id, pev_oldbuttons, iOldButtons | IN_JUMP)
	
	static Float:fVelocity[3]
	pev(id, pev_velocity, fVelocity)
	
	static Float:fFrameTime, Float:fPlayerGravity
	global_get(glb_frametime, fFrameTime)
	pev(id, pev_gravity, fPlayerGravity)
	
	new iLJ
	if(	(pev(id, pev_bInDuck) || iFlags & FL_DUCKING)
	&&	get_pdata_int(id, 356)
	&&	pev(id, pev_button) & IN_DUCK
	&&	pev(id, pev_flDuckTime)	){
		static Float:fPunchAngle[3], Float:fForward[3]
		pev(id, pev_punchangle, fPunchAngle)
		fPunchAngle[0] = -5.0
		set_pev(id, pev_punchangle, fPunchAngle)
		global_get(glb_v_forward, fForward)
		
		fVelocity[0] = fForward[0] * 560
		fVelocity[1] = fForward[1] * 560
		fVelocity[2] = 299.33259094191531084669989858532
		iLJ = 1
	}
	else
	{
		fVelocity[2] = 268.32815729997476356910084024775
	}
	
	fVelocity[2] -= fPlayerGravity * fFrameTime * 0.5 * 800
	
	set_pev(id, pev_velocity, fVelocity)
	
	set_pev(id, pev_gaitsequence, 6+iLJ)
	set_pev(id, pev_frame, 0.0)
}
public UpdateClientData(id, sendweapons, cd_handle)
{
	g_iCdWaterJumpTime[id] = get_cd(cd_handle, CD_WaterJumpTime)
}
////////////////////////////////////////////////////////////////////////////////////////////////////
// POWER WEAPONS
////////////////////////////////////////////////////////////////////////////////////////////////////
public event_damage( id ) {
	
	new victim_id = id;
	if( !is_user_connected( victim_id ) ) return PLUGIN_CONTINUE
	new dmg_take = read_data( 2 );
	new dmgtype = read_data( 3 );
	new Float:damage = dmg_take * get_pcvar_float(pweapdmgmulti);
	new health = get_user_health( victim_id );
	new frag = get_user_frags(id);
	
	new iWeapID, attacker_id = get_user_attacker( victim_id, iWeapID );
	
	if( !is_user_connected( attacker_id ) || !is_user_alive( victim_id ) ) {
		return PLUGIN_HANDLED
	}
	// AWP DMG
	if( iWeapID == CSW_AWP && has_awp[attacker_id] ) {
		
		if( floatround(damage) >= health ) {
			if( victim_id == attacker_id ) {
				return PLUGIN_CONTINUE
				}else{
				log_kill( attacker_id, victim_id, "awp", 0 );
			}
			
			return PLUGIN_CONTINUE
			}else {
			if( victim_id == attacker_id ) return PLUGIN_CONTINUE

			fakedamage( victim_id, "weapon_awp", damage, dmgtype );
			set_user_frags(id, frag++)
		}
	}
	// AK47 DMG
	if( iWeapID == CSW_AK47 && has_ak[attacker_id] ) {
		
		if( floatround(damage) >= health ) {
			if( victim_id == attacker_id ) {
				return PLUGIN_CONTINUE
				}else{
				log_kill( attacker_id, victim_id, "ak47", 0 );
			}
			
			return PLUGIN_CONTINUE
			}else {
			if( victim_id == attacker_id ) return PLUGIN_CONTINUE

			fakedamage( victim_id, "weapon_ak47", damage, dmgtype);
			set_user_frags(id, frag++)
		}
	}
	// COLT DMG
	if(iWeapID == CSW_M4A1 && has_colt[attacker_id]) 
	{
		if( floatround(damage) >= health ) {
			if( victim_id == attacker_id ) {
				return PLUGIN_CONTINUE
				}else{
				log_kill( attacker_id, victim_id, "m4a1", 0 );
			}
			return PLUGIN_CONTINUE
			}else {
			if( victim_id == attacker_id ) return PLUGIN_CONTINUE
			fakedamage( victim_id, "weapon_m4a1", damage, dmgtype);
			set_user_frags(id, frag++)
		}
	}
	return PLUGIN_CONTINUE
}		
// Normal Weapon Model (P.Weapon)
public CurWeapon(id)
{		
	// AWP
	if(get_pcvar_num(powerawp)) {
		
		new Weapon = read_data(2)
		
		if(Weapon == CSW_AWP && has_awp[id])
			entity_set_string(id, EV_SZ_viewmodel, "models/v_awp.mdl")
			
	}
	// AK47
	if(get_pcvar_num(powerak)) {
		
		new Weapon = read_data(2)
		
		if(Weapon == CSW_AK47 && has_ak[id])
			entity_set_string(id, EV_SZ_viewmodel, "models/v_ak47.mdl")
			
	}
	// Colt-m4a1
	if(get_pcvar_num(powercolt)) {
		
		new Weapon = read_data(2)
		
		if(Weapon == CSW_M4A1 && has_colt[id])
			entity_set_string(id, EV_SZ_viewmodel, "models/v_m4a1.mdl")
			
	}

}
////////////////////////////////////////////////////////////////////////////////////////////////////
// DISABLE ALL ITEMS
////////////////////////////////////////////////////////////////////////////////////////////////////
public disableall(id) {
	
	if(g_HasBhop[id]) {
		ColorChat(id, BLUE, "^4[MegaShop]^3 A ^4'Bhop'^3-od kikapcsolva!")
		g_HasBhop[id] = false;
	}
	if(g_UnAmmo[id]) {
		ColorChat(id, BLUE, "^4[MegaShop]^3 A ^4'Végtelen Töltény Mod'^3-od kikapcsolva!")
		g_UnAmmo[id] = false;
		
	}
	if(g_SilentF[id]) {
		ColorChat(id, BLUE, "^4[MegaShop]^3 A 'Halk Járás'^4-od Kikapcsolva!")
		g_SilentF[id] = false;
		set_user_footsteps(id, 0)
	
	}
	if(g_Glow[id]) {
		ColorChat(id, BLUE, "^4[MegaShop]^3 Az 'Aurád' ^4Kikapcsolva!")
		g_Glow[id] = false;
		set_user_rendering(id, kRenderFxGlowShell, 0, 0, 0, kRenderNormal, 0)
		
	}
	if(g_GodMode[id]) {
		ColorChat(id, BLUE, "^4[MegaShop]^3 Az 'Isten Mod'^4-od Kikapcsolva!")
		g_GodMode[id] = false
		set_user_godmode(id,0)
	}
	if(g_NoClip[id]) {
		ColorChat(id, BLUE, "^4[MegaShop]^3 A 'Falon Átjárás'^4-od Kikapcsolva!")
		g_NoClip[id] = false
		set_user_noclip(id,0)
	}
	if(get_pcvar_num(plugin_onoff) == 1) {
		oneRound[id] = true
	}
}
////////////////////////////////////////////////////////////////////////////////////////////////////
// UNSTUCK (NOCLIP) - Sorry if the code is not my friend, but I got the code from my friend.
////////////////////////////////////////////////////////////////////////////////////////////////////
public ClientCommand_UnStick ( const id ) {
	
	new i_Value;
	
	if ( ( i_Value = UTIL_UnstickPlayer ( id, 32, 128 ) ) != 1 )
	{
		switch ( i_Value )
		{
			case 0  : client_print ( id, print_chat, "Nem vagy beragadva!" );
				case -1 : client_print ( id, print_console, "..." );
			}
	}
	
	return PLUGIN_CONTINUE;
}


UTIL_UnstickPlayer ( const id, const i_StartDistance, const i_MaxAttempts ) {
	// --| Not alive, ignore.
	if ( !is_user_alive ( id ) )  return -1
	
	static Float:vf_OriginalOrigin[ Coord_e ], Float:vf_NewOrigin[ Coord_e ];
	static i_Attempts, i_Distance;
	
	// --| Get the current player's origin.
	pev ( id, pev_origin, vf_OriginalOrigin );
	
	i_Distance = i_StartDistance;
	
	while ( i_Distance < 1000 )
	{
		i_Attempts = i_MaxAttempts;
		
		while ( i_Attempts-- )
		{
			vf_NewOrigin[ x ] = random_float ( vf_OriginalOrigin[ x ] - i_Distance, vf_OriginalOrigin[ x ] + i_Distance );
			vf_NewOrigin[ y ] = random_float ( vf_OriginalOrigin[ y ] - i_Distance, vf_OriginalOrigin[ y ] + i_Distance );
			vf_NewOrigin[ z ] = random_float ( vf_OriginalOrigin[ z ] - i_Distance, vf_OriginalOrigin[ z ] + i_Distance );
			
			engfunc ( EngFunc_TraceHull, vf_NewOrigin, vf_NewOrigin, DONT_IGNORE_MONSTERS, GetPlayerHullSize ( id ), id, 0 );
			
			// --| Free space found.
			if ( get_tr2 ( 0, TR_InOpen ) && !get_tr2 ( 0, TR_AllSolid ) && !get_tr2 ( 0, TR_StartSolid ) )
			{
				// --| Set the new origin .
				engfunc ( EngFunc_SetOrigin, id, vf_NewOrigin );
				return 1;
			}
		}
		
		i_Distance += i_StartDistance;
	}
	
	// --| Could not be found.
	return 0;
}
////////////////////////////////////////////////////////////////////////////////////////////////////
// COLOR CHAT
////////////////////////////////////////////////////////////////////////////////////////////////////
public ColorChat(id, Color:type, const msg[], {Float,Sql,Result,_}:...)
{
	static message[256];

	switch(type)
	{
		case YELLOW: // Yellow
		{
			message[0] = 0x01;
		}
		case GREEN: // Green
		{
			message[0] = 0x04;
		}
		default: // White, Red, Blue
		{
			message[0] = 0x03;
		}
	}

	vformat(message[1], 251, msg, 4);

	// Make sure message is not longer than 192 character. Will crash the server.
	message[192] = '^0';

	new team, ColorChange, index, MSG_Type;
	
	if(!id)
	{
		index = FindPlayer();
		MSG_Type = MSG_ALL;
	
	} else {
		MSG_Type = MSG_ONE;
		index = id;
	}
	
	team = get_user_team(index);	
	ColorChange = ColorSelection(index, MSG_Type, type);

	ShowColorMessage(index, MSG_Type, message);
		
	if(ColorChange)
	{
		Team_Info(index, MSG_Type, TeamName[team]);
	}
}

ShowColorMessage(id, type, message[])
{
	message_begin(type, SayText, _, id);
	write_byte(id)		
	write_string(message);
	message_end();	
}

Team_Info(id, type, team[])
{
	message_begin(type, TeamInfo, _, id);
	write_byte(id);
	write_string(team);
	message_end();

	return 1;
}

ColorSelection(index, type, Color:Type)
{
	switch(Type)
	{
		case RED:
		{
			return Team_Info(index, type, TeamName[1]);
		}
		case BLUE:
		{
			return Team_Info(index, type, TeamName[2]);
		}
		case GREY:
		{
			return Team_Info(index, type, TeamName[0]);
		}
	}

	return 0;
}

FindPlayer()
{
	new i = -1;

	while(i <= MaxSlots)
	{
		if(IsConnected[++i])
		{
			return i;
		}
	}

	return -1;
}

/* AMXX-Studio Notes - DO NOT MODIFY BELOW HERE
*{\\ rtf1\\ ansi\\ deff0{\\ fonttbl{\\ f0\\ fnil Tahoma;}}\n\\ viewkind4\\ uc1\\ pard\\ lang1034\\ f0\\ fs16 \n\\ par }
*/
