/*
*   -----------------------------------
*   -----[ZP] Zombie Class: Smoker-----
*   -----------------------------------
*   ------Author: 4eRT (aka pff)-------
*   -----------------------------------
*      About:
*   When Left4Dead came out i immediately thought about Zombie Class Smoker plugin.
*   More later(few days ago) I was playing on Superhero Server when i found Scorpion hero.
*   So it was the way to create this plugin.
*   -----------------------------------
*      Discription:
*   Smoker is another zombie class for zombie plague like Smoker in L4D.
*   He can drags humans by holding "V" or +USE like /\...yeah, like Smoker. If Smoker receives
*   300 damage by human drag ends. If he falls or hurts more 25 dmg drag ends to.
*   Drag speed, max drags, cooldown, drag teammates, additional hooks, unable to move & damage to stop
*   may be customized by Cvars.
*   -----------------------------------
*      Credits:
*   yang - great thanks for his Scorpion superhero plugin where I borrow harpoon&drag code.
*   5c0r-|3i0 - for his converted Smoker sounds.
*   Anggara_nothing - for rewritting Entvars_Set_Vector from Vexd_Utilities to engine. but not very useful :/
*   xPaw - really thx for help optimization plugin. For Entity_Set_Vector.
*   frk_14 - for his Smoker model.
*   -----------------------------------
*      Cvars:
*   zp_smoker_maxdrags 10 // how many times Smoker can drag player to himself? def=10
*   zp_smoker_dragspeed 160 // speed of dragging player to Smoker def=160
*   zp_smoker_cooldown 5 // time in sec before you can use drag again. def=5
*   zp_smoker_mates 0 // can Smoker drag teammates to? 1=yes 0=no def=0
*   zp_smoker_dmg2stop 300 // damage to stop dragging. set 0 to disable it. def=300
*   zp_smoker_extrahook 2 // additional hooks after Smoker infects smb. def=2
*   zp_smoker_unable_move 1 // 0=human & Smoker can move / 1=unable human to move when dragging / 2=unable Smoker to move / 3=unable both
*   zp_smoker_nemesis 0 // 0=Smoker can't drag players if he is Nemesis / 1=Smoker can. def=0
*   zp_smoker_survivor 1 // 0=Smoker can't drag Survivor / 1=Smoker can. def=1
*   -----------------------------------
*      Modules:
*   hamsandwich
*   fakemeta
*   engine
*   -----------------------------------
*      History:
*   0.0b (14.04.09)
*      Most of code converted from sh_scorpion. Added 3 cvars.
*   0.1b (15.04.09)
*      Added cooldown, autobind, damage to stop and its cvars.
*      Beta testing. First view works perfectly...<- It was wrong belief...>_<
*   0.2b (17.04.09)
*      Entvars_Set_Vector now uses engine, not Vexd_Utilities.inc
*   0.3b (19.04.09)
*      Fixed cooldown. Now it works more stably. Reduced minimum drag distance.
*   0.3.1b (21.04.09)
*      Cooldown works more, more stably. After re-infecting Smoker can use drag
*      X times(cvar_maxdrags) if drags left when he was zombie last time.
*      Hope i've fixed dragging teammates. Please test it and say: does it work?
*      Added Smoker model(+modelT.mdl precacher).
*   0.3.2b (28.04.09)
*      Changed Smoker model(lite+without T.mdl -> deleted T.mdl precacher)
*      Added 3rd option to zp_smoker_bind - bind on +USE
*   1.0 (09.01.10)
*      Yeah. It's not beta now. :) Added autobind menu. Now player can choose: bind V +drag or hold +use to drag. Removed bind cvar.
*      Fixed cooldown. Fixed teammate drag. Added extra hook-cvar for infection.
*   1.1 (09.01.10)
*      Added unmovable cvar. Added Nemesis and Survivor cvars.
*   1.2 (12.01.10)
*      Code optimized. Fixed bugs.
*   1.3 (17.01.10)
*      Code optimized.
*   -----------------------------------
*      PS:
*   It's my second useful plugin for amxx so...
*/

// magyarositas by FD GoD

#include <amxmodx>
#include <zombieplague>
#include <fakemeta>
#include <hamsandwich>
#include <engine>

#define PLUGIN "[ZP] Class Smoker"
#define VERSION "1.3"
#define AUTHOR "4eRT"

//Fo Katergoria, T model & Sprite sugarzas
new g_zclass_smoker, g_Line
new const generic_models[][] = { "models/player/zombie_smoker/zombie_smokerT.mdl" } 
//hangok
new g_sndMiss[] = "zombie_plague/Smoker_TongueHit_miss.wav"
new g_sndDrag[] = "zombie_plague/Smoker_TongueHit_drag.wav"
//Some vars
new g_hooked[33], g_hooksLeft[33], g_unable2move[33], g_ovr_dmg[33]
new Float:g_lastHook[33]
new bool: g_bind_use[33] = false, bool: g_bind_or_not[33] = false, bool: g_drag_i[33] = false
//Cavrok
new cvar_maxdrags, cvar_dragspeed, cvar_cooldown, cvar_dmg2stop, cvar_mates, cvar_extrahook, cvar_unb2move, cvar_nemesis, cvar_survivor
//Menu gombok
new keys = MENU_KEY_1|MENU_KEY_2|MENU_KEY_3
//Smoker Tulajdonsagok
new const zclass_name[] = { "Smoker" }
new const zclass_info[] = { "Magahoz huzza a playert" }
new const zclass_model[] = { "zombie_smoker" }
new const zclass_clawmodel[] = { "v_knife_zombie.mdl" }
const zclass_health = 1400
const zclass_speed = 190
const Float:zclass_gravity = 1.0
const Float:zclass_knockback = 1.0

public plugin_init()
{
   cvar_dragspeed = register_cvar("zp_smoker_dragspeed", "160")
   cvar_maxdrags = register_cvar("zp_smoker_maxdrags", "10")
   cvar_cooldown = register_cvar("zp_smoker_cooldown", "5")
   cvar_dmg2stop = register_cvar("zp_smoker_dmg2stop", "300")
   cvar_mates = register_cvar("zp_smoker_mates", "0")
   cvar_extrahook = register_cvar("zp_smoker_extrahook", "2")
   cvar_unb2move = register_cvar("zp_smoker_unable_move", "1")
   cvar_nemesis = register_cvar("zp_smoker_nemesis", "0")
   cvar_survivor = register_cvar("zp_smoker_survivor", "1")
   register_event("ResetHUD", "newSpawn", "b")
   register_event("DeathMsg", "smoker_death", "a")
   register_forward(FM_PlayerPreThink, "fw_PlayerPreThink")
   RegisterHam(Ham_TakeDamage, "player", "fw_TakeDamage")
   register_clcmd("+drag","drag_start", ADMIN_USER, "bind ^"key^" ^"+drag^"")
   register_clcmd("-drag","drag_end")
   register_menucmd(register_menuid("Do you want to bind V +drag?"), keys, "bind_v_key")
}
public plugin_precache()
{
   register_plugin(PLUGIN, VERSION, AUTHOR)
   g_zclass_smoker = zp_register_zombie_class(zclass_name, zclass_info, zclass_model, zclass_clawmodel, zclass_health, zclass_speed, zclass_gravity, zclass_knockback)
   precache_sound(g_sndDrag)
   precache_sound(g_sndMiss)
   g_Line = precache_model("sprites/zbeam4.spr")
   
   for (new i = 0; i < sizeof generic_models; i++)
   precache_model(generic_models[i])
}

public zp_user_infected_post(id, infector)
{
   if ((zp_get_user_zombie_class(infector) == g_zclass_smoker) && (get_pcvar_num(cvar_extrahook) > 0))
   {
      g_hooksLeft[infector] = g_hooksLeft[infector] + get_pcvar_num(cvar_extrahook)
      set_hudmessage(255, 0, 0, -1.0, 0.45, 0, 0.0, 3.0, 0.01, 0.01, -1)
      show_hudmessage(infector, "+%d drag%s!", get_pcvar_num(cvar_extrahook), (get_pcvar_num(cvar_extrahook) < 2) ? "" : "s")
   }
   
   if (zp_get_user_zombie_class(id) == g_zclass_smoker)
   {
      g_hooksLeft[id] = get_pcvar_num(cvar_maxdrags)
      
      if (!g_bind_or_not[id])
      {
         new menu[192]
         format(menu, 191, "Beakarod bindelni V +drag?^n^n1. Igen^n2. Nem^n3. Slukkolas +USE")
         show_menu(id, keys, menu)
      }
   }
}

public newSpawn(id)
{
   if (g_hooked[id])
      drag_end(id)
}

public drag_start(id) // starts drag, checks if player is Smoker, checks cvars
{      
   if (zp_get_user_zombie(id) && (zp_get_user_zombie_class(id) == g_zclass_smoker) && !g_drag_i[id]) {
      
      static Float:cdown
      cdown = get_pcvar_float(cvar_cooldown)

      if (!is_user_alive(id)) {
         client_print(id, print_chat, "[ZP] Nem slukkolhatsz ha halott vagy!")
         return PLUGIN_HANDLED
      }

      if (g_hooksLeft[id] <= 0) {
         client_print(id, print_chat, "[ZP] Nem slukkolhatsz tobbet!")
         return PLUGIN_HANDLED
      }

      if (get_gametime() - g_lastHook[id] < cdown) {
         client_print(id, print_chat, "[ZP] Varj %.f0 masodpercet az ujra slukkolashoz!", get_pcvar_float(cvar_cooldown) - (get_gametime() - g_lastHook[id]))
         return PLUGIN_HANDLED
      }
      
      new hooktarget, body
      get_user_aiming(id, hooktarget, body)
      
      if (zp_get_user_nemesis(id) && get_pcvar_num(cvar_nemesis) == 0) {
         client_print(id, print_chat, "[ZP] Nem slukkolhatsz ha Nemesis vagy!")
         return PLUGIN_HANDLED
      }
      
      if (is_user_alive(hooktarget)) {
         if (!zp_get_user_zombie(hooktarget))
            {
               if (zp_get_user_survivor(hooktarget) && get_pcvar_num(cvar_survivor) == 0) {
                  client_print(id, print_chat, "[ZP] Nem slukkolhatod a Tulelot!")
                  return PLUGIN_HANDLED
               }
               
               g_hooked[id] = hooktarget
               emit_sound(hooktarget, CHAN_BODY, g_sndDrag, 1.0, ATTN_NORM, 0, PITCH_HIGH)
            }
         else
            {
               if (get_pcvar_num(cvar_mates) == 1)
               {
                  g_hooked[id] = hooktarget
                  emit_sound(hooktarget, CHAN_BODY, g_sndDrag, 1.0, ATTN_NORM, 0, PITCH_HIGH)
               }
               else
               {
                  client_print(id, print_chat, "[ZP] Nem slukkolhatod a csapattarsaidat!")
                  return PLUGIN_HANDLED
               }
            }

         if (get_pcvar_float(cvar_dragspeed) <= 0.0)
            cvar_dragspeed = 1
         
         new parm[2]
         parm[0] = id
         parm[1] = hooktarget
         
         set_task(0.1, "smoker_reelin", id, parm, 2, "b")
         harpoon_target(parm)
         
         g_hooksLeft[id]--
         client_print(id, print_chat, "[ZP] Nem slukkolhatsz embert meg: %d time%s", g_hooksLeft[id], (g_hooksLeft[id] < 2) ? "" : "s")
         g_drag_i[id] = true
         
         if(get_pcvar_num(cvar_unb2move) == 1)
            g_unable2move[hooktarget] = true
            
         if(get_pcvar_num(cvar_unb2move) == 2)
            g_unable2move[id] = true
            
         if(get_pcvar_num(cvar_unb2move) == 3)
         {
            g_unable2move[hooktarget] = true
            g_unable2move[id] = true
         }
      } else {
         g_hooked[id] = 33
         noTarget(id)
         emit_sound(hooktarget, CHAN_BODY, g_sndMiss, 1.0, ATTN_NORM, 0, PITCH_HIGH)
         g_drag_i[id] = true
         g_hooksLeft[id]--
         client_print(id, print_chat, "[ZP] Slukkolhatsz embert meg: %d time%s", g_hooksLeft[id], (g_hooksLeft[id] < 2) ? "" : "s")
      }
   }
   else
      return PLUGIN_HANDLED
   
   return PLUGIN_CONTINUE
}

public smoker_reelin(parm[]) // slukkolas ember
{
   new id = parm[0]
   new victim = parm[1]

   if (!g_hooked[id] || !is_user_alive(victim))
   {
      drag_end(id)
      return
   }

   new Float:fl_Velocity[3]
   new idOrigin[3], vicOrigin[3]

   get_user_origin(victim, vicOrigin)
   get_user_origin(id, idOrigin)

   new distance = get_distance(idOrigin, vicOrigin)

   if (distance > 1) {
      new Float:fl_Time = distance / get_pcvar_float(cvar_dragspeed)

      fl_Velocity[0] = (idOrigin[0] - vicOrigin[0]) / fl_Time
      fl_Velocity[1] = (idOrigin[1] - vicOrigin[1]) / fl_Time
      fl_Velocity[2] = (idOrigin[2] - vicOrigin[2]) / fl_Time
   } else {
      fl_Velocity[0] = 0.0
      fl_Velocity[1] = 0.0
      fl_Velocity[2] = 0.0
   }

   entity_set_vector(victim, EV_VEC_velocity, fl_Velocity) //<- rewritten. now uses engine
}

public drag_end(id) // drags end function
{
   g_hooked[id] = 0
   beam_remove(id)
   remove_task(id)
   
   if (g_drag_i[id])
      g_lastHook[id] = get_gametime()
   
   g_drag_i[id] = false
   g_unable2move[id] = false
}

public smoker_death() // if smoker dies drag off
{
   new id = read_data(2)
   
   beam_remove(id)
   
   if (g_hooked[id])
      drag_end(id)
}

public fw_TakeDamage(victim, inflictor, attacker, Float:damage) // if take damage drag off
{
   if (is_user_alive(attacker) && (get_pcvar_num(cvar_dmg2stop) > 0))
   {
      g_ovr_dmg[victim] = g_ovr_dmg[victim] + floatround(damage)
      if (g_ovr_dmg[victim] >= get_pcvar_num(cvar_dmg2stop))
      {
         g_ovr_dmg[victim] = 0
         drag_end(victim)
         return HAM_IGNORED;
      }
   }

   return HAM_IGNORED;
}

public fw_PlayerPreThink(id)
{
   if (!is_user_alive(id))
      return FMRES_IGNORED
   
   new button = get_user_button(id)
   new oldbutton = get_user_oldbutton(id)
   
   if (g_bind_use[id] && zp_get_user_zombie(id) && (zp_get_user_zombie_class(id) == g_zclass_smoker))
   {
      if (!(oldbutton & IN_USE) && (button & IN_USE))
         drag_start(id)
      
      if ((oldbutton & IN_USE) && !(button & IN_USE))
         drag_end(id)
   }
   
   if (!g_drag_i[id]) {
      g_unable2move[id] = false
   }
      
   if (g_unable2move[id] && get_pcvar_num(cvar_unb2move) > 0)
   {
      set_pev(id, pev_maxspeed, 1.0)
   }
   
   return PLUGIN_CONTINUE
}

public client_disconnect(id) // if client disconnects drag off
{
   if (id <= 0 || id > 32)
      return
   
   if (g_hooked[id])
      drag_end(id)
   
   if(g_unable2move[id])
      g_unable2move[id] = false
}

public harpoon_target(parm[]) // set beam (ex. tongue:) if target is player
{
   new id = parm[0]
   new hooktarget = parm[1]

   message_begin(MSG_BROADCAST, SVC_TEMPENTITY)
   write_byte(8)   // TE_BEAMENTS
   write_short(id)
   write_short(hooktarget)
   write_short(g_Line)   // sprite index
   write_byte(0)   // start frame
   write_byte(0)   // framerate
   write_byte(200)   // life
   write_byte(8)   // width
   write_byte(1)   // noise
   write_byte(155)   // r, g, b
   write_byte(155)   // r, g, b
   write_byte(55)   // r, g, b
   write_byte(90)   // brightness
   write_byte(10)   // speed
   message_end()
}

public bind_v_key(id, keys)
{
   g_bind_or_not[id] = true
   switch(keys)
   {
      case 0:
         client_cmd(id, "bind v ^"+drag^"")
   
      case 1:
         client_print(id, print_chat, "[ZP] Ahoz hogy slukkolhass (bind ^'^'gomb^'^' ^'^'+drag^'^') es tartsd nyomva")
         
      case 2:
         g_bind_use[id] = true
         
      default:
         g_bind_or_not[id] = false
   }
   
   return PLUGIN_HANDLED
}

public noTarget(id) // set beam if target isn't player
{
   new endorigin[3]

   get_user_origin(id, endorigin, 3)

   message_begin(MSG_BROADCAST, SVC_TEMPENTITY)
   write_byte( TE_BEAMENTPOINT ); // TE_BEAMENTPOINT
   write_short(id)
   write_coord(endorigin[0])
   write_coord(endorigin[1])
   write_coord(endorigin[2])
   write_short(g_Line) // sprite index
   write_byte(0)   // start frame
   write_byte(0)   // framerate
   write_byte(200)   // life
   write_byte(8)   // width
   write_byte(1)   // noise
   write_byte(155)   // r, g, b
   write_byte(155)   // r, g, b
   write_byte(55)   // r, g, b
   write_byte(75)   // brightness
   write_byte(0)   // speed
   message_end()
}

public beam_remove(id) // remove beam
{
   message_begin(MSG_BROADCAST, SVC_TEMPENTITY)
   write_byte(99)   //TE_KILLBEAM
   write_short(id)   //entity
   message_end()
}
/* AMXX-Studio Notes - DO NOT MODIFY BELOW HERE
*{\\ rtf1\\ ansi\\ deff0{\\ fonttbl{\\ f0\\ fnil Tahoma;}}\n\\ viewkind4\\ uc1\\ pard\\ lang1049\\ f0\\ fs16 \n\\ par }
*/