/*
AMXX Banhammer by Mati (initial release).

Usage: amx_banhammer

Available options (CVARS):
	hammer_bantime <minutes> (Default: 15) - Duration of the victims ban in minutes
	hammer_check <0/1> Default: 0 - Displays a verification menu after someone gets hit with the banhammer. The victim is freezed during that time.
	hammer_noclip <0/1> Default: 0 - Activates noclip when beeing equipped with the banhammer
	hammer_godmode <0/1> Default: 1 - Activates godmode when beeing equipped with the banhammer
	hammer_speed <number> Default: Value of sv_maxspeed - Defines the players speed when beeing equipped with the banhammer
	hammer_delay <number> Default: 0.0 - Adds a delay in between the hammer attacks. Will have no effect if <0.4. Might cause faulty animations.	
	hammer_explosiondelay <number> Default: 0.15 - Delay between the hammerhit and the explosion/ban
	*/

#include <amxmodx>
#include <amxmisc>
#include <engine>
#include <fun>
#include <hamsandwich>
#include <fakemeta>

new h_noclip, h_speed, h_godmode, h_check, h_delay, h_bantime, h_edelay;
new explosion, smoke, mdl_gib_flesh, mdl_gib_meat, mdl_gib_head, mdl_gib_legbone, mdl_gib_spine, mdl_gib_lung;
new bool:g_hasHammer[33];
new bool:g_blocked[33];
new g_pid;

public plugin_init() {
	register_plugin("AMXX Banhammer", "1.0", "Mati");
	register_clcmd("amx_banhammer", "HandleBanhammer", ADMIN_BAN);
	
	// CVARS
	new maxspeed[5];
	get_cvar_string("sv_maxspeed", maxspeed, 4);
	h_speed = register_cvar("hammer_speed", maxspeed);
	h_noclip = register_cvar("hammer_noclip", "0");
	h_godmode = register_cvar("hammer_godmode", "1");
	h_check = register_cvar("hammer_check", "0");
	h_delay = register_cvar("hammer_delay", "0.0");
	h_bantime = register_cvar("hammer_bantime", "15");
	h_edelay = register_cvar("hammer_explosiondelay", "0.1");
	
	register_event("CurWeapon","CurWeapon","be","1=1");
	
	register_forward(FM_EmitSound, "HandleSound");
	RegisterHam(Ham_Weapon_PrimaryAttack, "weapon_knife", "KnifeAttack");
	RegisterHam(Ham_Weapon_SecondaryAttack, "weapon_knife", "KnifeAttack");
	RegisterHam(Ham_Touch,"weaponbox","touch_weapon");
	RegisterHam(Ham_TraceAttack, "player", "TraceAttack");
	RegisterHam(Ham_Spawn, "player", "PlayerSpawnPost", 1);
}

public plugin_precache() {
	precache_model("models/v_knife.mdl");
	precache_model("models/p_knife.mdl");
	precache_model("models/banhammer/p_hammer.mdl");
	precache_model("models/banhammer/v_hammer.mdl");
	precache_sound("banhammer/hitwall.wav");
	precache_sound("banhammer/banhammer.wav");
	precache_sound("banhammer/hitplayer.wav");
	
	explosion = precache_model("sprites/bexplo.spr");
	smoke = precache_model("sprites/steam1.spr");
	
	mdl_gib_flesh = precache_model("models/Fleshgibs.mdl");
	mdl_gib_meat = precache_model("models/GIB_B_Gib.mdl");
	mdl_gib_head = precache_model("models/GIB_Skull.mdl");
	mdl_gib_legbone = precache_model("models/GIB_Legbone.mdl");
	mdl_gib_spine = precache_model("models/GIB_B_Bone.mdl");
	mdl_gib_lung = precache_model("models/GIB_Lung.mdl");
}

public HandleSound(entity, channel, const sound[]) {
	if (entity > 0 && entity < 33 && g_hasHammer[entity]) {
		if (equal(sound, "weapons/knife_hitwall1.wav")) {
			emit_sound(entity, CHAN_WEAPON, "banhammer/hitwall.wav", 1.0, ATTN_NORM, 0, PITCH_NORM);
			return FMRES_SUPERCEDE;
		} else if (equal(sound, "weapons/knife_hit", 17) || equal(sound, "weapons/knife_stab.wav")) {
			emit_sound(entity, CHAN_WEAPON, "banhammer/hitplayer.wav", 1.0, ATTN_NORM, 0, PITCH_NORM);
			return FMRES_SUPERCEDE;
		} else if (equal(sound, "weapons/knife_deploy1.wav")) {
			return FMRES_SUPERCEDE;
		}
	}
	return FMRES_IGNORED;
}

public HandleBanhammer(id, level, cid) {
	if (!cmd_access(id, level, cid, 1)) return PLUGIN_HANDLED;
	
	if (is_user_alive(id) && !g_hasHammer[id]) {
		g_hasHammer[id] = true;
		if (get_user_weapon(id) != CSW_KNIFE) {
			engclient_cmd(id, "weapon_knife");
			set_task(0.1, "ActionBanhammer", id);
			return PLUGIN_HANDLED;
		} else {
			ActionBanhammer(id);
		}
	} else {
		entity_set_string(id, EV_SZ_viewmodel, "models/v_knife.mdl");
		entity_set_string(id, EV_SZ_weaponmodel, "models/p_knife.mdl");
		RemoveAbilities(id);	
	}
	return PLUGIN_HANDLED;
}

public ActionBanhammer(id) {
	entity_set_string(id, EV_SZ_viewmodel, "models/banhammer/v_hammer.mdl");
	entity_set_string(id, EV_SZ_weaponmodel, "models/banhammer/p_hammer.mdl");
	client_cmd(0, "spk ^"banhammer/banhammer^"");
	
	if (get_pcvar_num(h_noclip)) set_user_noclip(id, 1);
	if (get_pcvar_num(h_godmode)) set_user_godmode(id, 1);
	set_user_maxspeed(id, get_pcvar_float(h_speed));
	g_hasHammer[id] = true;
}

public touch_weapon(ent, id) {
	if (id > 0 && id < 33 && g_hasHammer[id]) return HAM_SUPERCEDE;
	return HAM_IGNORED;
}

public CurWeapon(id) {
	if (g_hasHammer[id]) RemoveAbilities(id);
}

public RemoveAbilities(id) {
	if (get_pcvar_num(h_noclip)) {
		set_user_noclip(id);
		set_user_gravity(id, 0.25);
		set_task(3.0, "RemoveGrav", id);
	}
	if (get_pcvar_num(h_godmode)) set_user_godmode(id);
	set_user_maxspeed(id, 230.0);
	g_hasHammer[id] = false;
}

public RemoveGrav(id) {
	set_user_gravity(id);
}

public KnifeAttack(id) {
	new pid = entity_get_edict(id, EV_ENT_owner);
	if (g_hasHammer[pid] && get_pcvar_float(h_delay) > 0.39) {
		if (!g_blocked[pid]) {
			g_blocked[pid] = true;
			set_task(get_pcvar_float(h_delay), "RemoveBlock", pid);
			return PLUGIN_CONTINUE;
		}
		return HAM_SUPERCEDE;
	}
	return HAM_IGNORED;
}

public RemoveBlock(id) {
	g_blocked[id] = false;
}

public PlayerSpawnPost(id) {
	if (g_hasHammer[id] && is_user_alive(id)) {
		entity_set_string(id, EV_SZ_viewmodel, "models/v_knife.mdl");
		entity_set_string(id, EV_SZ_weaponmodel, "models/p_knife.mdl");
		RemoveAbilities(id);
        }
} 

public TraceAttack(id, attacker) {
	if (g_hasHammer[attacker]) {
		g_pid=id;
		entity_set_int(id, EV_INT_flags, entity_get_int(id, EV_INT_flags) | FL_FROZEN);
		
		if (get_pcvar_num(h_check)) {
			new title[48], name[32];
			get_user_name(id, name, 31);
			formatex(title, 47, "Ban %s?", name);
			new menu = menu_create(title, "CheckBan");
			menu_additem(menu, "Igen", "1");
			menu_additem(menu, "Nem", "2");
			menu_setprop(menu, MPROP_EXIT, MEXIT_ALL);
			menu_display(attacker, menu, 0);
		}
		else {
			hammer_hit(id);
		}
		return HAM_SUPERCEDE;
	}
	return HAM_IGNORED;
}

public CheckBan(id, menu, item) {
	if(item == MENU_EXIT || item == MENU_KEY_1) {
		menu_destroy(menu);
		entity_set_int(g_pid, EV_INT_flags, entity_get_int(id, EV_INT_flags) & ~FL_FROZEN);
	} else {
		hammer_hit(g_pid);
	}
}

public hammer_hit(id) {
	new origin[3];
	get_user_origin(id, origin);
	
	new Float:delaytime = get_pcvar_float(h_edelay);
	if (delaytime < 0.1) {
		set_task(0.1, "fx_explode", _, origin, 3);
	} else {
		set_task(delaytime, "fx_explode", _, origin, 3);
	}
}

public fx_explode(origin[3]) {
	new flesh[3];
	flesh[0] = mdl_gib_flesh;
	flesh[1] = mdl_gib_meat;
	flesh[2] = mdl_gib_legbone;
	
	// Explosion FX
	message_begin(MSG_BROADCAST, SVC_TEMPENTITY)
	write_byte(TE_EXPLOSION)
	write_coord(origin[0])
	write_coord(origin[1])
	write_coord(origin[2])
	write_short(explosion)	// sprite index
	write_byte(50)	// scale in 0.1's
	write_byte(10)	// framerate
	write_byte(0)	// flags
	message_end()
	
	// Smoke
	message_begin(MSG_BROADCAST, SVC_TEMPENTITY)
	write_byte(5)
	write_coord(origin[0]) 
	write_coord(origin[1]) 
	write_coord(origin[2]) 
	write_short(smoke) 
	write_byte(20) 
	write_byte(10)
	message_end()

	// Gib explosion
	// Head
	message_begin(MSG_BROADCAST,SVC_TEMPENTITY)
	write_byte(TE_MODEL)
	write_coord(origin[0])
	write_coord(origin[1])
	write_coord(origin[2])
	write_coord(random_num(-50,50))
	write_coord(random_num(-50,50))
	write_coord(random_num(100,200))
	write_angle(random_num(0,360))
	write_short(mdl_gib_head)
	write_byte(0) // bounce
	write_byte(500) // life
	message_end()
	
	// Spine
	message_begin(MSG_BROADCAST,SVC_TEMPENTITY)
	write_byte(TE_MODEL)
	write_coord(origin[0])
	write_coord(origin[1])
	write_coord(origin[2])
	write_coord(random_num(-50,50))
	write_coord(random_num(-50,50))
	write_coord(random_num(100,200))
	write_angle(random_num(0,360))
	write_short(mdl_gib_spine)
	write_byte(0) // bounce
	write_byte(500) // life
	message_end()
	
	// Lung
	for(new i = 0; i < random_num(1,2); i++) {
		message_begin(MSG_BROADCAST,SVC_TEMPENTITY)
		write_byte(TE_MODEL)
		write_coord(origin[0])
		write_coord(origin[1])
		write_coord(origin[2])
		write_coord(random_num(-50,50))
		write_coord(random_num(-50,50))
		write_coord(random_num(100,200))
		write_angle(random_num(0,360))
		write_short(mdl_gib_lung)
		write_byte(0) // bounce
		write_byte(500) // life
		message_end()
	}
	
	// Parts, 5 times
	for(new i = 0; i < 5; i++) {
		message_begin(MSG_BROADCAST,SVC_TEMPENTITY)
		write_byte(TE_MODEL)
		write_coord(origin[0])
		write_coord(origin[1])
		write_coord(origin[2])
		write_coord(random_num(-50,50))
		write_coord(random_num(-50,50))
		write_coord(random_num(100,200))
		write_angle(random_num(0,360))
		write_short(flesh[random_num(0,2)])
		write_byte(0) // bounce
		write_byte(500) // life
		message_end()
	}
	
	// Blood on world decal
	for (new i=0; i < 10; i++) {
		message_begin(MSG_BROADCAST,SVC_TEMPENTITY)
		write_byte(TE_WORLDDECAL)
		write_coord(origin[0]+random_num(-40,40))
		write_coord(origin[1]+random_num(-40,40))
		write_coord(origin[2]-36)
		write_byte(random_num(190, 197)) // index
		message_end();
	}
	new name[32], bantime = get_pcvar_num(h_bantime);
	server_cmd("banid %d #%d kick;wait;writeid", bantime, get_user_userid(g_pid));
	get_user_name(g_pid, name, 31);
	client_print(0, print_chat, "%s %d perces ban-t kapott a BANKALAPÁCSS-al.", name, bantime);
	
	/* Alternative methods are available.
	new authid[32];
	get_user_authid(id, authid, 31);
	get_user_name(id, name, 31);
	client_cmd(g_aid, "amx_addban ^"%s^" ^"%s^" %d ^"Eltalált a BANKALAPÁCS!^"", name, authid, get_pcvar_num(h_bantime));
	server_cmd("kick #%d", get_user_userid(id));*/
}

/*
This function was originally supposed as an additional method to switch back to knife when slot3 or similar was getting pressed.
I removed that again because that is getting called when amx_banhammer is executed as well.
There's still the possible to switch back to knife by pressing other slots/lastinv/amx_banhammer etc.
public client_command(id) {
	new args[4];
	read_args(args, 3);
	if (strlen(args) < 1) {
		entity_set_string(id, EV_SZ_viewmodel, "models/v_knife.mdl");
		entity_set_string(id, EV_SZ_weaponmodel, "models/p_knife.mdl");
		RemoveAbilities(id);
	}
}*/
