/*================================================================================
	
	--------------------------------
	-*- [ZP] Sub-Plugin: Rewards -*-
	--------------------------------
	
	~~~~~~~~~~~~~~~
	- Description -
	~~~~~~~~~~~~~~~
	
	This plugin offers certain amounts of ammo packs
		to those who frag their enemies or win the round.
	Everything is configurable by cvar values.
	This is a plugin that shouldn't be missing
		from any Zombie Plague server out there...
	Enjoy it and have fun!
	
	Original forum thread: http://forums.alliedmods.net/showthread.php?p=1156585
	
	~~~~~~~~~~~~~
	- Thanks to -
	~~~~~~~~~~~~~
	
		MeRcyLeZZ - For such an awesome mod like Zombie Plague
			and for some code i used from it...once again
		XxAvalanchexX - For some code i used from his GunGame Mod
		Fry! and bmann_420 - For not ignoring me when i
			needed help the most (like other 'friends' do)
		suNx - For helping me with the plugin tests
		abdul-rehman - For being a good friend
		And all my real friends...
	
	~~~~~~~~~~~~~
	- Changelog -
	~~~~~~~~~~~~~
	
	* v1.0 (21 Apr 2010)
		- First release
	
	* v1.1 (21 Apr 2010)
		- Fixed plugin turning off when
		the toggle cvar is set to 1
		- Added rewards for surviving
		the round as Nemesis or Survivor
		- Removed unuseful cvars
	
	* v1.2 (22 Apr 2010)
		- Fixed players not getting ammo packs when fragging a enemy
			(rescripted the Player Killed part in the plugin)
		     This wasn't showing up because i was testing the plugin
			with bots and it seems that just human players count
		- Added giving the players rewards in other rounds
	
	* v1.3 (10 May 2010)
		- Fixed bug where a player that killed Nemesis got packs for
			a Zombie frag too. Well, Nemesis is just a fancy Zombie...
		- Fixed players not getting awards for winning
			other rounds than Nemesis or Survivor
		- Added knife kill rewards for Survivors and Humans
		- Added chat text to notify when a Nemesis
			or a Zombie kills or infects a Human
		- Fixed chat multiple print bug
		- Fixed tons of other chat print bugs
	
	* v1.4 (23 Jun 2010)
		- Made the plugin multi-lingual
		- Added rewards for killing the first and last Zombie
		- Added reward giving for killing the last Human
		- Improved some code
		- Fixed some chat print errors
		- Fixed bug where sometimes bazooka kills
			were considered knife kills
	
================================================================================*/

#include <amxmodx>
#include <fakemeta>
#include <hamsandwich>
#include <zombieplague>

// Cvars
new cvar_toggle, cvar_nks_ampks, cvar_nks_round, cvar_nem_round, cvar_skn_ampks,
cvar_sknk_ampks, cvar_skn_round, cvar_skz_ampks, cvar_skzk_ampks, cvar_surv_round,
cvar_zks_ampks, cvar_zks_round, cvar_zklh_ampks, cvar_zm_round, cvar_hkn_ampks,
cvar_hknk_ampks, cvar_hkn_round, cvar_hkz_ampks, cvar_hkzk_ampks, cvar_hkfz_ampks,
cvar_hkfzk_ampks, cvar_hklz_ampks, cvar_hklzk_ampks, cvar_hum_round, cvar_nzkih_show,
cvar_nzkih_ampks

// Get server's max players | Create custom chat print
new g_maxplayers, g_msgSayText

public plugin_init()
{
	register_plugin("[ZP] Sub-Plugin: Rewards", "1.4", "93()|29!/<")
	register_dictionary("zp_rewards.txt")
	
	RegisterHam(Ham_Killed, "player", "fw_PlayerKilled")
	
	g_maxplayers = get_maxplayers()
	g_msgSayText = get_user_msgid("SayText")
}

public plugin_precache()
{
	cvar_toggle = register_cvar("zp_rewards", "1")				// Turned on/off
	cvar_nks_ampks = register_cvar("zp_rewards_nks", "3")			// Nemesis kills Survivor
	cvar_nks_round = register_cvar("zp_rewards_nks_round", "0")		// Only in Plague round
	cvar_nem_round = register_cvar("zp_rewards_nem_round", "35")	// Nemesis wins the round
	cvar_skn_ampks = register_cvar("zp_rewards_skn", "3")			// Survivor kills Nemesis
	cvar_sknk_ampks = register_cvar("zp_rewards_sknk", "25")		// Survivor kills Nemesis with knife
	cvar_skn_round = register_cvar("zp_rewards_skn_round", "0")		// Only in Plague round
	cvar_skz_ampks = register_cvar("zp_rewards_skz", "1")			// Survivor kills Zombie
	cvar_skzk_ampks = register_cvar("zp_rewards_skzk", "15")		// Survivor kills Zombie with knife
	cvar_surv_round = register_cvar("zp_rewards_surv_round", "35")	// Survivor wins the round
	cvar_zks_ampks = register_cvar("zp_rewards_zks", "35")		// Zombie Kills Survivor
	cvar_zks_round = register_cvar("zp_rewards_zks_round", "0")		// Only in Survivor Round
	cvar_zklh_ampks = register_cvar("zp_rewards_zklh", "1")		// Zombie kills last Human
	cvar_zm_round = register_cvar("zp_rewards_zm_round", "1")		// Zombies win the round
	cvar_hkn_ampks = register_cvar("zp_rewards_hkn", "35")		// Human kills Nemesis
	cvar_hknk_ampks = register_cvar("zp_rewards_hknk", "75")		// Human kills Nemesis with knife
	cvar_hkn_round = register_cvar("zp_rewards_hkn_round", "0")		// Only in Nemesis round
	cvar_hkz_ampks = register_cvar("zp_rewards_hkz", "1")			// Human kills Zombie
	cvar_hkzk_ampks = register_cvar("zp_rewards_hkzk", "25")		// Human kills Zombie with knife
	cvar_hkfz_ampks = register_cvar("zp_rewards_hkfz", "3")		// Human kills first Zombie
	cvar_hkfzk_ampks = register_cvar("zp_rewards_hkfzk", "25")		// Human kills first Zombie with knife
	cvar_hklz_ampks = register_cvar("zp_rewards_hklz", "1")		// Human kills last Zombie
	cvar_hklzk_ampks = register_cvar("zp_rewards_hklzk", "25")		// Human kills last Zombie with knife
	cvar_hum_round = register_cvar("zp_rewards_hum_round", "3")		// Humans win the round
	cvar_nzkih_show = register_cvar("zp_rewards_nzkih_show", "1")	// Nemesis/Zombie kills/infects a Human
	cvar_nzkih_ampks = get_cvar_num("zp_zombie_infect_reward")		// Find out how many ammo packs a Nemesis/Zombie gets for killing/infecting a Human
}

public plugin_cfg()
{
	// Plugin is disabled
	if (!get_pcvar_num(cvar_toggle))
		return;
	
	// Get configs dir
	new cfgdir[32]
	get_configsdir(cfgdir, charsmax(cfgdir))
	
	// Execute config file (zp_rewards.cfg)
	server_cmd("exec %s/zp_rewards.cfg", cfgdir)
}

// Ham Player Killed Forward
public fw_PlayerKilled(victim, attacker, shouldgib)
{
	// Plugin is disabled
	if (!get_pcvar_num(cvar_toggle))
		return;
	
	// Get deathmatch mode status and whether the player killed himself
	static selfkill
	selfkill = (victim == attacker || !is_user_connected(attacker)) ? true : false
	
	// Killed by a non-player entity or self killed
	if (selfkill) return;
	
	// Get attacker and victim's name
	static aname[32], vname[32]
	get_user_name(attacker, aname, 31)
	get_user_name(victim, vname, 31)
	
	// A Zombie was killed
	if (zp_get_user_zombie(victim))
	{
		// Get the fragger's current weapon
		static wpnName[24]
		get_killer_weapon(attacker, pev(victim, pev_dmg_inflictor), wpnName, 23)
		
		// Victim was Nemesis. What?! He's a Zombie too, you know?
		if (zp_get_user_nemesis(victim))
		{
			// Survivor's frag
			if (zp_get_user_survivor(attacker))
			{
				// He gets enough ammo packs allready
				if (!zp_is_plague_round() && get_pcvar_num(cvar_skn_round))
					return;
				
				// He knifed the Nemesis
				if (equal(wpnName, "knife"))
				{
					// Option disabled
					if (!get_pcvar_num(cvar_sknk_ampks))
						return;
					
					// Award him
					zp_set_user_ammo_packs(attacker, zp_get_user_ammo_packs(attacker) + get_pcvar_num(cvar_sknk_ampks))
					zp_colored_print(0, "^x04[ZP]^x01 %L", LANG_PLAYER, "REWARDS_SKNK", aname, get_pcvar_num(cvar_sknk_ampks), vname)
				}
				// Just a normal kill
				else
				{
					// Option disabled
					if (!get_pcvar_num(cvar_skn_ampks))
						return;
					
					// Award him
					zp_set_user_ammo_packs(attacker, zp_get_user_ammo_packs(attacker) + get_pcvar_num(cvar_skn_ampks))
					zp_colored_print(0, "^x04[ZP]^x01 %L", LANG_PLAYER, "REWARDS_SKN", aname, get_pcvar_num(cvar_skn_ampks), vname)
				}
			}
			// Human makes the kill
			else
			{
				// But he won't be so happy
				if (!zp_is_nemesis_round() && get_pcvar_num(cvar_hkn_round))
					return;
				
				// He knifed the Nemesis
				if (equal(wpnName, "knife"))
				{
					// Option disabled
					if (!get_pcvar_num(cvar_hknk_ampks))
						return;
					
					// Award him
					zp_set_user_ammo_packs(attacker, zp_get_user_ammo_packs(attacker) + get_pcvar_num(cvar_hknk_ampks))
					zp_colored_print(0, "^x04[ZP]^x01 %L", LANG_PLAYER, "REWARDS_HKNK", aname, get_pcvar_num(cvar_hknk_ampks), vname)
				}
				// Just a normal kill
				else
				{
					// Option disabled
					if (!get_pcvar_num(cvar_hkn_ampks))
						return;
					
					// Award him
					zp_set_user_ammo_packs(attacker, zp_get_user_ammo_packs(attacker) + get_pcvar_num(cvar_hkn_ampks))
					zp_colored_print(0, "^x04[ZP]^x01 %L", LANG_PLAYER, "REWARDS_HKN", aname, get_pcvar_num(cvar_hkn_ampks), vname)
				}
			}
		}
		// Well this time it was just a Zombie
		else
		{
			// Survivor strikes again
			if (zp_get_user_survivor(attacker))
			{
				// He knifed the Zombie
				if (equal(wpnName, "knife"))
				{
					// Option disabled
					if (!get_pcvar_num(cvar_skzk_ampks))
						return;
					
					// Award him
					zp_set_user_ammo_packs(attacker, zp_get_user_ammo_packs(attacker) + get_pcvar_num(cvar_skzk_ampks))
					zp_colored_print(0, "^x04[ZP]^x01 %L", LANG_PLAYER, "REWARDS_SKZK", aname, get_pcvar_num(cvar_skzk_ampks), vname)
				}
				// Just a normal kill
				else
				{
					// Option disabled
					if (!get_pcvar_num(cvar_skz_ampks))
						return;
					
					// Award him
					zp_set_user_ammo_packs(attacker, zp_get_user_ammo_packs(attacker) + get_pcvar_num(cvar_skz_ampks))
					zp_colored_print(0, "^x04[ZP]^x01 %L", LANG_PLAYER, "REWARDS_SKZ", aname, get_pcvar_num(cvar_skz_ampks), vname)
				}
			}
			// Human wants some ammo packs
			else
			{
				// He knifed the Zombie
				if (equal(wpnName, "knife"))
				{
					// Victim was the first Zombie
					if (zp_get_user_first_zombie(victim))
					{
						// No rewards for this kind of kill
						if (!get_pcvar_num(cvar_hkfzk_ampks))
							return;
						
						// Award the killer
						zp_set_user_ammo_packs(attacker, zp_get_user_ammo_packs(attacker) + get_pcvar_num(cvar_hkfzk_ampks))
						zp_colored_print(0, "^x04[ZP]^x01 %L", LANG_PLAYER, "REWARDS_HKFZK", aname, get_pcvar_num(cvar_hkfzk_ampks), vname)
					}
					// Last Zombie
					else if (zp_get_user_last_zombie(victim))
					{
						// No rewards for this kind of kill
						if (!get_pcvar_num(cvar_hklzk_ampks))
							return;
						
						// Award the killer
						zp_set_user_ammo_packs(attacker, zp_get_user_ammo_packs(attacker) + get_pcvar_num(cvar_hklzk_ampks))
						zp_colored_print(0, "^x04[ZP]^x01 %L", LANG_PLAYER, "REWARDS_HKLZK", aname, get_pcvar_num(cvar_hklzk_ampks), vname)
					}
					// Just one of those Zombies
					else
					{
						// Option disabled
						if (!get_pcvar_num(cvar_hkzk_ampks))
							return;
						
						// Award him
						zp_set_user_ammo_packs(attacker, zp_get_user_ammo_packs(attacker) + get_pcvar_num(cvar_hkzk_ampks))
						zp_colored_print(0, "^x04[ZP]^x01 %L", LANG_PLAYER, "REWARDS_HKZK", aname, get_pcvar_num(cvar_hkzk_ampks), vname)
					}
				}
				// Just a normal kill
				else
				{
					// Victim was the first Zombie
					if (zp_get_user_first_zombie(victim))
					{
						// No rewards for this kind of kill
						if (!get_pcvar_num(cvar_hkfz_ampks))
							return;
						
						// Award the killer
						zp_set_user_ammo_packs(attacker, zp_get_user_ammo_packs(attacker) + get_pcvar_num(cvar_hkfz_ampks))
						zp_colored_print(0, "^x04[ZP]^x01 %L", LANG_PLAYER, "REWARDS_HKFZ", aname, get_pcvar_num(cvar_hkfz_ampks), vname)
					}
					// Last Zombie
					else if (zp_get_user_last_zombie(victim))
					{
						// No rewards for this kind of kill
						if (!get_pcvar_num(cvar_hklz_ampks))
							return;
						
						// Award the killer
						zp_set_user_ammo_packs(attacker, zp_get_user_ammo_packs(attacker) + get_pcvar_num(cvar_hklz_ampks))
						zp_colored_print(0, "^x04[ZP]^x01 %L", LANG_PLAYER, "REWARDS_HKLZ", aname, get_pcvar_num(cvar_hklz_ampks), vname)
					}
					// Just one of those Zombies
					else
					{
						// Option disabled
						if (!get_pcvar_num(cvar_hkz_ampks))
							return;
						
						// Award him
						zp_set_user_ammo_packs(attacker, zp_get_user_ammo_packs(attacker) + get_pcvar_num(cvar_hkz_ampks))
						zp_colored_print(0, "^x04[ZP]^x01 %L", LANG_PLAYER, "REWARDS_HKZ", aname, get_pcvar_num(cvar_hkz_ampks), vname)
					}
				}
			}
		}
	}
	// Survivor or Human
	else
	{
		// Killed player was Survivor
		if (zp_get_user_survivor(victim))
		{
			// Nemesis is the killer
			if (zp_get_user_nemesis(attacker))
			{
				// And?
				if (!get_pcvar_num(cvar_nks_ampks) || !zp_is_plague_round() && get_pcvar_num(cvar_nks_round))
					return;
				
				// And he deserves a treat
				zp_set_user_ammo_packs(attacker, zp_get_user_ammo_packs(attacker) + get_pcvar_num(cvar_nks_ampks))
				zp_colored_print(0, "^x04[ZP]^x01 %L", LANG_PLAYER, "REWARDS_NKS", aname, get_pcvar_num(cvar_nks_ampks), vname)
			}
			// Killer is a Zombie
			else
			{
				// So what?
				if (!get_pcvar_num(cvar_zks_ampks) || !zp_is_survivor_round() && get_pcvar_num(cvar_zks_round))
					return;
				
				// So let's give him something... Paulie want a cracker?
				zp_set_user_ammo_packs(attacker, zp_get_user_ammo_packs(attacker) + get_pcvar_num(cvar_zks_ampks))
				zp_colored_print(0, "^x04[ZP]^x01 %L", LANG_PLAYER, "REWARDS_ZKS", aname, get_pcvar_num(cvar_zks_ampks), vname)
			}
		}
		// A Human got killed
		else
		{
			// Last Human
			if (zp_get_user_last_human(victim))
			{
				// Feature disabled
				if (!get_pcvar_num(cvar_zklh_ampks))
					return;
				
				// Reward the killer
				zp_set_user_ammo_packs(attacker, zp_get_user_ammo_packs(attacker) + get_pcvar_num(cvar_zklh_ampks))
				zp_colored_print(0, "^x04[ZP]^x01 %L", LANG_PLAYER, "REWARDS_ZKLH", aname, get_pcvar_num(cvar_zklh_ampks), vname)
			}
			// Just a random Human
			else
			{
				// Showing this isn't allowed
				if (!get_pcvar_num(cvar_nzkih_show) || !cvar_nzkih_ampks)
					return;
				
				// Nemesis' frag
				if (zp_get_user_nemesis(attacker))
					zp_colored_print(0, "^x04[ZP]^x01 %L", LANG_PLAYER, "REWARDS_NKH", aname, cvar_nzkih_ampks, vname)
				// Zombies are good at killing too
				else
					zp_colored_print(0, "^x04[ZP]^x01 %L", LANG_PLAYER, "REWARDS_ZKH", aname, cvar_nzkih_ampks, vname)
			}
		}
	}
}

// ZP User Infected Forward
public zp_user_infected_post(id, infector, nemesis)
{
	// Plugin is disabled | Option disabled | No ammo packs to receive | Not infected by a player | Turned into Nemesis
	if (!get_pcvar_num(cvar_toggle) || !get_pcvar_num(cvar_nzkih_show) || !cvar_nzkih_ampks || !infector || nemesis)
		return;
	
	// Get infector and infected's name
	static aname[32], vname[32]
	get_user_name(infector, aname, 31)
	get_user_name(id, vname, 31)
	
	// Spread the word
	zp_colored_print(0, "^x04[ZP]^x01 %L", LANG_PLAYER, "REWARDS_ZIH", aname, cvar_nzkih_ampks, vname)
}

// ZP Round Ended Forward
public zp_round_ended(winteam)
{
	// Plugin is disabled | No one won...
	if (!get_pcvar_num(cvar_toggle) || winteam == WIN_NO_ONE)
		return;
	
	// Loop trough all the players
	static id
	for (id = 1; id <= g_maxplayers; id++)
	{
		// Zombies have conquered the world
		if (winteam == WIN_ZOMBIES)
		{
			// Was Nemesis round
			if (zp_is_nemesis_round())
			{
				// Option turned off
				if (!get_pcvar_num(cvar_nem_round))
					return;
				
				// Is Nemesis
				if (zp_get_user_nemesis(id))
					zp_set_user_ammo_packs(id, zp_get_user_ammo_packs(id) + get_pcvar_num(cvar_nem_round))
				
				if (zp_get_nemesis_count() > 1)
					zp_colored_print(id, "^x04[ZP]^x01 %L", id, "REWARDS_NEM_ROUND2", get_pcvar_num(cvar_nem_round))
				else
					zp_colored_print(id, "^x04[ZP]^x01 %L", id, "REWARDS_NEM_ROUND1", get_pcvar_num(cvar_nem_round))
			}
			// Other rounds
			else
			{
				// Option turned off
				if (!get_pcvar_num(cvar_zm_round))
					return;
				
				// Is Zombie
				if (zp_get_user_zombie(id))
					zp_set_user_ammo_packs(id, zp_get_user_ammo_packs(id) + get_pcvar_num(cvar_zm_round))
				
				// No Nemesis was found
				if (!zp_get_nemesis_count())
					zp_colored_print(id, "^x04[ZP]^x01 %L", id, "REWARDS_ZM_ROUND", get_pcvar_num(cvar_zm_round))
				// One or more Nemesis were present
				else
					zp_colored_print(id, "^x04[ZP]^x01 %L", id, "REWARDS_NEM_ZM_ROUND", get_pcvar_num(cvar_zm_round))
			}
		}
		
		// Humans survived
		if (winteam == WIN_HUMANS)
		{
			// Was Survivor round
			if (zp_is_survivor_round())
			{
				// Option turned off
				if (!get_pcvar_num(cvar_surv_round))
					return;
				
				// Is Survivor
				if (zp_get_user_survivor(id))
					zp_set_user_ammo_packs(id, zp_get_user_ammo_packs(id) + get_pcvar_num(cvar_surv_round))
				
				// More than one Survivor
				if (zp_get_survivor_count() > 1)
					zp_colored_print(id, "^x04[ZP]^x01 %L", id, "REWARDS_SURV_ROUND2", get_pcvar_num(cvar_surv_round))
				// Only one Survivor
				else
					zp_colored_print(id, "^x04[ZP]^x01 %L", id, "REWARDS_SURV_ROUND1", get_pcvar_num(cvar_surv_round))
			}
			// Other rounds
			else
			{
				// Option turned on
				if (!get_pcvar_num(cvar_hum_round))
					return;
				
				// Isn't Zombie
				if (!zp_get_user_zombie(id))
					zp_set_user_ammo_packs(id, zp_get_user_ammo_packs(id) + get_pcvar_num(cvar_hum_round))
				
				// No Survivors
				if (!zp_get_survivor_count())
					zp_colored_print(id, "^x04[ZP]^x01 %L", id, "REWARDS_HUM_ROUND", get_pcvar_num(cvar_hum_round))
				// There are Survivors too
				else
					zp_colored_print(id, "^x04[ZP]^x01 %L", id, "REWARDS_SURV_HUM_ROUND", get_pcvar_num(cvar_hum_round))
			}
		}
	}
}

// Colored chat print. Thanks to MeRcyLeZZ
zp_colored_print(target, const message[], any:...)
{
	static buffer[512], i, argscount
	argscount = numargs()
	
	// Send to everyone
	if (!target)
	{
		static player
		for (player = 1; player <= g_maxplayers; player++)
		{
			// Not connected
			if (!is_user_connected(player))
				continue;
			
			// Remember changed arguments
			static changed[5], changedcount // [5] = max LANG_PLAYER occurencies
			changedcount = 0
			
			// Replace LANG_PLAYER with player id
			for (i = 2; i < argscount; i++)
			{
				if (getarg(i) == LANG_PLAYER)
				{
					setarg(i, 0, player)
					changed[changedcount] = i
					changedcount++
				}
			}
			
			// Format message for player
			vformat(buffer, charsmax(buffer), message, 3)
			
			// Send it
			message_begin(MSG_ONE_UNRELIABLE, g_msgSayText, _, player)
			write_byte(player)
			write_string(buffer)
			message_end()
			
			// Replace back player id's with LANG_PLAYER
			for (i = 0; i < changedcount; i++)
				setarg(changed[i], 0, LANG_PLAYER)
		}
	}
	// Send to specific target
	else
	{
		// Not connected
		if (!is_user_connected(target))
			return;
		
		// Format message for player
		vformat(buffer, charsmax(buffer), message, 3)
		
		// Send it
		message_begin(MSG_ONE, g_msgSayText, _, target)
		write_byte(target)
		write_string(buffer)
		message_end()
	}
}

// Stock from AmxMisc
stock get_configsdir(name[], len)
{
	return get_localinfo("amxx_configsdir", name, len);
}

// Gets the weapon that the killer used
stock get_killer_weapon(killer, inflictor, retVar[], retLen)
{
	static killer_weapon_name[32];
	killer_weapon_name = "world"; // by default, the player is killed by the world

	if (pev_valid(killer) && (pev(killer, pev_flags) & FL_CLIENT))
	{
		if (pev_valid(inflictor))
		{
			if (inflictor == killer)
			{
				// if the inflictor is the killer, then it must be their current weapon doing the damage
				new weapon = get_user_weapon(killer);
				get_weaponname(weapon, killer_weapon_name, 31);
			}
			else pev(inflictor, pev_classname, killer_weapon_name, 31); // it's just that easy
		}
	}
	else
	{
		if (pev_valid(killer)) pev(inflictor, pev_classname, killer_weapon_name, 31);
		else if (killer == 0) killer_weapon_name = "worldspawn";
	}
	
	// Strip the monster_* or weapon_* from the inflictor's classname
	if (equal(killer_weapon_name, "weapon_", 7))
		format(killer_weapon_name, 31, "%s", killer_weapon_name[7]);
	else if (equal(killer_weapon_name, "monster_", 8))
		format(killer_weapon_name, 31, "%s", killer_weapon_name[8]);
	else if (equal(killer_weapon_name, "func_", 5))
		format(killer_weapon_name, 31, "%s", killer_weapon_name[5]);
	
	// Output
	formatex(retVar, retLen, "%s", killer_weapon_name);
}
