#include <amxmodx>
#include <fakemeta>
#include <hamsandwich>
#include <amx_settings_api>
#include <cs_teams_api>
#include <cs_ham_bots_api>
#include <zp50_gamemodes>
#include <zp50_deathmatch>

new const ZP_SETTINGS_FILE[] = "zombieplague.ini"

new const sound_gravity[][] = { "zombie_plague/zpdam_round_gravity.wav" }

#define SOUND_MAX_LENGTH 64

new Array:g_sound_gravity

#define HUD_EVENT_X -1.0
#define HUD_EVENT_Y 0.17
#define HUD_EVENT_R 200
#define HUD_EVENT_G 50
#define HUD_EVENT_B 0

new g_MaxPlayers
new g_HudSync

new cvar_gravity_chance, cvar_gravity_min_players, cvar_gravity_min_zombies
new cvar_gravity_ratio, cvar_gravity_show_hud, cvar_gravity_sounds
new cvar_gravity_allow_respawn, cvar_respawn_after_last_human
new cvar_gravity_server, cvar_gravity_normal, cvar_gravity_round

public plugin_precache()
{
	register_plugin("[ZP] Game Mode: Gravity", "1.0", "Daminou")
	zp_gamemodes_register("Gravity Mode")
	
	g_HudSync = CreateHudSyncObj()
	
	g_MaxPlayers = get_maxplayers()
	
	cvar_gravity_chance = register_cvar("zpdam_gravity_chance", "35")
	cvar_gravity_min_players = register_cvar("zpdam_gravity_min_players", "2")
	cvar_gravity_min_zombies = register_cvar("zpdam_gravity_min_zombies", "2")
	cvar_gravity_ratio = register_cvar("zpdam_gravity_ratio", "0.5")
	cvar_gravity_show_hud = register_cvar("zpdam_gravity_show_hud", "1")
	cvar_gravity_sounds = register_cvar("zpdam_gravity_sounds", "1")
	cvar_gravity_allow_respawn = register_cvar("zpdam_gravity_allow_respawn", "1")
	cvar_respawn_after_last_human = register_cvar("zpdam_gra_respawn_after_last_human", "1")
	cvar_gravity_server = get_cvar_pointer("sv_gravity")
	cvar_gravity_normal = register_cvar("zpdam_gravity_normal", "800")
	cvar_gravity_round = register_cvar("zpdam_gravity_round", "250")
	
	g_sound_gravity = ArrayCreate(SOUND_MAX_LENGTH, 1)
	
	amx_load_setting_string_arr(ZP_SETTINGS_FILE, "Sounds", "ROUND GRAVITY", g_sound_gravity)
	
	new index
	if (ArraySize(g_sound_gravity) == 0)
	{
		for (index = 0; index < sizeof sound_gravity; index++)
			ArrayPushString(g_sound_gravity, sound_gravity[index])
		
		amx_save_setting_string_arr(ZP_SETTINGS_FILE, "Sounds", "ROUND GRAVITY", g_sound_gravity)
	}
	
	new sound[SOUND_MAX_LENGTH]
	for (index = 0; index < ArraySize(g_sound_gravity); index++)
	{
		ArrayGetString(g_sound_gravity, index, sound, charsmax(sound))
		if (equal(sound[strlen(sound)-4], ".mp3"))
		{
			format(sound, charsmax(sound), "sound/%s", sound)
			precache_generic(sound)
		}
		else
			precache_sound(sound)
	}
}

public zp_fw_deathmatch_respawn_pre(id)
{
	if (!get_pcvar_num(cvar_gravity_allow_respawn))
		return PLUGIN_HANDLED;
	
	if (!get_pcvar_num(cvar_respawn_after_last_human) && zp_core_get_human_count() == 1)
		return PLUGIN_HANDLED;
	
	return PLUGIN_CONTINUE;
}

public zp_fw_gamemodes_choose_pre(game_mode_id, skipchecks)
{
	new alive_count = GetAliveCount()
	
	new zombie_count = floatround(alive_count * get_pcvar_float(cvar_gravity_ratio), floatround_ceil)
	
	if (!skipchecks)
	{
		if (random_num(1, get_pcvar_num(cvar_gravity_chance)) != 1)
			return PLUGIN_HANDLED;
		
		if (alive_count < get_pcvar_num(cvar_gravity_min_players))
			return PLUGIN_HANDLED;
		
		if (zombie_count < get_pcvar_num(cvar_gravity_min_zombies))
			return PLUGIN_HANDLED;
	}
	
	if (zombie_count >= alive_count)
		return PLUGIN_HANDLED;
	
	return PLUGIN_CONTINUE;
}

public zp_fw_gamemodes_start()
{
	new gravity_round = get_pcvar_num(cvar_gravity_round)
	set_pcvar_num(cvar_gravity_server, gravity_round)
	zp_gamemodes_set_allow_infect()
	
	new iZombies, id, alive_count = GetAliveCount()
	new iMaxZombies = floatround(alive_count * get_pcvar_float(cvar_gravity_ratio), floatround_ceil)
	
	while (iZombies < iMaxZombies)
	{
		id = GetRandomAlive(random_num(1, alive_count))
		
		if (!is_user_alive(id) || zp_core_is_zombie(id))
			continue;
		
		zp_core_infect(id, 0)
		iZombies++
	}
	
	for (id = 1; id <= g_MaxPlayers; id++)
	{
		if (!is_user_alive(id) || zp_core_is_zombie(id))
			continue;
		
		cs_set_player_team(id, CS_TEAM_CT)
	}
	
	if (get_pcvar_num(cvar_gravity_sounds))
	{
		new sound[SOUND_MAX_LENGTH]
		ArrayGetString(g_sound_gravity, random_num(0, ArraySize(g_sound_gravity) - 1), sound, charsmax(sound))
		PlaySoundToClients(sound)
	}
	
	if (get_pcvar_num(cvar_gravity_show_hud))
	{
		set_hudmessage(HUD_EVENT_R, HUD_EVENT_G, HUD_EVENT_B, HUD_EVENT_X, HUD_EVENT_Y, 1, 0.0, 5.0, 1.0, 1.0, -1)
		ShowSyncHudMsg(0, g_HudSync, "%L", LANG_PLAYER, "NOTICE_GRAVITY")
	}
}

public zp_fw_gamemodes_end()
{
	new gravity_normal = get_pcvar_num(cvar_gravity_normal)
	set_pcvar_num(cvar_gravity_server, gravity_normal)
}

PlaySoundToClients(const sound[])
{
	if (equal(sound[strlen(sound)-4], ".mp3"))
		client_cmd(0, "mp3 play ^"sound/%s^"", sound)
	else
		client_cmd(0, "spk ^"%s^"", sound)
}

GetAliveCount()
{
	new iAlive, id
	
	for (id = 1; id <= g_MaxPlayers; id++)
	{
		if (is_user_alive(id))
			iAlive++
	}
	
	return iAlive;
}

GetRandomAlive(target_index)
{
	new iAlive, id
	
	for (id = 1; id <= g_MaxPlayers; id++)
	{
		if (is_user_alive(id))
			iAlive++
		
		if (iAlive == target_index)
			return id;
	}
	
	return -1;
}
/* AMXX-Studio Notes - DO NOT MODIFY BELOW HERE
*{\\ rtf1\\ ansi\\ deff0{\\ fonttbl{\\ f0\\ fnil Tahoma;}}\n\\ viewkind4\\ uc1\\ pard\\ lang1036\\ f0\\ fs16 \n\\ par }
*/
