#include <amxmodx>
#include <hamsandwich>
#include <fakemeta>
#include <engine>

#define PLUGIN "Chat Icon"
#define VERSION "1.0"
#define AUTHOR "DJ_WEST"

#define CHAT_ICON "sprites/chat_icon1.spr"
#define BIND_TASKID 7829
#define ICON_SIZE 0.47
#define ICON_ALPHA 255

new bool:g_b_PlayerInChat[33]
new HamHook:g_h_PlayerPostThink[33]
new g_PlayerIcon[33]
new g_InfoTarget

public plugin_init() 
{
	register_plugin(PLUGIN, VERSION, AUTHOR)
	
	register_clcmd("chat", "Start_Chat")
	register_clcmd("chat_team", "Start_Chat")
	register_clcmd("say", "Check_Chat")
	register_clcmd("say_team", "Check_Chat")

	g_InfoTarget = engfunc(EngFunc_AllocString, "info_target")
}

public plugin_precache()
	precache_model(CHAT_ICON)

public client_putinserver(id)
{
	if (is_user_bot(id) || is_user_hltv(id))
		return
		
	g_b_PlayerInChat[id] = false
	g_PlayerIcon[id] = 0
	set_task(5.0, "Bind_Delay", id + BIND_TASKID)
}

public client_disconnect(id)
	remove_task(id + BIND_TASKID)

public Bind_Delay(taskid)
{
	static id
	
	id = taskid - BIND_TASKID
	client_cmd(id, "bind y ^"chat;messagemode^";bind u ^"chat_team;messagemode2")
}

public Start_Chat(id)
{
	g_b_PlayerInChat[id] = true
	
	Enable_Icon(id)
	
	if (g_h_PlayerPostThink[id])
		EnableHamForward(g_h_PlayerPostThink[id])
	else
		g_h_PlayerPostThink[id] = RegisterHamFromEntity(Ham_Player_PostThink, id, "Player_Moving", 1)
	
	return PLUGIN_HANDLED
}

public Player_Moving(id)
{
	static i_Buttons
	
	i_Buttons = pev(id, pev_button)
	
	if (i_Buttons)
		Disable_Icon(id)
}

public Check_Chat(id)
{
	if (g_b_PlayerInChat[id])
		Disable_Icon(id)
}

public Enable_Icon(id)
{
	new i_Ent
	
	i_Ent = engfunc(EngFunc_CreateNamedEntity, g_InfoTarget)
	engfunc(EngFunc_SetModel, i_Ent, CHAT_ICON)
	set_pev(i_Ent, pev_aiment, id)
	set_pev(i_Ent, pev_movetype, MOVETYPE_FOLLOW)
	set_pev(i_Ent, pev_scale, ICON_SIZE)
	set_rendering(i_Ent, kRenderFxNone, 0, 0, 0, kRenderTransAlpha, ICON_ALPHA)
	g_PlayerIcon[id] = i_Ent
}

public Disable_Icon(id)
{
	static i_Ent
	
	if (g_h_PlayerPostThink[id])
		DisableHamForward(g_h_PlayerPostThink[id])
			
	g_b_PlayerInChat[id] = false

	i_Ent = g_PlayerIcon[id]

	if (i_Ent && pev_valid(i_Ent))
		remove_entity(i_Ent)
}
