/**
 *
 * Custom Sniper Scopes
 *  by Numb
 *
 *
 * Description:
 *  This plugin changes sniper scopes to custom ones. Client still has the ability to disable
 *  custom scopes by typing "/scope" in chat. That command will open a menu which allows client
 *  to choose what sniper rifles will have custom scopes and which ones wont. Admins can change
 *  scopes by using available cvars. Cvars can be changed to a sprite name without the ".spr"
 *  ending, and without the "sprites/" folder at the beginning. An example of cvar string for
 *  custom scope (using the default sprite) would be "sniper_scope".
 *
 *
 * Requires:
 *  FakeMeta
 *  HamSandWich
 *
 *
 * Cvars:
 *
 *  + "[U]scope_awp[/U]" - "" - awp custom scope.
 *  + "[U]scope_scout[/U]" - "" - scout custom scope.
 *  + "[U]scope_g3sg1[/U]" - "" - g3sg1 custom scope.
 *  + "[U]scope_sg550[/U]" - "" - sg550 custom scope.
 *
 *
 * Additional Info:
 *  Tested in Counter-Strike 1.6 with amxmodx 1.8.2 (dev build hg21). Leaving the cvars empty
 *  will enforce the scopes what are uploaded with the plugin.
 *
 *
 * Notes:
 *  Cvar changes take effect only at mapchange. And in order for sprites not to repeat, plugin
 *  will copy them to a different name what shall be unique only to your server ip. However
 *  don't remove your non-copied ones.
 *
 *
 * Warnings:
 *  Pausing and/or unpausing this plugin within an event (from message_begin() to message_end())
 *  may result in an error and possible crash.
 *
 *
 * Images:
 *
 *  + AWP: http://cloud-2.steampowered.com/ugc/542933952325064122/CBF6A12159853071F6A85D0F206098CA339BEEA2/
 *  + Scout: http://cloud.steampowered.com/ugc/542933952325068238/91655CC6CD11E7AC3D62ACAB634DB968551794B1/
 *  + G3SG1: http://cloud.steampowered.com/ugc/542933952325075179/AFD1098BC1177B6545D7E40D342B4D9BCB3120F6/
 *  + SG550: http://cloud-2.steampowered.com/ugc/542933952325077902/7380A6F6034E6364FC28BE47727E8E887A0A0077/
 *
 *
 * Credits:
 *  Special thanks to Arkshine ( http://forums.alliedmods.net/member.php?u=7779 ) for help in
 *  WeaponList ( http://forums.alliedmods.net/showthread.php?t=175632 ) related things.
 *
 *
 * ChangeLog:
 *
 *
 *  + 1.1
 *  - Changed: Advertisement isn't that often.
 *  - Changed: Advertisement is higher up the screen.
 *
 *  + 1.0
 *  - First release.
 *
 *
 * Downloads:
 *  Amx Mod X forums: http://forums.alliedmods.net/showthread.php?p=1761329#post1761329
 *
**/


#include <amxmodx>
#include <fakemeta>
#include <hamsandwich>

#define PLUGIN_NAME	"Custom Sniper Scopes"
#define PLUGIN_VERSION	"1.1"
#define PLUGIN_AUTHOR	"Numb"

#define SetPlayerBit(%1,%2)    ( %1 |=  ( 1 << ( %2 & 31 ) ) )
#define ClearPlayerBit(%1,%2)  ( %1 &= ~( 1 << ( %2 & 31 ) ) )
#define CheckPlayerBit(%1,%2)  ( %1 &   ( 1 << ( %2 & 31 ) ) )

#define m_pPlayer 41
#define m_iId 43
#define m_iClip 51

#define m_pActiveItem 373

new g_iAWPFileName[64];
new g_iScoutFileName[64];
new g_iG3SG1FileName[64];
new g_iSG550FileName[64];

new g_iCustomAwp;
new g_iCustomScout;
new g_iCustomG3SG1;
new g_iCustomSG550;
new g_iShouldUpdate;

new g_iLastSpectated[33];

new g_iMsgId_CurWeapon;
new g_iMsgId_WeaponList;


public plugin_precache()
{
	new iIpAddress[16];
	get_user_ip(0, iIpAddress, 15, 1);
	replace_all(iIpAddress, 15, ".", "_");
	
	#define AWP_CONFIG "14^n\
		weapon 320 320hud1 80 120 80 20^n\
		weapon_s 320 320hud1 80 140 80 20^n\
		ammo 320 640hud7 24 96 24 24^n\
		%s^n\
		weapon 640 640hud2 0 135 170 45^n\
		weapon_s 640 640hud5 0 135 170 45^n\
		ammo 640 640hud7 24 96 24 24^n\
		%s"
	if( configurate(register_cvar("scope_awp", ""), "awp", AWP_CONFIG, iIpAddress, g_iAWPFileName, 63) )
		register_clcmd(g_iAWPFileName, "clcmd_fix_awp");
	
	#define SCOUT_CONFIG "14^n\
		weapon 320 320hud1 0 80 80 20^n\
		weapon_s 320 320hud1 0 100 80 20^n\
		ammo 320 640hud7 72 72 24 24^n\
		%s^n\
		weapon 640 640hud12 0 45 170 45^n\
		weapon_s 640 640hud13 0 45 170 45^n\
		ammo 640 640hud7 72 72 24 24^n\
		%s"
	if( configurate(register_cvar("scope_scout", ""), "scout", SCOUT_CONFIG, iIpAddress, g_iScoutFileName, 63) )
		register_clcmd(g_iScoutFileName, "clcmd_fix_scout");
	
	#define G3SG1_CONFIG "14^n\
		weapon 320 320hud1 80 160 80 20^n\
		weapon_s 320 320hud1 80 180 80 20^n\
		ammo 320 640hud7 72 72 24 24^n\
		%s^n\
		weapon 640 640hud2 0 180 170 45^n\
		weapon_s 640 640hud5 0 180 170 45^n\
		ammo 640 640hud7 72 72 24 24^n\
		%s"
	if( configurate(register_cvar("scope_g3sg1", ""), "g3sg1", G3SG1_CONFIG, iIpAddress, g_iG3SG1FileName, 63) )
		register_clcmd(g_iG3SG1FileName, "clcmd_fix_g3sg1");
	
	#define SG550_CONFIG "14^n\
		weapon 320 320hud2 160 168 80 20^n\
		weapon_s 320 320hud2 160 188 80 20^n\
		ammo 320 640hud7 0 96 24 24^n\
		%s^n\
		weapon 640 640hud14 0 180 170 45^n\
		weapon_s 640 640hud15 0 180 170 45^n\
		ammo 640 640hud7 0 96 24 24^n\
		%s"
	if( configurate(register_cvar("scope_sg550", ""), "sg550", SG550_CONFIG, iIpAddress, g_iSG550FileName, 63) )
		register_clcmd(g_iSG550FileName, "clcmd_fix_sg550");
}

public plugin_init()
{
	register_plugin(PLUGIN_NAME, PLUGIN_VERSION, PLUGIN_AUTHOR);
	
	register_event("TextMsg",  "Event_ResetInfo", "bd", "1=4", "2=#Spec_Mode1"); // Locked Chase Cam
	register_event("TextMsg",  "Event_ResetInfo", "bd", "1=4", "2=#Spec_Mode2"); // Free Chase Cam
	register_event("TextMsg",  "Event_ResetInfo", "bd", "1=4", "2=#Spec_Mode3"); // Free Look
	register_event("TextMsg",  "Event_ResetInfo", "bd", "1=4", "2=#Spec_Mode5"); // Free Overview
	register_event("TextMsg",  "Event_ResetInfo", "bd", "1=4", "2=#Spec_Mode6"); // Chase Overview
	register_event("ResetHUD", "Event_ResetInfo", "be");
	
	register_message((g_iMsgId_CurWeapon=get_user_msgid("CurWeapon")), "Message_CurWeapon");
	
	register_menucmd(register_menuid("Custom Scopes"), 1023, "Menu_Select_Scopes");
	
	register_clcmd("say /tavcso", "clcmd_scope", ADMIN_USER, " - menu to change your sniper scopes");
	
	if( g_iAWPFileName[0] )
		RegisterHam(Ham_Item_AttachToPlayer, "weapon_awp",   "Ham_AttachToPlayer_Post", 1);
	if( g_iScoutFileName[0] )
		RegisterHam(Ham_Item_AttachToPlayer, "weapon_scout", "Ham_AttachToPlayer_Post", 1);
	if( g_iG3SG1FileName[0] )
		RegisterHam(Ham_Item_AttachToPlayer, "weapon_g3sg1", "Ham_AttachToPlayer_Post", 1);
	if( g_iSG550FileName[0] )
		RegisterHam(Ham_Item_AttachToPlayer, "weapon_sg550", "Ham_AttachToPlayer_Post", 1);
	
	g_iMsgId_WeaponList = get_user_msgid("WeaponList");
}

public plugin_pause()
{
	new iPlayers[32], iPlayerNum, iPlrId;
	get_players(iPlayers, iPlayerNum, "ch");
	for( new iPlayer; iPlayer<iPlayerNum; iPlayer++ )
	{
		iPlrId = iPlayers[iPlayer];
		
		if( CheckPlayerBit(g_iShouldUpdate, iPlrId) )
			continue;
		
		if( CheckPlayerBit(g_iCustomAwp, iPlrId) )
			send_awp(iPlrId, true);
		if( CheckPlayerBit(g_iCustomScout, iPlrId) )
			send_scout(iPlrId, true);
		if( CheckPlayerBit(g_iCustomG3SG1, iPlrId) )
			send_g3sg1(iPlrId, true);
		if( CheckPlayerBit(g_iCustomSG550, iPlrId) )
			send_sg550(iPlrId, true);
	}
	g_iCustomAwp = 0;
	g_iCustomScout = 0;
	g_iCustomG3SG1 = 0;
	g_iCustomSG550 = 0;
	g_iShouldUpdate = 0;
}

public plugin_unpause()
{
	new iPlayers[32], iPlayerNum, iPlrId;
	get_players(iPlayers, iPlayerNum, "ch");
	for( new iPlayer; iPlayer<iPlayerNum; iPlayer++ )
	{
		iPlrId = iPlayers[iPlayer];
		
		send_awp(iPlrId);
		send_scout(iPlrId);
		send_g3sg1(iPlrId);
		send_sg550(iPlrId);
		
		g_iLastSpectated[iPlrId] = 0;
	}
}

public client_putinserver(iPlrId)
{
	if( !is_user_hltv(iPlrId) && !is_user_bot(iPlrId) )
	{
		SetPlayerBit(g_iCustomAwp, iPlrId);
		SetPlayerBit(g_iCustomScout, iPlrId);
		SetPlayerBit(g_iCustomG3SG1, iPlrId);
		SetPlayerBit(g_iCustomSG550, iPlrId);
		SetPlayerBit(g_iShouldUpdate, iPlrId);
	}
	
	g_iLastSpectated[iPlrId] = 0;
}

public client_disconnect(iPlrId)
{
	ClearPlayerBit(g_iCustomAwp, iPlrId);
	ClearPlayerBit(g_iCustomScout, iPlrId);
	ClearPlayerBit(g_iCustomG3SG1, iPlrId);
	ClearPlayerBit(g_iCustomSG550, iPlrId);
	ClearPlayerBit(g_iShouldUpdate, iPlrId);
	
	g_iLastSpectated[iPlrId] = 0;
}

public Event_ResetInfo(iPlrId)
	g_iLastSpectated[iPlrId] = 0;

public Message_CurWeapon(iMsgId, iMsgType, iPlrId)
{
	if( CheckPlayerBit(g_iShouldUpdate, iPlrId) )
	{
		ClearPlayerBit(g_iShouldUpdate, iPlrId);
		
		send_awp(iPlrId, false, false);
		send_scout(iPlrId, false, false);
		send_g3sg1(iPlrId, false, false);
		send_sg550(iPlrId, false, false);
	}
	
	if( get_msg_arg_int(1) )
	{
		static s_iSpectated;
		s_iSpectated = pev(iPlrId, pev_iuser2);
		switch( get_msg_arg_int(2) )
		{
			case CSW_AWP:
			{
				if( g_iAWPFileName[0] && s_iSpectated!=g_iLastSpectated[iPlrId] )
				{
					g_iLastSpectated[iPlrId] = s_iSpectated;
					print_message(iPlrId);
				}
			}
			case CSW_SCOUT:
			{
				if( g_iScoutFileName[0] && s_iSpectated!=g_iLastSpectated[iPlrId] )
				{
					g_iLastSpectated[iPlrId] = s_iSpectated;
					print_message(iPlrId);
				}
			}
			case CSW_G3SG1:
			{
				if( g_iG3SG1FileName[0] && s_iSpectated!=g_iLastSpectated[iPlrId] )
				{
					g_iLastSpectated[iPlrId] = s_iSpectated;
					print_message(iPlrId);
				}
			}
			case CSW_SG550:
			{
				if( g_iAWPFileName[0] && s_iSpectated!=g_iLastSpectated[iPlrId] )
				{
					g_iLastSpectated[iPlrId] = s_iSpectated;
					print_message(iPlrId);
				}
			}
			default:
			{
				if( s_iSpectated!=g_iLastSpectated[iPlrId] )
					g_iLastSpectated[iPlrId] = 0;
			}
		}
	}
}

public clcmd_fix_awp(iPlrId)
{
	if( CheckPlayerBit(g_iCustomAwp, iPlrId) && !CheckPlayerBit(g_iShouldUpdate, iPlrId) )
		engclient_cmd(iPlrId, "weapon_awp");
}

public clcmd_fix_scout(iPlrId)
{
	if( CheckPlayerBit(g_iCustomScout, iPlrId) && !CheckPlayerBit(g_iShouldUpdate, iPlrId) )
		engclient_cmd(iPlrId, "weapon_scout");
}

public clcmd_fix_g3sg1(iPlrId)
{
	if( CheckPlayerBit(g_iCustomG3SG1, iPlrId) && !CheckPlayerBit(g_iShouldUpdate, iPlrId) )
		engclient_cmd(iPlrId, "weapon_g3sg1");
}

public clcmd_fix_sg550(iPlrId)
{
	if( CheckPlayerBit(g_iCustomSG550, iPlrId) && !CheckPlayerBit(g_iShouldUpdate, iPlrId) )
		engclient_cmd(iPlrId, "weapon_sg550");
}

public clcmd_scope(iPlrId)
{
	if( CheckPlayerBit(g_iShouldUpdate, iPlrId) )
	{
		ClearPlayerBit(g_iShouldUpdate, iPlrId);
		
		send_awp(iPlrId, false, false);
		send_scout(iPlrId, false, false);
		send_g3sg1(iPlrId, false, false);
		send_sg550(iPlrId, false, false);
	}
	
	Menu_Open_Scope(iPlrId);
}

public Menu_Select_Scopes(iPlrId, iKey)
{
	switch( iKey )
	{
		case 0: send_awp(iPlrId, (CheckPlayerBit(g_iCustomAwp, iPlrId)?true:false));
		case 1: send_scout(iPlrId, (CheckPlayerBit(g_iCustomScout, iPlrId)?true:false));
		case 2: send_g3sg1(iPlrId, (CheckPlayerBit(g_iCustomG3SG1, iPlrId)?true:false));
		case 3: send_sg550(iPlrId, (CheckPlayerBit(g_iCustomSG550, iPlrId)?true:false));
		default: return PLUGIN_HANDLED;
	}
	Menu_Open_Scope(iPlrId);
	
	return PLUGIN_HANDLED;
}

public Ham_AttachToPlayer_Post(iEnt, iPlrId)
	print_message(iPlrId);

configurate(iCvarPointer, const iWpnName[], const iWpnBuffer[], const iIpAddress[], iToggleCmd[], iLen)
{
	#define IDENTICAL_320 "crosshair 320 crosshairs 24 0 24 24^n\
		autoaim 320 crosshairs 0 72 24 24^n\
		zoom 320 ch_sniper2 0 0 256 256^n\
		zoom_autoaim 320 ch_sniper2 0 0 256 256"
	#define IDENTICAL_640 "crosshair 640 crosshairs 24 0 24 24^n\
		autoaim 640 crosshairs 0 72 24 24^n\
		zoom 640 %s 0 0 256 256^n\
		zoom_autoaim 640 %s 0 0 256 256"
		
	new iCvarText[32], iSpriteFile[64], bool:bFound;
	
	if( get_pcvar_string(iCvarPointer, iCvarText, 31) )
		bFound = true;
	else
		formatex(iCvarText, 31, "scope_%s_numb", iWpnName);
	
	formatex(iSpriteFile, 63, "sprites/%s.spr", iCvarText);
	if( file_exists(iSpriteFile) )
	{
		if( bFound )
		{
			new iSprite[64];
			
			formatex(iSprite, 63, "sprites/%s_%s.spr", iCvarText, iIpAddress);
			if( !file_exists(iSprite) )
			{
				new iFileIdRead = fopen(iSpriteFile, "rb");
				if( !iFileIdRead )
					bFound = false;
				else
				{
					new iFileIdWrite = fopen(iSprite, "wb");
					if( !iFileIdWrite )
					{
						fclose(iFileIdRead);
						bFound = false;
					}
					else
					{
						while( !feof(iFileIdRead) )
							fputc(iFileIdWrite, fgetc(iFileIdRead));
						
						fclose(iFileIdRead);
						fclose(iFileIdWrite);
					}
				}
			}
			
			if( bFound )
			{
				new iBuffer[1024];
				
				copy(iSpriteFile, 63, iSprite);
				formatex(iSprite, 63, "%s_%s", iCvarText, iIpAddress);
				
				new iTextFile[128];
				formatex(iTextFile, 127, "sprites/wpn_%s_%s_%s.txt", iWpnName, iIpAddress, iCvarText);
				formatex(iBuffer, 1023, iWpnBuffer, IDENTICAL_320, IDENTICAL_640);
				format(iBuffer, 1023, iBuffer, iSprite, iSprite);
				
				if( file_exists(iTextFile) )
					delete_file(iTextFile);
				
				if( write_file(iTextFile, iBuffer) )
				{
					precache_generic(iSpriteFile);
					precache_generic(iTextFile);
					formatex(iToggleCmd, iLen, "wpn_%s_%s_%s", iWpnName, iIpAddress, iCvarText);
					
					return 1;
				}
			}
		}
		else
		{
			new iTextFile[64], iBuffer[1024];
			formatex(iTextFile, 63, "sprites/weapon_%s_numb.txt", iWpnName);
			formatex(iBuffer, 1023, iWpnBuffer, IDENTICAL_320, IDENTICAL_640);
			format(iBuffer, 1023, iBuffer, iCvarText, iCvarText);
			
			if( file_exists(iTextFile) )
				delete_file(iTextFile);
			
			if( write_file(iTextFile, iBuffer) )
			{
				precache_generic(iSpriteFile);
				precache_generic(iTextFile);
				formatex(iToggleCmd, iLen, "weapon_%s_numb", iWpnName);
				
				return 2;
			}
		}
	}
	
	return 0;
}

Menu_Open_Scope(iPlrId)
{
	new iMenuBody[512], iMenuBodyLen, iKeys;
	
	iMenuBodyLen = copy(iMenuBody, 511, "\rEgyeni sniper tavcsovek^n\yBy\w: \dNumb^n");
	if( g_iAWPFileName[0] )
	{
		iMenuBodyLen += copy(iMenuBody[iMenuBodyLen], (511-iMenuBodyLen), CheckPlayerBit(g_iCustomAwp, iPlrId)?"^n\r1\y. \wAWP\d: \yBE":"^n\r1\y. \wAWP\d: \yKI");
		iKeys |= MENU_KEY_1;
	}
	else
		iMenuBodyLen += copy(iMenuBody[iMenuBodyLen], (511-iMenuBodyLen), "^n\r1\y. \dAWP\w: \yHIBA");
	if( g_iScoutFileName[0] )
	{
		iMenuBodyLen += copy(iMenuBody[iMenuBodyLen], (511-iMenuBodyLen), CheckPlayerBit(g_iCustomScout, iPlrId)?"^n\r2\y. \wScout\d: \yBE":"^n\r2\y. \wScout\d: \yKI");
		iKeys |= MENU_KEY_2;
	}
	else
		iMenuBodyLen += copy(iMenuBody[iMenuBodyLen], (511-iMenuBodyLen), "^n\r2\y. \dScout\w: \yHIBA");
	if( g_iG3SG1FileName[0] )
	{
		iMenuBodyLen += copy(iMenuBody[iMenuBodyLen], (511-iMenuBodyLen), CheckPlayerBit(g_iCustomG3SG1, iPlrId)?"^n\r3\y. \wG3SG1\d: \yBE":"^n\r3\y. \wG3SG1\d: \yKI");
		iKeys |= MENU_KEY_3;
	}
	else
		iMenuBodyLen += copy(iMenuBody[iMenuBodyLen], (511-iMenuBodyLen), "^n\r3\y. \dG3SG1\w: \yHIBA");
	if( g_iSG550FileName[0] )
	{
		iMenuBodyLen += copy(iMenuBody[iMenuBodyLen], (511-iMenuBodyLen), CheckPlayerBit(g_iCustomSG550, iPlrId)?"^n\r4\y. \wSG550\d: \yBE":"^n\r4\y. \wSG550\d: \yKI");
		iKeys |= MENU_KEY_4;
	}
	else
		iMenuBodyLen += copy(iMenuBody[iMenuBodyLen], (511-iMenuBodyLen), "^n\r4\y. \dSG550\w: \yHIBA");
	iMenuBodyLen += formatex(iMenuBody[iMenuBodyLen], (511-iMenuBodyLen), "^n^n\r0\y. \wKilepes");
	
	show_menu(iPlrId, (iKeys|MENU_KEY_0), iMenuBody, -1, "Custom Scopes");
}

send_awp(iPlrId, bool:bReal=false, bool:bCheckActiveItem=true)
{
	if( g_iAWPFileName[0] )
	{
		message_begin(MSG_ONE, g_iMsgId_WeaponList, _, iPlrId);
		write_string((bReal?"weapon_awp":g_iAWPFileName));
		write_byte(1);
		write_byte(30);
		write_byte(-1);
		write_byte(-1);
		write_byte(0);
		write_byte(2);
		write_byte(CSW_AWP);
		write_byte(0);
		message_end();
		
		if( bReal )
			ClearPlayerBit(g_iCustomAwp, iPlrId);
		else
			SetPlayerBit(g_iCustomAwp, iPlrId);
		
		if( bCheckActiveItem )
			check_active_item(iPlrId, CSW_AWP);
	}
	else
		ClearPlayerBit(g_iCustomAwp, iPlrId);
}

send_scout(iPlrId, bool:bReal=false, bool:bCheckActiveItem=true)
{
	if( g_iScoutFileName[0] )
	{
		message_begin(MSG_ONE, g_iMsgId_WeaponList, _, iPlrId);
		write_string((bReal?"weapon_scout":g_iScoutFileName));
		write_byte(2);
		write_byte(90);
		write_byte(-1);
		write_byte(-1);
		write_byte(0);
		write_byte(9);
		write_byte(CSW_SCOUT);
		write_byte(0);
		message_end();
		
		if( bReal )
			ClearPlayerBit(g_iCustomScout, iPlrId);
		else
			SetPlayerBit(g_iCustomScout, iPlrId);
		
		if( bCheckActiveItem )
			check_active_item(iPlrId, CSW_SCOUT);
	}
	else
		ClearPlayerBit(g_iCustomScout, iPlrId);
}

send_g3sg1(iPlrId, bool:bReal=false, bool:bCheckActiveItem=true)
{
	if( g_iG3SG1FileName[0] )
	{
		message_begin(MSG_ONE, g_iMsgId_WeaponList, _, iPlrId);
		write_string((bReal?"weapon_g3sg1":g_iG3SG1FileName));
		write_byte(2);
		write_byte(90);
		write_byte(-1);
		write_byte(-1);
		write_byte(0);
		write_byte(3);
		write_byte(CSW_G3SG1);
		write_byte(0);
		message_end();
		
		if( bReal )
			ClearPlayerBit(g_iCustomG3SG1, iPlrId);
		else
			SetPlayerBit(g_iCustomG3SG1, iPlrId);
		
		if( bCheckActiveItem )
			check_active_item(iPlrId, CSW_G3SG1);
	}
	else
		ClearPlayerBit(g_iCustomG3SG1, iPlrId);
}

send_sg550(iPlrId, bool:bReal=false, bool:bCheckActiveItem=true)
{
	if( g_iSG550FileName[0] )
	{
		message_begin(MSG_ONE, g_iMsgId_WeaponList, _, iPlrId);
		write_string((bReal?"weapon_sg550":g_iSG550FileName));
		write_byte(4);
		write_byte(90);
		write_byte(-1);
		write_byte(-1);
		write_byte(0);
		write_byte(16);
		write_byte(CSW_SG550);
		write_byte(0);
		message_end();
		
		if( bReal )
			ClearPlayerBit(g_iCustomSG550, iPlrId);
		else
			SetPlayerBit(g_iCustomSG550, iPlrId);
		
		if( bCheckActiveItem )
			check_active_item(iPlrId, CSW_SG550);
	}
	else
		ClearPlayerBit(g_iCustomSG550, iPlrId);
}

check_active_item(iPlrId, iWpnType)
{
	new iEnt = get_pdata_cbase(iPlrId, m_pActiveItem, 5);
	if( iEnt>0 )
	{
		if( get_pdata_int(iEnt, m_iId, 4)==iWpnType )
		{
			emessage_begin(MSG_ONE, g_iMsgId_CurWeapon, _, iPlrId);
			ewrite_byte(1);
			ewrite_byte(iWpnType);
			ewrite_byte(get_pdata_int(iEnt, m_iClip, 4));
			emessage_end(); // emessage_begin() and emessage_end() for "sniper crosshairs" plugin support.
		}
	}
}

print_message(iPlrId) // using eng*, cause calling inside an event sometimes
	engclient_print(iPlrId, engprint_center, "^n^nIrd be ^"/tavcso^" a chatbe h valtoztasd a ^nSnipered Tavcsovet.");
