#include <amxmodx>
#include <amxmisc>
#include <engine>
#include <fakemeta>
#include <fakemeta_util>
#include <hamsandwich>
#include <cstrike>
#include <fun>
#include <orpheu>
#include <orpheu_stocks>
#include <orpheu_memory>

#define PLUGIN "Zombie Escape"
#define VERSION "1.3"
#define AUTHOR "Dias"

#define MIN_PLAYER 2
#define DEFAULT_LIGHT "d"
new USE_FOG = 1
#define FOG_DENSITY "0.0010"
#define FOG_COLOR "100 100 100"

// Human Config
#define HUMAN_HEALTH 1000.0
#define HUMAN_ARMOR 100.0
#define HUMAN_GRAVITY 1.0
#define HUMAN_SPEED 250.0

// Zombie Config
#define ZOMBIE_HEALTH 14000.0
#define ZOMBIE_ARMOR 100.0
#define ZOMBIE_GRAVITY 0.875
#define ZOMBIE_SPEED 350.0
#define ZOMBIE_KNOCKBACK_POWER 500.0

#define SKY_NAME "hk"

// primary weapons (menu|game)
new g_primaryweapons[][][] = 
{ 
	{ "M4A1",     "weapon_m4a1"    },
	{ "AK47",     "weapon_ak47"    },
	{ "AUG",      "weapon_aug"     },
	{ "SG552",    "weapon_sg552"   },
	{ "Galil",    "weapon_galil"   },
	{ "Famas",    "weapon_famas"   },
	{ "MP5 Navy", "weapon_mp5navy" },
	{ "XM1014",   "weapon_xm1014"  },
	{ "M3",       "weapon_m3"      },
	{ "P90",      "weapon_p90"     },
	{ "M249",     "weapon_m249"    },
	{ "SG550",    "weapon_sg550"   },
	{ "G3SG1",    "weapon_g3sg1"   }			
}

// secondary weapons (menu|game)
new g_secondaryweapons[][][] = 
{ 
	{ "USP",      "weapon_usp"     },
	{ "Deagle",   "weapon_deagle"  },
	{ "Elite",    "weapon_elite"   } 
}

// grenade loadout (game)
new g_grenades[][] = 
{ 
	"weapon_hegrenade",
	"weapon_smokegrenade"
}

new const Game_Desc[] = 
"Zombie Escape. Version: 1.0. Coded: Dias"

new const ready_sound[1][] = 
{
	"zombie_escape/ZE_Ready.mp3"
}

new const ambience_sound[1][] = 
{
	"zombie_escape/ZE_Ambience.mp3"
}

new const zombieappear_sound[2][] = 
{
	"zombie_escape/zombi_coming_1.wav",
	"zombie_escape/zombi_coming_2.wav"
}

new const zombieinfect_sound[2][] = 
{
	"zombie_escape/zombie/human_death_01.wav",
	"zombie_escape/zombie/human_death_02.wav"
}

new const zombiehurt_sound[2][] =
{
	"zombie_escape/zombie/zombi_hurt_01.wav",
	"zombie_escape/zombie/zombi_hurt_02.wav"
}

new const zombieattack_sound[3][] = 
{
	"zombie_escape/zombie/zombi_attack_1.wav",
	"zombie_escape/zombie/zombi_attack_2.wav",
	"zombie_escape/zombie/zombi_attack_3.wav"
}

new const zombieswing_sound[3][] = 
{
	"zombie_escape/zombie/zombi_swing_1.wav",
	"zombie_escape/zombie/zombi_swing_2.wav",
	"zombie_escape/zombie/zombi_swing_3.wav"
}

new const zombiehitwall_sound[3][] =
{
	"zombie_escape/zombie/zombi_wall_1.wav",
	"zombie_escape/zombie/zombi_wall_2.wav",
	"zombie_escape/zombie/zombi_wall_3.wav"
}

new const count_sound[] = "zombie_escape/count/%i.wav"
new const escape_suc_sound[] = "zombie_escape/zombi_escape_success.wav"
new const escape_fail_sound[] = "zombie_escape/zombi_escape_fail.wav"

new const host_zombie_model[] = "tank_zombi_host"
new const origin_zombie_model[] = "tank_zombi_origin"
new const claws_model[] = "models/zombie_escape/v_knife_tank_zombi.mdl"
new const sound_nvg[2][] = {"items/nvg_off.wav", "items/nvg_on.wav"}

new g_szObjectiveClassNames[][] =
{
        "func_bomb_target",
        "info_bomb_target",
        "info_vip_start",
        "func_vip_safetyzone",
        "func_escapezone",
        "hostage_entity",
        "monster_scientist",
        "func_hostage_rescue",
        "info_hostage_rescue",
        "item_longjump"
};


enum
{
	TASK_COUNTDOWN = 52000,
	TASK_COUNTDOWN2,
	TASK_AMBIENCE,
	TASK_ROUNDTIME
}

enum
{
	TEAM_T = 1,
	TEAM_CT = 2,
	TEAM_ALL = 5,
	TEAM_START = 6
}
enum
{
	AL_NOT = 0,
	AL_ALIVE = 1,
	AL_BOTH = 2
}
enum
{
	ZOMBIE_TYPE_HOST = 0,
	ZOMBIE_TYPE_ORIGIN
}

new g_endround, g_count, bot_register, g_gamestart, g_default_model[33][64], score_hud, Float:delay_hud[33]
new notice_hud, g_started, g_zombie[33], g_zombie_type[33], g_nvg[33], g_isalive[33], g_team_score[6]

new OrpheuHook:handleHookCheckMapConditions;
new OrpheuHook:handleHookCheckWinConditions;
new OrpheuHook:handleHookHasRoundTimeExpired;

new g_WinText[7][64], g_pGameRules
#define set_mp_pdata(%1,%2)  (OrpheuMemorySetAtAddress( g_pGameRules, %1, 1, %2 ) )
#define get_mp_pdata(%1)     (OrpheuMemoryGetAtAddress( g_pGameRules, %1 ) )

new bool:g_showmenu[33], bool:g_menufailsafe[33], g_player_weapons[33][2], g_menuposition[33]
#define TASKID_WEAPONSMENU 564
#define EQUIP_PRI (1<<0)
#define EQUIP_SEC (1<<1)
#define EQUIP_GREN (1<<2)
#define EQUIP_ALL (1<<0 | 1<<1 | 1<<2)

#define OFFSET_LASTPRIM 368
#define OFFSET_LASTSEC 369
#define OFFSET_LASTKNI 370

#define OFFSET_DEATH 444
#define OFFSET_TEAM 114
#define OFFSET_ARMOR 112
#define OFFSET_NVG 129
#define OFFSET_CSMONEY 115
#define OFFSET_PRIMARYWEAPON 116
#define OFFSET_WEAPONTYPE 43
#define OFFSET_CLIPAMMO	51
#define EXTRAOFFSET_WEAPONS 4

#define OFFSET_AMMO_338MAGNUM 377
#define OFFSET_AMMO_762NATO 378
#define OFFSET_AMMO_556NATOBOX 379
#define OFFSET_AMMO_556NATO 380
#define OFFSET_AMMO_BUCKSHOT 381
#define OFFSET_AMMO_45ACP 382
#define OFFSET_AMMO_57MM 383
#define OFFSET_AMMO_50AE 384
#define OFFSET_AMMO_357SIG 385
#define OFFSET_AMMO_9MM 386

#define fm_lastprimary(%1) get_pdata_cbase(id, OFFSET_LASTPRIM)
#define fm_lastsecondry(%1) get_pdata_cbase(id, OFFSET_LASTSEC)
#define fm_lastknife(%1) get_pdata_cbase(id, OFFSET_LASTKNI)
#define fm_get_weapon_id(%1) get_pdata_int(%1, OFFSET_WEAPONTYPE, EXTRAOFFSET_WEAPONS)

new const g_weapon_ammo[][] =
{
	{ -1, -1 },
	{ 13, 200 },
	{ -1, -1 },
	{ 10, 200 },
	{ -1, -1 },
	{ 7, 200 },
	{ -1, -1 },
	{ 30, 200 },
	{ 30, 200 },
	{ -1, -1 },
	{ 30, 200 },
	{ 20, 200 },
	{ 25, 000 },
	{ 30, 200 },
	{ 35, 200 },
	{ 25, 200 },
	{ 12, 200 },
	{ 20, 200 },
	{ 10, 200 },
	{ 30, 200 },
	{ 100, 200 },
	{ 8, 200 },
	{ 30, 200 },
	{ 30, 200 },
	{ 20, 200 },
	{ -1, -1 },
	{ 7, 200 },
	{ 30, 200 },
	{ 30, 200 },
	{ -1, -1 },
	{ 50, 200 }
}

// Plugin & Precache & Config Zone
public plugin_init()
{
	static map_name[32]
	get_mapname(map_name, sizeof(map_name))
	
	if(containi(map_name, "ze_") == -1)
	{
		set_fail_state("[ZE] Hibas Map")
		return
	}
	
	register_plugin(PLUGIN, VERSION, AUTHOR)

	format(g_WinText[TEAM_T], 63, "Escape Fail")
	format(g_WinText[TEAM_CT], 63, "Escape Success")		
	format(g_WinText[TEAM_ALL], 63, "#Round_Draw")
	format(g_WinText[TEAM_START], 63, "#Game_Commencing")	
	
	register_menu("Equipment", 1023, "action_equip")
	register_menu("Primary", 1023, "action_prim")
	register_menu("Secondary", 1023, "action_sec")
	
	// Event
	register_event("HLTV", "event_newround", "a", "1=0", "2=0")
	register_logevent("event_roundend", 2, "1=Round_End")
	register_event("TextMsg","event_roundend","a","2=#Game_Commencing","2=#Game_will_restart_in")	
	register_event("CurWeapon", "event_CurWeapon", "be", "1=1")
	
	// Message
	register_message(get_user_msgid("Health"), "message_health")
	register_message(get_user_msgid("StatusIcon"), "message_StatusIcon")
	
	// Forward & Ham
	register_forward(FM_EmitSound, "fw_EmitSound")
	register_forward(FM_GetGameDescription, "fw_GetGameDesc")
	RegisterHam(Ham_Spawn, "player", "fw_Spawn_Post", 1)
	RegisterHam(Ham_TakeDamage, "player", "fw_TakeDamage")
	RegisterHam(Ham_Killed, "player", "fw_Killed_Post", 1)
	RegisterHam(Ham_Touch, "weaponbox", "fw_TouchWeapon")
	RegisterHam(Ham_Touch, "armoury_entity", "fw_TouchWeapon")
	RegisterHam(Ham_Touch, "weapon_shield", "fw_TouchWeapon")	
	
	PatchRoundInfinity()
	
	set_cvar_string("sv_skyname", SKY_NAME)
	
	notice_hud = CreateHudSyncObj(1)
	score_hud = CreateHudSyncObj(2)
	
	register_clcmd("nightvision", "cmd_nightvision")
	
	register_clcmd("jointeam", "cmd_jointeam")
	register_clcmd("chooseteam", "cmd_jointeam")		
}

public plugin_cfg()
{
	static map_name[32]
	get_mapname(map_name, sizeof(map_name))
	
	if(containi(map_name, "ze_") == -1)
		return
	
	server_cmd("mp_freezetime 22.0")
	server_cmd("mp_roundtime 9.0")
	server_cmd("mp_friendlyfire 0")
	server_cmd("mp_startmoney 16000")
}

public plugin_precache()
{
	static map_name[32]
	get_mapname(map_name, sizeof(map_name))	
	
	if(containi(map_name, "ze_") == -1)
		return
	
	OrpheuRegisterHook(OrpheuGetFunction("InstallGameRules"),"OnInstallGameRules",OrpheuHookPost)
	
	new i, buffer[128]
	for(i = 0; i < sizeof(ready_sound); i++)
	{
		if(equal(ready_sound[i][strlen(ready_sound[i]) - 4], ".mp3"))
		{
			format(buffer, charsmax(buffer), "sound/%s", ready_sound[i])
			precache_generic(buffer)
		} else {
			precache_sound(ready_sound[i])
		}
	}
	for(i = 0; i < sizeof(ambience_sound); i++)
	{
		if(equal(ambience_sound[i][strlen(ambience_sound[i]) - 4], ".mp3"))
		{
			format(buffer, charsmax(buffer), "sound/%s", ambience_sound[i])
			precache_generic(buffer)
		} else {
			precache_sound(ambience_sound[i])
		}
	}
	for(i = 0; i < sizeof(zombieappear_sound); i++)
		precache_sound(zombieappear_sound[i])
	for(i = 0; i < sizeof(zombieinfect_sound); i++)
		precache_sound(zombieinfect_sound[i])
	for(i = 0; i < sizeof(zombiehurt_sound); i++)
		precache_sound(zombiehurt_sound[i])
	for(i = 0; i < sizeof(zombieattack_sound); i++)
		precache_sound(zombieattack_sound[i])
	for(i = 0; i < sizeof(zombieswing_sound); i++)
		precache_sound(zombieswing_sound[i])
	for(i = 0; i < sizeof(zombiehitwall_sound); i++)
		precache_sound(zombiehitwall_sound[i])
	for (i = 1; i <= 10; i++)
	{
		new sound_count[64]
		format(sound_count, sizeof sound_count - 1, count_sound, i)
		
		precache_sound(sound_count)
	}	
	
	formatex(buffer, sizeof(buffer), "gfx/env/%sbk.tga", SKY_NAME)
	precache_generic(buffer)
	formatex(buffer, sizeof(buffer), "gfx/env/%sdn.tga", SKY_NAME)
	precache_generic(buffer)
	formatex(buffer, sizeof(buffer), "gfx/env/%sft.tga", SKY_NAME)
	precache_generic(buffer)
	formatex(buffer, sizeof(buffer), "gfx/env/%slf.tga", SKY_NAME)
	precache_generic(buffer)
	formatex(buffer, sizeof(buffer), "gfx/env/%srt.tga", SKY_NAME)
	precache_generic(buffer)
	formatex(buffer, sizeof(buffer), "gfx/env/%sup.tga", SKY_NAME)
	precache_generic(buffer)	
	
	precache_sound(escape_suc_sound)
	precache_sound(escape_fail_sound)
	
	formatex(buffer, sizeof(buffer), "models/player/%s/%s.mdl", host_zombie_model, host_zombie_model)
	precache_model(buffer)
	formatex(buffer, sizeof(buffer), "models/player/%s/%s.mdl", origin_zombie_model, origin_zombie_model)
	precache_model(buffer)	
	
	engfunc(EngFunc_PrecacheModel, claws_model)
	
	if(USE_FOG == 1)
	{
		static ent
		ent = engfunc(EngFunc_CreateNamedEntity, engfunc(EngFunc_AllocString, "env_fog"))
		if (pev_valid(ent))
		{
			fm_set_kvd(ent, "density", FOG_DENSITY, "env_fog")
			fm_set_kvd(ent, "rendercolor", FOG_COLOR, "env_fog")
		}
	}
	
	register_forward(FM_Spawn, "fw_Spawn")	
	
}

public plugin_end()
{
	UnPatchRoundInfinity()
}

public fw_Spawn(iEnt)
{
	if (!pev_valid(iEnt))
		return FMRES_IGNORED;
	
	static s_szClassName[32], s_iNum;
	pev(iEnt, pev_classname, s_szClassName, 31);
	
	for (s_iNum = 0; s_iNum < sizeof g_szObjectiveClassNames; s_iNum++)
	{
		if (equal(s_szClassName, g_szObjectiveClassNames[s_iNum]))
		{
			engfunc(EngFunc_RemoveEntity, iEnt);
			return FMRES_SUPERCEDE;
		}
	}
	
	return FMRES_IGNORED;
}

public client_putinserver(id)
{
	if(!bot_register && is_user_bot(id))
	{
		bot_register = 1
		set_task(1.0, "do_register", id)
	}
	
	g_showmenu[id] = true
	g_isalive[id] = 0
}

public client_disconnect(id)
{
	g_isalive[id] = 0
	check_win_con()
}

public do_register(id)
{
	RegisterHamFromEntity(Ham_Spawn, id, "fw_Spawn_Post", 1)
	RegisterHamFromEntity(Ham_TakeDamage, id, "fw_TakeDamage")	
	RegisterHamFromEntity(Ham_Killed, id, "fw_Killed_Post", 1)
}

public PatchRoundInfinity()
{
	handleHookCheckMapConditions = OrpheuRegisterHook( OrpheuGetFunction( "CheckMapConditions" , "CHalfLifeMultiplay" ), "CheckConditions" );
	handleHookCheckWinConditions = OrpheuRegisterHook( OrpheuGetFunction( "CheckWinConditions" , "CHalfLifeMultiplay" ), "CheckConditions" );
	
	if (is_linux_server())
	{
		handleHookHasRoundTimeExpired = OrpheuRegisterHook( OrpheuGetFunction( "HasRoundTimeExpired" , "CHalfLifeMultiplay" ), "CheckConditions" );
	}
	else
	{
		BytesToReplace("roundTimeCheck", { 0x90, 0x90, 0x90 } );
	}
}

public UnPatchRoundInfinity()
{
	OrpheuUnregisterHook( handleHookCheckMapConditions );
	OrpheuUnregisterHook( handleHookCheckWinConditions );
	
	if (is_linux_server())
	{
		OrpheuUnregisterHook( handleHookHasRoundTimeExpired );
	}
	else
	{
		BytesToReplace("roundTimeCheck", { 0xF6, 0xC4, 0x41 } );
	}
}

public OrpheuHookReturn:CheckConditions ()
{
	OrpheuSetReturn( false );
	return OrpheuSupercede;
}

public OnInstallGameRules()
{
	g_pGameRules = OrpheuGetReturn() 
}

// End of Plugin & Precache & Config Zone

// Event: New Round
public event_newround()
{
	// Reset Vars
	g_endround = 0
	g_gamestart = 0
	g_count = 20
	
	// Remove Task
	remove_task(TASK_COUNTDOWN)
	remove_task(TASK_COUNTDOWN2)
	remove_task(TASK_AMBIENCE)
	remove_task(TASK_ROUNDTIME)

	if(get_player_num(TEAM_ALL, AL_ALIVE) < MIN_PLAYER)
	{
		client_printc(0, "!g[Zombie Escape]!n Nincs eleg jatekos a modhoz! Jatekosok : !t%i!n", MIN_PLAYER)
		g_started = 0
		
		return
	}
	
	client_printc(0, "!g[Zombie Escape]!n Keszen allsz? Sok szerencset!")
	PlaySound(0, ready_sound[random_num(0, charsmax(ready_sound))])	
	
	set_task(1.0, "do_countdown", TASK_COUNTDOWN, _, _, "b")
	set_task(get_cvar_float("mp_roundtime") * 60.0 + 43.0, "do_zombie_win", TASK_ROUNDTIME)
}

public do_countdown(taskid)
{
	if(g_endround)
	{
		remove_task(taskid)
		return
	}
	
	if (!g_count)
	{
		start_game_now()
		remove_task(taskid)
		return
	}
	
	if (g_count <= 10)
	{
		new sound[64]
		format(sound, charsmax(sound), count_sound, g_count)
		PlaySound(0, sound)
	}
	
	new message[64]
	format(message, charsmax(message), "Kszen allsz? Megnyitas %i masodperc mulva!", g_count)
	
	client_print(0, print_center, message)
	//set_hudmessage(255, 255, 0, -1.0, 0.21, 1, 2.0, 2.0)
	//ShowSyncHudMsg(0, notice_hud, message)
	
	g_count--
}
// End of Event: New Round

// Event: Round End
public event_roundend()
{
	g_endround = 1
	
	remove_task(TASK_COUNTDOWN)
	remove_task(TASK_COUNTDOWN2)
	remove_task(TASK_AMBIENCE)
}

// End of Event: Round End

public cmd_jointeam(id)
{	
	if(!is_user_connected(id))
		return 1
		
	if(cs_get_user_team(id) == CS_TEAM_CT || cs_get_user_team(id) == CS_TEAM_T)
	{
		open_game_menu(id)
		return 1
	}
	
	return PLUGIN_CONTINUE
}

public open_game_menu(id)
{
	static menu
	menu = menu_create("Game Menu", "gamem_handle")
	
	menu_additem(menu, "Equipment", "1", 0)
	menu_additem(menu, "Game Information", "2", 0)

	menu_setprop(menu, MPROP_EXIT, MEXIT_ALL)

	menu_display(id, menu, 0)
}

public gamem_handle(id, menu, item)
{
	if(item == MENU_EXIT)
	{
		menu_destroy(menu)
		return PLUGIN_HANDLED;
	}

	new data[6], szName[64];
	new access, callback;

	menu_item_getinfo(menu, item, access, data,charsmax(data), szName,charsmax(szName), callback);

	new key = str_to_num(data);

	switch(key)
	{
		case 1: // Equipment
		{
			g_showmenu[id] = true
			client_printc(id, "!g[Zombie Escape]!n Engedelyezve van az Equipment menu!")
		}
		case 2: // Game Info
		{
			show_motd(id, Game_Desc, "Jatek informacio")
		}
	}
	
	return 0
}

// NightVision
public cmd_nightvision(id)
{
	if (!is_user_alive(id) || !g_zombie[id]) return PLUGIN_HANDLED;

	if (!g_nvg[id])
	{
		SwitchNvg(id, 1)
		PlaySound(id, sound_nvg[1])
	}
	else
	{
		SwitchNvg(id, 0)
		PlaySound(id, sound_nvg[0])
	}	
	
	return PLUGIN_CONTINUE
}

stock SwitchNvg(id, mode)
{
	if (!is_user_connected(id)) return;
	
	g_nvg[id] = mode
	set_user_nvision(id)
}

stock set_user_nvision(id)
{	
	if (!is_user_connected(id)) return;

	new alpha
	if (g_nvg[id]) alpha = 70
	else alpha = 0
	
	message_begin(MSG_ONE_UNRELIABLE, get_user_msgid("ScreenFade"), _, id)
	write_short(0) // duration
	write_short(0) // hold time
	write_short(0x0004) // fade type
	write_byte(253) // r
	write_byte(110) // g
	write_byte(110) // b
	write_byte(alpha) // alpha
	message_end()
	
	if(g_nvg[id])
	{
		set_player_light(id, "z")
	} else {
		set_player_light(id, DEFAULT_LIGHT)
	}
}

stock set_player_light(id, const LightStyle[])
{
	message_begin(MSG_ONE, SVC_LIGHTSTYLE, .player = id)
	write_byte(0)
	write_string(LightStyle)
	message_end()
}
// End of NightVision

// Start Game
public start_game_now()
{
	g_gamestart = 1
	
	PlaySound(0, ambience_sound[random_num(0, charsmax(ambience_sound))])	
	set_task(105.0, "check_ambience_sound", TASK_AMBIENCE, _, _, "b")
	
	// Make Zombies
	for(new i = 0; i < require_zombie(); i++)
	{
		set_user_zombie(get_random_player(TEAM_CT, AL_ALIVE), ZOMBIE_TYPE_ORIGIN)
	}
	
	g_count = 7
	set_task(1.0, "do_count_rezombie", TASK_COUNTDOWN2, _, _, "b")
	
	for(new i = 0; i < get_maxplayers(); i++)
	{
		if(is_user_connected(i) && is_user_alive(i) && !g_zombie[i])
		{
			set_user_maxspeed(i, HUMAN_SPEED)
			set_user_gravity(i, HUMAN_GRAVITY)
		}
	}
}

public check_ambience_sound(taskid)
{
	if(g_endround)
	{
		remove_task(taskid)
		return
	}
	
	PlaySound(0, ambience_sound[random_num(0, charsmax(ambience_sound))])	
}

public do_count_rezombie(taskid)
{
	if(g_endround)
	{
		remove_task(taskid)
		return
	}
	
	if (!g_count)
	{
		release_zombie()
		remove_task(taskid)
		return
	}

	set_hudmessage(255, 255, 0, -1.0, 0.21, 1, 2.0, 2.0)
	ShowSyncHudMsg(0, notice_hud, "Zombik ki szabadulnak %i masodperc mulva!", g_count)

	g_count--
}
// End of Start Game

// Game Main
public release_zombie()
{
	g_gamestart = 2
	
	for(new i = 0; i < get_maxplayers(); i++)
	{
		if(!is_user_connected(i) || !is_user_alive(i))
			continue
		if(!g_zombie[i])
			continue
			
		set_user_maxspeed(i, ZOMBIE_SPEED)
		set_user_gravity(i, ZOMBIE_GRAVITY)		
	}
}

public client_PostThink(id)
{
	if(!is_user_alive(id))
		return
	if(get_gametime() - 1.0 > delay_hud[id])
	{
		set_hudmessage(255, 255, 255, -1.0, 0.0, 0, 2.0, 2.0)
		ShowSyncHudMsg(id, score_hud, "Zombik vs Emberek^n %i --------- %i", g_team_score[TEAM_T], g_team_score[TEAM_CT])
		
		delay_hud[id] = get_gametime()
	}
	
	if(!g_gamestart)
	{
		if(!is_user_connected(id) || !is_user_alive(id))
			return
			
		if(cs_get_user_team(id) != CS_TEAM_CT) cs_set_user_team(id, CS_TEAM_T)
	}
	if(g_gamestart != 1)
		return	
	if(!g_zombie[id])
		return
		
	if(get_user_maxspeed(id) != 0.1) set_user_maxspeed(id, 0.1)
}

public set_user_zombie(id, zombie_type)
{
	cs_set_user_team(id, TEAM_T)
	
	g_zombie[id] = 1
	g_zombie_type[id] = zombie_type
	
	set_user_health(id, zombie_type == 0 ? floatround(ZOMBIE_HEALTH / 2.0) : floatround(ZOMBIE_HEALTH))
	set_user_armor(id, floatround(ZOMBIE_ARMOR))
	
	if(zombie_type == ZOMBIE_TYPE_HOST)
	{
		set_user_maxspeed(id, ZOMBIE_SPEED)
		set_user_gravity(id, ZOMBIE_GRAVITY)
	} else {
		set_user_maxspeed(id, 0.1)
		set_user_gravity(id, ZOMBIE_GRAVITY)		
	}
	
	cs_get_user_model(id, g_default_model[id], 63)
	cs_set_user_model(id, zombie_type == 0 ? host_zombie_model : origin_zombie_model)
	set_default_zombie(id, zombie_type)
	
	emit_sound(id, CHAN_BODY, zombieinfect_sound[random_num(0, charsmax(zombieinfect_sound))], 1.0, ATTN_NORM, 0, PITCH_NORM)
	PlaySound(0, zombieappear_sound[random_num(0, charsmax(zombieappear_sound))])
	
	SwitchNvg(id, 1)
	PlaySound(id, sound_nvg[1])	

	check_win_con()
}

stock set_default_zombie(id, zombie_type)
{
	if(!is_user_alive(id))
		return
	if(!g_zombie[id])
		return
		
	if(zombie_type == ZOMBIE_TYPE_ORIGIN)
	{
		new player = -1, entity_num, entity_list[40]
		if(cs_get_user_team(id) == CS_TEAM_T)
		{
			while((player = find_ent_by_class(player, "info_player_deathmatch")))
			{
				entity_list[entity_num] = player
				entity_num++
			}		
		} else if(cs_get_user_team(id) == CS_TEAM_CT) {
			while((player = find_ent_by_class(player, "info_player_start")))
			{
				entity_list[entity_num] = player
				entity_num++
			}	
		}
		
		new random_player1
		random_player1 = entity_list[random(entity_num)]
	
		if(random_player1 != 0)
		{
			new Float:Origin[3]
			pev(random_player1, pev_origin, Origin)
			
			if(check_spawn(Origin))
			{
				set_pev(id, pev_origin, Origin)
			} else {
				set_default_zombie(id, zombie_type)	
			}
		} else {
			set_default_zombie(id, zombie_type)
		}
	}
	
	// Remove any zoom (bugfix)
	cs_set_user_zoom(id, CS_RESET_ZOOM, 1)
	
	// Remove armor
	cs_set_user_armor(id, 0, CS_ARMOR_NONE)
	
	// Drop weapons when infected
	drop_weapons(id, 1)
	drop_weapons(id, 2)
	
	// Strip zombies from guns and give them a knife
	fm_strip_user_weapons(id)
	fm_give_item(id, "weapon_knife")
}

public event_CurWeapon(id)
{
	if(!is_user_alive(id))
		return 1
	if(!g_zombie[id])
		return 1
	if(get_user_weapon(id) != CSW_KNIFE)
	{
		drop_weapons(id, 1)
		drop_weapons(id, 2)
		
		engclient_cmd(id, "weapon_knife")
	} else {
		set_pev(id, pev_viewmodel2, claws_model)
		set_pev(id, pev_weaponmodel2, "")
	}
		
	return 0
}

public test(id)
{
}

// End of Game Main

public check_win_con()
{
	if(g_endround)
		return
	if(!g_gamestart)
		return
	
	if(get_player_num(TEAM_T, AL_ALIVE) == 0)
	{
		TerminateRound(TEAM_CT)
	} else if(get_player_num(TEAM_CT, AL_ALIVE) == 0) {
		TerminateRound(TEAM_T)
	}
}

public do_zombie_win()
{
	TerminateRound(TEAM_T)
}

// Message
public message_StatusIcon(msg_id, msg_dest, msg_entity)
{
	static szMsg[8];
	get_msg_arg_string(2, szMsg ,7);
	
	if(equal(szMsg, "buyzone") && get_msg_arg_int(1))
	{
		set_pdata_int(msg_entity, 235, get_pdata_int(msg_entity, 235) & ~(1<<0));
		return PLUGIN_HANDLED;
	}
	
	return PLUGIN_CONTINUE;
}

public message_health(msg_id, msg_dest, msg_entity)
{
	static health
	health = get_msg_arg_int(1)
	
	if(health > 255)	
		set_msg_arg_int(1, get_msg_argtype(1), 255)
}
// End of Message

// Ham
public fw_EmitSound(id, channel, const sample[], Float:volume, Float:attn, flags, pitch)
{
	// Block all those unneeeded hostage sounds
	if (sample[0] == 'h' && sample[1] == 'o' && sample[2] == 's' && sample[3] == 't' && sample[4] == 'a' && sample[5] == 'g' && sample[6] == 'e')
		return FMRES_SUPERCEDE;
	
	// Replace these next sounds for zombies only
	if (!is_user_connected(id) || !g_zombie[id])
		return FMRES_IGNORED;
	
	// Zombie being hit
	if (sample[7] == 'b' && sample[8] == 'h' && sample[9] == 'i' && sample[10] == 't' ||
	sample[7] == 'h' && sample[8] == 'e' && sample[9] == 'a' && sample[10] == 'd')
	{
		emit_sound(id, channel, zombiehurt_sound[random_num(0, charsmax(zombiehurt_sound))], volume, attn, flags, pitch)
		return FMRES_SUPERCEDE;
	}
	
	// Zombie Attack
	new attack_type
	if (equal(sample,"weapons/knife_hitwall1.wav")) attack_type = 1
	else if (equal(sample,"weapons/knife_hit1.wav") ||
	equal(sample,"weapons/knife_hit3.wav") ||
	equal(sample,"weapons/knife_hit2.wav") ||
	equal(sample,"weapons/knife_hit4.wav") ||
	equal(sample,"weapons/knife_stab.wav")) attack_type = 2
	else if(equal(sample,"weapons/knife_slash1.wav") ||
	equal(sample,"weapons/knife_slash2.wav")) attack_type = 3
	if (attack_type)
	{
		if (attack_type == 1) emit_sound(id, channel, zombiehitwall_sound[random_num(0, charsmax(zombiehitwall_sound))], volume, attn, flags, pitch)
		else if (attack_type == 2) emit_sound(id, channel, zombieattack_sound[random_num(0, charsmax(zombieattack_sound))], volume, attn, flags, pitch)
		else if (attack_type == 3) emit_sound(id, channel, zombieswing_sound[random_num(0, charsmax(zombieswing_sound))], volume, attn, flags, pitch)
		
		return FMRES_SUPERCEDE;
	}
	
	return FMRES_IGNORED;
}

public fw_GetGameDesc()
{
	forward_return(FMV_STRING, "Zombie Escape")
	return FMRES_SUPERCEDE
}

public fw_Spawn_Post(id)
{
	if (get_player_num(TEAM_ALL, AL_ALIVE) > 1 && !g_started)
	{
		g_started = 1
		TerminateRound(TEAM_START)
	}		
	if(!is_user_connected(id))
		return HAM_IGNORED
	if(g_gamestart)
		return HAM_IGNORED
		
	cs_set_user_team(id, TEAM_CT)
	cs_set_user_money(id, 16000, 1)
		
	g_isalive[id] = 1
	g_zombie[id] = 0
	g_zombie_type[id] = 0
	g_nvg[id] = 0
	g_menufailsafe[id] = false
	if(TASKID_WEAPONSMENU + id) remove_task(TASKID_WEAPONSMENU + id)
	
	set_user_nvision(id)
	
	set_human_stuff(id)
	
	if(g_showmenu[id])
		display_equipmenu(id)
	else
	{
		equipweapon(id, EQUIP_ALL)
	}
		
	return HAM_HANDLED
}

public display_equipmenu(id)
{
	static menubody[512], len
  	len = formatex(menubody, 511, "\yFegyver Menu^n^n")
	
	static bool:hasweap
	hasweap = ((g_player_weapons[id][0]) != -1 && (g_player_weapons[id][1] != -1)) ? true : false
	
	len += formatex(menubody[len], 511 - len,"\w1. Uj fegyver^n")
	len += formatex(menubody[len], 511 - len,"\w2. Elozo fegyver^n^n")
	len += formatex(menubody[len], 511 - len,"\w3. Pre-Weapon & Don't Show^n^n")
	len += formatex(menubody[len], 511 - len,"\w5. Kilepes^n", id, "MENU_EXIT")
	
	static keys
	keys = (MENU_KEY_1|MENU_KEY_5)
	
	if(hasweap) 
		keys |= (MENU_KEY_2|MENU_KEY_3)
	
	show_menu(id, keys, menubody, -1, "Equipment")
}

public action_equip(id, key)
{
	if(!is_user_alive(id) || g_zombie[id])
		return PLUGIN_HANDLED
	
	switch(key)
	{
		case 0: display_weaponmenu(id, 1, g_menuposition[id] = 0)
		case 1: equipweapon(id, EQUIP_ALL)
		case 2:
		{
			g_showmenu[id] = false
			equipweapon(id, EQUIP_ALL)
			client_printc(id, "!g[Zombie Escape]!n Nyomd meg az M betut a jatekmenujehez!")
		}
	}
	
	if(key > 0)
	{
		g_menufailsafe[id] = false
		remove_task(TASKID_WEAPONSMENU + id)
	}
	return PLUGIN_HANDLED
}


public display_weaponmenu(id, menuid, pos)
{
	if(pos < 0 || menuid < 0)
		return
	
	static start
	start = pos * 8
	
	static maxitem
	maxitem = menuid == 1 ? sizeof g_primaryweapons : sizeof g_secondaryweapons

  	if(start >= maxitem)
    		start = pos = g_menuposition[id]
	
	static menubody[512], len
  	len = formatex(menubody, 511, "\y%s\w^n^n", menuid == 1 ? "Primary" : "Secondary")

	static end
	end = start + 8
	if(end > maxitem)
    		end = maxitem
	
	static keys
	keys = MENU_KEY_0
	
	static a, b
	b = 0
	
  	for(a = start; a < end; ++a) 
	{
		keys |= (1<<b)
		len += formatex(menubody[len], 511 - len,"%d. %s^n", ++b, menuid == 1 ? g_primaryweapons[a][0]: g_secondaryweapons[a][0])
  	}

  	if(end != maxitem)
	{
    		formatex(menubody[len], 511 - len, "^n9. %s^n0. %s", "More", pos ? "Back" : "Exit")
    		keys |= MENU_KEY_9
  	}
  	else	
		formatex(menubody[len], 511 - len, "^n0. %s", pos ? "Back" : "Exit")
	
  	show_menu(id, keys, menubody, -1, menuid == 1 ? "Primary" : "Secondary")
}

public action_prim(id, key)
{
	if(!is_user_alive(id) || g_zombie[id])
		return PLUGIN_HANDLED

	switch(key)
	{
    		case 8: display_weaponmenu(id, 1, ++g_menuposition[id])
		case 9: display_weaponmenu(id, 1, --g_menuposition[id])
    		default:
		{
			g_player_weapons[id][0] = g_menuposition[id] * 8 + key
			equipweapon(id, EQUIP_PRI)
			
			display_weaponmenu(id, 2, g_menuposition[id] = 0)
		}
	}
	return PLUGIN_HANDLED
}

public action_sec(id, key)
{
	if(!is_user_alive(id) || g_zombie[id])
		return PLUGIN_HANDLED
	
	switch(key) 
	{
    		case 8: display_weaponmenu(id, 2, ++g_menuposition[id])
		case 9: display_weaponmenu(id, 2, --g_menuposition[id])
    		default:
		{
			g_menufailsafe[id] = false
			remove_task(TASKID_WEAPONSMENU + id)
			
			g_player_weapons[id][1] = g_menuposition[id] * 8 + key
			equipweapon(id, EQUIP_SEC)
			equipweapon(id, EQUIP_GREN)
		}
	}
	return PLUGIN_HANDLED
}


public set_human_stuff(id)
{
	g_zombie[id] = 0
	g_zombie_type[id] = 0
	
	set_user_health(id, floatround(HUMAN_HEALTH))
	set_user_armor(id, floatround(HUMAN_ARMOR))
	
	if(equal(g_default_model[id], "NonModel")) // Don't Have Model
	{
		cs_get_user_model(id, g_default_model[id], 63)
	} else {
		cs_set_user_model(id, g_default_model[id])
	}
}

public fw_TakeDamage(victim, inflictor, attacker, Float:damage, damagebits)
{
	if(g_gamestart < 2)
		return HAM_SUPERCEDE
	if(!is_user_connected(victim) || !is_user_connected(attacker))
		return HAM_IGNORED
	if(cs_get_user_team(attacker) == cs_get_user_team(victim))
		return HAM_SUPERCEDE
	if(g_zombie[attacker] && get_user_weapon(attacker) == CSW_KNIFE)
	{
		SendDeathMsg(attacker, victim)
		FixDeadAttrib(victim)	
		
		update_frags(attacker, 1)
		update_deaths(victim, 1)
		
		set_user_zombie(victim, ZOMBIE_TYPE_HOST)
	} else if(g_zombie[victim] && !g_zombie[attacker]) {
		set_pdata_float(victim, 108, 1.0, 50)
		
		static Float:MyOrigin[3]
		pev(attacker, pev_origin, MyOrigin)
		
		hook_ent2(victim, MyOrigin, ZOMBIE_KNOCKBACK_POWER, 2)
	}
		
	return HAM_HANDLED
}

public update_frags(id, frag)
{
	if(!is_user_connected(id))
		return
	
	set_pev(id, pev_frags, float(pev(id, pev_frags) + frag))
	
	message_begin(MSG_BROADCAST, get_user_msgid("ScoreInfo"))
	write_byte(id) // id
	write_short(pev(id, pev_frags)) // frags
	write_short(cs_get_user_deaths(id)) // deaths
	write_short(0) // class?
	write_short(get_pdata_int(id, 114, 5)) // team
	message_end()
}

public update_deaths(id, death)
{
	if(!is_user_connected(id))
		return
		
	cs_set_user_deaths(id, cs_get_user_deaths(id) + death)
	
	message_begin(MSG_BROADCAST, get_user_msgid("ScoreInfo"))
	write_byte(id) // id
	write_short(pev(id, pev_frags)) // frags
	write_short(cs_get_user_deaths(id)) // deaths
	write_short(0) // class?
	write_short(get_pdata_int(id, 114, 5)) // team
	message_end()		
}

public fw_Killed_Post(id)
{
	g_isalive[id] = 0
	check_win_con()
}

public fw_TouchWeapon(weapon, id)
{
	// Not a player
	if (!is_user_connected(id))
		return HAM_IGNORED
	if (g_zombie[id])
		return HAM_SUPERCEDE
	
	return HAM_IGNORED
}
// End of Ham

// ============================ STOCK =================================
stock get_player_num(team, alive)
{
	static player_num
	player_num = 0
	
	for(new i = 0; i < get_maxplayers(); i++)
	{
		if(!is_user_connected(i))
			continue
		if(alive == AL_NOT)
		{
			if(is_user_alive(i))
				continue
		} else if(alive == AL_ALIVE) {
			if(!is_user_alive(i))
				continue	
		}
		
		if(team == TEAM_ALL)
		{
			if(cs_get_user_team(i) == CS_TEAM_UNASSIGNED || cs_get_user_team(i) == CS_TEAM_SPECTATOR)
				continue
		} else if(team == TEAM_T) {
			if(cs_get_user_team(i) != CS_TEAM_T)
				continue
		} else if(team == TEAM_CT) {
			if(cs_get_user_team(i) != CS_TEAM_CT)
				continue
		}
		
		player_num++
	}
	
	return player_num
}

stock get_random_player(team, alive)
{
	static list_player[33], list_player_num
	static total_player
	total_player = get_player_num(team, alive)
	
	for(new i = 0; i < total_player; i++)
		list_player[i] = 0
		
	list_player_num = 0
	
	for(new i = 0; i < get_maxplayers(); i++)
	{
		if(!is_user_connected(i))
			continue
			
		if(alive == AL_NOT)
		{
			if(is_user_alive(i))
				continue
		} else if(alive == AL_ALIVE) {
			if(!is_user_alive(i))
				continue	
		}
		
		if(team == TEAM_ALL)
		{
			if(cs_get_user_team(i) == CS_TEAM_UNASSIGNED || cs_get_user_team(i) == CS_TEAM_SPECTATOR)
				continue
		} else if(team == TEAM_T) {
			if(cs_get_user_team(i) != CS_TEAM_T)
				continue
		} else if(team == TEAM_CT) {
			if(cs_get_user_team(i) != CS_TEAM_CT)
				continue
		}
		
		list_player[list_player_num] = i
		list_player_num++
	}
	
	static random_player; random_player = 0
	random_player = list_player[random_num(0, list_player_num - 1)]
	
	return random_player
}

stock PlaySound(id, const sound[])
{
	if(id == 0)
	{
		if (equal(sound[strlen(sound)-4], ".mp3"))
			client_cmd(0, "mp3 play ^"sound/%s^"", sound)
		else
			client_cmd(0, "spk ^"%s^"", sound)
	} else {
		if(is_user_connected(id)&& g_isalive[id])
		{
			if (equal(sound[strlen(sound)-4], ".mp3"))
				client_cmd(id, "mp3 play ^"sound/%s^"", sound)
			else
				client_cmd(id, "spk ^"%s^"", sound)			
		}
	}
}

stock client_printc(index, const text[], any:...)
{
	new szMsg[128];
	vformat(szMsg, sizeof(szMsg) - 1, text, 3);

	replace_all(szMsg, sizeof(szMsg) - 1, "!g", "^x04");
	replace_all(szMsg, sizeof(szMsg) - 1, "!n", "^x01");
	replace_all(szMsg, sizeof(szMsg) - 1, "!t", "^x03");

	if(index == 0)
	{
		for(new i = 0; i < get_maxplayers(); i++)
		{
			if(g_isalive[i] && is_user_connected(i))
			{
				message_begin(MSG_ONE_UNRELIABLE, get_user_msgid("SayText"), _, i);
				write_byte(i);
				write_string(szMsg);
				message_end();	
			}
		}		
	} else {
		message_begin(MSG_ONE_UNRELIABLE, get_user_msgid("SayText"), _, index);
		write_byte(index);
		write_string(szMsg);
		message_end();
	}
} 

stock require_zombie()
{
	switch(get_player_num(TEAM_CT, 1))
	{
		case 2..5: return 1
		case 6..15: return 2
		case 16..25: return 3
		case 26..32: return 4
	}
	
	return 0
}

stock check_spawn(Float:Origin[3])
{
	new Float:originE[3], Float:origin1[3], Float:origin2[3]
	new ent = -1
	while ((ent = engfunc(EngFunc_FindEntityByString, ent, "classname", "player")) != 0)
	{
		pev(ent, pev_origin, originE)
		
		// xoy
		origin1 = Origin
		origin2 = originE
		origin1[2] = origin2[2] = 0.0
		if (vector_distance(origin1, origin2) <= 2 * 16.0)
		{
			// oz
			origin1 = Origin
			origin2 = originE
			origin1[0] = origin2[0] = origin1[1] = origin2[1] = 0.0
			if (vector_distance(origin1, origin2) <= 72.0) return 0;
		}
	}
	
	return 1
}

// Drop primary/secondary weapons
stock drop_weapons(id, dropwhat)
{
	// Get user weapons
	static weapons[32], num, i, weaponid
	num = 0 // reset passed weapons count (bugfix)
	get_user_weapons(id, weapons, num)
	
	// Weapon bitsums
	const PRIMARY_WEAPONS_BIT_SUM = (1<<CSW_SCOUT)|(1<<CSW_XM1014)|(1<<CSW_MAC10)|(1<<CSW_AUG)|(1<<CSW_UMP45)|(1<<CSW_SG550)|(1<<CSW_GALIL)|(1<<CSW_FAMAS)|(1<<CSW_AWP)|(1<<CSW_MP5NAVY)|(1<<CSW_M249)|(1<<CSW_M3)|(1<<CSW_M4A1)|(1<<CSW_TMP)|(1<<CSW_G3SG1)|(1<<CSW_SG552)|(1<<CSW_AK47)|(1<<CSW_P90)
	const SECONDARY_WEAPONS_BIT_SUM = (1<<CSW_P228)|(1<<CSW_ELITE)|(1<<CSW_FIVESEVEN)|(1<<CSW_USP)|(1<<CSW_GLOCK18)|(1<<CSW_DEAGLE)	
	
	// Loop through them and drop primaries or secondaries
	for (i = 0; i < num; i++)
	{
		// Prevent re-indexing the array
		weaponid = weapons[i]
		
		if ((dropwhat == 1 && ((1<<weaponid) & PRIMARY_WEAPONS_BIT_SUM)) || (dropwhat == 2 && ((1<<weaponid) & SECONDARY_WEAPONS_BIT_SUM)))
		{
			// Get weapon entity
			static wname[32], weapon_ent
			get_weaponname(weaponid, wname, charsmax(wname))
			weapon_ent = fm_find_ent_by_owner(-1, wname, id)
			
			// Hack: store weapon bpammo on PEV_ADDITIONAL_AMMO
			set_pev(weapon_ent, pev_iuser1, cs_get_user_bpammo(id, weaponid))
			
			// Player drops the weapon and looses his bpammo
			engclient_cmd(id, "drop", wname)
			cs_set_user_bpammo(id, weaponid, 0)
		}
	}
}

stock BytesToReplace ( identifier[], const bytes[], const bytesLength = sizeof bytes )
{
	new address;
	OrpheuMemoryGet( identifier, address );
	
	for ( new i; i < bytesLength; i++)
	{
		OrpheuMemorySetAtAddress( address, "roundTimeCheck|dummy", 1, bytes[ i ], address );
		address++;
	}

	server_cmd( "sv_restart 1" );
}

stock bool:TerminateRound(team)
{
	new winStatus;
	new event;
	new sound[64];
	
	switch(team)
	{
		case TEAM_T:
		{
			winStatus         = 2;
			event             = 9;
			sound             = escape_fail_sound
			g_team_score[TEAM_T]++
		
			client_print(0, print_center, "Sikertelen menekules")
		}
		case TEAM_CT:
		{
			winStatus         = 1;
			event             = 8;
			sound             = escape_suc_sound
			g_team_score[TEAM_CT]++
			
			client_print(0, print_center, "Sikeres menekules")
		}
		case TEAM_ALL:
		{
			winStatus         = 3;
			event             = 10;
			sound             = "radio/rounddraw.wav";
			
			client_print(0, print_center, "Kor Draw")
		}
		case TEAM_START:
		{
			winStatus         = 3;	
			event             = 10;
			
			client_print(0, print_center, "Kor Draw")
		}
		default:
		{
			return false;
		}
	}
	
	g_endround = 1
	EndRoundMessage(g_WinText[team], event)
	RoundTerminating(winStatus, team == TEAM_START ? 3.0 : 5.0)
	PlaySound(0, sound)
	
	for(new i = 0; i < get_maxplayers(); i++)
	{
		if(!is_user_connected(i) || !is_user_alive(i))
			continue
		if(g_zombie[i])
		{
			update_deaths(i, 1)
		} else {
			update_frags(i, 3)
		}
	}

	return true;
}

stock RoundTerminating( const winStatus, const Float:delay )
{
	set_mp_pdata("m_iRoundWinStatus"  , winStatus );
	set_mp_pdata("m_fTeamCount"       , get_gametime() + delay );
	set_mp_pdata("m_bRoundTerminating", true );
}

stock EndRoundMessage( const message[], const event, const bool:notifyAllPlugins = false )
{
	static OrpheuFunction:handleFuncEndRoundMessage;
	
	if ( !handleFuncEndRoundMessage )
	{
		handleFuncEndRoundMessage = OrpheuGetFunction( "EndRoundMessage" );
	}
	
	( notifyAllPlugins ) ?
	OrpheuCallSuper( handleFuncEndRoundMessage, message, event ) :
	OrpheuCall( handleFuncEndRoundMessage, message, event );
}

stock hook_ent2(ent, Float:VicOrigin[3], Float:speed, type)
{
	static Float:fl_Velocity[3]
	static Float:EntOrigin[3]
	
	pev(ent, pev_origin, EntOrigin)
	static Float:distance_f
	distance_f = get_distance_f(EntOrigin, VicOrigin)
	
	new Float:fl_Time = distance_f / speed
	
	if(type == 1)
	{
		fl_Velocity[0] = ((VicOrigin[0] - EntOrigin[0]) / fl_Time) * 1.5
		fl_Velocity[1] = ((VicOrigin[1] - EntOrigin[1]) / fl_Time) * 1.5
		fl_Velocity[2] = (VicOrigin[2] - EntOrigin[2]) / fl_Time		
	} else if(type == 2) {
		fl_Velocity[0] = ((EntOrigin[0] - VicOrigin[0]) / fl_Time) * 1.5
		fl_Velocity[1] = ((EntOrigin[1] - VicOrigin[1]) / fl_Time) * 1.5
		fl_Velocity[2] = (EntOrigin[2] - VicOrigin[2]) / fl_Time
	}

	entity_set_vector(ent, EV_VEC_velocity, fl_Velocity)
}

stock equipweapon(id, weapon)
{
	if(!is_user_alive(id) || !is_user_connected(id)) 
		return

	static weaponid[2], weaponent
	
	if(weapon & EQUIP_PRI)
	{
		weaponent = fm_lastprimary(id)
		weaponid[1] = get_weaponid(g_primaryweapons[g_player_weapons[id][0]][1])
		
		if(pev_valid(weaponent))
		{
			weaponid[0] = fm_get_weapon_id(weaponent)
			if(weaponid[0] != weaponid[1])
				fm_strip_user_gun(id, weaponid[0])
		}
		else
			weaponid[0] = -1
		
		if(weaponid[0] != weaponid[1])
			fm_give_item(id, g_primaryweapons[g_player_weapons[id][0]][1])
		
		cs_set_user_bpammo(id, weaponid[1], g_weapon_ammo[weaponid[1]][1])
	}

	if(weapon & EQUIP_SEC)
	{
		weaponent = fm_lastsecondry(id)
		weaponid[1] = get_weaponid(g_secondaryweapons[g_player_weapons[id][1]][1])
		
		if(pev_valid(weaponent))
		{
			weaponid[0] = fm_get_weapon_id(weaponent)
			if(weaponid[0] != weaponid[1])
				fm_strip_user_gun(id, weaponid[0])
		}
		else
			weaponid[0] = -1
		
		if(weaponid[0] != weaponid[1])
			fm_give_item(id, g_secondaryweapons[g_player_weapons[id][1]][1])
		
		cs_set_user_bpammo(id, weaponid[1], g_weapon_ammo[weaponid[1]][1])
	}
	
	if(weapon & EQUIP_GREN)
	{
		static i
		for(i = 0; i < sizeof g_grenades; i++) if(!user_has_weapon(id, get_weaponid(g_grenades[i])))
			fm_give_item(id, g_grenades[i])
	}
}

// Fix Dead Attrib on scoreboard
FixDeadAttrib(id)
{
	message_begin(MSG_BROADCAST, get_user_msgid("ScoreAttrib"))
	write_byte(id) // id
	write_byte(0) // attrib
	message_end()
}

// Send Death Message for infections
SendDeathMsg(attacker, victim)
{
	message_begin(MSG_BROADCAST, get_user_msgid("DeathMsg"))
	write_byte(attacker) // killer
	write_byte(victim) // victim
	write_byte(1) // headshot flag
	write_string("infection") // killer's weapon
	message_end()
}
