/**
* 
* 		Jailbreak Day Menu
* 		  nikhilgupta345
* 
* 
* 		Features
* 
* 			- Voting on Round Start
* 				+ Guards vote
* 				+ Prisoners vote only every X round
* 
* 			- Many Day Optsions
* 				+ Free Day (Restricted/Unrestricted)
* 				+ Riot Day
* 				+ Cage Day
* 				+ Zombie Day
* 				+ Dodgeball Day
*					- Grenades Given at 8:00
*					- Auto Reload Nades After Throwing
* 				+ USP Ninja Day
* 				+ Lava Day
* 				+ Nightcrawler Day
* 				+ Space Day
* 				+ Shark Day
* 				+ Knife Day
* 				+ Hide and Seek Day
* 
* 			- Reverse Days For:
* 				+ Zombie Day
* 				+ Nightcrawler Day
* 				+ Shark Day
* 			
* 			- Objectives Displayed
* 
* 			- Prevent Weapon Pickup On Certain Days
*
*
*		CVARS
*			- jb_votetime 15		<seconds> 		// How long players have to vote
*			- jb_terroristvote 	<rounds> 		// How often Prisoners should vote // Every X times a vote occurs
*			- jb_voteoften		<rounds>		// How often a vote happens // Every X Rounds
*			- jb_opencells 		<0/1>			// Whether cells should be opened when day is chosen or not. (0=OFF, 1=ON)
*
*		Credits
*			Python1320 	- Used his code from WallClimb from nightcrawler's climb
*			Joropito 	- Used his code for open cells.
*			Mercylezz	- Used some code for zombie nightvision.
*
*		Changelog
*			September 24, 2011 	-v1.0- 	Initial release
*			September 24, 2011 	-v1.1-	Added CVAR jb_opencells
*			September 25, 2011 	-v1.2-	Added ability for only simons to use daymenu. Also added nightvision for the zombies.
*
*		Plugin Thread: http://forums.alliedmods.net/showthread.php?t=168122
*
* 
**/ 

// Includes
////////////

#include < amxmodx >
#include < amxmisc >
#include < cstrike >
#include < colorchat >
#include < fun >
#include < hamsandwich >
#include < fakemeta >
#include < engine >
#include < fakemeta_util >

#if !defined _colorchat_included
    #assert colorchat.inc library required !
#endif

// Defines
///////////

#define CELL_RADIUS	Float:200.0

// Enumerations
////////////////

enum
{
	DAY_FREE,
	DAY_CAGE,
	DAY_RIOT,
	DAY_ZOMBIE,
	DAY_DODGEBALL,
	DAY_USP_NINJA,
	DAY_LAVA,
	DAY_NIGHTCRAWLER,
	DAY_SPACE,
	DAY_SHARK,
	DAY_KNIFE,
	DAY_HNS,
	
	MAX_DAYS
}

enum
{
	UNRESTRICTED,
	RESTRICTED
}

enum
{
	CT,
	T
}
enum
{
	MAVERICK,
	AK,
	AUG,
	SCOUT,
	AWP,
	MP5
}

enum ( += 100 )
{
	TASK_HEGRENADE = 100,
	TASK_DODGEBALL,
	TASK_MAINDAYMENU,
	TASK_ZOMBIEMENU,
	TASK_HIDENSEEK,
	TASK_SHARKMENU,
	TASK_NCMENU,
	TASK_FREEMENU
}


// Integers
////////////

new g_iTimeLeft;
new g_iRoundStartTime;

new g_iCurrentDay;
new g_iDayCount;

new g_iFreedayType;
new g_iNightcrawlerType;
new g_iZombieType;
new g_iSharkType;

new g_iTimesVoted;

// PCVars
//////////

new g_pVoteTime;
new g_pTerroristDays;
new g_pVoteOften;

new g_pOpenCells;

// Arrays
//////////

new g_iMainDayVotes[MAX_DAYS];
new g_iFreedayVotes[2];
new g_iNightcrawlerVotes[2];
new g_iZombieVotes[2];
new g_iSharkVotes[2];

new g_iCurrentPage[33];

new g_iButtons[10];

new bool:g_bHasVoted[33] = { false, ... };

new Float:g_fWallOrigin[33][3];

// Messages
////////////

new g_msgNVGToggle;

// Booleans
////////////

new bool:g_bTerroristVote;

// Constants
/////////////

new const g_szDaymenuOptions[MAX_DAYS][] = 
{
	"Szabad Nap",
	"Ketrec Nap",
	"Lazadas Nap",
	"Zombi Nap",
	"Kidobos Nap",
	"Ninja Nap (usp-vel)",
	"Lava Nap",
	"Arnyek Nap",
	"Ur Nap",
	"Capa Nap",
	"Kes Nap",
	"Bujocska Nap"
}

new const g_szDaymenuObjectives[MAX_DAYS][] = 
{
	"A rabok barhova mehetnek. Kiveve GR-t!",
	"A raboknak be kell menni a nagyketrecbe es kovetni az orok utasitasait.",
	"Egy rab kap fegyvert. Az orok feladata megtalalni kinel van.",
	"Old meg a masik csapatot. A zombik 2000 hp val indulnak.",
	"Old meg a masik csapatot granatokkal!",
	"Mindket csapat kap usp-t. A gravitacio lecsokkent.",
	"",
	"Old meg a masik csapatot. Lathatatlanok vagytok es nem trappoltok",
	"Kis gravitacio.A raboknak scout az oroknek awp jar.",
	"A rabok at tudnak menni mindenen. Az orok awp vel lovik oket",
	"Az oroknek 150 hp, a raboknak 35 oljetek meg egymast!",
	"A raboknak 60 masodpercuk van elbujni. Utana az orok megkeresik es lelovik oket!"
}

new const g_szPrefix[] = "[JailBreak] [Napmenu]";

new const g_szZombieModel[ ] = "models/player/zombie/zombie.mdl";
new const g_szZombieHands[ ] = "models/jailbreak/zombie_hands.mdl";

new const g_szVersion[ ] = "1.2";

public plugin_precache()
{
	precache_model( g_szZombieModel );
	precache_model( g_szZombieHands );
}

////////////////////////////////////
//--------- Plugin Init ----------//
////////////////////////////////////
public plugin_init()
{	
	register_plugin( "Jailbreak Napmenu", g_szVersion, "H3avY Ra1n" );
	
	register_logevent( "LogEvent_RoundStart", 	2, "1=Round_Start" 	);	
	register_logevent( "LogEvent_RoundEnd", 	2, "1=Round_End" 	);
	
	register_event( "DeathMsg", "Event_DeathMsg", "a" );
	
	RegisterHam( Ham_Spawn, "player", "Ham_PlayerSpawn_Post", 1 );
	
	RegisterHam( Ham_TakeDamage, "player", "Ham_TakeDamage_Pre", 0 );
	
	RegisterHam( Ham_Weapon_SecondaryAttack, "weapon_usp", "Ham_USP_SecondaryAttack_Post", 1 );
	
	RegisterHam( Ham_Touch, "armoury_entity", 	"Ham_Touch_Weapon_Pre" 	);
	RegisterHam( Ham_Touch, "weaponbox", 		"Ham_Touch_Weapon_Pre" 	);
	RegisterHam( Ham_Touch, "worldspawn", 		"Ham_Touch_Wall_Pre" 	);
	RegisterHam( Ham_Touch, "func_wall", 		"Ham_Touch_Wall_Pre" 	);
	RegisterHam( Ham_Touch, "func_breakable", 	"Ham_Touch_Wall_Pre" 	);
	
	register_forward( FM_AddToFullPack, 	"Forward_AddToFullPack_Post", 	1 );
	register_forward( FM_PlayerPreThink, 	"Forward_PreThink",				0 );
	
	register_menu( "Main Menu", 		1023, 						"MainMenu_Handler" 			);
	register_menu( "Shark Menu", 		MENU_KEY_1 | MENU_KEY_2, 	"SharkMenu_Handler" 		);
	register_menu( "Zombie Menu", 		MENU_KEY_1 | MENU_KEY_2, 	"ZombieMenu_Handler" 		);
	register_menu( "Freeday Menu", 		MENU_KEY_1 | MENU_KEY_2, 	"FreedayMenu_Handler" 		);
	register_menu( "Nightcrawler Menu", MENU_KEY_1 | MENU_KEY_2, 	"NightcrawlerMenu_Handler" 	);
	
	server_cmd( "mp_roundtime 9" );
	server_cmd( "mp_freezetime 0" );
	
	g_pVoteOften 		= register_cvar( "jb_vote_often", "8" );
	g_pVoteTime 		= register_cvar( "jb_votetime", "15" );
	g_pTerroristDays 	= register_cvar( "jb_terroristvote", "1" ); // Prisoners vote every X days
	g_pOpenCells		= register_cvar( "jb_opencells", "1" );
	
	register_cvar( "daymenu_version_novote", g_szVersion, FCVAR_SPONLY|FCVAR_SERVER );
	
	g_msgNVGToggle = get_user_msgid( "NVGToggle" );
	
	setup_buttons();
}

////////////////////////////////////
//	        Player Dies			  //
////////////////////////////////////

public Event_DeathMsg()
{
	new players[32], num;
	get_players( players, num, "ae", "TERRORIST" );
	
	if( num == 1 )
	{
		if( g_iCurrentDay == DAY_ZOMBIE )
		{
			engfunc( EngFunc_LightStyle, 0, "m" );
			
			cs_reset_user_model( players[ 0 ] );
			
			if( get_user_weapon( players[ 0 ] ) == CSW_KNIFE )
				set_pev( players[ 0 ], pev_viewmodel2, "models/v_knife.mdl" );
		}
		
		g_iCurrentDay = -1;
		set_user_footsteps( players[0], 0 );
		set_user_rendering( players[0] );
	}
}

////////////////////////////////////
//	  Player Takes Damage PRE	  //
////////////////////////////////////

public Ham_TakeDamage_Pre( victim, inflictor, attacker, Float:damage, dmgbits )
{
	switch( g_iCurrentDay )
	{
		case DAY_HNS:
		{
			if( task_exists( TASK_HIDENSEEK ) )
				return HAM_SUPERCEDE;
		}
		
		case DAY_DODGEBALL:
		{
			if( task_exists( TASK_DODGEBALL ) )
				return HAM_SUPERCEDE;
		}
	}
	
	return HAM_IGNORED;
}


////////////////////////////////////
//	    Player Spawned POST 	  //
////////////////////////////////////

public Ham_PlayerSpawn_Post( id )
{
	if( !is_user_alive( id ) )
	{
		return HAM_IGNORED;
	}
	
	if( get_user_noclip( id ) )
		set_user_noclip( id, 0 );
	
	set_user_footsteps( id, 0 );
	
	set_user_rendering( id );
	
	set_user_gravity( id );	
	
	cs_reset_user_model( id );
	
	if( get_user_weapon( id ) == CSW_KNIFE )
		set_pev( id, pev_viewmodel2, "models/v_knife.mdl" );
		
	set_user_gnvision( id, 0 );
	
	StripPlayerWeapons( id );
	give_item( id, "weapon_knife" );
	
	
	return HAM_IGNORED;
}

////////////////////////////////////
//			Round Started 		  //
////////////////////////////////////
public LogEvent_RoundStart()
{
	engfunc( EngFunc_LightStyle, 0, "m" );
	
	g_iDayCount++;
	
	Reset();
	
	RemoveAllTasks();
	
	g_iRoundStartTime = get_systime();
	
	new iOften = get_pcvar_num( g_pVoteOften );
	
	if( iOften == 0 )
	{
		if( random_num( 1, 10 ) == 10 )
		{
			g_iTimesVoted++;
			StartDayVote();
		}
		
	}
	
	else
	{
		if( g_iDayCount % iOften == 0 )
		{
			g_iTimesVoted++;
			
			if( g_iTimesVoted % get_pcvar_num( g_pTerroristDays ) == 0 )
			{
				g_bTerroristVote = true;
			}
			
			else g_bTerroristVote = false;
			
			StartDayVote();
		}
	}
}


////////////////////////////////////
//			Round Ended 		  //
////////////////////////////////////
public LogEvent_RoundEnd()
{	
	Reset();
	RemoveAllTasks();
	
	new players[32], num;
	get_players( players, num, "a" );
	
	for( new i = 0; i < num; i++ )
	{
			StripPlayerWeapons( players[i] );
	}
	
	show_menu( 0, 0, "^n", 1 );
	
}

////////////////////////////////////
//		   Client Connected	  	  //
////////////////////////////////////
public client_putinserver( id )
{
	g_bHasVoted[id] = false;
	g_iCurrentPage[id] = 0;
	
	if( g_iCurrentDay == DAY_ZOMBIE )
	{
		engfunc( EngFunc_LightStyle, 0, "b" );
	}
	
	else engfunc( EngFunc_LightStyle, 0, "m" );
}

////////////////////////////////////
//			Main Day Vote 		  //
////////////////////////////////////
public StartDayVote() // This function starts the whole process.
{
	g_iTimeLeft = get_pcvar_num( g_pVoteTime );
	
	clamp( g_iTimeLeft, 5, 30 );
	
	ShowDayMenu();
	set_task( 1.0, "MainDayCountdown", TASK_MAINDAYMENU, _, _, "a", g_iTimeLeft );
}

public MainDayCountdown()
{
	g_iTimeLeft--;
	
	if( g_iTimeLeft > 0 )
	{
		ShowDayMenu();
	}
	
	else
	{
		DayVoteEnded();
	}
}

public ShowDayMenu()
{
	if( !( g_iTimeLeft > 0) )
		return;
	
	static szMenu[ 2048 ];
	static szFormat[ 2048 ];
	
	new iPlayers[ 32 ], iNum;
	get_players( iPlayers, iNum, "a" );
	
	new iPlayer;
	
	for( new i = 0; i < iNum; i++ )
	{
		iPlayer = iPlayers[ i ];
		
		formatex( szMenu, charsmax( szMenu ), "Jailbreak [Napmenu]^n\yValassz egy napot: [%i]", g_iTimeLeft );
		
		if( g_iCurrentPage[ iPlayer ] == 0 )
		{
			for( new i = 0; i < 7; i++ )
			{
				formatex( szFormat, charsmax( szFormat ), "^n\r%d. \w%s [Szavazatok: %d]", i + 1, g_szDaymenuOptions[ i ], g_iMainDayVotes[ i ] );
				
				add( szMenu, charsmax( szMenu ), szFormat );
				
			}
			
			add( szMenu, charsmax( szMenu ), "^n^n\r8. \dVissza" );
			add( szMenu, charsmax( szMenu ), "^n\r9. \wKovetkezo" );
			
		}
		
		else
		{
			for( new i = 7; i < MAX_DAYS; i++ )
			{
				formatex( szFormat, charsmax( szFormat ), "^n\r%d. \w%s [Szavazatok: %d]", i - 6, g_szDaymenuOptions[ i ], g_iMainDayVotes[ i ] );
				
				add( szMenu, charsmax( szMenu ), szFormat );
				
			}
			
			add( szMenu, charsmax( szMenu ), "^n^n\r8. \wVissza" );
			add( szMenu, charsmax( szMenu ), "^n\r9. \dKovetkezo" );
		}
		
		show_menu( iPlayer, 1023, szMenu, -1, "Main Menu" );
	}
}

public MainMenu_Handler( id, iKey )
{
	if( !is_user_connected( id ) )
		return PLUGIN_HANDLED;
	
	new CsTeams:team = cs_get_user_team( id );
	switch( g_iCurrentPage[ id ] )
	{
		case 0:
		{	
			if( iKey == 8 )
			{
				g_iCurrentPage[ id ]++;
				ShowDayMenu();
				return PLUGIN_HANDLED;
			}
			
			else
			{
				if( g_bHasVoted[id] )
				{
					ColorChat( id, NORMAL, "%s Te mar szavaztal.", g_szPrefix );
					ShowDayMenu();
					return PLUGIN_HANDLED;
				}
				
				else if( ( team == CS_TEAM_T && !g_bTerroristVote ) || ( team == CS_TEAM_CT && g_bTerroristVote ) )
				{
					ColorChat( id, NORMAL, "%s Te nem szavazhatsz ma!", g_szPrefix );
					ShowDayMenu();
					return PLUGIN_HANDLED;
				}
	
				else
				{
					g_iMainDayVotes[ iKey ]++;
					g_bHasVoted[ id ] = true;
					ShowDayMenu();
					
					return PLUGIN_HANDLED;
				}
			}
		}
		
		case 1:
		{
			if( iKey == 7 )
			{
				g_iCurrentPage[ id ]--;
				ShowDayMenu();
				return PLUGIN_HANDLED;
			}
			
			else if( iKey == 8 )
			{
				ShowDayMenu();
				return PLUGIN_HANDLED;
			}
			
			else if( iKey > MAX_DAYS - 8 )
			{
				ShowDayMenu();
				return PLUGIN_HANDLED;
			}
			
			else
			{
				if( g_bHasVoted[id] )
				{
					ColorChat( id, NORMAL, "%s Te mar szavaztal.", g_szPrefix );
					ShowDayMenu();
					return PLUGIN_HANDLED;
				}
				
				else if( ( team == CS_TEAM_T && !g_bTerroristVote ) || ( team == CS_TEAM_CT && g_bTerroristVote ) )
				{
					ColorChat( id, NORMAL, "%s Te nem szavazhatsz ma!", g_szPrefix );
					ShowDayMenu();
					return PLUGIN_HANDLED;
				}
				
				else
				{	
					g_iMainDayVotes[ iKey + 7 ]++;
					g_bHasVoted[ id ] = true;
					ShowDayMenu();
					
					return PLUGIN_HANDLED;
				}
			}
		}
	}
	
	return PLUGIN_HANDLED;
}  

public DayVoteEnded()
{
	show_menu( 0, 0, "^n", 1 );
	
	TallyDayVotes();
}

public TallyDayVotes()
{
	g_iCurrentDay = getHighestVote( g_iMainDayVotes, MAX_DAYS );
	
	if( g_iCurrentDay < 0 )
	{
		ColorChat( 0, NORMAL, "%s A szavazas sikertelen. Alapertelmezett: Ketrec Nap!", g_szPrefix );
		g_iCurrentDay = DAY_CAGE;
	}
	
	else
	ColorChat( 0, NORMAL, "%s A/Az %s megszavaztak a ^03%s^01-ot.", g_szPrefix, g_bTerroristVote ? "Rabok" : "Orok", g_szDaymenuOptions[g_iCurrentDay] );
	
	startDay();
	
	
	return PLUGIN_HANDLED;
}

////////////////////////////////////
//		Starting Chosen Day 	  //
////////////////////////////////////
public startDay()
{
	for( new i = 0; i < sizeof g_bHasVoted; i++ )
	{
		g_bHasVoted[i] = false;
		g_iCurrentPage[i] = 0;
	}
	
	switch( g_iCurrentDay )
	{
		case DAY_CAGE:
		{
			ShowWeaponMenu();
		}
		
		case DAY_FREE:
		{
			Start_FreedayVote();
			return PLUGIN_HANDLED;
		}
		
		case DAY_NIGHTCRAWLER:
		{			
			Start_NightcrawlerVote();
			return PLUGIN_HANDLED;
		}
		
		case DAY_SHARK:
		{
			Start_SharkVote();
			return PLUGIN_HANDLED;
		}
		
		case DAY_ZOMBIE:
		{
			Start_ZombieVote();
			return PLUGIN_HANDLED;
		}
		
		case DAY_RIOT:
		{
			new players[32], num;
			get_players( players, num, "ae", "TERRORIST" );
			
			if( num == 0 )
			{
				ColorChat( 0, NORMAL, "%s Jelenleg nincsenek ^03Rabok ^01elve.", g_szPrefix );
				return PLUGIN_HANDLED;
			}
			
			else if( num == 1 )
			{
				ColorChat( 0, NORMAL, "%s Nincs eleg ^03Rab ^01eletben ehhez a naphoz.", g_szPrefix );
				return PLUGIN_HANDLED;
			}
			
			
			new random = random_num( 1, num );
			
			while( !is_user_alive( players[random] ) )
				random = random_num( 1, num );
			
			cs_set_weapon_ammo( give_item( players[random], "weapon_m4a1" ), 90 );
			cs_set_weapon_ammo( give_item( players[random], "weapon_deagle" ), 35 );
			
			ShowWeaponMenu();
		}
		
		case DAY_DODGEBALL:
		{	
			
			new Float:roundtime = get_cvar_float( "mp_roundtime" );
			
			roundtime *= 60;
			
			roundtime -= ( get_systime() - g_iRoundStartTime );
			
			set_task( roundtime - 480, "startDodgeballDay", TASK_DODGEBALL );
			
			new iPlayers[ 32 ], iNum;
			get_players( iPlayers, iNum, "a" );
			
			for( new i = 0; i < iNum; i++ )
			{
				strip_user_weapons( iPlayers[ i ] );
				give_item( iPlayers[ i ], "weapon_knife" );
			}
		}
		
		case DAY_USP_NINJA:
		{
			new players[32], num, player;
			get_players( players, num, "a" );
			
			for( new i = 0; i < num; i++ )
			{
				player = players[i];
				set_user_health( player, 100 );
				StripPlayerWeapons( player );
				give_item( player, "weapon_knife" );
				
				give_item( player, "weapon_usp" );
				
				if( cs_get_user_team( player ) == CS_TEAM_CT )
				{
					cs_set_user_bpammo( player, CSW_USP, 112 );
				}
				
				else
				{
					cs_set_user_bpammo( player, CSW_USP, 32 );
				}
				
				new ent = find_ent_by_owner( 0, "weapon_usp", player );
				cs_set_weapon_silen( ent, 1 );
			}
			
			server_cmd( "sv_gravity 300" );
		}
		
		case DAY_SPACE:
		{
			new players[32], num, player;
			get_players( players, num, "a" );
			
			for( new i = 0; i < num; i++ )
			{
				player = players[i];
				StripPlayerWeapons( player );
				
				set_user_health( player, 100 );
				give_item( player, "weapon_knife" );
				
				switch( cs_get_user_team( player ) )
				{
					case CS_TEAM_CT:
					{
						give_item( player, "weapon_awp" );
						cs_set_user_bpammo( player, CSW_AWP, 30 );
						
					}
					
					case CS_TEAM_T:
					{
						give_item( player, "weapon_scout" );
						cs_set_user_bpammo( player, CSW_SCOUT, 90 );
					}
				}
			}
			
			server_cmd( "sv_gravity 300" );
		}
		
		case DAY_KNIFE:
		{
			new players[32], num, player;
			get_players( players,  num, "a" );
			
			for( new i = 0; i < num; i++ )
			{
				player = players[i];
				
				if( !is_user_alive( player ) )
					continue;
				
				switch( cs_get_user_team( player ) )
				{
					case CS_TEAM_CT:
					{
						set_user_health( player, 150 );
					}
					
					case CS_TEAM_T:
					{
						set_user_health( player, 35 );
					}
				}
				
				StripPlayerWeapons( player );
				
				give_item( player, "weapon_knife" );
			}
		}
		
		case DAY_HNS:
		{
			new players[32], num, player;
			get_players( players, num, "ae", "TERRORIST" );
			
			for( new i = 0; i < num; i++ )
			{
				player = players[i];
				
				if( !is_user_alive( player ) )
					continue;
				
				set_user_rendering( player, kRenderFxGlowShell, 0, 0, 0, kRenderTransAlpha, 16 );
				
				set_user_footsteps( player, 1 );
			}
			
			g_iTimeLeft = 60;
			set_task( 1.0, "Hidenseek_Countdown", TASK_HIDENSEEK, _, _, "a", g_iTimeLeft + 1 );
		}
		
		case DAY_LAVA: server_cmd( "decalfrequency 10" );
	}
	
	ColorChat( 0, NORMAL, "%s ^03Celkituzes: ^01%s", g_szPrefix, g_szDaymenuObjectives[g_iCurrentDay] );
	
	if( get_pcvar_num( g_pOpenCells ) )
		Push_Button();
	
	return PLUGIN_HANDLED;
}

////////////////////////////////////
//			Hidenseek Day 		  //
////////////////////////////////////
public Hidenseek_Countdown()
{
	g_iTimeLeft--;
	
	if( g_iTimeLeft >= 0 )
	{
		set_hudmessage( 0, 255, 0, -1.0, 0.2, 0, 0.0, 1.0, 0.1, 0.1, 4 );
		show_hudmessage( 0, "%i masodperc a lathatatlansagbol!", g_iTimeLeft );
	}
	
	else
	{
		set_hudmessage( 0, 255, 0, -1.0, 0.2, 0, 0.0, 5.0, 0.1, 0.1, 4 );
		show_hudmessage( 0, "Aki bujt, aki nem jovunk!" );
		
		new players[32], num, player;
		get_players( players, num, "ae", "TERRORIST" );
		
		for( new i = 0; i < num; i++ )
		{
			player = players[i];
			
			if( !is_user_alive( player ) )
				continue;
			
			set_user_rendering( player );
			set_user_footsteps( player, 0 );
		}
		
		if( task_exists( TASK_HIDENSEEK ) )
			remove_task( TASK_HIDENSEEK );	
		
		ColorChat( 0, NORMAL, "%s A ^03Rabok^01 lathatoak. Talaljatok meg oket!", g_szPrefix );
	}
}

////////////////////////////////////
//			Dodgeball Day 		  //
////////////////////////////////////
public startDodgeballDay()
{
	set_task( 0.1, "giveNades", TASK_HEGRENADE, _, _, "b" );
}

public giveNades()
{
	static players[32], num, player;
	get_players( players, num, "a" );
	
	for( new i = 0; i < num; i++ )
	{
		player = players[i];
		
		if( !is_user_alive( player ) ) continue;
		
		if( !user_has_weapon( player, CSW_HEGRENADE ) )
		{
			give_item( player, "weapon_hegrenade" );
		}
	}
}

////////////////////////////////////
//			Freeday Vote 		  //
////////////////////////////////////
public Start_FreedayVote()
{
	g_iTimeLeft = get_pcvar_num( g_pVoteTime );
	
	if( g_iTimeLeft > 30 )
		g_iTimeLeft = 30;
	
	showFreedayMenu();
	
	set_task( 1.0, "FreedayCountdown", .flags="a", .repeat=g_iTimeLeft );
}

public FreedayCountdown()
{
	g_iTimeLeft--;
	
	if( g_iTimeLeft > 0 )
		showFreedayMenu();
	
	else FreedayVoteEnded();
}

public showFreedayMenu()
{	
	if( !( g_iTimeLeft > 0 ) )
		return;
	
	static szMenu[ 2048 ], szFormat[ 2048 ];
	
	formatex( szMenu, charsmax( szMenu ), "\yValaszd ki a Szabad Nap tipusat: [%i]", g_iTimeLeft );
	
	formatex( szFormat, charsmax( szFormat ), "^n\r1. \wKorlatlan Szabadnap [Szavazatok: %i]", g_iFreedayVotes[ UNRESTRICTED ] );
	add( szMenu, charsmax( szMenu ), szFormat );
	
	formatex( szFormat, charsmax( szFormat ), "^n\r2. \wKorlatozott Szabadnap [Szavazatok: %i]", g_iFreedayVotes[ RESTRICTED ] );
	add( szMenu, charsmax( szMenu ), szFormat );
	
	
	new iPlayers[ 32 ], iNum;
	get_players( iPlayers, iNum, "a" );
	
	for( new i = 0; i < iNum; i++ )
	{
		show_menu( iPlayers[ i ], 0, "^n", 1 );
		
		show_menu( iPlayers[ i ], MENU_KEY_1 | MENU_KEY_2, szMenu, -1, "Freeday Menu" );
	}
	
}

public FreedayMenu_Handler( id, iKey )
{
	new CsTeams:team = cs_get_user_team( id );
	
	if( ( team == CS_TEAM_T && !g_bTerroristVote ) || ( team == CS_TEAM_CT && g_bTerroristVote ) )
	{
		ColorChat( id, NORMAL, "%s Te nem szavazhatsz ma!", g_szPrefix );
		
		showFreedayMenu();
		
		return PLUGIN_HANDLED;
	}
	
	else if( g_bHasVoted[id] )
	{
		ColorChat( id, NORMAL, "%s Te mar szavaztal.", g_szPrefix );
		
		showFreedayMenu();
		
		return PLUGIN_HANDLED;
	}
	
	
	g_iFreedayVotes[ iKey ]++;
	
	g_bHasVoted[ id ] = true;
	
	showFreedayMenu();
	
	return PLUGIN_HANDLED;
}

public FreedayVoteEnded()
{	
	show_menu( 0, 0, "^n", 1 );
	
	g_iFreedayType = getHighestVote( g_iFreedayVotes, 2 );
	
	if( g_iFreedayType == -1 )
		g_iFreedayType = UNRESTRICTED;
	
	startAlternativeDay();
}

////////////////////////////////////
//		  Nightcrawler Vote	      //
////////////////////////////////////
public Start_NightcrawlerVote()
{
	g_iTimeLeft = get_pcvar_num( g_pVoteTime );
	
	if( g_iTimeLeft > 30 )
		g_iTimeLeft = 30;
	
	showNightcrawlerMenu();
	
	set_task( 1.0, "NightcrawlerCountdown", .flags="a", .repeat=g_iTimeLeft );
}

public NightcrawlerCountdown()
{
	g_iTimeLeft--;
	
	if( g_iTimeLeft > 0 )
		showNightcrawlerMenu();
	
	else NightcrawlerVoteEnded();
}

public showNightcrawlerMenu()
{	
	if( !( g_iTimeLeft > 0 ) )
		return;

	static szMenu[ 2048 ], szFormat[ 2048 ];
	
	formatex( szMenu, charsmax( szMenu ), "\yValaszd ki, hogy ki legyen alcazva: [%i]", g_iTimeLeft );
	
	formatex( szFormat, charsmax( szFormat ), "^n\r1. \wOrok [Szavazatok: %i]", g_iNightcrawlerVotes[ CT ] );
	add( szMenu, charsmax( szMenu ), szFormat );
	
	formatex( szFormat, charsmax( szFormat ), "^n\r2. \wRabok [Szavazatok: %i]", g_iNightcrawlerVotes[ T ] );
	add( szMenu, charsmax( szMenu ), szFormat );
	
	
	new iPlayers[ 32 ], iNum;
	get_players( iPlayers, iNum, "a" );
	
	for( new i = 0; i < iNum; i++ )
	{
		show_menu( iPlayers[ i ], MENU_KEY_1 | MENU_KEY_2, szMenu, -1, "Nightcrawler Menu" );
	}
}

public NightcrawlerMenu_Handler( id, iKey )
{
	new CsTeams:team = cs_get_user_team( id );
	
	
	if( ( team == CS_TEAM_T && !g_bTerroristVote ) || ( team == CS_TEAM_CT && g_bTerroristVote ) )
	{
		ColorChat( id, NORMAL, "%s Te nem szavazhatsz ma!", g_szPrefix );
		
		showNightcrawlerMenu();
		return PLUGIN_HANDLED;
	}
	
	else if( g_bHasVoted[id] )
	{
		ColorChat( id, TEAM_COLOR, "%s Te mar szavaztal.", g_szPrefix );
		
		showNightcrawlerMenu();
		
		return PLUGIN_HANDLED;
	}
	
	g_iNightcrawlerVotes[ iKey ]++;
	
	g_bHasVoted[ id ] = true;
	
	return PLUGIN_HANDLED;
}

public NightcrawlerVoteEnded()
{
	show_menu( 0, 0, "^n", 1 );
	
	g_iNightcrawlerType = getHighestVote( g_iNightcrawlerVotes, 2 );
	
	if( g_iNightcrawlerType == -1 )
		g_iNightcrawlerType = CT;
	
	startAlternativeDay();
}

////////////////////////////////////
//			Zombie Vote 		  //
////////////////////////////////////
public Start_ZombieVote()
{
	g_iTimeLeft = get_pcvar_num( g_pVoteTime );
	
	if( g_iTimeLeft > 30 )
		g_iTimeLeft = 30;
	
	showZombieMenu();
	
	set_task( 1.0, "ZombieCountdown", .flags="a", .repeat=g_iTimeLeft );
}

public ZombieCountdown()
{
	g_iTimeLeft--;
	
	if( g_iTimeLeft > 0 )
		showZombieMenu();
	
	else ZombieVoteEnded();
}

public showZombieMenu()
{
	if( !( g_iTimeLeft > 0 ) )
		return;
	
	static szMenu[ 2048 ], szFormat[ 2048 ];
	
	formatex( szMenu, charsmax( szMenu ), "\yValaszd ki kik legyenek a zombik: [%i]", g_iTimeLeft );
	
	formatex( szFormat, charsmax( szFormat ), "^n\r1. \wOrok [Szavazatok: %i]", g_iZombieVotes[ CT ] );
	add( szMenu, charsmax( szMenu ), szFormat );
	
	formatex( szFormat, charsmax( szFormat ), "^n\r2. \wRabok [Szavazatok: %i]", g_iZombieVotes[ T ] );
	add( szMenu, charsmax( szMenu ), szFormat );
	
	
	new iPlayers[ 32 ], iNum;
	get_players( iPlayers, iNum, "a" );
	
	for( new i = 0; i < iNum; i++ )
	{
		show_menu( iPlayers[ i ], MENU_KEY_1 | MENU_KEY_2, szMenu, -1, "Zombie Menu" );
	}	
}

public ZombieMenu_Handler( id, iKey )
{
	new CsTeams:team = cs_get_user_team( id );

	if( ( team == CS_TEAM_T && !g_bTerroristVote ) || ( team == CS_TEAM_CT && g_bTerroristVote ) )
	{
		ColorChat( id, NORMAL, "%s Te nem szavazhatsz ma!", g_szPrefix );
		
		showZombieMenu();
		
		return PLUGIN_HANDLED;
	}
	
	if( g_bHasVoted[id] )
	{
		ColorChat( id, TEAM_COLOR, "%s Te mar szavaztal.", g_szPrefix );
		
		showZombieMenu();
		
		return PLUGIN_HANDLED;
	}

	g_iZombieVotes[ iKey ]++;
	
	g_bHasVoted[ id ] = true;
	
	return PLUGIN_HANDLED;
}

public ZombieVoteEnded()
{
	show_menu( 0, 0, "^n", 1 );
	
	g_iZombieType = getHighestVote( g_iZombieVotes, 2 );
	
	if( g_iZombieType == -1 )
		g_iZombieType = T;
	
	startAlternativeDay();
}

////////////////////////////////////
//			Shark Vote  		  //
////////////////////////////////////
public Start_SharkVote()
{
	g_iTimeLeft = get_pcvar_num( g_pVoteTime );
	
	if( g_iTimeLeft > 30 )
		g_iTimeLeft = 30;
	
	showSharkMenu();
	
	set_task( 1.0, "SharkCountdown", .flags="a", .repeat=g_iTimeLeft );
}

public SharkCountdown()
{
	g_iTimeLeft--;
	
	if( g_iTimeLeft > 0 )
		showSharkMenu();
	
	else sharkVoteEnded();
}

public showSharkMenu()
{
	if( !( g_iTimeLeft > 0 ) )
		return;
	
	static szMenu[ 2048 ], szFormat[ 2048 ];
	
	formatex( szMenu, charsmax( szMenu ), "\yValaszd ki a capakat: [%i]", g_iTimeLeft );
	
	formatex( szFormat, charsmax( szFormat ), "^n\r1. \wOrok [Szavazatok: %i]", g_iSharkVotes[ CT ] );
	add( szMenu, charsmax( szMenu ), szFormat );
	
	formatex( szFormat, charsmax( szFormat ), "^n\r2. \wRabok [Szavazatok: %i]", g_iSharkVotes[ T ] );
	add( szMenu, charsmax( szMenu ), szFormat );
	
	
	new iPlayers[ 32 ], iNum;
	get_players( iPlayers, iNum, "a" );
	
	for( new i = 0; i < iNum; i++ )
	{
		show_menu( iPlayers[ i ], MENU_KEY_1 | MENU_KEY_2, szMenu, -1, "Shark Menu" );
	}
	
}

public SharkMenu_Handler( id, iKey )
{
	new CsTeams:team = cs_get_user_team( id );
	
	if( ( team == CS_TEAM_T && !g_bTerroristVote ) || ( team == CS_TEAM_CT && g_bTerroristVote ) )
	{
		ColorChat( id, NORMAL, "%s Te nem szavazhatsz ma!", g_szPrefix );
		
		return PLUGIN_HANDLED;
	}
	
	else if( g_bHasVoted[id] )
	{
		ColorChat( id, TEAM_COLOR, "%s Te mar szavaztal.", g_szPrefix );
		return PLUGIN_HANDLED;
	}

	g_iSharkVotes[ iKey ]++;
	
	g_bHasVoted[ id ] = true;
	
	return PLUGIN_HANDLED;
}

public sharkVoteEnded()
{
	
	show_menu( 0, 0, "^n", 1 );
	
	g_iSharkType = getHighestVote( g_iSharkVotes, 2 );
	
	if( g_iSharkType == -1 )
	{
		g_iSharkType = CT;
	}
	
	startAlternativeDay();
}

////////////////////////////////////
//		  Start OTHER Day		  //
////////////////////////////////////
public startAlternativeDay()
{
	switch( g_iCurrentDay )
	{
		case DAY_FREE:
		{
			switch( g_iFreedayType )
			{
				case UNRESTRICTED:
				{
					ColorChat( 0, NORMAL, "%s A/Az ^03%s ^01megszavaztak a ^03Korlatlan Szabadnap^01-ot.", g_szPrefix, g_bTerroristVote ? "Rabok" : "Orok" );
				}
				
				case RESTRICTED:
				{
					ColorChat( 0, NORMAL, "%s A/Az ^03%s ^01megszavaztak a ^03Korlatozott Szabadnap^01-ot.", g_szPrefix, g_bTerroristVote ? "Rabok" : "Orok" );
				}                                                      
			}
			
			ShowWeaponMenu();
		}
		
		case DAY_NIGHTCRAWLER:
		{
			ColorChat( 0, NORMAL, "%s A/Az ^03%s ^01megszavaztak az ^03Arnyek Nap^01-ot.", g_szPrefix, g_bTerroristVote ? "Rabok" : "Orok" );
			
			switch( g_iNightcrawlerType )
			{
				case CT:
				{
					ColorChat( 0, NORMAL, "%s Az ^03Orok ^01az ^03Arnyekok^01!", g_szPrefix )
					
					new players[32], num, player;
					get_players( players, num, "a" );
					
					for( new i = 0; i < num; i++ )
					{
						player = players[i];
						
						set_user_health( player, 100 );
						
						StripPlayerWeapons( player );
						give_item( player, "weapon_knife" );
						
						switch( cs_get_user_team( player ) ) 
						{
							case CS_TEAM_T:	
							{
								give_item( player, "weapon_m4a1" );
								give_item( player, "weapon_deagle" );
								
								cs_set_user_bpammo( player, CSW_M4A1, 90 );
								cs_set_user_bpammo( player, CSW_DEAGLE, 35 );
							}
							
							case CS_TEAM_CT:
							{								
								set_user_rendering( player, kRenderFxGlowShell, 0, 0, 0, kRenderTransAlpha, 0 );
								
								set_user_footsteps( player, 1 );
								
								
							}
						}
					}
				}
				
				case T:
				{
					ColorChat( 0, NORMAL, "%s A ^03Rabok ^01az ^03Arnyekok^01!", g_szPrefix );
					
					new players[32], num, player;
					get_players( players, num, "a" );
					
					for( new i = 0; i < num; i++ )
					{
						player = players[i];
						
						set_user_health( player, 100 );
						
						StripPlayerWeapons( player );
						give_item( player, "weapon_knife" );
						
						switch( cs_get_user_team( player ) ) 
						{
							case CS_TEAM_CT:	
							{
								give_item( player, "weapon_m4a1" );
								give_item( player, "weapon_deagle" );
								
								cs_set_user_bpammo( player, CSW_M4A1, 90 );
								cs_set_user_bpammo( player, CSW_DEAGLE, 35 );
							}
							
							case CS_TEAM_T:
							{								
								set_user_rendering( player, kRenderFxGlowShell, 0, 0, 0, kRenderTransAlpha, 0 );
								
								set_user_footsteps( player, 1 );
								
								
							}
						}
					}					
				}
			}
		}
		
		case DAY_SHARK:
		{
			ColorChat( 0, NORMAL, "%s A/Az ^03%s ^01megszavaztak a ^03Capa Nap^01-ot.", g_szPrefix, g_bTerroristVote ? "Rabok" : "Orok" );
			
			switch( g_iSharkType )
			{
				case CT:
				{
					ColorChat( 0, NORMAL, "%s Az ^03Orok ^01a ^03Capak^01!", g_szPrefix );
					
					new players[32], num, player;
					get_players( players, num, "a" );
					
					for( new i = 0; i < num; i++ )
					{
						player = players[i];
						set_user_health( player, 100 );
						StripPlayerWeapons( player );
						give_item( player, "weapon_knife" );
						
						switch( cs_get_user_team( player ) )
						{
							case CS_TEAM_T:
							{
								give_item( player, "weapon_awp" );
								cs_set_user_bpammo( player, CSW_AWP, 30 );
							}
							
							case CS_TEAM_CT:
							{
								set_user_noclip( player, 1 );
							}
						}
					}
				}
				
				case T:
				{
					ColorChat( 0, NORMAL, "%s A ^03Rabok ^01a ^03Capak^01!", g_szPrefix );
					
					new players[32], num, player;
					get_players( players, num, "a" );
					
					for( new i = 0; i < num; i++ )
					{
						player = players[i];
						set_user_health( player, 100 );
						StripPlayerWeapons( player );
						give_item( player, "weapon_knife" );
						
						switch( cs_get_user_team( player ) )
						{
							case CS_TEAM_CT:
							{
								give_item( player, "weapon_awp" );
								cs_set_user_bpammo( player, CSW_AWP, 30 );
							}
							
							case CS_TEAM_T:
							{
								set_user_noclip( player, 1 );
							}
						}
					}
				}
			}
		}
		
		case DAY_ZOMBIE:
		{
			ColorChat( 0, NORMAL, "%s A/Az ^03%s ^01megszavaztak a ^03Zombi Nap^01-ot.", g_szPrefix, g_bTerroristVote ? "Rabok" : "Orok" );
			
			engfunc( EngFunc_LightStyle, 0, "b" );
			
			switch( g_iZombieType )
			{
				case CT:
				{
					ColorChat( 0, NORMAL, "%s Az ^03Orok ^01a ^03Zombik^01!", g_szPrefix );
					
					new players[32], num, player;
					get_players( players, num, "a" );
					
					for( new i = 0; i < num; i++ )
					{
						player = players[i];
						set_user_health( player, 100 );
						StripPlayerWeapons( player );
						give_item( player, "weapon_knife" );
						
						switch( cs_get_user_team( player ) )
						{
							case CS_TEAM_CT:
							{
								set_user_health( player, 4000 );
								
								cs_set_user_model( player, "zombie" );
								set_user_gnvision( player, 1 );
								
								set_pev( player, pev_viewmodel2, g_szZombieHands );
							}
							
							case CS_TEAM_T:
							{
								if( random_num( 0, 1 ) == 1 )
								{
									give_item( player, "weapon_ak47" );
									cs_set_user_bpammo( player, CSW_AK47, 90 );
								}
								
								else
								{
									give_item( player, "weapon_m4a1" );
									cs_set_user_bpammo( player, CSW_M4A1, 90 );
								}
								
								give_item( player, "weapon_deagle" );
								cs_set_user_bpammo( player, CSW_DEAGLE, 35 );
							}
						}
					}
				}
				
				case T:
				{
					ColorChat( 0, NORMAL, "%s A ^03Rabok ^01a ^03Zombik^01!", g_szPrefix );
					new players[32], num, player;
					get_players( players, num, "a" );
					
					for( new i = 0; i < num; i++ )
					{
						player = players[i];
						set_user_health( player, 100 );
						StripPlayerWeapons( player );
						give_item( player, "weapon_knife" );
						
						switch( cs_get_user_team( player ) )
						{
							case CS_TEAM_T:
							{
								set_user_health( player, 2000 );
								
								cs_set_user_model( player, "zombie" );
								set_user_gnvision( player, 1 );
								
								set_pev( player, pev_viewmodel2, g_szZombieHands );
							}
							
							case CS_TEAM_CT:
							{
								if( random_num( 0, 1 ) == 1 )
								{
									give_item( player, "weapon_ak47" );
									cs_set_user_bpammo( player, CSW_AK47, 90 );
								}
								
								else
								{
									give_item( player, "weapon_m4a1" );
									cs_set_user_bpammo( player, CSW_M4A1, 90 );
								}
								
								give_item( player, "weapon_deagle" );
								cs_set_user_bpammo( player, CSW_DEAGLE, 35 );
							}
						}
					}
				}
			}
		}
	}
	
	ColorChat( 0, NORMAL, "%s ^03Celkituzes: ^01%s", g_szPrefix, g_szDaymenuObjectives[g_iCurrentDay] );
	
	if( get_pcvar_num( g_pOpenCells ) )
		Push_Button();
}

public ShowWeaponMenu()
{
	new menu = menu_create( "Valassz fegyvert:",  "Weapon_MenuHandler" );
	menu_additem( menu, "M4a1", "0" );
	menu_additem( menu, "AK-47", "1" );
	menu_additem( menu, "AUG", "2" );
	menu_additem( menu, "Scout", "3" )
	menu_additem( menu, "AWP", "4" );
	menu_additem( menu, "MP5", "5" );
	
	new players[32], num;
	get_players( players, num, "ae", "CT" );
	
	for( new i = 0; i < num ;i++ )
	{
		menu_display( players[i], menu, 0 );
	}
}

public Weapon_MenuHandler( id, menu, item )
{
	if( !is_user_alive( id ) )
		return PLUGIN_HANDLED;
		
	if( item == MENU_EXIT )
	{
		give_item( id, "weapon_m4a1" );
		give_item( id, "weapon_deagle" )
		
		cs_set_user_bpammo( id, CSW_M4A1, 300 );
		cs_set_user_bpammo( id, CSW_DEAGLE, 100 );
		
		return PLUGIN_HANDLED;
	}
	
	if( !is_user_alive( id ) )
		return PLUGIN_HANDLED;
	
	new data[6], szName[64];
	new access, callback;
	
	menu_item_getinfo( menu, item, access, data, 5, szName, 63, callback );
	
	new key = str_to_num( data );
	
	StripPlayerWeapons( id );
	
	give_item( id, "weapon_knife" );
	
	switch( key )
	{
		case MAVERICK:
		{
			give_item( id, "weapon_m4a1" );
			cs_set_user_bpammo( id, CSW_M4A1, 300 );
		}
		
		case AK:
		{
			give_item( id, "weapon_ak47" );
			cs_set_user_bpammo( id, CSW_AK47, 300 );
		}
		
		case AUG:
		{
			give_item( id, "weapon_aug" );
			cs_set_user_bpammo( id, CSW_AUG, 300 );
		}
		
		case AWP:
		{
			give_item( id, "weapon_awp" );
			cs_set_user_bpammo( id, CSW_AWP, 100 );
		}
		
		case MP5:
		{
			give_item( id, "weapon_mp5navy" );
			cs_set_user_bpammo( id, CSW_MP5NAVY, 300 );
		}
		
		case SCOUT:
		{
			give_item( id, "weapon_scout" );
			cs_set_user_bpammo( id, CSW_SCOUT, 90 );
		}
	}
	
	give_item( id, "weapon_deagle" );
	cs_set_user_bpammo( id, CSW_DEAGLE, 100 );
	
	give_item( id, "weapon_hegrenade" );
	
	return PLUGIN_HANDLED;
}

public Ham_USP_SecondaryAttack_Post( ent )
{
	if( g_iCurrentDay != DAY_USP_NINJA )
		return HAM_IGNORED;
	
	if( !pev_valid( ent ) )
		return HAM_IGNORED;
	
	if( cs_get_weapon_silen( ent ) )
		return HAM_IGNORED;
	
	else cs_set_weapon_silen( ent, 1 );
	
	return HAM_IGNORED;
}

public Forward_AddToFullPack_Post( es_handle, e, ent, host, hostflags, id, pSet ) 
{
	if( id && g_iCurrentDay == DAY_NIGHTCRAWLER ) 
	{
		if( get_user_team( host ) == get_user_team( ent ) ) 
		{
			set_es( es_handle, ES_RenderMode, kRenderTransTexture );
			set_es( es_handle, ES_RenderAmt, 255 );
			
		}
	}
}

public Ham_Touch_Weapon_Pre( iEntity, id )
{
	if( !is_user_alive( id ) )
		return HAM_IGNORED;
	

	new CsTeams:team = cs_get_user_team( id );
		
	switch( g_iCurrentDay )
	{
		case DAY_ZOMBIE:
		{
			if( ( team == CS_TEAM_CT && g_iZombieType == CT ) 
				|| ( team == CS_TEAM_T && g_iZombieType == T ) )
					return HAM_SUPERCEDE;
		}
		
		case DAY_NIGHTCRAWLER:
		{
			if( ( team == CS_TEAM_CT && g_iNightcrawlerType == CT ) 
				|| ( team == CS_TEAM_T && g_iNightcrawlerType == T ) ) 
					return HAM_SUPERCEDE;
		}
		
		case DAY_SHARK:
		{
			if( ( team == CS_TEAM_CT && g_iSharkType == CT ) 
				|| ( team == CS_TEAM_T && g_iSharkType == T ) ) 
					return FMRES_SUPERCEDE;
		}
		
		case DAY_SPACE, DAY_KNIFE, DAY_USP_NINJA, DAY_DODGEBALL:
		{
			return HAM_SUPERCEDE;
		}
		
		case DAY_HNS:
		{
			if( team == CS_TEAM_T )
				return HAM_SUPERCEDE;
		}
	}
	
	return HAM_IGNORED;
}

public Ham_Touch_Wall_Pre( iEntity, id )
{
	if( !is_user_alive( id ) || g_iCurrentDay != DAY_NIGHTCRAWLER )
		return FMRES_IGNORED;

	pev( id, pev_origin, g_fWallOrigin[id] );
	
	return FMRES_IGNORED;
}


public Forward_PreThink( id )
{
	if( g_iCurrentDay != DAY_NIGHTCRAWLER )
		return FMRES_IGNORED;
	
	new CsTeams:team = cs_get_user_team( id );
	
	if( team == CS_TEAM_CT && g_iNightcrawlerType == T )
		return FMRES_IGNORED;
	
	else if( team == CS_TEAM_T && g_iNightcrawlerType == CT )
		return FMRES_IGNORED;
	
	new button = fm_get_user_button( id );
	
	if( button & IN_USE )
	{
		static Float:origin[3];
		pev( id, pev_origin, origin );
		
		if( get_distance_f( origin, g_fWallOrigin[id] ) > 10.0 )
			return FMRES_IGNORED;
		
		if( fm_get_entity_flags( id ) & FL_ONGROUND )
			return FMRES_IGNORED;
		
		if( button & IN_FORWARD )
		{
			static Float:velocity[3];
			velocity_by_aim( id, 240, velocity );
			
			fm_set_user_velocity( id, velocity );
		}
		
		else if( button & IN_BACK )
		{
			static Float:velocity[3];
			velocity_by_aim( id, -240, velocity );
			
			fm_set_user_velocity( id, velocity );
		}
	}
	
	return FMRES_IGNORED;
} 

////////////////////////////////////
//	  Returns the highest index   //
////////////////////////////////////
public getHighestVote( const votes[], len )
{
	new maximum = 0;
	
	for( new i = 0; i < len; i++ )
	{
		if( votes[i] > votes[maximum] )
			maximum = i;
	}
	
	if( maximum == 0 && votes[0] == 0 )
	{
		return -1;
	}
	
	return maximum;
}

public RemoveAllTasks()
{
	if( task_exists( TASK_HEGRENADE ) )
	{
		remove_task( TASK_HEGRENADE );
	}
	
	if( task_exists( TASK_DODGEBALL ) )
	{
		remove_task( TASK_DODGEBALL );
	}
	
	if( task_exists( TASK_MAINDAYMENU ) )
	{
		remove_task( TASK_MAINDAYMENU );
		
		show_menu( 0, 0, "^n", 1 );
	}
	
	if( task_exists( TASK_FREEMENU ) )
	{
		remove_task( TASK_FREEMENU );
		
		show_menu( 0, 0, "^n", 1 );
	}
	
	if( task_exists( TASK_SHARKMENU ) )
	{
		remove_task( TASK_SHARKMENU );
		
		show_menu( 0, 0, "^n", 1 );
	}
	
	if( task_exists( TASK_NCMENU ) )
	{
		remove_task( TASK_NCMENU );
		
		show_menu( 0, 0, "^n", 1 );
	}
	
	if( task_exists( TASK_ZOMBIEMENU ) )
	{
		remove_task( TASK_ZOMBIEMENU );
		
		show_menu( 0, 0, "^n", 1 );
	}
	
	
	if( task_exists( TASK_HIDENSEEK ) )
		remove_task( TASK_HIDENSEEK );
	
}

public Reset()
{
	if( get_cvar_num( "sv_gravity" ) != 800 )
		server_cmd( "sv_gravity 800" );
	
	if( get_cvar_num( "mp_friendlyfire" ) )
		server_cmd( "mp_friendlyfire 0" );
	
	if( get_cvar_num( "decalfrequency" ) == 15 )
		server_cmd( "decalfrequency 60" );
		
	/* Reset ALL variables */
	g_iCurrentDay = -1;
	g_iFreedayType = -1;
	g_iSharkType = -1;
	g_iNightcrawlerType = -1;
	g_iZombieType = -1;
	
	for( new i = 0; i < MAX_DAYS; i++ )
	{
		g_iMainDayVotes[i] = 0;
	}
	
	for( new i = 0; i < 2; i++ )
	{
		g_iFreedayVotes[i] = 0;
		g_iSharkVotes[i] = 0;
		g_iNightcrawlerVotes[i] = 0;
		g_iZombieVotes[i] = 0;
	}
	
	for( new i = 0; i < sizeof( g_bHasVoted ); i++ )
	{
		g_bHasVoted[i] = false;
		g_iCurrentPage[i] = 0;
	}
}

public setup_buttons()
{
	new ent = 1 
	new ent3 
	new Float:origin[3] 
	new Float:radius = 200.0 
	new class[32] 
	new name[32]
	new pos 
	while((pos <= sizeof(g_iButtons)) && (ent = engfunc(EngFunc_FindEntityByString, ent, "classname", "info_player_deathmatch"))) // info_player_deathmatch = tspawn
	{ 
			new ent2 = 1 
			pev(ent, pev_origin, origin) 
			while((ent2 = engfunc(EngFunc_FindEntityInSphere, ent2, origin, radius)))  // find doors near T spawn
			{ 
					if(!pev_valid(ent2)) 
							continue 

					pev(ent2, pev_classname, class, charsmax(class)) 
					if(!equal(class, "func_door")) // if it's not a door, move on to the next iteration
							continue 

					pev(ent2, pev_targetname, name, charsmax(name)) 
					ent3 = engfunc(EngFunc_FindEntityByString, 0, "target", name) // find button that opens this door
					if(pev_valid(ent3) && (in_array(ent3, g_iButtons, sizeof(g_iButtons)) < 0)) 
					{ 
							ExecuteHamB(Ham_Use, ent3, 0, 0, 1, 1.0) // zomg poosh it
							g_iButtons[pos] = ent3 
							pos++ // next
							break // break from current while loop
					} 
			} 
	} 
	return pos 
}

public Push_Button()
{
	static i
	for(i = 0; i < sizeof(g_iButtons); i++)
	{
		if(g_iButtons[i])
		{
			ExecuteHamB(Ham_Use, g_iButtons[i], 0, 0, 1, 1.0)
			entity_set_float(g_iButtons[i], EV_FL_frame, 0.0)
		}
	}
}

// By ConnorMcLeod - Prevent Weapon Pickup Glitch

#define OFFSET_PRIMARYWEAPON        116 

public StripPlayerWeapons(id) 
{ 
    strip_user_weapons(id) 
    set_pdata_int(id, OFFSET_PRIMARYWEAPON, 0) 
}

stock in_array(needle, data[], size)
{
	for(new i = 0; i < size; i++)
	{
		if(data[i] == needle)
			return i
	}
	return -1
}

set_user_gnvision(id, toggle)
{
	// Toggle NVG message
	message_begin(MSG_ONE, g_msgNVGToggle, _, id)
	write_byte(toggle) // toggle
	message_end()
}