#include <amxmodx>
#include <amxmisc>
#include <fakemeta>
#include <fakemeta_util>
#include <fun>
#include <hamsandwich>
#include <cs_ham_bots_api>
#include <cstrike>


#define PLUGIN "Kalapacs"
#define VERSION "1.0"
#define AUTHOR "Itep"

new 	bool:g_hasHammer[33], 
	bool:block = true,
	bool:bugfix,
	bool:csapatv[32];
	
new const v_knife[]      = "models/v_knife.mdl",
	  p_knife[]      = "models/p_knife.mdl",
	  v_hammer[]     = "models/kalapacs/v_hammer.mdl",
	  p_hammer[]     = "models/kalapacs/p_hammer.mdl",
	  waw_fal[]      = "kalapacs/fal.wav",
	  waw_jatekos[] = "kalapacs/jatekos.waw";
	  
new 	ka_beki,ka_sebzes,ka_hppp,ka_maxteleport,ka_faltav,
	ka_php,ka_teletime,ka_botteletime, ka_bottele;

new kivi,maxhp;
	   
public plugin_init() {
	register_plugin(PLUGIN, VERSION, AUTHOR);
	
	register_event("CurWeapon","elvalt","be","1=1");
	register_logevent("valaszt", 2, "1=Round_End");
	register_logevent("eloszt", 2, "0=World triggered", "1=Round_Start");
	register_clcmd("changeteam", "HookTeamChoose");
	register_clcmd("jointeam", "HookTeamChoose");
	
	RegisterHam(Ham_Weapon_SecondaryAttack, "weapon_knife", "tele");
	RegisterHam(Ham_TakeDamage,"player","tam");
	RegisterHamBots(Ham_TakeDamage,"tam");
	
	register_forward(FM_EmitSound, "HandleSound");
	
	ka_beki=register_cvar("ka_beki","0");
	ka_sebzes=register_cvar("ka_sebzes","2");
	ka_hppp=register_cvar("ka_hppp","1250");
	ka_maxteleport=register_cvar("ka_maxteleport","1024");
	ka_faltav=register_cvar("ka_faltav","37.0");
	ka_php=register_cvar("ka_php","100");
	ka_teletime=register_cvar("ka_teletime","10.0");
	ka_botteletime=register_cvar("ka_botteletime","10.0");
	ka_bottele=register_cvar("ka_bottele","1");
	
}

public plugin_precache() 
{
	precache_model(v_knife);
	precache_model(p_knife);
	precache_model(v_hammer);
	precache_model(p_hammer);
	
	precache_sound(waw_fal);
	precache_sound(waw_jatekos);
}

public HandleSound(entity, channel, const sound[]) {
	if (entity > 0 && entity < 33 && g_hasHammer[entity]) {
		if (equal(sound, "weapons/knife_hitwall1.wav")) {
			emit_sound(entity, CHAN_WEAPON, waw_fal, 1.0, ATTN_NORM, 0, PITCH_NORM);
			return FMRES_SUPERCEDE;
		} else if (equal(sound, "weapons/knife_hit", 17) || equal(sound, "weapons/knife_stab.wav")) {
			emit_sound(entity, CHAN_WEAPON, waw_jatekos, 1.0, ATTN_NORM, 0, PITCH_NORM);
			return FMRES_SUPERCEDE;
		} else if (equal(sound, "weapons/knife_deploy1.wav")) {
			return FMRES_SUPERCEDE;
		}
	}
	return FMRES_IGNORED;
}

public plugin_cfg()
{
	new file[64]; get_localinfo("amxx_configsdir",file,63);
	format(file, 63, "%s/kalapacs.cfg", file);
	if(file_exists(file)) server_cmd("exec %s", file), server_exec();
}

public valaszt()
{
	if (0!=get_pcvar_num(ka_beki))
	{
		new players[32],pnum;
		get_players(players, pnum, "h");
		kivi = players[random(pnum)];
		new name[33];
		get_user_name(kivi,name,32);
		
		for(new i=0; i<pnum; i++) {
			if (kivi!=players[i]) {
				cs_set_user_team(players[i], CS_TEAM_T, CS_DONTCHANGE);
				client_print(players[i],print_chat,"%s a kivalasztott!",name);
				vege(players[i]); 
			} else { 
				cs_set_user_team(players[i], CS_TEAM_CT, CS_DONTCHANGE);
				client_print(players[i],print_chat,"Te vagy a kivalasztott!");
			}
		}
		remove_task(3137);
		remove_task(8073137);
		bugfix=true;
	}
}

public eloszt()
{
	if (0!=get_pcvar_num(ka_beki)&&bugfix){
		new players[32],pnum;
		get_players(players, pnum, "h");
		if (is_user_alive(kivi)) {
			fegyo_eldob(kivi);
			Hammer(kivi);
			maxhp=pnum*get_pcvar_num(ka_hppp);
			set_user_health(kivi,maxhp);
		}
		set_task(0.5,"elet",3137,"param",1,"b");
		if (is_user_bot(kivi)&&1==get_pcvar_num(ka_bottele)) set_task(get_pcvar_float(ka_botteletime),"bot_tele",8073137,"param",1,"b");
		bugfix=false;
	}
		
}

public Hammer(id) 
{
	if (is_user_alive(id)) {
		if (get_user_weapon(id) != CSW_KNIFE) engclient_cmd(id, "weapon_knife");
		client_cmd(id, "cl_righthand ^"1^"");
		set_pev(id, pev_viewmodel2,v_hammer);
		set_pev(id, pev_weaponmodel2,p_hammer);
	}
	g_hasHammer[id] = true;
}

public vege(id) 
{
	if (g_hasHammer[id]){
		if (is_user_alive(id)) {
			if (get_user_weapon(id) != CSW_KNIFE) engclient_cmd(id, "weapon_knife");
			client_cmd(id, "cl_righthand ^"1^"");
			set_pev(id, pev_viewmodel2,v_knife);
			set_pev(id, pev_weaponmodel2,p_knife);
		}
		g_hasHammer[id] = false;
	}
}

public client_connect(id)
{
	vege(id);
	csapatv[id]=false;
}
public client_disconnect(id)
{
	vege(id);
	csapatv[id]=false;
}

public elvalt(id) 
{
	if (0!=get_pcvar_num(ka_beki)){
		if(g_hasHammer[id]&&get_user_weapon(id)!=CSW_KNIFE)
		{	
			fegyo_eldob(id);
			Hammer(id);
		}	
	}
}

public tele(ent) 
{
	new id = pev(ent, pev_owner);
	if (g_hasHammer[id]&&block&&!is_user_bot(id)&&0!=get_pcvar_num(ka_beki)) {
		teleport(id);
		return PLUGIN_CONTINUE;
	}
	return HAM_IGNORED;
}

public ki_block()
{
	client_print(kivi,print_chat,"Ujra teleportalhatsz!");
	block=true;
}



public tam(id, inflictor, attacker,Float:damage)
{
	if(g_hasHammer[attacker]&&0!=get_pcvar_num(ka_beki))
	{
		if (get_user_health(attacker)+get_pcvar_num(ka_php)<maxhp)
			set_user_health(attacker,get_user_health(attacker)+get_pcvar_num(ka_php));
		else set_user_health(attacker,maxhp);
		
		SetHamParamFloat(4,damage*get_pcvar_float(ka_sebzes));
	}
}

public elet(param)
{
	if (0!=get_pcvar_num(ka_beki))
	{
		new hp = get_user_health(kivi);
		
		set_hudmessage(255, 00, 00, 0.035, 0.91);
		show_hudmessage(0, "BossHp: %d", hp);
	}
}

public HookTeamChoose(id)
{
	if (0!=get_pcvar_num(ka_beki)&&csapatv[id])
	{
		client_print(id,print_center,"A csapat valtas tiltva van!");
		return PLUGIN_HANDLED;
	}
	csapatv[id]=true;
	return PLUGIN_CONTINUE;
}

public bot_tele(param)
{
	if (0!=get_pcvar_num(ka_beki))
	{
		teleport(kivi);
	}
}

public teleport(id)
{
	new Float:origin[3], Float:TD[3], Float:TE[3], Float:N[3];
	pev(id, pev_origin, origin ); 
	velocity_by_aim( id, get_pcvar_num(ka_maxteleport), TD ); 
	xs_vec_add( TD, origin, TE );  
	engfunc( EngFunc_TraceLine, origin, TE, DONT_IGNORE_MONSTERS, id, 0 );
	new Float:fF;
	get_tr2( 0, TR_flFraction, fF );
	if ( fF < 1.0 )
	{
		get_tr2( 0, TR_vecEndPos, TE );
		get_tr2( 0, TR_vecPlaneNormal, N );
	}
	xs_vec_mul_scalar( N, get_pcvar_float(ka_faltav), N );
	xs_vec_add( TE, N, origin );
	
	if (!beragadt(id,origin)){
		engfunc(EngFunc_SetOrigin, id, origin);
		client_print(id,print_chat,"%f mp mulva ujra teleportalhatsz!",get_pcvar_float(ka_teletime));
		block=false;
		set_task(get_pcvar_float(ka_teletime),"ki_block",7313);
	}else{
		client_print(id,print_chat,"Nem tudsz oda teleportalni!");
		if (is_user_bot(id)) set_task(2.0,"bot_tele",807,"param");
	}
}

public fegyo_eldob(id)
{
	if (is_user_bot(id)) { 
		strip_user_weapons(id);
		give_item(id, "weapon_knife");
	}else{
		new iwpn = 0, iwpns[32], nwpn[32];
		get_user_weapons ( id, iwpns, iwpn );
		const KNIFE_BIT_SUM = (1<<CSW_KNIFE);
		for (new a = 0; a < iwpn; ++a ) {
			if (!(1<<iwpns[a]&KNIFE_BIT_SUM)) {
				get_weaponname ( iwpns[a], nwpn, 31 );
				engclient_cmd ( id, "drop", nwpn );
			}
		}
	}
}

stock beragadt(id, Float:originF[3])
{
	engfunc(EngFunc_TraceHull, originF, originF, 0, (pev(id, pev_flags) & FL_DUCKING) ? HULL_HEAD : HULL_HUMAN, id, 0)
	
	if (get_tr2(0, TR_StartSolid) || get_tr2(0, TR_AllSolid) || !get_tr2(0, TR_InOpen))
		return true;
	
	return false;
}
