#include <amxmodx>
#include <amxmisc>
#include <fakemeta>
#include <engine>

#define MAX_ZONES	5
#define TASK_ID		1234

#define OriginX		0
#define OriginY		1
#define OriginZ		2

new cvar_delay
new cvar_kzsize
new cvar_kzsizez
new cvar_height
new cvar_nadepro

new bool:g_DirExist
new g_ConfigsDir[64]
new g_KnifeZoneDir[64]

new Float:g_fDelay[33]
new g_ProtectionTime[33]
new bool:g_InTheZone[33]

new zoneID
new sprite_zbeam
new g_KnifeZoneOrgins[MAX_ZONES][3]
new bool:g_KnifeZoneLogos[MAX_ZONES]



static const PLUGIN_NAME[] 	= "Knife Zone"
static const PLUGIN_AUTHOR[] 	= "Cheap_Suit"
static const PLUGIN_VERSION[]	= "1.6"

public plugin_init()
{
	register_plugin(PLUGIN_NAME, PLUGIN_VERSION, PLUGIN_AUTHOR)
	register_cvar(PLUGIN_NAME, PLUGIN_VERSION, FCVAR_SPONLY|FCVAR_SERVER)
	register_clcmd("amx_kzmenu", "open_KnifeZone", ADMIN_LEVEL_A, "Knife Zone Menu")
	register_menucmd(register_menuid("Knife Zone Menu"), 1023, "action_KnifeZone")

	cvar_delay	= register_cvar("amx_kzdelay", 	"0") //menyi ido alat legyel halhatatlan
	cvar_height	= register_cvar("amx_kzheight", "140") //zona Magasaga
	cvar_kzsize 	= register_cvar("amx_kzsize", 	"140") // Zona NAgysaga
	cvar_kzsizez 	= register_cvar("amx_kzsizez", 	"50") //Zona Szelesege
	cvar_nadepro	= register_cvar("amx_kznadepro", "1") // Ezt Nemtudom :S
	
	register_forward(FM_TraceLine, "fwd_TraceLine")
	register_directory()
}

public plugin_precache() 
{
	precache_model("sprites/knifezone.spr")
	sprite_zbeam = precache_model("sprites/zbeam4.spr")
}

register_directory()
{
	get_configsdir(g_ConfigsDir, 63)
	format(g_KnifeZoneDir, 63, "%s/knifezone", g_ConfigsDir)
	
	if(!dir_exists(g_KnifeZoneDir))
	{
		log_amx("Knife Zone directory does not exist")
		g_DirExist = false
	} 
	else 
	{
		g_DirExist = true
		
		new curMap[32]
		get_mapname(curMap, 31)
		load_origins(curMap)
		
		set_task(1.0, "task_visuals", TASK_ID, _, _, "b")
	}
}

public open_KnifeZone(id, level, cid)
{
	if(!cmd_access(id, level, cid, 1))
		return PLUGIN_HANDLED
	
	if(!g_DirExist) 
		console_print(id, "Knife Zone directory does not exist")
	else
		display_KnifeZone(id)
	
	return PLUGIN_HANDLED
}

public display_KnifeZone(id)
{
	new menuBody[512]
	new len = format(menuBody, 511, "\yKnife Zone Menu^n")
	len += format(menuBody[len], 511-len, "^n\w1. Zona letrehozasa")
	len += format(menuBody[len], 511-len, "^n\r2. Toroli Az Osszes Zonat")
	len += format(menuBody[len], 511-len, "^n\d3. Kilepes")

	new keys = (1<<0|1<<1|1<<2)
	show_menu(id, keys, menuBody, -1, "Kes Zona Menu")	
}

public action_KnifeZone(id, key)
{
	switch(key) 
	{
		case 0:	
		{
			if(zoneID >= MAX_ZONES)
			{
				client_print(id, print_chat, "Elerted a Max Kes Zonak Szamat")
				return PLUGIN_HANDLED
			}
			
			if(!is_user_alive(id)) 
			{
				client_print(id, print_chat, "Maradj eletben a Kes Zona Kesziteshez")
				return PLUGIN_HANDLED
			}
			
			_makeZone(id)
			display_KnifeZone(id)
			client_print(id, print_chat, "Letrehoztal Egy kes Zonat")
		}			
		case 1: 
		{
			_removeZones()
			display_KnifeZone(id)
			client_print(id, print_chat, "Osszes Kes Zona Torolve")
		}
	}
	return PLUGIN_HANDLED
}

public fwd_TraceLine(Float:v1[3], Float:v2[3], noMonsters, id)
{  
	if(!is_user_alive(id))
		return FMRES_IGNORED
	
	new victim = get_tr(TR_pHit)
	if(!is_user_alive(victim))
		return FMRES_IGNORED
		
	new tmp[2], weapon = get_user_weapon(victim, tmp[0], tmp[1]) 
	if(weapon == CSW_KNIFE && g_InTheZone[victim])
		set_tr(TR_flFraction, 1.0)
		
	return FMRES_IGNORED
}

public client_PreThink(id)
{
	if(!task_exists(TASK_ID) || !is_user_alive(id)) 
	{
		g_ProtectionTime[id] = -1
		g_InTheZone[id] = false
		
		return PLUGIN_CONTINUE
	}
	
	if(!check_origin(id))
	{
		g_InTheZone[id] = false
		g_ProtectionTime[id] = -1
		
		return PLUGIN_CONTINUE
	}
	
	new protectionDelay = get_pcvar_num(cvar_delay)
	if(g_ProtectionTime[id] < protectionDelay)
	{
		if(g_fDelay[id] + 1.0 < get_gametime())
		{
			g_ProtectionTime[id] += 1
			g_fDelay[id] = get_gametime()
		}
		
		set_hudmessage(255, 0, 0, -1.0, -1.0, _, _, 0.5, _, _, 4)
		show_hudmessage(id, "Protection in %d...", (protectionDelay - g_ProtectionTime[id]))
	}
	else if(g_ProtectionTime[id] >= protectionDelay)
		g_InTheZone[id] = true
	
	new tmp[2], weap = get_user_weapon(id, tmp[0], tmp[1])
	if(weap != CSW_KNIFE) client_cmd(id, "weapon_knife")
	
	return PLUGIN_CONTINUE
}

stock check_origin(id)
{
	new iOrigin[3]
	get_user_origin(id, iOrigin, 0)
	
	for(new i = 0; i < MAX_ZONES; ++i)
	{
		if((g_KnifeZoneOrgins[i][OriginX] == 0) 
		&& (g_KnifeZoneOrgins[i][OriginY] == 0) 
		&& g_KnifeZoneOrgins[i][OriginZ] == 0)
			continue
		
		new ZoneSizeX = get_pcvar_num(cvar_kzsize)
		new ZoneSizeY = get_pcvar_num(cvar_kzsize)
		new ZoneSizeZ = get_pcvar_num(cvar_kzsizez)
		
		if((g_KnifeZoneOrgins[i][OriginX] - iOrigin[0] > ZoneSizeX) || (g_KnifeZoneOrgins[i][OriginX] - iOrigin[0] < -ZoneSizeX) 
		|| (g_KnifeZoneOrgins[i][OriginY] - iOrigin[1] > ZoneSizeY) || (g_KnifeZoneOrgins[i][OriginY] - iOrigin[1] < -ZoneSizeY)
		|| (g_KnifeZoneOrgins[i][OriginZ] - iOrigin[2] > ZoneSizeZ) || (g_KnifeZoneOrgins[i][OriginZ] - iOrigin[2] < -ZoneSizeZ))
			continue

		return true
	}
	return false
}

stock check_GrenadeOrigin(Origin[3])
{	
	new Ent = -1
	while((Ent = find_ent_by_class(Ent, "grenade")))
	{
		new szModel[32]
		entity_get_string(Ent, EV_SZ_model, szModel, 31)
		if(equal(szModel, "models/w_smokegrenade.mdl") 
		|| equal(szModel, "models/w_hegrenade.mdl") 
		|| equal(szModel, "models/w_flashbang.mdl"))
		{
			new Float:vOrigin[3], iOrigin[3]
			entity_get_vector(Ent, EV_VEC_origin, vOrigin)
			FVecIVec(vOrigin, iOrigin)
 
			if(get_distance(iOrigin, Origin) <= get_pcvar_num(cvar_kzsize))
				remove_entity(Ent)
		}
	}
}

load_origins(mapname[])
{
	new mapFile[64]
	format(mapFile, 63, "%s/%s.cfg", g_KnifeZoneDir, mapname)

	if(!file_exists(mapFile)) 
	{
		server_print("There are no Knife Zone(s) for %s", mapname)
		return PLUGIN_CONTINUE
	}

	new Text[64], Line = 0, Len = 0
	while(read_file(mapFile, Line++, Text, 63, Len))
	{
		if((Text[0]==';') || !Len)
		 	continue
		
		if(zoneID >= MAX_ZONES)
		{
			log_amx("Max Knife Zones reached, increase MAX_ZONES")
			break
		}
		
		new iOrigin[3][16]
		parse(Text, iOrigin[OriginX], 15, iOrigin[OriginY], 15, iOrigin[OriginZ], 15)
		
		g_KnifeZoneOrgins[zoneID][OriginX] = str_to_num(iOrigin[OriginX])
		g_KnifeZoneOrgins[zoneID][OriginY] = str_to_num(iOrigin[OriginY])
		g_KnifeZoneOrgins[zoneID][OriginZ] = str_to_num(iOrigin[OriginZ])
		
		zoneID += 1
	}
	return PLUGIN_CONTINUE
}

save_origin(mapname[], Origin[3])
{
	new mapFile[64], Text[64]
	format(mapFile, 63, "%s/%s.cfg", g_KnifeZoneDir, mapname)
	if(!file_exists(mapFile)) 
	{
		new Comments[64]
		format(Comments, 63, "; Knife Zone origins for %s", mapname)
		write_file(mapFile, Comments, -1)
	}
	
	format(Text, 64, "%i %i %i", Origin[OriginX], Origin[OriginY], Origin[OriginZ])
	write_file(mapFile, Text, -1)
}

public task_visuals()
{
	for(new i = 0; i < MAX_ZONES; ++i)
	{
		if((g_KnifeZoneOrgins[i][OriginX] == 0) 
		&& (g_KnifeZoneOrgins[i][OriginY] == 0) 
		&& g_KnifeZoneOrgins[i][OriginZ] == 0)
				continue
		
		create_kzring(g_KnifeZoneOrgins[i])
		
		if(get_pcvar_num(cvar_nadepro))
			check_GrenadeOrigin(g_KnifeZoneOrgins[i])
		
		if(!g_KnifeZoneLogos[i]) 
		{
			g_KnifeZoneLogos[i] = true
			create_logo(g_KnifeZoneOrgins[i])
		}
	}
}

stock create_kzring(Origin[3])
{
	new shape[4][2] = {{1,1}, {-1,1}, {-1,-1}, {1,-1}}
	new x1, y1, x2, y2, height, i, j
	new ZoneSize = get_cvar_num("amx_kzsize")
	
	for(j = 0; j < 2; j++)
	{
		height = (30 * j - 30)
		for(i = 0; i < 4; i++)
		{
			x1 = (shape[i][0] * ZoneSize)
			y1 = (shape[i][1] * ZoneSize)
			if(i < 3)
			{
				x2 = (shape[i+1][0] * ZoneSize)
				y2 = (shape[i+1][1] * ZoneSize)
			}
			else
			{
				x2 = (shape[0][0] * ZoneSize)
				y2 = (shape[0][1] * ZoneSize)
			}
			
			message_begin(MSG_BROADCAST, SVC_TEMPENTITY)
			write_byte(0)
			write_coord(Origin[OriginX] + x1)
			write_coord(Origin[OriginY] + y1)
			write_coord(Origin[OriginZ] + height)
			write_coord(Origin[OriginX] + x2)
			write_coord(Origin[OriginY] + y2)
			write_coord(Origin[OriginZ] + height)
			write_short(sprite_zbeam)
			write_byte(0)
			write_byte(0)
			write_byte(30)
			write_byte(15)
			write_byte(0)
			write_byte(255)
			write_byte(0)
			write_byte(0)  
			write_byte(100)
			write_byte(0)
			message_end()
		}
	}
}

stock create_logo(Origin[3]) 
{
	new Float:flOrigin[3]
	IVecFVec(Origin, flOrigin)
	
	new sprite = create_entity("info_target")
	if(is_valid_ent(sprite))
	{
		entity_set_string(sprite, EV_SZ_classname, "kzlogo")
		entity_set_model(sprite, "sprites/knifezone.spr")
		
		flOrigin[2] += get_pcvar_num(cvar_height)
		entity_set_origin(sprite, flOrigin)
	}
}

_makeZone(id)
{
	new iOrigin[3], CurMap[32]
	get_user_origin(id, iOrigin, 0)
	get_mapname(CurMap, 31)

	zoneID = 0
	save_origin(CurMap, iOrigin)
	load_origins(CurMap)
	
	if(task_exists(TASK_ID))
		remove_task(TASK_ID)
		
	set_task(1.0, "task_visuals", TASK_ID, _, _, "b")
}

_removeZones()
{
	new MapFile[64], CurMap[32]
	get_mapname(CurMap, 31)
	format(MapFile, 63, "%s/%s.cfg", g_KnifeZoneDir, CurMap)
	if(file_exists(MapFile))
		delete_file(MapFile)
	
	if(task_exists(TASK_ID))
		remove_task(TASK_ID)
	
	zoneID = 0
	
	for(new i = 0; i < MAX_ZONES; ++i)
	{
		g_KnifeZoneLogos[i] = false
		g_KnifeZoneOrgins[i][OriginX] = 0
		g_KnifeZoneOrgins[i][OriginY] = 0
		g_KnifeZoneOrgins[i][OriginZ] = 0
	}
	
	new logo = -1
	while((logo = find_ent_by_class(logo, "kzlogo")))
		remove_entity(logo)
}
/* AMXX-Studio Notes - DO NOT MODIFY BELOW HERE
*{\\ rtf1\\ ansi\\ ansicpg1252\\ deff0\\ deflang1033{\\ fonttbl{\\ f0\\ fnil Tahoma;}}\n\\ viewkind4\\ uc1\\ pard\\ f0\\ fs16 \n\\ par }
*/
