#include < amxmodx > 
#include < fakemeta > 
#include < xs > 
#include < hamsandwich > 
#include < zombieplague > 

new const PLUGIN_VERSION[ ]	=    	"0.1"; 
new const PLUGIN_AUTHOR[ ]	=    	"Shurik07";
new const PLUGIN_NAME[ ]		=    	"[ ZP ] Nemesis skill"; 

new const BALL__MODEL[   ]		=	"sprites/lord.spr"; 
new const BALL_SHOOTSOUND[  ] 	=  	"deimos_skill_start.wav";
new const EXPLODE__SPRITE[ ] 	=	"sprites/ex.spr";
new const BALL__CLASSNAME[ ]    =    "szClassBall";

const Float:SPEED__BALL  	=   800.0; //Labda gyorsasaga
const Float:DAMAGE__BALL	=	500.0; // Sebzes erteke
const Float:RELOAD__SKILL	=	10.0; //Mennyi ido utan lehessen ujra
const Float:RADIUS__SKILL   =   200.0; //Sebzes hatosugara

const MAX_CLIENTS 		=	32;

new g_iSkill[ MAX_CLIENTS + 1 ]; 

new g_Ball = 1

new g_iExp;

enum _:Coord_e 
{ 
	Float:x,
	Float:y, 
	Float:z 
};

enum _:Angle_e 
{ 
	Float:pitch, 
	Float:yaw, 
	Float:roll 
};

#define VectorScale(%1,%2,%3)    ( %3[ x ] = %2 * %1[ x ], %3[ y ] = %2 * %1[ y ], %3[ z ] = %2 * %1[ z ] )

public plugin_init( ) 
{
	register_plugin( 	PLUGIN_NAME		, 
				PLUGIN_AUTHOR	, 
				PLUGIN_VERSION	
		);
		
	register_clcmd( "drop" , "ClCommand__UseSkill" ); 
	
	register_forward( FM_Touch , "Forward_Touch" );
}

public plugin_precache( ) 
{
	engfunc( EngFunc_PrecacheModel , BALL__MODEL	 );
	engfunc( EngFunc_PrecacheSound , BALL_SHOOTSOUND );
	
	g_iExp = engfunc( EngFunc_PrecacheModel , EXPLODE__SPRITE );
}

public zp_user_infected_post( pID , pInfector , pNemesis ) 
{
	if( !is_user_alive( pID  )  )
	{
			return 
	}
	
	if( zp_get_user_nemesis( pID ) ) 
	{
		g_iSkill[ pID ] = true ;
		
		client_print( pID , print_center , "Használd a labda képességed , 'G'-betűvel!" );
	}
}

public ClCommand__UseSkill( pID ) 
{
	if( !is_user_alive( pID ) ) 
	{
			return PLUGIN_CONTINUE;
	}
	
	if( zp_get_user_nemesis( pID ) && g_iSkill[ pID ] ) 
	{
		static Float:vf_Forward[ Coord_e ], Float:vf_vAngle[ Angle_e ];
		static Float:vf_Source [ Coord_e ];
		
		UTIL_GetPosition(  pID , vf_Source, 40.0, 4.0, -5.0 )
		
		global_get ( glb_v_forward, vf_Forward );
		pev ( pID, pev_v_angle, vf_vAngle );
		
		static Float:vf_VelocitySR[ Coord_e ]
		
		VectorScale ( vf_Forward, SPEED__BALL , vf_VelocitySR );		
		
		UTIL__SetBall( vf_Source , vf_VelocitySR , pID ); 
		
		engfunc( EngFunc_EmitSound, pID, CHAN_ITEM, BALL_SHOOTSOUND, 1.0, ATTN_NORM, 0, PITCH_NORM);
		
		g_iSkill[ pID ] = false;
		
		client_print( pID , print_center , "Várj %s másodpercet ,hogy ujra használd a képességed!" , RELOAD__SKILL );
		
		set_task( RELOAD__SKILL	, "Return__Skill" , pID ); 
	}
	
	return PLUGIN_CONTINUE;
}	
	
public UTIL__SetBall ( const Float:vf_Origin[], const Float:vf_Velocity[], const i_Owner )
{
	static pEntity;

	if ( ( pEntity = engfunc(EngFunc_CreateNamedEntity, engfunc(EngFunc_AllocString, "env_sprite") ) ) )
	{
		static vf_Temp[ Angle_e ]
		
		set_pev ( pEntity , pev_classname , BALL__CLASSNAME );
		set_pev ( pEntity, pev_origin, vf_Origin );
		set_pev ( pEntity, pev_owner, i_Owner );
		
		set_pev ( pEntity, pev_movetype, MOVETYPE_FLY );
		set_pev ( pEntity, pev_solid, SOLID_TRIGGER  );
		set_pev ( pEntity, pev_gravity, -1.0 );
		
		engfunc ( EngFunc_VecToAngles, vf_Velocity, vf_Temp );
		set_pev ( pEntity, pev_angles, vf_Temp );
		
		engfunc ( EngFunc_SetModel , pEntity, BALL__MODEL	 );
		engfunc ( EngFunc_SetSize  , pEntity, Float:{ 0.0, 0.0, 0.0 }, Float:{ 0.0, 0.0, 0.0 } );
		engfunc ( EngFunc_SetOrigin, pEntity, vf_Origin );
		
		set_pev ( pEntity, pev_velocity, vf_Velocity );
		set_pev ( pEntity, pev_rendermode,  kRenderTransAdd )
		set_pev ( pEntity, pev_renderamt,   255.0 )
		
		set_pev ( pEntity , pev_iuser1 , g_Ball );
	}
}	
	
	
public Forward_Touch( const pEntity , pOther ) 
{
		if( !pev_valid( pEntity ) )
		{
			return FMRES_IGNORED ; 
		}

		static zsClassname[ 32 ];

		pev( pEntity, pev_classname, zsClassname, charsmax( zsClassname ) );

		if( !equal( zsClassname, BALL__CLASSNAME ) )
		{
			return FMRES_IGNORED;
		}
		
		if( pev( pEntity , pev_iuser1 ) ) 
		{
			UTIL_SetTouch ( pEntity , pOther ) 
		}
		
		return FMRES_IGNORED 
}

public UTIL_SetTouch( pEntity ,pOther  ) 
{
	if( !pev_valid( pEntity ) )
	{
		return;
	}

	static Float:flOrigin[ Coord_e ];
	pev( pEntity, pev_origin, flOrigin );
	
	set_pev(pEntity, pev_movetype, MOVETYPE_NONE)
	set_pev(pEntity, pev_solid, SOLID_NOT)	
	
	message_begin(MSG_BROADCAST,SVC_TEMPENTITY)
	write_byte(TE_EXPLOSION)
	engfunc(EngFunc_WriteCoord , flOrigin[x] )
	engfunc(EngFunc_WriteCoord , flOrigin[y]  )
	engfunc(EngFunc_WriteCoord , flOrigin[z]  )
	write_short( g_iExp )
	write_byte( 50 )
	write_byte( 24 )
	write_byte( 0 )
	message_end( )

	new pOwner = pev( pEntity, pev_owner );
       
	static pevVictim, Float:flDistance,Float:fDamage;
                       
	pevVictim  = -1;
       
	while( ( pevVictim = engfunc( EngFunc_FindEntityInSphere, pevVictim, flOrigin, RADIUS__SKILL) ) != 0 )
	{

				if( !is_user_alive( pevVictim ) )
						continue;

				if( zp_get_user_zombie( pevVictim ) )
					continue;

				flDistance = fm_entity_range( pEntity, pevVictim );

				fDamage = UTIL_FloatRadius( DAMAGE__BALL, RADIUS__SKILL , flDistance );

				if( fDamage > 0.0 )
				{
						ExecuteHamB( Ham_TakeDamage, pevVictim, pEntity, pOwner, fDamage, DMG_BULLET | DMG_ALWAYSGIB );

				}
	}
       
	engfunc( EngFunc_RemoveEntity, pEntity );
}

public Return__Skill( pID ) 
{
	if( is_user_alive( pID ) ) 
	{
		g_iSkill[ pID ] = true 
		 
		client_print( pID , print_center , "A képességed ész , használatához nyomd 'G'-betűt!"  );
	}
}

Float:UTIL_FloatRadius( Float:flMaxAmount, Float:flRadius, Float:flDistance )
{
        return floatsub( flMaxAmount, floatmul( floatdiv( flMaxAmount, flRadius ), flDistance ) );
}

stock UTIL_GetPosition(id, Float:fOrigin[ ], Float:add_forward=0.0, Float:add_right=0.0, Float:add_up=0.0)
{
	static Float:Angles[ Angle_e ],Float:ViewOfs[ Coord_e  ], Float:vAngles[ Angle_e  ]
	static Float:Forward[ Coord_e ], Float:Right[ Coord_e ], Float:Up[ Coord_e ]
	
	pev(id, pev_v_angle, vAngles)
	pev(id, pev_origin, fOrigin)
	pev(id, pev_view_ofs, ViewOfs)
	xs_vec_add(fOrigin, ViewOfs, fOrigin)
	
	pev(id, pev_angles, Angles)
	
	Angles[0]= vAngles[0]
	
	engfunc(EngFunc_MakeVectors, Angles)
	
	global_get(glb_v_forward, Forward)
	global_get(glb_v_right, Right)
	global_get(glb_v_up,  Up)
	
	xs_vec_mul_scalar(Forward, add_forward, Forward)
	xs_vec_mul_scalar(Right, add_right, Right)
	xs_vec_mul_scalar(Up, add_up, Up)
	
	fOrigin[0]=fOrigin[0]+Forward[0]+Right[0]+Up[0]
	fOrigin[1]=fOrigin[1]+Forward[1]+Right[1]+Up[1]
	fOrigin[2]=fOrigin[2]+Forward[2]+Right[2]+Up[2]
}

stock Float:fm_entity_range(ent1, ent2) 
{ 
    new Float:origin1[3], Float:origin2[3] 
    pev(ent1, pev_origin, origin1) 
    pev(ent2, pev_origin, origin2) 

    return get_distance_f(origin1, origin2) 
}  
stock print_color(const id, const input[], any:...)
{
        new count = 1, players[32]
        static msg[191]
        vformat(msg, 190, input, 3)

        replace_all(msg, 190, "!g", "^4")
        replace_all(msg, 190, "!y", "^1")
        replace_all(msg, 190, "!t", "^3")
        replace_all(msg, 190, "", "á")
        replace_all(msg, 190, "", "é")
        replace_all(msg, 190, "", "í")
        replace_all(msg, 190, "", "ó")
        replace_all(msg, 190, "", "ö")
        replace_all(msg, 190, "", "ő")
        replace_all(msg, 190, "", "ú")
        replace_all(msg, 190, "", "ü")
        replace_all(msg, 190, "", "ű")
        replace_all(msg, 190, "", "Á")
        replace_all(msg, 190, "", "É")
        replace_all(msg, 190, "", "Í")
        replace_all(msg, 190, "", "Ó")
        replace_all(msg, 190, "", "Ö")
        replace_all(msg, 190, "", "Ő")
        replace_all(msg, 190, "", "Ú")
        replace_all(msg, 190, "", "Ü")
        replace_all(msg, 190, "", "Ű")        

        if (id) players[0] = id; else get_players(players, count, "ch")
        {
                for (new i = 0; i < count; i++)
                {
                        if (is_user_connected(players[i]))
                        {
                                message_begin(MSG_ONE_UNRELIABLE, get_user_msgid("SayText"), _, players[i])
                                write_byte(players[i])
                                write_string(msg)
                                message_end()
                        }
                }
        }
        return PLUGIN_HANDLED
}
