#include <amxmodx>
#include <amxmisc>
#include <fun>
#include <fakemeta_util>
#include <cstrike>

#define CMOD 1
#define CLIGHTS 2
#define CSPEED 3
#define CREGEN 4
#define CDAMAGE 5
#define CTIME 6
#define CGRAV 7
#define CRED 8
#define CGREEN 9
#define CBLUE 10
#define COBJEC 11
#define CALC 12
#define CLAST 13

#define TASK_LIGHT 111
#define TASK_REGEN 222
#define TASK_INVIS 333
#define TASK_CHOOSE 444
#define TASK_RESTART 555
#define TASK_VISION 666

#define MAXPLAYERS 33

new claws[] = "models/v_claws.mdl"
new knife[] = "models/v_knife.mdl"

new pcvar[CLAST];
new maxhealth, maxarmor;
new monster = 0;
new cached_gametime, curr_gametime;
new told;
new bool:selected;
new bool:gKilledByMonster = false;

new bombMap = 0;
new hostageMap = 0;

public plugin_precache() {
	precache_model("models/player/monster/monster.mdl");
	precache_model(claws);
	precache_model(knife);
}

public plugin_init() {
	register_plugin("Monster Mod", "1.3", "Rolnaaba");
	
	pcvar[CMOD] = register_cvar("sv_sewermonster", "1"); //mod on or off?
	pcvar[CLIGHTS] = register_cvar("sm_lights", "1"); //set lights down low and flickering, with sewermonster having night vision.
	pcvar[CSPEED] = register_cvar("sm_speed", "9999.0"); //how much FASTER the sewer monster runs.
	pcvar[CREGEN] = register_cvar("sm_regen", "25"); //how much health the sewermonster gets every five seconds.
	pcvar[CDAMAGE] = register_cvar("sm_damage", "2.0"); //damage multiplier for Sewer Monster!
	pcvar[CTIME] = register_cvar("sm_time", "30"); //time in whihc the monster must kill to not starve (starts over every kill)
	pcvar[CGRAV] = register_cvar("sm_grav", "0.3"); //half the gravity
	pcvar[COBJEC] = register_cvar("sm_block", "1"); //block objectives?
	pcvar[CALC] = register_cvar("sm_calc", "0");
	
	//these are for the RGB values of the monster's nightvision.
	pcvar[CRED] = register_cvar("sm_nvgr", "35"); //red value
	pcvar[CGREEN] = register_cvar("sm_nvgg", "65"); //green value
	pcvar[CBLUE] = register_cvar("sm_nvgb", "120"); //blue value
	
	register_clcmd("nightvision", "_NightVision"); //to block use of nightvision thanks to teame06
	
	register_concmd("amx_monster", "set_monster", ADMIN_CHAT, "<name> -Makes that player the monster!");
	register_concmd("amx_toggle_sm", "toggle_mod", ADMIN_CVAR, "-Toggles on and off the mod");
	
	register_event("HLTV", "BeginingNewRound", "a", "1=0", "2=0");
	register_event("CurWeapon", "Event_CurWeapon", "be");
	register_event("Damage", "Event_Damage", "be");
	register_event("DeathMsg", "Event_Death", "a");
	register_event("TeamInfo", "event_team_info", "a");
	
	register_logevent("Event_NewRound", 2, "1=Round_Start");
	
	set_task(1.0, "lighting_loop", TASK_LIGHT);
	set_task(10.0, "_choose_monster", TASK_CHOOSE);
		
	
	register_message(get_user_msgid("DeathMsg"), "msg_Death");
	
	//For blocking Objectives, from gungame!
	register_message(get_user_msgid("Scenario"),"message_scenario");
	register_message(get_user_msgid("BombDrop"),"message_bombdrop");
	register_message(get_user_msgid("WeapPickup"),"message_weappickup");
	register_message(get_user_msgid("AmmoPickup"),"message_ammopickup");
	register_message(get_user_msgid("TextMsg"),"message_textmsg");
	register_message(get_user_msgid("HostagePos"),"message_hostagepos");
	
	// identify this as a bomb map
	if(fm_find_ent_by_class(1, "info_bomb_target") || fm_find_ent_by_class(1, "func_bomb_target"))
		bombMap = 1;

	// identify this as a hostage map
	if(fm_find_ent_by_class(1,"hostage_entity"))
		hostageMap = 1;
	
	selected = false;
}

public toggle_mod(id, level, cid) {
	if(!cmd_access(id, level, cid, 1))
		return PLUGIN_HANDLED;
	
	if(!get_pcvar_num(pcvar[CMOD])) {
		set_pcvar_num(pcvar[CMOD], 1);
		console_print(id, "[MM] MonsterMod:BEKAPCSOLVA");
		client_print(0, print_chat, "[MM]MonsterMod:BEKAPCSOLVA");
	} else {
		set_pcvar_num(pcvar[CMOD], 0);
		console_print(id, "[MM]MonsterMod:KIKAPCSOLVA");
		client_print(0, print_chat, "[MM]MonsterMod:KIKAPCSOLVA");
	}

	if(monster) {
		set_user_rendering(monster);
		cs_reset_user_model(monster);
	}
	
	remove_task(TASK_VISION+monster);
	remove_task(TASK_REGEN+monster);
	remove_task(TASK_INVIS+monster);
	
	set_pev(monster, pev_viewmodel, engfunc(EngFunc_AllocString, knife));
		
	server_cmd("sv_restartround 5");
	
	return PLUGIN_HANDLED;
}

public set_monster(id, level, cid) {
	if(!get_pcvar_num(pcvar[CMOD])) {
		console_print(id, "A Monster Mod ot kikapcsolta egy admin!");
		return PLUGIN_HANDLED;
	}
	if(!cmd_access(id, level, cid, 2))
		return PLUGIN_HANDLED;

	new arg[32];
	read_argv(1, arg, 31);
	new player = cmd_target(id, arg, 2);
	
	if (!player) {
		console_print(id, "Nem talalhato a jatekos");
		return PLUGIN_HANDLED;
	}
	if(monster) {
		set_user_rendering(monster);
	}
	
	remove_task(TASK_VISION+monster);
	remove_task(TASK_REGEN+monster);
	remove_task(TASK_INVIS+monster);
		
	cs_set_user_team(monster, CS_TEAM_CT, CS_CT_GIGN);
	
	cs_reset_user_model(monster);
	set_pev(monster, pev_viewmodel, engfunc(EngFunc_AllocString, knife));
	
	monster = player;
	
	cs_set_user_team(monster, CS_TEAM_T, CS_T_TERROR);
	cs_set_user_model(monster, "monster");
	set_pev(monster, pev_viewmodel, engfunc(EngFunc_AllocString, claws));
	
	new aname[32], mname[32];
	get_user_name(id, aname, 31);
	get_user_name(player, mname, 31);
	
	client_print(0, print_chat, "[SM] ADMIN: %s csinalt %s a MONSTER!", aname, mname);
	
	server_cmd("sv_restartround 5");
	
	return PLUGIN_HANDLED;
}

public BeginingNewRound() {
	if(hostageMap && get_pcvar_num(pcvar[COBJEC]) && get_pcvar_num(pcvar[CMOD]))
		set_task(0.1,"move_hostages");
}

public _choose_monster() {
	if(!get_pcvar_num(pcvar[CMOD])) return PLUGIN_CONTINUE;
	
	new players[32], num;
	get_players(players, num);
	if(num <= 1) {
		client_print(0, print_center, "Nincs eleg jatekos a Monster kivalasztasahoz!");
		set_task(10.0, "_choose_monster", TASK_CHOOSE);
	} else {
		client_print(0, print_center, "A Monster kivalasztodik 5 masodperc mulva!");
		set_task(5.0, "choose_monster", TASK_CHOOSE);
	}
	return PLUGIN_CONTINUE;
}

public sm_regen_loop() {	
	if(!get_pcvar_num(pcvar[CMOD])) {
		set_task(5.0, "sm_regen_loop", TASK_REGEN);
	}
	
	if((get_user_health(monster)+get_pcvar_num(pcvar[CREGEN])) >= maxhealth) {
		set_user_health(monster, maxhealth);
	} else {
		set_user_health(monster, get_user_health(monster)+get_pcvar_num(pcvar[CREGEN]));
	}
	
	set_task(5.0, "sm_regen_loop", TASK_REGEN);
}

public sm_invis_loop() {
	if(!get_pcvar_num(pcvar[CMOD])) {
		set_task(5.0, "sm_invis_loop", TASK_INVIS);
	}
	
	set_task(random_float(0.5, 2.0), "_sm_invis_loop", TASK_INVIS);
	set_user_rendering(monster, kRenderFxPulseSlowWide, 0, 0, 0, kRenderTransAlpha, 85);
}

public _sm_invis_loop() {	
	set_task(random_float(5.0, 14.0), "sm_invis_loop", TASK_INVIS);
	set_user_rendering(monster, kRenderFxGlowShell, 0, 255, 0, kRenderNormal, 25);
}

public lighting_loop() {
	if(!get_pcvar_num(pcvar[CMOD])) return PLUGIN_CONTINUE;
	
	if(get_pcvar_num(pcvar[CLIGHTS])) {	
		engfunc(EngFunc_LightStyle, 0, "a")
		set_task(random_float(4.0, 8.0), "thunder_clap", TASK_LIGHT);
	} else {
		engfunc(EngFunc_LightStyle, 0, "#OFF")
		remove_task(TASK_LIGHT);
		set_task(20.0,"lighting_loop", TASK_LIGHT);
	}
	return PLUGIN_HANDLED
}

public thunder_clap() {
	engfunc(EngFunc_LightStyle, 0, "s")
	client_cmd(0,"speak ambience/thunder_clap.wav");
	
	set_task(1.0,"lighting_loop",TASK_LIGHT);
}

public choose_monster() {
	if(!get_pcvar_num(pcvar[CMOD])) return PLUGIN_CONTINUE;
	
	new players[32],num;
	get_players(players,num, "a");

	new ran = random(num);
	new id = players[ran];
	
	monster = id;
	
	client_print(0, print_center, "Monster Chosen!");
	
	set_task(1.0, "begin", id);
	
	return PLUGIN_CONTINUE;
}

public set_user_vision(id) {
	if(id > TASK_VISION) id -= TASK_VISION;
	
	if(!get_pcvar_num(pcvar[CMOD])) return PLUGIN_CONTINUE;
	
	if(!get_pcvar_num(pcvar[CLIGHTS])) {
		if(task_exists(id+TASK_VISION)) remove_task(id+TASK_VISION);
		return PLUGIN_CONTINUE;
	}
	
	new origin[3];
	get_user_origin(id, origin);
	
	//NVG Entity
	message_begin(MSG_ONE, SVC_TEMPENTITY, {0,0,0}, id);
	write_byte(TE_DLIGHT);		//entity type
	write_coord(origin[0]);		//x
	write_coord(origin[1]);		//y
	write_coord(origin[2]);		//z
	write_byte(125);		//visible distance
	write_byte(get_pcvar_num(pcvar[CRED]));		//red
	write_byte(get_pcvar_num(pcvar[CGREEN]));			//green
	write_byte(get_pcvar_num(pcvar[CBLUE]));			//blue
	write_byte(5);			//life in deciseconds (0.1's)
	write_byte(10);			//distance flicker (decay rate)
	message_end();
	
	set_task(0.1, "set_user_vision", TASK_VISION+id)
	
	return PLUGIN_CONTINUE;
}

public begin(id) {
	if(!get_pcvar_num(pcvar[CMOD])) return PLUGIN_CONTINUE;
	
	for(new i = 1; i < MAXPLAYERS; i++) {
		if(is_user_connected(i)) {
			cs_set_user_team(i, CS_TEAM_CT, CS_CT_GIGN);
			cs_set_user_nvg(i, 0);
		}
	}
	cs_set_user_team(id, CS_TEAM_T, CS_DONTCHANGE);
	cs_set_user_model(monster, "monster");
	
	selected = true;
	restart_round();
	
	return PLUGIN_CONTINUE;
}

public Event_CurWeapon(id) {
	if(!get_pcvar_num(pcvar[CMOD])) return PLUGIN_CONTINUE;

	if(id != monster) return PLUGIN_CONTINUE;
    
	set_user_maxspeed(id, get_user_maxspeed(id)+get_pcvar_float(pcvar[CSPEED]));

	new WeaponActive = read_data(1);
	new wpnid = read_data(2);

	if (!WeaponActive)
		return PLUGIN_CONTINUE;
        
	if(wpnid != CSW_KNIFE) {
		engclient_cmd(id, "weapon_knife");
		set_pev(monster, pev_viewmodel, engfunc(EngFunc_AllocString, claws))
	}

	return PLUGIN_CONTINUE;
} 

public Event_Damage(id) {
	if(!get_pcvar_num(pcvar[CMOD])) return PLUGIN_CONTINUE;
	
	new weapon, bodypart, attacker = get_user_attacker(id, weapon, bodypart);
	if(attacker != monster) return PLUGIN_CONTINUE;
	
	new damage = read_data(2);
	
	if(is_user_alive(id) && is_user_alive(attacker)) {
		new XtraDmg = floatround((damage * get_pcvar_float(pcvar[CDAMAGE])) - damage);
		if(get_user_health(id)-XtraDmg <= 0) {
			gKilledByMonster = true;
			set_task(0.3, "fix_scores", id);
		}
			
		set_user_health(id, get_user_health(id)-XtraDmg);
	}
	return PLUGIN_CONTINUE;
}

public msg_Death() {
	if(gKilledByMonster) {
		gKilledByMonster = false;
		set_msg_arg_int(1, 1, monster);
		set_msg_arg_string(4, "knife");
		empty_hunger_bar();
	}
	return PLUGIN_CONTINUE;
}

public Event_Death() {
	if(!get_pcvar_num(pcvar[CMOD])) return PLUGIN_CONTINUE;
	
	new killer = read_data(1);
	new victim = read_data(2);
	
	if(killer == monster)
		empty_hunger_bar();
	
	if(victim == monster) {
		set_user_rendering(monster);
		remove_task(TASK_VISION+monster);
		remove_task(TASK_REGEN+monster);
		remove_task(TASK_INVIS+monster);
		
		cs_reset_user_model(monster);
		set_pev(monster, pev_viewmodel, engfunc(EngFunc_AllocString, knife));
		
		empty_hunger_bar();
		
		cs_set_user_team(monster, CS_TEAM_CT, CS_CT_GIGN);

		monster = killer;
		
		cs_set_user_team(monster, CS_TEAM_T, CS_T_TERROR);
		cs_set_user_model(monster, "monster");
		set_pev(monster,pev_viewmodel, engfunc(EngFunc_AllocString, claws));
		
		if(get_pcvar_num(pcvar[CLIGHTS]))
			set_user_vision(monster);
		
		new name[32];
		get_user_name(killer, name, 31);
		
		client_print(0, print_center, "A Monster meghalt! %s az uj Monster!", name);
	} else if(get_pcvar_num(pcvar[CLIGHTS])) set_user_vision(victim);
	return PLUGIN_CONTINUE;
}

public fix_scores(victim) {
	set_pev(victim, pev_frags, pev(victim, pev_frags)+1.0);
	set_pev(monster, pev_frags, pev(monster, pev_frags)+1.0);
	
	// Update killers scorboard with new info
	message_begin(MSG_ALL, get_user_msgid("ScoreInfo"))
	write_byte(monster)
	write_short(get_user_frags(monster))
	write_short(get_user_deaths(monster))
	write_short(0)
	write_short(get_user_team(monster))
	message_end()
		
	// Update victims scoreboard with correct info
	message_begin(MSG_ALL, get_user_msgid("ScoreInfo"))
	write_byte(victim)
	write_short(get_user_frags(victim))
	write_short(get_user_deaths(victim))
	write_short(0)
	write_short(get_user_team(victim))
	message_end()
}

public Event_NewRound() {	
	if(!get_pcvar_num(pcvar[CMOD])) return PLUGIN_CONTINUE;
	
	told = 0;
	if(!selected) return PLUGIN_CONTINUE;
	if(!is_user_connected(monster) || !is_user_alive(monster)) return PLUGIN_CONTINUE;

	if(cs_get_user_team(monster) != CS_TEAM_T) cs_set_user_team(monster, CS_TEAM_T);
	
	new num = get_playersnum(1);
	
	if(!get_pcvar_num(pcvar[CALC])) {
		maxhealth = (25*num)+100;
		maxarmor = (25*num)+100;
	} else {
		maxhealth = get_pcvar_num(pcvar[CALC]);
		maxarmor = get_pcvar_num(pcvar[CALC]);
	}
	
	set_user_health(monster, maxhealth);
	set_user_armor(monster, maxarmor);
	
	cs_set_user_model(monster, "monster");
	
	if(get_pcvar_num(pcvar[CLIGHTS])) {
		if(!task_exists(monster+TASK_VISION))
			set_user_vision(monster);
	} else if(task_exists(monster+TASK_VISION)) remove_task(TASK_VISION+monster);
	
	set_user_maxspeed(monster, get_user_maxspeed(monster)+get_pcvar_float(pcvar[CSPEED]));
	set_user_gravity(monster, get_pcvar_float(pcvar[CGRAV]));
	
	strip_user_weapons(monster);
	give_item(monster, "weapon_knife");
	
	set_pev(monster, pev_viewmodel, engfunc(EngFunc_AllocString, claws));
	
	set_task(1.0, "sm_regen_loop", TASK_REGEN);
	set_task(random_float(3.0, 14.0), "sm_invis_loop", TASK_INVIS);
	
	for(new i = 1; i < MAXPLAYERS; i++) {
		if(is_user_connected(i)) {
			if((i != monster && cs_get_user_team(i) != CS_TEAM_SPECTATOR) && task_exists(i+TASK_VISION)) remove_task(i+TASK_VISION);
			
			if(cs_get_user_team(i) == CS_TEAM_T || cs_get_user_team(i) == CS_TEAM_UNASSIGNED) {
				if(i != monster) {
					cs_set_user_team(i, CS_TEAM_CT, CS_CT_GIGN);
				}
			}
		}
	}
	empty_hunger_bar();
	
	return PLUGIN_CONTINUE;
}
	
public restart_round() {
	if(!get_pcvar_num(pcvar[CMOD])) return PLUGIN_CONTINUE;

	server_cmd("sv_restartround 1");
	
	return PLUGIN_CONTINUE;
}

public _NightVision(id) {
	if(!get_pcvar_num(pcvar[CMOD])) return PLUGIN_CONTINUE;
	
	return PLUGIN_HANDLED;
}

public event_team_info() {
	if(!get_pcvar_num(pcvar[CMOD])) return PLUGIN_CONTINUE;
	
	new id = read_data(1);
        
	new team[12];
	read_data(2, team, sizeof team - 1);
    
	switch(team[0]) {
		case 'C' :  return PLUGIN_CONTINUE;
		case 'T' :  {
			if(id != monster) {
				cs_set_user_team(id, CS_TEAM_CT, CS_CT_GIGN);
			}
		}
		case 'S' : if(get_pcvar_num(pcvar[CLIGHTS]))  set_user_vision(id);
	}
	return PLUGIN_CONTINUE;
}

public empty_hunger_bar() {
	//takes there status bar and makes it finish
	message_begin(MSG_ONE, get_user_msgid("BarTime"), {0,0,0}, monster);
	write_byte(0);
	write_byte(0);
	message_end();
	
	if(!get_pcvar_num(pcvar[CMOD])) return PLUGIN_CONTINUE;
	
	//starts a new one!
	message_begin(MSG_ONE, get_user_msgid("BarTime"), {0,0,0}, monster);
	write_byte(get_pcvar_num(pcvar[CTIME]));
	write_byte(0);
	message_end(); 
	
	cached_gametime = get_systime();
	
	told = 0;
	return PLUGIN_CONTINUE;
}

public client_PreThink(id) {
	if(!get_pcvar_num(pcvar[CMOD])) return PLUGIN_CONTINUE;
	
	if(id != monster) return PLUGIN_CONTINUE;
	
	curr_gametime = get_systime();
	new passed = curr_gametime-cached_gametime;
	new left = get_pcvar_num(pcvar[CTIME])-passed;
	
	switch(told) {
		case 0: {
			if(left <= get_pcvar_num(pcvar[CTIME])/2 && left > get_pcvar_num(pcvar[CTIME])/4) {
				client_print(monster, print_center, "You must eat soon!!");
				told = 1;
			}
		}
		case 1: {
			if(left <= get_pcvar_num(pcvar[CTIME])/4 && left > 0) {
				client_print(monster, print_center, "Te vagy a HALAL!!");
				told = 2;
			}
		}
		case 2: {
			if(left <= 0) {
				told = 0;
				client_print(monster, print_center, "Ehen haltal...");
				user_kill(monster);
				
				remove_task(TASK_VISION+monster);
				remove_task(TASK_REGEN+monster);
				remove_task(TASK_INVIS+monster);
				set_user_rendering(monster);
				
				empty_hunger_bar();
			
				cs_set_user_team(monster, CS_TEAM_CT, CS_CT_GIGN);
				
				cs_reset_user_model(monster);
				set_pev(monster, pev_viewmodel, engfunc(EngFunc_AllocString, knife));
				
				client_print(0, print_chat, "[MM] A Monster Ehenhalt!! A kovetkezo 2 masodperc mulva kivalasztodik!");
				set_task(2.0, "choose_monster", TASK_CHOOSE);
			}
		}
	}
	return PLUGIN_CONTINUE;
}

public client_disconnect(id) {
	if(id == monster) {
		_choose_monster();
	}
}

//To block Objectives...From gungame!

// block hostages from appearing on radar if we disabled objectives
public message_hostagepos(msg_id,msg_dest,msg_entity) {
	if(!get_pcvar_num(pcvar[COBJEC]))
		return PLUGIN_CONTINUE;

	return PLUGIN_HANDLED;
}

// block dropped the bomb message if we disabled objectives
public message_textmsg(msg_id,msg_dest,msg_entity) {
	if(!bombMap || !get_pcvar_num(pcvar[COBJEC]))
		return PLUGIN_CONTINUE;

	static message[16];
	get_msg_arg_string(2, message, 15);

	if(equal(message,"#Game_bomb_drop"))
		return PLUGIN_HANDLED;

	return PLUGIN_CONTINUE;
}

// block c4 ammo message if we disabled objectives
public message_ammopickup(msg_id,msg_dest,msg_entity) {
	if(!bombMap || !get_pcvar_num(pcvar[COBJEC]))
		return PLUGIN_CONTINUE;

	if(get_msg_arg_int(1) == 14) // C4
		return PLUGIN_HANDLED;

	return PLUGIN_CONTINUE;
}

// remove c4 if we disabled objectives
public message_weappickup(msg_id,msg_dest,msg_entity) {
	if(!bombMap || !get_pcvar_num(pcvar[COBJEC]))
		return PLUGIN_CONTINUE;

	if(get_msg_arg_int(1) == CSW_C4) {
		set_task(0.1, "strip_c4", msg_entity);
		return PLUGIN_HANDLED;
	}

	return PLUGIN_CONTINUE;
 }

public message_bombdrop(msg_id,msg_dest,msg_entity) {
	if(!get_pcvar_num(pcvar[COBJEC]))
		return PLUGIN_HANDLED;

	return PLUGIN_CONTINUE;
}

public message_scenario(msg_id,msg_dest,msg_entity) {
	// block hostage display if we disabled objectives
	if(get_msg_args() > 1 && get_pcvar_num(pcvar[COBJEC])) {
		new sprite[8];
		get_msg_arg_string(2, sprite, 7);

		if(equal(sprite,"hostage"))
			return PLUGIN_HANDLED;
	}

	return PLUGIN_CONTINUE;
}

// move the hostages so that CTs can't get to them
public move_hostages() {
	new ent;
	while((ent = fm_find_ent_by_class(ent,"hostage_entity")) != 0)
		set_pev(ent, pev_origin, Float:{8192.0,8192.0,8192.0});
}

// delay, since weappickup is slightly before we actually get the weapon
public strip_c4(id) {
	fm_strip_user_gun(id, CSW_C4);
}
