/*================================================================================

	Deagle Sniper
	Copyright (C) 2009 by fezh
	
	This program is free software: you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation, either version 3 of the License, or
	(at your option) any later version.
	
	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.
	
	You should have received a copy of the GNU General Public License
	along with this program.  If not, see <http://www.gnu.org/licenses/>.
	
	In addition, as a special exception, the author gives permission to
	link the code of this program with the Half-Life Game Engine ("HL
	Engine") and Modified Game Libraries ("MODs") developed by Valve,
	L.L.C ("Valve"). You must obey the GNU General Public License in all
	respects for all of the code used other than the HL Engine and MODs
	from Valve. If you modify this file, you may extend this exception
	to your version of the file, but you are not obligated to do so. If
	you do not wish to do so, delete this exception statement from your
	version.

=================================================================================*/

#include <amxmodx>
#include <fakemeta>
#include <hamsandwich>

#define PLUGIN_VERSION "0.1.3"

const m_iFOV = 363
const m_iPlayer = 41
const m_iClipAmmo = 51
const m_iExtraOffsetLinux = 4
const m_iExtraOffsetWindows = 0

#pragma semicolon 1

new model_deagle_sniper[] = "models/v_deagle_new.mdl";

new gAlive[33];
new gZoom[33];
new gReloading[33];

public plugin_precache()
	engfunc(EngFunc_PrecacheModel, model_deagle_sniper);

public plugin_init()
{
	register_plugin("Deagle Sniper", PLUGIN_VERSION, "fezh");

	register_forward(FM_CmdStart, "fwCmdStart");

	RegisterHam(Ham_Spawn, "player", "fwPlayerSpawnPost", 1);
	RegisterHam(Ham_Killed, "player", "fwPlayerKilled");
	RegisterHam(Ham_Weapon_Reload, "weapon_deagle", "fwWeaponReload");
	RegisterHam(Ham_Item_Deploy, "weapon_deagle", "fwItemDeployPost", 1);

	register_cvar("deagle_sniper", PLUGIN_VERSION, FCVAR_SERVER|FCVAR_SPONLY);
}

public fwCmdStart(id, uc_handle, seed)
{
	if (!gAlive[id]) return FMRES_IGNORED;

	static button, oldbuttons, weapon;
	button = get_uc(uc_handle, UC_Buttons);
	oldbuttons = pev(id, pev_oldbuttons);
	weapon = get_user_weapon(id);

	if ((button & IN_ATTACK2) && !(oldbuttons & IN_ATTACK2))
	{
		if (weapon == CSW_DEAGLE)
		{
			if (!gZoom[id] && !gReloading[id])
			{
				gZoom[id] = true;
				set_pdata_int(id, m_iFOV, 35, 5);
				emit_sound(id, CHAN_ITEM, "weapons/zoom.wav", 0.20, 2.40, 0, 100);
			}
			else
			{
				if (gZoom[id])
				{
					gZoom[id] = false;
					set_pdata_int(id, m_iFOV, 90, 5);
				}
			}
		}
	}
	return FMRES_IGNORED;
}

public fwPlayerSpawnPost(id) if (is_user_alive(id)) gAlive[id] = true;

public fwPlayerKilled(victim, attacker, shouldgib) gAlive[victim] = false;

public fwWeaponReload(weapon)
{
	if (fm_get_weapon_ammo(weapon) != 7)
	{
		static id;
		id = get_pdata_cbase(weapon, m_iPlayer, 4);

		set_pdata_int(id, m_iFOV, 90, 5);

		gReloading[id] = true;
		set_task(2.3, "taskWeaponReloaded", id);
	}
}

public taskWeaponReloaded(id)
	gReloading[id] = false;

public fwItemDeployPost(weapon)
{
	static id;
	id = get_pdata_cbase(weapon, m_iPlayer, 4);

	set_pev(id, pev_viewmodel2, model_deagle_sniper);
}

// cs_to_fm
stock fm_get_weapon_ammo(weapon)
	return get_pdata_int(weapon, m_iClipAmmo, is_linux_server() ? m_iExtraOffsetLinux : m_iExtraOffsetWindows);