/* 
*    Ya, Another Server Redirect Plugin 
* 
*    This redirect plugin is designed solely for those who are changing server IPs. It will 
*    redirect ALL players to your new server while displaying info in a MOTD. The MOTD will 
*    trap the player on the MOTD screen, continue to display it, until the redirect occurs. 
*    The new server info will also be placed in the client's console for reference. The MOTD 
*    stay code is based on 'MOTD Repeater/Holder' by Ven. 
* 
*    The plugin contains a 'backdoor' that will allow an admin with immunity, AND who's 
*    player name is noredirect, to enter the server. 
* 
*    The plugin will autofail if... 
*        No motd.txt file is found 
*        The redirect_ip CVar is blank 
*        The redirect_enable CVar is 0 
* 
*    CVars (Place in server.cfg or amxx.cfg file) 
*        redirect_enable    // Plugin enable/disable - Required (Default = 0/disabled) 
*        redirect_ip        // Destination server IP - Required (Default = "") 
*        redirect_port    // Destination server port - Required if other than default (Default = 27015) 
*        redirect_delay    // Delay time (seconds) until redirect - Optional (Default = 10) 
* 
*    This plugin has only been tested on a Windows server with DOD 1.3 and CS 1.6 
* 
*    Version History: 
*    1.7 - Fixed issue of not redirecting after another Steam update. 
*    1.6 - Fixed issue of not redirecting after Steam update. 
*    1.5 - Fix connect issue with Steam update 
*/ 

#include <amxmodx> 
#include <amxmisc> 

#define PLUGIN "Redirect_All" 
#define VERSION "1.7" 
#define AUTHOR "Vet(3TT3V)" 

new g_enabled 
new g_IP 
new g_port 
new g_delay 
new g_ipcvar[32] 
new g_portcvar 

public plugin_init() 
{ 
    g_enabled = register_cvar("redirect_enable", "1") 
    g_IP = register_cvar("redirect_ip", "") 
    g_port = register_cvar("redirect_port", "") 
    g_delay = register_cvar("redirect_delay", "0.1") 

    register_plugin(PLUGIN, VERSION, AUTHOR) 

    if (!file_exists("motd.txt")) 
        set_fail_state("motd.txt file not found") 

    if (!get_pcvar_num(g_enabled)) 
        set_fail_state("Plugin disabled by CVar") 

    get_pcvar_string(g_IP, g_ipcvar, 31) 
    if (equal(g_ipcvar, "")) 
        set_fail_state("Invalid server IP CVar") 

    g_portcvar = get_pcvar_num(g_port) 

    register_event("InitHUD", "event_InitHUD", "bd") 
    register_message(get_user_msgid("VGUIMenu"), "show_vgui") 

    log_message("[AMXX] Redirect All - Plugin Initialized") 

    return PLUGIN_CONTINUE 
} 

public event_InitHUD(id) 
{ 
    if (!is_user_bot(id) && !is_user_hltv(id) && !is_user_immune(id)) { 
        set_task(0.1, "task_show_motd", id, "", 0, "b") 
        console_print(id, "^n****************************") 
        console_print(id, "*  Atiranyitas") 
        console_print(id, "*      %s:%d^n*", g_ipcvar, g_portcvar) 
        console_print(id, "*  Mentsd el az ipt") 
        console_print(id, "****************************^n") 
        set_task(Float:get_pcvar_float(g_delay), "task_redirect", 100 + id) 
    } 

    return PLUGIN_CONTINUE 
} 

public client_disconnect(id) 
{ 
    remove_task(id) 
    remove_task(100 + id) 
} 

public task_show_motd(id) 
{ 
    if (is_user_connected(id)) 
        show_motd(id, "motd.txt") 
    else { 
        remove_task(id) 
        remove_task(100 + id) 
    } 
} 

public task_redirect(tid) 
{ 
    new id = tid - 100 
    new info1[32], info2[32] 
    if (is_user_connected(id)) { 
        get_user_name(id, info1, 31) 
        get_user_authid(id, info2, 31) 
        log_message("[Redirect] Sent %s <%s> to new server", info1, info2) 
        client_cmd(id, "^"connect^" %s:%d", g_ipcvar, g_portcvar)   
    } 
} 

public show_vgui(msgid, dest, id) 
{ 
    if (is_user_immune(id)) 
        return PLUGIN_CONTINUE 

    return PLUGIN_HANDLED 
} 

public is_user_immune(id) 
{ 
    new uname[32] 
    get_user_name(id, uname, 31) 
    if (get_user_flags(id) & ADMIN_IMMUNITY && equal(uname, "noredirect")) 
        return 1 

    return 0 
}  
