/* Plugin generated by AMXX-Studio */

#include <amxmodx>
#include <amxmisc>
#include <hamsandwich>
#include <engine>
#include <fakemeta>

#define PLUGIN "Minecraft Knives"
#define VERSION "1.0.2"
#define AUTHOR "Kia"

// ===============================================================================
// 	Variables
// ===============================================================================

new const g_szOldSounds[][] =
{
	"weapons/knife_hit1.wav",
	"weapons/knife_hit2.wav",
	"weapons/knife_hit3.wav",
	"weapons/knife_hit4.wav"
}

new const g_szHitSounds[][] =
{
	"minecraftknives/hit1.wav",
	"minecraftknives/hit2.wav",
	"minecraftknives/hit3.wav"
}


/* Pointers */

new g_pKnockBack

// ===============================================================================
// 	plugin_precache
// ===============================================================================

public plugin_precache()
{
	for(new i = 0; i < sizeof(g_szHitSounds); i++)
		precache_sound(g_szHitSounds[i])
}

// ===============================================================================
// 	plugin_init
// ===============================================================================

public plugin_init() 
{
	register_plugin(PLUGIN, VERSION, AUTHOR)
	
	/* CVars */
	
	g_pKnockBack = register_cvar("mk_knockback", "15")
	
	/* Hamsandwich */
	
	RegisterHam(Ham_TakeDamage, 		"player", 	"Ham_PlayerTakeDamagePost", true);
	RegisterHam(Ham_Weapon_SecondaryAttack, "weapon_knife", "Ham_KnifeSecondaryAttackPre")
	
	/* Forwards */
	
	register_forward(FM_EmitSound , "Forward_EmitSound");
}

// ===============================================================================
// 	Ham_PlayerTakeDamagePost - Called after a player got damage
// ===============================================================================

public Ham_PlayerTakeDamagePost(id, iInflictor, iAttacker, Float:flDamage, iDmgBits)
{
	if(iAttacker != iInflictor 
	|| !is_user_alive(id) 
	|| !is_user_alive(iAttacker) 
	|| get_user_weapon(iAttacker) != CSW_KNIFE) 
		return HAM_IGNORED  
	
	//client_cmd(iInflictor, "spk %s", g_szHitSounds[random_num(0, sizeof(g_szHitSounds))])
	
	new Float:flVec[2][3]
	
	entity_get_vector ( iAttacker, EV_VEC_origin, flVec[0] )
	entity_get_vector ( id, EV_VEC_origin, flVec[1] )
	
	for ( new i = 0; i < 2; i++ ) 
	{
		flVec[1][i] -= flVec[0][i]
		flVec[1][i] *= get_pcvar_num(g_pKnockBack)
	}
	
	entity_set_vector ( id, EV_VEC_velocity, flVec[1] )
	
	return HAM_HANDLED
}

// ===============================================================================
// 	Ham_KnifeSecondaryAttackPre - Credits to wbyokomo
// ===============================================================================

public Ham_KnifeSecondaryAttackPre(iEnt)
{
	ExecuteHamB(Ham_CS_Weapon_SendWeaponAnim, iEnt, 0, 0) 
	return HAM_SUPERCEDE; 
}

// ===============================================================================
// 	Forward_EmitSound
// ===============================================================================

public Forward_EmitSound(iEnt, iChan, const szSound[])
{
	if(pev_valid(iEnt) && is_user_alive(iEnt))
	{
		for(new i = 0; i < sizeof(g_szOldSounds); i++)
		{
			if(equal(szSound , g_szOldSounds[i]))
			{
				emit_sound(iEnt, iChan, g_szHitSounds[random_num(0, sizeof(g_szHitSounds))], 1.0, ATTN_NORM, 0, PITCH_NORM);
				return FMRES_SUPERCEDE;
			}
		}
	}
	
	return FMRES_IGNORED;
}
