#include <amxmodx>
#include <amxmisc>
#include <nvault>
#include <hamsandwich>
#include <fun>
#include <colorchat>

#pragma semicolon 1

new const PLUGIN_NAME[] = "Euro System";
new const VERSION_PLUGIN[] = "1.0";
new const AUTOR_NAME[] = "GhosT ***";

new EuroPlayer[32];
new g_vault;

new HeadShotKill_Euro;
new NormalKill_Euro;

public plugin_cfg()
{
	get_pcvar_num(HeadShotKill_Euro);
	get_pcvar_num(NormalKill_Euro);
}

public plugin_init()
{
	register_plugin(PLUGIN_NAME, VERSION_PLUGIN, AUTOR_NAME);
	
	register_clcmd("say /euro", "ShowEuroInfo");
	register_clcmd("say_team /euro", "ShowEuroInfo");
	
	register_event("DeathMsg", "DeathMsg", "a");
	
	register_concmd("amx_euro", "_euro");
	register_concmd("amx_give_euro", "_give_euro", ADMIN_MENU, "<nume> <Amount>");
	register_concmd("amx_take_euro", "_take_euro", ADMIN_MENU, "<nume> <Amount>");
	
	g_vault = nvault_open("EuroSystem");
	
	HeadShotKill_Euro = register_cvar("HsKill_Euro", "50");
	NormalKill_Euro = register_cvar("NormalKill_Euro", "30");
}
public client_putinserver(id)
{
	LoadEuro(id);
	
	set_task(5.0, "ShowMessage", id);
}
public client_disconnect(id)
{
	SaveEuro(id);
}
public SaveEuro(id)
{
	new name[32];
	get_user_name(id,name,31);
	
	new vaultkey[64],vaultdata[256]; 
	format(vaultkey,63,"%s-Euro",name);  
	format(vaultdata,255,"%i ", EuroPlayer[id]);
	
	nvault_set(g_vault,vaultkey,vaultdata);
}
public LoadEuro(id)
{
	new name[32];
	get_user_name(id, name, 31);
	
	new vaultkey[64], vaultdata[256];
	format(vaultkey, 63, "%s-Euro", name);
	format(vaultdata, 255, "%i ", EuroPlayer[id]);
	
	nvault_get(g_vault,vaultkey,vaultdata,255);
	
	new PlayerEuro[32];
	parse(vaultdata, PlayerEuro, 31);
	
	EuroPlayer[id] = str_to_num(PlayerEuro);
}
public plugin_natives()
{
	register_library( "es" );
	register_native("get_user_euro", "_get_user_Euro");
	register_native("set_user_euro", "_set_user_Euro");
}
public _get_user_Euro(Plugin, Params)
{
	return EuroPlayer[get_param(1)];
}
public _set_user_Euro(Plugin, Params)
{
	new id = get_param(1);
	EuroPlayer[id] = max(0, get_param(2));
	SaveEuro(id);
	return EuroPlayer[id];
}
native get_user_euro(index);
native set_user_euro(index, amount);

public ShowEuroInfo(id)
{
	ColorChat(id, RED, "^x04 [EURO]^x01 Neked ennyi ^x03 %i^x01 eurod van !", get_user_euro(id));
	return 1;
}
public DeathMsg(iWpnIndex)
{
	new headshot = read_data(3);
	new Victim = read_data(2);
	new iAttacker = read_data(1);
	
	if(iAttacker == Victim)
		return PLUGIN_HANDLED;
		
	else if(headshot)
		set_user_euro(iAttacker, get_user_euro(iAttacker) + get_pcvar_num(HeadShotKill_Euro));

	else
		set_user_euro(iAttacker, get_user_euro(iAttacker) + get_pcvar_num(NormalKill_Euro));
	
	return PLUGIN_CONTINUE;
}
public _euro(id)
{
	new target_name[32];
	
	read_argv(1, target_name, 31);
	
	if(equal(target_name, ""))
	{
		console_print(id, "amx_euro <nick>");
		return 1;
	}
	
	new iPlayer = cmd_target(id, target_name, CMDTARGET_ALLOW_SELF);
	if(!iPlayer)
	{
		console_print(id, "Nincs ilyen nev !");
		return 1;
	}
	
	new Player_Name[32];
	get_user_name(iPlayer, Player_Name, 31);
	
	console_print(id, "Player %s have %i euro !", Player_Name, get_user_euro(iPlayer));
	return 1;
}
public _give_euro(id)
{
	if(get_user_flags(id) & ADMIN_MENU)
	{
		new target_name[32];
		new Amount[10];
		
		read_argv(1, target_name, 31);
		read_argv(2, Amount, 9);
		
		if(equal(target_name, "") || equal(Amount, ""))
		{
			console_print(id, "amx_give_euro <nick> <amount>");
			return 1;
		}
		
		new Euro = str_to_num(Amount);
		
		if(Euro <= 0)
		{
			console_print(id, "0-nal nagyobbnak kell hogy legyen !");
			return 1;
		}
		
		new iPlayer = cmd_target(id, target_name, CMDTARGET_ALLOW_SELF);
		
		if(!iPlayer)
		{
			console_print(id, "Ervenytelen !");
			return 1;
		}
		
		set_user_euro(iPlayer, get_user_euro(iPlayer) + Euro);
		
		new Admin_Name[32];
		new Player_Name[32];
		
		get_user_name(id, Admin_Name, 31);
		get_user_name(iPlayer, Player_Name, 31);
		
		ColorChat(id, RED, "^x04 ADMIN: %s^x01 adott ^x03 %d Eurot^x01 to^x04 %s^x01 !", Admin_Name, Euro, Player_Name);
		
		return 1;
	}
	else
	{
		console_print(id, "Te nemtudod hasznalni ezt a parancsot!");
		return 1;
	}
	
	return 1;
}
public _take_euro(id)
{
	if(get_user_flags(id) & ADMIN_MENU)
	{
		new target_name[32];
		new Amount[10];
		
		read_argv(1, target_name, 31);
		read_argv(2, Amount, 9);
		
		if(equal(target_name, "") || equal(Amount, ""))
		{
			console_print(id, "amx_take_euro <nick> <amount>");
			return 1;
		}
		
		new Euro = str_to_num(Amount);
		
		if(Euro <= 0)
		{
			console_print(id, "0-nal nagyobbnak kell hogy legyen !");
			return 1;
		}
		
		new iPlayer = cmd_target(id, target_name, 8);
		
		if(!iPlayer)
		{
			console_print(id, "Nincs ilyen jatekos !");
			return 1;
		}
		if(get_user_euro(iPlayer) < Euro)
		{
			console_print(id, "Jatekos %s mindenkinek %i Eurot !", target_name, get_user_euro(iPlayer));
			return 1;
		}
		
		set_user_euro(iPlayer, get_user_euro(iPlayer) - Euro);
		
		new Admin_Name[32];
		new Player_Name[32];
		
		get_user_name(id, Admin_Name, 31);
		get_user_name(iPlayer, Player_Name, 31);
		
		ColorChat(id, RED, "^x04 ADMIN: %s^x01 elvett ennyi ^x03 %d Eurot^x01 to^x04 %s^x01 !", Admin_Name, Euro, Player_Name);
		
		return 1;
	}
	else
	{
		console_print(id, "Nem tudod hasznalni ezt a parancsot !");
		return 1;
	}
	
	return 1;
}
/* AMXX-Studio Notes - DO NOT MODIFY BELOW HERE
*{\\ rtf1\\ ansi\\ deff0{\\ fonttbl{\\ f0\\ fnil Tahoma;}}\n\\ viewkind4\\ uc1\\ pard\\ lang1033\\ f0\\ fs16 \n\\ par }
*/
