#if defined _euro_system_included
	#endinput
#endif

#define _euro_system_included
 
//==========================================================================================
 
native get_user_euro(index);

/*
 * Returns a players euro
 * 
 * @param		index - The player index to get euro
 * 
 * @return		The Euro of client
 * 
 */
 
//==========================================================================================

native set_user_euro(index, amount);
 
/*
 * Sets <euro> to player
 * 
 * @param		index - The player index to set euro
 * @param		amount - The amount of euro to set to player
 * 
 * @return		The Euro of client
 * 
 */
 
//==========================================================================================

stock add_user_euro(index, amount)
{
	return set_user_euro(index, get_user_euro(index) + amount);
}
 
/*
 * Add <euro> to player
 * 
 * @param		index - The player index to add euro
 * @param		amount - The amount of euro to add to player
 * 
 * @return		The Euro of client
 * 
 */

//==========================================================================================
 
stock remove_user_euro(index, amount)
{
	return set_user_euro(index, get_user_euro(index) - credits);
}
 
/*
 * Remove <euro> from player
 * 
 * @param		index - The player index to remove euro
 * @param		amount - The amount of euro to remove to player
 * 
 * @return		The Euro of client
 * 
 */

//==========================================================================================
 
stock strip_user_euro(index)
{
	return set_user_euro(index, 0);
}
 
/*
 * Strip <euro> from player
 * 
 * @param		index - The player index to strip euro
 * 
 * @return		The Euro of client
 * 
 */
 
//==========================================================================================
/* AMXX-Studio Notes - DO NOT MODIFY BELOW HERE
*{\\ rtf1\\ ansi\\ deff0{\\ fonttbl{\\ f0\\ fnil Tahoma;}}\n\\ viewkind4\\ uc1\\ pard\\ lang1033\\ f0\\ fs16 \n\\ par }
*/
