// D2LoD client console commands

public clcmd_changetm(id)
{
	if ( g_iLogged[id] )
	{
		main_mod_menu(id);
	}
	else
	{
		main_hero_menu_connect(id);
	}

	return PLUGIN_HANDLED;
}
public handle_say(id)
{
	if ( !g_iLogged[id] )
		return PLUGIN_HANDLED;

	static Text[32]
	read_args( Text, charsmax(Text) );

	remove_quotes(Text)

	static szArg1[32], szArg2[32];
	parse(Text, szArg1, charsmax(szArg1), szArg2, charsmax(szArg2))

	new Value = str_to_num(szArg2)

	if( equali( szArg1, "/deposit") )
	{
		if ( !native_get_p_near_inventory(id) )
		{
			client_print(id, print_chat, "You must be near inventory to do some actions!")
			return PLUGIN_HANDLED;
		}

		if(szArg2[0] == '-') 
		{
			client_print(id, print_chat, "You can't have a '-' in the value!")
			return PLUGIN_HANDLED;
		}

		if ( Value > g_Coins[id][g_CurrentChar[id]] )
		{
			client_print(id, print_chat, "You don't have much gold!")
			return PLUGIN_HANDLED;
		}

		if ( Value > MAX_PLAYER_MONEY_INV[g_PlayerLevel[id][g_CurrentChar[id]]] )
		{
			client_print(id, print_chat, "You can't deposit so much gold!")
			return PLUGIN_HANDLED;
		}

		client_printcolor(id, "/g%d /ygold deposited!", Value)
		Set_Player_Coins(id, g_Coins[id][g_CurrentChar[id]] - Value);
		Set_Player_CoinsInv(id, g_CoinsInv[id][g_CurrentChar[id]] + Value);

		return PLUGIN_HANDLED;
	}
	else if ( equali( szArg1, "/withdraw") )
	{
		if ( !native_get_p_near_inventory(id) )
		{
			client_print(id, print_chat, "You must be near inventory to do some actions!")
			return PLUGIN_HANDLED;
		}

		if(szArg2[0] == '-') 
		{
			client_print(id, print_chat, "You can't have a '-' in the value!")
			return PLUGIN_HANDLED;
		}

		if ( Value > g_CoinsInv[id][g_CurrentChar[id]] )
		{
			client_print(id, print_chat, "You don't have much gold in inventory!")
			return PLUGIN_HANDLED;
		}

		if ( Value > MAX_PLAYER_MONEY[g_PlayerLevel[id][g_CurrentChar[id]]] )
		{
			client_print(id, print_chat, "You can't withdraw so much gold from inventory!")	
			return PLUGIN_HANDLED;
		}

		client_printcolor(id, "/g%d /ygold withdraw!", Value)
		Set_Player_Coins(id, g_Coins[id][g_CurrentChar[id]] + Value);
		Set_Player_CoinsInv(id, g_CoinsInv[id][g_CurrentChar[id]] - Value);

		return PLUGIN_HANDLED;
	}

	return PLUGIN_CONTINUE;
}
public cmd_set_level(id, level, cid) 
{
	if( !cmd_access(id, level, cid, 3) )
	{
		return PLUGIN_HANDLED;
	}
	
	new Arg1[64], Target
	read_argv(1, Arg1, 63)
	Target = cmd_target(id, Arg1, 0)
	
	new iLevel[32], Value
	read_argv(2, iLevel, 31)
	Value = str_to_num(iLevel)
	
	if(iLevel[0] == '-') 
	{
		console_print(id, "You can't have a '-' in the value!")
		return PLUGIN_HANDLED;
	}
	
	if(!Target) 
	{
		console_print(id, "Target not found!")
		return PLUGIN_HANDLED;
	}

	if ( !g_iLogged[Target] )
	{
		console_print(id, "Target not logged!")
		return PLUGIN_HANDLED;
	}
	
	if(Value > MAX_LEVELS-1)
	{
		console_print(id, "You can't set a more than %d!", MAX_LEVELS-1)
		return PLUGIN_HANDLED;
	}
	
	if(Value < 1)
	{
		console_print(id, "You can't set less than 1!")
		return PLUGIN_HANDLED;
	}
	
	new AdminName[32]
	get_user_name(id, AdminName, 31)
		
	new TargetName[32]
	get_user_name(Target, TargetName, 31)
	
	g_PlayerLevel[Target][g_CurrentChar[Target]] = Value
	g_PlayerXp[Target][g_CurrentChar[Target]] = LEVELS[g_PlayerLevel[Target][g_CurrentChar[Target]]]
	
	g_PlayerStPoints[Target][g_CurrentChar[Target]] = get_pcvar_num(d2_stat_points_levelup) * g_PlayerLevel[Target][g_CurrentChar[Target]];

	g_PlayerSkPoints[Target][g_CurrentChar[Target]] = g_PlayerLevel[Target][g_CurrentChar[Target]];
	
	g_Dexterity[Target][g_CurrentChar[Target]] = 0;
	g_Strength[Target][g_CurrentChar[Target]] = 0;
	g_Vitality[Target][g_CurrentChar[Target]] = 0;
	g_Energy[Target][g_CurrentChar[Target]] = 0;

	for(new skill_id = 0; skill_id <= g_skillcounter ; skill_id++)
	{
		g_iSkills[Target][g_CurrentChar[Target]][skill_id] = 0; 
	}
	
	client_printcolor(Target, "/gADMIN: /ctr%s /yhas set your LEVEL to /g%d", AdminName, Value)

	return PLUGIN_HANDLED;
}
public cmd_set_gold(id, level, cid) 
{
	if( !cmd_access(id, level, cid, 3) )
	{
		return PLUGIN_HANDLED;
	}
	
	new Arg1[64], Target
	read_argv(1, Arg1, 63)
	Target = cmd_target(id, Arg1, 0)
	
	new iLevel[32], Value
	read_argv(2, iLevel, 31)
	Value = str_to_num(iLevel)
	
	if(iLevel[0] == '-') 
	{
		console_print(id, "You can't have a '-' in the value!")
		return PLUGIN_HANDLED;
	}
	
	if(!Target) 
	{
		console_print(id, "Target not found!")
		return PLUGIN_HANDLED;
	}

	if ( !g_iLogged[Target] )
	{
		console_print(id, "Target not logged!")
		return PLUGIN_HANDLED;
	}

	Set_Player_Coins(Target, Value);
	
	new AdminName[32]
	get_user_name(id, AdminName, 31)
		
	new TargetName[32]
	get_user_name(Target, TargetName, 31)
	
	client_printcolor(Target, "/gADMIN: /ctr%s /yhas set your GOLD to /g%d", AdminName, Value)

	return PLUGIN_HANDLED;
}
public show_top(id)
{
	if( !g_iLogged[id] )
		return;
	
	static Sort[33][2], SortStr[33][1][32];
	new players[32],num,count,index;
	get_players(players,num);
    
	for(new i = 0; i < num; i++)
	{
		index = players[i];
		
		if ( !g_iLogged[index] || g_iFakeplayer == index ) continue;
		
		Sort[count][0] = index;
		Sort[count][1] = g_PlayerLevel[index][g_CurrentChar[index]];
		formatex(SortStr[count][0], charsmax(SortStr[][]), "%s", HEROES[g_PlayerHero[index][g_CurrentChar[index]]]);
		count++;
	}
    
	SortCustom2D(Sort,count,"CompareLevel");
	//SortCustom2D(SortStr,count,"CompareLevel");
	new motd[1501],iLen;
	iLen = formatex(motd, sizeof motd - 1,"<body bgcolor=#000000><font color=#98f5ff><pre>");
	iLen += formatex(motd[iLen], (sizeof motd - 1) - iLen,"%s %-22.22s %-11.11s %s^n", "#", "Name", "# LvL", "# Hero");
    
	new y = clamp(count,0,32);
	new name[32],kindex;
    
	for(new x = 0; x < y; x++)
	{
		kindex = Sort[x][0];
		get_user_name(kindex,name,sizeof name - 1);
		iLen += formatex(motd[iLen], (sizeof motd - 1) - iLen,"%d %-22.22s %-11.11d %s^n", x + 1, name, Sort[x][1], SortStr[x][0]);
	}
	iLen += formatex(motd[iLen], (sizeof motd - 1) - iLen,"</body></font></pre>");
	show_motd(id,motd, "GunXpMod Top 20");
}
public CompareLevel(elem1[], elem2[])
{
    if(elem1[1] > elem2[1])
        return -1;
    else if(elem1[1] < elem2[1])
        return 1;
    
    return 0;
} 
public skill_handle(id)
{
	if ( !is_user_alive(id) || g_FreezeTime || !g_iLogged[id] )
		return PLUGIN_HANDLED;

	for (new skill_id = 0; skill_id <= g_skillcounter; skill_id++)
	{
		if ( g_PlayerHero[id][g_CurrentChar[id]] == g_skillhero[skill_id] )
			ExecuteForward( g_SkillFired, g_iReturn, id);
	}

	return PLUGIN_HANDLED;
}