// Cvars,pcvars,commands,functions

public LoadCvars()
{
	d2_save_type = register_cvar("d2_save_type", "0"); // Save Data type : 1 = MYSQL, 0 = Nvault.
	d2_save_by = register_cvar("d2_save_by", "1");// Save Data by : 0 = SteamID, 1 = IP, 2 = Name.

	mysqlx_host = register_cvar ("d2_host", ""); // The host from the db
	mysqlx_user = register_cvar ("d2_user", ""); // The username from the db login
	mysqlx_pass = register_cvar ("d2_pass", ""); // The password from the db login
	mysqlx_db = register_cvar ("d2_dbname", ""); // The database name 

	d2_xp_kill = register_cvar("d2_xp_kill","110"); // How much xp give each kill
	d2_3rdperson = register_cvar("d2_3rdperson","1"); // Enable 3RDPERSON view? 1 - Yes, 0 - No.

	d2_advert = register_cvar("d2_advertisement","1"); // Enable Advertisement? 1 - Yes, 0 - No.
	d2_advert_time = register_cvar("d2_adv_time","180.0"); // Every each time advertise? 

	d2_block_attack2 = register_cvar("d2_block_attack2","1"); // Block Knife Attack 2? 1 - Yes, 0 - No.

	d2_cl_corpsestay = register_cvar("d2_cl_corpsestay","5.000000"); // How long corpses stay on the ground, 1.000000 - 1 second.

	d2_max_random_value = register_cvar("d2_max_random","1000"); // What is max random value/chance to dodge,damage more player attacks
	d2_stat_points_levelup = register_cvar("d2_stat_points","5"); // How much stats points give on level up?
	d2_high_level = register_cvar("d2_high_level","90"); // If victims level 40 or more and higher than yours, it will give extra xp to attacker
	d2_high_level_xp = register_cvar("d2_high_level_xp","50"); // Give extra xp for killing high player level!

	d2_enable_respawn = register_cvar("d2_spawn","1"); // Enable respawning? 1 = yes,  0 = no.
	d2_spawn_cooldown = register_cvar("d2_spawn_cooldown","5"); // Respawn cooldown.
	d2_spawn_protection = register_cvar("d2_spawn_protection","1"); // Enable respawn protection? 1 = yes, 0 = no.
	d2_spawn_protection_time = register_cvar("d2_spawn_protection_time","4"); // Respawn protection time.

	d2_block_kill_command = register_cvar("d2_block_kill_command","1"); // Block "kill" command? 1 = yes, 0 = no.

	d2_show_damage = register_cvar("d2_show_damage","1"); // Show damage done?
	d2_show_damage_received = register_cvar("d2_show_damage_r","1"); // Show damage received?

	d2_minlevel_coins = register_cvar("d2_minlevel_drop_coins","5"); // Minimum level to drop coins.

	d2_minlevel_items = register_cvar("d2_minlevel_drop_item","20"); // Minimum level to drop items.
	d2_chance_to_drop = register_cvar("d2_chance_drop_item","2"); // X percents chance to drop item ( from 100 percents ).

	d2_bolts_value = register_cvar("d2_bolts_value","50"); // Crossbow's bolts value when buying.

	d2_minlevel_potions = register_cvar("d2_minlevel_drop_potion","8"); // Minimum level to drop potions.
	d2_chance_to_dropp = register_cvar("d2_chance_drop_potion","15"); // X percents chance to drop potion ( from 100 percents ).

	register_clcmd("say /d2menu","main_mod_menu");
	register_clcmd("say d2menu","main_mod_menu");

	register_clcmd("say /level","HUD_Say_Info_Task");
	register_clcmd("say level","HUD_Say_Info_Task");

	register_clcmd("say trade","main_trade_menu");
	register_clcmd("say /trade","main_trade_menu");

	register_clcmd("say giveitem","main_give_menu");
	register_clcmd("say /giveitem","main_give_menu");

	register_clcmd("amenu", "Open_MapItemConfig")
	register_clcmd("say amenu", "Open_MapItemConfig")
	register_clcmd("say /amenu", "Open_MapItemConfig")

	register_clcmd("say /worn","main_worn_menu");
	register_clcmd("say worn","main_worn_menu");

	register_clcmd("say","handle_say");
	register_clcmd("say_team","handle_say");

	register_clcmd("say /potion","main_potion_menu");
	register_clcmd("say potion","main_potion_menu");
	register_clcmd("potion","main_potion_menu");

	register_clcmd("say /spec","force_player_not_joined");
	register_clcmd("say spec","force_player_not_joined");

	register_clcmd("say /players","show_top");
	register_clcmd("say players","show_top");
	register_clcmd("say /top","show_top");
	register_clcmd("say top","show_top");

	register_clcmd("+skills","skill_handle");

	register_clcmd("chooseteam", "clcmd_changetm")
	register_clcmd("jointeam", "clcmd_changetm" );

	register_concmd("set_level", "cmd_set_level", ADMIN_RCON, "set_level <name> <amount>" );
	register_concmd("set_gold", "cmd_set_gold", ADMIN_RCON, "set_gold <name> <amount>" );
}

// Load the Characters and settings from the ini file
public LoadIniItems()
{
	// The the configs path
	static configsdir[256];
	get_configsdir( configsdir, charsmax( configsdir ) );
	
	// create one string with the path and the config file
	static configfile[256];
	formatex( configfile, charsmax( configfile ), "%s/%s", configsdir, "d2items.ini" );
	
	// is the file there?
	if ( !file_exists( configfile ) )
	{
		// Nope. Set the plugin failed.
		static sError[256];
		formatex( sError, charsmax( sError ), "Cannot load customization file %s", configfile );
		set_fail_state( sError );
		
		return;
	}
	
	// Set up some vars to hold parsing info
	new linedata[2024], key[64], value[960], section;
	
	// Open customization file for reading
	new file = fopen( configfile, "rt" );
		
	while ( file && !feof( file ) )
	{
		// Read one line at a time
		fgets( file, linedata, charsmax( linedata ) );
		
		// Replace newlines with a null character to prevent headaches
		replace( linedata, charsmax( linedata ), "^n", "" );
		
		// Blank line or comment
		if ( !linedata[0] || linedata[0] == ';' ) 
			continue;
		
		// New section starting
		if ( linedata[0] == '[' )
		{
			section++;
			continue;
		}
		
		// Get key and value(s)
		strtok( linedata, key, charsmax( key ), value, charsmax( value ), '=' );
		
		// Trim spaces
		trim( key );
		trim( value );
		
		switch ( section )
		{
			case 1: // Here we load all the characters
			{
				// we reached the chars max
				if ( g_charcounter > MAX_ITEMS )
				{
					// So go out of this
					continue;
				}
				
				if ( equal( key, "NAME" ) )
				{
					// We found a name. This must be a new Character
					g_charcounter++;
					
					// Save the name from the character in the array
					formatex( item_name[g_charcounter], 31, "%s", value );
				}
				else if ( equali( key, "VMODEL" ) )
				{
					formatex( item_vmodel[g_charcounter], 63, "%s", value );
				}
				else if ( equali( key, "PMODEL" ) )
				{
					formatex( item_pmodel[g_charcounter], 63, "%s", value );
				}
				else if ( equali( key, "ARMOR" ) )
				{
					item_data[g_charcounter][CHAR_ARMOR] = str_to_num( value );
				}
				
				else if ( equali( key, "DAMAGE" ) )
				{
					item_data[g_charcounter][CHAR_DAMAGE] = str_to_num( value );
				}
				else if ( equali( key, "COST" ) )
				{
					item_data[g_charcounter][CHAR_COST] = str_to_num( value );
				}
				
				else if ( equali( key, "DURABILITY" ) )
				{
					item_data[g_charcounter][CHAR_DURABILITY] = str_to_num( value );							}
				else if ( equali( key, "STRENGTH_REQ" ) )
				{
					item_data[g_charcounter][CHAR_STR] = str_to_num( value );
				}
				
				else if ( equali( key, "DEXTERITY_REQ" ) )
				{
					item_data[g_charcounter][CHAR_DEX] = str_to_num( value );
				}
				else if ( equali( key, "LEVEL_REQ" ) )
				{
					// Save the health in the array
					item_data[g_charcounter][CHAR_LEVEL] = str_to_num( value );
				}
				
				else if ( equali( key, "BLOCK_CHANCE" ) )
				{
					// Save the speed in the array
					item_data[g_charcounter][CHAR_BLOCK] = str_to_num( value );
				}
				else if ( equali( key, "GIVE_VITALITY" ) )
				{
					// Save the health in the array
					item_data[g_charcounter][CHAR_GIVEVIT] = str_to_num( value );
				}
				
				else if ( equali( key, "GIVE_ENERGY" ) )
				{
					// Save the speed in the array
					item_data[g_charcounter][CHAR_GIVEENE] = str_to_num( value );
				}
				else if ( equali( key, "ITEM_TYPE" ) )
				{
					// Save the speed in the array
					item_data[g_charcounter][CHAR_TYPE] = str_to_num( value );
				}
				else if ( equali( key, "HAS_POISON" ) )
				{
					// Save the speed in the array
					item_data[g_charcounter][CHAR_HASP] = str_to_num( value );
				}
				else if ( equali( key, "POISON_DAMAGE" ) )
				{
					// Save the speed in the array
					item_data[g_charcounter][CHAR_PDAMAGE] = str_to_num( value );
				}
				else if ( equali( key, "POISON_DURATION" ) )
				{
					// Save the speed in the array
					item_data[g_charcounter][CHAR_PDURATION] = str_to_num( value );
				}
				else if ( equali( key, "CROSSBOW_DAMAGE" ) )
				{
					// Save the speed in the array
					item_data[g_charcounter][CHAR_CROSSBOWDAMAGE] = str_to_num( value );
				}
			}
		}
	}
}