#include <amxmodx>
#include <d2lod>
#include <fakemeta>
#include <fakemeta_util>
#include <hamsandwich>
#include <fun>
#include <engine>

new PLUGIN_NAME[] = "Wake of Inferno"
new PLUGIN_AUTHOR[] = "xbatista"
new PLUGIN_VERSION[] = "1.0"

new Skill_Level = 24;
new Mana_Sentry = 20;
new Sentry_Limit = 3;

new const Float:AssTrapDur[MAX_P_SKILLS] =  // Assassin lightning trap duration.
{
	3.0, 4.0, 5.0, 6.0, 7.0, 8.0, 9.0, 10.0, 11.0, 12.0, 13.0, 14.0, 15.0, 15.0, 15.0, 15.0, 15.0, 15.0, 15.0, 15.0
};
new const Float:AssTrapDmg[MAX_P_SKILLS] =  // Assassin lightning trap damage.
{
	3.0, 4.0, 5.0, 6.0, 7.0, 8.0, 9.0, 10.0, 11.0, 12.0, 13.0, 14.0, 15.0, 15.0, 16.0, 17.0, 18.0, 19.0, 20.0, 21.0
};

new const WakeInfernoSnd[] = "ambience/flameburst1.wav";
new const SentryBuild[] = "d2lod/turrset.wav";
new const SentryModel[] = "models/d2lod/base.mdl";
new const FireCast[] = "sprites/xfireball3.spr";

new g_SkillId;

const m_pPlayer	= 41;
const m_flPrimaryAttack = 46;

new Float:g_LastPressedSkill[33];
new g_iCurSkill[33];
new g_iMaxPlayers;
new sLimit[33];

public plugin_init() 
{
	register_plugin(PLUGIN_NAME, PLUGIN_VERSION, PLUGIN_AUTHOR)

	g_SkillId = register_d2_skill(PLUGIN_NAME, "A fire trap that shoots a large flame.", ASSASSIN, Skill_Level, DISPLAY)

	register_forward(FM_Think, "FwdThink");
	register_forward(FM_Touch, "Entity_Touched");

	g_iMaxPlayers = get_maxplayers();
}

public plugin_precache()
{
	precache_sound( WakeInfernoSnd );
	precache_sound( SentryBuild );
	precache_model( SentryModel );
	precache_model( FireCast );
}

public client_disconnect(id)
{
	sLimit[id] = 0;

	new sentry = find_ent_by_class(-1, "Inferno_Sentry")
	
	while ( sentry ) 
	{
		new owner = entity_get_edict(sentry, EV_ENT_owner);

		if ( id != owner ) break;

		remove_entity(sentry)
		sentry = find_ent_by_class(sentry, "Inferno_Sentry")
	}
}

public d2_skill_selected(id, skill_id)
{
	g_iCurSkill[id] = skill_id
}

public Entity_Touched(ent, victim)
{
	if ( !is_valid_ent(ent) )
		return;
	
	new classname[32]
	entity_get_string(ent, EV_SZ_classname, classname, sizeof(classname) - 1);

	new attacker = entity_get_edict(ent, EV_ENT_owner);
	
	if( !equal(classname,"SentryFlame") || ent == victim ) return;

	if ( is_user_alive(victim) && victim != attacker && !IsPlayerNearByMonster(victim) && !is_p_protected(victim) && get_p_skill( attacker, g_SkillId ) > 0 )
	{
		dmg_kill_player(victim, attacker, AssTrapDmg[get_p_skill( attacker, g_SkillId ) - 1], "sentryflame");
	}	

	set_pev( ent, pev_flags, FL_KILLME);
}
public FwdThink(ent) 
{ 
	if ( !is_valid_ent(ent) ) return;

	new attacker = entity_get_edict(ent, EV_ENT_owner);

	if ( !is_user_connected(attacker) ) return;

	static classname[32]; 
	entity_get_string(ent, EV_SZ_classname, classname, sizeof(classname) - 1)
     
	if( !equali(classname, "Inferno_Sentry") ) return;

	new victim = FindVictim(ent, attacker);

	if ( victim > 0 )
	{
		Set_Sprite_FireBolt(ent, victim, attacker, FireCast, 40.0, 0.3, "SentryFlame");

		emit_sound( ent , CHAN_ITEM, WakeInfernoSnd, 1.0, ATTN_NORM, 0, PITCH_NORM );
	}

	entity_set_float(ent, EV_FL_nextthink, get_gametime() + 0.3);
}

public d2_skill_fired(id)
{
	if ( g_iCurSkill[id] == g_SkillId )
	{
		static Float:cdown;
		cdown = 3.0;

		if (get_gametime() - g_LastPressedSkill[id] <= cdown) 
		{
			return PLUGIN_HANDLED;
		}
		else if ( get_gametime() - g_LastPressedSkill[id] >= cdown )
		{
			g_LastPressedSkill[id] = get_gametime()
		}

		if ( get_p_skill( id, g_SkillId ) > 0 && get_p_mana(id) >= Mana_Sentry && sLimit[id] < Sentry_Limit )
		{
			sLimit[id]++;

			set_p_mana(id, get_p_mana(id) - Mana_Sentry );

			Create_Sentry(id);

			emit_sound( id , CHAN_ITEM, SentryBuild, 1.0, ATTN_NORM, 0, PITCH_NORM );
		}
	}
	
	return PLUGIN_CONTINUE;
}

public d2_logged(id, log_type)
{
	if ( log_type == UNLOGGED )
	{
		new sentry = find_ent_by_class(-1, "Inferno_Sentry")
	
		while ( sentry ) 
		{
			new owner = entity_get_edict(sentry, EV_ENT_owner);

			if ( id != owner ) break;

			remove_entity(sentry)
			sentry = find_ent_by_class(sentry, "Inferno_Sentry")
		}
	}
}
public Create_Sentry(id)
{
	new Float:Origin[3];
	entity_get_vector(id, EV_VEC_origin, Origin)

	new Float:fGlowColors[3] = {255.0, 255.0, 0.0}
	new sentry = create_entity("info_target")
	if(pev_valid(sentry))
	{
		entity_set_string(sentry, EV_SZ_classname, "Inferno_Sentry");
				
		entity_set_int(sentry, EV_INT_solid, SOLID_TRIGGER)
		entity_set_int(sentry, EV_INT_movetype, MOVETYPE_TOSS)
		entity_set_edict(sentry, EV_ENT_owner, id)
		entity_set_int(sentry, EV_INT_renderfx, kRenderFxGlowShell)
		entity_set_vector(sentry, EV_VEC_rendercolor, fGlowColors)

		entity_set_vector(sentry, EV_VEC_origin, Origin)
		
		entity_set_model(sentry, SentryModel)
		//entity_set_size(sentry, Float:{-2.5, -2.5, -1.5}, Float:{2.5, 2.5, 1.5})

		entity_set_float(sentry, EV_FL_nextthink, get_gametime() + 0.3);

		drop_to_floor(sentry)

		set_task(AssTrapDur[ get_p_skill( id, g_SkillId ) - 1], "Kill_Ent_Task", sentry);
	}
}
public Kill_Ent_Task(sentry)
{
	if ( is_valid_ent(sentry) )
	{
		new owner = entity_get_edict(sentry, EV_ENT_owner);
		sLimit[owner]--;

		remove_entity(sentry);
	}
}
FindVictim(ent, attacker)
{
	new victim;

	for(new enemy = 1; enemy <= g_iMaxPlayers; enemy++) 
	{
		if ( !is_user_alive(enemy) ) continue;
		if ( is_p_protected(enemy) ) continue;
		if ( get_p_in_safezone(enemy) ) continue;
		if ( IsPlayerNearByMonster(enemy) ) continue;
		if ( !fm_is_ent_visible(ent, enemy) ) continue;
		if ( attacker == enemy ) continue;

		new Float:Torigin[3], Float:fOrigin[3];
		entity_get_vector( ent, EV_VEC_origin, fOrigin);
		entity_get_vector( enemy, EV_VEC_origin, Torigin);

		new Float:Distance;
		Distance = get_distance_f(fOrigin, Torigin);

		if ( Distance <= 350.0 )
		{
			victim = enemy;
		}
	}

	return victim;
}
public Set_Sprite_FireBolt(ent, victim, id, const sprite[], Float:framerate, Float:scale, const classname[])
{
	new sprite_ent = create_entity("env_sprite")

	entity_set_string( sprite_ent, EV_SZ_classname, classname)
	entity_set_model( sprite_ent, sprite);

	entity_set_edict( sprite_ent, EV_ENT_owner, id)

	entity_set_size( sprite_ent, Float:{-1.1, -1.1, -1.1}, Float:{1.1, 1.1, 1.1})

	entity_set_int( sprite_ent, EV_INT_rendermode, kRenderTransAdd)
	entity_set_float( sprite_ent, EV_FL_renderamt, 200.0 )
    
	entity_set_float( sprite_ent, EV_FL_framerate, framerate )
	entity_set_float( sprite_ent, EV_FL_scale, scale )

	DispatchSpawn(sprite_ent);
	entity_set_int( sprite_ent, EV_INT_spawnflags, SF_SPRITE_STARTON)

	entity_set_int( sprite_ent, EV_INT_movetype, MOVETYPE_FLY)
	entity_set_int( sprite_ent, EV_INT_solid, SOLID_BBOX)

	new Float:fOrigin[3], Float:target_origin[3];

	entity_get_vector( ent, EV_VEC_origin, fOrigin)
	fOrigin[2] += 35.0
	entity_get_vector( victim, EV_VEC_origin, target_origin)


	new Float:diff[3];
	diff[0] = target_origin[0] - fOrigin[0];
	diff[1] = target_origin[1] - fOrigin[1];
	diff[2] = target_origin[2] - fOrigin[2];
	
	new Float:length = floatsqroot(floatpower(diff[0], 2.0) + floatpower(diff[1], 2.0) + floatpower(diff[2], 2.0));

	entity_set_vector( sprite_ent, EV_VEC_origin, fOrigin)

	new Float:fVel[3]
	fVel[0] = diff[0] * (400.0 / length);
	fVel[1] = diff[1] * (400.0 / length);
	fVel[2] = diff[2] * (400.0 / length);	

	entity_set_vector( sprite_ent, EV_VEC_velocity, fVel)
}