#include <amxmodx>
#include <d2lod>
#include <fakemeta>
#include <engine>

new PLUGIN_NAME[] = "Blizzard"
new PLUGIN_AUTHOR[] = "xbatista"
new PLUGIN_VERSION[] = "1.0"

new Skill_Level = 24;

new const g_SpriteBlizz[] = "sprites/xblizzard.spr";
new const SorcBlizzCast[] = "d2lod/blizzard.wav";

#define RADIUS_DAMAGE 350.0

new const SorcaManaBlizz[MAX_P_SKILLS] =  // Meteor mana.
{
	17, 17, 18, 19, 22, 24, 26, 28, 30, 32, 34, 36, 38, 39, 40, 40, 40, 40, 45, 45
};
new const Float:BlizzDamage[MAX_P_SKILLS] =  // Sorceress Meteor damage.
{
	10.0, 15.0, 20.0, 25.0, 30.0, 35.0, 40.0, 45.0, 50.0, 55.0, 60.0, 65.0, 66.0, 67.0, 68.0, 69.0, 70.0, 73.0, 75.0, 80.0
};

#define TASKID_BLIZZ 4223

new g_SkillId;

new g_iCurSkill[33];
new Float:g_LastPressedSkill[33];
new g_spriteShockwave

public plugin_init() 
{
	register_plugin(PLUGIN_NAME, PLUGIN_VERSION, PLUGIN_AUTHOR)

	g_SkillId = register_d2_skill(PLUGIN_NAME, "Summons an ice storm to rain cold death onto your enemies.", SORCERESS, Skill_Level, DISPLAY)

	register_forward(FM_Touch, "Entity_Touched");
}

public plugin_precache()
{
	precache_sound( SorcBlizzCast );
	precache_model( g_SpriteBlizz );
	g_spriteShockwave = precache_model( "sprites/shockwave.spr" );
}

public client_disconnect(id)
{
	remove_task( id + TASKID_BLIZZ);
}
public d2_skill_selected(id, skill_id)
{
	g_iCurSkill[id] = skill_id;
}

public d2_skill_fired(id)
{
	if ( g_iCurSkill[id] == g_SkillId )
	{
		static Float:cdown;
		cdown = 2.5;

		if (get_gametime() - g_LastPressedSkill[id] <= cdown) 
		{
			return PLUGIN_HANDLED;
		}
		else if ( get_gametime() - g_LastPressedSkill[id] >= cdown )
		{
			g_LastPressedSkill[id] = get_gametime()
		}

		if ( get_p_skill( id, g_SkillId ) > 0 && get_p_mana(id) >= SorcaManaBlizz[ get_p_skill( id, g_SkillId ) - 1 ] )
		{
			emit_sound(id, CHAN_ITEM, SorcBlizzCast, 1.0, ATTN_NORM, 0, PITCH_NORM);

			set_p_mana( id, get_p_mana(id) - SorcaManaBlizz[ get_p_skill( id, g_SkillId ) - 1 ] );

			new AimOrigin[3];

			get_user_origin( id, AimOrigin, 3);

			set_task( 0.4, "Task_Blizz", id + TASKID_BLIZZ, AimOrigin, sizeof AimOrigin, "a", 8);
		}
	}
	
	return PLUGIN_CONTINUE;
}
public Entity_Touched(ent, victim)
{
	if ( !pev_valid(ent) )
		return;
	
	new classname[32];
	pev( ent, pev_classname, classname, sizeof(classname)-1 )

	new attacker = entity_get_edict(ent, EV_ENT_owner);
	
	if( equal(classname,"Blizzard") && ent != victim ) 
	{
		new Float:fOrigin[3], iOrigin[3];
		entity_get_vector( ent, EV_VEC_origin, fOrigin)	
		FVecIVec( fOrigin, iOrigin)

		message_begin( MSG_PAS, SVC_TEMPENTITY, iOrigin );
		write_byte( TE_BEAMCYLINDER );
		engfunc( EngFunc_WriteCoord, fOrigin[0]);
		engfunc( EngFunc_WriteCoord, fOrigin[1]);
		engfunc( EngFunc_WriteCoord, fOrigin[2] - 16.0);
		engfunc( EngFunc_WriteCoord, fOrigin[0]);
		engfunc( EngFunc_WriteCoord, fOrigin[1]);
		engfunc( EngFunc_WriteCoord, fOrigin[2] - 16.0 + 40.0);
		write_short( g_spriteShockwave );
		write_byte( 0 );	// Startframe
		write_byte( 0 );	// Framerate
		write_byte( 3 );	// Life
		write_byte( 20 );	// Width
		write_byte( 0 );	// Noise
		write_byte( 0 );  // r
		write_byte( 0 );  // g
		write_byte( 255 );  // b
		write_byte( 255 );	// Brightness
		write_byte( 8 );	// Speed
		message_end();

		if ( is_user_alive(victim) && is_user_alive(attacker) && victim != attacker )
		{
			if ( !IsPlayerNearByMonster(victim) && !is_p_protected(victim) && get_p_skill( attacker, g_SkillId ) > 0 )
			{
				dmg_kill_player(victim, attacker, BlizzDamage[get_p_skill( attacker, g_SkillId ) - 1], "blizzard");
			}

		}

		set_pev( ent, pev_flags, FL_KILLME);
	}
}

public d2_takedamage(victim, attacker, Float:iDamage[1])
{

}
public d2_logged(id, log_type)
{
	if ( log_type == UNLOGGED )
	{
		remove_task( id + TASKID_BLIZZ);
	}
}
public Task_Blizz(AimOrigin[], id)
{
	id -= TASKID_BLIZZ;

	if ( !is_user_connected(id) )
		return;

	new RandomX, RandomY, RandomOrigin[3], EndOrigin[3];

	AimOrigin[2] += 150;

	for ( new i = 0; i < 8; i++)
	{
		RandomX = random_num(-125,125)
		RandomY = random_num(-125,125)

		RandomOrigin[0] = AimOrigin[0] + 1 * RandomX;
		RandomOrigin[1] = AimOrigin[1] + 1 * RandomY;
		RandomOrigin[2] = AimOrigin[2];

		new Float:LocVec[3]
		IVecFVec(RandomOrigin, LocVec)
                
		EndOrigin[0] = RandomOrigin[0]
		EndOrigin[1] = RandomOrigin[1]
		EndOrigin[2] = RandomOrigin[2] - 5

		new Float:EndVec[3]
		IVecFVec(EndOrigin, EndVec)
                
		new Float:VeloVec[3]
 		VeloVec[0] = (EndVec[0] - LocVec[0]) * 1 + 100;
		VeloVec[1] = (EndVec[1] - LocVec[1]) * 1 + 1;
		VeloVec[2] = (EndVec[2] - LocVec[2]) * 1 - random_num(120, 160);

		new sprite_ent = create_entity("env_sprite")

		entity_set_string( sprite_ent, EV_SZ_classname, "Blizzard")
		entity_set_model( sprite_ent, g_SpriteBlizz);

		entity_set_edict( sprite_ent, EV_ENT_owner, id)

		//entity_set_size( sprite_ent, Float:{-1.1, -1.1, -1.1}, Float:{1.1, 1.1, 1.1})

		entity_set_int( sprite_ent, EV_INT_rendermode, kRenderTransAdd)
		entity_set_float( sprite_ent, EV_FL_renderamt, 200.0 )
    
		entity_set_float( sprite_ent, EV_FL_framerate, 40.0 )
		entity_set_float( sprite_ent, EV_FL_scale, 2.7 )

		DispatchSpawn(sprite_ent);
		entity_set_int( sprite_ent, EV_INT_spawnflags, SF_SPRITE_STARTON)

		entity_set_int( sprite_ent, EV_INT_movetype, MOVETYPE_TOSS)
		entity_set_int( sprite_ent, EV_INT_solid, SOLID_TRIGGER)

		set_pev(sprite_ent, pev_angles, { 0.0, 0.0, 30.0 });
		entity_set_origin( sprite_ent, LocVec) // start posistion  
		entity_set_vector( sprite_ent, EV_VEC_velocity, VeloVec) // follow 
	}
}