#include <amxmodx>
#include <d2lod>
#include <fakemeta>
#include <fakemeta_util>
#include <hamsandwich>
#include <fun>
#include <engine>

new PLUGIN_NAME[] = "Lightning Sentry"
new PLUGIN_AUTHOR[] = "xbatista"
new PLUGIN_VERSION[] = "1.0"

new Skill_Level = 24;
new Mana_Sentry = 20;
new Sentry_Limit = 3;

new const Float:AssTrapDur[MAX_P_SKILLS] =  // Assassin lightning trap duration.
{
	3.0, 4.0, 5.0, 6.0, 7.0, 8.0, 9.0, 10.0, 11.0, 12.0, 13.0, 14.0, 15.0, 15.0, 15.0, 15.0, 15.0, 15.0, 15.0, 15.0
};
new const Float:AssTrapDmg[MAX_P_SKILLS] =  // Assassin lightning trap damage.
{
	23.0, 29.0, 34.0, 39.0, 42.0, 45.0, 50.0, 53.0, 57.0, 60.0, 61.0, 62.0, 63.0, 64.0, 65.0, 66.0, 67.0, 68.0, 69.0, 70.0
};

new const LightningCast[] = "d2lod/vengeanceimpact3.wav";
new const SentryBuild[] = "d2lod/turrset.wav";
new const SentryModel[] = "models/d2lod/base.mdl";

new g_SkillId;

const m_pPlayer	= 41;
const m_flPrimaryAttack = 46;

new Float:g_LastPressedSkill[33];
new g_iCurSkill[33];
new g_iMaxPlayers;
new sLimit[33];

new g_lightning;

public plugin_init() 
{
	register_plugin(PLUGIN_NAME, PLUGIN_VERSION, PLUGIN_AUTHOR)

	g_SkillId = register_d2_skill(PLUGIN_NAME, "A lightning trap.", ASSASSIN, Skill_Level, DISPLAY)

	register_forward(FM_Think, "FwdThink");

	g_iMaxPlayers = get_maxplayers();
}

public plugin_precache()
{
	precache_sound( LightningCast );
	precache_sound( SentryBuild );
	precache_model( SentryModel );
	g_lightning = precache_model( "sprites/lgtning.spr" );
}

public client_disconnect(id)
{
	sLimit[id] = 0;

	new sentry = find_ent_by_class(-1, "Lightning_Sentry")
	
	while ( sentry ) 
	{
		new owner = entity_get_edict(sentry, EV_ENT_owner);

		if ( id != owner ) break;

		remove_entity(sentry)
		sentry = find_ent_by_class(sentry, "Lightning_Sentry")
	}
}

public d2_skill_selected(id, skill_id)
{
	g_iCurSkill[id] = skill_id
}

public FwdThink(ent) 
{ 
	if ( !is_valid_ent(ent) ) return;

	new attacker = entity_get_edict(ent, EV_ENT_owner);

	if ( !is_user_connected(attacker) ) return;

	static classname[32]; 
	entity_get_string(ent, EV_SZ_classname, classname, sizeof(classname) - 1)
     
	if( !equali(classname, "Lightning_Sentry") ) return;

	new victim = FindVictim(ent, attacker);

	if ( victim > 0 )
	{
		new Float:EntOrigin[3], Float:VictimOrigin[3];
		entity_get_vector(ent, EV_VEC_origin, EntOrigin)
		entity_get_vector(victim, EV_VEC_origin, VictimOrigin)
		EntOrigin[2] += 25.0;

		Thunder( EntOrigin, VictimOrigin, ent )

		dmg_kill_player(victim, attacker, AssTrapDmg[ get_p_skill( attacker, g_SkillId ) - 1], "sentrylight");
	}

	entity_set_float(ent, EV_FL_nextthink, get_gametime() + 2.0);
}

public d2_skill_fired(id)
{
	if ( g_iCurSkill[id] == g_SkillId )
	{
		static Float:cdown;
		cdown = 3.0;

		if (get_gametime() - g_LastPressedSkill[id] <= cdown) 
		{
			return PLUGIN_HANDLED;
		}
		else if ( get_gametime() - g_LastPressedSkill[id] >= cdown )
		{
			g_LastPressedSkill[id] = get_gametime()
		}

		if ( get_p_skill( id, g_SkillId ) > 0 && get_p_mana(id) >= Mana_Sentry && sLimit[id] < Sentry_Limit )
		{
			sLimit[id]++;

			set_p_mana(id, get_p_mana(id) - Mana_Sentry );

			Create_Sentry(id);

			emit_sound( id , CHAN_ITEM, SentryBuild, 1.0, ATTN_NORM, 0, PITCH_NORM );
		}
	}
	
	return PLUGIN_CONTINUE;
}

public d2_logged(id, log_type)
{
	if ( log_type == UNLOGGED )
	{
		new sentry = find_ent_by_class(-1, "Lightning_Sentry")
	
		while ( sentry ) 
		{
			new owner = entity_get_edict(sentry, EV_ENT_owner);

			if ( id != owner ) break;

			remove_entity(sentry)
			sentry = find_ent_by_class(sentry, "Lightning_Sentry")
		}
	}
}
public Create_Sentry(id)
{
	new Float:Origin[3];
	entity_get_vector(id, EV_VEC_origin, Origin)

	new Float:fGlowColors[3] = {255.0, 255.0, 255.0}
	new sentry = create_entity("info_target")
	if(pev_valid(sentry))
	{
		entity_set_string(sentry, EV_SZ_classname, "Lightning_Sentry");
				
		entity_set_int(sentry, EV_INT_solid, SOLID_TRIGGER)
		entity_set_int(sentry, EV_INT_movetype, MOVETYPE_TOSS)
		entity_set_edict(sentry, EV_ENT_owner, id)
		entity_set_int(sentry, EV_INT_renderfx, kRenderFxGlowShell)
		entity_set_vector(sentry, EV_VEC_rendercolor, fGlowColors)

		entity_set_vector(sentry, EV_VEC_origin, Origin)
		
		entity_set_model(sentry, SentryModel)
		//entity_set_size(sentry, Float:{-2.5, -2.5, -1.5}, Float:{2.5, 2.5, 1.5})

		entity_set_float(sentry, EV_FL_nextthink, get_gametime() + 1.0);

		drop_to_floor(sentry)

		set_task(AssTrapDur[ get_p_skill( id, g_SkillId ) - 1], "Kill_Ent_Task", sentry);
	}
}
public Kill_Ent_Task(sentry)
{
	if ( is_valid_ent(sentry) )
	{
		new owner = entity_get_edict(sentry, EV_ENT_owner);
		sLimit[owner]--;

		remove_entity(sentry);
	}
}
FindVictim(ent, attacker)
{
	new victim;

	for(new enemy = 1; enemy <= g_iMaxPlayers; enemy++) 
	{
		if ( !is_user_alive(enemy) ) continue;
		if ( is_p_protected(enemy) ) continue;
		if ( get_p_in_safezone(enemy) ) continue;
		if ( IsPlayerNearByMonster(enemy) ) continue;
		if ( !fm_is_ent_visible(ent, enemy) ) continue;
		if ( attacker == enemy ) continue;

		new Float:Torigin[3], Float:fOrigin[3];
		entity_get_vector( ent, EV_VEC_origin, fOrigin);
		entity_get_vector( enemy, EV_VEC_origin, Torigin);

		new Float:Distance;
		Distance = get_distance_f(fOrigin, Torigin);

		if ( Distance <= 450.0 )
		{
			victim = enemy;
		}
	}

	return victim;
}
Thunder( Float:start[ 3 ], Float:end[ 3 ], ent )
{
	new Istart[3], Iend[3];
	FVecIVec( start, Istart);
	FVecIVec( end, Iend);

	message_begin( MSG_BROADCAST, SVC_TEMPENTITY ); 
	write_byte( TE_BEAMPOINTS ); 
	write_coord( Istart[ 0 ] ); 
	write_coord( Istart[ 1 ] ); 
	write_coord( Istart[ 2 ] ); 
	write_coord( Iend[ 0 ] ); 
	write_coord( Iend[ 1 ] ); 
	write_coord( Iend[ 2 ] ); 
	write_short( g_lightning ); 
	write_byte( 1 ); // start frame
	write_byte( 5 ); // frame rate in 0.1
	write_byte( 8 ); // life in 0.1
	write_byte( 130 ); // line width in 0.1
	write_byte( 30 ); // noise amplitude in 0.1
	write_byte( 200 ); 
	write_byte( 200 );
	write_byte( 200 );
	write_byte( 200 );
	write_byte( 200 ); // scrool speed in 0.1
	message_end();
	
	emit_sound( ent , CHAN_ITEM, LightningCast, 1.0, ATTN_NORM, 0, PITCH_NORM );
}