/*		
		Copyright © 2014, zmd94.

		This plugin is free software;
		you can redistribute it and/or modify it under the terms of the
		GNU General Public License as published by the Free Software Foundation.

		This program is distributed in the hope that it will be useful,
		but WITHOUT ANY WARRANTY; without even the implied warranty of
		MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
		GNU General Public License for more details.
*/

#include <amxmodx>
#include <cs_core>
#include <hamsandwich>
#include <engine>

// Configure access flag to open war menu and start vote command. ;)
#define ADMIN_FLAG ADMIN_VOTE

#define MAXPLAYERS 32
#define TASK_RESPAWN 1994

enum (+= 123)
{
	TASK_HUD = 1234,
	TASK_VOTE
}

enum _:TOTAL_FORWARDS
{
	FW_WAR_ROUND_START = 0,
	FW_WAR_ROUND_END,
	FW_WAR_VOTE_START,
	FW_WAR_VOTE_END,
}

enum _:WEAPONSWAR
{
	WeaponType[64],
	WeaponName[64],
	WeaponID[64]
}

new const WeaponsData[][WEAPONSWAR] =
{
	{"Hand-gun", "9x19mm Side-arm", "weapon_glock18"}, 
	{"Hand-gun", "KM.45 Tactical", "weapon_usp"}, 
	{"Hand-gun", "228 Compact", "weapon_p228"},
	{"Hand-gun", "Night Haw2.50c", "weapon_deagle"}, 
	{"Hand-gun", "Elites", "weapon_elite"}, 
	{"Hand-gun", "Five-Seven", "weapon_fiveseven"},
	{"Shotgun", "12 gauge", "weapon_m3"}, 
	{"Shotgun", "Auto-Shotgun", "weapon_xm1014"},
	{"Sub-machine", "TMP", "weapon_tmp"},
	{"Sub-machine", "MP5-Navy", "weapon_mp5navy"},
	{"Sub-machine", "KM-UMP45", "weapon_ump45"},
	{"Sub-machine", "ES-C90", "weapon_p90"},
	{"Sub-machine", "Ingram MAC-10", "weapon_mac10"},
	{"Rifles", "IDF-Defender", "weapon_galil"},
	{"Rifles", "Famas", "weapon_famas"},
	{"Rifles", "AK-47", "weapon_ak47"},
	{"Rifles", "M4A1", "weapon_m4a1"},
	{"Rifles", "Scout", "weapon_scout"},
	{"Rifles", "Ster-Aug", "weapon_aug"},
	{"Rifles", "Krieg 552", "weapon_sg552"},
	{"Rifles", "Krieg 550", "weapon_sg550"},
	{"Rifles", "Magnum", "weapon_awp"},
	{"Rifles", "D3/AU-1", "weapon_g3sg1"},
	{"Heavy", "Machine-gun", "weapon_m249"},
	{"Melee", "Knife", "weapon_knife"},
	{"Nade", "HE grenade", "weapon_hegrenade"}
}

// Bool
new bool:g_bInWar
new bool:g_bHEWar
new bool:g_bStartWar
new bool:g_bVote

// Floats
const Float:HUD_MODE_X = 0.75	// X Position ( --- )
const Float:HUD_MODE_Y = 0.20	// Y Position ( ||| )

// String
new g_sWeaponWar[32], g_sWeaponID[32]

// Variables
new g_ForwardResult
new g_Forwards[TOTAL_FORWARDS]

new g_iPoints[MAXPLAYERS+1]
new g_iAllVote[MAXPLAYERS+1]
new g_iVotes[2]
new g_iVoteMenu, g_iVoteTime

new g_WarMenu
new g_iVotingTime, g_iBullet, g_iUnlimitClip, g_iShowHud 
new g_iPointLeader, g_iPointBonus, g_iBonusAmount
new g_iAutoWarVote, g_iVoteCountdown, g_iAutoWarStart, g_iWarCountdown
new g_iVoteDelay, g_iWarDelay
new g_iAutoRespawn

new g_iMsgSayTxt, g_iSyncHud

public plugin_init() 
{
	register_plugin("Weapons War", "6.2", "zmd94")
	
	register_dictionary("cs_war.txt")
	
	register_clcmd("drop", "clcmd_drop")
	
	register_clcmd("say /ww", "clcmd_war")
	register_clcmd("say_team /ww", "clcmd_war")
	register_clcmd("say /wvote", "clcmd_vote")
	register_clcmd("say_team /wvote", "clcmd_vote")
	
	register_event("HLTV", "event_new_round", "a", "1=0", "2=0")
	register_event("TextMsg", "event_restart", "a", "2&#Game_C", "2&#Game_w")	
	register_event("CurWeapon", "event_CurWeapon", "be", "1=1")
	
	register_logevent("logevent_round_start", 2, "1=Round_Start")
	register_logevent("logevent_round_end", 2, "1=Round_End") 
	
	RegisterHam(Ham_Spawn, "player", "fw_PlayerRespawn", 1)
	RegisterHam(Ham_Killed, "player", "fw_PlayerKilled", 1)
	
	RegisterHam(Ham_Touch, "weaponbox", "fw_TouchWeapon")
	RegisterHam(Ham_Touch, "weapon_shield", "fw_TouchWeapon") 
	RegisterHam(Ham_Touch, "armoury_entity", "fw_TouchWeapon")
	
	g_iBullet = register_cvar("ww_allow_bullet", "0") // Allow player to have unlimited bullet
	g_iShowHud = register_cvar("ww_show_war_hud", "1") // Show current war round. ;)
	g_iVotingTime = register_cvar("ww_vote_time", "30") // Time for vote
	g_iPointLeader = register_cvar("ww_point_leader", "1") // Enable showing point leader
	g_iPointBonus = register_cvar("ww_leader_bonus", "1") // Enable point leader bonus
	g_iBonusAmount = register_cvar("ww_bonus_amount", "2000") // Amount of money given
	g_iAutoWarVote = register_cvar("ww_auto_vote", "1") // Allow auto war vote
	g_iVoteDelay = register_cvar("ww_vote_delay", "2") // Amount of round delay for auto war vote
	g_iAutoWarStart = register_cvar("ww_auto_war", "1") // Allow auto war start
	g_iWarDelay = register_cvar("ww_war_delay", "3") // Amount of round delay for auto war start
	g_iAutoRespawn = register_cvar("ww_allow_respawn", "1") // Allow auto respawn during war round
	
	// Forwards
	g_Forwards[FW_WAR_ROUND_START] = CreateMultiForward("cs_fw_war_start", ET_IGNORE, FP_CELL)
	g_Forwards[FW_WAR_ROUND_END] = CreateMultiForward("cs_fw_war_end", ET_IGNORE, FP_CELL)
	g_Forwards[FW_WAR_VOTE_START] = CreateMultiForward("cs_fw_vote_start", ET_IGNORE)
	g_Forwards[FW_WAR_VOTE_END] = CreateMultiForward("cs_fw_vote_end", ET_IGNORE)
	
	g_iMsgSayTxt = get_user_msgid("SayText") 
	g_iSyncHud = CreateHudSyncObj()
	
	g_WarMenu = menu_create("\yWeapons War \rv6.2", "war_handler")
    
	new szItem[64]
	for(new i; i < sizeof(WeaponsData); i++)
	{
		formatex(szItem, charsmax(szItem), "%s: \y%s", WeaponsData[i][WeaponType], WeaponsData[i][WeaponName])
		menu_additem(g_WarMenu, szItem)
	}
}

public plugin_cfg()
{
	g_iUnlimitClip = get_pcvar_num(g_iBullet)
}

public plugin_end()
{
	menu_destroy(g_WarMenu)
}

public plugin_natives()
{
	register_library("cs_war")
	register_native("cs_is_war_round", "native_is_war_round")
	register_native("cs_current_war", "native_current_war")
	register_native("cs_get_war_id", "native_get_war_id")
}

public native_is_war_round()
{
	return g_bInWar
}

public native_current_war()
{
	return g_sWeaponWar
}

public native_get_war_id()
{
	new szWarID[32]
	get_string(1, szWarID, charsmax(szWarID))
}

public event_new_round()
{
	new iPlayers[32], iPlayerCount, i, id
	
	get_players(iPlayers, iPlayerCount, "c") 
	for(i = 0; i < iPlayerCount; i++)
	{
		id = iPlayers[i]
		g_iAllVote[id] = false

		g_iPoints[id] = 0
	}
	
	g_bInWar = false
	g_bHEWar = false
	g_bVote = false
	
	remove_task(TASK_HUD)
	remove_task(TASK_VOTE)
}

public event_restart()
{
	g_iWarCountdown = 0
	g_iVoteCountdown = 0
}

public logevent_round_start()
{		
	if(g_bStartWar)
	{
		StartWar()
		
		g_bStartWar = false
	}
	else
	{
		if(get_pcvar_num(g_iAutoWarVote))
		{
			if(g_iVoteCountdown >= get_pcvar_num(g_iVoteDelay))
			{
				new iWeaponIndex = random(sizeof WeaponsData)
				
				copy(g_sWeaponWar, charsmax(g_sWeaponWar), WeaponsData[iWeaponIndex][WeaponName])
				copy(g_sWeaponID, charsmax(g_sWeaponID), WeaponsData[iWeaponIndex][WeaponID])
				
				set_task(get_pcvar_float(g_iVotingTime), "EndVote", TASK_VOTE)
				
				print_colored(0, "!g[WW]!t %L", LANG_PLAYER, "VOTE3", get_pcvar_num(g_iVotingTime))
				
				g_bVote = true
				g_iVoteTime --
				
				StartVote()
				
				g_iVoteCountdown = 0
			}

			g_iVoteCountdown ++
		}
		
		if(get_pcvar_num(g_iAutoWarStart))
		{
			if(g_iWarCountdown >= get_pcvar_num(g_iWarDelay))
			{
				new iWeaponIndex = random(sizeof WeaponsData)
				
				copy(g_sWeaponWar, charsmax(g_sWeaponWar), WeaponsData[iWeaponIndex][WeaponName])
				copy(g_sWeaponID, charsmax(g_sWeaponID), WeaponsData[iWeaponIndex][WeaponID])
				
				StartWar()
				
				g_iWarCountdown = 0
			}
			
			g_iWarCountdown ++
		}
	}
}

public logevent_round_end()
{
	if(g_bInWar)
	{
		new iPlayers[32], iPlayerCount, i, id
		
		get_players(iPlayers, iPlayerCount, "a") 
		for(i = 0; i < iPlayerCount; i++)
		{
			id = iPlayers[i]
			
			if(g_bHEWar)
			{
				cs_grenade_reward(id, 191, 0)
				
				g_bHEWar = false
			}
			
			remove_task(id+TASK_RESPAWN)
		}
		
		if(get_pcvar_num(g_iPointLeader))
		{
			new iPoints, Others
			new iLeader = FindLeader(iPoints)

			get_players(iPlayers, iPlayerCount, "c" )
			for ( new i = 0; i < iPlayerCount; i++ )
			{
				Others = g_iPoints[i]
			}
				
			if(iPoints == Others)
			{
				set_hudmessage(random_num(10,255), random(256), random(256), -1.0, 0.20, 0, 3.0, 6.0, 0.0, 0.0, -1)
				show_hudmessage(0, "%L", LANG_PLAYER, "EQUAL")
			}
			else
			{
				new szName[32]
				get_user_name(iLeader, szName, charsmax(szName))
				
				set_hudmessage(random_num(10,255), random(256), random(256), -1.0, 0.20, 0, 3.0, 6.0, 0.0, 0.0, -1)
				show_hudmessage(0, "%L", LANG_PLAYER, "LEADER", szName, iPoints)
				
				if (get_pcvar_num(g_iPointBonus))
				{
					cs_money_reward(iLeader, get_pcvar_num(g_iBonusAmount), 1)
					print_colored(0, "!g[WW]!t %L", LANG_PLAYER, "WORD3", szName, iPoints)
				}
			}
		}
		
		ExecuteForward(g_Forwards[FW_WAR_ROUND_END], g_ForwardResult, g_sWeaponWar)
	}
}

FindLeader(&iPoints)
{
	new iPlayers[32], iPlayerCount, i, id
	new iLeader, iAllPoints	
	
	get_players(iPlayers, iPlayerCount, "c")
	for ( i = 0; i < iPlayerCount; i++ )
	{
		id = iPlayers[i]
		iAllPoints = g_iPoints[id]
		
		if (iAllPoints > iPoints)
		{
			iPoints = iAllPoints
			iLeader = id
		}
	}

	return iLeader;
}

public fw_PlayerRespawn(id)
{
	if (g_bInWar && is_user_alive(id))
	{
		if(g_bHEWar)
		{
			cs_grenade_reward(id, 191, 0)
		}
		else
		{
			cs_weapon_reward(id, g_sWeaponID)
		}
		
		if(g_iUnlimitClip)
		{
			cs_unlimited_reward(id, 2, 0, 0.0)
		}
	}
}

public fw_PlayerKilled(iVictim, iKiller)  
{
	if (!g_bInWar || !is_user_alive(iKiller) || iVictim == iKiller) 
		return
	
	if(get_pcvar_num(g_iPointLeader))
	{
		g_iPoints[iKiller] ++
	}
	
	if(get_pcvar_num(g_iAutoRespawn))
	{
		set_task(3.0, "AutoRespawn", iVictim+TASK_RESPAWN)
	}
}

public AutoRespawn(id)
{
	id -= TASK_RESPAWN
	if(!is_user_alive(id))
	{
		ExecuteHamB(Ham_CS_RoundRespawn, id)
	}
}

public event_CurWeapon(id)
{
	if(g_bInWar)
	{
		engclient_cmd(id, g_sWeaponID)
	}
}

public client_disconnect(id)
{
	g_iAllVote[id] = false
	g_iPoints[id] = 0
}

public clcmd_drop(id)
{
	if(g_bInWar)
	{
		print_colored(id, "!g[WW]!t %L", LANG_PLAYER, "WORD", g_sWeaponWar)
		return PLUGIN_HANDLED
	}
	
	return PLUGIN_CONTINUE
}

public clcmd_vote(id)
{
	if(get_user_flags(id) & ADMIN_FLAG)
	{
		if(g_bVote)
		{
			print_colored(id, "!g[WW]!t %L", LANG_PLAYER, "VOTE")
		}
		else
		{
			if(g_bStartWar)
			{
				print_colored(id, "!g[WW]!t %L", LANG_PLAYER, "VOTE7", g_sWeaponWar)
			}
			else
			{		
				if(g_bInWar)
				{
					print_colored(id, "!g[WW]!t %L", LANG_PLAYER, "VOTE6", g_sWeaponWar)
				}
				else
				{
					g_iAllVote[id] = true
					
					menu_display(id, g_WarMenu, 0)
				}
			}
		}
	}
}

public vote_handler(const id, const menuid, const item) 
{
	if(item == MENU_EXIT || !g_bVote) 
	{
		return PLUGIN_HANDLED
	}
	
	g_iVotes[item] ++
	
	return PLUGIN_HANDLED
}

public clcmd_war(id)
{
	if(get_user_flags(id) & ADMIN_FLAG)
	{
		if(g_bVote)
		{
			print_colored(id, "!g[WW]!t %L", LANG_PLAYER, "VOTE")
		}
		else
		{
			if(g_bStartWar)
			{
				print_colored(id, "!g[WW]!t %L", LANG_PLAYER, "VOTE7", g_sWeaponWar)
			}
			else
			{
				if(g_bInWar)
				{
					print_colored(0, "!g[WW]!t %L", LANG_PLAYER, "WORD2", g_sWeaponWar)
				}
				else
				{
					menu_display(id, g_WarMenu, 0)
				}
			}
		}
	}
}

public war_handler(const id, const menuid, const item)
{
	if(is_user_alive(id))
	{
		copy(g_sWeaponWar, charsmax(g_sWeaponWar), WeaponsData[item][WeaponName])
		copy(g_sWeaponID, charsmax(g_sWeaponID), WeaponsData[item][WeaponID])
		
		menu_cancel(id)
		
		WarType(id)
	}
}

public WarType(id)
{
	if(g_iAllVote[id])
	{
		new szADMIN[32]
		get_user_name(id, szADMIN, charsmax(szADMIN))
		
		set_task(get_pcvar_float(g_iVotingTime), "EndVote", TASK_VOTE)
		
		print_colored(0, "!g[WW]!t %L", LANG_PLAYER, "VOTE2", szADMIN, g_sWeaponWar)
		print_colored(0, "!g[WW]!t %L", LANG_PLAYER, "VOTE3", get_pcvar_num(g_iVotingTime))
		
		g_bVote = true
		g_iVoteTime --
		
		StartVote()
	}
	else
	{
		StartWar()
	}
}

public StartVote()
{
	g_iVotes[0] = g_iVotes[1] = 0
	
	new szVote[101]
	formatex(szVote, charsmax(szVote), "Vote for War Round! ^n\rNext is %s war!", g_sWeaponWar)
	
	g_iVoteMenu = menu_create(szVote, "vote_handler")
	
	menu_additem(g_iVoteMenu, "Yes!", "", 0)
	menu_additem(g_iVoteMenu, "No!", "", 0)
	
	new iPlayers[32], iPlayerCount, id
	
	get_players(iPlayers, iPlayerCount, "ac")
	for(new i; i < iPlayerCount; i++)
	{
		id = iPlayers[i];
		menu_display(id, g_iVoteMenu, 0)
	}
	
	// Forward
	ExecuteForward(g_Forwards[FW_WAR_VOTE_START], g_ForwardResult)
}

public EndVote()
{
	if(g_iVotes[0] > g_iVotes[1])
	{
		print_colored(0, "!g[WW]!t %L", LANG_PLAYER, "VOTE4")
		print_colored(0, "!g[WW]!t %L", LANG_PLAYER, "VOTE7", g_sWeaponWar)
		
		g_bStartWar = true
	}
	else
	{
		print_colored(0, "!g[WW]!t %L", LANG_PLAYER, "VOTE5")
	}
	
	menu_destroy(g_iVoteMenu)
	
	g_bVote = false
	
	// Forward
	ExecuteForward(g_Forwards[FW_WAR_VOTE_END], g_ForwardResult)
}

public StartWar()
{
	new iPlayers[32], iPlayerCount, i, id
	
	get_players(iPlayers, iPlayerCount, "a") 
	for(i = 0; i < iPlayerCount; i++)
	{
		id = iPlayers[i]
	
		if(equal(g_sWeaponID, "weapon_hegrenade",16))
		{
			cs_grenade_reward(id, 191, 0)
			
			g_bHEWar = true
		}
		else
		{
			cs_weapon_reward(id, g_sWeaponID)
		}
		
		if(g_iUnlimitClip)
		{
			cs_unlimited_reward(id, 2, 0, 0.0)
		}
	}
	
	g_bInWar = true
	
	if(get_pcvar_num(g_iShowHud))
	{
		set_task(1.0, "WarHud", TASK_HUD, _, _, "b")
	}
	
	set_hudmessage(random_num(10,255), random(256), random(256), -1.0, 0.20, 0, 6.0, 12.0, 0.0, 0.0, -1)
	show_hudmessage(0, "%s round!", g_sWeaponWar)
	
	// Execute war round started forward
	ExecuteForward(g_Forwards[FW_WAR_ROUND_START], g_ForwardResult, g_sWeaponWar)
}

public WarHud()
{
	set_hudmessage(255, 0, 0, HUD_MODE_X, HUD_MODE_Y, 0, 1.0, 1.0)
	ShowSyncHudMsg(0, g_iSyncHud, "Current round: ^n%s war!", g_sWeaponWar)
}

public fw_TouchWeapon(ent, id)
{
	if(is_valid_ent(ent) && is_user_alive(id) && g_bInWar)
	{
		return HAM_SUPERCEDE
	}
	
	return HAM_IGNORED
} 

stock print_colored(const index, const input [ ], const any:...)
{ 
	new message[191]
	vformat(message, 190, input, 3)
	replace_all(message, 190, "!y", "^1")
	replace_all(message, 190, "!t", "^3")
	replace_all(message, 190, "!g", "^4")

	if(index)
	{
		message_begin(MSG_ONE_UNRELIABLE , g_iMsgSayTxt, _, index)
		write_byte(index)
		write_string(message)
		message_end()
	}
	else
	{
		new players[32], count, i, id
		get_players(players, count, "ch")
		for( i = 0; i < count; i ++ )
		{
			id = players[i]
			if(!is_user_alive(id)) continue;

			message_begin(MSG_ONE_UNRELIABLE, g_iMsgSayTxt, _, id)
			write_byte(id)
			write_string(message)
			message_end()
		}
	}
}