#if defined _cs_war_included
  #endinput
#endif
#define _cs_war_included

#if AMXX_VERSION_NUM >= 175
	#pragma reqlib cs_war
	#if !defined AMXMODX_NOAUTOLOAD
		#pragma loadlib cs_war
	#endif
#else
	#pragma library cs_war
#endif

/**
 * Return whether current round is war round
 */
native cs_is_war_round();

/**
 * Return current war name
 */
native cs_current_war();

/**
 * Return war ID
 */
native cs_get_war_id(const szWarID[]);

/**
 * This is called during a war round is started
 * param sWarID - Internal ID for the chosen war
 */
forward cs_fw_war_start(sWarID);

/**
 * This is called during a war round is end
 * param sWarID - Internal ID for the chosen war
 */
forward cs_fw_war_end(sWarID);

/**
 * This is called during a war vote is started
 * param sWarID - Internal ID for the chosen war
 */
forward cs_fw_vote_start();

/**
 * This is called during a war vote is end
 * param sWarID - Internal ID for the chosen war
 */
forward cs_fw_vote_end();