#include < amxmodx >
#include < amxmisc >
#include < cstrike >
#include < csx >
#include < hamsandwich >
#include < fvault >

#define PLUGIN		"Basic SkillPoints Special Edition"
#define VERSION		"2.0.2"
#define AUTHOR		"guipatinador"

#define g_VaultSkillPoints	"skillpoints_v2"
#define g_VaultNames		"skillpoints_names"
#define PREFIX			"[SkillPoints]"

#define MAX_PLAYERS	32
#define ADMIN		ADMIN_RCON

#define EXPIREDAYS	30
#define MAX_CLASSES	5
#define MAX_LEVELS	5
#define MAX_PONTUATION	10000 // max skillpoints per player

#define IsPlayer(%1)		( 1 <= %1 <= g_iMaxPlayers )

new const CLASSES[ MAX_CLASSES ][ ] = {
	"BOT",
	"NOOB",
	"GAMER",
	"LEET",
	"TOP"
}

new const LEVELS[ MAX_LEVELS ] = {
	500,
	1200,
	1800,
	2500,
	100000 /* high value (not reachable) */
}

enum _:FvaultData {
	szSteamID[ 35 ],
	szSkillP_Data[ 128 ]
}

new g_iK
new const g_ChatAdvertise[ ][ ] = {
	"!g%s!n rd be!t /myskill!n, hogy megnzhesd SkillPontjaid.",
	"!g%s!n rd be!t /restartskill!n, hogy nullzd a SkillPontjaid s a szinted.",
	"!g%s!n rd be!t /rankskill!n, hogy megtekintsd a rankod.",
	"!g%s!n rd be!t /topskill!n, hogy megnzd a legjobbak listjt."
}

new g_iMaxPlayers
new g_szAuthID[ MAX_PLAYERS + 1 ][ 35 ]
new g_szName[ MAX_PLAYERS + 1 ][ 32 ]
new g_iCurrentKills[ MAX_PLAYERS + 1 ]
new g_szMotd[ 1536 ]

new g_iPoints[ MAX_PLAYERS + 1 ]
new g_iLevels[ MAX_PLAYERS + 1 ]
new g_iClasses[ MAX_PLAYERS + 1 ]

new g_iKills[ MAX_PLAYERS + 1 ]
new g_iDeaths[ MAX_PLAYERS + 1 ]
new g_iHeadShots[ MAX_PLAYERS + 1 ]
new g_iKnifeKills[ MAX_PLAYERS + 1 ]
new g_iKnifeDeaths[ MAX_PLAYERS + 1 ]
new g_iGrenadeKills[ MAX_PLAYERS + 1 ]
new g_iGrenadeDeaths[ MAX_PLAYERS + 1 ]
new g_iBombExplosions[ MAX_PLAYERS + 1 ]
new g_iDefusedBombs[ MAX_PLAYERS + 1 ]
new g_iWonRounds[ MAX_PLAYERS + 1 ]

new g_TimeBetweenAds

new bool:g_bRoundEnded

new g_iAdsOnChat
new g_iEnableAnnounceOnChat
new g_iEnableShowSkillPointsOnNick
new g_iHideChangeNickNotification
new g_iEnableSkillPointsCmd
new g_iEnableSkillPointsRestart
new g_iEnableSkillPointsCmdRank
new g_iEnableSkillPointsTop15
new g_iHideCmds
new g_iEnableWonPointsHour
new g_iWonPointsHour
new g_iLostPointsTK
new g_iLostPointsSuicide
new g_iWonPointsKill
new g_iLostPointsDeath
new g_iWonPointsHeadshot
new g_iLostPointsHeadshot
new g_iWonPointsKnife
new g_iLostPointsKnife
new g_iWonPointsGrenade
new g_iLostPointsGrenade
new g_iWonPointsTerrorists
new g_iWonPointsCounterTerrorists
new g_iLostPointsTerrorists
new g_iLostPointsCounterTerrorists
new g_iWonPointsPlanter
new g_iWonPointsPlanterExplode
new g_iWonPointsDefuser
new g_iWonPoints4k
new g_iWonPoints5k
new g_iNegativePoints

public plugin_init( )
{
	register_plugin( PLUGIN, VERSION, AUTHOR )
	
	register_clcmd( "say", "ClCmd_Say" )
	register_clcmd( "say_team", "ClCmd_Say" )
	
	register_concmd("bps_give", "CmdGivePoints", ADMIN, "<target> <skillpoints to give>" )
	register_concmd("bps_take", "CmdTakePoints", ADMIN, "<target> <skillpoints to take>" )
	
	RegisterHam( Ham_Spawn, "player", "FwdPlayerSpawnPost", 1 )
	
	register_message( get_user_msgid( "SayText" ), "MessageSayText" )
	
	register_event( "SendAudio", "TerroristsWin", "a", "2&%!MRAD_terwin" )
	register_event( "SendAudio", "CounterTerroristsWin", "a", "2&%!MRAD_ctwin" )
	
	register_event( "HLTV", "EventNewRound", "a", "1=0", "2=0" )
	register_logevent( "RoundEnd", 2, "1=Round_End" )
	
	g_iMaxPlayers = get_maxplayers( )
	
	RegisterCvars( )
}

public plugin_natives( )
{
	register_library( "skillpoints" )
	
	register_native( "skillpoints", "_skillpoints" )
}

public _skillpoints( plugin, params )
{
	if( params != 1 )
	{
		return 0
	}
	
	new id = get_param( 1 )
	if( !id )
	{
		return 0
	}
	
	return g_iPoints[ id ]
}

public RegisterCvars( )
{
	g_iAdsOnChat = register_cvar( "bps_ads", "1" )
	g_TimeBetweenAds = register_cvar( "bps_time_between_ads", "300.0" )
	g_iEnableAnnounceOnChat = register_cvar( "bps_announce_on_chat", "1" )
	g_iEnableShowSkillPointsOnNick = register_cvar( "bps_skillpoints_on_nick", "1" )
	g_iHideChangeNickNotification = register_cvar( "bps_hide_change_nick_notification", "1" )
	g_iEnableSkillPointsCmd = register_cvar( "bps_skillpoints_cmd", "1" )
	g_iEnableSkillPointsRestart = register_cvar( "bps_skillpoints_cmd_restart", "1" )
	g_iEnableSkillPointsCmdRank = register_cvar( "bps_skillpoints_cmd_rank", "1" )
	g_iEnableSkillPointsTop15 = register_cvar( "bps_skillpoints_cmd_top15", "1" )
	g_iHideCmds = register_cvar( "bps_hide_cmd", "0" )
	g_iEnableWonPointsHour = register_cvar( "bps_enable_win_per_hour", "1" )
	g_iWonPointsHour = register_cvar( "bps_won_points_hour", "5" )
	g_iLostPointsTK = register_cvar( "bps_lost_points_tk", "5" )
	g_iLostPointsSuicide = register_cvar( "bps_lost_points_suicide", "1" )
	g_iWonPointsKill = register_cvar( "bps_won_points_kill", "1" )
	g_iLostPointsDeath = register_cvar( "bps_lost_points_kill", "1" )
	g_iWonPointsHeadshot = register_cvar( "bps_won_points_headshot", "2" )
	g_iLostPointsHeadshot = register_cvar( "bps_lost_points_headshot", "2" )
	g_iWonPointsKnife = register_cvar( "bps_won_points_knife", "3" )
	g_iLostPointsKnife = register_cvar( "bps_lost_points_knife", "3" )
	g_iWonPointsGrenade = register_cvar( "bps_won_points_grenade", "3" )
	g_iLostPointsGrenade = register_cvar( "bps_lost_points_grenade", "3" )
	g_iWonPointsTerrorists = register_cvar( "bps_won_points_ts", "1" )
	g_iWonPointsCounterTerrorists = register_cvar( "bps_won_points_cts", "1" )
	g_iLostPointsTerrorists = register_cvar( "bps_lost_points_ts", "1" )
	g_iLostPointsCounterTerrorists = register_cvar( "bps_lost_points_cts", "1" )
	g_iWonPointsPlanter = register_cvar( "bps_won_points_planter", "1" )
	g_iWonPointsPlanterExplode = register_cvar( "bps_won_points_planter_explode", "2" ) 
	g_iWonPointsDefuser = register_cvar( "bps_won_points_defuser", "3" )
	g_iWonPoints4k = register_cvar( "bps_won_points_4k", "4" )
	g_iWonPoints5k = register_cvar( "bps_won_points_5k", "5" )
	g_iNegativePoints = register_cvar( "bps_negative_points", "0" )
	
	if( get_pcvar_num( g_iAdsOnChat ) )
	{
		set_task( get_pcvar_float( g_TimeBetweenAds ), "ChatAdvertisements", _, _, _, "b" )
	}
	
	fvault_prune( g_VaultSkillPoints, _, get_systime( ) - ( 86400 * EXPIREDAYS ) )
	
	MakeTop15( )
}

public client_authorized( id )
{
	get_user_authid( id , g_szAuthID[ id ], charsmax( g_szAuthID[ ] ) )
	get_user_info( id, "name", g_szName[ id ], charsmax( g_szName[ ] ) )
	
	fvault_set_data( g_VaultNames, g_szAuthID[ id ], g_szName[ id ] )
	
	g_iPoints[ id ] = 0
	g_iLevels[ id ] = 0
	g_iClasses[ id ] = 0
	
	g_iKills[ id ] = 0
	g_iDeaths[ id ] = 0
	g_iHeadShots[ id ] = 0
	g_iKnifeKills[ id ] = 0
	g_iKnifeDeaths[ id ] = 0
	g_iGrenadeKills[ id ] = 0
	g_iGrenadeDeaths[ id ] = 0
	g_iBombExplosions[ id ] = 0
	g_iDefusedBombs[ id ] = 0
	g_iWonRounds[ id ] = 0
	
	g_iCurrentKills[ id ] = 0
	
	LoadPoints( id )
	
	if( get_pcvar_num( g_iEnableWonPointsHour ) && get_pcvar_num( g_iWonPointsHour ) )
	{
		set_task( 3600.0, "GiveSkillPointsHour", id, _, _, "b" )
	}
}

public client_infochanged( id )
{
	if( is_user_connected( id ) )
	{
		new szNewName[ 32 ]
		get_user_info( id, "name", szNewName, charsmax( szNewName ) ) 
		
		new iLen = strlen( szNewName )
		
		new iPos = iLen - 1
		
		if( szNewName[ iPos ] == '>' )
		{    
			new i
			for( i = 1; i < 7; i++ )
			{    
				if( szNewName[ iPos - i ] == '<' )
				{    
					iLen = iPos - i
					szNewName[ iLen ] = EOS
					break
				}
			}
		}
		
		trim( szNewName )
		
		if( !equal( g_szName[ id ], szNewName ) )   
		{     
			copy( g_szName[ id ], charsmax( g_szName[ ] ), szNewName )
			
			fvault_set_data( g_VaultNames, g_szAuthID[ id ], g_szName[ id ] )
		}	
	}
}

public client_disconnect( id )
{
	if( task_exists( id ) )
	{
		remove_task( id )
	}
	
	CheckLevelAndSave( id )
}

public ClCmd_Say( id )
{	
	new szCmd[ 12 ]
	read_argv( 1, szCmd, charsmax( szCmd ) )
	
	if( equali( szCmd[ 1 ], "myskill" ) )
	{
		GetSkillPoints( id )
	}
	
	else if( equali( szCmd[ 1 ], "restartskill" ) )
	{
		RestartSkillPoints( id )
	}
	
	else if( equali( szCmd[ 1 ], "rankskill" ) )
	{
		SkillRank( id )
	}
	
	else if( equali( szCmd[ 1 ], "topskill" ) )
	{
		TopSkill( id )
	}
}

public GiveSkillPointsHour( id )
{
	g_iPoints[ id ] += get_pcvar_num( g_iWonPointsHour )
	
	if( get_pcvar_num( g_iEnableAnnounceOnChat ) )
	{
		ClientPrintColor( id, "!g%s!n Kaptl!t %i!n pontot%s , mert mg egy rt jtszottl.", PREFIX, get_pcvar_num( g_iWonPointsHour ), get_pcvar_num( g_iWonPointsHour ) > 1 ? "s" : "" )
	}
}

public client_death( iKiller, iVictim, iWpnIndex, iHitPlace, iTK )
{	
	if( !IsPlayer( iKiller ) || !IsPlayer( iVictim ) )
	{
		return PLUGIN_CONTINUE
	}
	
	if( iTK )
	{
		g_iPoints[ iKiller ] -= get_pcvar_num( g_iLostPointsTK )
		
		if( get_pcvar_num( g_iEnableAnnounceOnChat ) && get_pcvar_num( g_iLostPointsTK ) )
		{
			ClientPrintColor( iKiller, "!g%s!n !t %i!n pontot vesztettl%s , mert meglted egy csapattrsad.", PREFIX, get_pcvar_num( g_iLostPointsTK ), get_pcvar_num( g_iLostPointsTK ) > 1 ? "s" : ""  )
		}
		
		return PLUGIN_CONTINUE
	}
	
	if( iKiller == iVictim )
	{
		g_iPoints[ iKiller ] -= get_pcvar_num( g_iLostPointsSuicide )
		
		if( get_pcvar_num( g_iEnableAnnounceOnChat ) && get_pcvar_num( g_iLostPointsSuicide ) )
		{
			ClientPrintColor( iKiller, "!g%s!n !t %i!n pontot vesztettl%s , mert ngyilkos lettl.", PREFIX, get_pcvar_num( g_iLostPointsSuicide ), get_pcvar_num( g_iLostPointsSuicide ) > 1 ? "s" : ""  )
		}
		
		g_iDeaths[ iKiller ]++
		
		return PLUGIN_CONTINUE
	}
	
	g_iCurrentKills[ iKiller ]++
	g_iKills[ iKiller ]++
	
	g_iDeaths[ iVictim ]++
	
	if( iWpnIndex == CSW_HEGRENADE )
	{
		g_iPoints[ iKiller ] += get_pcvar_num( g_iWonPointsGrenade )
		g_iGrenadeKills[ iKiller]++
		
		if( get_pcvar_num( g_iEnableAnnounceOnChat ) && get_pcvar_num( g_iWonPointsGrenade ) )
		{
			ClientPrintColor( iKiller, "!g%s!n Kaptl!t %i!n pontot%s , mert %s -t grnttal lted meg.", PREFIX, get_pcvar_num( g_iWonPointsGrenade ), get_pcvar_num( g_iWonPointsGrenade ) > 1 ? "s" : "" ,g_szName[ iVictim ] )
		}
		
		g_iPoints[ iVictim ] -= get_pcvar_num( g_iLostPointsGrenade )
		g_iGrenadeDeaths[ iVictim ]++
		
		if( get_pcvar_num( g_iEnableAnnounceOnChat ) && get_pcvar_num( g_iLostPointsGrenade ) )
		{
			ClientPrintColor( iVictim, "!g%s!n !t %i!n pontot vesztettl%s , mert grnt ltal haltl meg.", PREFIX, get_pcvar_num( g_iLostPointsGrenade ), get_pcvar_num( g_iLostPointsGrenade ) > 1 ? "s" : "" )
		}
		
		return PLUGIN_CONTINUE
	}
	
	if( iWpnIndex == CSW_KNIFE )
	{
		g_iPoints[ iKiller ] += get_pcvar_num( g_iWonPointsKnife )
		g_iKnifeKills[ iKiller ]++
		
		if( get_pcvar_num( g_iEnableAnnounceOnChat ) && get_pcvar_num( g_iWonPointsKnife ) )
		{
			ClientPrintColor( iKiller, "!g%s!n Kaptl!t %i!n pontot%s , mert %s -t kssel lted meg.", PREFIX, get_pcvar_num( g_iWonPointsKnife ), get_pcvar_num( g_iWonPointsKnife ) > 1 ? "s" : "" ,g_szName[ iVictim ] )
		}
		
		g_iPoints[ iVictim ] -= get_pcvar_num( g_iLostPointsKnife )
		g_iKnifeDeaths[ iVictim ]++
		
		if( get_pcvar_num( g_iEnableAnnounceOnChat ) && get_pcvar_num( g_iLostPointsKnife ) )
		{
			ClientPrintColor( iVictim, "!g%s!n !t %i!n pontot vesztettl%s , mert kssel ltek meg.", PREFIX, get_pcvar_num( g_iLostPointsKnife ), get_pcvar_num( g_iLostPointsKnife ) > 1 ? "s" : "" )
		}
		
		return PLUGIN_CONTINUE
	}
	
	if( iHitPlace == HIT_HEAD )
	{
		g_iPoints[ iKiller ] += get_pcvar_num( g_iWonPointsHeadshot )
		g_iHeadShots[ iKiller ]++
		
		if( get_pcvar_num( g_iEnableAnnounceOnChat ) && get_pcvar_num( g_iWonPointsHeadshot ) )
		{
			ClientPrintColor( iKiller, "!g%s!n Kaptl!t %i!n pontot%s , mert meglted %s -t egy HS-sel.", PREFIX, get_pcvar_num( g_iWonPointsHeadshot ), get_pcvar_num( g_iWonPointsHeadshot ) > 1 ? "s" : "" ,g_szName[ iVictim ] )
		}
		
		g_iPoints[ iVictim ] -= get_pcvar_num( g_iLostPointsHeadshot )
		
		if( get_pcvar_num( g_iEnableAnnounceOnChat ) && get_pcvar_num( g_iLostPointsHeadshot ) )
		{
			ClientPrintColor( iVictim, "!g%s!n !t %i!n pontot vesztettl%s , mert HS ltal haltl meg.", PREFIX, get_pcvar_num( g_iLostPointsHeadshot ), get_pcvar_num( g_iLostPointsHeadshot ) > 1 ? "s" : "" )
		}
		
		return PLUGIN_CONTINUE
	}
	
	g_iPoints[ iKiller ] += get_pcvar_num( g_iWonPointsKill )
	
	if( get_pcvar_num( g_iEnableAnnounceOnChat ) && get_pcvar_num( g_iWonPointsKill ) )
	{
		ClientPrintColor( iKiller, "!g%s!n Kaptl!t %i!n pontot%s , mert meglted %s -t.", PREFIX, get_pcvar_num( g_iWonPointsKill ), get_pcvar_num( g_iWonPointsKill ) > 1 ? "s" : "", g_szName[ iVictim ] )
	}
	
	g_iPoints[ iVictim ] -= get_pcvar_num( g_iLostPointsDeath )
	
	if( get_pcvar_num( g_iEnableAnnounceOnChat ) && get_pcvar_num( g_iLostPointsDeath ) )
	{
		ClientPrintColor( iVictim, "!g%s!n !t %i!n pontot vesztettel%s , mert meghaltl.", PREFIX, get_pcvar_num( g_iLostPointsDeath ), get_pcvar_num( g_iLostPointsDeath ) > 1 ? "s" : "" )
	}
	
	return PLUGIN_CONTINUE	
}

public TerroristsWin( )
{
	if( g_bRoundEnded )
	{
		return PLUGIN_CONTINUE
	}
	
	new Players[ MAX_PLAYERS ]
	new iNum
	new i
	
	get_players( Players, iNum, "ch" )
	
	for( --iNum; iNum >= 0; iNum-- )
	{
		i = Players[ iNum ]
		
		switch( cs_get_user_team( i ) )
		{
			case( CS_TEAM_T ):
			{
				if( get_pcvar_num( g_iWonPointsTerrorists ) )
				{
					g_iPoints[ i ] += get_pcvar_num( g_iWonPointsTerrorists )
					g_iWonRounds[ i ]++
					
					if( get_pcvar_num( g_iEnableAnnounceOnChat ) )
					{
						ClientPrintColor( i, "!g%s!n A csapatod!t (T)!n nyert!t %i!n pont%s a kr megnyersrt.", PREFIX, get_pcvar_num( g_iWonPointsTerrorists ), get_pcvar_num( g_iWonPointsTerrorists ) > 1 ? "s" : "" )
					}
				}
			}
			
			case( CS_TEAM_CT ):
			{
				if( get_pcvar_num( g_iLostPointsCounterTerrorists ) )
				{
					g_iPoints[ i ] -= get_pcvar_num( g_iLostPointsCounterTerrorists )
					
					if( get_pcvar_num( g_iEnableAnnounceOnChat ) )
					{
						ClientPrintColor( i, "!g%s!n A csapatod!t (CT)!n vesztett!t %i!n pont%s a kr elvesztsrt.", PREFIX, get_pcvar_num( g_iLostPointsCounterTerrorists ), get_pcvar_num( g_iLostPointsCounterTerrorists ) > 1 ? "s" : "" )
					}
				}
			}
		}
	}
	
	g_bRoundEnded = true
	
	return PLUGIN_CONTINUE
}

public CounterTerroristsWin( )
{
	if( g_bRoundEnded )
	{
		return PLUGIN_CONTINUE
	}
	
	new Players[ MAX_PLAYERS ]
	new iNum
	new i
	
	get_players( Players, iNum, "ch" )
	
	for( --iNum; iNum >= 0; iNum-- )
	{
		i = Players[ iNum ]
		
		switch( cs_get_user_team( i ) )
		{
			case( CS_TEAM_T ):
			{
				if( get_pcvar_num( g_iLostPointsTerrorists ) )
				{
					g_iPoints[ i ] -= get_pcvar_num( g_iLostPointsTerrorists )
					
					if( get_pcvar_num( g_iEnableAnnounceOnChat ) )
					{
						ClientPrintColor( i, "!g%s!n A csapatod!t (T)!n vesztett!t %i!n pont%s a kr elvesztsrt.", PREFIX, get_pcvar_num( g_iLostPointsTerrorists ), get_pcvar_num( g_iLostPointsTerrorists ) > 1 ? "s" : "" )
					}
				}
			}
			
			case( CS_TEAM_CT ):
			{
				if( get_pcvar_num( g_iWonPointsCounterTerrorists ) )
				{
					g_iPoints[ i ] += get_pcvar_num( g_iWonPointsCounterTerrorists )
					g_iWonRounds[ i ]++
					
					if( get_pcvar_num( g_iEnableAnnounceOnChat ) )
					{
						ClientPrintColor( i, "!g%s!n A csapatod!t (CT)!n nyert!t %i!n pont%s a kr megnyersrt.", PREFIX, get_pcvar_num( g_iWonPointsCounterTerrorists ), get_pcvar_num( g_iWonPointsCounterTerrorists ) > 1 ? "s" : "" )
					}
				}
			}
		}
	}
	
	g_bRoundEnded = true
	
	return PLUGIN_CONTINUE
}

public bomb_planted( planter )
{
	if( get_pcvar_num( g_iWonPointsPlanter ) )
	{
		g_iPoints[ planter ] += get_pcvar_num( g_iWonPointsPlanter )
		
		if( get_pcvar_num( g_iEnableAnnounceOnChat ) )
		{
			ClientPrintColor( planter, "!g%s!n Kaptl!t %i!n pontot%s a bomba idztsrt.", PREFIX, get_pcvar_num( g_iWonPointsPlanter ), get_pcvar_num( g_iWonPointsPlanter ) > 1 ? "s" : "" )
		}
	}
}

public bomb_explode( planter, defuser )
{
	if( get_pcvar_num( g_iWonPointsPlanterExplode ) )
	{
		g_iPoints[ planter ] += get_pcvar_num( g_iWonPointsPlanterExplode )
		g_iBombExplosions[ planter ]++
		
		if( get_pcvar_num( g_iEnableAnnounceOnChat ) )
		{
			ClientPrintColor( planter, "!g%s!n Kaptl!t %i!n pontot%s a bomba felrobbantsrt.", PREFIX, get_pcvar_num( g_iWonPointsPlanterExplode ), get_pcvar_num( g_iWonPointsPlanterExplode ) > 1 ? "s" : "" )
		}
	}
}

public bomb_defused( defuser )
{
	if( get_pcvar_num( g_iWonPointsDefuser ) )
	{
		g_iPoints[ defuser ] += get_pcvar_num( g_iWonPointsDefuser )
		g_iDefusedBombs[ defuser ]++
		
		if( get_pcvar_num( g_iEnableAnnounceOnChat ) )
		{
			ClientPrintColor( defuser, "!g%s!n Kaptl!t %i!n pontot%s a bomba hatstalantsrt.", PREFIX, get_pcvar_num( g_iWonPointsDefuser ), get_pcvar_num( g_iWonPointsDefuser ) > 1 ? "s" : "" )
		}
	}
}

public EventNewRound( )
{
	g_bRoundEnded = false
	
	MakeTop15( )
}


public RoundEnd( )
{
	set_task( 0.5, "SavePointsAtRoundEnd" )
}

public SavePointsAtRoundEnd( )
{
	new Players[ MAX_PLAYERS ]
	new iNum
	new i
	
	get_players( Players, iNum, "ch" )
	
	for( --iNum; iNum >= 0; iNum-- )
	{
		i = Players[ iNum ]
		
		if( g_iCurrentKills[ i ] == 4 && get_pcvar_num( g_iWonPoints4k ) )
		{
			g_iPoints[ i ] += get_pcvar_num( g_iWonPoints4k )
			
			if( get_pcvar_num( g_iEnableAnnounceOnChat ) )
			{
				ClientPrintColor( i, "!g%s!n Kaptl!t %i!n pontot%s , mert ngyet ltl ebben a krben.", PREFIX, get_pcvar_num( g_iWonPoints4k ), get_pcvar_num( g_iWonPoints4k ) > 1 ? "s" : "" )
			}
		}
		
		if( g_iCurrentKills[ i ] >= 5 && get_pcvar_num( g_iWonPoints5k ) )
		{
			g_iPoints[ i ] += get_pcvar_num( g_iWonPoints5k )
			
			if( get_pcvar_num( g_iEnableAnnounceOnChat ) )
			{
				ClientPrintColor( i, "!g%s!n Kaptl!t %i!n pontot%s , mert tt ltl ebben a krben.", PREFIX, get_pcvar_num( g_iWonPoints5k ), get_pcvar_num( g_iWonPoints5k ) > 1 ? "s" : "" )
			}
		}
		
		CheckLevelAndSave( i )
	}
}

public CheckLevelAndSave( id )
{
	if( !get_pcvar_num( g_iNegativePoints) )
	{
		if( g_iPoints[ id ] < 0 )
		{
			g_iPoints[ id ] = 0
		}
		
		if( g_iLevels[ id ] < 0 )
		{
			g_iLevels[ id ] = 0
		}
	}
	
	while( g_iPoints[ id ] >= LEVELS[ g_iLevels[ id ] ] )
	{
		g_iLevels[ id ]++
		g_iClasses[ id ]++
		
		if( get_pcvar_num( g_iEnableAnnounceOnChat ) )
		{			
			ClientPrintColor( 0, "!g%s!n %s Szintet lptl! Szinted:!t %s!n sszes pontod:!t %d", PREFIX, g_szName[ id ], CLASSES[ g_iLevels[ id ] ], g_iPoints[ id ] )
		}
	}
	
	new szFormattedData[ 128 ]
	formatex( szFormattedData, charsmax( szFormattedData ),
	"%i %i %i %i %i %i %i %i %i %i %i %i",
	
	g_iPoints[ id ],
	g_iLevels[ id ],
	
	g_iKills[ id ],
	g_iDeaths[ id ],
	g_iHeadShots[ id ],
	g_iKnifeKills[ id ],
	g_iKnifeDeaths[ id ],
	g_iGrenadeKills[ id ],
	g_iGrenadeDeaths[ id ],
	g_iBombExplosions[ id ],
	g_iDefusedBombs[ id ],
	g_iWonRounds[ id ] )
	
	fvault_set_data( g_VaultSkillPoints, g_szAuthID[ id ], szFormattedData )
	
	if( g_iPoints[ id ] >= MAX_PONTUATION )
	{		
		if( get_pcvar_num( g_iEnableAnnounceOnChat ) )
		{
			ClientPrintColor( id, "!g%s!n Elrted a maxmilis SkillPont szmot! Pontjaid s szinted nullzdik.", PREFIX )
		}
		
		g_iPoints[ id ] = 0
		g_iLevels[ id ] = 0
		g_iClasses[ id ] = 0
		
		g_iKills[ id ] = 0
		g_iDeaths[ id ] = 0
		g_iHeadShots[ id ] = 0
		g_iKnifeKills[ id ] = 0
		g_iKnifeDeaths[ id ] = 0
		g_iGrenadeKills[ id ] = 0
		g_iGrenadeDeaths[ id ] = 0
		g_iBombExplosions[ id ] = 0
		g_iDefusedBombs[ id ] = 0
		g_iWonRounds[ id ] = 0
		
		CheckLevelAndSave( id )
	}
}

public LoadPoints( id )
{
	new szFormattedData[ 128 ]
	if( fvault_get_data( g_VaultSkillPoints, g_szAuthID[ id ], szFormattedData, charsmax( szFormattedData ) ) )
	{
		new szPlayerPoints[ 7 ]
		new szPlayerLevel[ 7 ]
		
		new szPlayerKills[ 7 ]
		new szPlayerDeahts[ 7 ]
		new szPlayerHeadShots[ 7 ]
		new szPlayerKnifeKills[ 7 ]
		new szPlayerKnifeDeaths[ 7 ]
		new szPlayerGrenadeKills[ 7 ]
		new szPlayerGrenadeDeaths[ 7 ]
		new szPlayerBombExplosions[ 7 ]
		new szPlayerDefusedBombs[ 7 ]
		new szPlayerWonRounds[ 7 ]
		
		parse( szFormattedData,
		szPlayerPoints, charsmax( szPlayerPoints ),
		szPlayerLevel, charsmax( szPlayerLevel ),
		
		szPlayerKills, charsmax( szPlayerKills ),
		szPlayerDeahts, charsmax( szPlayerDeahts ),
		szPlayerHeadShots, charsmax( szPlayerHeadShots ),
		szPlayerKnifeKills, charsmax( szPlayerKnifeKills ),
		szPlayerKnifeDeaths, charsmax( szPlayerKnifeDeaths ),
		szPlayerGrenadeKills, charsmax( szPlayerGrenadeKills ),
		szPlayerGrenadeDeaths, charsmax( szPlayerGrenadeDeaths ),
		szPlayerBombExplosions, charsmax( szPlayerBombExplosions ),
		szPlayerDefusedBombs, charsmax( szPlayerDefusedBombs ),
		szPlayerWonRounds, charsmax( szPlayerWonRounds ) )
		
		g_iPoints[ id ] = str_to_num( szPlayerPoints )
		g_iLevels[ id ] = str_to_num( szPlayerLevel )
		
		g_iKills[ id ] = str_to_num( szPlayerKills )
		g_iDeaths[ id ] = str_to_num( szPlayerDeahts )
		g_iHeadShots[ id ] = str_to_num( szPlayerHeadShots )
		g_iKnifeKills[ id ] = str_to_num( szPlayerKnifeKills )
		g_iKnifeDeaths[ id ] = str_to_num( szPlayerKnifeDeaths )
		g_iGrenadeKills[ id ] = str_to_num( szPlayerGrenadeKills )
		g_iGrenadeDeaths[ id ] = str_to_num( szPlayerGrenadeDeaths )
		g_iBombExplosions[ id ] = str_to_num( szPlayerBombExplosions )
		g_iDefusedBombs[ id ] = str_to_num( szPlayerDefusedBombs )
		g_iWonRounds[ id ] = str_to_num( szPlayerWonRounds )
		
	}
}

public GetSkillPoints( id )
{
	if( !get_pcvar_num( g_iEnableSkillPointsCmd ) )
	{
		ClientPrintColor( id, "!g%s!n Ez a parancs nincs engedlyezve", PREFIX )
	}
	
	else
	{		
		if( g_iLevels[ id ] < ( MAX_LEVELS - 1 ) )
		{
			ClientPrintColor( id, "!g%s!n sszes pontod:!t %d!n Szinted:!t %s!n Kvetkez szinthez szksges pontok:!t %d", PREFIX, g_iPoints[ id ], CLASSES[ g_iLevels[ id ] ], ( LEVELS[ g_iLevels[ id ] ] - g_iPoints[ id ] ) )
		}
		
		else
		{
			ClientPrintColor( id, "!g%s!n sszes pontod:!t %d!n Szinted:!t %s!n (Az utols szint)", PREFIX, g_iPoints[ id ], CLASSES[ g_iLevels[ id ] ] )
		}
	}
	
	return ( get_pcvar_num( g_iHideCmds ) == 0 ) ? PLUGIN_CONTINUE : PLUGIN_HANDLED_MAIN
}

public ChatAdvertisements( )
{
	new Players[ MAX_PLAYERS ]
	new iNum
	new i
	
	get_players( Players, iNum, "ch" )
	
	for( --iNum; iNum >= 0; iNum-- )
	{
		i = Players[ iNum ]
		
		ClientPrintColor( i, g_ChatAdvertise[ g_iK ], PREFIX )
	}
	
	g_iK++
	
	if( g_iK >= sizeof g_ChatAdvertise )
	{
		g_iK = 0
	}
}

public CmdGivePoints( id, level, cid )
{
	if ( !cmd_access( id, level, cid, 3 ) )
	{
		return PLUGIN_HANDLED
	}
	
	new Arg1[ 32 ]
	new Arg2[ 6 ]
	
	read_argv( 1, Arg1, charsmax( Arg1 ) )
	read_argv( 2, Arg2, charsmax( Arg2 ) )
	
	new iPlayer = cmd_target( id, Arg1, 1 )
	new iPoints = str_to_num( Arg2 )
	
	if ( !iPlayer )
	{
		console_print( id, "Sajnlom, de %s nem tallhat!", Arg1 )
		return PLUGIN_HANDLED
	}
	
	if( iPoints > 0 )
	{
		g_iPoints[ iPlayer ] += iPoints
		CheckLevelAndSave( iPlayer )
		
		if( get_pcvar_num( g_iEnableAnnounceOnChat ) )
		{
			ClientPrintColor( 0, "!g%s!n %s adott!t %i!n SkillPontot%s  %s -nak/-nek", PREFIX, g_szName[ id ], iPoints, iPoints > 1 ? "s" : "", g_szName[ iPlayer ] )
		}
	}
	
	return PLUGIN_HANDLED
}

public CmdTakePoints( id, level, cid )
{
	if ( !cmd_access( id, level, cid, 3 ) )
	{
		return PLUGIN_HANDLED
	}
	
	new Arg1[ 32 ]
	new Arg2[ 6 ]
	
	read_argv( 1, Arg1, charsmax( Arg1 ) )
	read_argv( 2, Arg2, charsmax( Arg2 ) )
	
	new iPlayer = cmd_target( id, Arg1, 1 )
	new iPoints = str_to_num( Arg2 )
	
	if ( !iPlayer )
	{
		console_print( id, "Sajnlom, de %s nem tallhat!", Arg1 )
		return PLUGIN_HANDLED
	}
	
	if( iPoints > 0 )
	{
		g_iPoints[ iPlayer ] -= iPoints
		CheckLevelAndSave( iPlayer )
		
		if( get_pcvar_num( g_iEnableAnnounceOnChat ) )
		{
			ClientPrintColor( 0, "!g%s!n %s elvett!t %i!n SkillPontot%s  %s -tl/-tl", PREFIX, g_szName[ id ], iPoints, iPoints > 1 ? "s" : "", g_szName[ iPlayer ] )
		}
	}
	
	return PLUGIN_HANDLED
}

public RestartSkillPoints( id )
{
	if( !get_pcvar_num( g_iEnableSkillPointsRestart ) )
	{
		ClientPrintColor( id, "!g%s!n Ez a parancs nincs engedlyezve", PREFIX )
	}
	
	else
	{
		g_iPoints[ id ] = 0
		g_iLevels[ id ] = 0
		g_iClasses[ id ] = 0
		
		g_iKills[ id ] = 0
		g_iDeaths[ id ] = 0
		g_iHeadShots[ id ] = 0
		g_iKnifeKills[ id ] = 0
		g_iKnifeDeaths[ id ] = 0
		g_iGrenadeKills[ id ] = 0
		g_iGrenadeDeaths[ id ] = 0
		g_iBombExplosions[ id ] = 0
		g_iDefusedBombs[ id ] = 0
		g_iWonRounds[ id ] = 0
		
		CheckLevelAndSave( id )
		
		if( get_pcvar_num( g_iEnableAnnounceOnChat ) )
		{
			ClientPrintColor( id, "!g%s!n SkillPontjaid s szinted nullzdtak.", PREFIX )
		}
	}
	
	return ( get_pcvar_num( g_iHideCmds ) == 0 ) ? PLUGIN_CONTINUE : PLUGIN_HANDLED_MAIN
}

public SkillRank( id )
{
	if( !get_pcvar_num( g_iEnableSkillPointsCmdRank ) )
	{
		ClientPrintColor( id, "!g%s!n Ez a parancs nincs engedlyezve", PREFIX )
	}
	
	else
	{
		new Array:aKey = ArrayCreate( 35 )
		new Array:aData = ArrayCreate( 128 )
		new Array:aAll = ArrayCreate( FvaultData )
		
		fvault_load( g_VaultSkillPoints, aKey, aData )
		
		new iArraySize = ArraySize( aKey )
		
		new Data[ FvaultData ]
		
		new i
		for( i = 0; i < iArraySize; i++ )
		{
			ArrayGetString( aKey, i, Data[ szSteamID ], sizeof Data[ szSteamID ] - 1 )
			ArrayGetString( aData, i, Data[ szSkillP_Data ], sizeof Data[ szSkillP_Data ] - 1 )
			
			ArrayPushArray( aAll, Data )
		}
		
		ArraySort( aAll, "SortData" )
		
		new szAuthIdFromArray[ 35 ]
		
		new j
		for( j = 0; j < iArraySize; j++ )
		{
			ArrayGetString( aAll, j, szAuthIdFromArray, charsmax( szAuthIdFromArray ) )
			
			if( equal( szAuthIdFromArray, g_szAuthID[ id ] ) )
			{
				break
			}	
		}
		
		ArrayDestroy( aKey )
		ArrayDestroy( aData )
		ArrayDestroy( aAll )
		
		ClientPrintColor( id, "!g%s!n A rankod!t %i!n a!t %i!n -bl!t %i!n ponttal.", PREFIX, j + 1, iArraySize, g_iPoints[ id ] )
	}
	
	return ( get_pcvar_num( g_iHideCmds ) == 0 ) ? PLUGIN_CONTINUE : PLUGIN_HANDLED_MAIN
}

public TopSkill( id )
{
	if( !get_pcvar_num( g_iEnableSkillPointsTop15 ) )
	{
		ClientPrintColor( id, "!g%s!n Ez a parancs nincs engedlyezve", PREFIX )
	}
	
	else
	{
		show_motd( id, g_szMotd, "Top SkillPointers" )
	}
	
	return ( get_pcvar_num( g_iHideCmds ) == 0 ) ? PLUGIN_CONTINUE : PLUGIN_HANDLED_MAIN
}

public MakeTop15( )
{
	new iLen
	iLen = formatex( g_szMotd, charsmax( g_szMotd ),
	"<body bgcolor=#A4BED6>\
	<table width=100%% cellpadding=2 cellspacing=0 border=0>\
	<tr align=center bgcolor=#52697B>\
	<th width=4%%>#\
	<th width=30%% align=left>Jtkos\
	<th width=8%%>lsek\
	<th width=8%%>Hallok\
	<th width=8%%>HS-ek\
	<th width=8%%>Ks lsek\
	<th width=8%%>Grnt lsek\
	<th width=8%%>Bomba plantok\
	<th width=8%%>Defuse-ok\
	<th width=10%>SkillPontok" )
	
	new Array:aKey = ArrayCreate( 35 )
	new Array:aData = ArrayCreate( 128 )
	new Array:aAll = ArrayCreate( FvaultData )
	
	fvault_load( g_VaultSkillPoints, aKey, aData )
	
	new iArraySize = ArraySize( aKey )
	
	new Data[ FvaultData ]
	
	new i
	for( i = 0; i < iArraySize; i++ )
	{
		ArrayGetString( aKey, i, Data[ szSteamID ], sizeof Data[ szSteamID ] - 1 )
		ArrayGetString( aData, i, Data[ szSkillP_Data ], sizeof Data[ szSkillP_Data ] - 1 )
		
		ArrayPushArray( aAll, Data )
	}
	
	ArraySort( aAll, "SortData" )
	
	new szPlayerPoints[ 7 ]
	new szPlayerLevel[ 7 ]
	
	new szPlayerKills[ 7 ]
	new szPlayerDeahts[ 7 ]
	new szPlayerHeadShots[ 7 ]
	new szPlayerKnifeKills[ 7 ]
	new szPlayerKnifeDeaths[ 7 ]
	new szPlayerGrenadeKills[ 7 ]
	new szPlayerGrenadeDeaths[ 7 ]
	new szPlayerBombExplosions[ 7 ]
	new szPlayerDefusedBombs[ 7 ]
	new szPlayerWonRounds[ 7 ]
	
	new szName[ 22 ]
	new iSize = clamp( iArraySize, 0, 10 )
	
	new j
	for( j = 0; j < iSize; j++ )
	{
		ArrayGetArray( aAll, j, Data )
		
		fvault_get_data( g_VaultNames, Data[ szSteamID ], szName, charsmax( szName ) )
		
		replace_all( szName, charsmax( szName ), "<", "[" )
		replace_all( szName, charsmax( szName ), ">", "]" )
		
		parse( Data[ szSkillP_Data ],
		szPlayerPoints, charsmax( szPlayerPoints ),
		szPlayerLevel, charsmax( szPlayerLevel ),
		
		szPlayerKills, charsmax( szPlayerKills ),
		szPlayerDeahts, charsmax( szPlayerDeahts ),
		szPlayerHeadShots, charsmax( szPlayerHeadShots ),
		szPlayerKnifeKills, charsmax( szPlayerKnifeKills ),
		szPlayerKnifeDeaths, charsmax( szPlayerKnifeDeaths ),
		szPlayerGrenadeKills, charsmax( szPlayerGrenadeKills ),
		szPlayerGrenadeDeaths, charsmax( szPlayerGrenadeDeaths ),
		szPlayerBombExplosions, charsmax( szPlayerBombExplosions ),
		szPlayerDefusedBombs, charsmax( szPlayerDefusedBombs ),
		szPlayerWonRounds, charsmax( szPlayerWonRounds ) )
		
		iLen += formatex( g_szMotd[ iLen ], charsmax( g_szMotd ) - iLen, "<tr align=center>" )
		iLen += formatex( g_szMotd[ iLen ], charsmax( g_szMotd ) - iLen, "<td>%i", j + 1 )
		iLen += formatex( g_szMotd[ iLen ], charsmax( g_szMotd ) - iLen, "<td align=left>%s", szName )
		iLen += formatex( g_szMotd[ iLen ], charsmax( g_szMotd ) - iLen, "<td>%s", szPlayerKills )
		iLen += formatex( g_szMotd[ iLen ], charsmax( g_szMotd ) - iLen, "<td>%s", szPlayerDeahts )
		iLen += formatex( g_szMotd[ iLen ], charsmax( g_szMotd ) - iLen, "<td>%s", szPlayerHeadShots )
		iLen += formatex( g_szMotd[ iLen ], charsmax( g_szMotd ) - iLen, "<td>%s", szPlayerKnifeKills )
		iLen += formatex( g_szMotd[ iLen ], charsmax( g_szMotd ) - iLen, "<td>%s", szPlayerGrenadeKills )
		iLen += formatex( g_szMotd[ iLen ], charsmax( g_szMotd ) - iLen, "<td>%s", szPlayerBombExplosions )
		iLen += formatex( g_szMotd[ iLen ], charsmax( g_szMotd ) - iLen, "<td>%s", szPlayerDefusedBombs )
		iLen += formatex( g_szMotd[ iLen ], charsmax( g_szMotd ) - iLen, "<td>%s", szPlayerPoints )
	}
	
	iLen += formatex( g_szMotd[ iLen ], charsmax( g_szMotd ) - iLen, "</table></body>" )
	
	ArrayDestroy( aKey )
	ArrayDestroy( aData )
	ArrayDestroy( aAll )
}

public SortData( Array:aArray, iItem1, iItem2, iData[ ], iDataSize )
{
	new Data1[ FvaultData ]
	new Data2[ FvaultData ]
	
	ArrayGetArray( aArray, iItem1, Data1 )
	ArrayGetArray( aArray, iItem2, Data2 )
	
	new szPoints_1[ 7 ]
	parse( Data1[ szSkillP_Data ], szPoints_1, charsmax( szPoints_1 ) )
	
	new szPoints_2[ 7 ]
	parse( Data2[ szSkillP_Data ], szPoints_2, charsmax( szPoints_2 ) )
	
	new iCount1 = str_to_num( szPoints_1 )
	new iCount2 = str_to_num( szPoints_2 )
	
	return ( iCount1 > iCount2 ) ? -1 : ( ( iCount1 < iCount2 ) ? 1 : 0 )
}

public FwdPlayerSpawnPost( id )
{	
	if( is_user_alive( id ) )
	{
		g_iCurrentKills[ id ] = 0
		
		if( get_pcvar_num( g_iEnableShowSkillPointsOnNick ) )
		{
			new szName[ 32 ]
			get_user_info( id, "name", szName, charsmax( szName ) )
			
			new iLen = strlen( szName )
			
			new iPos = iLen - 1
			
			if( szName[ iPos ] == '>' )
			{    
				new i
				for( i = 1; i < 7; i++ )
				{    
					if( szName[ iPos - i ] == '<' )
					{    
						iLen = iPos - i
						szName[ iLen ] = '^0'
						break
					}
				}
			}
			
			format( szName[ iLen ], charsmax( szName ) - iLen, szName[ iLen-1 ] == ' ' ? "<%d>" : " <%d>", g_iPoints[ id ] )    
			set_user_info( id, "name", szName )
		}	
	}
}

public MessageSayText( iMsgID, iDest, iReceiver )
{
	if( get_pcvar_num( g_iHideChangeNickNotification ) )
	{	
		new const Cstrike_Name_Change[ ] = "#Cstrike_Name_Change"
		
		new szMessage[ sizeof( Cstrike_Name_Change ) + 1 ]
		get_msg_arg_string( 2, szMessage, charsmax( szMessage ) )
		
		if( equal( szMessage, Cstrike_Name_Change ) )
		{
			return PLUGIN_HANDLED
		}
	}
	
	return PLUGIN_CONTINUE
}

ClientPrintColor( id, String[ ], any:... )
{
	new szMsg[ 190 ]
	vformat( szMsg, charsmax( szMsg ), String, 3 )
	
	replace_all( szMsg, charsmax( szMsg ), "!n", "^1" )
	replace_all( szMsg, charsmax( szMsg ), "!t", "^3" )
	replace_all( szMsg, charsmax( szMsg ), "!g", "^4" )
	replace_all( szMsg, charsmax( szMsg ), "", "á")
	replace_all( szMsg, charsmax( szMsg ), "", "é")
	replace_all( szMsg, charsmax( szMsg ), "", "í")
	replace_all( szMsg, charsmax( szMsg ), "", "ó")
	replace_all( szMsg, charsmax( szMsg ), "", "ö")
	replace_all( szMsg, charsmax( szMsg ), "", "ő")
	replace_all( szMsg, charsmax( szMsg ), "", "ú")
	replace_all( szMsg, charsmax( szMsg ), "", "ü")
	replace_all( szMsg, charsmax( szMsg ), "", "ű")
	replace_all( szMsg, charsmax( szMsg ), "", "Á")
	replace_all( szMsg, charsmax( szMsg ), "", "É")
	replace_all( szMsg, charsmax( szMsg ), "", "Í")
	replace_all( szMsg, charsmax( szMsg ), "", "Ó")
	replace_all( szMsg, charsmax( szMsg ), "", "Ö")
	replace_all( szMsg, charsmax( szMsg ), "", "Ő")
	replace_all( szMsg, charsmax( szMsg ), "", "Ú")
	replace_all( szMsg, charsmax( szMsg ), "", "Ü")
	replace_all( szMsg, charsmax( szMsg ), "", "Ű")  
	
	static msgSayText = 0
	static fake_user
	
	if( !msgSayText )
	{
		msgSayText = get_user_msgid( "SayText" )
		fake_user = get_maxplayers( ) + 1
	}
	
	message_begin( id ? MSG_ONE_UNRELIABLE : MSG_BROADCAST, msgSayText, _, id )
	write_byte( id ? id : fake_user )
	write_string( szMsg )
	message_end( )
}
/* AMXX-Studio Notes - DO NOT MODIFY BELOW HERE
*{\\ rtf1\\ ansi\\ deff0{\\ fonttbl{\\ f0\\ fnil Tahoma;}}\n\\ viewkind4\\ uc1\\ pard\\ lang1038\\ f0\\ fs16 \n\\ par }
*/
