#include <amxmodx>
#include <amxmisc>
#include <colorchat>
#include <csstats>
#include <fakemeta>
#include <nvault>

#define PLUGIN "Fegyverskin"
#define VERSION "1.0"
#define AUTHOR "Blesh"


new oles[33]
new awp[33], deagle[33], usp[33], glock[33], m4a1[33], ak47[33]
new vault

new const szPrefix[] = "[Információ]"

public plugin_init() {
	register_plugin(PLUGIN, VERSION, AUTHOR)
	
	register_dictionary("weaponskin.txt")
	
	//Chat parancsok
	register_clcmd("say /awp", "awp_menu")
	register_clcmd("say_team /awp", "awp_menu")
	register_clcmd("say /deagle", "deagle_menu")
	register_clcmd("say_team /deagle", "deagle_menu")
	register_clcmd("say /usp", "usp_menu")
	register_clcmd("say_team /usp", "usp_menu")
	register_clcmd("say /glock", "glock_menu")
	register_clcmd("say_team /glock", "glock_menu")
	register_clcmd("say /m4a1", "m4a1_menu")
	register_clcmd("say_team /m4a1", "m4a1_menu")
	register_clcmd("say /ak47", "ak47_menu")
	register_clcmd("say_team /ak47", "ak47_menu")
	register_clcmd("say /menu", "fomenu")
	register_clcmd("say_team /menu", "fomenu")
	
	//Fegyverváltás
	register_event("CurWeapon", "fegyvervaltas", "be", "1=1")
	
	//Halál
	register_event("DeathMsg", "eDeath", "ade")
	
	vault = nvault_open("Fegyverskin")
}

public plugin_precache() {
	precache_model("models/wsm/awp_v1.mdl")
	precache_model("models/wsm/deagle_v1.mdl")
	precache_model("models/wsm/usp_v1.mdl")
	precache_model("models/wsm/glock18_v1.mdl")
	precache_model("models/wsm/m4a1_v1.mdl")
	precache_model("models/wsm/ak47_v1.mdl")
	precache_model("models/wsm/awp_v2.mdl")
	precache_model("models/wsm/deagle_v2.mdl")
	precache_model("models/wsm/usp_v2.mdl")
	precache_model("models/wsm/glock18_v2.mdl")
	precache_model("models/wsm/m4a1_v2.mdl")
	precache_model("models/wsm/ak47_v2.mdl")
	precache_model("models/wsm/awp_v3.mdl")
	precache_model("models/wsm/deagle_v3.mdl")
	precache_model("models/wsm/usp_v3.mdl")
	precache_model("models/wsm/glock18_v3.mdl")
	precache_model("models/wsm/m4a1_v3.mdl")
	precache_model("models/wsm/ak47_v3.mdl")
	precache_model("models/wsm/awp_v4.mdl")
	precache_model("models/wsm/deagle_v4.mdl")
	precache_model("models/wsm/usp_v4.mdl")
	precache_model("models/wsm/glock18_v4.mdl")
	precache_model("models/wsm/m4a1_v4.mdl")
	precache_model("models/wsm/ak47_v4.mdl")
	precache_model("models/wsm/awp_v5.mdl")
	precache_model("models/wsm/deagle_v5.mdl")
	precache_model("models/wsm/usp_v5.mdl")
	precache_model("models/wsm/glock18_v5.mdl")
	precache_model("models/wsm/m4a1_v5.mdl")
	precache_model("models/wsm/ak47_v5.mdl")
}

public eDeath() {
	
	new attacker = read_data(1)
	new victim = read_data(2)
	
	if(attacker == victim)
		return PLUGIN_HANDLED
	
	oles[attacker] ++
	return PLUGIN_HANDLED
}

public fomenu(id) {
	new menu = menu_create("Főmenü", "fomenu_h")
	
	menu_additem(menu, "AWP Skinek", "1", 0)
	menu_additem(menu, "Deagle Skinek", "2", 0)
	menu_additem(menu, "USP Skinek", "3", 0)
	menu_additem(menu, "Glock Skinek", "4", 0)
	menu_additem(menu, "M4A1 Skinek", "5", 0)
	menu_additem(menu, "AK47 Skinek", "6", 0)
	
	menu_display(id, menu, 0)
}

public fomenu_h(id, menu, item) {
	
	if(item == MENU_EXIT)
	{
		menu_cancel(id)
		return PLUGIN_HANDLED
	}
	
	new data[9], access, callback, szName[64]
	menu_item_getinfo(menu, item, access, data,charsmax(data), szName,charsmax(szName), callback)
	new key = str_to_num(data)
	
	switch(key) {
		case 1:{
			awp_menu(id)
		}
		case 2:{
			deagle_menu(id)
		}
		case 3:{
			usp_menu(id)
		}
		case 4:{
			glock_menu(id)
		}
		case 5:{
			m4a1_menu(id)
		}
		case 6:{
			ak47_menu(id)
		}
	}
	
	return PLUGIN_HANDLED
}

public awp_menu(id) {
	
	new szText[512]
	new cim[121]
    	format(cim, charsmax(cim), "AWP Skinek [Öléseid: %d]",oles[id])
    	new menu = menu_create(cim, "awp_handler" )
	
	if(oles[id] < 100)
	{
		formatex(szText, charsmax(szText), "Arany AWP [Még %d ölés]", 100-oles[id])
		menu_additem(menu, szText, "1", 0)
	}
	else
	menu_additem(menu, "Arany AWP [Elérve]", "1", 0)
	if(oles[id] < 250)
	{
		formatex(szText, charsmax(szText), "Camo AWP [Még %d ölés]", 250-oles[id])
		menu_additem(menu, szText, "2", 0)
	}
	else
	menu_additem(menu, "Camo AWP [Elérve]", "2", 0)
	if(oles[id] < 600)
	{
		formatex(szText, charsmax(szText), "AWP Redlight [Még %d ölés]", 600-oles[id])
		menu_additem(menu, szText, "3", 0)
	}
	else
	menu_additem(menu, "AWP Redlight [Elérve]", "3", 0)
	if(oles[id] < 800)
	{
		formatex(szText, charsmax(szText), "AWP Bluelight [Még %d ölés]", 800-oles[id])
		menu_additem(menu, szText, "4", 0)
	}
	else
	menu_additem(menu, "AWP Bluelight [Elérve]", "4", 0)
	if(oles[id] < 1500)
	{
		formatex(szText, charsmax(szText), "AWP Erica [Még %d ölés]", 1500-oles[id])
		menu_additem(menu, szText, "5", 0)
	}
	else
	menu_additem(menu, "AWP Erica [Elérve]", "5", 0)
	
    	menu_display(id, menu, 0)
}

public awp_handler(id, menu, item) {
    	if( item == MENU_EXIT )
    	{
    	menu_destroy(menu);
    	return PLUGIN_HANDLED;
    	}
    	new data[9], szName[64];
    	new access, callback;
    	menu_item_getinfo(menu, item, access, data,charsmax(data), szName,charsmax(szName), callback);
    	new key = str_to_num(data);
    	switch(key)
    	{
    		case 1:{ //AWP1
    			if(awp[id] != 1) 
    			{
    				if(oles[id] >= 100)
    				{
    					ColorChat(id, TEAM_COLOR, "%s ^1%L Arany AWP-t!", szPrefix, LANG_SERVER, "WSM_CHOSEN")
    					awp[id] = 1
    				}
    				else
    				{
    					ColorChat(id, TEAM_COLOR, "%s ^1%L", szPrefix, LANG_SERVER, "WSM_NOTENOUGH", 100-oles[id])
    					awp_menu(id)
    				}
    			}
    			else
    			{
    				ColorChat(id, TEAM_COLOR, "%s ^1%L", szPrefix, LANG_SERVER, "WSM_AWP")
    				awp_menu(id)
    			}
    		} 
    		case 2:{  //AWP2
    			if(awp[id] != 2)
    			{
    				if(oles[id] >= 250)
    				{
    					ColorChat(id, TEAM_COLOR, "%s ^1%L Camo AWP-t!", szPrefix, LANG_SERVER, "WSM_CHOSEN")
    					awp[id] = 2
    				}
    				else
    				{
    					ColorChat(id, TEAM_COLOR, "%s ^1%L", szPrefix, LANG_SERVER, "WSM_NOTENOUGH", 250-oles[id])
    					awp_menu(id)
    				}
    			}
    			else
    			{
    				ColorChat(id, TEAM_COLOR, "%s ^1%L", szPrefix, LANG_SERVER, "WSM_AWP")
    				awp_menu(id)
    			}
    		}
    		case 3:{ //AWP3
    			if(awp[id] != 3)
    			{
    				if(oles[id] >= 600)
    				{
    					ColorChat(id, TEAM_COLOR, "%s ^1%L AWP Bluelight-ot!", szPrefix, LANG_SERVER, "WSM_CHOSEN")
    					awp[id] = 3
    				}
    				else
    				{
    					ColorChat(id, TEAM_COLOR, "%s ^1%L", szPrefix, LANG_SERVER, "WSM_NOTENOUGH", 600-oles[id])
    					awp_menu(id)
    				}	
    			}
    			else
    			{
    				ColorChat(id, TEAM_COLOR, "%s ^1%L", szPrefix, LANG_SERVER, "WSM_AWP")
    				awp_menu(id)
    			}
    		}
    		case 4:{ //AWP4
    			if(awp[id] != 4)
    			{
    				if(oles[id] >= 800)
    				{
    					ColorChat(id, TEAM_COLOR, "%s ^1%L AWP Redlight-ot!", szPrefix, LANG_SERVER, "WSM_CHOSEN")
    					awp[id] = 4
    				}
    				else
    				{
    					ColorChat(id, TEAM_COLOR, "%s ^1%L", szPrefix, LANG_SERVER, "WSM_NOTENOUGH", 800-oles[id])
    					awp_menu(id)
    				}
    			}
    			else
    			{
    				ColorChat(id, TEAM_COLOR, "%s ^1%L", szPrefix, LANG_SERVER, "WSM_AWP")
    				awp_menu(id)
    			}
    		}
    		case 5:{ //AWP5
    			if(awp[id] != 5)
    			{
    				if(oles[id] >= 1500)
    				{
    					ColorChat(id, TEAM_COLOR, "%s ^1%L AWP Erica-t!", szPrefix, LANG_SERVER, "WSM_CHOSEN")
    					awp[id] = 5
    				}
    				else
    				{
    					ColorChat(id, TEAM_COLOR, "%s ^1%L", szPrefix, LANG_SERVER, "WSM_NOTENOUGH", 1500-oles[id])
    					awp_menu(id)
    				}
    			}
    			else
    			{
    				ColorChat(id, TEAM_COLOR, "%s ^1%L", szPrefix, LANG_SERVER, "WSM_AWP")
    				awp_menu(id)
    			}
    		}
    	}

    	menu_destroy(menu)
    	return PLUGIN_HANDLED
}

public deagle_menu(id) {
	
	new cim[121]
	new szText[512]
    	format(cim, charsmax(cim), "Deagle Skinek [Öléseid: %d]",oles[id])
    	new menu = menu_create(cim, "deagle_handler" )
	
	if(oles[id] < 50)
	{
		formatex(szText, charsmax(szText), "Arany Deagle [Még %d ölés]", 50-oles[id])
		menu_additem(menu, szText, "1", 0)
	}
	else
	menu_additem(menu, "Arany Deagle [Elérve]", "1", 0)
	if(oles[id] < 200)
	{
		formatex(szText, charsmax(szText), "Camo Deagle [Még %d ölés]", 250-oles[id])
		menu_additem(menu, szText, "2", 0)
	}
	else
	menu_additem(menu, "Camo Deagle [Elérve]", "2", 0)
	if(oles[id] < 350)
	{
		formatex(szText, charsmax(szText), "Deagle Redlight [Még %d ölés]", 350-oles[id])
		menu_additem(menu, szText, "3", 0)
	}
	else
	menu_additem(menu, "Deagle Redlight [Elérve]", "3", 0)
	if(oles[id] < 700)
	{
		formatex(szText, charsmax(szText), "Deagle Bluelight [Még %d ölés]", 700-oles[id])
		menu_additem(menu, szText, "4", 0)
	}
	else
	menu_additem(menu, "Deagle Bluelight [Elérve]", "4", 0)
	if(oles[id] < 1050)
	{
		formatex(szText, charsmax(szText), "Deagle Erica [Még %d ölés]", 1050-oles[id])
		menu_additem(menu, szText, "5", 0)
	}
	else
	menu_additem(menu, "Deagle Erica [Elérve]", "5", 0)

    	menu_display(id, menu, 0)
}

public deagle_handler(id, menu, item) {
    	if( item == MENU_EXIT )
    	{
    	menu_destroy(menu);
    	return PLUGIN_HANDLED;
    	}
    	new data[9], szName[64];
    	new access, callback;
    	menu_item_getinfo(menu, item, access, data,charsmax(data), szName,charsmax(szName), callback);
    	new key = str_to_num(data);
    	switch(key)
    	{
    		case 1:{ //Deagle1
    			if(deagle[id] != 1) 
    			{
    				if(oles[id] >= 50)
    				{
    					ColorChat(id, TEAM_COLOR, "%s ^1%L Arany Deagle-t!", szPrefix, LANG_SERVER, "WSM_CHOSEN")
    					deagle[id] = 1
    				}
    				else
    				{
    					ColorChat(id, TEAM_COLOR, "%s ^1%L", szPrefix, LANG_SERVER, "WSM_NOTENOUGH", 50-oles[id])
					deagle_menu(id)
    				}
    			}
    			else
    			{
    				ColorChat(id, TEAM_COLOR, "%s ^1%L", szPrefix, LANG_SERVER, "WSM_DEAGLE")
    				deagle_menu(id)
    			}
    		} 
    		case 2:{  //Deagle2
    			if(deagle[id] != 2)
    			{
    				if(oles[id] >= 200)
    				{
    					ColorChat(id, TEAM_COLOR, "%s ^1%L Camo Deagle-t!", szPrefix, LANG_SERVER, "WSM_CHOSEN")
    					deagle[id] = 2
    				}
    				else
    				{
    					ColorChat(id, TEAM_COLOR, "%s ^1%L", szPrefix, LANG_SERVER, "WSM_NOTENOUGH", 200-oles[id])
    					deagle_menu(id)
    				}
    			}
    			else
    			{
    				ColorChat(id, TEAM_COLOR, "%s ^1%L", szPrefix, LANG_SERVER, "WSM_DEAGLE")
    				deagle_menu(id)
    			}
    		}
    		case 3:{ //Deagle3
    			if(deagle[id] != 3)
    			{
    				if(oles[id] >= 350)
    				{
    					ColorChat(id, TEAM_COLOR, "%s ^1%L Deagle Redlight-ot!", szPrefix, LANG_SERVER, "WSM_CHOSEN")
    					deagle[id] = 3
    				}
    				else
    				{
    					ColorChat(id, TEAM_COLOR, "%s ^1%L", szPrefix, LANG_SERVER, "WSM_NOTENOUGH", 350-oles[id])
    					deagle_menu(id)
    				}	
    			}
    			else
    			{
    				ColorChat(id, TEAM_COLOR, "%s ^1%L", szPrefix, LANG_SERVER, "WSM_DEAGLE")
    				deagle_menu(id)
    			}
    		}
    		case 4:{ //Deagle4
    			if(deagle[id] != 4)
    			{
    				if(oles[id] >= 700)
    				{
    					ColorChat(id, TEAM_COLOR, "%s ^1%L Deagle Bluelight-ot!", szPrefix, LANG_SERVER, "WSM_CHOSEN")
    					deagle[id] = 4
    				}
    				else
    				{
    					ColorChat(id, TEAM_COLOR, "%s ^1%L", szPrefix, LANG_SERVER, "WSM_NOTENOUGH", 700-oles[id])
    					deagle_menu(id)
    				}
    			}
    			else
    			{
    				ColorChat(id, TEAM_COLOR, "%s ^1%L", szPrefix, LANG_SERVER, "WSM_DEAGLE")
				deagle_menu(id)
    			}
    		}
    		case 5:{ //Deagle5
    			if(deagle[id] != 5)
    			{
    				if(oles[id] >= 1050)
    				{
    					ColorChat(id, TEAM_COLOR, "%s ^1%L Deagle Erica-t!", szPrefix, LANG_SERVER, "WSM_CHOSEN")
    					deagle[id] = 5
    				}
    				else
    				{
    					ColorChat(id, TEAM_COLOR, "%s ^1%L", szPrefix, LANG_SERVER, "WSM_NOTENOUGH", 1050-oles[id])
    					deagle_menu(id)
    				}
    			}
    			else
    			{
    				ColorChat(id, TEAM_COLOR, "%s ^1%L", szPrefix, LANG_SERVER, "WSM_DEAGLE")
    				deagle_menu(id)
    			}
    		}
    	}

    	menu_destroy(menu)
    	return PLUGIN_HANDLED
}

public usp_menu(id) {
	
	new szText[512]
	new cim[121]
    	format(cim, charsmax(cim), "USP Skinek [Öléseid: %d]",oles[id])
    	new menu = menu_create(cim, "usp_handler" )
	
	if(oles[id] < 20)
	{
		formatex(szText, charsmax(szText), "Arany USP [Még %d ölés]", 20-oles[id])
		menu_additem(menu, szText, "1", 0)
	}
	else
	menu_additem(menu, "Arany USP [Elérve]", "1", 0)
	if(oles[id] < 75)
	{
		formatex(szText, charsmax(szText), "USP Red Destiny [Még %d ölés]", 75-oles[id])
		menu_additem(menu, szText, "2", 0)
	}
	else
	menu_additem(menu, "USP Red Destiny [Elérve]", "2", 0)
	if(oles[id] < 180)
	{
		formatex(szText, charsmax(szText), "USP Caiman [Még %d ölés]", 180-oles[id])
		menu_additem(menu, szText, "3", 0)
	}
	else
	menu_additem(menu, "USP Caiman [Elérve]", "3", 0)
	if(oles[id] < 400)
	{
		formatex(szText, charsmax(szText), "USP Comet [Még %d ölés]", 400-oles[id])
		menu_additem(menu, szText, "4", 0)
	}
	else
	menu_additem(menu, "USP Comet [Elérve]", "4", 0)
	if(oles[id] < 670)
	{
		formatex(szText, charsmax(szText), "USP THUNDER [Még %d ölés]", 670-oles[id])
		menu_additem(menu, szText, "5", 0)
	}
	else
	menu_additem(menu, "USP THUNDER [Elérve]", "5", 0)
	
    	menu_display(id, menu, 0)
}

public usp_handler(id, menu, item) {
    	if( item == MENU_EXIT )
    	{
    	menu_destroy(menu);
    	return PLUGIN_HANDLED;
    	}
    	new data[9], szName[64];
    	new access, callback;
    	menu_item_getinfo(menu, item, access, data,charsmax(data), szName,charsmax(szName), callback);
    	new key = str_to_num(data);
    	switch(key)
    	{
    		case 1:{ //USP1
    			if(usp[id] != 1) 
    			{
    				if(oles[id] >= 20)
    				{
    					ColorChat(id, TEAM_COLOR, "%s ^1%L Arany USP-t!", szPrefix, LANG_SERVER, "WSM_CHOSEN")
    					usp[id] = 1
    				}
    				else
    				{
    					ColorChat(id, TEAM_COLOR, "%s ^1%L", szPrefix, LANG_SERVER, "WSM_NOTENOUGH", 20-oles[id])
					usp_menu(id)
    				}
    			}
    			else
    			{
    				ColorChat(id, TEAM_COLOR, "%s ^1%L", szPrefix, LANG_SERVER, "WSM_USP")
    				usp_menu(id)
    			}
    		} 
    		case 2:{  //USP2
    			if(usp[id] != 2)
    			{
    				if(oles[id] >= 75)
    				{
    					ColorChat(id, TEAM_COLOR, "%s ^1%L USP Red Destiny-t!", szPrefix, LANG_SERVER, "WSM_CHOSEN")
    					usp[id] = 2
    				}
    				else
    				{
    					ColorChat(id, TEAM_COLOR, "%s ^1%L", szPrefix, LANG_SERVER, "WSM_NOTENOUGH", 75-oles[id])
    					usp_menu(id)
    				}
    			}
    			else
    			{
    				ColorChat(id, TEAM_COLOR, "%s ^1%L", szPrefix, LANG_SERVER, "WSM_USP")
    				usp_menu(id)
    			}
    		}
    		case 3:{ //USP3
    			if(usp[id] != 3)
    			{
    				if(oles[id] >= 180)
    				{
    					ColorChat(id, TEAM_COLOR, "%s ^1%L USP Caiman-t!", szPrefix, LANG_SERVER, "WSM_CHOSEN")
    					usp[id] = 3
    				}
    				else
    				{
    					ColorChat(id, TEAM_COLOR, "%s ^1%L", szPrefix, LANG_SERVER, "WSM_NOTENOUGH", 180-oles[id])
    					usp_menu(id)
    				}	
    			}
    			else
    			{
    				ColorChat(id, TEAM_COLOR, "%s ^1%L", szPrefix, LANG_SERVER, "WSM_USP")
    				usp_menu(id)
    			}
    		}
    		case 4:{ //USP4
    			if(usp[id] != 4)
    			{
    				if(oles[id] >= 400)
    				{
    					ColorChat(id, TEAM_COLOR, "%s ^1%L USP Comet-et!", szPrefix, LANG_SERVER, "WSM_CHOSEN")
    					usp[id] = 4
    				}
    				else
    				{
    					ColorChat(id, TEAM_COLOR, "%s ^1%L", szPrefix, LANG_SERVER, "WSM_NOTENOUGH", 400-oles[id])
    					usp_menu(id)
    				}
    			}
    			else
    			{
    				ColorChat(id, TEAM_COLOR, "%s ^1%L", szPrefix, LANG_SERVER, "WSM_USP")
				usp_menu(id)
    			}
    		}
    		case 5:{ //USP5
    			if(usp[id] != 5)
    			{
    				if(oles[id] >= 670)
    				{
    					ColorChat(id, TEAM_COLOR, "%s ^1%L USP THUNDER-t!", szPrefix, LANG_SERVER, "WSM_CHOSEN")
    					usp[id] = 5
    				}
    				else
    				{
					ColorChat(id, TEAM_COLOR, "%s ^1%L", szPrefix, LANG_SERVER, "WSM_NOTENOUGH", 670-oles[id])
    					usp_menu(id)
    				}
    			}
    			else
    			{
    				ColorChat(id, TEAM_COLOR, "%s ^1%L", szPrefix, LANG_SERVER, "WSM_USP")
    				usp_menu(id)
    			}
    		}
    	}

    	menu_destroy(menu)
    	return PLUGIN_HANDLED
}

public glock_menu(id) {
	
	new szText[512]
	new cim[121]
    	format(cim, charsmax(cim), "Glock Skinek [Öléseid: %d]",oles[id])
    	new menu = menu_create(cim, "glock_handler" )
	
	if(oles[id] < 30)
	{
		formatex(szText, charsmax(szText), "Arany Glock [Még %d ölés]", 30-oles[id])
		menu_additem(menu, szText, "1", 0)
	}
	else
	menu_additem(menu, "Arany Glock [Elérve]", "1", 0)
	if(oles[id] < 85)
	{
		formatex(szText, charsmax(szText), "Glock CityScape [Még %d ölés]", 85-oles[id])
		menu_additem(menu, szText, "2", 0)
	}
	else
	menu_additem(menu, "Glock CityScape [Elérve]", "2", 0)
	if(oles[id] < 190)
	{
		formatex(szText, charsmax(szText), "Glock Redline [Még %d ölés]", 190-oles[id])
		menu_additem(menu, szText, "3", 0)
	}
	else
	menu_additem(menu, "Glock Redline [Elérve]", "3", 0)
	if(oles[id] < 410)
	{
		formatex(szText, charsmax(szText), "Glock Water Element [Még %d ölés]", 410-oles[id])
		menu_additem(menu, szText, "4", 0)
	}
	else
	menu_additem(menu, "Glock Water Element [Elérve]", "4", 0)
	if(oles[id] < 680)
	{
		formatex(szText, charsmax(szText), "Glock Dragon [Még %d ölés]", 680-oles[id])
		menu_additem(menu, szText, "5", 0)
	}
	else
	menu_additem(menu, "Glock Dragon [Elérve]", "5", 0)
	
    	menu_display(id, menu, 0)
}

public glock_handler(id, menu, item) {
    	if( item == MENU_EXIT )
    	{
    	menu_destroy(menu);
    	return PLUGIN_HANDLED;
    	}
    	new data[9], szName[64];
    	new access, callback;
    	menu_item_getinfo(menu, item, access, data,charsmax(data), szName,charsmax(szName), callback);
    	new key = str_to_num(data);
    	switch(key)
    	{
    		case 1:{ //Glock1
    			if(glock[id] != 1) 
    			{
    				if(oles[id] >= 30)
    				{
    					ColorChat(id, TEAM_COLOR, "%s ^1%L Arany Glock-ot!", szPrefix, LANG_SERVER, "WSM_CHOSEN")
    					glock[id] = 1
    				}
    				else
    				{
    					ColorChat(id, TEAM_COLOR, "%s ^1%L", szPrefix, LANG_SERVER, "WSM_NOTENOUGH", 30-oles[id])
					glock_menu(id)
    				}
    			}
    			else
    			{
    				ColorChat(id, TEAM_COLOR, "%s ^1%L", szPrefix, LANG_SERVER, "WSM_GLOCK")
    				glock_menu(id)
    			}
    		} 
    		case 2:{  //Glock2
    			if(glock[id] != 2)
    			{
    				if(oles[id] >= 85)
    				{
    					ColorChat(id, TEAM_COLOR, "%s ^1%L Glock CityScape-et!", szPrefix, LANG_SERVER, "WSM_CHOSEN")
    					glock[id] = 2
    				}
    				else
    				{
    					ColorChat(id, TEAM_COLOR, "%s ^1%L", szPrefix, LANG_SERVER, "WSM_NOTENOUGH", 85-oles[id])
    					glock_menu(id)
    				}
    			}
    			else
    			{
    				ColorChat(id, TEAM_COLOR, "%s ^1%L", szPrefix, LANG_SERVER, "WSM_GLOCK")
    				glock_menu(id)
    			}
    		}
    		case 3:{ //Glock3
    			if(glock[id] != 3)
    			{
    				if(oles[id] >= 190)
    				{
    					ColorChat(id, TEAM_COLOR, "%s ^1%L Glock Redline-t!", szPrefix, LANG_SERVER, "WSM_CHOSEN")
    					glock[id] = 3
    				}
    				else
    				{
    					ColorChat(id, TEAM_COLOR, "%s ^1%L", szPrefix, LANG_SERVER, "WSM_NOTENOUGH", 190-oles[id])
    					glock_menu(id)
    				}	
    			}
    			else
    			{
    				ColorChat(id, TEAM_COLOR, "%s ^1%L", szPrefix, LANG_SERVER, "WSM_GLOCK")
    				glock_menu(id)
    			}
    		}
    		case 4:{ //Glock4
    			if(glock[id] != 4)
    			{
    				if(oles[id] >= 410)
    				{
    					ColorChat(id, TEAM_COLOR, "%s ^1%L Glock Water Element-et!", szPrefix, LANG_SERVER, "WSM_CHOSEN")
    					glock[id] = 4
    				}
    				else
    				{
    					ColorChat(id, TEAM_COLOR, "%s ^1%L", szPrefix, LANG_SERVER, "WSM_NOTENOUGH", 410-oles[id])
    					glock_menu(id)
    				}
    			}
    			else
    			{
    				ColorChat(id, TEAM_COLOR, "%s ^1%L", szPrefix, LANG_SERVER, "WSM_GLOCK")
				glock_menu(id)
    			}
    		}
    		case 5:{ //Glock5
    			if(glock[id] != 5)
    			{
    				if(oles[id] >= 680)
    				{
    					ColorChat(id, TEAM_COLOR, "%s ^1%L Glock Dragon-t!", szPrefix, LANG_SERVER, "WSM_CHOSEN")
    					glock[id] = 5
    				}
    				else
    				{
    					ColorChat(id, TEAM_COLOR, "%s ^1%L", szPrefix, LANG_SERVER, "WSM_NOTENOUGH", 680-oles[id])
					glock_menu(id)
    				}
    			}
    			else
    			{
    				ColorChat(id, TEAM_COLOR, "%s ^1%L", szPrefix, LANG_SERVER, "WSM_GLOCK")
    				glock_menu(id)
    			}
    		}
    	}

    	menu_destroy(menu)
    	return PLUGIN_HANDLED
}

public m4a1_menu(id) {
	
	new szText[512]
	new cim[121]
    	format(cim, charsmax(cim), "M4A1 Skinek [Öléseid: %d]",oles[id])
    	new menu = menu_create(cim, "m4a1_handler" )
	
	if(oles[id] < 150)
	{
		formatex(szText, charsmax(szText), "Arany M4A1 [Még %d ölés]", 150-oles[id])
		menu_additem(menu, szText, "1", 0)
	}
	else
	menu_additem(menu, "Arany M4A1 [Elérve]", "1", 0)
	if(oles[id] < 375)
	{
		formatex(szText, charsmax(szText), "Camo M4A1 [Még %d ölés]", 375-oles[id])
		menu_additem(menu, szText, "2", 0)
	}
	else
	menu_additem(menu, "Camo M4A1 [Elérve]", "2", 0)
	if(oles[id] < 750)
	{
		formatex(szText, charsmax(szText), "M4A1 Redlight [Még %d ölés]", 750-oles[id])
		menu_additem(menu, szText, "3", 0)
	}
	else
	menu_additem(menu, "M4A1 Redlight [Elérve]", "3", 0)
	if(oles[id] < 980)
	{
		formatex(szText, charsmax(szText), "M4A1 Bluelight [Még %d ölés]", 980-oles[id])
		menu_additem(menu, szText, "4", 0)
	}
	else
	menu_additem(menu, "M4A1 Bluelight [Elérve]", "4", 0)
	if(oles[id] < 1280)
	{
		formatex(szText, charsmax(szText), "M4A1 Erica [Még %d ölés]", 1280-oles[id])
		menu_additem(menu, szText, "5", 0)
	}
	else
	menu_additem(menu, "M4A1 Erica [Elérve]", "5", 0)
	
    	menu_display(id, menu, 0)
}

public m4a1_handler(id, menu, item) {
    	if( item == MENU_EXIT )
    	{
    	menu_destroy(menu);
    	return PLUGIN_HANDLED;
    	}
    	new data[9], szName[64];
    	new access, callback;
    	menu_item_getinfo(menu, item, access, data,charsmax(data), szName,charsmax(szName), callback);
    	new key = str_to_num(data);
    	switch(key)
    	{
    		case 1:{ //M4A11
    			if(m4a1[id] != 1) 
    			{
    				if(oles[id] >= 150)
    				{
    					ColorChat(id, TEAM_COLOR, "%s ^1%L Arany M4A1-et!", szPrefix, LANG_SERVER, "WSM_CHOSEN")
    					m4a1[id] = 1
    				}
    				else
    				{
    					ColorChat(id, TEAM_COLOR, "%s ^1%L", szPrefix, LANG_SERVER, "WSM_NOTENOUGH", 150-oles[id])
					m4a1_menu(id)
    				}
    			}
    			else
    			{
    				ColorChat(id, TEAM_COLOR, "%s ^1%L", szPrefix, LANG_SERVER, "WSM_M4A1")
    				m4a1_menu(id)
    			}
    		} 
    		case 2:{  //M4A12
    			if(m4a1[id] != 2)
    			{
    				if(oles[id] >= 375)
    				{
    					ColorChat(id, TEAM_COLOR, "%s ^1%L Camo M4A1-et!", szPrefix, LANG_SERVER, "WSM_CHOSEN")
    					m4a1[id] = 2
    				}
    				else
    				{
    					ColorChat(id, TEAM_COLOR, "%s ^1%L", szPrefix, LANG_SERVER, "WSM_NOTENOUGH", 375-oles[id])
    					m4a1_menu(id)
    				}
    			}
    			else
    			{
    				ColorChat(id, TEAM_COLOR, "%s ^1%L", szPrefix, LANG_SERVER, "WSM_M4A1")
    				m4a1_menu(id)
    			}
    		}
    		case 3:{ //Glock3
    			if(m4a1[id] != 3)
    			{
    				if(oles[id] >= 750)
    				{
    					ColorChat(id, TEAM_COLOR, "%s ^1%L M4A1 Redlight-ot!", szPrefix, LANG_SERVER, "WSM_CHOSEN")
    					m4a1[id] = 3
    				}
    				else
    				{
    					ColorChat(id, TEAM_COLOR, "%s ^1%L", szPrefix, LANG_SERVER, "WSM_NOTENOUGH", 750-oles[id])
    					m4a1_menu(id)
    				}	
    			}
    			else
    			{
    				ColorChat(id, TEAM_COLOR, "%s ^1%L", szPrefix, LANG_SERVER, "WSM_M4A1")
    				m4a1_menu(id)
    			}
    		}
    		case 4:{ //M4A14
    			if(m4a1[id] != 4)
    			{
    				if(oles[id] >= 980)
    				{
    					ColorChat(id, TEAM_COLOR, "%s ^1%L M4A1 Bluelight-ot!", szPrefix, LANG_SERVER, "WSM_CHOSEN")
    					m4a1[id] = 4
    				}
    				else
    				{
    					ColorChat(id, TEAM_COLOR, "%s ^1%L", szPrefix, LANG_SERVER, "WSM_NOTENOUGH", 980-oles[id])
    					m4a1_menu(id)
    				}
    			}
    			else
    			{
    				ColorChat(id, TEAM_COLOR, "%s ^1%L", szPrefix, LANG_SERVER, "WSM_M4A1")
				m4a1_menu(id)
    			}
    		}
    		case 5:{ //M4A15
    			if(m4a1[id] != 5)
    			{
    				if(oles[id] >= 1280)
    				{
    					ColorChat(id, TEAM_COLOR, "%s ^1%L M4A1 Erica-t!", szPrefix, LANG_SERVER, "WSM_CHOSEN")
    					m4a1[id] = 5
    				}
    				else
    				{
    					ColorChat(id, TEAM_COLOR, "%s ^1%L", szPrefix, LANG_SERVER, "WSM_NOTENOUGH", 1280-oles[id])
					m4a1_menu(id)
    				}
    			}
    			else
    			{
    				ColorChat(id, TEAM_COLOR, "%s ^1%L", szPrefix, LANG_SERVER, "WSM_M4A1")
    				m4a1_menu(id)
    			}
    		}
    	}

    	menu_destroy(menu)
    	return PLUGIN_HANDLED
}

public ak47_menu(id) {
	
	new szText[512]
	new cim[121]
    	format(cim, charsmax(cim), "AK47 Skinek [Öléseid: %d]",oles[id])
    	new menu = menu_create(cim, "ak47_handler" )
	
	if(oles[id] < 140)
	{
		formatex(szText, charsmax(szText), "Arany AK47 [Még %d ölés]", 140-oles[id])
		menu_additem(menu, szText, "1", 0)
	}
	else                
	menu_additem(menu, "Arany AK47 [Elérve]", "1", 0)
	if(oles[id] < 365)
	{
		formatex(szText, charsmax(szText), "Camo AK47 [Még %d ölés]", 365-oles[id])
		menu_additem(menu, szText, "1", 0)
	}
	else                
	menu_additem(menu, "Camo AK47 [Elérve]", "2", 0)
	if(oles[id] < 740) 
	{
		formatex(szText, charsmax(szText), "AK47 Redlight [Még %d ölés]", 740-oles[id])
		menu_additem(menu, szText, "1", 0)
	}
	else                
	menu_additem(menu, "AK47 Redlight [Elérve]", "3", 0)
	if(oles[id] < 970) 
	{
		formatex(szText, charsmax(szText), "AK47 Bluelight [Még %d ölés]", 970-oles[id])
		menu_additem(menu, szText, "1", 0)
	}
	else                
	menu_additem(menu, "AK47 Bluelight [Elérve]", "4", 0)
	if(oles[id] < 1180)
	{
		formatex(szText, charsmax(szText), "AK47 Erica [Még %d ölés]", 1180-oles[id])
		menu_additem(menu, szText, "1", 0)
	}
	else                
	menu_additem(menu, "AK47 Erica [Elérve]", "5", 0)
	
    	menu_display(id, menu, 0)
}

public ak47_handler(id, menu, item) {
    	if( item == MENU_EXIT )
    	{
    	menu_destroy(menu);
    	return PLUGIN_HANDLED;
    	}
    	new data[9], szName[64];
    	new access, callback;
    	menu_item_getinfo(menu, item, access, data,charsmax(data), szName,charsmax(szName), callback);
    	new key = str_to_num(data);
    	switch(key)
    	{
    		case 1:{ //AK471
    			if(ak47[id] != 1) 
    			{
    				if(oles[id] >= 140)
    				{
    					ColorChat(id, TEAM_COLOR, "%s ^1%L Arany AK47-et!", szPrefix, LANG_SERVER, "WSM_CHOSEN")
    					ak47[id] = 1                                                   
    				}
    				else
    				{
    					ColorChat(id, TEAM_COLOR, "%s ^1%L", szPrefix, LANG_SERVER, "WSM_NOTENOUGH", 140-oles[id])
					ak47_menu(id)  
    				}
    			}
    			else
    			{
    				ColorChat(id, TEAM_COLOR, "%s ^1%L", szPrefix, LANG_SERVER, "WSM_AK47")
    				ak47_menu(id)                                    
    			}
    		} 
    		case 2:{  //AK472
    			if(ak47[id] != 2)
    			{
    				if(oles[id] >= 365)
    				{
    					ColorChat(id, TEAM_COLOR, "%s ^1%L Camo AK47-et!", szPrefix, LANG_SERVER, "WSM_CHOSEN")
    					ak47[id] = 2                                                   
    				}
    				else
    				{
    					ColorChat(id, TEAM_COLOR, "%s ^1%L", szPrefix, LANG_SERVER, "WSM_NOTENOUGH", 365-oles[id])
    					ak47_menu(id)  
    				}
    			}
    			else
    			{
    				ColorChat(id, TEAM_COLOR, "%s ^1%L", szPrefix, LANG_SERVER, "WSM_AK47")
    				ak47_menu(id)                                     
    			}
    		}
    		case 3:{ //AK473
    			if(ak47[id] != 3)
    			{
    				if(oles[id] >= 740)
    				{
    					ColorChat(id, TEAM_COLOR, "%s ^1%L AK47 Redlight-ot!", szPrefix, LANG_SERVER, "WSM_CHOSEN")
    					ak47[id] = 3                                                   
    				}
    				else
    				{
    					ColorChat(id, TEAM_COLOR, "%s ^1%L", szPrefix, LANG_SERVER, "WSM_NOTENOUGH", 740-oles[id])
					ak47_menu(id)  
    				}	
    			}
    			else
    			{
    				ColorChat(id, TEAM_COLOR, "%s ^1%L", szPrefix, LANG_SERVER, "WSM_AK47")
    				ak47_menu(id)                                    
    			}
    		}
    		case 4:{ //AK474
    			if(ak47[id] != 4)
    			{
    				if(oles[id] >= 970)
    				{
    					ColorChat(id, TEAM_COLOR, "%s ^1%L AK47 Bluelight-ot!", szPrefix, LANG_SERVER, "WSM_CHOSEN")
    					ak47[id] = 4                                                   
    				}
    				else
    				{
    					ColorChat(id, TEAM_COLOR, "%s ^1%L", szPrefix, LANG_SERVER, "WSM_NOTENOUGH", 970-oles[id])
    					ak47_menu(id)  
    				}
    			}
    			else
    			{
    				ColorChat(id, TEAM_COLOR, "%s ^1%L", szPrefix, LANG_SERVER, "WSM_AK47")
				ak47_menu(id)                                     
    			}
    		}
    		case 5:{ //AK475
    			if(ak47[id] != 5)
    			{
    				if(oles[id] >= 1180)
    				{
    					ColorChat(id, TEAM_COLOR, "%s ^1%L AK47 Erica-t!", szPrefix, LANG_SERVER, "WSM_CHOSEN")
    					ak47[id] = 5                                                   
    				}
    				else
    				{
    					ColorChat(id, TEAM_COLOR, "%s ^1%L", szPrefix, LANG_SERVER, "WSM_NOTENOUGH", 1180-oles[id])
					ak47_menu(id)  
    				}
    			}
    			else
    			{
    				ColorChat(id, TEAM_COLOR, "%s ^1%L", szPrefix, LANG_SERVER, "WSM_AK47")
    				ak47_menu(id)                                     
    			}
    		}
    	}

    	menu_destroy(menu)
    	return PLUGIN_HANDLED
}

public mentes(id)
    {
    	new name[32]
    	get_user_name(id, name, 31)
    	new vaultkey[64],vaultdata[256]
    	format(vaultkey,63,"%s", name)
    	format(vaultdata,255,"%i",oles[id])
    	nvault_set(vault,vaultkey,vaultdata)
    	return PLUGIN_CONTINUE
    }
    public betoltes(id)
    {
    	new name[32]
    	get_user_name(id, name, 31)
    	new vaultkey[64],vaultdata[256]
    	format(vaultkey,63,"%s", name)
    	format(vaultdata,255,"%i",oles[id])
    	nvault_get(vault,vaultkey,vaultdata,255)
    	replace_all(vaultdata, 255, "#", " ")
    	new a_o[32]
    	parse(vaultdata, a_o, 31)
    	oles[id] = str_to_num(a_o)
    	return PLUGIN_CONTINUE
    }
public client_putinserver(id)
{
    	awp[id] = 0
	deagle[id] = 0	
	usp[id] = 0	
	glock[id] = 0	
	m4a1[id] = 0	
	ak47[id] = 0	
}
public client_connect(id)
{
    	betoltes(id)
}
public client_disconnect(id)
{
	mentes(id)
}

public fegyvervaltas(id) {
	new fgy = get_user_weapon(id)
	
	if(awp[id] == 1 && fgy == CSW_AWP)
	{
		set_pev(id, pev_viewmodel2, "models/wsm/awp_v1.mdl")
	}
	if(deagle[id] == 1 && fgy == CSW_DEAGLE)
	{
		set_pev(id, pev_viewmodel2, "models/wsm/deagle_v1.mdl")
	}
	if(usp[id] == 1 && fgy == CSW_USP)
	{
		set_pev(id, pev_viewmodel2, "models/wsm/usp_v1.mdl")
	}
	if(glock[id] == 1 && fgy == CSW_GLOCK18)
	{
		set_pev(id, pev_viewmodel2, "models/wsm/glock18_v1.mdl")
	}
	if(m4a1[id] == 1 && fgy == CSW_M4A1)
	{
		set_pev(id, pev_viewmodel2, "models/wsm/m4a1_v1.mdl")
	}
	if(ak47[id] == 1 && fgy == CSW_AK47)
	{
		set_pev(id, pev_viewmodel2, "models/wsm/ak47_v1.mdl")
	}
	if(awp[id] == 2 && fgy == CSW_AWP)
	{
		set_pev(id, pev_viewmodel2, "models/wsm/awp_v2.mdl")
	}
	if(deagle[id] == 2 && fgy == CSW_DEAGLE)
	{
		set_pev(id, pev_viewmodel2, "models/wsm/deagle_v2.mdl")
	}
	if(usp[id] == 2 && fgy == CSW_USP)
	{
		set_pev(id, pev_viewmodel2, "models/wsm/usp_v2.mdl")
	}
	if(glock[id] == 2 && fgy == CSW_GLOCK18)
	{
		set_pev(id, pev_viewmodel2, "models/wsm/glock18_v2.mdl")
	}
	if(m4a1[id] == 2 && fgy == CSW_M4A1)
	{
		set_pev(id, pev_viewmodel2, "models/wsm/m4a1_v2.mdl")
	}
	if(ak47[id] == 2 && fgy == CSW_AK47)
	{
		set_pev(id, pev_viewmodel2, "models/wsm/ak47_v2.mdl")
	}
	if(awp[id] == 3 && fgy == CSW_AWP)
	{
		set_pev(id, pev_viewmodel2, "models/wsm/awp_v3.mdl")
	}
	if(deagle[id] == 3 && fgy == CSW_DEAGLE)
	{
		set_pev(id, pev_viewmodel2, "models/wsm/deagle_v3.mdl")
	}
	if(usp[id] == 3 && fgy == CSW_USP)
	{
		set_pev(id, pev_viewmodel2, "models/wsm/usp_v3.mdl")
	}
	if(glock[id] == 3 && fgy == CSW_GLOCK18)
	{
		set_pev(id, pev_viewmodel2, "models/wsm/glock18_v3.mdl")
	}
	if(m4a1[id] == 3 && fgy == CSW_M4A1)
	{
		set_pev(id, pev_viewmodel2, "models/wsm/m4a1_v3.mdl")
	}
	if(ak47[id] == 3 && fgy == CSW_AK47)
	{
		set_pev(id, pev_viewmodel2, "models/wsm/ak47_v3.mdl")
	}
	if(awp[id] == 4 && fgy == CSW_AWP)
	{
		set_pev(id, pev_viewmodel2, "models/wsm/awp_v4.mdl")
	}
	if(deagle[id] == 4 && fgy == CSW_DEAGLE)
	{
		set_pev(id, pev_viewmodel2, "models/wsm/deagle_v4.mdl")
	}
	if(usp[id] == 4 && fgy == CSW_USP)
	{
		set_pev(id, pev_viewmodel2, "models/wsm/usp_v4.mdl")
	}
	if(glock[id] == 4 && fgy == CSW_GLOCK18)
	{
		set_pev(id, pev_viewmodel2, "models/wsm/glock18_v4.mdl")
	}
	if(m4a1[id] == 4 && fgy == CSW_M4A1)
	{
		set_pev(id, pev_viewmodel2, "models/wsm/m4a1_v4.mdl")
	}
	if(ak47[id] == 4 && fgy == CSW_AK47)
	{
		set_pev(id, pev_viewmodel2, "models/wsm/ak47_v4.mdl")
	}
	if(awp[id] == 5 && fgy == CSW_AWP)
	{
		set_pev(id, pev_viewmodel2, "models/wsm/awp_v5.mdl")
	}
	if(deagle[id] == 5 && fgy == CSW_DEAGLE)
	{
		set_pev(id, pev_viewmodel2, "models/wsm/deagle_v5.mdl")
	}
	if(usp[id] == 5 && fgy == CSW_USP)
	{
		set_pev(id, pev_viewmodel2, "models/wsm/usp_v5.mdl")
	}
	if(glock[id] == 5 && fgy == CSW_GLOCK18)
	{
		set_pev(id, pev_viewmodel2, "models/wsm/glock18_v5.mdl")
	}
	if(m4a1[id] == 5 && fgy == CSW_M4A1)
	{
		set_pev(id, pev_viewmodel2, "models/wsm/m4a1_v5.mdl")
	}
	if(ak47[id] == 5 && fgy == CSW_AK47)
	{
		set_pev(id, pev_viewmodel2, "models/wsm/ak47_v5.mdl")
	}
}
/* AMXX-Studio Notes - DO NOT MODIFY BELOW HERE
*{\\ rtf1\\ ansi\\ deff0{\\ fonttbl{\\ f0\\ fnil Tahoma;}}\n\\ viewkind4\\ uc1\\ pard\\ lang1038\\ f0\\ fs16 \n\\ par }
*/
