/*
	oo    o       o    o o
	o  o  o o   o o  o
	o  o  o  o o  o  o
	o  o  o   o   o  o
	oo    o       o    o o
	
	Plugin name:    DeRoiD's Mapchooser
	Plugin version: 1.62 Alpha
	First relase:   2015/04/08
	Last Update:    2015/04/22
	Author:         DeRoiD
	
	Changelog:
	
		- v1.0
			+ First relase http://hlmod.hu/viewtopic.php?f=100&t=20224
			+ Map choose (Old method)
			+ Played maps
			+ Next map
			+ Timeleft
		
		
		- v1.2b
			+ Rounds
			+ Nomination
			+ Admin vote
			+ Rock the vote
		
		
		- v1.30b
			+ Previous map can not be choose
		
		
		- v1.35b
			+ Fix bugs
			+ New chooser method
			+ More map choices [MAX 9]
		
		
		- v1.49a
			+ Re-vote if vote percent < min percent
			+ Removed hard coding paths. (Thanks HamletEagle)
		
		
		- v1.53a
			+ Fixed extend time [ +- 1 min ]
			+ Fixed changelevel bug.
			
			
		- v1.62a
			+ Hud Counter
			+ Change map only next round. (Cvar)
			+ Fix bugs
	
	
	Short description [default cvar]:
		This plugin last 3 minutes or round open the "Vote a map" menu. 
		The one for which more people vote it will be the next map. 
		If best vote < min. vote percent then re-vote! There is a manner of two kinds.
		
		
	You can [default cvar]:
		rtv "Rock the vote" [players 1:2]
		nom "Nomination" (in menu) [chance 50%]
		see timeleft | nextmap [timeleft, nextmap]
		see played maps and played counts [/playedmaps]
		if you admin then can startvote (/startvote) [StartVoteFlag]
		
	Plugin link: forums.alliedmods.net/showthread.php?t=261412
*/
#include <amxmodx>

new const PLUGIN[] = "DeRoiD's Mapchooser";
new const VERSION[] = "1.62a";
new const AUTHOR[] = "DeRoiD";

#define MapID 180912

#define R 255
#define G 255
#define B 255
#define CHUD 1.1

#define Max 200
#define MinRounds 5
#define MaxChoice 9
#define StartVoteFlag ADMIN_LEVEL_A

#pragma semicolon 1

new MapFile[64], PrevMapFile[64], MapCycle[32], MapFile_Lines, MapCycle_Lines;
new Maps[Max][32], MapName[32], MapNames[MaxChoice][32], MapRevote[2][32], NomMaps[Max][32], NomNum, Nom, Nomed[Max];
new MapVote[MaxChoice], RevoteCounts[2], VoteMenu, RevoteMenu, MapCounter, PrevMap[32], BeginCounter;
new AllVotes, AllRevotes, Next[32], RTV, RTVTime[3], PlayerMap[33], ElapsedTime[3];
new bool:Voted, bool:PlayerVoted[33], bool:ChangeMap, bool:Begined, bool:inProcess, bool:Revoted,
bool:PlayerRTV[33], bool:toRTV, bool:AlreadyNom[33], bool:PlayerRevoted[33], bool:NeedRV;
new SayText, Rounds, MaxRounds, oTimeLimit, oRounds;

new Cvar_WaitVoteMenuTime, Cvar_MenuDestroyTime, Cvar_RTVMinute, Cvar_VoteCounter,
Cvar_NomChance, Cvar_VoteSound, Cvar_Extend, Cvar_StartRevoteTime, Cvar_VotePercentMin,
Cvar_Nomination, Cvar_PlayedMaps, Cvar_RTV, Cvar_VoteVariable, Cvar_RTVMin, Cvar_Mod,
Cvar_ChangeSpeed, Cvar_MaxMaps, Cvar_WaitRevoteMenuTime, Cvar_HudMod, Cvar_OnlyNextRound;

new Prefix[32];

new const MapMenuCommands[][] =
{
	"/playedmaps",
	"/pm",
	"!playedmaps",
	"!pm",
	"playedmaps",
	"pm"
};
new const TimeLeftCommands[][] =
{
	"/timeleft",
	"/tl",
	"!timeleft",
	"!tl",
	"timeleft",
	"tl"
};
new const NextMapCommands[][] =
{
	"/nextmap",
	"/nm",
	"!nextmap",
	"!nm",
	"nextmap",
	"nm"
};
new const AdminCommands[][] =
{
	"/startvote",
	"!startvote",
	"startvote"
};
new const RTVCommands[][] =
{
	"/rtv",
	"!rtv",
	"/rockthevote",
	"!rockthevote",
	"rockthevote",
	"rtv"
};
new const NomCommands[][] =
{
	"/nom",
	"!nom",
	"/nomination",
	"!nomination",
	"nom",
	"nomination"
};

public plugin_init()
{
	register_plugin(PLUGIN, VERSION, AUTHOR);
	register_cvar(PLUGIN, VERSION, FCVAR_SERVER);
	register_dictionary("dmc.txt");
	
	static ConfigsDir[64]; 
	get_localinfo("amxx_configsdir", ConfigsDir, 63);
	formatex(MapFile, 63, "%s/dmc/mapdatas.dmc", ConfigsDir);
	get_localinfo("amxx_configsdir", ConfigsDir, 63);
	formatex(PrevMapFile, 63, "%s/dmc/prevmap.dmc", ConfigsDir);
	formatex(MapCycle, 31, "mapcycle.txt");
	formatex(Prefix, 31, "!g[DMC]");
	
	MapFile_Lines = file_size(MapFile, 1);
	MapCycle_Lines = file_size(MapCycle, 1);
	
	Cvar_Mod = register_cvar("DMC_Mod", "1");
	Cvar_HudMod = register_cvar("DMC_HudMod", "1");
	Cvar_ChangeSpeed = register_cvar("DMC_ChangeSpeed", "3.0");
	Cvar_WaitVoteMenuTime = register_cvar("DMC_WaitVoteMenuTime", "10.0");
	Cvar_WaitRevoteMenuTime = register_cvar("DMC_WaitRevoteMenuTime", "5.0");
	Cvar_MenuDestroyTime = register_cvar("DMC_MenuDestroyTime", "5.0");
	Cvar_RTVMinute = register_cvar("DMC_RTVMinute", "10");
	Cvar_VoteCounter = register_cvar("DMC_VoteCounter", "15");
	Cvar_VoteVariable = register_cvar("DMC_VoteVariable", "3");
	Cvar_VotePercentMin = register_cvar("DMC_VotePercent", "50");
	Cvar_MaxMaps = register_cvar("DMC_MaxMaps", "5");
	Cvar_Nomination = register_cvar("DMC_Nomination", "1");
	Cvar_PlayedMaps = register_cvar("DMC_PlayedMaps", "1");
	Cvar_RTV = register_cvar("DMC_RTV", "1");
	Cvar_VoteSound = register_cvar("DMC_VoteSound", "1");
	Cvar_RTVMin = register_cvar("DMC_RTVMin", "2");
	Cvar_NomChance = register_cvar("DMC_NomChance", "50");
	Cvar_Extend = register_cvar("DMC_Extend", "15");
	Cvar_StartRevoteTime = register_cvar("DMC_StartRevoteTime", "5.0");
	Cvar_OnlyNextRound = register_cvar("DMC_OnlyNextRound", "1");

	
	VoteMenu = register_menuid("VoteMenu");
	RevoteMenu = register_menuid("RevoteMenu");
	register_menucmd(VoteMenu, 1023, "VoteMenuKeys");
	register_menucmd(RevoteMenu, 1023, "RevoteMenuKeys");
	SayText = get_user_msgid("SayText");
	
	server_cmd("exec server.cfg");
	oTimeLimit = get_cvar_num("mp_timelimit");
	MaxRounds = get_cvar_num("mp_maxrounds");
	oRounds = MaxRounds;
	
	if(get_pcvar_num(Cvar_MaxMaps) > MaxChoice)
	{
		set_pcvar_num(Cvar_MaxMaps, MaxChoice);
	}
	
	if(get_pcvar_num(Cvar_MaxMaps) == 1)
	{
		set_pcvar_num(Cvar_MaxMaps, 2);
	}
	
	if(MapCycle_Lines-get_pcvar_num(Cvar_MaxMaps) < 0)
	{
		new Error[64];
		formatex(Error, charsmax(Error), "Only %d maps in %s file! (Min: %d)", MapCycle_Lines, MapCycle, get_pcvar_num(Cvar_MaxMaps));
		log_amx(Error);
		
		if(MapCycle_Lines > 1)
		{
			set_pcvar_num(Cvar_MaxMaps, MapCycle_Lines);
			formatex(Error, charsmax(Error), "MaxMaps set %d", MapCycle_Lines);
			log_amx(Error);
		}
	}
	
	register_event("HLTV", "NewRound", "a", "1=0", "2=0");
	
	if(get_pcvar_num(Cvar_Mod) == 0)
	{	
		register_logevent("RestartRound", 2, "0=World triggered", "1&Restart_Round_");
		register_logevent("RestartRound", 2, "0=World triggered", "1=Game_Commencing");
		register_logevent("RoundEnd", 2, "0=World triggered", "1=Round_End");
		
		if(MaxRounds < MinRounds)
		{
			server_cmd("mp_maxrounds ^"%d^"", MinRounds);
		}
		
		server_cmd("mp_timelimit 0");
		
		MaxRounds = get_cvar_num("mp_maxrounds");
		oRounds = MaxRounds;
	}
	
	new Cmd[32];
	if(get_pcvar_num(Cvar_PlayedMaps) == 1)
	{
		for(new Num = 0; Num < sizeof MapMenuCommands; Num++)
		{
			format(Cmd, charsmax(Cmd), "say %s", MapMenuCommands[Num]);
			register_clcmd(Cmd, "ShowMapMenu");
		}
	}
	
	for(new Num = 0; Num < sizeof NextMapCommands; Num++)
	{
		format(Cmd, charsmax(Cmd), "say %s", NextMapCommands[Num]);
		register_clcmd(Cmd, "ShowNextMap");
	}
	
	for(new Num = 0; Num < sizeof TimeLeftCommands; Num++)
	{
		format(Cmd, charsmax(Cmd), "say %s", TimeLeftCommands[Num]);
		register_clcmd(Cmd, "ShowTimeLeft");
	}
	
	for(new Num = 0; Num < sizeof AdminCommands; Num++)
	{
		format(Cmd, charsmax(Cmd), "say %s", AdminCommands[Num]);
		register_clcmd(Cmd, "StartVote");
	}
	
	if(get_pcvar_num(Cvar_RTV) == 1)
	{
		for(new Num = 0; Num < sizeof RTVCommands; Num++)
		{
			format(Cmd, charsmax(Cmd), "say %s", RTVCommands[Num]);
			register_clcmd(Cmd, "RockTheVote");
		}
	}
	
	if(get_pcvar_num(Cvar_Nomination) == 1)
	{
		for(new Num = 0; Num < sizeof NomCommands; Num++)
		{
			format(Cmd, charsmax(Cmd), "say %s", NomCommands[Num]);
			register_clcmd(Cmd, "ShowNomMenu");
		}
	}
	
	get_mapname(MapName, charsmax(MapName));
	
	set_task(0.1, "LoadOldMap");
	set_task(0.2, "LoadMaps");
	set_task(0.3, "LoadVoteMaps");
	
	set_task(0.8, "CheckTime", MapID-1, _, _, "b");
	set_task(random_float(100.0, 200.0), "AdvTime", MapID-10, _, _, "b");
	
	toRTV = false;
	set_task(0.4, "SavePresentTime");
}
public SavePresentTime()
{	
	new Hour[32], Minute[32], Second[32];
	format_time(Hour, sizeof(Hour) - 1, "%H");
	format_time(Minute, sizeof(Minute) - 1, "%M");
	format_time(Second, sizeof(Second) - 1, "%S");
	ElapsedTime[0] = str_to_num(Second);
	ElapsedTime[1] = str_to_num(Minute);
	ElapsedTime[2] = str_to_num(Hour);
	RTVTime[2] = str_to_num(Hour);
	RTVTime[1] = str_to_num(Minute)+get_pcvar_num(Cvar_RTVMinute);
	RTVTime[0] = str_to_num(Second);
	
	if(RTVTime[1] >= 60)
	{
		RTVTime[1] -= 60;
		RTVTime[2]++;
	}
}
public AdvTime()
{
	print_color(0, "%s %L", Prefix, LANG_SERVER, "ADV", PLUGIN, VERSION);
}
public RestartRound() {
	Rounds = 0;
	NeedRV = false;
	ChangeMap = false;
	Voted = false;
	Revoted = false;
	inProcess = false;
	AllVotes = 0;
	
	for(new Num = 0; Num < 32; Num++)
	{
		AlreadyNom[Num] = false;
		PlayerMap[Num] = 0;
	}
	
	for(new Num = 0; Num < get_pcvar_num(Cvar_MaxMaps); Num++)
	{
		MapVote[Num] = 0;
	}
}
public RoundEnd() {
	if(MaxRounds-Rounds > 0)
	{
		Rounds += 1;
	}
}
public NewRound()
{
	if(get_pcvar_num(Cvar_Mod) == 1)
	{
		if(ChangeMap && Voted && Begined && !Revoted || ChangeMap && Revoted && Begined && !Voted)
		{
			ChangeLevel();
		}
	}
	else if(get_pcvar_num(Cvar_Mod) == 0)
	{
		if(Rounds >= MaxRounds)
		{
			if(ChangeMap && Voted && Begined && !Revoted || ChangeMap && Revoted && Begined && !Voted)
			{
				ChangeLevel();
			}
		}
	}
}
public StartVote(id)
{
	if(get_user_flags(id) & StartVoteFlag)
	{
		if(!inProcess)
		{
			NeedRV = false;
			ChangeMap = false;
			Revoted = false;
			Voted = false;
			new String[32];
			float_to_str(get_pcvar_float(Cvar_WaitVoteMenuTime), String, 2);
			replace_all(String, 2, ".", "");
			set_task(get_pcvar_float(Cvar_WaitVoteMenuTime), "StartMapChooser", MapID+3);
			Begined = true;
			client_cmd(0, "spk fvox/time_is_now");
			inProcess = true;
			
			if(get_pcvar_num(Cvar_Mod) == 1)
			{
				server_cmd("mp_timelimit 0");
			}
			else if(get_pcvar_num(Cvar_Mod) == 0)
			{
				Rounds = MaxRounds;
			}
			
			if(get_pcvar_num(Cvar_HudMod) == 1)
			{
				remove_task(MapID+8123);
				BeginCounter = str_to_num(String);
				VoteCounter();
			}
			else if(get_pcvar_num(Cvar_HudMod) == 0)
			{
				set_hudmessage(R, G, B, -1.0, 0.20, 0, 6.0, get_pcvar_float(Cvar_WaitVoteMenuTime));
				show_hudmessage(0, "%L", LANG_SERVER, "VOTE2", String);
			}
		}
	}
}
public VoteCounter()
{
	if(BeginCounter > 0)
	{
		new String[32];
		num_to_str(BeginCounter, String, 2);
		
		set_hudmessage(R, G, B, -1.0, 0.20, 0, 0.1, CHUD);
		if(NeedRV)
		{
			show_hudmessage(0, "%L", LANG_SERVER, "VOTE4", String);
		}
		else
		{
			show_hudmessage(0, "%L", LANG_SERVER, "VOTE3", String);
		}
		
		BeginCounter--;
		set_task(1.0, "VoteCounter", MapID+8123);
	}
}
public RockTheVote(id)
{
	new Hour[32], Minute[32], Time[2];
	format_time(Hour, sizeof(Hour) - 1, "%H");
	format_time(Minute, sizeof(Minute) - 1, "%M");
	Time[0] = str_to_num(Hour);
	Time[1] = str_to_num(Minute);
	
	if(Time[0] > RTVTime[2]
	|| Time[0] == RTVTime[2] && Time[1] >= RTVTime[1])
	toRTV = true;
	
	if(PlayerRTV[id] || Voted || inProcess || !toRTV)
	{
		if(!toRTV)
		{
			if(RTVTime[2] > Time[0])
			{
				print_color(id, "%s %L", Prefix, LANG_SERVER, "RTV2", (RTVTime[1]+60)-Time[1]);
			}
			else
			{
				print_color(id, "%s %L", Prefix, LANG_SERVER, "RTV2", RTVTime[1]-Time[1]);
			}
		}
		if(PlayerRTV[id])
		print_color(id, "%s %L", Prefix, LANG_SERVER, "RTV1");
		
		return PLUGIN_HANDLED;
	}
	
	PlayerRTV[id] = true;
	RTV++;
	
	new Players[32], Num;
	get_players(Players, Num, "c");
	
	if(RTV >= Num/get_pcvar_num(Cvar_RTVMin))
	{
		new String[32];
		float_to_str(get_pcvar_float(Cvar_WaitVoteMenuTime), String, 2);
		replace_all(String, 2, ".", "");
		set_task(get_pcvar_float(Cvar_WaitVoteMenuTime), "StartMapChooser", MapID+3);
		Begined = true;
		client_cmd(0, "spk fvox/time_is_now");
		inProcess = true;
		
		if(get_pcvar_num(Cvar_Mod) == 1)
		{
			server_cmd("mp_timelimit 0");
		}
		else if(get_pcvar_num(Cvar_Mod) == 0)
		{
			Rounds = MaxRounds;
		}
		
		if(get_pcvar_num(Cvar_HudMod) == 1)
		{
			remove_task(MapID+8123);
			BeginCounter = str_to_num(String);
			VoteCounter();
		}
		else if(get_pcvar_num(Cvar_HudMod) == 0)
		{
			set_hudmessage(R, G, B, -1.0, 0.20, 0, 6.0, get_pcvar_float(Cvar_WaitVoteMenuTime));
			show_hudmessage(0, "%L", LANG_SERVER, "VOTE1", String);
		}
	}
	else
	{
		print_color(0, "%s %L", Prefix, LANG_SERVER, "RTV3", (Num/get_pcvar_num(Cvar_RTVMin))-RTV);
	}
	
	return PLUGIN_HANDLED;
}
public Extend()
{
	NeedRV = false;
	ChangeMap = false;
	Begined = false;
	Voted = false;
	Revoted = false;
	inProcess = false;
	AllVotes = 0;
	AllRevotes = 0;
	
	for(new Num = 0; Num < 32; Num++)
	{
		AlreadyNom[Num] = false;
		PlayerMap[Num] = 0;
		PlayerVoted[Num] = false;
		PlayerRevoted[Num] = false;
	}
	
	for(new Num = 0; Num < Nom; Num++)
	{
		NomMaps[Num] = "";
	}
	
	for(new Num = 0; Num < Max; Num++)
	{
		Nomed[Num] = 0;
	}
	
	for(new Num = 0; Num < get_pcvar_num(Cvar_MaxMaps); Num++)
	{
		MapNames[Num] = "";
		MapVote[Num] = 0;
	}
	
	RTV = 0;
	Nom = 0;
	LoadVoteMaps();
	LoadNomMaps();
	Next = "";
}
public CheckTime()
{
	static Time[3];
	Time[0] = get_timeleft();
	Time[1] = Time[0] / 60;
	Time[2] = Time[1] / 60;
	Time[0] = Time[0] - Time[1] * 60;
	Time[1] = Time[1] - Time[2] * 60;
	
	if(get_pcvar_num(Cvar_Mod) == 1)
	{
		if(Time[1] <= get_pcvar_num(Cvar_VoteVariable) && !Begined && !inProcess)
		{
			new String[32];
			float_to_str(get_pcvar_float(Cvar_WaitVoteMenuTime), String, 2);
			replace_all(String, 2, ".", "");
			
			if(get_pcvar_num(Cvar_HudMod) == 1)
			{
				remove_task(MapID+8123);
				BeginCounter = str_to_num(String);
				VoteCounter();
			}
			else if(get_pcvar_num(Cvar_HudMod) == 0)
			{
				set_hudmessage(R, G, B, -1.0, 0.20, 0, 6.0, get_pcvar_float(Cvar_WaitVoteMenuTime));
				show_hudmessage(0, "%L", LANG_SERVER, "VOTE3", String);
			}
		
			set_task(get_pcvar_float(Cvar_WaitVoteMenuTime), "StartMapChooser", MapID+3);
			Begined = true;
			client_cmd(0, "spk fvox/time_is_now");
			inProcess = true;
		}
	
		if(Time[0] <= 3 && Time[1] == 0 && Time[2] == 0)
		{
			server_cmd("mp_timelimit 0");
			if(!ChangeMap && Voted && !inProcess && !Revoted
			|| !ChangeMap && Revoted && !inProcess && !Voted)
			{
				if(get_pcvar_num(Cvar_OnlyNextRound) == 1)
				{
					print_color(0, "%s %L", Prefix, LANG_SERVER, "MCAR");
					ChangeMap = true;
				}
				else if(get_pcvar_num(Cvar_OnlyNextRound) == 0)
				{
					ChangeMap = true;
					ChangeLevel();
				}
			}
		}
	}
	else if(get_pcvar_num(Cvar_Mod) == 0)
	{
		if(Rounds == MaxRounds-get_pcvar_num(Cvar_VoteVariable) && !Begined && !inProcess)
		{
			new String[32];
			float_to_str(get_pcvar_float(Cvar_WaitVoteMenuTime), String, 2);
			replace_all(String, 2, ".", "");
			
			if(get_pcvar_num(Cvar_HudMod) == 1)
			{
				remove_task(MapID+8123);
				BeginCounter = str_to_num(String);
				VoteCounter();
			}
			else if(get_pcvar_num(Cvar_HudMod) == 0)
			{
				set_hudmessage(R, G, B, -1.0, 0.20, 0, 6.0, get_pcvar_float(Cvar_WaitVoteMenuTime));
				show_hudmessage(0, "%L", LANG_SERVER, "VOTE3", String);
			}
			
			set_task(get_pcvar_float(Cvar_WaitVoteMenuTime), "StartMapChooser", MapID+3);
			Begined = true;
			client_cmd(0, "spk fvox/time_is_now");
			inProcess = true;
		}
		
		if(Rounds >= MaxRounds && !ChangeMap && Voted
		|| Rounds >= MaxRounds && !ChangeMap && Revoted)
		{
			print_color(0, "%s %L", Prefix, LANG_SERVER, "MCAR");
			ChangeMap = true;
		}
	}
	
	if(!toRTV)
	{
		new Hour[32], Minute[32];
		format_time(Hour, sizeof(Hour) - 1, "%H");
		format_time(Minute, sizeof(Minute) - 1, "%M");
		Time[2] = str_to_num(Hour);
		Time[1] = str_to_num(Minute);
		
		if(RTVTime[2] == Time[2] && RTVTime[1]+get_pcvar_num(Cvar_RTVMinute) <= Time[1])
		{
			toRTV = true;
		}
	}
}
public StartMapChooser()
{
	remove_task(MapID+3);
	ChangeMap = false;
	Voted = false;
	MapCounter = get_pcvar_num(Cvar_VoteCounter);
	Counter();
	client_cmd(0, "spk Gman/Gman_Choose%i", random_num(1, 2));
}
public Change()
{
	server_cmd("changelevel ^"%s^"", Next);
}
public ShowTimeLeft()
{
	if(get_pcvar_num(Cvar_Mod) == 1)
	{
		static Time[3];
		Time[0] = get_timeleft();
		Time[1] = Time[0] / 60;
		Time[2] = Time[1] / 60;
		Time[0] = Time[0] - Time[1] * 60;
		Time[1] = Time[1] - Time[2] * 60;
		if(ChangeMap && Voted && Begined && !Revoted || ChangeMap && Revoted && Begined && !Voted)
		{
			print_color(0, "%s!y %L!t 0!y:!t00!y:!t00", Prefix, LANG_SERVER, "TL");
		}
		else
		{
			print_color(0, "%s!y %L!t %d%!y:!t%02d!y:!t%02d", Prefix, LANG_SERVER, "TL", Time[2], Time[1], Time[0]);
		}
	}
	else if(get_pcvar_num(Cvar_Mod) == 0)
	{
		print_color(0, "%s!t %L", Prefix, LANG_SERVER, "RM", MaxRounds-Rounds);
	}
}
public ShowNextMap()
{
	new Status[2][32];
	formatex(Status[0], 31, "%L", LANG_SERVER, "NYT");
	formatex(Status[1], 31, "%L", LANG_SERVER, "VIP");
	if(strlen(Next) > 2)
	print_color(0, "%s!y %L!t %s", Prefix, LANG_SERVER, "NM", Next);
	else
	{
		if(inProcess)
		print_color(0, "%s!y %L!t %s", Prefix, LANG_SERVER, "NM", Status[1]);
		else
		print_color(0, "%s!y %L!t %s", Prefix, LANG_SERVER, "NM", Status[0]);
	}
}
public Counter()
{
	if(MapCounter < 1)
	{
		Voted = true;
		
		CheckVotes();
		
		for(new Num; Num < 32; Num++)
		{
			ShowVoteMenu(Num);
		}
	
		return;
	}
	
	MapCounter--;
	
	set_task(1.0, "Counter", MapID+1);
	
	for(new Num; Num < 32; Num++)
	{
		ShowVoteMenu(Num);
	}
}
public NextMap()
{
	remove_task(MapID-4);
	set_task(get_pcvar_float(Cvar_MenuDestroyTime), "DestroyVoteMenu", MapID-4);
	inProcess = false;
}
public DestroyVoteMenu()
{
	for(new Num; Num < 32; Num++)
	{
		show_menu(Num, 0, "^n", 1);
	}
}
public ShowVoteMenu(id)
{
	new Menu[512], String[128], Key, MapPercent[MaxChoice];
	
	AllVotes = 0;
	
	for(new All; All < get_pcvar_num(Cvar_MaxMaps); All++)
	{
		AllVotes += MapVote[All];
	}
	
	formatex(String, 127, "%L", LANG_SERVER, "CHONM", AllVotes);
	add(Menu, 511, String);
	
	for(new Num; Num < get_pcvar_num(Cvar_MaxMaps); Num++)
	{
		if(MapVote[Num] > 0)
		MapPercent[Num] = ((MapVote[Num]*100)/(AllVotes));
		if(equal(MapName, MapNames[Num]))
		formatex(String, 127, "%L", LANG_SERVER, "MOP5", Num+1, MapNames[Num], MapVote[Num], MapPercent[Num]);
		else
		formatex(String, 127, "%L", LANG_SERVER, "MOPD", Num+1, MapNames[Num], MapVote[Num], MapPercent[Num]);
		add(Menu, 511, String);
	}
	
	if(Voted)
	formatex(String, 127, "%L", LANG_SERVER, "MNM", Next);
	else if(!Revoted && !Voted && MapCounter <= 0 && NeedRV)
	formatex(String, 127, "%L", LANG_SERVER, "MNRE");
	else
	formatex(String, 127, "%L", LANG_SERVER, "MCSL", MapCounter);
	
	add(Menu, 511, String);
	
	Key = (-1^(-1<<(get_pcvar_num(Cvar_MaxMaps))));
	
	show_menu(id, Key, Menu, -1, "VoteMenu");
}
public VoteMenuKeys(id, Key)
{
	
	if(PlayerVoted[id] || Voted)
	{
		if(PlayerVoted[id])
		print_color(id, "%s %L", Prefix, LANG_SERVER, "AVO");
		
		return;
	}
	
	if(!Begined)
	{
		show_menu(id, 0, "^n", 1);
		return;
	}
	
	new PlayerName[32];
	get_user_name(id, PlayerName, 31);
	
	if(Key <= get_pcvar_num(Cvar_MaxMaps)-1)
	{
		PlayerMap[id] = Key;
		PlayerVoted[id] = true;
		print_color(0, "%s %L", Prefix, LANG_SERVER, "PCHO", PlayerName, MapNames[Key]);
		MapVote[Key]++;
		if(get_pcvar_num(Cvar_VoteSound) == 1)
		client_cmd(0, "spk buttons/lightswitch2");
	}
	
	ShowVoteMenu(id);
}
public LoadVoteMaps()
{
	new Line[128], Map[32], Len, Used[Max], Loaded, File;
	
	File = fopen(MapCycle, "rt");
	
	if(File)
	{
		
		for(new lNum; lNum < Max; lNum++)
		{
			new RandomMap = random(MapCycle_Lines);
			read_file(MapCycle, RandomMap, Line, 127, Len);
			
			parse(Line, Map, 31);
			
			if(equali(Map, MapNames[0]) || equali(Map, MapNames[1]) || equali(Map, MapNames[2])
			|| equali(Map, MapNames[3]) || equali(Map, MapNames[4]) || equali(Map, MapNames[5])
			|| equali(Map, MapNames[6]) || equali(Map, PrevMap) || equali(Map, MapName))
			continue;
			
			if(Used[RandomMap] == 0 && Loaded < get_pcvar_num(Cvar_MaxMaps)-1)
			{
				Used[RandomMap] = 1;
				copy(MapNames[Loaded], sizeof(Map) - 1, Map);
				Loaded++;
			}
		}
		
	}
	
	fclose(File);
	
	MapNames[get_pcvar_num(Cvar_MaxMaps)-1] = MapName;
	set_task(0.1, "LoadNomMaps", MapID+69);
}
public LoadNomMaps()
{
	new Line[128], Map[32], File;
	
	File = fopen(MapCycle, "rt");
	
	while(!feof(File))
	{
		fgets(File, Line, charsmax(Line));
			
		parse(Line, Map, 31);
		
		if(NomNum < MapCycle_Lines)
		{
			copy(NomMaps[NomNum], sizeof(Map) - 1, Map);
			NomNum++;
		}
	}
	
	fclose(File);
}
public ShowMapMenu(id)
{
	new Menu, MenuLine[128], MapDatas[2][32], String[32];
	formatex(MenuLine, 127, "%L", LANG_SERVER, "MPNM");
	Menu = menu_create(MenuLine, "MapKey");
	
	for(new MapNum; MapNum < MapFile_Lines-1; MapNum++)
	{
		parse(Maps[MapNum], MapDatas[0], 31, MapDatas[1], 31);
		formatex(MenuLine, 127, "%L", LANG_SERVER, "PMPM", MapDatas[0], MapDatas[1]);
		num_to_str(MapNum, String, 2);
		menu_additem(Menu, MenuLine, String);
	}
	
	formatex(MenuLine, 127, "%L", LANG_SERVER, "MNEXT");
	menu_setprop(Menu, MPROP_NEXTNAME, MenuLine);
	formatex(MenuLine, 127, "%L", LANG_SERVER, "MEXIT");
	menu_setprop(Menu, MPROP_EXITNAME, MenuLine);
	formatex(MenuLine, 127, "%L", LANG_SERVER, "MBACK");
	menu_setprop(Menu, MPROP_BACKNAME, MenuLine);
	menu_display(id, Menu);
}
public MapKey(id, Menu, Item)
{
	new MenuNum[2], Data[2][32], Key;
	menu_item_getinfo(Menu, Item, MenuNum[0], Data[0], charsmax(Data), Data[1], charsmax(Data), MenuNum[1]);
	
	Key = str_to_num(Data[0]);
	
	if(Item == MENU_EXIT)
	{
		menu_destroy(Menu);
		return;
	}
	
	new MapDatas[2][32];
	parse(Maps[Key], MapDatas[0], 31, MapDatas[1], 31);
	
	print_color(id, "%s %L", Prefix, LANG_SERVER, "MNP", MapDatas[0], MapDatas[1]);
}
public ShowNomMenu(id)
{	
	if(Nom > get_pcvar_num(Cvar_MaxMaps)-1)
	{
		print_color(id, "%s %L", Prefix, LANG_SERVER, "NOMT");
		return;
	}
	if(AlreadyNom[id])
	{
		print_color(id, "%s %L", Prefix, LANG_SERVER, "NOMN");
		return;
	}
	if(inProcess || Voted || Revoted)
	{
		return;
	}
	
	new Menu, MenuLine[128];
	formatex(MenuLine, 127, "%L", LANG_SERVER, "NOMM");
	Menu = menu_create(MenuLine, "NomKey");
	
	for(new MapNum; MapNum < NomNum-get_pcvar_num(Cvar_MaxMaps); MapNum++)
	{
		if(Nomed[MapNum] == 1)
		continue;
		
		if(equali(NomMaps[MapNum], MapNames[0]) || equali(NomMaps[MapNum], MapNames[1]) || equali(NomMaps[MapNum], MapNames[2])
		|| equali(NomMaps[MapNum], MapNames[3]) || equali(NomMaps[MapNum], MapNames[4]) || equali(NomMaps[MapNum], MapNames[5])
		|| equali(NomMaps[MapNum], MapNames[6]) || equali(NomMaps[MapNum], PrevMap) || equali(NomMaps[MapNum], MapName))
		continue;
		
		formatex(MenuLine, 127, "%L", LANG_SERVER, "NOM1", NomMaps[MapNum]);
		menu_additem(Menu, MenuLine, NomMaps[MapNum]);
	}
	
	formatex(MenuLine, 127, "%L", LANG_SERVER, "MNEXT");
	menu_setprop(Menu, MPROP_NEXTNAME, MenuLine);
	formatex(MenuLine, 127, "%L", LANG_SERVER, "MEXIT");
	menu_setprop(Menu, MPROP_EXITNAME, MenuLine);
	formatex(MenuLine, 127, "%L", LANG_SERVER, "MBACK");
	menu_setprop(Menu, MPROP_BACKNAME, MenuLine);
	menu_display(id, Menu);
}
public NomKey(id, Menu, Item)
{
	
	if(Nom > get_pcvar_num(Cvar_MaxMaps)-1)
	{
		print_color(id, "%s %L", Prefix, LANG_SERVER, "NOMT");
		return PLUGIN_HANDLED;
	}
	if(AlreadyNom[id])
	{
		print_color(id, "%s %L", Prefix, LANG_SERVER, "NOMN");
		return PLUGIN_HANDLED;
	}
	if(inProcess || Voted)
	{
		return PLUGIN_HANDLED;
	}
	
	new MenuNum[2], Data_1[32], Data_2[32], PlayerName[32];
	menu_item_getinfo(Menu, Item, MenuNum[0], Data_1, charsmax(Data_1), Data_2, charsmax(Data_2), MenuNum[1]);
	
	if(Item == MENU_EXIT)
	{
		menu_destroy(Menu);
		return PLUGIN_HANDLED;
	}
	
	if(equali(Data_1, MapNames[0]) || equali(Data_1, MapNames[1])
	|| equali(Data_1, MapNames[2]) || equali(Data_1, MapNames[3])
	|| equali(Data_1, MapNames[4]) || equali(Data_1, MapNames[5])
	|| equali(Data_1, MapNames[6]) || equali(Data_1, PrevMap))
	return PLUGIN_HANDLED;
	
	get_user_name(id, PlayerName, charsmax(PlayerName));
	
	print_color(0, "%s %L", Prefix, LANG_SERVER, "NOMC", PlayerName, Data_1);
	
	if(get_pcvar_num(Cvar_NomChance) >= (random_num(1,100)))
	{
		MapNames[Nom] = Data_1;
	}
	
	MapNames[Nom] = Data_1;
	Nomed[Nom] = 1;
	Nom++;
	AlreadyNom[id] = true;
	
	return PLUGIN_HANDLED;
}
public LoadMapMenu()
{
	new Line[64], File, Len;
	
	File = fopen(MapFile, "rt");
	
	if(File)
	{
		for(new MapNum; MapNum < MapFile_Lines; MapNum++)
		{
			read_file(MapFile, MapNum, Line, 63, Len);
			
			if(Line[0] == ';' || strlen(Line) < 2)
				continue;
				
			remove_quotes(Line);
			
			copy(Maps[MapNum], sizeof(Line) - 1, Line);
		}
	}
	
	fclose(File);
}
public LoadMaps()
{
	remove_task(MapID);
	
	new Line[64], File, MapDatas[2][32], LineNum, MapNum, bool:Found;
	File = fopen(MapFile, "rt");
	
	while(!feof(File))
	{
		fgets(File, Line, charsmax(Line));
		
		if(Line[0] == ';' || strlen(Line) < 2)
			continue;
			
		parse(Line, MapDatas[0], 31, MapDatas[1], 31);
		
		if(equal(MapDatas[0], MapName))
		{
			MapNum = str_to_num(MapDatas[1])+1;
			format(Line, sizeof Line - 1, "^"%s^" ^"%d^"", MapName, MapNum);
			write_file(MapFile, Line, LineNum);
			Found = true;
		}
		
		LineNum++;
	}
	
	fclose(File);
	
	if(!Found)
	{
		NewMap();
	}
	
	set_task(0.5, "LoadMapMenu", MapID);
}
public NewMap()
{
	new Line[32], File;
	File = fopen(MapFile, "at+");
	formatex(Line, sizeof Line - 1, "^"%s^" ^"%d^"^n", MapName, 1);
	fprintf(File, Line);
	fclose(File);
}
public OldMap()
{
	new Line[32], File;
	File = fopen(PrevMapFile, "at+");
	formatex(Line, sizeof Line - 1, "^"%s^"", MapName);
	write_file(PrevMapFile, Line, 0);
	fclose(File);
}
public LoadOldMap()
{
	new Line[32], File;
	
	File = fopen(PrevMap, "rt");
	
	if(File)
	{
		fgets(File, Line, charsmax(Line));
			
		if(Line[0] == ';' || strlen(Line) < 2)
			return;
			
		remove_quotes(Line);
		
		copy(PrevMap, sizeof(Line) - 1, Line);
	}
	
	fclose(File);
}
public StartRevoteTime() 
{
	new String[32];
	float_to_str(get_pcvar_float(Cvar_WaitRevoteMenuTime), String, 2);
	replace_all(String, 2, ".", "");
	
	if(get_pcvar_num(Cvar_HudMod) == 1)
	{
		remove_task(MapID+8123);
		BeginCounter = str_to_num(String);
		VoteCounter();
	}
	else if(get_pcvar_num(Cvar_HudMod) == 0)
	{
		set_hudmessage(R, G, B, -1.0, 0.20, 0, 6.0, get_pcvar_float(Cvar_WaitVoteMenuTime));
		show_hudmessage(0, "%L", LANG_SERVER, "VOTE4", String);
	}
			
	client_cmd(0, "spk fvox/time_is_now");
	inProcess = true;
	set_task(get_pcvar_float(Cvar_StartRevoteTime), "StartRevote", MapID+33);
}
public StartRevote() 
{
	Voted = false;
	Begined = true;
	MapCounter = get_pcvar_num(Cvar_VoteCounter);
	ReCounter();
	client_cmd(0, "spk Gman/Gman_Choose%i", random_num(1, 2));
}
public ShowRevoteMenu(id)
{
	new Menu[512], String[128], Key, MapPercent[MaxChoice];
	
	AllRevotes = 0;
	
	for(new All; All < 2; All++)
	{
		AllRevotes += RevoteCounts[All];
	}
	
	formatex(String, 127, "%L", LANG_SERVER, "CHONM", AllRevotes);
	add(Menu, 511, String);
	
	for(new Num; Num < 2; Num++)
	{
		if(RevoteCounts[Num] > 0)
		MapPercent[Num] = ((RevoteCounts[Num]*100)/(AllRevotes));
		formatex(String, 127, "%L", LANG_SERVER, "MOPD", Num+1, MapRevote[Num], RevoteCounts[Num], MapPercent[Num]);
		add(Menu, 511, String);
	}
	
	if(!Revoted)
	formatex(String, 127, "%L", LANG_SERVER, "MCSL", MapCounter);
	else
	formatex(String, 127, "%L", LANG_SERVER, "MNM", Next);
	
	add(Menu, 511, String);
	
	Key = (-1^(-1<<(2)));
	
	show_menu(id, Key, Menu, -1, "RevoteMenu");
}
public RevoteMenuKeys(id, Key)
{
	if(PlayerRevoted[id] || Revoted)
	{
		if(PlayerVoted[id])
		print_color(id, "%s %L", Prefix, LANG_SERVER, "AVO");
		
		ShowRevoteMenu(id);
		return;
	}
	
	if(!Begined)
	{
		show_menu(id, 0, "^n", 1);
		return;
	}
	
	new PlayerName[32];
	get_user_name(id, PlayerName, 31);
	
	if(Key <= 2)
	{
		PlayerMap[id] = Key;
		PlayerRevoted[id] = true;
		print_color(0, "%s %L", Prefix, LANG_SERVER, "PCHO", PlayerName, MapRevote[Key]);
		RevoteCounts[Key]++;
		if(get_pcvar_num(Cvar_VoteSound) == 1)
		client_cmd(0, "spk buttons/lightswitch2");
	}
	
	ShowRevoteMenu(id);
}
public ReCounter()
{
	if(MapCounter < 1)
	{
		Revoted = true;
		CheckRevotes();
		set_task(get_pcvar_float(Cvar_MenuDestroyTime), "DestroyVoteMenu", MapID-4);
		inProcess = false;
		
		for(new Num; Num < 32; Num++)
		{
			ShowRevoteMenu(Num);
		}
	
		return;
	}
	
	MapCounter--;
	
	set_task(1.0, "ReCounter", MapID+211);
	
	for(new Num; Num < 32; Num++)
	{
		ShowRevoteMenu(Num);
	}
}
public client_disconnect(id)
{
	if(PlayerRTV[id])
	{
		RTV--;
		PlayerRTV[id] = false;
	}
	if(PlayerVoted[id])
	{
		MapVote[PlayerMap[id]]--;
		PlayerVoted[id] = false;
	}
	if(PlayerRevoted[id])
	{
		RevoteCounts[PlayerMap[id]]--;
		PlayerRevoted[id] = false;
	}
}
stock ChangeLevel()
{
	if(ChangeMap && Voted && Begined && !Revoted || ChangeMap && Revoted && Begined && !Voted)
	{
		set_task(get_pcvar_float(Cvar_ChangeSpeed), "Change", MapID+2);
		message_begin(MSG_ALL, SVC_INTERMISSION);
		message_end();
		server_cmd("mp_timelimit ^"%d^"", oTimeLimit);
		server_cmd("mp_maxrounds ^"%d^"", oRounds);
		OldMap();
	}
}
stock print_color(const id, const input[], any:...)
{
	new Count = 1, Players[32];
	static Msg[191];
	vformat(Msg, 190, input, 3);
	
	replace_all(Msg, 190, "!g", "^4");
	replace_all(Msg, 190, "!y", "^1");
	replace_all(Msg, 190, "!t", "^3");

	if(id) Players[0] = id; else get_players(Players, Count, "ch");
	{
		for (new i = 0; i < Count; i++)
		{
			if (is_user_connected(Players[i]))
			{
				message_begin(MSG_ONE_UNRELIABLE, SayText, _, Players[i]);
				write_byte(Players[i]);
				write_string(Msg);
				message_end();
			}
		}
	}
	return PLUGIN_HANDLED;
}
stock CheckVotes() {
	
	if(AllVotes == 0)
	{
		Next = MapNames[0];
		return;
	}
	
	new VoteNum_1 = 0;
	
	for(new Num = 0; Num < MaxChoice; ++Num)
	{
		if(MapVote[VoteNum_1] < MapVote[Num])
		VoteNum_1 = Num;
	}
	
	if((MapVote[VoteNum_1]*100/AllVotes) >= get_pcvar_num(Cvar_VotePercentMin))
	{
		Revoted = false;
		Next = MapNames[VoteNum_1];
		set_cvar_string("amx_nextmap", Next);
		
		if(get_pcvar_num(Cvar_Mod) == 1)
		{
			if(equali(Next, MapName))
			{
				new Hour[32], Minute[32], Second[32], pTime[3];
				format_time(Hour, sizeof(Hour) - 1, "%H");
				format_time(Minute, sizeof(Minute) - 1, "%M");
				format_time(Second, sizeof(Second) - 1, "%S");
				pTime[0] = str_to_num(Second);
				pTime[1] = str_to_num(Minute);
				pTime[2] = str_to_num(Hour);
				
				pTime[1] = pTime[1] - ElapsedTime[1];
				
				if(pTime[0] >= ElapsedTime[0])
					pTime[0] = pTime[0] - ElapsedTime[0];
				else
				{
					pTime[0] = pTime[0]+60 - ElapsedTime[0];
					pTime[1]--;
				}
				
				if(pTime[2] == ElapsedTime[2])
				server_cmd("mp_timelimit %d.%02d", get_pcvar_num(Cvar_Extend)+pTime[1], pTime[0]);
				else
				server_cmd("mp_timelimit %d.%02d", (get_pcvar_num(Cvar_Extend)+pTime[1])+(60*(pTime[2]-ElapsedTime[2])), pTime[0]);
				
				print_color(0, "%s %L", Prefix, LANG_SERVER, "MEXTEND1", get_pcvar_num(Cvar_Extend));
				
				Extend();
				
				set_task(0.1, "DestroyVoteMenu");
			}
		}
		else if(get_pcvar_num(Cvar_Mod) == 0)
		{
			if(equali(Next, MapName))
			{
				print_color(0, "%s %L", Prefix, LANG_SERVER, "MEXTEND2", get_pcvar_num(Cvar_Extend));
				server_cmd("mp_maxrounds ^"%d^"", get_pcvar_num(Cvar_Extend)+oRounds);
				
				Rounds = 0;
				MaxRounds = get_pcvar_num(Cvar_Extend);
				
				Extend();
				
				set_task(0.1, "DestroyVoteMenu");
			}
		}
	
		NextMap();
		
		if(!equali(Next, MapName))
		ShowNextMap();
	}
	else
	{
		NeedRV = true;
		Voted = false;
		
		MapVote[VoteNum_1] = -MapVote[VoteNum_1];
		
		new VoteNum_1_1 = 0;

		for(new Num = 0; Num < MaxChoice; ++Num)
		{
			if(MapVote[VoteNum_1_1] < MapVote[Num])
			VoteNum_1_1 = Num;
		}
		
		MapVote[VoteNum_1] = 0-MapVote[VoteNum_1];
		
		copy(MapRevote[0], 31, MapNames[VoteNum_1]);
		copy(MapRevote[1], 31, MapNames[VoteNum_1_1]);
		
		RevoteCounts[0] = 0;
		RevoteCounts[1] = 0;
		
		set_task(get_pcvar_float(Cvar_StartRevoteTime), "StartRevoteTime", MapID+3);
		print_color(0, "%s %L", Prefix, LANG_SERVER, "RER", get_pcvar_num(Cvar_VotePercentMin));
		
		NextMap();
	}	
}
stock CheckRevotes() {
	
	if(AllRevotes == 0)
	{
		Next = MapRevote[0];
		return;
	}
	
	new VoteNum_1 = 0;
	
	for(new Num = 0; Num < 2; ++Num)
	{
		if(RevoteCounts[VoteNum_1] < RevoteCounts[Num])
		VoteNum_1 = Num;
	}
	
	Next = MapRevote[VoteNum_1];
	set_cvar_string("amx_nextmap", Next);
	Voted = false;
	NeedRV = false;
	
	if(get_pcvar_num(Cvar_Mod) == 1)
	{
		if(equali(Next, MapName))
		{
			new Hour[32], Minute[32], Second[32], pTime[3];
			format_time(Hour, sizeof(Hour) - 1, "%H");
			format_time(Minute, sizeof(Minute) - 1, "%M");
			format_time(Second, sizeof(Second) - 1, "%S");
			pTime[0] = str_to_num(Second);
			pTime[1] = str_to_num(Minute);
			pTime[2] = str_to_num(Hour);
			
			pTime[1] = pTime[1] - ElapsedTime[1];
			
			if(pTime[0] >= ElapsedTime[0])
				pTime[0] = pTime[0] - ElapsedTime[0];
			else
			{
				pTime[0] = pTime[0]+60 - ElapsedTime[0];
				pTime[1]--;
			}
			
			if(pTime[2] == ElapsedTime[2])
			server_cmd("mp_timelimit %d.%02d", get_pcvar_num(Cvar_Extend)+pTime[1], pTime[0]);
			else
			server_cmd("mp_timelimit %d.%02d", (get_pcvar_num(Cvar_Extend)+pTime[1])+(60*(pTime[2]-ElapsedTime[2])), pTime[0]);
			
			print_color(0, "%s %L", Prefix, LANG_SERVER, "MEXTEND1", get_pcvar_num(Cvar_Extend));
			
			Extend();
			
			set_task(0.1, "DestroyVoteMenu");
		}
	}
	else if(get_pcvar_num(Cvar_Mod) == 0)
	{
		if(equali(Next, MapName))
		{
			print_color(0, "%s %L", Prefix, LANG_SERVER, "MEXTEND2", get_pcvar_num(Cvar_Extend));
			server_cmd("mp_maxrounds ^"%d^"", get_pcvar_num(Cvar_Extend)+oRounds);
			
			Rounds = MaxRounds-get_pcvar_num(Cvar_Extend);
			MaxRounds = get_pcvar_num(Cvar_Extend);
			
			Extend();
			
			set_task(0.1, "DestroyVoteMenu");
		}
	}
	
	if(!equali(Next, MapName))
	ShowNextMap();
	NextMap();
}
/* AMXX-Studio Notes - DO NOT MODIFY BELOW HERE
*{\\ rtf1\\ ansi\\ deff0{\\ fonttbl{\\ f0\\ fnil Tahoma;}}\n\\ viewkind4\\ uc1\\ pard\\ lang1038\\ f0\\ fs16 \n\\ par }
*/
