#include <amxmodx>
#include <celltrie>
#include <hamsandwich>
#include <orpheu>
#include <orpheu_stocks>

#define MAX_PLAYERS 32
#define VERSION "1.4-nokill"

//----------------------------------------------------------------------------------------------
new _pg_is_h
#define _IsHuman(%1) ( _pg_is_h & 1<<%1 )
#define _SetHuman(%1) _pg_is_h |= 1<<%1
#define _SetNotHuman(%1) _pg_is_h &= ~( 1<<%1 )
//----------------------------------------------------------------------------------------------
new _pg_spawned
#define _HasSpawned(%1) ( _pg_spawned & 1<<%1 )
#define _SetSpawned(%1) _pg_spawned |= 1<<%1
#define _SetNotSpawned(%1) _pg_spawned &= ~(1<<%1)
#define _ResetSpawned() _pg_spawned = 0
//----------------------------------------------------------------------------------------------
new _pg_block
#define _IsBlocked(%1) ( _pg_block & 1<<%1 )
#define _SetBlock(%1) _pg_block |= 1<<%1
#define _SetNoBlock(%1) _pg_block &= ~(1<<%1)
#define _ResetBlocked() _pg_block = 0
//----------------------------------------------------------------------------------------------

new g_pGameRules

new bool:g_stored_ips
new g_p_ip[MAX_PLAYERS+1][16]
new Trie:g_trie_ips

new Float:g_late_spawn_time_limit

new pcvar_spawn_time
new pcvar_enabled

new bool:g_block_late_spawn
new g_enabled

public plugin_init(){
    register_plugin("BlockReconnectRespawn", VERSION, "Sylwester")
    register_cvar("brr_ver", VERSION, FCVAR_SERVER)

    RegisterHam(Ham_Spawn, "player", "Player_Spawn", 1)
    
    register_event("HLTV", "event_new_round", "a", "1=0", "2=0")
    register_logevent("logevent_round_start", 2, "1=Round_Start")
    pcvar_spawn_time = register_cvar("brr_spawn_time", "0")
    pcvar_enabled = register_cvar("brr_enabled", "1")

    OrpheuRegisterHookFromObject(g_pGameRules,"FPlayerCanRespawn","CGameRules","OnFPlayerCanRespawn")
    g_trie_ips = TrieCreate()
}


public plugin_precache()
    OrpheuRegisterHook(OrpheuGetFunction("InstallGameRules"),"OnInstallGameRules",OrpheuHookPost)


public OnInstallGameRules()
    g_pGameRules = OrpheuGetReturn()


public OrpheuHookReturn:OnFPlayerCanRespawn(gamerules, id){
    if(!_IsHuman(id) || _HasSpawned(id))
        return OrpheuIgnored
    if(_IsBlocked(id)){
        OrpheuSetReturn(false)
        return OrpheuSupercede
    }

    if(g_block_late_spawn && g_late_spawn_time_limit < get_gametime()){
        OrpheuSetReturn(false)
        return OrpheuSupercede
    }
    return OrpheuIgnored
}


public Player_Spawn(id){
    if(!_IsHuman(id) || !is_user_alive(id))
        return
    _SetSpawned(id)
}


public logevent_round_start(){
    g_enabled = get_pcvar_num(pcvar_enabled)
    new late_spawn_time = get_pcvar_num(pcvar_spawn_time)
    if(late_spawn_time <= 0){
        g_block_late_spawn = false
        return
    }
    g_block_late_spawn = true
    g_late_spawn_time_limit = get_gametime()+float(late_spawn_time)
}


public event_new_round(){
    if(g_stored_ips){
        TrieClear(g_trie_ips)
        g_stored_ips = false
    }
    _ResetSpawned()
    _ResetBlocked()
    g_block_late_spawn = false
}


public client_putinserver(id){
    if(is_user_bot(id) || is_user_hltv(id))
        return
    _SetHuman(id)
    get_user_ip(id, g_p_ip[id], 15)
    if(g_enabled && TrieKeyExists(g_trie_ips, g_p_ip[id])){
        _SetBlock(id)
    }
}


public client_disconnect(id){
    if(_HasSpawned(id) && !_IsBlocked(id) && g_enabled){
        g_stored_ips = true
        TrieSetCell(g_trie_ips, g_p_ip[id], 0)
    }
    _SetNoBlock(id)
    _SetNotSpawned(id)
    _SetNotHuman(id)
}


public plugin_end(){
    TrieDestroy(g_trie_ips)
}