#include <amxmodx>
#include <fun>
#include <hamsandwich>

#pragma semicolon 1;

#define PLUGIN "Surf Godmode"
#define VERSION "1.5"
#define AUTHOR "ILUSION"

#define DMG_NADE (1 << 24)

new g_godmode[33], g_time[33], g_respawn[33];

new enabled, timetowait;

public plugin_init()
{
	register_plugin(PLUGIN, VERSION, AUTHOR);
	
	register_clcmd("say /godmode", "cmdGodMode");
	
	RegisterHam(Ham_Spawn, "player", "fw_PlayerSpawn_Post", 1);
	RegisterHam(Ham_TraceAttack, "player", "fw_TraceAttack");
	RegisterHam(Ham_TakeDamage, "player", "fw_TakeDamage");
	
	enabled = register_cvar("amx_surf_godmode", "1");
	timetowait = register_cvar("amx_surf_wait", "120");
	
	register_dictionary("surf_godmode.txt");
	
	register_cvar("amx_surf_godmode_version", VERSION, FCVAR_SERVER);
}

public plugin_cfg()
{
	new map[32];
	get_mapname(map, charsmax(map));
	
	if (containi(map, "surf_") == -1)
		pause("a");
}		

public client_putinserver(id)
{
	g_godmode[id] = false;
	g_respawn[id] = false;
}

public client_disconnect(id)
{
	g_godmode[id] = false;
	g_respawn[id] = false;
}	

public fw_PlayerSpawn_Post(id)
{
	if (!get_pcvar_num(enabled))
		return HAM_IGNORED;
		
	if (g_godmode[id] && is_user_alive(id))
		set_user_rendering(id, kRenderFxGlowShell, 255, 255, 50, kRenderNormal, 25);
	
	if (!g_respawn[id])
	{
		new name[32];
		get_user_name(id, name, charsmax(name));
				
		client_print(id, print_chat, "%L", id, "WELCOME_MSG", name, VERSION);
		
		g_respawn[id] = true;
	}
	
	return HAM_IGNORED;	
}
		
public fw_TraceAttack(victim, attacker, Float:dmg, Float:dir[3], traceresult, dmgbits)
{
	if (!get_pcvar_num(enabled))
		return HAM_IGNORED;
		
	if (g_godmode[attacker] || g_godmode[victim])
		return HAM_SUPERCEDE;
	
	return HAM_IGNORED;
}

public fw_TakeDamage(victim, inflictor, attacker, Float:damage, damage_type)
{
	if (!is_user_connected(attacker) || !get_pcvar_num(enabled))
		return HAM_IGNORED;
	
	if (damage_type & DMG_NADE && g_godmode[victim] || g_godmode[attacker])
	{
		SetHamParamFloat(4, 0.0);
		return HAM_SUPERCEDE;
	}	
	
	return HAM_IGNORED;
}

public cmdGodMode(id)
{
	if (!get_pcvar_num(enabled))
	{
		client_print(id, print_chat, "%L", id, "GODMODE_DISABLED");
		return PLUGIN_HANDLED;
	}
	
	new delay = get_pcvar_num(timetowait);
	new wait = get_systime() - g_time[id];
	
	if (!g_godmode[id]  && delay > wait)
	{
		client_print(id, print_chat, "%L", id, "GODMODE_WAIT", delay - wait);
		return PLUGIN_HANDLED;
	}
	
	if (!g_godmode[id] && !is_user_alive(id))
	{
		client_print(id, print_chat, "%L", id, "GODMODE_ALIVE_ONLY");
		return PLUGIN_HANDLED;
	}
	
	if (g_godmode[id])
	{
		client_print(id, print_chat, "%L", id, "GODMODE_OFF");
		set_user_rendering(id, kRenderFxNone, 0, 0, 0, kRenderNormal, 0);
		g_time[id] = get_systime();
		g_godmode[id] = false;
	}
	else
	{
		set_user_rendering(id, kRenderFxGlowShell, 255, 255, 50, kRenderNormal, 25);
		client_print(id, print_chat, "%L", id, "GODMODE_ON");
		g_godmode[id] = true;
	}	
	
	return PLUGIN_CONTINUE;
}