#include <amxmodx>
#include <amxmisc>
#include <hamsandwich>
#include <fakemeta_util>
#include <cstrike>
 
#if defined _surf_included
#endif
#define _surf_included
#endinput
native surf_get_user_points(index);
native surf_set_user_points(index, amount);
native surf_add_user_points(index, amount);
native surf_del_user_points(index, amount);
 
// Pragma
#pragma semicolon 1
 
// Plugin info
new const PLUGIN[] =	"Surf Buy";
new const VERSION[] =	"1.0";
new const AUTHOR[] =	"Hattrick";
 
// Customization
new const xPrefix[] =	"!g[Surf Pontrendszer]";
new const ConfigFile[] = "addons/amxmodx/configs/surf_buy.cfg";
 
// Unlimited clip offsets
#if cellbits == 32
	const OFFSET_CLIPAMMO = 51;
#else
	const OFFSET_CLIPAMMO = 65;
#endif
const OFFSET_LINUX_WEAPONS = 4;
 
// Maxclip const
new const MAXCLIP[] = { -1, 13, -1, 10, 1, 7, -1, 30, 30, 1, 30, 20, 25, 30, 35, 25, 12, 20, 10, 30, 100, 8, 30, 30, 20, 2, 7, 30, 30, -1, 50 };
 
// Entities list
new entlist[][] = { "func_button", "trigger_multiple", "trigger_once" };
 
// Cvars
new cvar_health1_cost, cvar_speed_cost, cvar_gravity_cost, cvar_invisibility_cost, cvar_moneys_cost, cvar_damage_cost, cvar_noclip_cost, cvar_godmode_cost,
cvar_health2_cost, cvar_unlimitedclip_cost, cvar_jail_cost, cvar_shotguns_cost,
cvar_health1_cost2, cvar_speed_cost2, cvar_gravity_cost2, cvar_invisibility_cost2, cvar_moneys_cost2, cvar_damage_cost2, cvar_noclip_cost2, cvar_godmode_cost2,
cvar_health2_cost2, cvar_unlimitedclip_cost2, cvar_jail_cost2, cvar_shotguns_cost2;
 
// Bools
new bool:b_Speed[33], bool:b_Invisibility[33], bool:b_Damage[33], bool:b_Noclip[33], bool:b_Godmode[33],
bool:b_Unlimitedclip[33], b_Spawns[33], g_GodmodeCount[33], g_NoclipCount[33], bool:b_Gravity[33], bool:b_Shotguns[33];
 
// Init
public plugin_init()
{
	// Register the plugin
	register_plugin(PLUGIN, VERSION, AUTHOR);
 
	// Register the plugin dictionary
	register_dictionary("surf_buy.txt");
 
	// Register the plugins events
	register_event("CurWeapon", "event_CurWeapon", "be", "1=1");
 
	// Client commands
	register_clcmd("say /menu", "command_Buy");
	register_clcmd("say menu", "command_Buy");
	register_clcmd("say /shop", "command_Buy");
	register_clcmd("say shop", "command_Buy");
 
	// Menu commands
	register_menucmd(register_menuid("aaaxMenu1"), 1023, "BuyMenu");
	register_menucmd(register_menuid("bbbxMenu2"), 1023, "BuyMenu2");
 
	// Messages
	register_message(get_user_msgid("CurWeapon"), "message_cur_weapon");
 
	// Plugin cvars
	cvar_health1_cost = register_cvar("surf_health1_cost", "3");
	cvar_speed_cost = register_cvar("surf_speed_cost", "3");
	cvar_gravity_cost = register_cvar("surf_gravity_cost", "3");
	cvar_invisibility_cost = register_cvar("surf_invisibility_cost", "4");
	cvar_moneys_cost = register_cvar("surf_moneys_cost", "4");
	cvar_damage_cost = register_cvar("surf_damage_cost", "5");
	cvar_noclip_cost = register_cvar("surf_noclip_cost", "7");
	cvar_godmode_cost = register_cvar("surf_godmode_cost", "7");
	cvar_health2_cost = register_cvar("surf_health2_cost", "8");
	cvar_unlimitedclip_cost = register_cvar("surf_unlimitedclip_cost", "8");
	cvar_jail_cost = register_cvar("surf_jail_cost", "3");
	cvar_shotguns_cost = register_cvar("surf_shotguns_cost", "8");
	cvar_health1_cost2 = register_cvar("surf_health1_cost2", "1500");
	cvar_speed_cost2 = register_cvar("surf_speed_cost2", "1750");
	cvar_gravity_cost2 = register_cvar("surf_gravity_cost2", "1500");
	cvar_invisibility_cost2 = register_cvar("surf_invisibility_cost2", "2000");
	cvar_moneys_cost2 = register_cvar("surf_moneys_cost2", "10000");
	cvar_damage_cost2 = register_cvar("surf_damage_cost2", "8000");
	cvar_noclip_cost2 = register_cvar("surf_noclip_cost2", "12000");
	cvar_godmode_cost2 = register_cvar("surf_godmode_cost2", "12000");
	cvar_health2_cost2 = register_cvar("surf_health2_cost2", "14500");
	cvar_unlimitedclip_cost2 = register_cvar("surf_unlimitedclip_cost2", "14500");
	cvar_jail_cost2 = register_cvar("surf_jail_cost2", "3750");
	cvar_shotguns_cost2 = register_cvar("surf_shotguns_cost2", "15000");
 
	// Forwards
	RegisterHam(Ham_Spawn, "player", "ham_PlayerSpawned_Post", 1);
	RegisterHam(Ham_TakeDamage, "player", "ham_TakeDamage");
}
 
// Public plugin config
public plugin_cfg()
{
	new x[128];
	format(x, 127, "exec %s", ConfigFile);
	server_cmd(x);
	server_exec();
}
 
// Menu format
public command_Buy(id)
{
	// Make menu (2024 max characters)
	new menuBody[2025];
	add(menuBody, 2024, "\ySurf Pontrendszer^n^n");
	add(menuBody, 2024, "\r1.\w let \y[+255 HP]^n");
	add(menuBody, 2024, "\r2.\w Gyorsasg \y[350 Sebessg]^n");
	add(menuBody, 2024, "\r3.\w Gravitci \y[500 Gravitci]^n");
	add(menuBody, 2024, "\r4.\w Lthatatlansg \y[100% Lthatatlansg]^n");
	add(menuBody, 2024, "\r5.\w Pnz \y[+12500$]^n");
	add(menuBody, 2024, "\r6.\w Sebzs \y[2x DMG]^n");
	add(menuBody, 2024, "\r7.\w Noclip \y[20 msodperc]^n");
	add(menuBody, 2024, "\r8.\w Istenmd \y[20 msodperc]^n^n");
	add(menuBody, 2024, "\r9.\w Kvetkez^n^n");
	add(menuBody, 2024, "\r0.\w Kilps^n");
 
	// Show menu to player
	show_menu(id, (1<<0 | 1<<1 | 1<<2 | 1<<3 | 1<<4 | 1<<5 | 1<<6 | 1<<7 | 1<<8 | 1<<9), menuBody, -1, "aaaxMenu1");
}
 
// Menu2 format
public command_Buy2(id)
{
	// Make menu (2024 max characters)
	new menuBody[2025];
	add(menuBody, 2024, "\ySurf Pontrendszer 2^n^n");
	add(menuBody, 2024, "\r1.\w let \y[+1000 HP]^n");
	add(menuBody, 2024, "\r2.\w Korltlan Clip \y[vgtelen lszer]^n");
	add(menuBody, 2024, "\r3.\w Jail nyits^n");
	add(menuBody, 2024, "\r4.\w ShotGun \y[M3 & XM1014]^n^n");
	add(menuBody, 2024, "\r9.\w Vissza^n^n");
	add(menuBody, 2024, "\r0.\w Kilps^n");
 
	// Show menu to player
	show_menu(id, (1<<0 | 1<<1 | 1<<2 | 1<<3 | 1<<4 | 1<<5 | 1<<6 | 1<<7 | 1<<8 | 1<<9), menuBody, -1, "bbbxMenu2");
}
 
// Buy menu
public BuyMenu(id, key)
{
	// Get the user name
	new name[32];
	get_user_name(id, name, 31);
 
	// Switch the player key
	switch(key)
	{
		// Health +255
		case 0:
		{
			// Has enough points?
			if (surf_get_user_points(id) >= get_pcvar_num(cvar_health1_cost))
			{
				fm_set_user_health(id, get_user_health(id) + 255);
				surf_del_user_points(id, get_pcvar_num(cvar_health1_cost));
				write_colored(0, "%s %L", xPrefix, LANG_PLAYER, "SURF_CHAT_INFO_X", name, "+255 HP!");
			}
			// Not has enough points, has enough moneys?
			else if (cs_get_user_money(id) >= get_pcvar_num(cvar_health1_cost2))
			{
				fm_set_user_health(id, get_user_health(id) + 255);
				cs_set_user_money(id, cs_get_user_money(id) - get_pcvar_num(cvar_health1_cost2));
				write_colored(0, "%s %L", xPrefix, LANG_PLAYER, "SURF_CHAT_INFO_X", name, "+255 HP!");
			}
			// Not has points, not has moneys... I'm sorry...
			else
			{
				write_colored(id, "%s %L", xPrefix, LANG_PLAYER, "SURF_NO_ENOUGH_MONEY", get_pcvar_num(cvar_health1_cost), get_pcvar_num(cvar_health1_cost2));
			}
		}
		// 300 Speed
		case 1:
		{
			// Has enough points?
			if (surf_get_user_points(id) >= get_pcvar_num(cvar_speed_cost))
			{
				b_Speed[id] = true;
				surf_del_user_points(id, get_pcvar_num(cvar_speed_cost));
				write_colored(0, "%s %L", xPrefix, LANG_PLAYER, "SURF_CHAT_INFO_X", name, "300 Sebessg!");
			}
			// Not has enough points, has enough moneys?
			else if (cs_get_user_money(id) >= get_pcvar_num(cvar_speed_cost2))
			{
				b_Speed[id] = true;
				cs_set_user_money(id, cs_get_user_money(id) - get_pcvar_num(cvar_speed_cost2));
				write_colored(0, "%s %L", xPrefix, LANG_PLAYER, "SURF_CHAT_INFO_X", name, "300 Sebessg!");
			}
			// Not has points, not has moneys... I'm sorry...
			else
			{
				write_colored(id, "%s %L", xPrefix, LANG_PLAYER, "SURF_NO_ENOUGH_MONEY", get_pcvar_num(cvar_speed_cost), get_pcvar_num(cvar_speed_cost2));
			}
		}
		// 500 Gravity
		case 2:
		{
			// Has enough points?
			if (surf_get_user_points(id) >= get_pcvar_num(cvar_gravity_cost))
			{
				b_Gravity[id] = true;
				fm_set_user_gravity(id, 0.7);
				surf_del_user_points(id, get_pcvar_num(cvar_gravity_cost));
				write_colored(0, "%s %L", xPrefix, LANG_PLAYER, "SURF_CHAT_INFO_X", name, "500 Gravitci!");
			}
			// Not has enough points, has enough moneys?
			else if (cs_get_user_money(id) >= get_pcvar_num(cvar_gravity_cost2))
			{
				b_Gravity[id] = true;
				fm_set_user_gravity(id, 0.7);
				cs_set_user_money(id, cs_get_user_money(id) - get_pcvar_num(cvar_gravity_cost2));
				write_colored(0, "%s %L", xPrefix, LANG_PLAYER, "SURF_CHAT_INFO_X", name, "500 Gravitci!");
			}
			// Not has points, not has moneys... I'm sorry...
			else
			{
				write_colored(id, "%s %L", xPrefix, LANG_PLAYER, "SURF_NO_ENOUGH_MONEY", get_pcvar_num(cvar_gravity_cost), get_pcvar_num(cvar_gravity_cost2));
			}
		}
		// 100% Invisibility
		case 3:
		{
			// Has enough points?
			if (surf_get_user_points(id) >= get_pcvar_num(cvar_invisibility_cost))
			{
				b_Invisibility[id] = true;
				fm_set_user_rendering(id, kRenderFxHologram, 0, 0, 0, kRenderTransAlpha, 250);
				surf_del_user_points(id, get_pcvar_num(cvar_invisibility_cost));
				write_colored(0, "%s %L", xPrefix, LANG_PLAYER, "SURF_CHAT_INFO_X", name, "100% Lthatatlansg!");
			}
			// Not has enough points, has enough moneys?
			else if (cs_get_user_money(id) >= get_pcvar_num(cvar_invisibility_cost2))
			{
				b_Invisibility[id] = true;
				fm_set_user_rendering(id, kRenderFxHologram, 0, 0, 0, kRenderTransAlpha, 250);
				cs_set_user_money(id, cs_get_user_money(id) - get_pcvar_num(cvar_invisibility_cost2));
				write_colored(0, "%s %L", xPrefix, LANG_PLAYER, "SURF_CHAT_INFO_X", name, "100% Lthatatlansg!");
			}
			// Not has points, not has moneys... I'm sorry...
			else
			{
				write_colored(id, "%s %L", xPrefix, LANG_PLAYER, "SURF_NO_ENOUGH_MONEY", get_pcvar_num(cvar_invisibility_cost), get_pcvar_num(cvar_invisibility_cost2));
			}
		}
		// 12500$ Moneys
		case 4:
		{
			// Has enough points?
			if (surf_get_user_points(id) >= get_pcvar_num(cvar_moneys_cost))
			{
				cs_set_user_money(id, cs_get_user_money(id) + 12500);
				surf_del_user_points(id, get_pcvar_num(cvar_moneys_cost));
				write_colored(0, "%s %L", xPrefix, LANG_PLAYER, "SURF_CHAT_INFO_X", name, "12500$ Pnz!");
			}
			// Not has enough points, has enough moneys?
			else if (cs_get_user_money(id) >= get_pcvar_num(cvar_moneys_cost2))
			{
				cs_set_user_money(id, cs_get_user_money(id) - get_pcvar_num(cvar_moneys_cost2));
				cs_set_user_money(id, cs_get_user_money(id) + 12500);
				write_colored(0, "%s %L", xPrefix, LANG_PLAYER, "SURF_CHAT_INFO_X", name, "12500$ Pnz!");
			}
			// Not has points, not has moneys... I'm sorry...
			else
			{
				write_colored(id, "%s %L", xPrefix, LANG_PLAYER, "SURF_NO_ENOUGH_MONEY", get_pcvar_num(cvar_moneys_cost), get_pcvar_num(cvar_moneys_cost2));
			}
		}
		// 2x Damage
		case 5:
		{
			// Has enough points?
			if (surf_get_user_points(id) >= get_pcvar_num(cvar_damage_cost))
			{
				b_Damage[id] = true;
				surf_del_user_points(id, get_pcvar_num(cvar_damage_cost));
				write_colored(0, "%s %L", xPrefix, LANG_PLAYER, "SURF_CHAT_INFO_X", name, "2x Sebzs!");
			}
			// Not has enough points, has enough moneys?
			else if (cs_get_user_money(id) >= get_pcvar_num(cvar_damage_cost2))
			{
				b_Damage[id] = true;
				cs_set_user_money(id, cs_get_user_money(id) - get_pcvar_num(cvar_damage_cost2));
				write_colored(0, "%s %L", xPrefix, LANG_PLAYER, "SURF_CHAT_INFO_X", name, "2x Sebzs!");
			}
			// Not has points, not has moneys... I'm sorry...
			else
			{
				write_colored(id, "%s %L", xPrefix, LANG_PLAYER, "SURF_NO_ENOUGH_MONEY", get_pcvar_num(cvar_damage_cost), get_pcvar_num(cvar_damage_cost2));
			}
		}
		// Noclip 20 seconds
		case 6:
		{
			// Has enough points?
			if (surf_get_user_points(id) >= get_pcvar_num(cvar_noclip_cost))
			{
				b_Noclip[id] = true;
				g_NoclipCount[id] = 19;
				fm_set_user_noclip(id, 1);
				surf_del_user_points(id, get_pcvar_num(cvar_noclip_cost));
				set_task(20.0, "task_RemoveNoclip", id);
				set_task(1.0, "task_NoclipCountDown", id, _, _, "a", 19);
				write_colored(0, "%s %L", xPrefix, LANG_PLAYER, "SURF_CHAT_INFO_X", name, "No clip!");
			}
			// Not has enough points, has enough moneys?
			else if (cs_get_user_money(id) >= get_pcvar_num(cvar_noclip_cost2))
			{
				b_Noclip[id] = true;
				g_NoclipCount[id] = 19;
				fm_set_user_noclip(id, 1);
				cs_set_user_money(id, cs_get_user_money(id) - get_pcvar_num(cvar_noclip_cost2));
				set_task(20.0, "task_RemoveNoclip", id);
				set_task(1.0, "task_NoclipCountDown", id, _, _, "a", 19);
				write_colored(0, "%s %L", xPrefix, LANG_PLAYER, "SURF_CHAT_INFO_X", name, "No clip!");
			}
			// Not has points, not has moneys... I'm sorry...
			else
			{
				write_colored(id, "%s %L", xPrefix, LANG_PLAYER, "SURF_NO_ENOUGH_MONEY", get_pcvar_num(cvar_noclip_cost), get_pcvar_num(cvar_noclip_cost2));
			}
		}
		// Godmode 20 seconds
		case 7:
		{
			// Has enough points?
			if (surf_get_user_points(id) >= get_pcvar_num(cvar_godmode_cost))
			{
				b_Godmode[id] = true;
				g_GodmodeCount[id] = 19;
				fm_set_user_godmode(id, 1);
				surf_del_user_points(id, get_pcvar_num(cvar_godmode_cost));
				set_task(20.0, "task_RemoveGodmode", id);
				set_task(1.0, "task_GodmodeCountDown", id, _, _, "a", 19);
				write_colored(0, "%s %L", xPrefix, LANG_PLAYER, "SURF_CHAT_INFO_X", name, "Istemd!");
			}
			// Not has enough points, has enough moneys?
			else if (cs_get_user_money(id) >= get_pcvar_num(cvar_godmode_cost2))
			{
				b_Godmode[id] = true;
				g_GodmodeCount[id] = 19;
				fm_set_user_godmode(id, 1);
				cs_set_user_money(id, cs_get_user_money(id) - get_pcvar_num(cvar_godmode_cost2));
				set_task(20.0, "task_RemoveGodmode", id);
				set_task(1.0, "task_GodmodeCountDown", id, _, _, "a", 19);
				write_colored(0, "%s %L", xPrefix, LANG_PLAYER, "SURF_CHAT_INFO_X", name, "Istenmd!");
			}
			// Not has points, not has moneys... I'm sorry...
			else
			{
				write_colored(id, "%s %L", xPrefix, LANG_PLAYER, "SURF_NO_ENOUGH_MONEY", get_pcvar_num(cvar_godmode_cost), get_pcvar_num(cvar_godmode_cost2));
			}
		}
		case 8:
		{
			command_Buy2(id);
		}
		default:
		{
			return PLUGIN_CONTINUE;
		}
	}
	return PLUGIN_CONTINUE;
}
 
// Buy menu2
public BuyMenu2(id, key)
{
	// Get the user name
	new name[32];
	get_user_name(id, name, 31);
 
	// Switch the player key
	switch(key)
	{
		// Health +1000
		case 0:
		{
			// Has enough points?
			if (surf_get_user_points(id) >= get_pcvar_num(cvar_health2_cost))
			{
				fm_set_user_health(id, get_user_health(id) + 1000);
				surf_del_user_points(id, get_pcvar_num(cvar_health2_cost));
				write_colored(0, "%s %L", xPrefix, LANG_PLAYER, "SURF_CHAT_INFO_X", name, "+1000 HP!");
			}
			// Not has enough points, has enough moneys?
			else if (cs_get_user_money(id) >= get_pcvar_num(cvar_health2_cost2))
			{
				fm_set_user_health(id, get_user_health(id) + 1000);
				cs_set_user_money(id, cs_get_user_money(id) - get_pcvar_num(cvar_health2_cost2));
				write_colored(0, "%s %L", xPrefix, LANG_PLAYER, "SURF_CHAT_INFO_X", name, "+1000 HP!");
			}
			// Not has points, not has moneys... I'm sorry...
			else
			{
				write_colored(id, "%s %L", xPrefix, LANG_PLAYER, "SURF_NO_ENOUGH_MONEY", get_pcvar_num(cvar_health2_cost), get_pcvar_num(cvar_health2_cost2));
			}
		}
		// Unlimited Clip
		case 1:
		{
			// Has enough points?
			if (surf_get_user_points(id) >= get_pcvar_num(cvar_unlimitedclip_cost))
			{
				b_Unlimitedclip[id] = true;
				surf_del_user_points(id, get_pcvar_num(cvar_unlimitedclip_cost));
				write_colored(0, "%s %L", xPrefix, LANG_PLAYER, "SURF_CHAT_INFO_X", name, "Vgtelen Clip!");
			}
			// Not has enough points, has enough moneys?
			else if (cs_get_user_money(id) >= get_pcvar_num(cvar_unlimitedclip_cost2))
			{
				b_Unlimitedclip[id] = true;
				cs_set_user_money(id, cs_get_user_money(id) - get_pcvar_num(cvar_unlimitedclip_cost2));
				write_colored(0, "%s %L", xPrefix, LANG_PLAYER, "SURF_CHAT_INFO_X", name, "Vgtelen Clip!");
			}
			// Not has points, not has moneys... I'm sorry...
			else
			{
				write_colored(id, "%s %L", xPrefix, LANG_PLAYER, "SURF_NO_ENOUGH_MONEY", get_pcvar_num(cvar_unlimitedclip_cost), get_pcvar_num(cvar_unlimitedclip_cost2));
			}
		}
		// Jail open
		case 2:
		{
			// Has enough points?
			if (surf_get_user_points(id) >= get_pcvar_num(cvar_jail_cost))
			{
				open_jail(id);
				surf_del_user_points(id, get_pcvar_num(cvar_jail_cost));
			}
			// Not has enough points, has enough moneys?
			else if (cs_get_user_money(id) >= get_pcvar_num(cvar_jail_cost2))
			{
				open_jail(id);
				cs_set_user_money(id, cs_get_user_money(id) - get_pcvar_num(cvar_jail_cost2));
			}
			// Not has points, not has moneys... I'm sorry...
			else
			{
				write_colored(id, "%s %L", xPrefix, LANG_PLAYER, "SURF_NO_ENOUGH_MONEY", get_pcvar_num(cvar_jail_cost), get_pcvar_num(cvar_jail_cost2));
			}
		}
		// ShotGuns
		case 3:
		{
			// Has enough points?
			if (surf_get_user_points(id) >= get_pcvar_num(cvar_shotguns_cost))
			{
				b_Shotguns[id] = true;
				fm_give_item(id, "weapon_m3");
				fm_give_item(id, "weapon_xm1014");
				cs_set_user_bpammo(id, CSW_M3, 999);
				cs_set_user_bpammo(id, CSW_XM1014, 999);
				surf_del_user_points(id, get_pcvar_num(cvar_shotguns_cost));
			}
			// Not has enough points, has enough moneys?
			else if (cs_get_user_money(id) >= get_pcvar_num(cvar_shotguns_cost2))
			{
				b_Shotguns[id] = true;
				fm_give_item(id, "weapon_m3");
				fm_give_item(id, "weapon_xm1014");
				cs_set_user_bpammo(id, CSW_M3, 999);
				cs_set_user_bpammo(id, CSW_XM1014, 999);
				cs_set_user_money(id, cs_get_user_money(id) - get_pcvar_num(cvar_shotguns_cost2));
			}
			// Not has points, not has moneys... I'm sorry...
			else
			{
				write_colored(id, "%s %L", xPrefix, LANG_PLAYER, "SURF_NO_ENOUGH_MONEY", get_pcvar_num(cvar_shotguns_cost), get_pcvar_num(cvar_shotguns_cost2));
			}
		}
		case 8:
		{
			command_Buy(id);
		}
		default:
		{
			return PLUGIN_CONTINUE;
		}
	}
	return PLUGIN_CONTINUE;
}
 
// Current Weapon event
public event_CurWeapon(id)
{
	if (b_Speed[id])
	{
		fm_set_user_maxspeed(id, 350.0);
	}
}
 
// When client is spawned
public ham_PlayerSpawned_Post(id)
{
	b_Spawns[id]++;
	if (b_Speed[id])
	{
		b_Speed[id] = false;
	}
	if (b_Invisibility[id])
	{
		b_Invisibility[id] = false;
		fm_set_user_rendering(id, kRenderFxNone, 0, 0, 0, kRenderTransAlpha, 255);
	}
	if (b_Gravity[id])
	{
		b_Gravity[id] = false;
		fm_set_user_gravity(id, 1.0);
	}
	if (b_Damage[id])
	{
		b_Damage[id] = false;
	}
	if (b_Noclip[id])
	{
		b_Noclip[id] = false;
		fm_set_user_noclip(id, 0);
	}
	if (b_Godmode[id])
	{
		b_Godmode[id] = false;
		fm_set_user_godmode(id, 0);
	}
	if (b_Spawns[id] == 3)
	{
		command_Buy(id);
		write_colored(id, "%s %L", xPrefix, LANG_PLAYER, "SURF_BEGGIN_INFO");
		write_colored(id, "%s %L", xPrefix, LANG_PLAYER, "SURF_BEGGIN_INFO");
	}
	if (b_Unlimitedclip[id])
	{
		b_Unlimitedclip[id] = false;
	}
	if (g_GodmodeCount[id])
	{
		g_GodmodeCount[id] = 0;
	}
	if (g_NoclipCount[id])
	{
		g_NoclipCount[id] = 0;
	}
	if (b_Shotguns[id])
	{
		b_Shotguns[id] = false;
		fm_give_item(id, "weapon_m3");
		fm_give_item(id, "weapon_xm1014");
		cs_set_user_bpammo(id, CSW_M3, 999);
		cs_set_user_bpammo(id, CSW_XM1014, 999);
	}
}
 
// Damage multiplier
public ham_TakeDamage(victim, inflictor, attacker, Float:damage)
{
	if (victim == attacker || !is_user_connected(attacker))
	{
		return HAM_IGNORED;
	}
	if (b_Damage[attacker])
	{
		damage *= 2.0;
		SetHamParamFloat(4, damage);
	}
	return HAM_IGNORED;
}
 
// When client joining
public client_putinserver(id)
{
	set_task(25.0, "task_Announce", id);
}
 
// When client disconnect
public client_disconnect(id)
{
	if (b_Speed[id])
	{
		b_Speed[id] = false;
	}
	if (b_Invisibility[id])
	{
		b_Invisibility[id] = false;
	}
	if (b_Gravity[id])
	{
		b_Gravity[id] = false;
	}
	if (b_Damage[id])
	{
		b_Damage[id] = false;
	}
	if (b_Noclip[id])
	{
		b_Noclip[id] = false;
	}
	if (b_Godmode[id])
	{
		b_Godmode[id] = false;
	}
	if (b_Spawns[id])
	{
		b_Spawns[id] = 0;
	}
	if (b_Unlimitedclip[id])
	{
		b_Unlimitedclip[id] = false;
	}
	if (g_GodmodeCount[id])
	{
		g_GodmodeCount[id] = 0;
	}
	if (g_NoclipCount[id])
	{
		g_NoclipCount[id] = 0;
	}
	if (b_Shotguns[id])
	{
		b_Shotguns[id] = false;
	}
}
 
// Remove Noclip task
public task_RemoveNoclip(id)
{
	if (!is_user_connected(id))
	{
		return;
	}
	if (fm_get_user_noclip(id))
	{
		b_Noclip[id] = false;
		fm_set_user_noclip(id, 0);
		new Float:origin[3], hulltype;
		pev(id, pev_origin, origin);
		hulltype = (pev(id, pev_flags) & FL_DUCKING) ? HULL_HEAD : HULL_HUMAN;
		if (!hattrick_hull_vacant(id, origin, hulltype))
		{
			user_kill(id);
			write_colored(id, "%s %L", xPrefix, LANG_PLAYER, "SURF_NOCLIP_DIED");
		}
		if (is_user_alive(id))
		{
			write_colored(id, "%s %L", xPrefix, LANG_PLAYER, "SURF_NOCLIP_REMOVED");
		}
	}
}
 
// Remove Godmode task
public task_RemoveGodmode(id)
{
	if (!is_user_connected(id))
	{
		return;
	}
	if (fm_get_user_godmode(id))
	{
		b_Godmode[id] = false;
		fm_set_user_godmode(id, 0);
		write_colored(id, "%s %L", xPrefix, LANG_PLAYER, "SURF_GODMODE_REMOVED");
	}
}
 
// Announce the player
public task_Announce(id)
{
	if (is_user_connected(id))
	{
		write_colored(id, "%s %L", xPrefix, LANG_PLAYER, "SURF_WELCOME");
	}
}
 
// Countdown player noclip
public task_NoclipCountDown(id)
{
	if (!is_user_connected(id) || !is_user_alive(id))
	{
		return;
	}
	g_NoclipCount[id]--;
	set_hudmessage(0, 255, 0, 0.35, 0.8, _, _, 7.0);
	show_hudmessage(id, "%L", LANG_PLAYER, "SURF_YOU_HAVE", "noclip", g_NoclipCount[id]);
}
 
// Countdown player godmode
public task_GodmodeCountDown(id)
{
	if (!is_user_connected(id) || !is_user_alive(id))
	{
		return;
	}
	g_GodmodeCount[id]--;
	set_hudmessage(0, 255, 0, 0.35, 0.8, _, _, 7.0);
	show_hudmessage(id, "%L", LANG_PLAYER, "SURF_YOU_HAVE", "godmode", g_GodmodeCount[id]);
}
 
// Write colored function
public write_colored(const id, const string[], {Float, Sql, Resul,_}:...)
{
	new msg[191], players[32], count = 1;
	vformat(msg, 190, string, 3);
	replace_all(msg, 190, "!n", "^1");
	replace_all(msg, 190, "!t", "^3");
	replace_all(msg, 190, "!g", "^4");
	if (id) players[0] = id;
	else get_players(players, count, "ch");
	for (new i = 0; i < count; i++)
	{
		if (is_user_connected(players[i]))
		{
			message_begin(MSG_ONE_UNRELIABLE, get_user_msgid("SayText"), _, players[i]);
			write_byte(players[i]);
			write_string(msg);
			message_end();
		}
	}
}
 
// Is hull vacant stock (credits ==> VEN)
stock bool:hattrick_hull_vacant(id, const Float:origin[3], hullType = HULL_HEAD, &hitent = 0)
{
	engfunc(EngFunc_TraceHull, origin, origin, 0, hullType, id, 0);
	hitent = get_tr2(0, TraceResult:TR_pHit);
	if (!get_tr2(0, TraceResult:TR_StartSolid) && !get_tr2(0, TraceResult:TR_AllSolid) && get_tr2(0, TraceResult:TR_InOpen))
	{
		return true;
	}
	return false;
}
 
// Unlimited clip stuff
public message_cur_weapon(msg_id, msg_dest, msg_entity)
{
	if (!b_Unlimitedclip[msg_entity])
	{
		return;
	}
	if (!is_user_alive(msg_entity) || get_msg_arg_int(1) != 1)
	{
		return;
	}
	static weapon, clip;
	weapon = get_msg_arg_int(2);
	clip = get_msg_arg_int(3);
	if (MAXCLIP[weapon] > 2)
	{
		set_msg_arg_int(3, get_msg_argtype(3), MAXCLIP[weapon]);
		if (clip < 2)
		{
			static wname[32], weapon_ent;
			get_weaponname(weapon, wname, 31);
			weapon_ent = fm_find_ent_by_owner(-1, wname, msg_entity);
			fm_set_weapon_ammo(weapon_ent, MAXCLIP[weapon]);
		}
	}
}
 
stock fm_set_weapon_ammo(entity, amount)
{
	set_pdata_int(entity, OFFSET_CLIPAMMO, amount, OFFSET_LINUX_WEAPONS);
}
 
// Open jail function
public open_jail(id)
{
	// Get the user name
	new name[32];
	get_user_name(id, name, 31);
 
	new ent, target[32], ent2;
	for (new i = 0; i < sizeof entlist; i++)
	{
		ent = 0;
		ent2 = 0;
		while((ent = engfunc(EngFunc_FindEntityByString, ent, "classname", entlist[i])))
		{
			if (pev_valid(ent))
			{
				pev(ent, pev_target, target, 31);
				while((ent2 = engfunc(EngFunc_FindEntityByString, ent2, "targetname", target)))
				{
					dllfunc(DLLFunc_Use, ent2, id);
					write_colored(0, "%s %L", xPrefix, LANG_PLAYER, "SURF_CHAT_INFO_X", name, "Jail Nyits!");
					return PLUGIN_HANDLED;
				}
			}
		}
	}
	write_colored(id, "%s %L", xPrefix, LANG_PLAYER, "SURF_CANT_FIND");
	return PLUGIN_HANDLED;
}