/*
	-----------------------------------------------

			[Licensing Info]
	
	Copyright (C) 2011  eXcalibur.007
	
	This program is free software: you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation, either version 3 of the License, or
	(at your option) any later version.
	
	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.
	
	You should have received a copy of the GNU General Public License
	along with this program.  If not, see <http://www.gnu.org/licenses/>.
	
	-----------------------------------------------
	
*/

#include <amxmodx>
#include <fakemeta>
#include <sqlx>
#include <zp50_core>
#include <zp50_class_zombie>
#include <zp50_colorchat>

new const VERSION[] = "2.1.2"

new const RANKS[][]=
{
	"Private", // 0
	"Private 1st Class", // 1
	"Corporal", // 2
	"Sergeant", // 3
	"Staff Sergeant", // 4
	"Sergeant 1st Class", // 5
	"Master Sergeant", // 6
	"Sergeant Major", // 7
	"2nd Lieutenant", // 8
	"1st Lieutenant", // 9
	"Captain", // 10
	"Major", // 11
	"Lieutenant Colonel", // 12
	"Colonel", // 13
	"Brigadier General", // 14
	"Major General", // 15
	"Lieutenant General", // 16
	"General", // 17
	"General of the Army" // 18
}

new const EXP[] =
{
	0, // 0
	50, // 1
	100, // 2
	200, // 3
	400, // 4
	800, // 5
	1600, // 6
	3200, // 7
	6400, // 8
	12800, // 9
	25600, // 10
	51200, // 11
	102400, // 12
	204800, // 13
	409600, // 14
	819200, // 15
	1638400, // 16
	3276800, // 17
	6553600 // 18
}

new SQL_HOST[] = "127.0.0.1"
new SQL_USER[] = "root"
new SQL_PASS[] = "yoursqlpasswordhere"
new SQL_DB[] = "amx"

new Handle:g_SqlTuple
new g_Error[512]

#define ADMIN_FLAG	ADMIN_BAN

new g_bitConnectedPlayers, g_bitAlivePlayers, g_bitAuthorizedPlayers

#define MarkUserConnected(%0)   g_bitConnectedPlayers |= (1 << (%0 & 31))
#define ClearUserConnected(%0)  g_bitConnectedPlayers &= ~(1 << (%0 & 31))
#define IsUserConnected(%0)	g_bitConnectedPlayers & (1 << (%0 & 31))

#define MarkUserAlive(%0)   	g_bitAlivePlayers |= (1 << (%0 & 31))
#define ClearUserAlive(%0)  	g_bitAlivePlayers &= ~(1 << (%0 & 31))
#define IsUserAlive(%0)		g_bitAlivePlayers & (1 << (%0 & 31))

#define MarkUserAllow(%0)   	g_bitAuthorizedPlayers |= (1 << (%0 & 31))
#define ClearUserAllow(%0)  	g_bitAuthorizedPlayers &= ~(1 << (%0 & 31))
#define IsUserAllow(%0)		g_bitAuthorizedPlayers & (1 << (%0 & 31))

#define IsPlayer(%0)		(1 <= %0 <= g_iMaxPlayers)

new cvar_xp, cvar_hsxp, cvar_assistxp, cvar_divide, cvar_icon, cvar_icon_time
new cached_xp, cached_hsxp, cached_assistxp, cached_divide, cached_icon, Float:cached_icon_time

new g_msgSayText, g_iMaxPlayers

new iXP[33], iRank[33], iMaxHealth[33]
new iDamage[33][33], iKilledZombie[33][33], iSteamID[33][32]
new iSprite[20]

public plugin_precache()
{
	new szFile[35]

	for(new i = 0; i < sizeof(RANKS); i++)
	{
		formatex(szFile, charsmax(szFile), "sprites/zombie_plague/ranks/%i.spr", i)
		
		iSprite[i] = precache_model(szFile)
	}
}

// Done by eXcalibur.007

public plugin_init()
{
	register_plugin("[ZP] Addon: Military Ranks", VERSION, "eXcalibur.007")
	
	cvar_xp = register_cvar("zp_rank_xp", "30")
	cvar_hsxp = register_cvar("zp_rank_hsxp", "60")
	cvar_assistxp = register_cvar("zp_rank_assistxp", "15")
	cvar_divide = register_cvar("zp_rank_assisthpdivide", "5")
	cvar_icon = register_cvar("zp_rank_icon", "1")
	cvar_icon_time = register_cvar("zp_rank_icon_time", "1.5")
	
	register_clcmd("say", "hook_say")
	register_clcmd("say_team", "hook_say_team")
	register_clcmd("say /showrank", "show_stats")
	register_clcmd("say_team /showrank", "show_stats")
	
	register_event("HLTV", "event_new_round", "a", "1=0", "2=0")
	register_event("Damage", "event_Damage", "be", "2!0", "3=0", "4!0")
	register_event("DeathMsg", "event_DeathMsg", "a", "1>0")
	
	register_event("StatusValue", "event_StatusValue", "be", "1=2", "2!0")
	
	g_msgSayText = get_user_msgid("SayText")
	g_iMaxPlayers = get_maxplayers()
	
	register_message(g_msgSayText, "message_SayText")
	
	set_task(1.0, "MySQL_Init")
}

public MySQL_Init()
{
	g_SqlTuple = SQL_MakeDbTuple(SQL_HOST, SQL_USER, SQL_PASS, SQL_DB)
	
	new ErrorCode, Handle:SqlConnection = SQL_Connect(g_SqlTuple, ErrorCode, g_Error, charsmax(g_Error))
	
	if(SqlConnection == Empty_Handle)
		set_fail_state(g_Error)
       
	new Handle:Queries
	
	Queries = SQL_PrepareQuery(SqlConnection, "CREATE TABLE IF NOT EXISTS militaryrank (steamid varchar(32),rank INT(2),exp INT(11))")
	
	if(!SQL_Execute(Queries))
	{
		SQL_QueryError(Queries, g_Error, charsmax(g_Error))
		set_fail_state(g_Error)
	}
	
	SQL_FreeHandle(Queries)
	SQL_FreeHandle(SqlConnection)   
}

public MySQL_CoreFunction(FailState, Handle:Query, Error[], Errcode, Data[], DataSize)
{
	if(FailState == TQUERY_CONNECT_FAILED)
	{
		log_amx("Load - Could not connect to SQL database.  [%d] %s", Errcode, Error)
	}
	else if(FailState == TQUERY_QUERY_FAILED)
	{
		log_amx("Load Query failed. [%d] %s", Errcode, Error)
	}
	
	new id
	id = Data[0]
	
	if(SQL_NumResults(Query) < 1) 
	{
		if(equal(iSteamID[id], "ID_PENDING"))
			return PLUGIN_HANDLED
		
		new szTemp[512]
		
		format(szTemp,charsmax(szTemp), "INSERT INTO `militaryrank` ( `steamid` , `rank` , `exp`)VALUES ('%s','0','0');", iSteamID[id])
		SQL_ThreadQuery(g_SqlTuple, "IgnoreHandle", szTemp)
	} 
	else 
	{
		iRank[id] = SQL_ReadResult(Query, 1)
		iXP[id] = SQL_ReadResult(Query, 2)
	}
	
	return PLUGIN_HANDLED
}

public IgnoreHandle(FailState, Handle:Query, Error[], Errcode, Data[], DataSize)
{
	SQL_FreeHandle(Query)
	
	return PLUGIN_HANDLED
}

public Load_MySQL(id)
{
	new szTemp[512]
	
	new Data[1]
	Data[0] = id
	
	format(szTemp, charsmax(szTemp), "SELECT * FROM `militaryrank` WHERE (`militaryrank`.`steamid` = '%s')", iSteamID[id])
	SQL_ThreadQuery(g_SqlTuple, "MySQL_CoreFunction", szTemp, Data, 1)
}

public Save_MySQL(id)
{
	new szTemp1[512], szTemp2[512]
	
	format(szTemp1, charsmax(szTemp1), "UPDATE `militaryrank` SET `rank` = '%i' WHERE `militaryrank`.`steamid` = '%s';", iRank[id], iSteamID[id])
	format(szTemp2, charsmax(szTemp2), "UPDATE `militaryrank` SET `exp` = '%i' WHERE `militaryrank`.`steamid` = '%s';", iXP[id], iSteamID[id])
	
	SQL_ThreadQuery(g_SqlTuple, "IgnoreHandle", szTemp1)
	SQL_ThreadQuery(g_SqlTuple, "IgnoreHandle", szTemp2)
}

public plugin_end()
{
	new iPlayers[32], iNum
	get_players(iPlayers, iNum)
	
	new iPlayer
	for(new i = 0; i < iNum; i++)
	{
		iPlayer = iPlayers[i]
		
		Save_MySQL(iPlayer)
	}
	
	SQL_FreeHandle(g_SqlTuple)
}

public plugin_cfg()
{
	cached_xp = get_pcvar_num(cvar_xp)
	cached_hsxp = get_pcvar_num(cvar_hsxp)
	cached_assistxp = get_pcvar_num(cvar_assistxp)
	cached_divide = get_pcvar_num(cvar_divide)
	cached_icon = get_pcvar_num(cvar_icon)
	cached_icon_time = get_pcvar_float(cvar_icon_time)
}

public client_putinserver(id)
{
	MarkUserConnected(id)
	
	get_user_authid(id, iSteamID[id], 31)
	
	Load_MySQL(id)
}

public client_authorized(id)
{
	MarkUserAllow(id)
}

public client_disconnect(id)
{
	if(IsUserAllow(id))
		Save_MySQL(id)
	
	iRank[id] = 0
	iXP[id] = 0
	
	ClearUserConnected(id)
	ClearUserAlive(id)
	ClearUserAllow(id)
}

public hook_say(id)
{
	new szMessage[192], szName[32]
	
	read_args(szMessage, 191)
	remove_quotes(szMessage)
	get_user_name(id, szName, 31)
	
	if(equali(szMessage[0], " ") || equali(szMessage[0], "") || !is_valid_msg(szMessage))
		return PLUGIN_HANDLED_MAIN
		
	if(IsUserAlive(id))
		format(szMessage, 191, "^4[%s] ^3%s : ^1%s", RANKS[iRank[id]], szName, szMessage)
	else
		format(szMessage, 191, "^1*DEAD* ^4[%s] ^3%s : ^1%s", RANKS[iRank[id]], szName, szMessage)
	
	new iPlayers[32] 
	new iPlayerCount, i, player
	get_players(iPlayers, iPlayerCount, "ch") 
	
	for(i = 0; i < iPlayerCount; i++)
	{
		player = iPlayers[i]
		
		if(IsUserAlive(id) && IsUserAlive(player) || ~IsUserAlive(id) && ~IsUserAlive(player))
		{
			message_begin(MSG_ONE, g_msgSayText, {0, 0, 0}, player)
			write_byte(id)
			write_string(szMessage)
			message_end()
		}
	}
	
	return PLUGIN_CONTINUE
}

public hook_say_team(id)
{
	new szMessage[192], szName[32]
	
	read_args(szMessage, 191)
	remove_quotes(szMessage)
	get_user_name(id, szName, 31)
	
	if(equali(szMessage[0], " ") || equali(szMessage[0], "") || !is_valid_msg(szMessage))
		return PLUGIN_HANDLED_MAIN
	
	if(IsUserAlive(id))
		format(szMessage, 191, "^4[%s] ^3%s : ^1%s", RANKS[iRank[id]], szName, szMessage)
	else
		format(szMessage, 191, "^1*DEAD* ^4[%s] ^3%s : ^1%s", RANKS[iRank[id]], szName, szMessage)
	
	new teamid = get_user_team(id)
	
	new iPlayers[32] 
	new iPlayerCount, i, player
	get_players(iPlayers, iPlayerCount, "ch") 
	
	for(i = 0; i < iPlayerCount; i++)
	{
		player = iPlayers[i]
		
		new teami = get_user_team(player)
		
		if(IsUserAlive(id) && IsUserAlive(player) && teamid == teami || ~IsUserAlive(id) && ~IsUserAlive(player) && teamid == teami)
		{
			message_begin(MSG_ONE, g_msgSayText, {0, 0, 0}, player)
			write_byte(id)
			write_string(szMessage)
			message_end()
		}
	}
	
	return PLUGIN_CONTINUE
}

public show_stats(id)
{
	if(IsUserConnected(id))
	{
		zp_colored_print(id, "Rank:^x04 %s ^x01| EXP:^x04 %d ^x01| EXP szksges a kvetkez ranghoz:^x04 %d", RANKS[iRank[id]], iXP[id], (EXP[iRank[id] + 1] - iXP[id]))
	}
}

public event_new_round()
{
	cached_xp = get_pcvar_num(cvar_xp)
	cached_hsxp = get_pcvar_num(cvar_hsxp)
	cached_assistxp = get_pcvar_num(cvar_assistxp)
	cached_divide = get_pcvar_num(cvar_divide)
	cached_icon = get_pcvar_num(cvar_icon)
	cached_icon_time = get_pcvar_float(cvar_icon_time)
	
	new iPlayers[32] 
	new iPlayerCount, i, player
	get_players(iPlayers, iPlayerCount, "h") 
	
	for(i = 0; i < iPlayerCount; i++)
	{
		player = iPlayers[i]
		
		iDamage[player][player] = 0
	}
}

public event_Damage(iVictim)
{
	if(IsUserAlive(iVictim) && IsPlayer(iVictim) && zp_core_is_zombie(iVictim))
	{
		static iAttacker; iAttacker = get_user_attacker(iVictim)
		
		if(IsPlayer(iAttacker))
			iDamage[iAttacker][iVictim] += read_data(2)
	}
}

public event_DeathMsg()
{
	static iKiller; iKiller = read_data(1)
	static iVictim; iVictim = read_data(2)
	static iIsHeadshot; iIsHeadshot = read_data(3)
	
	ClearUserAlive(iVictim)
	
	if(iVictim == iKiller || zp_core_is_zombie(iKiller) || !zp_core_is_zombie(iVictim))
		return PLUGIN_CONTINUE
		
	if(~IsUserAllow(iKiller))
	{
		zp_colored_print(iKiller, "Nem fogsz kapni EXP-t addig, amg nem regisztrltl/jelentkeztl be.")
		return PLUGIN_CONTINUE
	}
	
	if(iIsHeadshot)
	{
				
		iKilledZombie[iKiller][iVictim] = true
		iXP[iKiller] += cached_hsxp
		
		zp_colored_print(iKiller, "Kaptl ^x04 %d EXP-t^x01 ,mert HeadShot-ba megltl egy zombit.", cached_hsxp)
	}
	else
	{
		iKilledZombie[iKiller][iVictim] = true
		iXP[iKiller] += cached_xp
		
		zp_colored_print(iKiller, "Kaptl ^x01 %d EXP-t^x01 ,mert megltl egy zombit.", cached_xp)
	}
		
	while((iXP[iKiller] >= EXP[iRank[iKiller] + 1] && iRank[iKiller] < 18))
	{
		iRank[iKiller] += 1
		
		zp_colored_print(iKiller, "Gratullunk, mostantl ez az j rangod:^x04 %s", RANKS[iRank[iKiller]])
	}
	
	new iPlayers[32] 
	new iPlayerCount, i, id
	get_players(iPlayers, iPlayerCount, "h") 
	
	for(i = 0; i < iPlayerCount; i++)
	{
		id = iPlayers[i]
		
		if(iDamage[id][iVictim] >= iMaxHealth[iVictim] / cached_divide)
		{
			if(!iKilledZombie[id][iVictim])
			{
				iXP[id] += cached_assistxp
				
				new szName[32]
				get_user_name(iKiller, szName, charsmax(szName))
				
				zp_colored_print(id, "Kaptl ^x04 %d EXP-t ,mert segtettl a zombi meglsben.^x04 %s %s", cached_assistxp, RANKS[iRank[iKiller]], szName)
				
				while((iXP[id] >= EXP[iRank[id] + 1] && iRank[id] < 18))
				{
					iRank[id] += 1
					
					zp_colored_print(i, "Gratullunk, mostantl ez az j rangod:^x04 %s", RANKS[iRank[id]])
				}
				
				iDamage[id][iVictim] = 0
			}
			else
			{
				iKilledZombie[id][iVictim] = false
			}
		}
			
	}
	
	return PLUGIN_CONTINUE
}

public event_StatusValue(id)
{
	if(!cached_icon)
		return
		
	new pid = read_data(2)
	new pidrank = iRank[pid]
	
	if(!pev_valid(pid) || ~IsUserAlive(pid) || zp_core_is_zombie(pid))
		return
		
	new flTime = floatround(cached_icon_time * 10)
	
	if(flTime > 0)
		Create_TE_PLAYERATTACHMENT(id, pid, 55, iSprite[pidrank], flTime)
}

public zp_fw_core_spawn_post(id)
{
	if(is_user_alive(id))
		MarkUserAlive(id)
}

public message_SayText(id)
{
	return PLUGIN_HANDLED
}

public zp_fw_core_infect_post(id)
{
	iMaxHealth[id] = zp_class_zombie_get_max_health(id, zp_class_zombie_get_current(id))
}

bool:is_valid_msg(const szMessage[])
{
	if(szMessage[0] == '@' || szMessage[0] == '/' || szMessage[0] == '!' || !strlen(szMessage))
		return false
		
	return true
}

stock Create_TE_PLAYERATTACHMENT(id, entity, vOffset, iSprite, life)
{
	message_begin(MSG_ONE_UNRELIABLE, SVC_TEMPENTITY, _, id)
	write_byte(TE_PLAYERATTACHMENT)
	write_byte(entity)
	write_coord(vOffset)
	write_short(iSprite)
	write_short(life)
	message_end()
}
